﻿using System;
using System.Linq;
using NVCC.Models;
using NVCC.WebUI.Infrastructure;
using NVCC.WebUI.Models;
using System.Web.Mvc;

namespace NVCC.WebUI.Controllers
{
    [NvccAuthorize]
    public class ReportController : Controller
    {
        private readonly IPatientRepository _patientRepository;

        public ReportController(IPatientRepository patientRepository)
        {
            _patientRepository = patientRepository;
        }

        // GET: Report
        public ActionResult Index()
        {
            return View();
        }
        [HttpPost]
        public JsonResult LogData()
        {
            return Json(_patientRepository.GetLogs());
        }
        [HttpPost]
        public JsonResult UsageData([Bind(Include = "timeGroup, statistic, sta3n, userID")] UsageReportParametersViewModel usageReportParametersViewModel)
        {
            return new JsonResult
            {
                Data = _patientRepository.UsageData(
                    usageReportParametersViewModel.timeGroup,
                    usageReportParametersViewModel.statistic,
                    string.Join(",", usageReportParametersViewModel.sta3n),
                    string.Join(",", usageReportParametersViewModel.userID)),
                MaxJsonLength = Int32.MaxValue
            };
        }

        public ActionResult Usage()
        {
            ViewBag.stations = _patientRepository.GetUsageParametersSta3n();
            ViewBag.users = _patientRepository.GetUsageParametersUser();
            return View(new UsageReportParametersViewModel());
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Usage([Bind(Include = "timeGroup, statistic, sta3n, userID")] UsageReportParametersViewModel _usageReportParametersViewModel)
        {
            ViewBag.stations = _patientRepository.GetUsageParametersSta3n();
            ViewBag.users = _patientRepository.GetUsageParametersUser();
            return View(_usageReportParametersViewModel);
        }
        [HttpPost]
        public JsonResult CurrentUsageData([Bind(Include = "timeframe")] CurrentUsageParametersViewModel currentUsageParametersViewModel)
        {
            return Json(_patientRepository.GetCurrentUsage(currentUsageParametersViewModel.timeframe));
        }
        public ActionResult CurrentUsage()
        {
            return View(new CurrentUsageParametersViewModel());
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult CurrentUsage([Bind(Include = "timeframe")] CurrentUsageParametersViewModel currentUsageParametersViewModel)
        {
            return View(currentUsageParametersViewModel);
        }
        public ActionResult ActiveUsers()
        {
            ActiveUsersViewModel activeUsersViewModel = new ActiveUsersViewModel();
            activeUsersViewModel.activeUserCountList = _patientRepository.GetActiveUserCount();
            activeUsersViewModel.userCounts = _patientRepository.GetUserCounts().First();
            return View(activeUsersViewModel);
        }
        public ActionResult Counts()
        {
            return View(_patientRepository.GetUniqueVeterans());
        }
    }
}