﻿using System;
using NUnit.Framework;
using NVCC.Models;
using System.Linq;
using System.Collections.Generic;
using System.Threading.Tasks;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using NVCC.WebUI.Models;
using Moq;
using NVCC.WebUI.Infrastructure;
using Assert = NUnit.Framework.Assert;

namespace NVCC.WebUI.Tests
{
    [TestFixture]
    public class PatientModelListFactoryTests
    {
        Mock<IPatientRepository> _patientRepoMock;
        Mock<IPatientProfileService> _patientServiceMock;
        [OneTimeSetUp]
        public void TestSetup()
        {
            _patientRepoMock = new Mock<IPatientRepository>();
            _patientServiceMock = new Mock<IPatientProfileService>();
            _patientServiceMock.Setup(m => m.GetPatientProfile(It.IsAny<int>()))
                  .Returns(FakeDataManager.GetPatientProfile());
        }
         [Test]
         //[ExpectedException(typeof(ArgumentNullException))]
        public async Task CreateModels_NoPatientSid_Throws()
        {
            PatientModelListFactory sut = new PatientModelListFactory(_patientServiceMock.Object);
            Assert.That(async () => await sut.CreateModels(0), Throws.TypeOf<ArgumentNullException>());

             //await sut.CreateModels(0);
        }
         [Test]
         public async Task CreateModels_ValidPatientSid_CreatesListOfFourModelItems()
         {
             var sut = new PatientModelListFactory(_patientServiceMock.Object);
             await sut.CreateModels(1);
             Assert.IsNotNull(sut.Items);
             Assert.AreEqual(8, sut.Items.Count());
         }
    }
}
