﻿using System.Collections.Generic;
using NUnit.Framework;
using NVCC.Models;
using NVCC.WebUI.Models;

namespace NVCC.WebUI.Tests
{
    [TestFixture]
    public class AuthorizationViewModelTests
    {
        private static IList<Authorization> authList;

        [SetUp]
        public void SetUp()
        {
            authList = new List<Authorization>
                {
                    new Authorization
                    {
                        AuthorizationId = "0",
                        AuthorizationTitle = "VHA CHOICE Approval",
                        AuthorizationText =  "LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038 STANDARD TITLE: NONVA NOTE DATE OF NOTE: OCT 16, 2015@10:00 ENTRY DATE: OCT 16, 2015@10:00:50 AUTHOR: DURKEE-MURPHY,CYNTH EXP COSIGNER: URGENCY: STATUS: COMPLETED Department of Veterans Affairs: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-0386 Please select urgency: Routine Clinically Indicated Date: Sep 3,2015 Description of Specialty: SCREENING MAMMO Eligibility Verification: As the authorized VA representative, I hereby confirm that the Veteran is eligible for Choice services by checking basic eligibility in the Veterans Choice Viewer application. Eligibility was verified on: Oct 16,2015 Non-VA Care Program Manager or equivalent: Name: CYNTHIA DURKEE-MURPHY Title: Authorization Clerk Veteran Information: Name: KAREN ANN THOMAS DOB: APR 27,1944 SSN: 543-54-0934 Service-Connected(SC) and/or Special Authority(SA): DS - Disabilities Eligibility: NSC, VA PENSION VERIFIED No REPORT ALL QUESTIONS RELATED TO THIS APPROVAL TO THE ISSUING VA OFFICE: VA POC Name: Purchased Care Division Telephone #: 360-759-1674 From Station #: 648 Facility Name: VA Portland Healthcare System Street Address: VA Portland Healthcare System City: Portland State: OR Zip: 97239 Fax: 360-905-1731 In accordance with section 101 of the Veterans Access, Choice, and Accountability Act of 2014 (the Act) (Public Law 113-146, 128 Stat. 1754), as amended by the Department of Veterans Affairs (VA), the Expiring Authorities Act of 2014 (Public Law 113-175, 128 Stat. 1902), the Consolidated and Further Continuing Appropriations Act of 2015 (Public Law 113 -235, 128 Stat. 2568), and 38 CFR ?? 17.1500-1540, VA will pay for non-VA hospital care and medical services that are authorized by VA for Veterans who are determined by VA to meet the Veterans Choice Program eligibility criteria set forth by section 101 of the Act and 38 CFR ? 17.1510 and any other eligibility standards that may apply to particular services (such as health care for newborns of Veterans under 38 CFR ? 17.38(a)(xiv) and dental benefits under ?? 17.160-17.169). /es/ CYNTHIA DURKEE-MURPHY Purchased Care Voucher Examiner Signed: 10/16/2015 10:03"
                    },
                     new Authorization
                    {
                        AuthorizationId = "1",
                        AuthorizationTitle = "VHA CHOICE Approval",
                        AuthorizationText= "LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038 STANDARD TITLE: NONVA NOTE DATE OF NOTE: OCT 26, 2015@10:44 ENTRY DATE: OCT 26, 2015@10:44:48 AUTHOR: ONDRAK,AHNESTY EXP COSIGNER: URGENCY: STATUS: COMPLETED Department of Veterans Affairs: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-0386 Please select urgency: Now Clinically Indicated Date: Sep 25,2015 Description of Specialty: Chiropractic Eligibility Verification: As the authorized VA representative, I hereby confirm that the Veteran is eligible for Choice services by checking basic eligibility in the Veterans Choice Viewer application. Eligibility was verified on: Oct 7,2015 Non-VA Care Program Manager or equivalent: Name: Ahnesty Ondrak Title: Authorization Clerk Veteran Information: Name: ERIC VICTOR FARM DOB: AUG 2,1965 SSN: 544-74-4757 Service-Connected(SC) and/or Special Authority(SA): DS - Disabilities Eligibility: SERVICE CONNECTED 50% to 100% VERIFIED Total S/C %: 60 TRAUMATIC BRAIN DISEASE 0% S/C MIGRAINE HEADACHES 50% S/C TINNITUS 10% S/C Yes REPORT ALL QUESTIONS RELATED TO THIS APPROVAL TO THE ISSUING VA OFFICE: VA POC Name: Purchased Care Division Telephone #: 360-759-1674 From Station #: 648 Facility Name: VA Portland Healthcare System Street Address: VA Portland Healthcare System City: Portland State: OR Zip: 97239 Fax: 360-905-1731 In accordance with section 101 of the Veterans Access, Choice, and Accountability Act of 2014 (the Act) (Public Law 113-146, 128 Stat. 1754), as amended by the Department of Veterans Affairs (VA), the Expiring Authorities Act of 2014 (Public Law 113-175, 128 Stat. 1902), the Consolidated and Further Continuing Appropriations Act of 2015 (Public Law 113 -235, 128 Stat. 2568), and 38 CFR ?? 17.1500-1540, VA will pay for non-VA hospital care and medical services that are authorized by VA for Veterans who are determined by VA to meet the Veterans Choice Program eligibility criteria set forth by section 101 of the Act and 38 CFR ? 17.1510 and any other eligibility standards that may apply to particular services (such as health care for newborns of Veterans under 38 CFR ? 17.38(a)(xiv) and dental benefits under ?? 17.160-17.169). /es/ AHNESTY ONDRAK Voucher Examiner Signed: 10/26/2015 10:45"
                    },
                     new Authorization
                    {
                        AuthorizationId = "2",
                        AuthorizationTitle = "VHA CHOICE Approval",
                        AuthorizationText = "LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038 STANDARD TITLE: NONVA NOTE DATE OF NOTE: OCT 12, 2015@10:37 ENTRY DATE: OCT 12, 2015@10:37:40 AUTHOR: VINCENT,CHRISTINA L EXP COSIGNER: URGENCY: STATUS: COMPLETED Department of Veterans Affairs: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-0386 Please select urgency: STAT Clinically Indicated Date: Nov 19,2015 Description of Specialty: Orthopedics Eligibility Verification: As the authorized VA representative, I hereby confirm that the Veteran is eligible for Choice services by checking basic eligibility in the Veterans Choice Viewer application. Eligibility was verified on: Oct 12,2015 Non-VA Care Program Manager or equivalent: Name: Christina Vincent, RN Title: Other - Veteran Information: Name: ERIC VICTOR FARM DOB: AUG 2,1965 SSN: 544-74-4757 Service-Connected(SC) and/or Special Authority(SA): DS - Disabilities Eligibility: SERVICE CONNECTED 50% to 100% VERIFIED Total S/C %: 60 TINNITUS 10% S/C TRAUMATIC BRAIN DISEASE 0% S/C MIGRAINE HEADACHES 50% S/C No REPORT ALL QUESTIONS RELATED TO THIS APPROVAL TO THE ISSUING VA OFFICE: VA POC Name: Purchased Care Division Telephone #: 360-759-1674 From Station #: 648 Facility Name: VA Portland Healthcare System Street Address: VA Portland Healthcare System City: Portland State: OR Zip: 97239 Fax: 360-905-1731 In accordance with section 101 of the Veterans Access, Choice, and Accountability Act of 2014 (the Act) (Public Law 113-146, 128 Stat. 1754), as amended by the Department of Veterans Affairs (VA), the Expiring Authorities Act of 2014 (Public Law 113-175, 128 Stat. 1902), the Consolidated and Further Continuing Appropriations Act of 2015 (Public Law 113 -235, 128 Stat. 2568), and 38 CFR ?? 17.1500-1540, VA will pay for non-VA hospital care and medical services that are authorized by VA for Veterans who are determined by VA to meet the Veterans Choice Program eligibility criteria set forth by section 101 of the Act and 38 CFR ? 17.1510 and any other eligibility standards that may apply to particular services (such as health care for newborns of Veterans under 38 CFR ? 17.38(a)(xiv) and dental benefits under ?? 17.160-17.169). /es/ CHRISTINA L VINCENT Signed: 10/12/2015 10:38"
                    },
                    new Authorization
                    {
                        AuthorizationId = "3",
                        AuthorizationTitle = "VHA CHOICE Approval",
                        AuthorizationText = "LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038 STANDARD TITLE: NONVA NOTE DATE OF NOTE: DEC 11, 2015@15:50 ENTRY DATE: DEC 11, 2015@15:50:06 AUTHOR: STIVASON,JEFFERY G EXP COSIGNER: URGENCY: STATUS: COMPLETED TriWest Department of Veterans Affairs VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-0386 Please select urgency: Routine To facilitate Urgent Scheduling, please include an alternate point of contact's (different than the NVCC staff member listed below) name, telephone number, and relationship to the patient (spouse, social worker, triage nurse, etc.) in space provided. Clinically Indicated Date: Dec 10,2015 Description of Specific Services and Medical Specialist: ORTHOPEDICS ~ PAINFUL ELBOW EVAL/TREATMENT, POST-OP FOLLOW UP CARE, PHYSICAL THERAPY. Eligibility Verification: As the authorized VA representative, I hereby confirm that the Veteran is eligible for Choice services by checking basic eligibility in the Veterans Choice Viewer application. Eligibility was verified on: Dec 11,2015 Non-VA Care Program Manager or equivalent: Name: JEFF STIVASON Title: Authorization Clerk Veteran Information: Name: ERIC VICTOR FARM DOB: AUG 2,1965 SSN: 544-74-4757 Service-Connected(SC) and/or Special Authority(SA): Yes Local Health Care Contractor: TriWest Report all CRITICAL FINDINGS related to this authorization to the issuing office below. ALL other questions regarding this authorization should be directed to: 1-866-606-8198 REPORT ALL QUESTIONS RELATED TO THIS APPROVAL TO THE ISSUING VA OFFICE: VA POC Name: Purchased Care Division Telephone #: 360-759-1674 From Station #: 648 Facility Name: VA Portland Healthcare System Street Address: VA Portland Healthcare System City: Portland State: OR Zip: 97239 Fax: 360-905-1731 In accordance with section 101 of the Veterans Access, Choice, and Accountability Act of 2014 (the Act) (Public Law 113-146, 128 Stat. 1754), as amended by the Department of Veterans Affairs (VA), the Expiring Authorities Act of 2014 (Public Law 113-175, 128 Stat. 1902), the Consolidated and Further Continuing Appropriations Act of 2015 (Public Law 113 -235, 128 Stat. 2568), and 38 CFR ?? 17.1500-1540, VA will pay for non-VA hospital care and medical services that are authorized by VA for Veterans who are determined by VA to meet the Veterans Choice Program eligibility criteria set forth by section 101 of the Act and 38 CFR ? 17.1510 and any other eligibility standards that may apply to particular services (such as health care for newborns of Veterans under 38 CFR ? 17.38(a)(xiv) and dental benefits under ?? 17.160-17.169). This order is placed against the Patient Centered Community Care Contract in effect for this region: TriWest: VA791-13-D-0054 /es/ JEFFERY G STIVASON PCD-Voucher Examiner Signed: 12/11/2015 15:52"
                    },
                    new Authorization 
                    // Based on VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-0386 V3.0 U
                    // generated on 8/29/2016 from
                    // Shared Templates -> NVCC -> Testing
                    // for a test patient
                    {
                        AuthorizationId = "4",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-0386",
                        AuthorizationText = " LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038\nSTANDARD TITLE: NONVA NOTE                                      \nDATE OF NOTE: AUG 29, 2016@13:20     ENTRY DATE: AUG 29, 2016@13:22:07      \n      AUTHOR: DIGGS,BRIAN S        EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\n                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n                             VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf URGENT, indicate timeframe for appt: \n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \nAlternate point of contact 1-800-666-6666\n\n\nClinically Indicated Date (CID):\n\n08/31/2016\n\nCategory of Care/Type of Specialist: \n\nCategory:      Cartography\nType of Spec:  Orientiering\n\nType of Service/Procedure:\n\n  Topoligical Mapping\n\nNumber of Visits, Frequency and Duration: \n\n  As Needed\n\n\n\n\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: Aug 29,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nNo\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing office \nbelow. ALL other questions regarding this authorization should be directed to: \n1-866-606-8198\n \nAOD/Emergency Contact After Hours #: xxx-xxx-xxxx\n\nFrom Station #: XXX\nFacility Name: XXX\nStreet Address: XXX\nCity: XXX\nState: XXX\nZip: XXX\nFax: XXX\n\nVeteran Information:\nName: Zztest, Cendy\nDOB: xx/xx/xxxx\nSSN: xxx-xx-xxxx\nAddress: xxx Main Street\nAnytown, USA\n\nPhone: xxx-xxx-xxxx\nVeteran Alternate Phone:yyy-yyy-yyyy\n\nVeteran Alternate Address: \n\n \nAlternate POC for Veteran:(If available for VA internal use)\nName: \nAddress: \n\nPhone: \n\nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountabilityAct of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR ?? 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR ? 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR ? 17.38(a)(xiv) and dental \nbenefits under ?? 17.160-17.169).\n \n/es/ Brian S Diggs, PhD\nProgram Analyst\nSigned: 08/29/2016 13:25\n"
                    },
                    new Authorization
                    // Adapted from a note from Spokane, provided by Sandra Gravelle, 2016/09/13
                    // PPI has been redacted
                    // Manually converted newlines to '\n'
                    // Seems to be based on version 3, but with "If URGENT" changed to "If ROUTINE"
                    {
                        AuthorizationId = "5",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038",
                        AuthorizationText = "LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE VA-FORM 10-038\nSTANDARD TITLE: NONVA NOTE                                      \nDATE OF NOTE: SEP 13, 2016@15:27     ENTRY DATE: SEP 13, 2016@15:27:32      \n      AUTHOR: GRAVELLE,SANDRA JO   EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\n                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n                             VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf ROUTINE, indicate timeframe for appt: \n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \n\n\nClinically Indicated Date (CID):\n09/12/2016\n\nCategory of Care/Type of Specialist: \n\nCategory:      NEUROLOGY\nType of Specialist: \n NEUROLOGY EEG DIAGNOSTIC\n\nType of Service/Procedure:\n\n  Dizziness and Giddiness(ICD-10-CM R42.)\n\nNumber of Visits, Frequency and Duration: \n\n  1 VISIT FOR A 90 DAY EPISODE OF CARE\n\n\n\n\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: Sep 13,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nNo\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing\noffice below. ALL other questions regarding this authorization should be\ndirected to: 1-866-606-8198\n\nAOD/Emergency Contact After Hours #: 509-434-7010\n\nFrom Station #: 668\nFacility Name:  Mann Grandstaff VAMC\nStreet Address: 4815 N Assembly Street\nCity:           Spokane\nState:          Washington\nZip:            99205\nFax:            1-509-484-7941\n\nVeteran Information:\nName:  XXXXXXX,XXX XXXXX\nDOB:   JAN 1,1800\nSSN:   XXX-XX-XXXX\nAddress:123 Main Street\n             SPOKANE VALLEY, WA  99212\nPhone: XXX XXX XXXX\nVeteran Alternate Phone:\n\nVeteran Alternate Address: \n\n\nAlternate POC for Veteran:(If available for VA internal use)\nName: \nAddress: \n\nPhone: \nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountabilityAct of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR ?? 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR ? 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR ? 17.38(a)(xiv) and dental \nbenefits under ?? 17.160-17.169).\n\n/es/ SANDRA JO GRAVELLE\nCLAIMS ASSISTANT\nSigned: 09/13/2016 15:30\n"
                    },
                    new Authorization
                    // From a note from Atlanta, provided by Charles Demosthenes, 2016/09/16
                    // Manually converted newlines to '\n'
                    {
                        AuthorizationId = "6",
                        AuthorizationTitle = "", // Local note title unknown
                        AuthorizationText = "                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n			     VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf ROUTINE, indicate timeframe for appt: I think this should if NOT routine\n\nTo facilitate Urgent scheduling, \nplease include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \njoe nurse\n\n\nClinically Indicated Date (CID):\n\n05/06/2016\n\nCategory of Care/Type of Specialty: \n\nCategory:      Orthopedist\n\nType of Specialist:\n\nOrthopedist\n\nType of Service/Procedure:\n\n  Orthopedic help\nDescription of Specialty:\nALL OTHER SPECIALTIES: Orthopedics\n\n\n \nNumber of Visits, Frequency and Duration: \n\n  4\n\n\nVeteran or VAMC Preferred Provider Name and Contact Information:\n  Dr smith\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: \nSep 16,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nNo\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing office \nbelow. ALL other questions regarding this authorization should be directed to: \n1-866-606-8198\n \nMOD/Emergency Contact After Hours #: 7465\n\nFrom Station #: 508\nFacility Name: Atlanta VA Medical Center\nStreet Address: 1670 Clairmont Road\nCity: Decatur\nState: GA\nZip: 30033\nFax: wer234\n\nVeteran Information:\nName: HUMPTY JR ZZDUMPTY\nDOB: JAN 1,1945\nSSN: 000-00-8888\nAddress: 1670 CLAIRMONT ROAD\nDECATUR, GEORGIA  30033\nPhone: (555)555-5555\nVeteran Alternate Phone:3rewfsdc\n\nVeteran Alternate Address: \nasdfxcz\n\n \nAlternate POC for Veteran:(If available for VA internal use)\nName: dasfcxz\nAddress: \nasdfzcx\n\nPhone: dsafcvxz \n\nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountabilityAct of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR § 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \nbenefits under §§ 17.160-17.169).\n"
                    },
                    new Authorization
                    // From a diagnostic mammography note from Atlanta, provided by Charles Demosthenes, 2016/09/17
                    // Line breaks converted to '\n'
                    {
                        AuthorizationId = "7",
                        AuthorizationTitle = "", // Local note title unknown
                        AuthorizationText = "                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n			     VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf ROUTINE, indicate timeframe for appt: routine\n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \njoe\n\n\nClinically Indicated Date (CID):\n\n03/06/2016\n\nCategory of Care/Type of Specialty: \n\nCategory:      Mammography\n\nType of Specialist:\n\nmammorgraphy\n\nType of Service/Procedure:\n\n  mammorgraphy\nDescription of Specialty:\nCHOICE-FIRST DIAGNOSTIC MAMMOGRAM\nService: Radiology - DIAGNOSTIC Mammography\nDiagnosis: Abnormal mammogram R92.8 \n\nVisits Authorized: 6\n\nFax number: 404-728-4824\n\nAdministrative and clinical eligibility verified for NVCC.\nClinical and administrative eligibility verified for Choice-Program. \n\nApproved one (1) diagnostic bilateral (or unilateral) mammography.    \n\nApproved additional views/supplemental imaging, visits for imaging, if \nclinically indicated, for suspicious findings or lesion(s).\n\nApproved breasts ultrasound, fine needle biopsy, or stereotactic\nbreast biopsy, including visit to accomplish diagnostic testing, if\nclinically indicated. \n\nOne (1) follow-up office visit not to exceed a level 2, is pre-approved\nfor follow up post procedure, if biopsy was performed, to discuss pathology\nfindings and treatment plan.\n\nALL specimens submitted for pathology evaluation and report, as a result\nof an approved procedure, are authorized for payment/reimbursement as well.  \n\nAuthorization includes all in-office associated labs and radiology tests\nas clinically indicated.\n\nNo diagnostics, treatments, procedures, referrals to other non-VA specialists, \netc., except as listed above, are authorized at this time.\n\nUse critical findings instructions to report abnormal results.\nNumber of Visits, Frequency and Duration: \n\n  5\n\n\n\n\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: \nSep 16,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nYes\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing office \nbelow. ALL other questions regarding this authorization should be directed to: \n1-866-606-8198\n \nMOD/Emergency Contact After Hours #: 7465\n\nFrom Station #: 508\nFacility Name: Atlanta VA Medical Center\nStreet Address: 1670 Clairmont Road\nCity: Decatur\nState: GA\nZip: 30033\nFax: asd\n\nVeteran Information:\nName: HUMPTY JR ZZDUMPTY\nDOB: JAN 1,1945\nSSN: 000-00-8888\nAddress: 1670 CLAIRMONT ROAD\nDECATUR, GEORGIA  30033\nPhone: (555)555-5555\nVeteran Alternate Phone:asd\n\nVeteran Alternate Address: \n\n \nAlternate POC for Veteran:(If available for VA internal use)\nName: \nAddress: \n\nPhone: \n\nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountabilityAct of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR § 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \nbenefits under §§ 17.160-17.169).\n"
                    },
                    new Authorization
                    // From a mammography note from Atlanta, provided by Charles Demosthenes, 2016/09/17
                    // Line breaks converted to '\n'
                    {
                        AuthorizationId = "8",
                        AuthorizationTitle = "", // Local note title unknown
                        AuthorizationText = "                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n			     VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf ROUTINE, indicate timeframe for appt: \n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \n\n\nClinically Indicated Date (CID):\n\n03/07/1800\n\nCategory of Care/Type of Specialty: \n\nCategory:      mammorgraphy\n\nType of Specialist:\n\n\n\nType of Service/Procedure:\n\n  mammorgaphy\nDescription of Specialty:\nCHOICE-FIRST SCREENING MAMMOGRAM\nService: Radiology – SCREENING Mammography\nDiagnosis: Mammography screening Z12.31 \n\nVisits Authorized: 6\n\nFax number: 404-728-4824\n\nClinical and administrative eligibility verified for NVCC.\nClinical and administrative eligibility verified for Choice-Program. \n\nApproved for one (1) screening bilateral (or unilateral) mammography.    \n\nApproved for additional views/supplemental imaging, if clinically indicated,\nfor suspicious findings or lesion(s).  \n\nApproved for diagnostic mammography, breast(s) ultrasound, fine needle\nbiopsy(ies), or stereotactic breast biopsy(ies), if clinically indicated,\nincluding visits to complete supplemental imaging. \n\nApproved for one (1) follow-up office visit, not to exceed a level 2,\npost procedure, if biopsy was performed, to discuss pathology findings\nand treatment plan.\n\nALL specimen(s) submitted for pathology evaluation and report as result\nfrom the approved procedure(s), are authorized for payment/reimbursement\nas well.  \n\nAuthorization includes all in-office associated labs and radiology tests, \nas clinically indicated.\n\nNo diagnostics, treatments, procedures, referrals to other non-VA specialists,\netc., except as listed above, are authorized at this time.\n\nUse critical findings instructions to report abnormal results.\n\n\n  \nNumber of Visits, Frequency and Duration: \n\n  6\n\n\n\n\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: \nSep 16,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nNo\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing office \nbelow. ALL other questions regarding this authorization should be directed to: \n1-866-606-8198\n \nMOD/Emergency Contact After Hours #: 7465\n\nFrom Station #: 508\nFacility Name: Atlanta VA Medical Center\nStreet Address: 1670 Clairmont Road\nCity: Decatur\nState: GA\nZip: 30033\nFax: adsf\n\nVeteran Information:\nName: HUMPTY JR ZZDUMPTY\nDOB: JAN 1,1945\nSSN: 000-00-8888\nAddress: 1670 CLAIRMONT ROAD\nDECATUR, GEORGIA  30033\nPhone: (555)555-5555\nVeteran Alternate Phone:asdf\n\nVeteran Alternate Address: \nadsf\n\n \nAlternate POC for Veteran:(If available for VA internal use)\nName: \nAddress: \n\nPhone: \n\nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountabilityAct of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR § 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \nbenefits under §§ 17.160-17.169).\n"
                    },
                    new Authorization
                    // Created by Brian Diggs on 9/22/2016 from Note title: VCP-CHOICE PROV AGRMT VAF 10-0386A
                    // Manually removed line breaks.
                    {
                        AuthorizationId = "9",
                        AuthorizationTitle = "VCP-CHOICE PROV AGRMT VAF 10-0386A",
                        AuthorizationText = "REFERRAL INFORMATION\n                      Department of Veterans Affairs \n             VETERANS CHOICE PROVIDER AGREEMENT AUTHORIZATION\n			    VA-FORM 10-0386a\n\nReason for Use of Provider Agreement:Veteran Requested Specific Provider\n\nCommunity Provider Name(s):\n  Dr. Bob\n\nAuthorization Number: xx\n\nVA Ordering Provider: Dr. Howard \n\nPlease select referral urgency: \nRoutine\n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \n\n\nSecondary Authorization Request(SAR):\n\n   \n\nServices and Timeframe Authorized:\n\nSpecialty: \n\n  Cardiology\n\nType of Specialist:\n\n  Echocardiographist\n\nType of Service/Procedure:\n\n  EEG\n\nNumber of Visits, Frequency and Duration: \n\n  x\n\n\nDate VA Requests services under Provider Agreement:\nSep 23,2016@06:00\n\n\n\n\n\nVeteran Information:\nName: ZZTEST,CENDY\nDOB: JAN 5,1954\nSSN: 000-00-0014\nAddress: 1750 BLANKENSHIP RD\nPORTLAND, OR  98665\nPhone: 3602705995\n\n \n\n\n\n(include name, address and phone if known)\n\n\nEligiblity Type(From initial authorization if applicable):\nVeterans Choice 40 Mile\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: \n09/22/2016\n\nVeteran Other Health Insurance (OHI):\n\n  Does Veteran have billable OHI?:\n\n   No - Veteran does not have billable OHI - VA Primary Payer\n\n\n\nService-Connected(SC) and/or Special Authority(SA):\n   Not applicable - Veteran does not have billable OHI\n   \n\nVA Community Care Manager or equivalent:\n\nName: XX\n\nTitle: XX\n\nVA Issuing Office:\nVA Community Care Contact #: XX\nAfter Hours POC #: XX\n\nContact local VA Community Care Office first to provide information to VA or \nreach VA ordering provider. All contact from Community Care Provider will be \ndocumented in the Veteran's Record by VA Community Care staff and VA Ordering \nProvider notified for awareness. Report all CRITICAL FINDINGS related to this \nauthorization to the VA Community Care Office above.\n\nFrom Station #: 648\nFacility Name: Portland\nStreet Address: xxx\nCity: xxx\nState: xxx\nZip: xxx\nFax: xxx\n"
                    },
                    new Authorization
                    // Provided by Rick Woods, 10/20/2016
                    // as "Tele Mental Health" note
                    // "Just an FYI there is going to be some additions made to the 10-0386, but only for 3-6 pilot sites.  I don’t have a timeline yet. 
                    // I have made the team aware that I need to have you look at the form first to make sure that the REF DOC tool will work prior to moving forward."
                    {
                        AuthorizationId = "10",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386",
                        AuthorizationText = " LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386  \nSTANDARD TITLE: NONVA NOTE                                      \nDATE OF NOTE: OCT 20, 2016@10:39     ENTRY DATE: OCT 20, 2016@10:39:31      \n      AUTHOR: WOODS,GAROLD R       EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\n                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n                             VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf ROUTINE, indicate timeframe for appt: AAAAAAAA\n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \n\n\nClinically Indicated Date (CID):\n\n10/20/2016\n\nTele Mental Health\nCognitive Behavioral Therapy(CBT) \nVA Behavioral Health Provider Name:  AAAA\nVA Behavioral Health Provider Phone: AAAAA\nVA AOD/Emergency Contact After Hours #:  AAAAAA\n\nNumber of Visits, Frequency and Duration: \n\n  AAAAAAAAAAAAAAAAAA\n\n\n\n\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: Oct 20,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nNo\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing office \nbelow. ALL other questions regarding this authorization should be directed to: \n1-866-606-8198\n \nAOD/Emergency Contact After Hours #: 561-422-8277 (AOD)\n\nFrom Station #: 548\nFacility Name: WEST PALM BEACH VA MEDICAL CENTER\nStreet Address: 7305 N. MILITARY TRAIL\nCity: WEST PALM BEACH\nState: FLORIDA\nZip: 33410\nFax: 561-422-1575\n\nVeteran Information:\nName: AA-TLAZLY,DETLY L\nDOB: NOV 23,1971\nSSN:  101-17-9793\nAddress: \n1735 VIARRITZ DRIVE\nBOONVILLE MT 12345\nPhone: Home Phone# 404-656-1122\nVeteran Alternate Phone:\n\nVeteran Alternate Address: \n\n \nAlternate POC for Veteran:(If available for VA internal use)\nName: \nAddress: \n\nPhone: \n\nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountability Act of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR § 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \nbenefits under §§ 17.160-17.169).\n \n/es/ Garold R Woods,RN\nHealth Informatics Specialist\nSigned: 10/20/2016 10:40\n"
                    },
                    new Authorization
                    // Provided by Rick Woods, 10/20/2016
                    // as "Other Service" note
                    // "Just an FYI there is going to be some additions made to the 10-0386, but only for 3-6 pilot sites.  I don’t have a timeline yet. 
                    // I have made the team aware that I need to have you look at the form first to make sure that the REF DOC tool will work prior to moving forward."
                    {
                        AuthorizationId = "11",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386",
                        AuthorizationText = " LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386  \nSTANDARD TITLE: NONVA NOTE                                      \nDATE OF NOTE: OCT 20, 2016@10:41     ENTRY DATE: OCT 20, 2016@10:42:02      \n      AUTHOR: WOODS,GAROLD R       EXP COSIGNER:                           \n     URGENCY:                            STATUS: COMPLETED                     \n\n                   Department of Veterans Affairs \n                 VHA CHOICE APPROVAL FOR MEDICAL CARE\n                             VA-FORM 10-0386\n\nPlease select referral urgency: \nRoutine\n\nIf ROUTINE, indicate timeframe for appt: XX\n\nTo facilitate Urgent scheduling, please include an alternate point \nof contact's (different than the NVCC staff member listed below) name,\ntelephone number, and relationship to the patient (social worker, triage nurse, \netc.) in space provided. \n\n\nClinically Indicated Date (CID):\n\n10/21/2016\n\nService other than Tele Mental Health\nCategory of Care/Type of Specialty:\n\nCategory:     XXXXXXXXXXXXXXXXX\n\nType of Specialist:\n\nXXXXXXXXXXXXXXXXXXXX\n\nType of Service/Procedure:\n\n  XXXXXXXXXXXXXXXXXXX\n\nNumber of Visits, Frequency and Duration: \n\n  XXXXXXXXXXXXXXXXXXXXX\n\n\n\n\n\nEligibility Verification: \nAs the authorized VA representative, I hereby confirm that the Veteran is \neligible for Choice services. The Veteran's basic eligibility was verified\nin the Veterans Choice Viewer application (VA Viewer) on: Oct 20,2016\n\nService-Connected(SC) and/or Special Authority(SA):\nNo\n\nContact local VA NVCC Office first to provide information to VA or reach \nVA ordering provider. All contact from Contractor will be documented in \nthe Veteran's Record by NVCC and VA Provider notified for awareness. \n\nReport all CRITICAL FINDINGS related to this authorization to the issuing office \nbelow. ALL other questions regarding this authorization should be directed to: \n1-866-606-8198\n \nAOD/Emergency Contact After Hours #: 561-422-8277 (AOD)\n\nFrom Station #: 548\nFacility Name: WEST PALM BEACH VA MEDICAL CENTER\nStreet Address: 7305 N. MILITARY TRAIL\nCity: WEST PALM BEACH\nState: FLORIDA\nZip: 33410\nFax: 561-422-1575\n\nVeteran Information:\nName: AA-TLAZLY,DETLY L\nDOB: NOV 23,1971\nSSN:  101-17-9793\nAddress: \n1735 VIARRITZ DRIVE\nBOONVILLE MT 12345\nPhone: Home Phone# 404-656-1122\nVeteran Alternate Phone:\n\nVeteran Alternate Address: \n\n \nAlternate POC for Veteran:(If available for VA internal use)\nName: \nAddress: \n\nPhone: \n\nIn accordance with section 101 of the Veterans Access, Choice, and \nAccountability Act of 2014 (the Act)(Public Law 113-146, 128 Stat. \n1754), as amended by the Department of Veterans Affairs (VA), the \nExpiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \nthe Consolidated and Further Continuing Appropriations Act of 2015 \n(Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \nVA will pay for non-VA hospital care and medical services that are \nauthorized by VA for Veterans who are determined by VA to meet the \nVeterans Choice Program eligibility criteria set forth by section \n101 of the Act and 38 CFR § 17.1510 and any other eligibility \nstandards that may apply to particular services (such as health care \nfor newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \nbenefits under §§ 17.160-17.169).\n \n/es/ Garold R Woods,RN\nHealth Informatics Specialist\nSigned: 10/20/2016 10:43\n"
                    },
                    new Authorization
                    // Provided by Stephanie Bell, 05/03/2017
                    // Urgency and Clinically Indicated Date were not being parsed (UNK)
                    // PHI/PII blocked out
                    {
                        AuthorizationId = "12",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386",
                        AuthorizationText = " LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386\n STANDARD TITLE: NONVA NOTE\n DATE OF NOTE: MAY 03, 2017@15:20    ENTRY DATE: MAY 03, 2017@15:20:40\n AUTHOR: SUTTON,TUNIESA      EXP COSIGNER:\n URGENCY:                           STATUS: COMPLETED\n \n Department of Veterans Affairs\n VHA CHOICE APPROVAL FOR MEDICAL CARE\n VA-FORM 10-0386\n \n Please select referral urgency:\n Routine\n \n If ROUTINE, indicate time frame for appt:\n \n To facilitate Urgent scheduling, please include an alternate point\n of contact's (different than the Local VA Office of Community\n Care (OCC) staff member listed below) name,telephone number, and\n relationship to the patient (social worker, triage nurse, etc.)\n in space provided.\n Dr. Fengming Zhong\n VA Attending Physician, Hematology/Oncology\n 973-676-1000\n \n \n Clinically Indicated Date (CID):\n \n 03/22/2017\n \n Category of Care/Type of Specialty:\n \n Category:      Oncology\n Type of Specialist:\n (e.g. Specialist: Neurologist vs Neurosurgeon) Oncologist\n \n Type of Service/Procedure:\n \n Evaluation and treatment. Diagnosis: Thrombocytopenia\n \n PRIMARY VA CLINICAL POINT OF CONTACT - INCLUDING FOR CRITICAL FINDINGS: DR.\n FENGMING ZHONG, ATTENDING PHYSICIAN, HEMATOLOGY/ONCOLOGY,973-676-\n 1000X1311\n SECONDARY VA CLINICAL POINT OF CONTACT: LOLITA GONZALEZ, RN, NON VA CARE\n OFFICE (973) 676-1000 X2292.\n \n Number of Visits, Frequency and Duration:\n \n 3 MONTHS\n \n \n \n Eligibility Verification:\n As the authorized VA representative, I hereby confirm\n that the Veteran is eligible for Choice services. The\n Veteran's basic eligibility was verified in the Veterans\n Choice Viewer application (VC Viewer)\n on: May 3,2017\n \n Contact the Local VA Office of Community Care (OCC) first to provide\n information to VA or reach VA ordering provider. All contact from\n Contractor will be documented in the Veteran's Record by the Local\n VA Office of Community Care (OCC) and VA Provider notified for awareness.\n \n Report all CRITICAL FINDINGS related to this authorization\n to the issuing office below. ALL other questions regarding\n this authorization should be directed to:\n \n Local VA Office of Community Care (OCC) Contact\n \n Non-VA Care Program Manager or equivalent:\n Name: Erika Tyree\n Title: Supervisory Program Analyst\n \n AOD/Emergency Contact After Hours Number:\n (973) 676-1000 X3435/3436\n \n \n From Station #: 561\n Facility Name: VA New Jersey Health Care System\n Street Address: 385 Tremont Avenue\n City: East Orange\n State: NJ\n Zip: 07018\n Fax:(973) 395-7517\n \n Veteran Information:\n Name: XXXXXXX,XXXXXX XXXXXX\n DOB: XXXXXXXXXXXXXX XX,XXXX\n SSN: XXX-XX-XXXX\n Address: NNN XXXXXXX DRIVE\n ANYTOWN, US NNNNN\n Phone: (NNN)NNN-NNNN\n Veteran Alternate Phone:\n Veteran Alternate Address:\n \n \n Alternate POC for Veteran:(If available for VA internal use)\n Name: XXXXXX XXXXXXX\n Address:\n NNN XXXXXXX Drive\n Anytown, US NNNNN\n \n Phone: NNN-NNN-NNNN\n \n In accordance with section 101 of the Veterans Access, Choice, and\n Accountability Act of 2014 (the Act)(Public Law 113-146, 128 Stat.\n 1754), as amended by the Department of Veterans Affairs (VA), the\n Expiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902),\n the Consolidated and Further Continuing Appropriations Act of 2015\n (Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540,\n VA will pay for non-VA hospital care and medical services that are\n authorized by VA for Veterans who are determined by VA to meet the\n Veterans Choice Program eligibility criteria set forth by section\n 101 of the Act and 38 CFR § 17.1510 and any other eligibility\n standards that may apply to particular services (such as health care\n for newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental\n benefits under §§ 17.160-17.169).\n \n /es/ TUNIESA SUTTON\n ADVANCED MEDICAL SUPPORT\n Signed: 05/03/2017 15:24\n"
                    }
                    , new Authorization
                    // Provided by Deira Ledesma-Martinez on 5/4/2017
                    // PHI/PII blocked out
                    {
                        AuthorizationId = "13",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386",
                        AuthorizationText = " LOCAL TITLE: VHA CHOICE APPROVAL FOR MEDICAL CARE FORM 10-0386  \n STANDARD TITLE: NONVA NOTE                                      \n DATE OF NOTE: APR 17, 2017@13:45     ENTRY DATE: APR 17, 2017@13:45:55      \n AUTHOR: ATHILL,LORI          EXP COSIGNER:                           \n URGENCY:                            STATUS: COMPLETED                     \n \n Department of Veterans Affairs \n VHA CHOICE APPROVAL FOR MEDICAL CARE\n VA-FORM 10-0386\n \n Please select referral urgency: \n Routine\n \n If Routine, indicate timeframe for appt: \n \n To facilitate scheduling, please include an alternate point \n of contact's (different than the NVCC staff member listed below) name,\n telephone number, and relationship to the patient (social worker, triage nurse, \n etc.) in space provided. \n Name:  XXXXXXX,XXXXXXXXXXX (XXXX)\n 123 MAIN STREET\n ANYTOWN, USA  00000\n Phone number:  (000)000-0000\n Work phone number:  000-000-0000\n \n \n \n Clinically Indicated Date (CID):\n \n 04/14/2017\n \n Category of Care/Type of Specialist: \n \n Category:      PHYSICAL THERAPY\n Type of Specialist: \n PHYSICAL THERAPIST\n \n Type of Service/Procedure:\n \n TREATMENT LOW BACK PAIN AND RIGHT FOOT PAIN\n \n PRIMARY VA CLINICAL POINT OF CONTACT - INCLUDING FOR CRITICAL FINDINGS :\n NIGEL SHENOY\n LONG RANGE PAGER #: 973-281-0730\n FAX #: 973-395-7160\n 973.676.1000 X1255\n \n SECONDARY VA CLINICAL POINT OF CONTACT: LOLITA GONZALEZ, RN, NON VA CARE \n OFFICE (973) 676-1000 X2292/FAX 973.395.7517.\n \n Number of Visits, Frequency and Duration: \n \n 8WEEKS\n 3X A WEEK\n \n \n Veteran or VAMC Preferred Provider Name and Contact Information:\n Patient prefers going to the following provider:\n Name: Sports Care\n Address: 3196 John F. Kennedy Blvd, Union City, NJ\n Phone: 201-223-4949\n \n Eligibility Verification: \n As the authorized VA representative, I hereby confirm that the Veteran is \n eligible for Choice services. The Veteran's basic eligibility was verified\n in the Veterans Choice Viewer application (VA Viewer) on: Apr 17,2017\n \n Non-VA Care Program Manager or equivalent:\n Name: Erika Tyree \n Title: Supervisory Program Analyst\n \n Service-Connected(SC) and/or Special Authority(SA):\n Yes\n \n Contact local VA NVCC Office first to provide information to VA or reach \n VA ordering provider. All contact from Contractor will be documented in \n the Veteran's Record by NVCC and VA Provider notified for awareness. \n \n Report all CRITICAL FINDINGS related to this authorization to the issuing office \n below. ALL other questions regarding this authorization should be directed to: \n 1-866-606-8198\n \n AOD/Emergency Contact After Hours #: AOD 973.676.1000 3435/3436\n \n From Station #: 561\n Facility Name: VA New Jersey Health Care System\n Street Address: 385 Tremont Avenue\n City: East Orange\n State: NJ\n Zip: 07018\n Fax:(973) 395-7517\n \n Veteran Information:\n Name: XXXXXXXXX,XXX X\n DOB: JAN 1,1900\n SSN: 000-00-0000\n Address: 123 MAIN STREET \n ANYTOWN,USA 00000\n \n Phone: (000)000-0000 \n \n Veteran Alternate Address: \n N/A\n Cell: (000)000-0000\n \n \n Alternate POC for Veteran:(If available for VA internal use)\n Name: XXXXXXX,XXXXXXXXXXX (XXXX)\n Address: \n 123 MAIN STREET\n ANYTOWN, USA  00000\n Work phone number:  000-000-0000\n \n \n Secondary Next of Kin Information:\n XXXXX,XXXXXXXXXXXX (XXX)\n 123 MAIN STREET\n ANYTOWON, USA 00000\n Phone number:  (000)000-0000\n \n \n \n Phone: (000)000-0000\n \n In accordance with section 101 of the Veterans Access, Choice, and \n Accountability Act of 2014 (the Act)(Public Law 113-146, 128 Stat. \n 1754), as amended by the Department of Veterans Affairs (VA), the \n Expiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \n the Consolidated and Further Continuing Appropriations Act of 2015 \n (Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \n VA will pay for non-VA hospital care and medical services that are \n authorized by VA for Veterans who are determined by VA to meet the \n Veterans Choice Program eligibility criteria set forth by section \n 101 of the Act and 38 CFR § 17.1510 and any other eligibility \n standards that may apply to particular services (such as health care \n for newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \n benefits under §§ 17.160-17.169).\n \n /es/ LORI ATHILL\n fee clerk\n Signed: 04/17/2017 13:57\n"
                    }
                    , new Authorization
                    // V5 of the 10-0386. This is the "April 21, 2017" release
                    // Derived by hand translating the file https://URL         .DNS/sites/cbopc/BSM/NVCC/I/CT/CHOICE-FIRST/VHA%20CHOICE%20APPROVAL%20FOR%20MEDICAL%20CARE%20VA-FORM%2010-0386%20VERSION%203.0/CPRS%20Template%20VAF%2010-0386%20(Choice%20Contractor)%20Update%20April%2019,%202017/VHA%20CHOICE%20APPROVAL%20FOR%20MEDICAL%20CARE%20VA%20FORM%20100386%20V5.txml
                    // substituting the constant text fields.
                    // Document retrieved 2017-06-12
                    {
                        AuthorizationId = "14",
                        AuthorizationTitle = "VHA CHOICE APPROVAL FOR MEDICAL CARE VA FORM 10-0386 V5",
                        AuthorizationText = "                   Department of Veterans Affairs \n VHA CHOICE APPROVAL FOR MEDICAL CARE\n VA-FORM 10-0386\n \n Please select referral urgency: \n {FLD:VA-10-0386-SCH URGENT-ROUTINE1}\n \n If ROUTINE, indicate time frame for appt: {FLD:VA-10-0386 TEXT}\n \n {FLD:VA-10-0386 URGENT CONTACT INF3}\n {FLD:VA-WORD 70-3}\n \n Clinically Indicated Date (CID):\n (CID = VA Ordering Provider requests patient seen on the date entered\n below,as the first scheduled appointment)\n {FLD:VA-NVCC DATE MONTH1}{FLD:VA-NVCC DAY NUMBER1}{FLD:VA-NVCC DATE YEAR1}\n \n Category of Care/Type of Specialty: \n (e.g. CATEGORY: Optometry vs Ophthalmology )\n Category:      {FLD:VA-10-0386 TEXT REQ}\n Type of Specialist:\n (e.g. Specialist: Neurologist vs Neurosurgeon)  {FLD:VA-10-0386 TEXT REQ}\n \n Type of Service/Procedure:\n (e.g. Mohs, Colonoscopy, Cardiac Stress Test, Surgery \n to include post op Home Health)\n {FLD:VA-10-0386 WORD 70-3 REQ}\n \n Number of Visits, Frequency and Duration: \n (e.g. 3 months duration, 2 visits a week for 6 weeks, not to exceed 365 days)\n {FLD:VA-10-0386 WORD 70-3 REQ}\n (Please note: information contained in this section is for assistance in\n identifying the service required. It is NOT diagnostically valid.)\n \n Veteran or VAMC Preferred Provider Name and Contact Information:\n {FLD:VA-10-0386 WORD 70-3}\n \n Eligibility Verification: \n As the authorized VA representative, I hereby confirm\n that the Veteran is eligible for Choice services. The \n Veteran's basic eligibility was verified in the Veterans\n Choice Viewer application (VC Viewer) \n on: {FLD:VA-10-0386 DATE&amp;TIME TODAY}\n \n Contact the Local VA Office of Community Care (OCC) first to provide\n information to VA or reach VA ordering provider. All contact from \n Contractor will be documented in the Veteran's Record by the Local \n VA Office of Community Care (OCC) and VA Provider notified for awareness. \n \n Report all CRITICAL FINDINGS related to this authorization\n to the issuing office below. ALL other questions regarding \n this authorization should be directed to: \n {FLD:VA-10-0386 EDIT 30-40}\n \n Local VA Office of Community Care (OCC) Contact \n Number (Normal Business Hours):\n {FLD:VA-10-0386 EDIT 30-40 REQ}\n AOD/Emergency Contact After Hours Number: \n {FLD:VA-10-0386 EDIT 30-40 REQ}\n \n \n From Station #: \n Facility Name: \n Street Address: \n City: \n State: \n Zip: \n Fax: \n \n Veteran Information:\n Name: \n DOB: \n SSN: \n Address: \n Phone: \n Veteran Alternate Phone:{FLD:EDIT 20}\n Veteran Alternate Address: \n {FLD:VA-WORD 35-3}\n \n Alternate POC for Veteran:(If available for VA internal use)\n Name: {FLD:EDIT 501}\n Address: \n {FLD:VA-WORD 35-3}\n Phone: {FLD:EDIT 20}\n \n In accordance with section 101 of the Veterans Access, Choice, and \n Accountability Act of 2014 (the Act)(Public Law 113-146, 128 Stat. \n 1754), as amended by the Department of Veterans Affairs (VA), the \n Expiring Authorities Act of 2014(Public Law 113-175, 128 Stat. 1902), \n the Consolidated and Further Continuing Appropriations Act of 2015 \n (Public Law 113 -235, 128 Stat. 2568), and 38 CFR §§ 17.1500-1540, \n VA will pay for non-VA hospital care and medical services that are \n authorized by VA for Veterans who are determined by VA to meet the \n Veterans Choice Program eligibility criteria set forth by section \n 101 of the Act and 38 CFR § 17.1510 and any other eligibility \n standards that may apply to particular services (such as health care \n for newborns of Veterans under 38 CFR § 17.38(a)(xiv) and dental \n benefits under §§ 17.160-17.169).\n"
                    }
                    , new Authorization
                    // V5 of the 10-0386a. This is the "April 21, 2017" release
                    // Derived by hand translating the file https://URL         .DNS/sites/cbopc/BSM/NVCC/I/CT/CHOICE-FIRST/VHA%20CHOICE%20APPROVAL%20FOR%20MEDICAL%20CARE%20VA-FORM%2010-0386%20VERSION%203.0/CPRS%20Template%20VAF%2010-0386a%20(VCP%20Provider%20Agreement)%20Update%20April%2019,%202017/VCPCHOICE%20PROV%20AGRMT%20VAF%20100386A%20V5.txml
                    // substituting the constant text fields.
                    // Document retrieved 2017-06-12
                    {
                        AuthorizationId = "15",
                        AuthorizationTitle = "VCP-CHOICE PROV AGRMT VAF 10-0386A V5",
                        AuthorizationText = "                        Department of Veterans Affairs\n VETERANS CHOICE PROVIDER AGREEMENT AUTHORIZATION\n VA-FORM 10-0386a\n \n Reason for use of Provider Agreement:\n {FLD:VA-VCPA REASON FOR RETURN}\n \n Community Provider Name(s): \n {FLD:WP 2 LINE 50 REQ}\n \n Authorization Number: {FLD:EB 40R}\n \n VA Ordering Provider: {FLD:EB 40R}\n \n Please select referral urgency\n {FLD:VC URGENCY RB}\n \n To facilitate urgent scheduling, please include an alternate \n point of contact(s) (different than the Local VA Office of \n Community Care (OCC) staff member listed below) name, \n telephone number, and relationship to the patient \n (social worker, triage nurse, etc.) in space provided.\n {FLD:WP 2 LINE}\n \n Secondary Authorization Request (SAR):\n NOTE: All SARs require clinical approval. Approved SARs require \n creation of 10-0386a and 10-7078/10-7079.  If SAR requires \n services for new diagnosis or new provider, notify VA ordering \n provider to enter a new NVC consult or VA internal consult \n request per Choice process.\n If SAR referral, specify type:\n {FLD:VCP SAR TYPE RB}\n \n Services and Timeframe Authorized:\n Specialty:\n (i.e. Cardiology, Dermatology, Neurology)\n {FLD:WP 2 LINE 50 REQ}\n \n Type of Specialist:\n (Must be specialty specific: Neurologist vs. Neurosurgeon)\n {FLD:WP 2 LINE 50 REQ}\n \n Type of Service/Procedure:\n (e.g. Follow-up, Colonoscopy)\n {FLD:WP 2 LINE 50 REQ}\n \n Number of Visits, Frequency and Duration:\n (e.g. 1 consultation with 3 follow-up visits x 2 month)\n {FLD:WP 2 LINE 50 REQ}\n (Please note: information contained in this section is for \n assistance in identifying the service required.  It is NOT\n diagnostically valid.)\n \n Date VA Requests services under Provider Agreement:\n {FLD:DATE}\n \n Appointment Comment:\n (Enter reason appointment not scheduled at time authorization completed)\n {FLD:WP 3 LINE}\n \n Veteran Information:\n Name: \n DOB: \n SSN: \n Address: \n Phone: \n \n Veterans Alternate address/phone\n {FLD:WP 3 FL 50}\n \n Alternate POC:\n (include name, address and phone if known)\n {FLD:WP 3 FL 50}\n \n Eligibility Type (From initial authorization if applicable):\n {FLD:VCP ELIGIBILITY TYPE RB1}\n \n Eligibility Verification:\n As the authorized VA representative, I hereby confirm that \n the Veteran is eligible for Choice services.  The Veteran's \n basic eligibility was verified in the Veterans Choice Viewer\n application (VC Viewer) on: {FLD:DATE }\n \n Local VA Office of Community Care(OCC)Manager or equivalent:\n \n Name:{FLD:EB 40R}\n Title:{FLD:EB 40R}\n \n Local VA Office of Community Care (OCC) Contact \n Number (Normal Business Hours):\n {FLD:VA-10-0386 EDIT 30-40 REQ}\n After hours Point of Contact (POC) Number: {FLD:EB 40R}\n \n Contact the Local VA Office of Community Care (OCC) first to \n provide information to VA or reach VA ordering provider.  \n All contact from Community Care Provider will be documented\n in the Veteran's Record by the Local VA Office of Community \n Care (OCC) staff and VA Ordering Provider notified for \n awareness.  Report all CRITICAL FINDINGS related to this \n authorization to the Local VA Office of Community \n Care (OCC) above.\n \n From station #: \n Facility Name: \n Street Address: \n City: \n State: \n Zip:\n Fax:\n"
                    }
                };

        }

        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsScreeningMammo()
        {
            var expectedText = "SCREENING MAMMO";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[0]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsChiropracticEligibility()
        {
            var expectedText = "Chiropractic";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[1]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsScreeningOrthopedics()
        {
            var expectedText = "Orthopedics";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[2]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsOrtho()
        {
            var expectedText = "ORTHOPEDICS  PAINFUL ELBOW EVALTREATMENT POST-OP FOLLOW UP CARE PHYSICAL THERAPY";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[3]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsCartography()
        {
            var expectedText = "Cartography";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[4]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsNeurology()
        {
            var expectedText = "NEUROLOGY";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[5]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsOrthopedist()
        {
            var expectedText = "Orthopedist";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[6]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsMammography()
        {
            var expectedText = "Mammography";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[7]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_Returnsmammorgraphy()
        {
            var expectedText = "mammorgraphy"; //[sic]
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[8]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsCardiology()
        {
            var expectedText = "Cardiology";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[9]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsTeleMentalHealth()
        {
            var expectedText = "Tele Mental Health";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[10]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsXXXXXXXXXXXXXXXXX()
        {
            var expectedText = "XXXXXXXXXXXXXXXXX";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[11]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsOncology()
        {
            var expectedText = "Oncology";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[12]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsPhysicalTherapy()
        {
            var expectedText = "PHYSICAL THERAPY";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[13]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsFieldReference()
        {
            // The nominal expected response is "{FLD:VA-10-0386 TEXT REQ}". However, the 
            // curly braces and colon are not present in the expected text because the
            // method strips out (those) non-alphanumeric characters.
            var expectedText = "FLDVA-10-0386 TEXT REQ"; 
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[14]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }
        [Test]
        public void DescriptionOfSpecialty_GivenValidText_ReturnsFieldReference2()
        {
            // The nominal expected response is "{FLD:WP 2 LINE 50 REQ}". However, the 
            // curly braces and colon are not present in the expected text because the
            // method strips out (those) non-alphanumeric characters.
            var expectedText = "FLDWP 2 LINE 50 REQ";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[15]);
            Assert.AreEqual(expectedText, viewModel.DescriptionOfSpecialty);
        }

        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[0]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsNow()
        {
            var expectedText = "Now";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[1]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsSTAT()
        {
            var expectedText = "STAT";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[2]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine2()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[4]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine3()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[5]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine4()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[6]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine5()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[7]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine6()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[8]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine7()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[9]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine8()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[10]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine9()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[11]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine10()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[12]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsRoutine11()
        {
            var expectedText = "Routine";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[13]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsFieldReference()
        {
            // The nominal expected response is "{FLD:VA-10-0386-SCH URGENT-ROUTINE1}". However, the 
            // curly braces and colon are not present in the expected text because the
            // method strips out (those) non-alphanumeric characters.
            var expectedText = "FLDVA-10-0386-SCH URGENT-ROUTINE1";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[14]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }
        [Test]
        public void Urgency_GivenValidText_ReturnsFieldReference2()
        {
            // The nominal expected response is "{FLD:VC URGENCY RB}". However, the 
            // curly braces and colon are not present in the expected text because the
            // method strips out (those) non-alphanumeric characters.
            var expectedText = "FLDVC URGENCY RB";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[15]);
            Assert.AreEqual(expectedText, viewModel.Urgency);
        }

        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_ReturnsSep_3_2015()
        {
            var expectedText = "Sep 3,2015";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[0]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_ReturnsSep_25_2015()
        {
            var expectedText = "Sep 25,2015";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[1]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_ReturnsNov_19_2015()
        {
            var expectedText = "Nov 19,2015";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[2]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns8_31_2016()
        {
            var expectedText = "08/31/2016";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[4]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns09_12_2016()
        {
            var expectedText = "09/12/2016";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[5]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns05_06_2016()
        {
            var expectedText = "05/06/2016";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[6]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns03_06_2016()
        {
            var expectedText = "03/06/2016";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[7]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns03_07_1800()
        {
            var expectedText = "03/07/1800";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[8]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_ReturnsSept_23_2016()
        {
            var expectedText = "Sep 23,2016@06:00";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[9]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns10_20_2016()
        {
            var expectedText = "10/20/2016";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[10]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns10_21_2016()
        {
            var expectedText = "10/21/2016";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[11]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns03_22_2017()
        {
            var expectedText = "03/22/2017";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[12]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_Returns04_14_2017()
        {
            var expectedText = "04/14/2017";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[13]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_ReturnsFieldReference()
        {
            var expectedText = "{FLD:VA-NVCC DATE MONTH1}{FLD:VA-NVCC DAY NUMBER1}{FLD:VA-NVCC DATE YEAR1}";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[14]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }
        [Test]
        public void ClinicallyIndicatedDate_GivenValidText_ReturnsFieldReference2()
        {
            var expectedText = "{FLD:DATE}";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[15]);
            Assert.AreEqual(expectedText, viewModel.ClinicallyIndicatedDate);
        }

        [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsOct_16_2015()
         {
             var expectedText = "Oct 16,2015";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[0]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsOct_7_2015()
         {
             var expectedText = "Oct 7,2015";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[1]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsOct_12_2015()
         {
             var expectedText = "Oct 12,2015";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[2]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsAug_29_2016()
         {
             var expectedText = "Aug 29,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[4]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsSep_13_2016()
         {
             var expectedText = "Sep 13,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[5]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsSep_16_2016()
         {
             var expectedText = "Sep 16,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[6]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsSep_16_2016_2()
         {
             var expectedText = "Sep 16,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[7]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsSep_16_2016_3()
         {
             var expectedText = "Sep 16,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[8]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_Returns09_22_2016()
         {
             var expectedText = "09/22/2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[9]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsOct_20_2016()
         {
             var expectedText = "Oct 20,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[10]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
         [Test]
         public void EligibilityVerificationDate_GivenValidText_ReturnsOct_20_2016B()
         {
             var expectedText = "Oct 20,2016";
             AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[11]);
             Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
         }
        [Test]
        public void EligibilityVerificationDate_GivenValidText_ReturnsMay_3_2017()
        {
            var expectedText = "May 3,2017";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[12]);
            Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
        }
        [Test]
        public void EligibilityVerificationDate_GivenValidText_ReturnsApr_17_2017()
        {
            var expectedText = "Apr 17,2017";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[13]);
            Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
        }
        [Test]
        public void EligibilityVerificationDate_GivenValidText_ReturnsFieldReference()
        {
            var expectedText = "{FLD:VA-10-0386 DATE&amp;TIME TODAY}";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[14]);
            Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
        }
        [Test]
        public void EligibilityVerificationDate_GivenValidText_ReturnsFieldReference2()
        {
            var expectedText = "{FLD:DATE }";
            AuthorizationViewModel viewModel = new AuthorizationViewModel(authList[15]);
            Assert.AreEqual(expectedText, viewModel.EligiblityVerificationDate);
        }

    }
}
