﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NVCC.Repos.MdwsRepository.Utilities
{
    public class MdwsDataUtilities
    {
        public static string DatetoCprsFormat(DateTime aDate)
        {
            return aDate.ToString("yyyyMMdd.HHmmss");
        }

        public static DateTime? CprsFormattoDate(string aDate)
        {
            try
            {
                return DateTime.ParseExact(aDate, "yyyyMMdd.HHmmss", CultureInfo.InvariantCulture);
            }
            catch (Exception)
            {
                return null;
            }
        }
    }
}
