﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace NVCC.Models
{
    [Serializable]
    public class User
    {
        public int ApplicationUserID { get; set; }
        public string DomainPlusNetworkUserName { get; set; }
        public string Name { get; set; }
        public short CurrentDefaultFacility { get; set; }
        public IDictionary<short, UserFacility> Facilities { get; set; }
        public UserFacility LastAuthorized()
        {
            return Facilities.Values.OrderByDescending(f => f.LastAuthDateTime).FirstOrDefault();
        }
        public IEnumerable<UserFacility> ActiveFacilities()
        {
            return Facilities.Values.Where(f => (f.PHIPII ?? false) && (f.ViaB ?? false) && (!String.IsNullOrEmpty(f.VIAToken)) && (f.VIATokenExpiration != null) && (f.VIATokenExpiration > DateTime.UtcNow)); 
        }
    }
}
