﻿



CREATE View [PanelMgmt].[vICD] AS
--=============================================================================================================
--Region                : R01
--Visn					: V20
--Requestor				: NWIC
--Author                : Jerry Kohler
--Object/SP Name		: vICD
--Server				: 
--Data Base				: CC_REFDOC
--Schema				: PanelMgmt
--Report				: Any Panel Management registry or report.
--Folder				:
--Report Loc            : 
--Job Loc               : None
--Note                  : THIS VIEW RETURNS THE CURRENT DESCRIPTION AND DIAGNOSTIC TEXT, NOT HISTORIC ONES
--                      : BASED ON A DATE.  This view is not supported by CDW, BISL or any OI&T group.
--                      :
--                      : These views only exist at district 5.  Any code using them cannot be shared beyond
--                        district 5.
--                      :
--Date Created          : 09-21-2015
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To minimize the impact of future CDW changes of ICD-9/10 on our code.
--=============================================================================================================
Select Sta3n,
       ICDIEN            AS ICDIEN,
       ICD9SID           AS ICDSID,
       ICD9Code          AS ICDCode, 
       ICD9Description   AS ICDDescription,
       ICD9DiagnosisText AS ICDDiagnosisText,
       ICDVersion
From PanelMgmt.vICD9

UNION ALL

Select Sta3n,
       ICDIEN             AS ICDIEN,
       ICD10SID           AS ICDSID,
       ICD10Code          AS ICDCode, 
       ICD10Description   AS ICDDescription,
       ICD10DiagnosisText AS ICDDiagnosisText,
       ICDVersion
From PanelMgmt.vICD10

;




