﻿CREATE VIEW [App].[vNVCC_ProductionAccessLog]
AS
SELECT
	*
FROM
	App.NVCC_AccessLog al
WHERE
	al.UserID NOT IN ('DNS', 'VHA20\vhaporDiggsB', 'VHA20\vhaporNordaT', 'VHA20\VHAPORKOHLEG', 'VHA20\VHAPORMCCONJ') 
	AND (
		al.HostName = 'DNS.URL       ' OR
		--dev.nwic was being used to host users who could not covert to the VIA version during these dates
 		(al.HostName = 'DNS.URL       ' AND AccessDateTime BETWEEN '2016-10-19' AND '2016-11-15')
		OR al.HostName = 'DNS' --the EWIS hosted national production site
	)
	AND al.Action = 'PDF'

