﻿CREATE TABLE [App].[NVCC_UserFacilities]
(
	[UserFacilityId] INT IDENTITY (1, 1) NOT NULL PRIMARY KEY NONCLUSTERED, 
    [UserID] INT NOT NULL, 
    [Sta3n] SMALLINT NOT NULL, 
    [Sta6a] VARCHAR(50) NULL,
    [LastAuthDateTime] DATETIME2(0) NULL, 
    [ViaB] BIT NULL, 
    [admin] BIT NOT NULL DEFAULT 0
) WITH (DATA_COMPRESSION = PAGE);

GO
CREATE UNIQUE CLUSTERED INDEX [NVCC_UserFacilities_UserIDSta3n]
	ON [App].[NVCC_UserFacilities]([UserID] ASC, [Sta3n] ASC) WITH (DATA_COMPRESSION = PAGE)
GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_UserFacilities_UserFacilityId]
	ON [App].[NVCC_UserFacilities]([UserFacilityId] ASC)
	WITH (DATA_COMPRESSION = PAGE)
