﻿CREATE TABLE [App].[NVCC_SensitiveDxCodes] (
    [CodingSystem]  VARCHAR (12)  NOT NULL,
    [Sta3n]         SMALLINT      NULL,
    [ICDSID]        INT           NULL,
    [Code]          VARCHAR (12)  NOT NULL,
    [DiagnosisText] VARCHAR (255) NOT NULL,
    [AbuseDx]       INT           NULL,
    [SickleDx]      INT           NULL,
    [HIVDx]         INT           NULL
);


GO
CREATE UNIQUE CLUSTERED INDEX [NVCC_SensitiveDxCodes_ICDSID]
    ON [App].[NVCC_SensitiveDxCodes]([ICDSID] ASC) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);


GO
CREATE UNIQUE NONCLUSTERED INDEX [NVCC_SensitiveDxCodes_Sta3n_ICDCode]
    ON [App].[NVCC_SensitiveDxCodes]([Sta3n] ASC, [Code] ASC)
    INCLUDE([DiagnosisText], [AbuseDx], [SickleDx], [HIVDx]) WITH (FILLFACTOR = 95, DATA_COMPRESSION = PAGE);

