﻿CREATE TABLE [App].[NVCC_AccessLog] (
    [AccessLogID]        INT           IDENTITY (1, 1) NOT NULL,
    [HostName]           VARCHAR (80)  NULL,
    [UserID]             VARCHAR (50)  NULL,
    [AccessDateTime]     DATETIME      NULL,
    [Action]             VARCHAR (255) NULL,
    [PatientSID]         INT           NULL,
    [ElapsedTime]        FLOAT (53)    NULL,
    [DatabaseServerName] VARCHAR (50)  NULL,
    CONSTRAINT [PK_App_NVCCAccessLog] PRIMARY KEY NONCLUSTERED ([AccessLogID] ASC) WITH (DATA_COMPRESSION = PAGE)
);
GO

CREATE CLUSTERED INDEX [NVCC_AccessLog_HostName_UserID_AccessDateTime]
    ON [App].[NVCC_AccessLog]([UserID] ASC, [HostName] ASC, [AccessDateTime] ASC) WITH (DATA_COMPRESSION = PAGE);
GO

