﻿CREATE TABLE [App].[AllCDWPatients] (
    [Sta3n]      SMALLINT     NOT NULL,
    [PatientIEN] VARCHAR (50) NULL,
    [PatientSSN] VARCHAR (50) NULL,
    [PatientSID] INT          NOT NULL,
    [PatientICN] VARCHAR (55) NULL
);


GO
CREATE CLUSTERED INDEX [AllCDWPatients_Sta3n_PatientSSN]
    ON [App].[AllCDWPatients]([Sta3n] ASC, [PatientSSN] ASC) WITH (DATA_COMPRESSION = PAGE);


GO
CREATE NONCLUSTERED INDEX [AllCDWPatients_PatientICN]
    ON [App].[AllCDWPatients]([PatientICN] ASC)
    INCLUDE([PatientSID], [PatientSSN], [Sta3n]) WITH (DATA_COMPRESSION = PAGE);


GO
CREATE NONCLUSTERED INDEX [AllCDWPatients_PatientSID]
    ON [App].[AllCDWPatients]([PatientSID] ASC)
    INCLUDE([PatientICN]) WITH (DATA_COMPRESSION = PAGE);

