unit sxpath;
{
/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Sablopas : Pascal wrapper for Sablotron.
 *
 * More infos at http://www.tekool.com/sablopas - Contact : cespern@free.fr
 *
 * The Initial Developer of the Original Code is Christophe ESPERN
 * Portions created by Christophe ESPERN are Copyright (C) 2001-2002 Christophe
 * ESPERN. All Rights Reserved.
 * 
 * Contributor(s): None
}

interface

uses
 sablot,shandler;


const
  // ** SXPNodeType **
  SXP_ELEMENT_NODE = 1;
  SXP_ATTRIBUTE_NODE = 2;
  SXP_TEXT_NODE = 3;
  SXP_PROCESSING_INSTRUCTION_NODE = 7;
  SXP_COMMENT_NODE = 8;
  SXP_DOCUMENT_NODE = 9;
  SXP_NAMESPACE_NODE = 13;

  // ** SXPExprType **
  SXP_NONE=0;
  SXP_NUMBER=1;
  SXP_STRING=2;
  SXP_BOOLEAN=3;
  SXP_NODESET=4;

 type

  SXPNodeType=type longword;
  SXPExprType=type longword;

  QueryContext=type LongWord;
  SXPNode= type LongWord;
  SXPNodeList=type LongWord;
  SXPDocument= type SXPNode;

  PSXPNode= ^SXPNode;
  PSXPDocument= ^SXPDocument;
  PSXPNodeList= ^SXPNodeList;
  PQueryContext=^QueryContext;

  DOMH_getNodeType=function(n:SXPNode):SXPNodeType;cdecl;

  DOMH_getNodeName=function(n:SXPNode):PAnsiChar;cdecl;
  DOMH_getNodeNameURI=function(n:SXPNode):PAnsiChar;cdecl;
  DOMH_getNodeNameLocal=function(n:SXPNode):PAnsiChar;cdecl;
  DOMH_getNodeValue=function(n:SXPNode):PAnsiChar;cdecl;


  DOMH_getNextSibling=function(n:SXPNode):SXPNode;cdecl;
  DOMH_getPreviousSibling=function(n:SXPNode):SXPNode;cdecl;
  DOMH_getNextAttrNS=function(n:SXPNode):SXPNode;cdecl;
  DOMH_getPreviousAttrNS=function(n:SXPNode):SXPNode;cdecl;

  DOMH_getChildCount=function(n:SXPNode):integer;cdecl;
  DOMH_getAttributeCount=function(n:SXPNode):integer;cdecl;
  DOMH_getNamespaceCount=function(n:SXPNode):integer;cdecl;

  DOMH_getChildNo=function(n:SXPNode;ndx:integer):SXPNode;cdecl;
  DOMH_getAttributeNo=function(n:SXPNode;ndx:integer):SXPNode;cdecl;
  DOMH_getNamespaceNo=function(n:SXPNode;ndx:integer):SXPNode;cdecl;

  DOMH_getParent=function(n:SXPNode):SXPNode;cdecl;

  DOMH_getOwnerDocument=function(n:SXPNode):SXPDocument;cdecl;

  DOMH_compareNodes=function(n1,n2:SXPNode):integer;cdecl;

  DOMH_retrieveDocument=function(const uri:PAnsiChar;udata:Pointer):SXPDocument;cdecl;

  DOMH_getNodeWithID=function(doc:SXPDocument;const id:PAnsiChar):SXPNode;cdecl;


  DomHandler=record
    getNodeType:^DOMH_getNodeType;
    getNodeName:^DOMH_getNodeName;
    getNodeNameURI:^DOMH_getNodeNameURI;
    getNodeNameLocal:^DOMH_getNodeNameLocal;
    getNodeValue:^DOMH_getNodeValue;
    getNextSibling:^DOMH_getNextSibling;
    getPreviousSibling:^DOMH_getPreviousSibling;
    getNextAttrNS:^DOMH_getNextAttrNS;
    getPreviousAttrNS:^DOMH_getPreviousAttrNS;
    getChildCount:^DOMH_getChildCount;
    getAttributeCount:^DOMH_getAttributeCount;
    getNamespaceCount:^DOMH_getNamespaceCount;
    getChildNo:^DOMH_getChildNo;
    getAttributeNo:^DOMH_getAttributeNo;
    getNamespaceNo:^DOMH_getNamespaceNo;
    getParent:^DOMH_getParent;
    getOwnerDocument:^DOMH_getOwnerDocument;
    compareNodes:^DOMH_compareNodes;
    retrieveDocument:^DOMH_retrieveDocument;
    getNodeWithID:^DOMH_getNodeWithID;
  end;

  PDomHandler=^DomHandler;
  // Registering DOM Handler
  procedure SXP_registerDOMHandler(s:SablotSituation;domh:PDomHandler;udata:pointer);cdecl;external SAB_LIB;
  procedure SXP_unregisterDOMHandler(s:SablotSituation );cdecl;external SAB_LIB;
  // Query Management functions
  function SXP_createQueryContext(s:SablotSituation; Q:PQueryContext):integer;cdecl;external SAB_LIB;
  function SXP_addVariableBinding(Q:QueryContext;const name:PAnsiChar; source:QueryContext):integer;cdecl;external SAB_LIB;
  function SXP_addVariableNumber(Q:QueryContext; const name:PAnsiChar;value:double):integer;cdecl;external SAB_LIB;
  function SXP_addVariableString(Q:QueryContext;const name:PAnsiChar; const value:PAnsiChar):integer;cdecl;external SAB_LIB;
  function SXP_addVariableBoolean(Q:QueryContext; const name:PAnsiChar; value:integer):integer;cdecl;external SAB_LIB;
  function SXP_addNamespaceDeclaration(Q:QueryContext;const prefix,uri:PAnsiChar):integer;cdecl;external SAB_LIB;
  function SXP_query(Q:QueryContext;query:PAnsiChar;n:SXPNode;contextPosition:integer;contextSize:integer):integer;cdecl;external SAB_LIB;
  function SXP_destroyQueryContext(Q:QueryContext):integer;cdecl;external SAB_LIB;
   // Retrieve Result functions
  function SXP_getResultType(Q:QueryContext;var Xtype: integer ):integer;cdecl;external SAB_LIB;
  function SXP_getResultNumber(Q:QueryContext; var result:double):integer;cdecl;external SAB_LIB;
  function SXP_getResultBool(Q:QueryContext; var result:integer):integer;cdecl;external SAB_LIB;
  function SXP_getResultString(Q:QueryContext; result:PAnsiChar):integer;cdecl;external SAB_LIB;
  function SXP_getResultNodeset(Q:QueryContext; result:PSXPNodelist):integer;cdecl;external SAB_LIB;
   // Node list functions
  function SXP_getNodeListLength(l:SXPNodeList):integer;cdecl;external SAB_LIB;
  function SXP_getNodeListItem(l:SXPNodeList;const index:integer):SXPNode;cdecl;external SAB_LIB;

implementation

end.
