unit sabutils;
{Tbe most important part of of this file was a small part of the XDOM Unit, a file of
the Open XML software written by Dieter Khler. As I only need the URI parsing function
I copy them in a separate file. All the functions contained  in this file are still covered by
the license of Open XML and if he wants Dieter can use any modified version of this file for
Open XML. I consider the Open XML license as Open Source. More infos at http://www.philo.de/openxml
}

interface
{$IFDEF FPC}
 {$MODE DELPHI}
{$ENDIF}


uses SysUtils, Classes;

type


TSabUri=Ansistring;

TIniFile = class(TObject)
private
  FFileName: Ansistring;
  FContent:TStringList;
public
  constructor Create(const AFileName: Ansistring);
  destructor Destroy;override;
  function ReadString(const Section, Ident, Default: Ansistring): Ansistring;
  procedure WriteString(const Section, Ident, Value: Ansistring);
  procedure ReadSectionValues(const Section: Ansistring; Strings: TStrings);
  procedure SaveSectionValues(const Section: Ansistring; Strings: TStrings);
  procedure EraseSection(const Section: Ansistring);
  procedure UpdateFile;
  property FileName: Ansistring read FFileName;
end;

  TUriStrAnalyzer = class
  protected
    FUriAuthority: Ansistring;
    FUriFragment: Ansistring;
    FUriQuery: Ansistring;
    FUriPath: Ansistring;
    FUriScheme: Ansistring;
    FHasUriAuthority: boolean;
    FHasUriFragment: boolean;
    FHasUriQuery: boolean;
    FHasUriScheme: boolean;
    function getUriReference: Ansistring; virtual;
  public
    constructor create;
    function setUriAuthority(const Value: Ansistring;
                             const isDefined: boolean): boolean; virtual;
    function setUriFragment(const Value: Ansistring;
                            const isDefined: boolean): boolean; virtual;
    function setUriPath(const Value: Ansistring): boolean; virtual;
    function setUriQuery(const Value: Ansistring;
                         const isDefined: boolean): boolean; virtual;
    function setUriReference(const Value: Ansistring): boolean; virtual;
    function setUriScheme(const Value: Ansistring;
                          const isDefined: boolean): boolean; virtual;
    property HasUriAuthority: boolean read FHasUriAuthority;
    property HasUriFragment: boolean read FHasUriFragment;
    property HasUriQuery: boolean read FHasUriQuery;
    property HasUriScheme: boolean read FHasUriScheme;
    property UriAuthority: Ansistring read FUriAuthority;
    property UriFragment: Ansistring read FUriFragment;
    property UriPath: Ansistring read FUriPath;
    property UriQuery: Ansistring read FUriQuery;
    property UriReference: Ansistring read getUriReference;
    property UriScheme: Ansistring read FUriScheme;
  end;

function isAbnfALPHAChar(c: AnsiChar): boolean;
function isAbnfBITChar(c: AnsiChar): boolean;
function isAbnfCHARChar(c: AnsiChar): boolean;
function isAbnfCRChar(c: AnsiChar): boolean;
function isAbnfCRLFStr(s: Ansistring): boolean;
function isAbnfCTLChar(c: AnsiChar): boolean;
function isAbnfDIGITChar(c: AnsiChar): boolean;
function isAbnfDQUOTEChar(c: AnsiChar): boolean;
function isAbnfHEXDIGChar(c: AnsiChar): boolean;
function isAbnfHTABChar(c: AnsiChar): boolean;
function isAbnfLFChar(c: AnsiChar): boolean;
function isAbnfLWSPStr(s: Ansistring): boolean;
function isAbnfOCTETChar(c: AnsiChar): boolean;
function isAbnfSPChar(c: AnsiChar): boolean;
function isAbnfVCHARChar(c: AnsiChar): boolean;
function isAbnfWSPChar(c: AnsiChar): boolean;

function isUriURI_referenceStr(s: Ansistring): boolean;
function isUriAbsoluteURIStr(s: Ansistring): boolean;
function isUriRelativeURIStr(s: Ansistring): boolean;
function isUriHier_partStr(s: Ansistring): boolean;
function isUriOpaque_partStr(s: Ansistring): boolean;
function isUriNet_pathStr(s: Ansistring): boolean;
function isUriAbs_pathStr(s: Ansistring): boolean;
function isUriRel_pathStr(s: Ansistring): boolean;
function isUriRel_segmentStr(s: Ansistring): boolean;
function isUriSchemeStr(s: Ansistring): boolean;
function isUriAuthorityStr(s: Ansistring): boolean;
function isUriReg_nameStr(s: Ansistring): boolean;
function isUriServerStr(s: Ansistring): boolean;
function isUriUserinfoStr(s: Ansistring): boolean;
function isUriHostPortStr(s: Ansistring): boolean;
function isUriHostStr(s: Ansistring): boolean;
function isUriHostnameStr(s: Ansistring): boolean;
function isUriDomainlabelStr(s: Ansistring): boolean;
function isUriToplabelStr(s: Ansistring): boolean;
function isUriIPv4addressStr(s: Ansistring): boolean;
function isUriPortStr(s: Ansistring): boolean;
function isUriPathStr(s: Ansistring): boolean;
function isUriPath_segmentsStr(s: Ansistring): boolean;
function isUriSegmentStr(s: Ansistring): boolean;
function isUriParamStr(s: Ansistring): boolean;
function isUriQueryStr(s: Ansistring): boolean;
function isUriFragmentStr(s: Ansistring): boolean;
function isUriUricStr(s: Ansistring): boolean;
function isUriReservedChar(c: AnsiChar): boolean;
function isUriUnreservedChar(c: AnsiChar): boolean;
function isUriMarkChar(c: AnsiChar): boolean;
function isUriHexChar(c: AnsiChar): boolean;
function isUriAlphanumChar(c: AnsiChar): boolean;
function isUriAlphaChar(c: AnsiChar): boolean;
function isUriDigitChar(c: AnsiChar): boolean;

// Functions added by Christophe ESPERN for the Sablopas Project


function resolveRelativeUriStr(const baseUri,relUri: Ansistring;var resultUri: Ansistring): boolean;

function UriStrToFilename(const uri: Ansistring;var path: TFilename; var authority,query,fragment: Ansistring): boolean;

procedure SplitKeyValue(const s:Ansistring;var key,value:Ansistring);

function UnixPathToDosPath(const Path: Ansistring): Ansistring;
function DosPathToUnixPath(const Path: Ansistring): Ansistring;

function ExtractURIScheme(const URI: Ansistring): Ansistring;
function ExtractURIRest(const URI: Ansistring): Ansistring;
function ExtractURIFilename(const URI: Ansistring): Ansistring;

function PosIdx (Const Substr : AnsiString; Const Source : AnsiString;i:longint) : Longint;
procedure Replace(var s:Ansistring;const s1,s2:Ansistring);

procedure StringFromFile(const fname:Ansistring;var s:Ansistring);

implementation

Function PosIdx (Const Substr : AnsiString; Const Source : AnsiString;i:longint) : Longint;
  var
    S : Ansistring;
  begin
    PosIdx:=0;
    if Length(SubStr)=0 then
     exit;
    while (i <= length (Source) - length (substr)) do
     begin
       inc (i);
       S:=copy(Source,i,length(Substr));
       if S=SubStr then
       exit;
     end;
end;

procedure Replace(var s:Ansistring;const s1,s2:Ansistring);
 var
  last,
  x  : longint;
 begin
  last:=0;
  repeat
   x:=posidx(s1,uppercase(s),last);
   if (x>0) then
   begin
     Delete(s,x,length(s1));
     Insert(s2,s,x);
     last:=x+1;
   end;
  until (x=0);
end;

function ExtractURIScheme(const URI: Ansistring): Ansistring;
begin
 Result:=Copy(uri,0,pos('://',uri)-1);
 if Result='' then Result:=  Copy(uri,0,pos(':/',uri)-1)
end;

function ExtractURIRest(const URI: Ansistring): Ansistring;
begin
 Result:=Copy(URI,Pos('://',URI)+1,length(URI));
 if Result='' then Result:=Copy(URI,Pos(':/',URI)+1,length(URI));
end;

function ExtractURIFilename(const URI: Ansistring): Ansistring;
begin
 Result:=Copy(URI,Pos('://',URI)+3,length(URI));
 if Result='' then Result:=Copy(URI,Pos(':/',URI)+2,length(URI));
end;

function isUriURI_referenceStr(s: Ansistring): boolean;
var
  dcPos: integer;
  s1: Ansistring;
begin
  dcPos:= pos('#',s);
  if dcPos > 0 then begin
    s1:= copy(s,1,dcPos-1);
    result:= (   isUriAbsoluteURIStr(s1)
              or isUriRelativeURIStr(s1)
              or (s1 = '') )
              and isUriFragmentStr(copy(s,dcPos+1,length(s)-dcPos));
  end else
    result:= isUriAbsoluteURIStr(s) or isUriRelativeURIStr(s) or (s = '');
end;

function isUriAbsoluteURIStr(s: Ansistring): boolean;
var
  colonPos: integer;
  s1: Ansistring;
begin
  colonPos:= pos(':',s);
  if colonPos > 0 then begin
    s1:= copy(s,colonPos+1,length(s)-colonPos);
    result:= isUriSchemeStr(copy(s,1,colonPos-1)) and
             ( isUriHier_partStr(s1) or isUriOpaque_partStr(s1) );
  end else result:= false;
end;

function isUriRelativeURIStr(s: Ansistring): boolean;
var
  qmPos: integer;
  s1: Ansistring;
begin
  qmPos:= pos('?',s);
  if qmPos > 0 then begin
    s1:= copy(s,1,qmPos-1);
    result:= (   isUriNet_pathStr(s1)
              or isUriAbs_pathStr(s1)
              or isUriRel_pathStr(s1) )
              and isUriQueryStr(copy(s,qmPos+1,length(s)-qmPos));
  end else
    result:= isUriNet_pathStr(s) or isUriAbs_pathStr(s) or isUriRel_pathStr(s);
end;

function isUriHier_partStr(s: Ansistring): boolean;
var
  qmPos: integer;
  s1: Ansistring;
begin
  qmPos:= pos('?',s);
  if qmPos > 0 then begin
    s1:= copy(s,1,qmPos-1);
    result:= (   isUriNet_pathStr(s1)
              or isUriAbs_pathStr(s1) )
              and isUriQueryStr(copy(s,qmPos+1,length(s)-qmPos));
  end else
    result:= isUriNet_pathStr(s) or isUriAbs_pathStr(s);
end;

function isUriOpaque_partStr(s: Ansistring): boolean;
begin
  if s = '' then begin result:= false; exit; end;
  if s[1] = '/' then begin result:= false; exit; end;
  result:= isUriUricStr(s);
end;

function isUriNet_pathStr(s: Ansistring): boolean;
var
  slashPos: integer;
begin
  if copy(s,1,2) <> '//' then begin result:= false; exit; end;
  s:= copy(s,3,length(s)-2);
  slashPos:= pos('/',s);
  if slashPos > 0 then begin
    result:= isUriAuthorityStr(copy(s,1,slashPos-1)) and isUriAbs_pathStr(copy(s,slashPos,length(s)-slashPos+1));
  end else
    result:= isUriAuthorityStr(s);
end;

function isUriAbs_pathStr(s: Ansistring): boolean;
begin
  if s = '' then begin result:= false; exit; end;
  if s[1] <> '/' then begin result:= false; exit; end;
  result:= isUriPath_segmentsStr(copy(s,2,length(s)-1));
end;

function isUriRel_pathStr(s: Ansistring): boolean;
var
  slashPos: integer;
begin
  slashPos:= pos('/',s);
  if slashPos > 0 then begin
    result:= isUriRel_segmentStr(copy(s,1,slashPos-1)) and isUriAbs_pathStr(copy(s,slashPos,length(s)-slashPos+1));
  end else
    result:= isUriRel_segmentStr(s);
end;

function isUriRel_segmentStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ';') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') )
      then begin result:= false; exit; end;
  end;
end;

function isUriSchemeStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  if not isAbnfALPHAChar(s[1]) then begin result:= false; exit; end;
  result:= true;
  for i:= 2 to l do
    if not (    isAbnfALPHAChar(s[i])
             or isAbnfDIGITChar(s[i])
             or (s[i] = '+')
             or (s[i] = '-')
             or (s[i] = '.')
           )
      then begin result:= false; exit; end;
end;

function isUriAuthorityStr(s: Ansistring): boolean;
begin
  result:= isUriServerStr(s) or isUriReg_nameStr(s);
end;

function isUriReg_nameStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = '$') or (s[i] = ',') or (s[i] = ';')
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') )
      then begin result:= false; exit; end;
  end;
end;

function isUriServerStr(s: Ansistring): boolean;
var
  atPos,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= true; exit; end;
  atPos:= pos('@',s);
  if atPos > 0 then begin
    result:= isUriUserinfoStr(copy(s,1,atPos-1)) and isUriHostportStr(copy(s,atPos+1,l-atPos));
  end else
    result:= isUriHostportStr(s);
end;

function isUriUserinfoStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ';') or (s[i] = ':') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') )
      then begin result:= false; exit; end;
  end;
end;

function isUriHostPortStr(s: Ansistring): boolean;
var
  colonPos: integer;
begin
  colonPos:= pos(':',s);
  if colonPos > 0 then begin
    result:= isUriHostStr(copy(s,1,colonPos-1)) and isUriPortStr(copy(s,colonPos+1,length(s)-colonPos));
  end else
    result:= isUriHostStr(s);
end;

function isUriHostStr(s: Ansistring): boolean;
begin
  result:= isUriHostnameStr(s) or isUriIPv4addressStr(s);
end;

function isUriHostnameStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  result:= true;
  if s[l] = '.' then dec(l);
  i:= l;
  while i > 0 do begin
    if s[i] = '.' then break;
    dec(i);
  end;
  if not isUriToplabelStr(copy(s,i+1,l-i))
    then begin result:= false; exit; end;
  while i > 0 do begin
    l:= i;
    if s[l] = '.' then dec(l);
    i:= l;
    while i > 0 do begin
      if s[i] = '.' then break;
      dec(i);
    end;
    if not isUriDomainlabelStr(copy(s,i+1,l-i))
      then begin result:= false; exit; end;
  end;
end;

function isUriDomainlabelStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  if not ( isUriAlphanumChar(s[1]) and isUriAlphanumChar(s[l]) )
    then begin result:= false; exit; end;
  result:= true;
  i:= 1;
  while i < l do begin
    inc(i);
    if not (isUriAlphanumChar(s[i]) or (s[i] = '-') )
       then begin result:= false; exit; end;
  end;
end;

function isUriToplabelStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0 then begin result:= false; exit; end;
  if not ( isUriAlphaChar(s[1]) and isUriAlphanumChar(s[l]) )
    then begin result:= false; exit; end;
  result:= true;
  i:= 1;
  while i < l do begin
    inc(i);
    if not (isUriAlphanumChar(s[i]) or (s[i] = '-') )
       then begin result:= false; exit; end;
  end;
end;

function isUriIPv4addressStr(s: Ansistring): boolean;
var
  digitNo,colonNo,i,l: integer;
  digitFound: boolean;
begin
  result:= false;
  l:= length(s);
  i:= 0;
  digitNo:= 0;
  colonNo:= 0;
  digitFound:= false;
  while i < l do begin
    if isUriDigitChar(s[i]) then begin
      if not digitFound then begin
        digitFound:= true;
        inc(digitNo);
      end;
    end else if s[i] = '.' then begin
      if not digitFound then exit;
      digitFound:= false;
      inc(colonNo);
    end else exit;
  end;
  if (colonNo = 3) and (digitNo = 4) then result:= true;
end;

function isUriPortStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  result:= true;
  l:= length(s);
  for i:= 1 to l do
    if not isUriDigitChar(s[i]) then begin result:= false; exit; end;
end;

function isUriPathStr(s: Ansistring): boolean;
begin
  if isUriAbs_pathStr(s) or isUriOpaque_partStr(s) or (s = '')
    then result:= true
    else result:= false;
end;

function isUriPath_segmentsStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') or (s[i] = ';') or (s[i] = '/') )
      then begin result:= false; exit; end;
  end;
end;

function isUriSegmentStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') or (s[i] = ';') )
      then begin result:= false; exit; end;
  end;
end;

function isUriParamStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  result:= true;
  if l = 0 then exit;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriUnreservedChar(s[i])
                      or (s[i] = ':') or (s[i] = '@') or (s[i] = '&')
                      or (s[i] = '=') or (s[i] = '+') or (s[i] = '$')
                      or (s[i] = ',') )
      then begin result:= false; exit; end;
  end;
end;

function isUriQueryStr(s: Ansistring): boolean;
begin
  if s = ''
    then result:= true
    else result:= isUriUricStr(s);
end;

function isUriFragmentStr(s: Ansistring): boolean;
begin
  if s = ''
    then result:= true
    else result:= isUriUricStr(s);
end;

function isUriUricStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0
    then begin result:= false; exit; end
    else result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    if s[i] = '%' then begin
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
      if i = l then begin result:= false; exit; end;
      inc(i);
      if not isUriHexChar(s[i]) then begin result:= false; exit; end;
    end else if not ( isUriReservedChar(s[i]) or isUriUnreservedChar(s[i]) )
      then begin result:= false; exit; end;
  end;
end;

function isUriReservedChar(c: AnsiChar): boolean;
begin
  if (c=';') or (c='/') or (c='?') or (c=':') or (c='@') or (c='&') or
     (c='=') or (c='+') or (c='$') or (c=',')
    then result:= true
    else result:= false;
end;

function isUriUnreservedChar(c: AnsiChar): boolean;
begin
  if isUriAlphanumChar(c) or isUriMarkChar(c)
    then result:= true
    else result:= false;
end;

function isUriMarkChar(c: AnsiChar): boolean;
begin
  if (c='-') or (c='_') or (c='.') or (c='!') or (c='~') or (c='*') or
     (c=#39) or (c='(') or (c=')')
    then result:= true
    else result:= false;
end;

function isUriHexChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $30..$39,$41..$46,$61..$66:  // 0..9 , A..F , a..f
    result:= true;
  else
    result:= false;
  end;
end;

function isUriAlphanumChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $30..$39,$41..$5A,$61..$7A:
    result:= true;
  else
    result:= false;
  end;
end;

function isUriAlphaChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $41..$5A,$61..$7A:
    result:= true;
  else
    result:= false;
  end;
end;

function isUriDigitChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $30..$39:
    result:= true;
  else
    result:= false;
  end;
end;


procedure SplitKeyValue(const s:Ansistring;var key,value:Ansistring);
var
 epos:integer;
begin
 try
 epos:=pos('=',s);
 value:=copy(s,epos+1,length(s));
 key:=copy(s,0,epos-1);
 except
  Exception.create('Error in splitKeyvalue')
 end
end;

{ TIniFile }
constructor TIniFile.Create(const AFileName: Ansistring);
begin
 FFileName:=AFilename;
 FContent:=TStringList.create;
 if FileExists(AFileName) then
  FContent.LoadFromFile(AFileName);
end;

destructor TIniFile.Destroy;
begin
  inherited;
  FContent.Free;
end;

procedure TIniFile.ReadSectionValues(const Section: Ansistring;
  Strings: TStrings);
var
 i:integer;
 Inside:boolean;
begin
 Inside:=false;
 for i:=0 to FContent.count-1 do
  if trim(FContent[i])='['+Section+']' then
    Inside:=true
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then
    exit
  else if (inside) and (FContent[i]<>'') then
    Strings.Add(trim(FContent[i]));
end;

function TIniFile.ReadString(const Section, Ident,
  Default: Ansistring): Ansistring;
var
 i:integer;
 inside:boolean;
 key,value:Ansistring;
begin
 Inside:=false;
 for i:=0 to FContent.count-1 do
  if trim(FContent[i])='['+Section+']' then
    Inside:=true
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then
    exit
  else if inside then begin
    SplitKeyValue(trim(FContent[i]),key,value);
    if CompareText(key,ident)=0 then begin
      Result:=Value;
      break;
    end
  end;
end;

procedure TIniFile.EraseSection(const Section: Ansistring);
var
 i:integer;
 inside:boolean;
begin
 i:=0;
 inside:=false;
 repeat
  if (trim(FContent[i])='['+Section+']') and not(inside) then
    Inside:=true
  else if (trim(FContent[i])='['+Section+']') and inside then begin
    FContent.delete(i);
    i:=FCOntent.count-1;
  end
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then begin
    FContent.delete(i-1);
    i:=FCOntent.count-1;
  end
  else if inside then begin
    FContent.delete(i);
    dec(i);
  end;
  inc(i);
 until
   (i=FCOntent.count);
end;

procedure TIniFile.SaveSectionValues(const Section: Ansistring;
  Strings: TStrings);
var
 i:integer;
 s1,s2:Ansistring;
begin
 EraseSection(Section);
 for i:=0 to Strings.count-1 do begin
  SplitKeyValue(Strings[i],s1,s2);
  WriteString(Section,s1,s2);
 end;
end;

procedure TIniFile.UpdateFile;
begin
    FCOntent.SaveToFIle(FFilename)
end;

procedure TIniFile.WriteString(const Section, Ident, Value: Ansistring);
var
 i:integer;
 inside:boolean;
 key,avalue:Ansistring;
begin
 if ident='' then exit;
 Inside:=false;
 for i:=0 to FContent.count-1 do
  //Section Existe
  if trim(FContent[i])='['+Section+']' then
    Inside:=true
   //Donnes n'existaient pas -> insres
  else  if (Copy(trim(FContent[i]),0,1)='[') and inside then begin
    FContent.Insert(i,ident+'='+value) ;
    exit;
  end
  else if inside then begin
   //Section et donnes existaient -> valeur remplace
    SplitKeyValue(trim(FContent[i]),key,avalue);
    if CompareText(key,ident)=0 then begin
      FContent[i]:=ident+'='+value;
      exit;
    end
  end;
  //Section n'existait pas -> ajoutes
  if not inside then
    FContent.Add('['+section+']');
  //Donnes n'existait pas + fin de fichier -> ajoutes
  FContent.Add(ident+'='+value);
end;

function resolveRelativeUriStr(const baseUri,
                                     relUri: Ansistring;
                                 var resultUri: Ansistring): boolean;
var
  BaseUriAnalyzer,RelUriAnalyzer: TUriStrAnalyzer;
  i,slashPos,queryIndex: integer;
  pathBuffer: Ansistring;
  segments: TStringList;
begin
  resultUri:= '';
  BaseUriAnalyzer:= TUriStrAnalyzer.create;
  RelUriAnalyzer:= TUriStrAnalyzer.create;
  try
    result:= BaseUriAnalyzer.setUriReference(baseUri);
    result:= (RelUriAnalyzer.setUriReference(relUri) and result);
    result:= ((BaseUriAnalyzer.HasUriScheme or RelUriAnalyzer.HasUriScheme) and result);
    if not result then exit;  // baseUri is not an absolute URI reference, or baseUri or relUri is maleformed
    with RelUriAnalyzer do begin
      if (UriPath = '') and not ( HasUriScheme or HasUriAuthority or HasUriQuery) then begin
        // Same document reference detected
        BaseUriAnalyzer.setUriFragment(UriFragment,HasUriFragment);
        resultUri:= BaseUriAnalyzer.UriReference;
        exit;
      end;
      if HasUriScheme then begin
        // relUri is an absolute URI --> we are done.
        resultUri:= relUri;
        exit;
      end;
      // inherit scheme:
      setUriScheme(BaseUriAnalyzer.UriScheme,BaseUriAnalyzer.HasUriScheme);
      if not HasUriAuthority then begin
        // inherit authority:
        setUriAuthority(BaseUriAnalyzer.UriAuthority,BaseUriAnalyzer.HasUriAuthority);
        if not (copy(UriPath,1,1) = '/') then begin
          // analyze paths:
          segments:= TStringList.create;
          try
            slashPos:= LastDelimiter('/',BaseUriAnalyzer.UriPath);
            if slashPos > 0
              then pathBuffer:= copy(BaseUriAnalyzer.UriPath,2,slashPos-1) // Copy path without last segment and first character which is always '/'
              else pathBuffer:= '';
            pathBuffer:= concat(pathBuffer,UriPath);
            with segments do begin
              // cut pathBuffer into segments:
              slashPos:= pos('/',pathBuffer);
              while slashPos > 0 do begin
                Add(copy(pathBuffer,1,slashPos-1));
                pathBuffer:= copy(pathBuffer,slashPos+1,length(pathBuffer)-slashPos);
                slashPos:= pos('/',pathBuffer);
              end; {while ...}
              Add(pathBuffer);
              if (pathBuffer = '..') or (pathBuffer = '.')
                then Add(''); // Necessary to preserve ending '/' under some circumstances
              // remove '.' segments:
              queryIndex:= IndexOf('.');
              while queryIndex > -1 do begin
                delete(queryIndex);
                queryIndex:= IndexOf('.');
              end;
              // remove '<segment>/..' segments:
              queryIndex:= IndexOf('..');
              while queryIndex > 0 do begin
                delete(queryIndex);
                delete(pred(queryIndex));
                queryIndex:= IndexOf('..');
              end;
              // test for maleformed path:
              if count > 0
                then if strings[0] = '..' then begin
                  result:= false;
                  exit;
                end;
              pathBuffer:= '';
              for i:= 0 to pred(count) do
                pathBuffer:= concat(pathBuffer,'/',strings[i]);
              setUriPath(pathBuffer);
            end; {with segments ...}
          finally
            segments.free;
          end;
        end; {if not (copy(UriPath,1,1) = '/') ...}
      end; {if not HasAuthorityScheme ...}
      resultUri:= UriReference;
    end; {with RelUriAnalyzer ...}
  finally
    BaseUriAnalyzer.free;
    RelUriAnalyzer.free;
  end;
end;

constructor TUriStrAnalyzer.create;
begin
  setUriReference('');
end;

function TUriStrAnalyzer.getUriReference: Ansistring;
begin
  result:= '';
  if FHasUriScheme
    then result:= concat(result,FUriScheme,':');
  if FHasUriAuthority
    then result:= concat(result,'//',FUriAuthority);
  result:= concat(result,FUriPath);
  if FHasUriQuery
    then result:= concat(result,'?',FUriQuery);
  if FHasUriFragment
    then result:= concat(result,'#',FUriFragment);
end;

function TUriStrAnalyzer.setUriAuthority(const Value: Ansistring;
                                         const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriAuthority:= isDefined;
  if isDefined then begin
    if isUriAuthorityStr(Value)
      then FUriAuthority:= value
      else begin FUriAuthority:= ''; result:= false; end;
  end else FUriAuthority:= '';
end;

function TUriStrAnalyzer.setUriFragment(const Value: Ansistring;
                                        const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriFragment:= isDefined;
  if isDefined then begin
    if isUriFragmentStr(Value)
      then FUriFragment:= value
      else begin FUriFragment:= ''; result:= false; end;
  end else FUriFragment:= '';
end;

function TUriStrAnalyzer.setUriPath(const Value: Ansistring): boolean;
begin
  result:= isUriPathStr(Value);
  if result
    then FUriPath:= value
    else FUriPath:= '';
end;

function TUriStrAnalyzer.setUriQuery(const Value: Ansistring;
                                     const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriQuery:= isDefined;
  if isDefined then begin
    if isUriQueryStr(Value)
      then FUriQuery:= value
      else begin FUriQuery:= ''; result:= false; end;
  end else FUriQuery:= '';
end;

function TUriStrAnalyzer.setUriReference(const Value: Ansistring): boolean;
var
  colonPos,dcPos,qmPos,slashPos: integer;
  s: Ansistring;
begin
  colonPos:= pos(':',value);
  result:= setUriScheme(copy(value,1,colonPos-1),(colonPos > 0));
  s:= copy(value,colonPos+1,length(value)-colonPos);

  dcPos:= pos('#',s);
  if dcPos > 0 then begin
    result:= (setUriFragment(copy(s,dcPos+1,length(s)-dcPos),true) and result);
    s:= copy(s,1,dcPos-1);
  end else setUriFragment('',false);

  qmPos:= pos('?',s);
  if qmPos > 0 then begin
    result:= (setUriQuery(copy(s,qmPos+1,length(s)-qmPos),true) and result);
    s:= copy(s,1,qmPos-1);
  end else setUriQuery('',false);

  if copy(s,1,2) = '//' then begin
    s:= copy(s,3,length(s)-2);
    slashPos:= pos('/',s);
    if slashPos > 0 then begin
      result:= (setUriAuthority(copy(s,1,slashPos-1),true) and result);
      s:= copy(s,slashPos,length(s)-slashPos+1);
    end else begin
      result:= (setUriAuthority(s,true) and result);
      s:= '';
    end;
  end else setUriAuthority('',false);

  result:= setUriPath(s) and result;

  if not result then setUriReference('');
end;

function TUriStrAnalyzer.setUriScheme(const Value: Ansistring;
                                      const isDefined: boolean): boolean;
begin
  result:= true;
  FHasUriScheme:= isDefined;
  if isDefined then begin
    if isUriSchemeStr(Value)
      then FUriScheme:= value
      else begin FUriScheme:= ''; result:= false; end;
  end else FUriScheme:= '';
end;

function isAbnfALPHAChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $41..$5A,$61..$7A:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfBITChar(c: AnsiChar): boolean;
begin
  if (c = '0') or (c = '1')
    then result:= true
    else result:= false;
end;

function isAbnfCHARChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $01..$7F:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfCRChar(c: AnsiChar): boolean;
begin
  if c = #$0D
    then result:= true
    else result:= false;
end;

function isAbnfCRLFStr(s: Ansistring): boolean;
begin
  if s = #$0D#$0A
    then result:= true
    else result:= false;
end;

function isAbnfCTLChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $00..$1F,$7F:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfDIGITChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $30..$39:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfDQUOTEChar(c: AnsiChar): boolean;
begin
  if c = #$22
    then result:= true
    else result:= false;
end;

function isAbnfHEXDIGChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $30..$39,$41..$46:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfHTABChar(c: AnsiChar): boolean;
begin
  if c = #$09
    then result:= true
    else result:= false;
end;

function isAbnfLFChar(c: AnsiChar): boolean;
begin
  if c = #$0A
    then result:= true
    else result:= false;
end;

function isAbnfLWSPStr(s: Ansistring): boolean;
var
  i,l: integer;
begin
  l:= length(s);
  if l = 0
    then begin result:= false; exit; end
    else result:= true;
  i:= 0;
  while i < l do begin
    inc(i);
    case byte(s[i]) of
      $20,$09:; // SP or TAB --> Do nothing, because everthing is alright
      $0D: begin  // CR --> Look for LF
        if i = l then begin result:= false; exit; end;
        inc(i);
        if s[i] <> #$0A then begin result:= false; exit; end;
      end;
    else begin
      result:= false;
      exit;
      end;
    end;
  end;
end;

function isAbnfOCTETChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $00..$ff:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfSPChar(c: AnsiChar): boolean;
begin
  if c = #$20
    then result:= true
    else result:= false;
end;

function isAbnfVCHARChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $21..$7E:
    result:= true;
  else
    result:= false;
  end;
end;

function isAbnfWSPChar(c: AnsiChar): boolean;
begin
  case byte(c) of
    $20,$09:
    result:= true;
  else
    result:= false;
  end;
end;

function UriStrToFilename(const uri: Ansistring;
                            var path: TFilename;
                            var authority,
                                query,
                                fragment: Ansistring): boolean;
var
  UriAnalyzer: TUriStrAnalyzer;
  pathBuffer: Ansistring;  // Used to increase performance
  i,l: integer;
begin
  path:= '';
  query:= '';
  fragment:= '';
  result:= false;
  UriAnalyzer:= TUriStrAnalyzer.create;
  try
    with UriAnalyzer do begin
      if setUriReference(uri) then begin
        if CompareText(UriScheme,'file') = 0 then begin
          result:= true;
          pathBuffer:= UriPath;
          l:= length(pathBuffer);
          if l > 0 then begin
            // remove leading '/':
            dec(l);
            pathBuffer:= copy(pathBuffer,2,l);
            i:= 1;
            while i <= l do begin
              if pathBuffer[i] = '%' then begin
                // resolve escape sequence:
                path:= concat(path,chr(StrToInt(concat('x',pathBuffer[i+1],pathBuffer[i+2]))));
                i:= i+2;
              end else if pathBuffer[i] = '/' then begin
                // translate '/' to '\':
                path:= concat(path,'\');
              end else path:= concat(path,pathBuffer[i]);
              inc(i);
            end; {while ...}
          end; {if ...}
          authority:= UriAuthority;
          if HasUriQuery
            then query:= concat('?',UriQuery);
          if HasUriFragment
            then fragment:= concat('#',UriFragment);
        end; {if ...}
      end; {if ...}
    end; {with ...}
  finally
    UriAnalyzer.free;
  end;
end;


function TranslateChar(const Str: Ansistring; FromChar, ToChar: AnsiChar): Ansistring;
var
  I: Integer;
begin
  Result := Str;
  for I := 1 to Length(Result) do
    if Result[I] = FromChar then
      Result[I] := ToChar;
end;

function UnixPathToDosPath(const Path: Ansistring): Ansistring;
begin
  Result := TranslateChar(Path, '/', '\');
end;

function DosPathToUnixPath(const Path: Ansistring): Ansistring;
begin
  Result := TranslateChar(Path, '\', '/');
end;


procedure StringFromFile(const fname:Ansistring;var s:Ansistring);
var
 fs:TFileStream;
begin
 try
 fs:=TFileStream.Create(fname,fmOpenRead);
 SetLength(s,fs.size);
 fs.ReadBuffer(Pointer(s)^,fs.size);
 finally
  if Assigned(fs) then
   fs.free;
 end;
end;




end.
