unit sablot;
{
/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is the Sablopas : Pascal wrapper for Sablotron.
 * More infos at http://www.tekool.com/sablopas - Contact : cespern@free.fr
 *
 * The Initial Developer of the Original Code is Christophe Espern
 * Portions created by Christophe ESPERN are Copyright (C) 2001-2002 Christophe
 * Espern. All Rights Reserved.
 *
 * Contributor(s):
 /
}
interface



uses
shandler;


type

 TSParams=array [0..100] of PAnsiChar;

 SablotProcessor=type SablotHandle;
 SablotSituation=type LongWord;
 PSablotHandle = ^SablotHandle;
 PProcessor = ^SablotProcessor;
 PSituation=^SablotSituation;

{SDomNode is in fact declare in SDom.h but we need it here to pass a DomDocument to
functions which has a DomNode}
 SDomNode= type LongWord;
 SDomDocument= type SDomNode;
 PDomNode= ^SDomNode;
 PDomDocument= ^SDomDocument;
 // Parsing functions
 function SablotParse(s:SablotSituation;const URI:PAnsichar;d:PDomDocument):integer; cdecl;external SAB_LIB;
 function SablotParseBuffer(s:SablotSituation;const buffer:PAnsiChar;d:PDomDocument):integer; cdecl;external SAB_LIB;
 function SablotParseStylesheet(s:SablotSituation;const URI:PAnsiCHar;d:PDomDocument):integer; cdecl;external SAB_LIB;
 function SablotParseStylesheetBuffer(s:SablotSituation;const buffer:PAnsiChar;d:PDomDocument):integer; cdecl;external SAB_LIB;
 // Document Management
 function SablotCreateDocument(s:SablotSituation;d:PDomDocument):integer;cdecl;external SAB_LIB;
 function SablotLockDocument(s:SablotSituation;d:SDomDocument):integer;cdecl;external SAB_LIB;
 function SablotDestroyDocument(s:SablotSituation;d:SDomDocument):integer;cdecl;external SAB_LIB;
 // Params and Arguments Management
 function SablotAddParam(s:SablotSituation;p:SablotProcessor;const paramName:PAnsiChar;paramValue:PAnsiChar):integer; cdecl;external SAB_LIB;
 function SablotAddArgTree(s:SablotSituation;p:SablotProcessor;const argName:PAnsiChar;tree:SDomDocument):integer; cdecl;external SAB_LIB;
 function SablotAddArgBuffer(s:SablotSituation;p:SablotProcessor;const argName,bufferValue:PAnsiChar):integer; cdecl;external SAB_LIB;
 // SablotSituation
 function SablotCreateSituation(sPtr:PSituation):integer;cdecl;external SAB_LIB;
 function SablotSetOptions(s:SablotSituation;flags:integer):integer;cdecl;external SAB_LIB;
 function SablotClearSituation(s:SablotSituation):integer;cdecl;external SAB_LIB;
 function SablotDestroySituation(s:SablotSituation):integer;cdecl;external SAB_LIB;
  // Results Managements
 function SablotFree(resultStr:PAnsiChar):integer;cdecl;external SAB_LIB;
 function SablotGetResultArg(processor_:SablotHandle;argURI:PAnsiChar;argValue:PAnsiChar):integer;cdecl;external SAB_LIB;
 function SablotFreeResultArgs(processor_:SablotHandle):integer;cdecl;external SAB_LIB;
 // Errors Management
 //function SablotGetErrorLine(S:SablotSituation):integer;cdecl;external SAB_LIB; //Non export ?
// function SablotGetErrorMsg(s:SablotSituation):PAnsiChar;cdecl;external SAB_LIB;// Non export ?
 function SablotGetMsgText(code:integer):PAnsiChar;cdecl;external SAB_LIB;
 function SablotClearError(processor_:SablotHandle):integer;cdecl;external SAB_LIB;
 // Handlers
 function SablotRegHandler(processor_:SablotHandle;Htype:SHandlerType;handler:Pointer;userData:pointer):integer;cdecl;external SAB_LIB;
 function SablotUnregHandler(processor_:SablotHandle;Htype:SHandlerType;handler:Pointer;userData:pointer):integer;cdecl;external SAB_LIB;
// Base URI Management
 function SablotSetBase(processor_:SablotHandle;const theBase:PAnsiChar):integer;cdecl;external SAB_LIB;
 function SablotSetBaseForScheme(processor_:SablotHandle;const scheme,base:PAnsiChar):integer;cdecl;external SAB_LIB;
 // Instance Data Management
 procedure SablotSetInstanceData(processor_:SablotHandle;idata:pointer);cdecl;external SAB_LIB;
 function  SablotGetInstanceData(processor_:SablotHandle):pointer;cdecl;external SAB_LIB;
 // SablotProcessor
 function SablotCreateProcessor(P:PProcessor):integer;cdecl;external SAB_LIB;
 function SablotCreateProcessorForSituation(s:SablotSituation;p:PProcessor):integer;cdecl;external SAB_LIB;
 function SablotDestroyProcessor(P:SablotProcessor):integer;cdecl;external SAB_LIB;
 function SablotRunProcessor(P:SablotProcessor;sheetURI,inputURI,resultURI:PAnsiChar;params,arguments:TSParams):integer;cdecl;external SAB_LIB;
 function SablotRunProcessorGen(s:SablotSituation;p:SablotProcessor;sheetURI,inputURI,resultURI:PAnsiChar):integer; cdecl;external SAB_LIB;
 function SablotRunProcessorExt(s:SablotSituation;p:SablotProcessor;sheetURI,inputURI:PAnsiChar;doc:SDomDocument):integer; cdecl;external SAB_LIB;
 function SablotSetLog(processor_:SablotHandle;const logfilename:PAnsiChar;loglevel:integer):integer;cdecl;external SAB_LIB;
// Sablot Shortcuts
 function SablotProcess(sheetURI,inputURI,resultURI:PAnsiChar;params,arguments,resultArg:TSParams):integer;cdecl;external SAB_LIB;
 function SablotProcessFiles(sheetURI,inputURI,resultURI:PAnsiChar):integer;cdecl;external SAB_LIB;
 function SablotProcessStrings(styleSheetStr,inputStr:PAnsiChar;resultStr:PAnsiChar):integer;cdecl;external SAB_LIB;
 function SablotProcessStringsWithBase(styleSheetStr,inputStr,resultStr,theHardBase:PAnsiChar):integer;cdecl;external SAB_LIB;


implementation


end.

