{
/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is the Sablopas : an Object-Pascal wrapper for Sablotron.
 *
 * More infos at http://www.tekool.com/sablopas - Contact : cespern@free.fr
 *
 * The Initial Developer of the Original Code is Christophe ESPERN
 * Portions created by Christophe ESPERN are Copyright (C) 2001-2002 Christophe
 * ESPERN. All Rights Reserved.
 *
 * Contributor(s): None
}



procedure MessageHandlerError(userData:pointer;processor_: SablotHandle;
    code:MH_ERROR;level:MH_LEVEL;var fields:TSErrorFields);cdecl;
var
 msg:Ansistring;
 procedure SabFormatMessage;
 var
  prefix,suffix:Ansistring;
  i:byte;
  locationerror:Ansistring;
 begin
 for i:=low(fields) to High(Fields) do
   if Fields[i]<>nil then begin
    prefix:=copy(fields[i],0,pos(':',fields[i])-1);
    suffix:=copy(fields[i],pos(':',fields[i])+1,length(Ansistring(fields[i]))-1);
      if prefix <>'' then begin
      if prefix='module' then
       msg:=suffix+' : '+msg
      else if prefix='msg' then
       msg:=msg+suffix
      else if prefix='line' then
	locationerror:=locationerror+' at line '+suffix
       else if prefix='URI' then
	locationerror:=' in '+fields[i]+locationerror
       else if prefix='node' then
	locationerror:=' - '+suffix+locationerror
      end
   end
   else
    break;
   msg:=msg+locationerror;
  msg:=msg;
  end;
begin
 try
   if userData<>nil then
    with TSablotEngine(userData) do begin
     SabFormatMessage;
     if Level <> MH_LEVEL_DEBUG then
      FLastError:=msg
     else
      FLastDebug:=msg;
     if (Level <> MH_LEVEL_DEBUG) or  (FShowDebug) then
      DoRaiseEvent(code,level,fields);
    end;
 except
   raise Exception.create('Error in the MessageHandlerError callback function');
 end;
end;

procedure MessageHandlerLog(userData:pointer;processor_: SablotHandle;
    code:MH_ERROR;level:MH_LEVEL;var fields:TSErrorFields);cdecl;
begin
 //
end;

procedure MessageHandlerMakeCode(userData:pointer;processor_:SablotHandle;
            severity,facility,code:integer);cdecl;
begin
 //
end;

function SabSchemeHandlerGetAll(userData:pointer;processor_:SablotHandle;const scheme,rest:PAnsiCHar;var buffer:PAnsiChar;var byteCount:integer):integer;cdecl;
var
 eng:TSablotEngine;
 newScheme,newRest:AnsiString;
 PnewScheme,PnewRest:PAnsiChar;
 i, j:integer;
begin
 eng:=TSablotEngine(userData);

 SetString(newRest, Rest, length(Rest));
 SetString(newScheme, scheme,length(scheme));

 Result:=1;
 // Change the URI if need
 eng.ResolveSabURI(newScheme,newRest);
 eng.RaiseMessage(MH_LEVEL_DEBUG,'Sablopas','Get All Call back : '+newscheme+':'+newrest);
 with eng do
  //Local file
 if CompareText(newScheme,'file')=0 then
  try
   Result:=FileProxy.GetAll(PAnsiChar(newScheme),PAnsiChar(newrest),buffer,bytecount);
  except
   Result:=1;
  end
 //Not a local file
 else begin
  j := ProxyCount;
  try
   for i:=0 to j-1 do
    if Proxies[i].HasScheme(newScheme) then begin
     Result:=Proxies[i].GetAll(PAnsiChar(newscheme),PAnsiChar(newrest),buffer,bytecount);
     if Result<>0 then
       begin
         FTempProxy:=Proxies[i];
       end;
       break;
     end
  except
   Result:=1;
  end;


 end;
end;

function SabSchemeHandlerFreeMemory(userData:pointer;processor_:SablotHandle;var buffer:PAnsiChar):integer;cdecl;
begin
 Result:=1;
 with TSablotEngine(userData) do
 try
   RaiseMessage(MH_LEVEL_DEBUG,'Sablopas','Free Memory Call Back');
   if FTempProxy<>nil then begin
    Result:=FTempProxy.FreeMemory(buffer);
    FTempProxy:=nil;
    buffer := nil;
   end
   else
   begin
    Result:=FileProxy.FreeMemory(buffer);
   end;


 except
   on E:Exception do
    TSablotEngine(UserData).RaiseMessage(MH_LEVEL_ERROR,'Sablopas',E.message);
 end;
end;

function SabSchemeHandlerOpen(userData:TSablotEngine;processor_:SablotHandle;const scheme,rest:PAnsiCHar;var handle:integer):integer;cdecl;
var
 eng:TSablotEngine;
 newscheme,newrest:Ansistring;
 PnewScheme,PnewRest:PAnsiChar;
 i:integer;
begin
 eng:=TSablotEngine(userData);
 //newScheme:=scheme;
 //newRest:=rest;

 SetString(newRest, Rest, length(Rest));
 SetString(newScheme, scheme,length(scheme));

 eng.ResolveSabURI(newScheme,newRest);

 Result:=1;
 handle:=0;
 eng.RaiseMessage(MH_LEVEL_DEBUG,'Sablopas','Open Call Back : '+scheme+':'+rest);
 with eng do
  try
   //Local file
   if CompareText(newScheme,'file')=0 then
    Result:=FileProxy.Open(PAnsiChar(newscheme),PAnsiChar(newrest),handle)
   //Not local file
   else begin
     for i:=0 to ProxyCount-1 do
      if Proxies[i].HasScheme(newScheme) then begin
       Result:=Proxies[i].Open(PAnsiChar(newscheme),PAnsiChar(newrest),handle);
       if Result<>0 then
        break;
      end
    end;
   except
    on E:Exception do
     RaiseMessage(MH_LEVEL_ERROR,'Sablopas',E.message);
   end;
end;

function SabSchemeHandlerGet(userData:pointer;processor_:SablotHandle;handle:integer;var buffer:PAnsiChar;var byteCount:integer):integer;cdecl;
begin
 Result:=1;
 with  TSablotEngine(userData) do
 if GetProxyByHandle(handle)<>nil then
  try
   RaiseMessage(MH_LEVEL_DEBUG,'Sablopas','Get Call Back : handle='+inttostr(handle));
   if GetProxyByHandle(handle)<>nil then
    Result:=GetProxyByHandle(handle).Get(handle,buffer,bytecount);
  except
   on E:Exception do
    RaiseMessage(MH_LEVEL_ERROR,'Sablopas',E.message);
  end
end;

function SabSchemeHandlerPut(userData:pointer;processor_:SablotHandle;handle:integer;const buffer:PAnsiChar;var byteCount:integer):integer;cdecl;
begin
 Result:=1;
 with TSablotEngine(userdata) do
 try
  RaiseMessage(MH_LEVEL_DEBUG,'Sablopas','Put Call back : handle='+inttostr(handle));
  if GetProxyByHandle(handle)<>nil then
    Result:=GetProxyByHandle(handle).Put(handle,buffer,bytecount)
 except
  on E:Exception do
   RaiseMessage(MH_LEVEL_ERROR,'Sablopas',E.message);
 end
end;

function SabSchemeHandlerClose(userData:pointer;processor_:SablotHandle;handle:integer):integer;cdecl;
begin
 Result:=1;
 with TSablotEngine(userdata) do
  try
    RaiseMessage(MH_LEVEL_DEBUG,'Sablopas','Close Call Back : handle='+inttostr(handle));
    if GetProxyByHandle(handle)<>nil then
     Result:=GetProxyByHandle(handle).Close(handle);
  except
  on E:Exception do
   RaiseMessage(MH_LEVEL_ERROR,'Sablopas',E.message);
  end;
end;
