{*********************************************************}
{*                   OVCTAB0.PAS 4.06                    *}
{*********************************************************}

{* ***** BEGIN LICENSE BLOCK *****                                            *}
{* Version: MPL 1.1                                                           *}
{*                                                                            *}
{* The contents of this file are subject to the Mozilla Public License        *}
{* Version 1.1 (the "License"); you may not use this file except in           *}
{* compliance with the License. You may obtain a copy of the License at       *}
{* http://www.mozilla.org/MPL/                                                *}
{*                                                                            *}
{* Software distributed under the License is distributed on an "AS IS" basis, *}
{* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License   *}
{* for the specific language governing rights and limitations under the       *}
{* License.                                                                   *}
{*                                                                            *}
{* The Original Code is TurboPower Orpheus                                    *}
{*                                                                            *}
{* The Initial Developer of the Original Code is TurboPower Software          *}
{*                                                                            *}
{* Portions created by TurboPower Software Inc. are Copyright (C)1995-2002    *}
{* TurboPower Software Inc. All Rights Reserved.                              *}
{*                                                                            *}
{* Contributor(s):                                                            *}
{*                                                                            *}
{* ***** END LICENSE BLOCK *****                                              *}

{$I OVC.INC}

{$B-} {Complete Boolean Evaluation}
{$I+} {Input/Output-Checking}
{$P+} {Open Parameters}
{$T-} {Typed @ Operator}
{.W-} {Windows Stack Frame}
{$X+} {Extended Syntax}

unit ovcnbk0;
  {-component editor for the tab control}

interface

uses
  {$IFDEF VERSION6} DesignIntf, DesignEditors, {$ELSE} DsgnIntf, {$ENDIF}
  Forms, SysUtils, OvcBase, OvcData, OvcNbk, OvcColE0;

type
  TOvcNotebookEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index : Integer);
      override;
    function GetVerb(Index : Integer) : string;
      override;
    function GetVerbCount : Integer;
      override;
  end;


implementation


{*** TOvcNotebookEditor ***}


procedure TOvcNotebookEditor.ExecuteVerb(Index : Integer);
begin
{$IFDEF VERSION5}
  if Index = 0 then
    ShowCollectionEditor(Designer,
                         (Component as TOvcNotebook).PageCollection,
                         IsInInLined);
{$ELSE}
  if Index = 0 then
    ShowCollectionEditor(Designer, (Component as TOvcNotebook).PageCollection);
{$ENDIF}
end;


function TOvcNotebookEditor.GetVerb(Index : Integer) : string;
begin
  Result := 'Edit Pages...';
end;

function TOvcNotebookEditor.GetVerbCount : Integer;
begin
  Result := 1;
end;


end.
