{
HtmlViewer Version 11.5
Copyright (c) 2013-2014 by Bernd Gabriel

This source module is adopted from CodeChangerDecodeMatrix.pas
written by SchwarzKopf-M (SchwarzKopf-M@yandex.ru).

Thanks to SchwarzKopf-M for his extensive work.

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Note that the source modules HTMLGIF1.PAS and DITHERUNIT.PAS
are covered by separate copyright notices located in those modules.
}

//This is the original copyright notice in CodeChangerDecodeMatrix.pas

//This is charset Windows-1251:
//        " ".
//       
//     .
//     - SchwarzKopf-M (SchwarzKopf-M@yandex.ru).
//       
//      .
//      
//      libiconv.
//
//  HTMLViewer (http://code.google.com/p/thtmlviewer)

// Translated by "http://translate.google.de/#ru|en|" it is:
// Text conversion module is freeware and is distributed "as is".
// If you modify or partial use of source code links
// To the original module is required.
// Copyright reserve the - SchwarzKopf-M (SchwarzKopf-M@yandex.ru).
// This module uses the information found on the Internet
// Without affecting the original copyright holder.
// For the conversion of some Asian languages ??used in freestyle
// Interpretation of the source code library libiconv.
//
// Especially for HTMLViewer (http://code.google.com/p/thtmlviewer)

{.$I htmlcons.inc}

unit BuffConvArrays;

interface

uses
  HtmlBuffer;

type
  ThtAnsiCharMap     = array[Byte] of TBuffChar;
  ThtAnsiCharHighMap = array[$80..$FF] of TBuffChar;
  ThtAnsiCharISOMap  = array[$A0..$FF] of TBuffChar;

const
  Windows708Map: ThtAnsiCharHighMap = (
      #$2502, #$2524, #$00E9, #$00E2, #$2561, #$00E0, #$2562, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$2556, #$2555, #$2563,
      #$2551, #$2557, #$255D, #$00F4, #$255C, #$255B, #$00FB, #$00F9,
      #$2510, #$2514, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$F8C1, #$2534, #$252C, #$251C, #$00A4, #$2500, #$253C, #$255E,
      #$255F, #$255A, #$2554, #$2569, #$060C, #$2566, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2560, #$2550, #$256C, #$2567, #$2568,
      #$2564, #$2565, #$2559, #$061B, #$2558, #$2552, #$2553, #$061F,
      #$256B, #$0621, #$0622, #$0623, #$0624, #$0625, #$0626, #$0627,
      #$0628, #$0629, #$062A, #$062B, #$062C, #$062D, #$062E, #$062F,
      #$0630, #$0631, #$0632, #$0633, #$0634, #$0635, #$0636, #$0637,
      #$0638, #$0639, #$063A, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$0640, #$0641, #$0642, #$0643, #$0644, #$0645, #$0646, #$0647,
      #$0648, #$0649, #$064A, #$064B, #$064C, #$064D, #$064E, #$064F,
      #$0650, #$0651, #$0652, #$F8C2, #$F8C3, #$F8C4, #$F8C5, #$F8C6,
      #$F8C7, #$256A, #$2518, #$250C, #$00B5, #$00A3, #$25A0, #$00A0);
  Windows737Map: ThtAnsiCharHighMap = (
      #$0391, #$0392, #$0393, #$0394, #$0395, #$0396, #$0397, #$0398,
      #$0399, #$039A, #$039B, #$039C, #$039D, #$039E, #$039F, #$03A0,
      #$03A1, #$03A3, #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9,
      #$03B1, #$03B2, #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8,
      #$03B9, #$03BA, #$03BB, #$03BC, #$03BD, #$03BE, #$03BF, #$03C0,
      #$03C1, #$03C3, #$03C2, #$03C4, #$03C5, #$03C6, #$03C7, #$03C8,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03C9, #$03AC, #$03AD, #$03AE, #$03CA, #$03AF, #$03CC, #$03CD,
      #$03CB, #$03CE, #$0386, #$0388, #$0389, #$038A, #$038C, #$038E,
      #$038F, #$00B1, #$2265, #$2264, #$03AA, #$03AB, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  Windows775Map: ThtAnsiCharHighMap = (
      #$0106, #$00FC, #$00E9, #$0101, #$00E4, #$0123, #$00E5, #$0107,
      #$0142, #$0113, #$0156, #$0157, #$012B, #$0179, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$014D, #$00F6, #$0122, #$00A2, #$015A,
      #$015B, #$00D6, #$00DC, #$00F8, #$00A3, #$00D8, #$00D7, #$00A4,
      #$0100, #$012A, #$00F3, #$017B, #$017C, #$017A, #$201D, #$00A6,
      #$00A9, #$00AE, #$00AC, #$00BD, #$00BC, #$0141, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$0104, #$010C, #$0118,
      #$0116, #$2563, #$2551, #$2557, #$255D, #$012E, #$0160, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$0172, #$016A,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$017D,
      #$0105, #$010D, #$0119, #$0117, #$012F, #$0161, #$0173, #$016B,
      #$017E, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$00D3, #$00DF, #$014C, #$0143, #$00F5, #$00D5, #$00B5, #$0144,
      #$0136, #$0137, #$013B, #$013C, #$0146, #$0112, #$0145, #$2019,
      #$00AD, #$00B1, #$201C, #$00BE, #$00B6, #$00A7, #$00F7, #$201E,
      #$00B0, #$2219, #$00B7, #$00B9, #$00B3, #$00B2, #$25A0, #$00A0);
  Windows864Map: ThtAnsiCharHighMap = (
      #$00B0, #$00B7, #$2219, #$221A, #$2592, #$2500, #$2502, #$253C,
      #$2524, #$252C, #$251C, #$2534, #$2510, #$250C, #$2514, #$2518,
      #$03B2, #$221E, #$03C6, #$00B1, #$00BD, #$00BC, #$2248, #$00AB,
      #$00BB, #$FEF7, #$FEF8, #$009B, #$009C, #$FEFB, #$FEFC, #$009F,
      #$00A0, #$00AD, #$FE82, #$00A3, #$00A4, #$FE84, #$F8BE, #$F8BF,
      #$FE8E, #$FE8F, #$FE95, #$FE99, #$060C, #$FE9D, #$FEA1, #$FEA5,
      #$0660, #$0661, #$0662, #$0663, #$0664, #$0665, #$0666, #$0667,
      #$0668, #$0669, #$FED1, #$061B, #$FEB1, #$FEB5, #$FEB9, #$061F,
      #$00A2, #$FE80, #$FE81, #$FE83, #$FE85, #$FECA, #$FE8B, #$FE8D,
      #$FE91, #$FE93, #$FE97, #$FE9B, #$FE9F, #$FEA3, #$FEA7, #$FEA9,
      #$FEAB, #$FEAD, #$FEAF, #$FEB3, #$FEB7, #$FEBB, #$FEBF, #$FEC1,
      #$FEC5, #$FECB, #$FECF, #$00A6, #$00AC, #$00F7, #$00D7, #$FEC9,
      #$0640, #$FED3, #$FED7, #$FEDB, #$FEDF, #$FEE3, #$FEE7, #$FEEB,
      #$FEED, #$FEEF, #$FEF3, #$FEBD, #$FECC, #$FECE, #$FECD, #$FEE1,
      #$FE7D, #$0651, #$FEE5, #$FEE9, #$FEEC, #$FEF0, #$FEF2, #$FED0,
      #$FED5, #$FEF5, #$FEF6, #$FEDD, #$FED9, #$FEF1, #$25A0, #$F8C0);
  Windows874Map: ThtAnsiCharHighMap = (
      #$20AC, #$0081, #$0082, #$0083, #$0084, #$2026, #$0086, #$0087,
      #$0088, #$0089, #$008A, #$008B, #$008C, #$008D, #$008E, #$008F,
      #$0090, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014,
      #$0098, #$0099, #$009A, #$009B, #$009C, #$009D, #$009E, #$009F,
      #$00A0, #$0E01, #$0E02, #$0E03, #$0E04, #$0E05, #$0E06, #$0E07,
      #$0E08, #$0E09, #$0E0A, #$0E0B, #$0E0C, #$0E0D, #$0E0E, #$0E0F,
      #$0E10, #$0E11, #$0E12, #$0E13, #$0E14, #$0E15, #$0E16, #$0E17,
      #$0E18, #$0E19, #$0E1A, #$0E1B, #$0E1C, #$0E1D, #$0E1E, #$0E1F,
      #$0E20, #$0E21, #$0E22, #$0E23, #$0E24, #$0E25, #$0E26, #$0E27,
      #$0E28, #$0E29, #$0E2A, #$0E2B, #$0E2C, #$0E2D, #$0E2E, #$0E2F,
      #$0E30, #$0E31, #$0E32, #$0E33, #$0E34, #$0E35, #$0E36, #$0E37,
      #$0E38, #$0E39, #$0E3A, #$F8C1, #$F8C2, #$F8C3, #$F8C4, #$0E3F,
      #$0E40, #$0E41, #$0E42, #$0E43, #$0E44, #$0E45, #$0E46, #$0E47,
      #$0E48, #$0E49, #$0E4A, #$0E4B, #$0E4C, #$0E4D, #$0E4E, #$0E4F,
      #$0E50, #$0E51, #$0E52, #$0E53, #$0E54, #$0E55, #$0E56, #$0E57,
      #$0E58, #$0E59, #$0E5A, #$0E5B, #$F8C5, #$F8C6, #$F8C7, #$F8C8);
  CP437Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$00EC, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9,
      #$00FF, #$00D6, #$00DC, #$00A2, #$00A3, #$00A5, #$20A7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA,
      #$00BF, #$2310, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4,
      #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  CP850Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$00EC, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9,
      #$00FF, #$00D6, #$00DC, #$00F8, #$00A3, #$00D8, #$00D7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA,
      #$00BF, #$00AE, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$00C1, #$00C2, #$00C0,
      #$00A9, #$2563, #$2551, #$2557, #$255D, #$00A2, #$00A5, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$00E3, #$00C3,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$00A4,
      #$00F0, #$00D0, #$00CA, #$00CB, #$00C8, #$0131, #$00CD, #$00CE,
      #$00CF, #$2518, #$250C, #$2588, #$2584, #$00A6, #$00CC, #$2580,
      #$00D3, #$00DF, #$00D4, #$00D2, #$00F5, #$00D5, #$00B5, #$00FE,
      #$00DE, #$00DA, #$00DB, #$00D9, #$00FD, #$00DD, #$00AF, #$00B4,
      #$00AD, #$00B1, #$2017, #$00BE, #$00B6, #$00A7, #$00F7, #$00B8,
      #$00B0, #$00A8, #$00B7, #$00B9, #$00B3, #$00B2, #$25A0, #$00A0);
  CP852Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$016F, #$0107, #$00E7,
      #$0142, #$00EB, #$0150, #$0151, #$00EE, #$0179, #$00C4, #$0106,
      #$00C9, #$0139, #$013A, #$00F4, #$00F6, #$013D, #$013E, #$015A,
      #$015B, #$00D6, #$00DC, #$0164, #$0165, #$0141, #$00D7, #$010D,
      #$00E1, #$00ED, #$00F3, #$00FA, #$0104, #$0105, #$017D, #$017E,
      #$0118, #$0119, #$00AC, #$017A, #$010C, #$015F, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$00C1, #$00C2, #$011A,
      #$015E, #$2563, #$2551, #$2557, #$255D, #$017B, #$017C, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$0102, #$0103,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$00A4,
      #$0111, #$0110, #$010E, #$00CB, #$010F, #$0147, #$00CD, #$00CE,
      #$011B, #$2518, #$250C, #$2588, #$2584, #$0162, #$016E, #$2580,
      #$00D3, #$00DF, #$00D4, #$0143, #$0144, #$0148, #$0160, #$0161,
      #$0154, #$00DA, #$0155, #$0170, #$00FD, #$00DD, #$0163, #$00B4,
      #$00AD, #$02DD, #$02DB, #$02C7, #$02D8, #$00A7, #$00F7, #$00B8,
      #$00B0, #$00A8, #$02D9, #$0171, #$0158, #$0159, #$25A0, #$00A0);
  CP855Map: ThtAnsiCharHighMap = (
      #$0452, #$0402, #$0453, #$0403, #$0451, #$0401, #$0454, #$0404,
      #$0455, #$0405, #$0456, #$0406, #$0457, #$0407, #$0458, #$0408,
      #$0459, #$0409, #$045A, #$040A, #$045B, #$040B, #$045C, #$040C,
      #$045E, #$040E, #$045F, #$040F, #$044E, #$042E, #$044A, #$042A,
      #$0430, #$0410, #$0431, #$0411, #$0446, #$0426, #$0434, #$0414,
      #$0435, #$0415, #$0444, #$0424, #$0433, #$0413, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$0445, #$0425, #$0438,
      #$0418, #$2563, #$2551, #$2557, #$255D, #$0439, #$0419, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$043A, #$041A,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$00A4,
      #$043B, #$041B, #$043C, #$041C, #$043D, #$041D, #$043E, #$041E,
      #$043F, #$2518, #$250C, #$2588, #$2584, #$041F, #$044F, #$2580,
      #$042F, #$0440, #$0420, #$0441, #$0421, #$0442, #$0422, #$0443,
      #$0423, #$0436, #$0416, #$0432, #$0412, #$044C, #$042C, #$2116,
      #$00AD, #$044B, #$042B, #$0437, #$0417, #$0448, #$0428, #$044D,
      #$042D, #$0449, #$0429, #$0447, #$0427, #$00A7, #$25A0, #$00A0);
  CP857Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$0131, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9,
      #$0130, #$00D6, #$00DC, #$00F8, #$00A3, #$00D8, #$015E, #$015F,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$011E, #$011F,
      #$00BF, #$00AE, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$00C1, #$00C2, #$00C0,
      #$00A9, #$2563, #$2551, #$2557, #$255D, #$00A2, #$00A5, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$00E3, #$00C3,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$00A4,
      #$00BA, #$00AA, #$00CA, #$00CB, #$00C8, #$F8BB, #$00CD, #$00CE,
      #$00CF, #$2518, #$250C, #$2588, #$2584, #$00A6, #$00CC, #$2580,
      #$00D3, #$00DF, #$00D4, #$00D2, #$00F5, #$00D5, #$00B5, #$F8BC,
      #$00D7, #$00DA, #$00DB, #$00D9, #$00EC, #$00FF, #$00AF, #$00B4,
      #$00AD, #$00B1, #$F8BD, #$00BE, #$00B6, #$00A7, #$00F7, #$00B8,
      #$00B0, #$00A8, #$00B7, #$00B9, #$00B3, #$00B2, #$25A0, #$00A0);
  CP865Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$00EC, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9,
      #$00FF, #$00D6, #$00DC, #$00F8, #$00A3, #$00D8, #$20A7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA,
      #$00BF, #$2310, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00A4,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4,
      #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  CP866Map: ThtAnsiCharHighMap = (
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0416, #$0417,
      #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E, #$041F,
      #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427,
      #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E, #$042F,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0436, #$0437,
      #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447,
      #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$044F,
      #$0401, #$0451, #$0404, #$0454, #$0407, #$0457, #$040E, #$045E,
      #$00B0, #$2219, #$00B7, #$221A, #$2116, #$00A4, #$25A0, #$00A0);
  CP869Map: ThtAnsiCharHighMap = (
      #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$FFFF, #$0386, #$FFFF,
      #$00B7, #$00AC, #$00A6, #$2018, #$2019, #$0388, #$2015, #$0389,
      #$038A, #$03AA, #$038C, #$FFFF, #$FFFF, #$038E, #$03AB, #$00A9,
      #$038F, #$00B2, #$00B3, #$03AC, #$00A3, #$03AD, #$03AE, #$03AF,
      #$03CA, #$0390, #$03CC, #$03CD, #$0391, #$0392, #$0393, #$0394,
      #$0395, #$0396, #$0397, #$00BD, #$0398, #$0399, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$039A, #$039B, #$039C,
      #$039D, #$2563, #$2551, #$2557, #$255D, #$039E, #$039F, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$03A0, #$03A1,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$03A3,
      #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9, #$03B1, #$03B2,
      #$03B3, #$2518, #$250C, #$2588, #$2584, #$03B4, #$03B5, #$2580,
      #$03B6, #$03B7, #$03B8, #$03B9, #$03BA, #$03BB, #$03BC, #$03BD,
      #$03BE, #$03BF, #$03C0, #$03C1, #$03C3, #$03C2, #$03C4, #$0384,
      #$00AD, #$00B1, #$03C5, #$03C6, #$03C7, #$00A7, #$03C8, #$0385,
      #$00B0, #$00A8, #$03C9, #$03CB, #$03B0, #$03CE, #$25A0, #$00A0);
  CP922_1Map: array[0..15] of TBuffChar = (
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7,
      #$00A8, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$203E);
  CP922_2Map: array[0..15] of TBuffChar = (
      #$0160, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$00D7,
      #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$00DD, #$017D, #$00DF);
  CP922_3Map: array[0..15] of TBuffChar = (
      #$0161, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$00F7,
      #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$00FD, #$017E, #$00FF);
  CP1124Map: array[0..95] of TBuffChar = (
      #$00A0, #$0401, #$0402, #$0490, #$0404, #$0405, #$0406, #$0407,
      #$0408, #$0409, #$040A, #$040B, #$040C, #$00AD, #$040E, #$040F,
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0416, #$0417,
      #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E, #$041F,
      #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427,
      #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E, #$042F,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0436, #$0437,
      #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447,
      #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$044F,
      #$2116, #$0451, #$0452, #$0491, #$0454, #$0455, #$0456, #$0457,
      #$0458, #$0459, #$045A, #$045B, #$045C, #$00A7, #$045E, #$045F);
  CP1125Map: array[0..79] of TBuffChar = (
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447,
      #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$044F,
      #$0401, #$0451, #$0490, #$0491, #$0404, #$0454, #$0406, #$0456,
      #$0407, #$0457, #$00B7, #$221A, #$2116, #$00A4, #$25A0, #$00A0);
  CP1129Map: array[0..95] of TBuffChar = (
      #$00A0, #$00A1, #$00A2, #$00A3, #$00A4, #$00A5, #$00A6, #$00A7,
      #$0153, #$00A9, #$00AA, #$00AB, #$00AC, #$00AD, #$00AE, #$00AF,
      #$00B0, #$00B1, #$00B2, #$00B3, #$0178, #$00B5, #$00B6, #$00B7,
      #$0152, #$00B9, #$00BA, #$00BB, #$00BC, #$00BD, #$00BE, #$00BF,
      #$00C0, #$00C1, #$00C2, #$0102, #$00C4, #$00C5, #$00C6, #$00C7,
      #$00C8, #$00C9, #$00CA, #$00CB, #$0300, #$00CD, #$00CE, #$00CF,
      #$0110, #$00D1, #$0309, #$00D3, #$00D4, #$01A0, #$00D6, #$00D7,
      #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$01AF, #$0303, #$00DF,
      #$00E0, #$00E1, #$00E2, #$0103, #$00E4, #$00E5, #$00E6, #$00E7,
      #$00E8, #$00E9, #$00EA, #$00EB, #$0301, #$00ED, #$00EE, #$00EF,
      #$0111, #$00F1, #$0323, #$00F3, #$00F4, #$01A1, #$00F6, #$00F7,
      #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$01B0, #$20AB, #$00FF);
  IBM860Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E3, #$00E0, #$00C1, #$00E7,
      #$00EA, #$00CA, #$00E8, #$00CD, #$00D4, #$00EC, #$00C3, #$00C2,
      #$00C9, #$00C0, #$00C8, #$00F4, #$00F5, #$00F2, #$00DA, #$00F9,
      #$00CC, #$00D5, #$00DC, #$00A2, #$00A3, #$00D9, #$20A7, #$00D3,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA,
      #$00BF, #$00D2, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4,
      #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  CP861Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00D0, #$00F0, #$00DE, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00FE, #$00FB, #$00DD,
      #$00FD, #$00D6, #$00DC, #$00F8, #$00A3, #$00D8, #$20A7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00C1, #$00CD, #$00D3, #$00DA,
      #$00BF, #$2310, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4,
      #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  CP862Map: ThtAnsiCharHighMap = (
      #$05D0, #$05D1, #$05D2, #$05D3, #$05D4, #$05D5, #$05D6, #$05D7,
      #$05D8, #$05D9, #$05DA, #$05DB, #$05DC, #$05DD, #$05DE, #$05DF,
      #$05E0, #$05E1, #$05E2, #$05E3, #$05E4, #$05E5, #$05E6, #$05E7,
      #$05E8, #$05E9, #$05EA, #$00A2, #$00A3, #$00A5, #$20A7, #$0192,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$00AA, #$00BA,
      #$00BF, #$2310, #$00AC, #$00BD, #$00BC, #$00A1, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4,
      #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  CP863Map: ThtAnsiCharHighMap = (
      #$00C7, #$00FC, #$00E9, #$00E2, #$00C2, #$00E0, #$00B6, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$2017, #$00C0, #$00A7,
      #$00C9, #$00C8, #$00CA, #$00F4, #$00CB, #$00CF, #$00FB, #$00F9,
      #$00A4, #$00D4, #$00DC, #$00A2, #$00A3, #$00D9, #$00DB, #$0192,
      #$00A6, #$00B4, #$00F3, #$00FA, #$00A8, #$00B8, #$00B3, #$00AF,
      #$00CE, #$2310, #$00AC, #$00BD, #$00BC, #$00BE, #$00AB, #$00BB,
      #$2591, #$2592, #$2593, #$2502, #$2524, #$2561, #$2562, #$2556,
      #$2555, #$2563, #$2551, #$2557, #$255D, #$255C, #$255B, #$2510,
      #$2514, #$2534, #$252C, #$251C, #$2500, #$253C, #$255E, #$255F,
      #$255A, #$2554, #$2569, #$2566, #$2560, #$2550, #$256C, #$2567,
      #$2568, #$2564, #$2565, #$2559, #$2558, #$2552, #$2553, #$256B,
      #$256A, #$2518, #$250C, #$2588, #$2584, #$258C, #$2590, #$2580,
      #$03B1, #$00DF, #$0393, #$03C0, #$03A3, #$03C3, #$00B5, #$03C4,
      #$03A6, #$0398, #$03A9, #$03B4, #$221E, #$03C6, #$03B5, #$2229,
      #$2261, #$00B1, #$2265, #$2264, #$2320, #$2321, #$00F7, #$2248,
      #$00B0, #$2219, #$00B7, #$221A, #$207F, #$00B2, #$25A0, #$00A0);
  IBM864Map: array[$25..$FF] of TBuffChar = (
      #$FFFF, #$0026, #$0027, #$0028, #$0029, #$002A, #$002B, #$002C,
      #$002D, #$002E, #$002F, #$0030, #$0031, #$0032, #$0033, #$0034,
      #$0035, #$0036, #$0037, #$0038, #$0039, #$003A, #$003B, #$003C,
      #$003D, #$003E, #$003F, #$0040, #$0041, #$0042, #$0043, #$0044,
      #$0045, #$0046, #$0047, #$0048, #$0049, #$004A, #$004B, #$004C,
      #$004D, #$004E, #$004F, #$0050, #$0051, #$0052, #$0053, #$0054,
      #$0055, #$0056, #$0057, #$0058, #$0059, #$005A, #$005B, #$005C,
      #$005D, #$005E, #$005F, #$0060, #$0061, #$0062, #$0063, #$0064,
      #$0065, #$0066, #$0067, #$0068, #$0069, #$006A, #$006B, #$006C,
      #$006D, #$006E, #$006F, #$0070, #$0071, #$0072, #$0073, #$0074,
      #$0075, #$0076, #$0077, #$0078, #$0079, #$007A, #$007B, #$007C,
      #$007D, #$007E, #$007F, #$00B0, #$00B7, #$2219, #$221A, #$2592,
      #$2500, #$2502, #$253C, #$2524, #$252C, #$251C, #$2534, #$2510,
      #$250C, #$2514, #$2518, #$03B2, #$221E, #$03C6, #$00B1, #$00BD,
      #$00BC, #$2248, #$00AB, #$00BB, #$FEF7, #$FEF8, #$FFFF, #$FFFF,
      #$FEFB, #$FEFC, #$FFFF, #$00A0, #$00AD, #$FE82, #$00A3, #$00A4,
      #$FE84, #$FFFF, #$FFFF, #$FE8E, #$FE8F, #$FE95, #$FE99, #$060C,
      #$FE9D, #$FEA1, #$FEA5, #$0660, #$0661, #$0662, #$0663, #$0664,
      #$0665, #$0666, #$0667, #$0668, #$0669, #$FED1, #$061B, #$FEB1,
      #$FEB5, #$FEB9, #$061F, #$00A2, #$FFFF, #$FFFF, #$FFFF, #$FFFF,
      #$FECA, #$FFFF, #$FE8D, #$FE91, #$FE93, #$FE97, #$FE9B, #$FE9F,
      #$FEA3, #$FEA7, #$FEA9, #$FEAB, #$FEAD, #$FEAF, #$FEB3, #$FEB7,
      #$FEBB, #$FEBF, #$FEC1, #$FEC5, #$FECB, #$FECF, #$00A6, #$00AC,
      #$00F7, #$00D7, #$FEC9, #$0640, #$FED3, #$FED7, #$FEDB, #$FEDF,
      #$FEE3, #$FEE7, #$FEEB, #$FEED, #$FEEF, #$FEF3, #$FEBD, #$FECC,
      #$FECE, #$FECD, #$FEE1, #$FE7D, #$0651, #$FEE5, #$FEE9, #$FEEC,
      #$FEF0, #$FEF2, #$FED0, #$FED5, #$FEF5, #$FEF6, #$FEDD, #$FED9,
      #$FEF1, #$25A0, #$FFFF);
  CP932E_1Map: array[0..91] of TBuffChar = (
      #$2460, #$2461, #$2462, #$2463, #$2464, #$2465, #$2466, #$2467,
      #$2468, #$2469, #$246A, #$246B, #$246C, #$246D, #$246E, #$246F,
      #$2470, #$2471, #$2472, #$2473, #$2160, #$2161, #$2162, #$2163,
      #$2164, #$2165, #$2166, #$2167, #$2168, #$2169, #$FFFD, #$3349,
      #$3314, #$3322, #$334D, #$3318, #$3327, #$3303, #$3336, #$3351,
      #$3357, #$330D, #$3326, #$3323, #$332B, #$334A, #$333B, #$339C,
      #$339D, #$339E, #$338E, #$338F, #$33C4, #$33A1, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$337B, #$301D,
      #$301F, #$2116, #$33CD, #$2121, #$32A4, #$32A5, #$32A6, #$32A7,
      #$32A8, #$3231, #$3232, #$3239, #$337E, #$337D, #$337C, #$2252,
      #$2261, #$222B, #$222E, #$2211, #$221A, #$22A5, #$2220, #$221F,
      #$22BF, #$2235, #$2229, #$222A);
  CP932E_2Map: array[0..375] of TBuffChar = (
      #$7E8A, #$891C, #$9348, #$9288, #$84DC, #$4FC9, #$70BB, #$6631,
      #$68C8, #$92F9, #$66FB, #$5F45, #$4E28, #$4EE1, #$4EFC, #$4F00,
      #$4F03, #$4F39, #$4F56, #$4F92, #$4F8A, #$4F9A, #$4F94, #$4FCD,
      #$5040, #$5022, #$4FFF, #$501E, #$5046, #$5070, #$5042, #$5094,
      #$50F4, #$50D8, #$514A, #$5164, #$519D, #$51BE, #$51EC, #$5215,
      #$529C, #$52A6, #$52C0, #$52DB, #$5300, #$5307, #$5324, #$5372,
      #$5393, #$53B2, #$53DD, #$FA0E, #$549C, #$548A, #$54A9, #$54FF,
      #$5586, #$5759, #$5765, #$57AC, #$57C8, #$57C7, #$FA0F, #$FA10,
      #$589E, #$58B2, #$590B, #$5953, #$595B, #$595D, #$5963, #$59A4,
      #$59BA, #$5B56, #$5BC0, #$752F, #$5BD8, #$5BEC, #$5C1E, #$5CA6,
      #$5CBA, #$5CF5, #$5D27, #$5D53, #$FA11, #$5D42, #$5D6D, #$5DB8,
      #$5DB9, #$5DD0, #$5F21, #$5F34, #$5F67, #$5FB7, #$5FDE, #$605D,
      #$6085, #$608A, #$60DE, #$60D5, #$6120, #$60F2, #$6111, #$6137,
      #$6130, #$6198, #$6213, #$62A6, #$63F5, #$6460, #$649D, #$64CE,
      #$654E, #$6600, #$6615, #$663B, #$6609, #$662E, #$661E, #$6624,
      #$6665, #$6657, #$6659, #$FA12, #$6673, #$6699, #$66A0, #$66B2,
      #$66BF, #$66FA, #$670E, #$F929, #$6766, #$67BB, #$6852, #$67C0,
      #$6801, #$6844, #$68CF, #$FA13, #$6968, #$FA14, #$6998, #$69E2,
      #$6A30, #$6A6B, #$6A46, #$6A73, #$6A7E, #$6AE2, #$6AE4, #$6BD6,
      #$6C3F, #$6C5C, #$6C86, #$6C6F, #$6CDA, #$6D04, #$6D87, #$6D6F,
      #$6D96, #$6DAC, #$6DCF, #$6DF8, #$6DF2, #$6DFC, #$6E39, #$6E5C,
      #$6E27, #$6E3C, #$6EBF, #$6F88, #$6FB5, #$6FF5, #$7005, #$7007,
      #$7028, #$7085, #$70AB, #$710F, #$7104, #$715C, #$7146, #$7147,
      #$FA15, #$71C1, #$71FE, #$72B1,
      #$72BE, #$7324, #$FA16, #$7377, #$73BD, #$73C9, #$73D6, #$73E3,
      #$73D2, #$7407, #$73F5, #$7426, #$742A, #$7429, #$742E, #$7462,
      #$7489, #$749F, #$7501, #$756F, #$7682, #$769C, #$769E, #$769B,
      #$76A6, #$FA17, #$7746, #$52AF, #$7821, #$784E, #$7864, #$787A,
      #$7930, #$FA18, #$FA19, #$FA1A, #$7994, #$FA1B, #$799B, #$7AD1,
      #$7AE7, #$FA1C, #$7AEB, #$7B9E, #$FA1D, #$7D48, #$7D5C, #$7DB7,
      #$7DA0, #$7DD6, #$7E52, #$7F47, #$7FA1, #$FA1E, #$8301, #$8362,
      #$837F, #$83C7, #$83F6, #$8448, #$84B4, #$8553, #$8559, #$856B,
      #$FA1F, #$85B0, #$FA20, #$FA21, #$8807, #$88F5, #$8A12, #$8A37,
      #$8A79, #$8AA7, #$8ABE, #$8ADF, #$FA22, #$8AF6, #$8B53, #$8B7F,
      #$8CF0, #$8CF4, #$8D12, #$8D76, #$FA23, #$8ECF, #$FA24, #$FA25,
      #$9067, #$90DE, #$FA26, #$9115, #$9127, #$91DA, #$91D7, #$91DE,
      #$91ED, #$91EE, #$91E4, #$91E5, #$9206, #$9210, #$920A, #$923A,
      #$9240, #$923C, #$924E, #$9259, #$9251, #$9239, #$9267, #$92A7,
      #$9277, #$9278, #$92E7, #$92D7, #$92D9, #$92D0, #$FA27, #$92D5,
      #$92E0, #$92D3, #$9325, #$9321, #$92FB, #$FA28, #$931E, #$92FF,
      #$931D, #$9302, #$9370, #$9357, #$93A4, #$93C6, #$93DE, #$93F8,
      #$9431, #$9445, #$9448, #$9592, #$F9DC, #$FA29, #$969D, #$96AF,
      #$9733, #$973B, #$9743, #$974D, #$974F, #$9751, #$9755, #$9857,
      #$9865, #$FA2A, #$FA2B, #$9927, #$FA2C, #$999E, #$9A4E, #$9AD9,
      #$9ADC, #$9B75, #$9B72, #$9B8F, #$9BB1, #$9BBB, #$9C00, #$9D70,
      #$9D6B, #$FA2D, #$9E19, #$9ED1, #$FFFD, #$FFFD, #$2170, #$2171,
      #$2172, #$2173, #$2174, #$2175, #$2176, #$2177, #$2178, #$2179,
      #$FFE2, #$FFE4, #$FF07, #$FF02);
  CP932E_3Map: array[0..387] of TBuffChar = (
      #$2170, #$2171, #$2172, #$2173, #$2174, #$2175, #$2176, #$2177,
      #$2178, #$2179, #$2160, #$2161, #$2162, #$2163, #$2164, #$2165,
      #$2166, #$2167, #$2168, #$2169, #$FFE2, #$FFE4, #$FF07, #$FF02,
      #$3231, #$2116, #$2121, #$2235, #$7E8A, #$891C, #$9348, #$9288,
      #$84DC, #$4FC9, #$70BB, #$6631, #$68C8, #$92F9, #$66FB, #$5F45,
      #$4E28, #$4EE1, #$4EFC, #$4F00, #$4F03, #$4F39, #$4F56, #$4F92,
      #$4F8A, #$4F9A, #$4F94, #$4FCD, #$5040, #$5022, #$4FFF, #$501E,
      #$5046, #$5070, #$5042, #$5094, #$50F4, #$50D8, #$514A, #$5164,
      #$519D, #$51BE, #$51EC, #$5215, #$529C, #$52A6, #$52C0, #$52DB,
      #$5300, #$5307, #$5324, #$5372, #$5393, #$53B2, #$53DD, #$FA0E,
      #$549C, #$548A, #$54A9, #$54FF, #$5586, #$5759, #$5765, #$57AC,
      #$57C8, #$57C7, #$FA0F, #$FA10, #$589E, #$58B2, #$590B, #$5953,
      #$595B, #$595D, #$5963, #$59A4, #$59BA, #$5B56, #$5BC0, #$752F,
      #$5BD8, #$5BEC, #$5C1E, #$5CA6, #$5CBA, #$5CF5, #$5D27, #$5D53,
      #$FA11, #$5D42, #$5D6D, #$5DB8, #$5DB9, #$5DD0, #$5F21, #$5F34,
      #$5F67, #$5FB7, #$5FDE, #$605D, #$6085, #$608A, #$60DE, #$60D5,
      #$6120, #$60F2, #$6111, #$6137, #$6130, #$6198, #$6213, #$62A6,
      #$63F5, #$6460, #$649D, #$64CE, #$654E, #$6600, #$6615, #$663B,
      #$6609, #$662E, #$661E, #$6624, #$6665, #$6657, #$6659, #$FA12,
      #$6673, #$6699, #$66A0, #$66B2, #$66BF, #$66FA, #$670E, #$F929,
      #$6766, #$67BB, #$6852, #$67C0, #$6801, #$6844, #$68CF, #$FA13,
      #$6968, #$FA14, #$6998, #$69E2, #$6A30, #$6A6B, #$6A46, #$6A73,
      #$6A7E, #$6AE2, #$6AE4, #$6BD6, #$6C3F, #$6C5C, #$6C86, #$6C6F,
      #$6CDA, #$6D04, #$6D87, #$6D6F,
      #$6D96, #$6DAC, #$6DCF, #$6DF8, #$6DF2, #$6DFC, #$6E39, #$6E5C,
      #$6E27, #$6E3C, #$6EBF, #$6F88, #$6FB5, #$6FF5, #$7005, #$7007,
      #$7028, #$7085, #$70AB, #$710F, #$7104, #$715C, #$7146, #$7147,
      #$FA15, #$71C1, #$71FE, #$72B1, #$72BE, #$7324, #$FA16, #$7377,
      #$73BD, #$73C9, #$73D6, #$73E3, #$73D2, #$7407, #$73F5, #$7426,
      #$742A, #$7429, #$742E, #$7462, #$7489, #$749F, #$7501, #$756F,
      #$7682, #$769C, #$769E, #$769B, #$76A6, #$FA17, #$7746, #$52AF,
      #$7821, #$784E, #$7864, #$787A, #$7930, #$FA18, #$FA19, #$FA1A,
      #$7994, #$FA1B, #$799B, #$7AD1, #$7AE7, #$FA1C, #$7AEB, #$7B9E,
      #$FA1D, #$7D48, #$7D5C, #$7DB7, #$7DA0, #$7DD6, #$7E52, #$7F47,
      #$7FA1, #$FA1E, #$8301, #$8362, #$837F, #$83C7, #$83F6, #$8448,
      #$84B4, #$8553, #$8559, #$856B, #$FA1F, #$85B0, #$FA20, #$FA21,
      #$8807, #$88F5, #$8A12, #$8A37, #$8A79, #$8AA7, #$8ABE, #$8ADF,
      #$FA22, #$8AF6, #$8B53, #$8B7F, #$8CF0, #$8CF4, #$8D12, #$8D76,
      #$FA23, #$8ECF, #$FA24, #$FA25, #$9067, #$90DE, #$FA26, #$9115,
      #$9127, #$91DA, #$91D7, #$91DE, #$91ED, #$91EE, #$91E4, #$91E5,
      #$9206, #$9210, #$920A, #$923A, #$9240, #$923C, #$924E, #$9259,
      #$9251, #$9239, #$9267, #$92A7, #$9277, #$9278, #$92E7, #$92D7,
      #$92D9, #$92D0, #$FA27, #$92D5, #$92E0, #$92D3, #$9325, #$9321,
      #$92FB, #$FA28, #$931E, #$92FF, #$931D, #$9302, #$9370, #$9357,
      #$93A4, #$93C6, #$93DE, #$93F8, #$9431, #$9445, #$9448, #$9592,
      #$F9DC, #$FA29, #$969D, #$96AF, #$9733, #$973B, #$9743, #$974D,
      #$974F, #$9751, #$9755, #$9857, #$9865, #$FA2A, #$FA2B, #$9927,
      #$FA2C, #$999E, #$9A4E, #$9AD9,
      #$9ADC, #$9B75, #$9B72, #$9B8F, #$9BB1, #$9BBB, #$9C00, #$9D70,
      #$9D6B, #$FA2D, #$9E19, #$9ED1);
  CP936E_1Map: array[0..21] of TBuffChar = (
      #$FE35, #$FE36, #$FE39, #$FE3A, #$FE3F, #$FE40, #$FE3D, #$FE3E,
      #$FE41, #$FE42, #$FE43, #$FE44, #$FFFD, #$FFFD, #$FE3B, #$FE3C,
      #$FE37, #$FE38, #$FE31, #$FFFD, #$FE33, #$FE34);
  CP936E_2Map: array[0..5] of TBuffChar = (
      #$0251, #$FFFD, #$0144, #$0148, #$FFFD, #$0261);
  CP950Map: array[0..313] of TBuffChar = (
      #$3000, #$FF0C, #$3001, #$3002, #$FF0E, #$2027, #$FF1B, #$FF1A,
      #$FF1F, #$FF01, #$FE30, #$2026, #$2025, #$FE50, #$FE51, #$FE52,
      #$00B7, #$FE54, #$FE55, #$FE56, #$FE57, #$FF5C, #$2013, #$FE31,
      #$2014, #$FE33, #$2574, #$FE34, #$FE4F, #$FF08, #$FF09, #$FE35,
      #$FE36, #$FF5B, #$FF5D, #$FE37, #$FE38, #$3014, #$3015, #$FE39,
      #$FE3A, #$3010, #$3011, #$FE3B, #$FE3C, #$300A, #$300B, #$FE3D,
      #$FE3E, #$3008, #$3009, #$FE3F, #$FE40, #$300C, #$300D, #$FE41,
      #$FE42, #$300E, #$300F, #$FE43, #$FE44, #$FE59, #$FE5A, #$FE5B,
      #$FE5C, #$FE5D, #$FE5E, #$2018, #$2019, #$201C, #$201D, #$301D,
      #$301E, #$2035, #$2032, #$FF03, #$FF06, #$FF0A, #$203B, #$00A7,
      #$3003, #$25CB, #$25CF, #$25B3, #$25B2, #$25CE, #$2606, #$2605,
      #$25C7, #$25C6, #$25A1, #$25A0, #$25BD, #$25BC, #$32A3, #$2105,
      #$00AF, #$FFE3, #$FF3F, #$02CD, #$FE49, #$FE4A, #$FE4D, #$FE4E,
      #$FE4B, #$FE4C, #$FE5F, #$FE60, #$FE61, #$FF0B, #$FF0D, #$00D7,
      #$00F7, #$00B1, #$221A, #$FF1C, #$FF1E, #$FF1D, #$2266, #$2267,
      #$2260, #$221E, #$2252, #$2261, #$FE62, #$FE63, #$FE64, #$FE65,
      #$FE66, #$FF5E, #$2229, #$222A, #$22A5, #$2220, #$221F, #$22BF,
      #$33D2, #$33D1, #$222B, #$222E, #$2235, #$2234, #$2640, #$2642,
      #$2295, #$2299, #$2191, #$2193, #$2190, #$2192, #$2196, #$2197,
      #$2199, #$2198, #$2225, #$2223, #$FF0F,
      #$FF3C, #$2215, #$FE68, #$FF04, #$FFE5, #$3012, #$FFE0, #$FFE1,
      #$FF05, #$FF20, #$2103, #$2109, #$FE69, #$FE6A, #$FE6B, #$33D5,
      #$339C, #$339D, #$339E, #$33CE, #$33A1, #$338E, #$338F, #$33C4,
      #$00B0, #$5159, #$515B, #$515E, #$515D, #$5161, #$5163, #$55E7,
      #$74E9, #$7CCE, #$2581, #$2582, #$2583, #$2584, #$2585, #$2586,
      #$2587, #$2588, #$258F, #$258E, #$258D, #$258C, #$258B, #$258A,
      #$2589, #$253C, #$2534, #$252C, #$2524, #$251C, #$2594, #$2500,
      #$2502, #$2595, #$250C, #$2510, #$2514, #$2518, #$256D, #$256E,
      #$2570, #$256F, #$2550, #$255E, #$256A, #$2561, #$25E2, #$25E3,
      #$25E5, #$25E4, #$2571, #$2572, #$2573, #$FF10, #$FF11, #$FF12,
      #$FF13, #$FF14, #$FF15, #$FF16, #$FF17, #$FF18, #$FF19, #$2160,
      #$2161, #$2162, #$2163, #$2164, #$2165, #$2166, #$2167, #$2168,
      #$2169, #$3021, #$3022, #$3023, #$3024, #$3025, #$3026, #$3027,
      #$3028, #$3029, #$5341, #$5344, #$5345, #$FF21, #$FF22, #$FF23,
      #$FF24, #$FF25, #$FF26, #$FF27, #$FF28, #$FF29, #$FF2A, #$FF2B,
      #$FF2C, #$FF2D, #$FF2E, #$FF2F, #$FF30, #$FF31, #$FF32, #$FF33,
      #$FF34, #$FF35, #$FF36, #$FF37, #$FF38, #$FF39, #$FF3A, #$FF41,
      #$FF42, #$FF43, #$FF44, #$FF45, #$FF46, #$FF47, #$FF48, #$FF49,
      #$FF4A, #$FF4B, #$FF4C, #$FF4D, #$FF4E, #$FF4F, #$FF50, #$FF51,
      #$FF52, #$FF53, #$FF54, #$FF55, #$FF56);
  CP950EMap: array[0..157 - 116 - 1] of TBuffChar = (
      #$7881, #$92B9, #$88CF, #$58BB,
      #$6052, #$7CA7, #$5AFA, #$2554, #$2566, #$2557, #$2560, #$256C,
      #$2563, #$255A, #$2569, #$255D, #$2552, #$2564, #$2555, #$255E,
      #$256A, #$2561, #$2558, #$2567, #$255B, #$2553, #$2565, #$2556,
      #$255F, #$256B, #$2562, #$2559, #$2568, #$255C, #$2551, #$2550,
      #$256D, #$256E, #$2570, #$256F, #$2593);
  MacCentralEuropeMap: ThtAnsiCharHighMap = (
      #$00C4, #$0100, #$0101, #$00C9, #$0104, #$00D6, #$00DC, #$00E1,
      #$0105, #$010C, #$00E4, #$010D, #$0106, #$0107, #$00E9, #$0179,
      #$017A, #$010E, #$00ED, #$010F, #$0112, #$0113, #$0116, #$00F3,
      #$0117, #$00F4, #$00F6, #$00F5, #$00FA, #$011A, #$011B, #$00FC,
      #$2020, #$00B0, #$0118, #$00A3, #$00A7, #$2022, #$00B6, #$00DF,
      #$00AE, #$00A9, #$2122, #$0119, #$00A8, #$2260, #$0123, #$012E,
      #$012F, #$012A, #$2264, #$2265, #$012B, #$0136, #$2202, #$2211,
      #$0142, #$013B, #$013C, #$013D, #$013E, #$0139, #$013A, #$0145,
      #$0146, #$0143, #$00AC, #$221A, #$0144, #$0147, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$0148, #$0150, #$00D5, #$0151, #$014C,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$25CA,
      #$014D, #$0154, #$0155, #$0158, #$2039, #$203A, #$0159, #$0156,
      #$0157, #$0160, #$201A, #$201E, #$0161, #$015A, #$015B, #$00C1,
      #$0164, #$0165, #$00CD, #$017D, #$017E, #$016A, #$00D3, #$00D4,
      #$016B, #$016E, #$00DA, #$016F, #$0170, #$0171, #$0172, #$0173,
      #$00DD, #$00FD, #$0137, #$017B, #$0141, #$017C, #$0122, #$02C7);
  MacRomanMap: ThtAnsiCharHighMap = (
      #$00C4, #$00C5, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$00E3, #$00E5, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$00EC, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00F2, #$00F4, #$00F6, #$00F5, #$00FA, #$00F9, #$00FB, #$00FC,
      #$2020, #$00B0, #$00A2, #$00A3, #$00A7, #$2022, #$00B6, #$00DF,
      #$00AE, #$00A9, #$2122, #$00B4, #$00A8, #$2260, #$00C6, #$00D8,
      #$221E, #$00B1, #$2264, #$2265, #$00A5, #$00B5, #$2202, #$2211,
      #$220F, #$03C0, #$222B, #$00AA, #$00BA, #$2126, #$00E6, #$00F8,
      #$00BF, #$00A1, #$00AC, #$221A, #$0192, #$2248, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$00C0, #$00C3, #$00D5, #$0152, #$0153,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$25CA,
      #$00FF, #$0178, #$2044, #$00A4, #$2039, #$203A, #$FB01, #$FB02,
      #$2021, #$00B7, #$201A, #$201E, #$2030, #$00C2, #$00CA, #$00C1,
      #$00CB, #$00C8, #$00CD, #$00CE, #$00CF, #$00CC, #$00D3, #$00D4,
      #$FFFF, #$00D2, #$00DA, #$00DB, #$00D9, #$0131, #$02C6, #$02DC,
      #$00AF, #$02D8, #$02D9, #$02DA, #$00B8, #$02DD, #$02DB, #$02C7);
  MacCyrillicMap: ThtAnsiCharHighMap = (
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0416, #$0417,
      #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E, #$041F,
      #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427,
      #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E, #$042F,
      #$2020, #$00B0, #$00A2, #$00A3, #$00A7, #$2022, #$00B6, #$0406,
      #$00AE, #$00A9, #$2122, #$0402, #$0452, #$2260, #$0403, #$0453,
      #$221E, #$00B1, #$2264, #$2265, #$0456, #$00B5, #$2202, #$0408,
      #$0404, #$0454, #$0407, #$0457, #$0409, #$0459, #$040A, #$045A,
      #$0458, #$0405, #$00AC, #$221A, #$0192, #$2248, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$040B, #$045B, #$040C, #$045C, #$0455,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$201E,
      #$040E, #$045E, #$040F, #$045F, #$2116, #$0401, #$0451, #$044F,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0436, #$0437,
      #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447,
      #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$00A4);
  MacGreekMap: ThtAnsiCharHighMap = (
      #$00C4, #$00B9, #$00B2, #$00C9, #$00B3, #$00D6, #$00DC, #$0385,
      #$00E0, #$00E2, #$00E4, #$0384, #$00A8, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00A3, #$2122, #$00EE, #$00EF, #$2022, #$00BD,
      #$2030, #$00F4, #$00F6, #$00A6, #$00AD, #$00F9, #$00FB, #$00FC,
      #$2020, #$0393, #$0394, #$0398, #$039B, #$039E, #$03A0, #$00DF,
      #$00AE, #$00A9, #$03A3, #$03AA, #$00A7, #$2260, #$00B0, #$0387,
      #$0391, #$00B1, #$2264, #$2265, #$00A5, #$0392, #$0395, #$0396,
      #$0397, #$0399, #$039A, #$039C, #$03A6, #$03AB, #$03A8, #$03A9,
      #$03AC, #$039D, #$00AC, #$039F, #$03A1, #$2248, #$03A4, #$00AB,
      #$00BB, #$2026, #$00A0, #$03A5, #$03A7, #$0386, #$0388, #$0153,
      #$2013, #$2015, #$201C, #$201D, #$2018, #$2019, #$00F7, #$0389,
      #$038A, #$038C, #$038E, #$03AD, #$03AE, #$03AF, #$03CC, #$038F,
      #$03CD, #$03B1, #$03B2, #$03C8, #$03B4, #$03B5, #$03C6, #$03B3,
      #$03B7, #$03B9, #$03BE, #$03BA, #$03BB, #$03BC, #$03BD, #$03BF,
      #$03C0, #$03CE, #$03C1, #$03C3, #$03C4, #$03B8, #$03C9, #$03C2,
      #$03C7, #$03C5, #$03B6, #$03CA, #$03CB, #$0390, #$03B0, #$FFFF);
  MacIcelandicMap: ThtAnsiCharHighMap = (
      #$00C4, #$00C5, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$00E3, #$00E5, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$00EC, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00F2, #$00F4, #$00F6, #$00F5, #$00FA, #$00F9, #$00FB, #$00FC,
      #$00DD, #$00B0, #$00A2, #$00A3, #$00A7, #$2022, #$00B6, #$00DF,
      #$00AE, #$00A9, #$2122, #$00B4, #$00A8, #$2260, #$00C6, #$00D8,
      #$221E, #$00B1, #$2264, #$2265, #$00A5, #$00B5, #$2202, #$2211,
      #$220F, #$03C0, #$222B, #$00AA, #$00BA, #$2126, #$00E6, #$00F8,
      #$00BF, #$00A1, #$00AC, #$221A, #$0192, #$2248, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$00C0, #$00C3, #$00D5, #$0152, #$0153,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$25CA,
      #$00FF, #$0178, #$2044, #$00A4, #$00D0, #$00F0, #$00DE, #$00FE,
      #$00FD, #$00B7, #$201A, #$201E, #$2030, #$00C2, #$00CA, #$00C1,
      #$00CB, #$00C8, #$00CD, #$00CE, #$00CF, #$00CC, #$00D3, #$00D4,
      #$FFFF, #$00D2, #$00DA, #$00DB, #$00D9, #$0131, #$02C6, #$02DC,
      #$00AF, #$02D8, #$02D9, #$02DA, #$00B8, #$02DD, #$02DB, #$02C7);
  MacTurkishMap: ThtAnsiCharHighMap = (
      #$00C4, #$00C5, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$00E3, #$00E5, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$00EC, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00F2, #$00F4, #$00F6, #$00F5, #$00FA, #$00F9, #$00FB, #$00FC,
      #$2020, #$00B0, #$00A2, #$00A3, #$00A7, #$2022, #$00B6, #$00DF,
      #$00AE, #$00A9, #$2122, #$00B4, #$00A8, #$2260, #$00C6, #$00D8,
      #$221E, #$00B1, #$2264, #$2265, #$00A5, #$00B5, #$2202, #$2211,
      #$220F, #$03C0, #$222B, #$00AA, #$00BA, #$2126, #$00E6, #$00F8,
      #$00BF, #$00A1, #$00AC, #$221A, #$0192, #$2248, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$00C0, #$00C3, #$00D5, #$0152, #$0153,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$25CA,
      #$00FF, #$0178, #$011E, #$011F, #$0130, #$0131, #$015E, #$015F,
      #$2021, #$00B7, #$201A, #$201E, #$2030, #$00C2, #$00CA, #$00C1,
      #$00CB, #$00C8, #$00CD, #$00CE, #$00CF, #$00CC, #$00D3, #$00D4,
      #$FFFF, #$00D2, #$00DA, #$00DB, #$00D9, #$FFFF, #$02C6, #$02DC,
      #$00AF, #$02D8, #$02D9, #$02DA, #$00B8, #$02DD, #$02DB, #$02C7);
  MacArabicMap: ThtAnsiCharHighMap = (
      #$00C4, #$00A0, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$06BA, #$00AB, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$2026, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00BB, #$00F4, #$00F6, #$00F7, #$00FA, #$00F9, #$00FB, #$00FC,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$066A, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$060C, #$FFFD, #$FFFD, #$FFFD,
      #$0660, #$0661, #$0662, #$0663, #$0664, #$0665, #$0666, #$0667,
      #$0668, #$0669, #$FFFD, #$061B, #$FFFD, #$FFFD, #$FFFD, #$061F,
      #$066D, #$0621, #$0622, #$0623, #$0624, #$0625, #$0626, #$0627,
      #$0628, #$0629, #$062A, #$062B, #$062C, #$062D, #$062E, #$062F,
      #$0630, #$0631, #$0632, #$0633, #$0634, #$0635, #$0636, #$0637,
      #$0638, #$0639, #$063A, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0640, #$0641, #$0642, #$0643, #$0644, #$0645, #$0646, #$0647,
      #$0648, #$0649, #$064A, #$064B, #$064C, #$064D, #$064E, #$064F,
      #$0650, #$0651, #$0652, #$067E, #$0679, #$0686, #$06D5, #$06A4,
      #$06AF, #$0688, #$0691, #$FFFD, #$FFFD, #$FFFD, #$0698, #$06D2);
  MacCroatianMap: ThtAnsiCharHighMap = (
      #$00C4, #$00C5, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$00E3, #$00E5, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$00EC, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00F2, #$00F4, #$00F6, #$00F5, #$00FA, #$00F9, #$00FB, #$00FC,
      #$2020, #$00B0, #$00A2, #$00A3, #$00A7, #$2022, #$00B6, #$00DF,
      #$00AE, #$0160, #$2122, #$00B4, #$00A8, #$2260, #$017D, #$00D8,
      #$221E, #$00B1, #$2264, #$2265, #$2206, #$00B5, #$2202, #$2211,
      #$220F, #$0161, #$222B, #$00AA, #$00BA, #$2126, #$017E, #$00F8,
      #$00BF, #$00A1, #$00AC, #$221A, #$0192, #$2248, #$0106, #$00AB,
      #$010C, #$2026, #$00A0, #$00C0, #$00C3, #$00D5, #$0152, #$0153,
      #$0110, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$25CA,
      #$FFFD, #$00A9, #$2044, #$00A4, #$2039, #$203A, #$00C6, #$00BB,
      #$2013, #$00B7, #$201A, #$201E, #$2030, #$00C2, #$0107, #$00C1,
      #$010D, #$00C8, #$00CD, #$00CE, #$00CF, #$00CC, #$00D3, #$00D4,
      #$0111, #$00D2, #$00DA, #$00DB, #$00D9, #$0131, #$02C6, #$02DC,
      #$00AF, #$03C0, #$00CB, #$02DA, #$00B8, #$00CA, #$00E6, #$02C7);
  MacHebrewMap: ThtAnsiCharHighMap = (
      #$00C4, #$FB1F, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$00E3, #$00E5, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$00EC, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00F2, #$00F4, #$00F6, #$00F5, #$00FA, #$00F9, #$00FB, #$00FC,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$20AA, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$201E, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$05BC, #$FB4B,
      #$FB35, #$2026, #$00A0, #$05B8, #$05B7, #$05B5, #$05B6, #$05B4,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$FB2A, #$FB2B,
      #$05BF, #$05B0, #$05B2, #$05B1, #$05BB, #$05B9, #$FFFD, #$05B3,
      #$05D0, #$05D1, #$05D2, #$05D3, #$05D4, #$05D5, #$05D6, #$05D7,
      #$05D8, #$05D9, #$05DA, #$05DB, #$05DC, #$05DD, #$05DE, #$05DF,
      #$05E0, #$05E1, #$05E2, #$05E3, #$05E4, #$05E5, #$05E6, #$05E7,
      #$05E8, #$05E9, #$05EA, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD);
  MacRomaniaMap: ThtAnsiCharHighMap = (
      #$00C4, #$00C5, #$00C7, #$00C9, #$00D1, #$00D6, #$00DC, #$00E1,
      #$00E0, #$00E2, #$00E4, #$00E3, #$00E5, #$00E7, #$00E9, #$00E8,
      #$00EA, #$00EB, #$00ED, #$00EC, #$00EE, #$00EF, #$00F1, #$00F3,
      #$00F2, #$00F4, #$00F6, #$00F5, #$00FA, #$00F9, #$00FB, #$00FC,
      #$2020, #$00B0, #$00A2, #$00A3, #$00A7, #$2022, #$00B6, #$00DF,
      #$00AE, #$00A9, #$2122, #$00B4, #$00A8, #$2260, #$0102, #$015E,
      #$221E, #$00B1, #$2264, #$2265, #$00A5, #$00B5, #$2202, #$2211,
      #$220F, #$03C0, #$222B, #$00AA, #$00BA, #$2126, #$0103, #$015F,
      #$00BF, #$00A1, #$00AC, #$221A, #$0192, #$2248, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$00C0, #$00C3, #$00D5, #$0152, #$0153,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$25CA,
      #$00FF, #$0178, #$2044, #$00A4, #$2039, #$203A, #$0162, #$0163,
      #$2021, #$00B7, #$201A, #$201E, #$2030, #$00C2, #$00CA, #$00C1,
      #$00CB, #$00C8, #$00CD, #$00CE, #$00CF, #$00CC, #$00D3, #$00D4,
      #$FFFD, #$00D2, #$00DA, #$00DB, #$00D9, #$0131, #$02C6, #$02DC,
      #$00AF, #$02D8, #$02D9, #$02DA, #$00B8, #$02DD, #$02DB, #$02C7);
  MacThaiMap: ThtAnsiCharHighMap = (
      #$00AB, #$00BB, #$2026, #$F88C, #$F88F, #$F892, #$F895, #$F898,
      #$F88B, #$F88E, #$F891, #$F894, #$F897, #$201C, #$201D, #$F899,
      #$FFFD, #$2022, #$F884, #$F889, #$F885, #$F886, #$F887, #$F888,
      #$F88A, #$F88D, #$F890, #$F893, #$F896, #$2018, #$2019, #$FFFD,
      #$00A0, #$0E01, #$0E02, #$0E03, #$0E04, #$0E05, #$0E06, #$0E07,
      #$0E08, #$0E09, #$0E0A, #$0E0B, #$0E0C, #$0E0D, #$0E0E, #$0E0F,
      #$0E10, #$0E11, #$0E12, #$0E13, #$0E14, #$0E15, #$0E16, #$0E17,
      #$0E18, #$0E19, #$0E1A, #$0E1B, #$0E1C, #$0E1D, #$0E1E, #$0E1F,
      #$0E20, #$0E21, #$0E22, #$0E23, #$0E24, #$0E25, #$0E26, #$0E27,
      #$0E28, #$0E29, #$0E2A, #$0E2B, #$0E2C, #$0E2D, #$0E2E, #$0E2F,
      #$0E30, #$0E31, #$0E32, #$0E33, #$0E34, #$0E35, #$0E36, #$0E37,
      #$0E38, #$0E39, #$0E3A, #$FEFF, #$200B, #$2013, #$2014, #$0E3F,
      #$0E40, #$0E41, #$0E42, #$0E43, #$0E44, #$0E45, #$0E46, #$0E47,
      #$0E48, #$0E49, #$0E4A, #$0E4B, #$0E4C, #$0E4D, #$2122, #$0E4F,
      #$0E50, #$0E51, #$0E52, #$0E53, #$0E54, #$0E55, #$0E56, #$0E57,
      #$0E58, #$0E59, #$00AE, #$00A9, #$FFFD, #$FFFD, #$FFFD, #$FFFD);
  MacUkraineMap: ThtAnsiCharHighMap = (
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0416, #$0417,
      #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E, #$041F,
      #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427,
      #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E, #$042F,
      #$2020, #$00B0, #$0490, #$00A3, #$00A7, #$2022, #$00B6, #$0406,
      #$00AE, #$00A9, #$2122, #$0402, #$0452, #$2260, #$0403, #$0453,
      #$221E, #$00B1, #$2264, #$2265, #$0456, #$00B5, #$0491, #$0408,
      #$0404, #$0454, #$0407, #$0457, #$0409, #$0459, #$040A, #$045A,
      #$0458, #$0405, #$00AC, #$221A, #$0192, #$2248, #$2206, #$00AB,
      #$00BB, #$2026, #$00A0, #$040B, #$045B, #$040C, #$045C, #$0455,
      #$2013, #$2014, #$201C, #$201D, #$2018, #$2019, #$00F7, #$201E,
      #$040E, #$045E, #$040F, #$045F, #$2116, #$0401, #$0451, #$044F,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0436, #$0437,
      #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F,
      #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447,
      #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$00A4);
  CP29001: ThtAnsiCharMap = (
      #$0000, #$0386, #$0388, #$0389, #$038A, #$038C, #$038E, #$00B0,
      #$25D8, #$25CB, #$25D9, #$2642, #$2640, #$266A, #$266C, #$263C,
      #$25B6, #$25C0, #$2195, #$203C, #$00B6, #$00A7, #$00A3, #$038F,
      #$2191, #$2193, #$2192, #$2190, #$00CB, #$2194, #$25B2, #$25BC,
      #$0020, #$0021, #$0022, #$0023, #$0024, #$0025, #$0026, #$0027,
      #$0028, #$0029, #$002A, #$002B, #$002C, #$002D, #$002E, #$002F,
      #$0030, #$0031, #$0032, #$0033, #$0034, #$0035, #$0036, #$0037,
      #$0038, #$0039, #$003A, #$003B, #$003C, #$003D, #$003E, #$003F,
      #$0040, #$0041, #$0042, #$0043, #$0044, #$0045, #$0046, #$0047,
      #$0048, #$0049, #$004A, #$004B, #$004C, #$004D, #$004E, #$004F,
      #$0050, #$0051, #$0052, #$0053, #$0054, #$0055, #$0056, #$0057,
      #$0058, #$0059, #$005A, #$005B, #$005C, #$005D, #$005E, #$005F,
      #$0060, #$0061, #$0062, #$0063, #$0064, #$0065, #$0066, #$0067,
      #$0068, #$0069, #$006A, #$006B, #$006C, #$006D, #$006E, #$006F,
      #$0070, #$0071, #$0072, #$0073, #$0074, #$0075, #$0076, #$0077,
      #$0078, #$0079, #$007A, #$007B, #$007C, #$007D, #$007E, #$007F,
      #$00C7, #$00FC, #$00E9, #$00E2, #$00E4, #$00E0, #$00E5, #$00E7,
      #$00EA, #$00EB, #$00E8, #$00EF, #$00EE, #$00EC, #$00C4, #$00C5,
      #$00C9, #$00E6, #$00C6, #$00F4, #$00F6, #$00F2, #$00FB, #$00F9,
      #$0391, #$00D6, #$00DC, #$00F8, #$03B1, #$00D8, #$03AC, #$0392,
      #$00E1, #$00ED, #$00F3, #$00FA, #$00F1, #$00D1, #$03B2, #$0393,
      #$03B3, #$0394, #$03B4, #$0395, #$03B5, #$03AD, #$0396, #$03B6,
      #$0397, #$03B7, #$03AE, #$2502, #$00AA, #$00C1, #$00C2, #$00C0,
      #$0398, #$03B8, #$2551, #$2557, #$255D, #$0399, #$03AA, #$2510,
      #$2514, #$00BA, #$00A1, #$00BF, #$2500, #$0384, #$00E3, #$00C3,
      #$255A, #$2554, #$03B9, #$03AF, #$03CA, #$2550, #$0390, #$039A,
      #$03BA, #$039B, #$00CA, #$03BB, #$039C, #$03BC, #$00CD, #$039D,
      #$03BD, #$2518, #$250C, #$039E, #$03BE, #$039F, #$03BF, #$03CC,
      #$00D3, #$00DF, #$00D4, #$03A0, #$00F5, #$00D5, #$03C0, #$03A1,
      #$03C1, #$00DA, #$03A3, #$03C2, #$03C3, #$03A4, #$03C4, #$03A5,
      #$03AB, #$03C5, #$03CD, #$03CB, #$03B0, #$03A6, #$03C6, #$03A7,
      #$03C7, #$03A8, #$0387, #$03C8, #$03A9, #$03C9, #$03CE, #$F8FF);
  KOI8_RMap: ThtAnsiCharHighMap = (
      #$2500, #$2502, #$250C, #$2510, #$2514, #$2518, #$251C, #$2524,
      #$252C, #$2534, #$253C, #$2580, #$2584, #$2588, #$258C, #$2590,
      #$2591, #$2592, #$2593, #$2320, #$25A0, #$2219, #$221A, #$2248,
      #$2264, #$2265, #$00A0, #$2321, #$00B0, #$00B2, #$00B7, #$00F7,
      #$2550, #$2551, #$2552, #$0451, #$2553, #$2554, #$2555, #$2556,
      #$2557, #$2558, #$2559, #$255A, #$255B, #$255C, #$255D, #$255E,
      #$255F, #$2560, #$2561, #$0401, #$2562, #$2563, #$2564, #$2565,
      #$2566, #$2567, #$2568, #$2569, #$256A, #$256B, #$256C, #$00A9,
      #$044E, #$0430, #$0431, #$0446, #$0434, #$0435, #$0444, #$0433,
      #$0445, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E,
      #$043F, #$044F, #$0440, #$0441, #$0442, #$0443, #$0436, #$0432,
      #$044C, #$044B, #$0437, #$0448, #$044D, #$0449, #$0447, #$044A,
      #$042E, #$0410, #$0411, #$0426, #$0414, #$0415, #$0424, #$0413,
      #$0425, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E,
      #$041F, #$042F, #$0420, #$0421, #$0422, #$0423, #$0416, #$0412,
      #$042C, #$042B, #$0417, #$0428, #$042D, #$0429, #$0427, #$042A);
  KOI8_TMap: ThtAnsiCharHighMap = (
      #$049B, #$0493, #$201A, #$0492, #$201E, #$2026, #$2020, #$2021,
      #$FFFD, #$2030, #$04B3, #$2039, #$04B2, #$04B7, #$04B6, #$FFFD,
      #$049A, #$2018, #$2019, #$201C, #$201D, #$2022, #$2013, #$2014,
      #$FFFD, #$2122, #$FFFD, #$203A, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$04EF, #$04EE, #$0451, #$00A4, #$04E3, #$00A6, #$00A7,
      #$FFFD, #$FFFD, #$FFFD, #$00AB, #$00AC, #$00AD, #$00AE, #$FFFD,
      #$00B0, #$00B1, #$00B2, #$0401, #$FFFD, #$04E2, #$00B6, #$00B7,
      #$FFFD, #$2116, #$FFFD, #$00BB, #$FFFD, #$FFFD, #$FFFD, #$00A9,
      #$044E, #$0430, #$0431, #$0446, #$0434, #$0435, #$0444, #$0433,
      #$0445, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E,
      #$043F, #$044F, #$0440, #$0441, #$0442, #$0443, #$0436, #$0432,
      #$044C, #$044B, #$0437, #$0448, #$044D, #$0449, #$0447, #$044A,
      #$042E, #$0410, #$0411, #$0426, #$0414, #$0415, #$0424, #$0413,
      #$0425, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E,
      #$041F, #$042F, #$0420, #$0421, #$0422, #$0423, #$0416, #$0412,
      #$042C, #$042B, #$0417, #$0428, #$042D, #$0429, #$0427, #$042A);
  GB2312_1Map: array[0..830] of TBuffChar = (
      #$3000, #$3001, #$3002, #$30FB, #$02C9, #$02C7, #$00A8, #$3003,
      #$3005, #$2015, #$FF5E, #$2016, #$2026, #$2018, #$2019, #$201C,
      #$201D, #$3014, #$3015, #$3008, #$3009, #$300A, #$300B, #$300C,
      #$300D, #$300E, #$300F, #$3016, #$3017, #$3010, #$3011, #$00B1,
      #$00D7, #$00F7, #$2236, #$2227, #$2228, #$2211, #$220F, #$222A,
      #$2229, #$2208, #$2237, #$221A, #$22A5, #$2225, #$2220, #$2312,
      #$2299, #$222B, #$222E, #$2261, #$224C, #$2248, #$223D, #$221D,
      #$2260, #$226E, #$226F, #$2264, #$2265, #$221E, #$2235, #$2234,
      #$2642, #$2640, #$00B0, #$2032, #$2033, #$2103, #$FF04, #$00A4,
      #$FFE0, #$FFE1, #$2030, #$00A7, #$2116, #$2606, #$2605, #$25CB,
      #$25CF, #$25CE, #$25C7, #$25C6, #$25A1, #$25A0, #$25B3, #$25B2,
      #$203B, #$2192, #$2190, #$2191, #$2193, #$3013,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$2488, #$2489, #$248A, #$248B, #$248C, #$248D, #$248E, #$248F,
      #$2490, #$2491, #$2492, #$2493, #$2494, #$2495, #$2496, #$2497,
      #$2498, #$2499, #$249A, #$249B, #$2474, #$2475, #$2476, #$2477,
      #$2478, #$2479, #$247A, #$247B, #$247C, #$247D, #$247E, #$247F,
      #$2480, #$2481, #$2482, #$2483, #$2484, #$2485, #$2486, #$2487,
      #$2460, #$2461, #$2462, #$2463, #$2464, #$2465, #$2466, #$2467,
      #$2468, #$2469, #$FFFD, #$FFFD, #$3220, #$3221, #$3222, #$3223,
      #$3224, #$3225, #$3226, #$3227, #$3228, #$3229, #$FFFD, #$FFFD,
      #$2160, #$2161, #$2162, #$2163, #$2164, #$2165, #$2166, #$2167,
      #$2168, #$2169, #$216A, #$216B, #$FFFD, #$FFFD,
      #$FF01, #$FF02, #$FF03, #$FFE5, #$FF05, #$FF06, #$FF07, #$FF08,
      #$FF09, #$FF0A, #$FF0B, #$FF0C, #$FF0D, #$FF0E, #$FF0F, #$FF10,
      #$FF11, #$FF12, #$FF13, #$FF14, #$FF15, #$FF16, #$FF17, #$FF18,
      #$FF19, #$FF1A, #$FF1B, #$FF1C, #$FF1D, #$FF1E, #$FF1F, #$FF20,
      #$FF21, #$FF22, #$FF23, #$FF24, #$FF25, #$FF26, #$FF27, #$FF28,
      #$FF29, #$FF2A, #$FF2B, #$FF2C, #$FF2D, #$FF2E, #$FF2F, #$FF30,
      #$FF31, #$FF32, #$FF33, #$FF34, #$FF35, #$FF36, #$FF37, #$FF38,
      #$FF39, #$FF3A, #$FF3B, #$FF3C, #$FF3D, #$FF3E, #$FF3F, #$FF40,
      #$FF41, #$FF42, #$FF43, #$FF44, #$FF45, #$FF46, #$FF47, #$FF48,
      #$FF49, #$FF4A, #$FF4B, #$FF4C, #$FF4D, #$FF4E, #$FF4F, #$FF50,
      #$FF51, #$FF52, #$FF53, #$FF54, #$FF55, #$FF56, #$FF57, #$FF58,
      #$FF59, #$FF5A, #$FF5B, #$FF5C, #$FF5D, #$FFE3,
      #$3041, #$3042, #$3043, #$3044, #$3045, #$3046, #$3047, #$3048,
      #$3049, #$304A, #$304B, #$304C, #$304D, #$304E, #$304F, #$3050,
      #$3051, #$3052, #$3053, #$3054, #$3055, #$3056, #$3057, #$3058,
      #$3059, #$305A, #$305B, #$305C, #$305D, #$305E, #$305F, #$3060,
      #$3061, #$3062, #$3063, #$3064, #$3065, #$3066, #$3067, #$3068,
      #$3069, #$306A, #$306B, #$306C, #$306D, #$306E, #$306F, #$3070,
      #$3071, #$3072, #$3073, #$3074, #$3075, #$3076, #$3077, #$3078,
      #$3079, #$307A, #$307B, #$307C, #$307D, #$307E, #$307F, #$3080,
      #$3081, #$3082, #$3083, #$3084, #$3085, #$3086, #$3087, #$3088,
      #$3089, #$308A, #$308B, #$308C, #$308D, #$308E, #$308F, #$3090,
      #$3091, #$3092, #$3093, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$30A1, #$30A2, #$30A3, #$30A4, #$30A5, #$30A6, #$30A7, #$30A8,
      #$30A9, #$30AA, #$30AB, #$30AC, #$30AD, #$30AE, #$30AF, #$30B0,
      #$30B1, #$30B2, #$30B3, #$30B4, #$30B5, #$30B6, #$30B7, #$30B8,
      #$30B9, #$30BA, #$30BB, #$30BC, #$30BD, #$30BE, #$30BF, #$30C0,
      #$30C1, #$30C2, #$30C3, #$30C4, #$30C5, #$30C6, #$30C7, #$30C8,
      #$30C9, #$30CA, #$30CB, #$30CC, #$30CD, #$30CE, #$30CF, #$30D0,
      #$30D1, #$30D2, #$30D3, #$30D4, #$30D5, #$30D6, #$30D7, #$30D8,
      #$30D9, #$30DA, #$30DB, #$30DC, #$30DD, #$30DE, #$30DF, #$30E0,
      #$30E1, #$30E2, #$30E3, #$30E4, #$30E5, #$30E6, #$30E7, #$30E8,
      #$30E9, #$30EA, #$30EB, #$30EC, #$30ED, #$30EE, #$30EF, #$30F0,
      #$30F1, #$30F2, #$30F3, #$30F4, #$30F5, #$30F6, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0391, #$0392, #$0393, #$0394, #$0395, #$0396, #$0397, #$0398,
      #$0399, #$039A, #$039B, #$039C, #$039D, #$039E, #$039F, #$03A0,
      #$03A1, #$03A3, #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$03B1, #$03B2, #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8,
      #$03B9, #$03BA, #$03BB, #$03BC, #$03BD, #$03BE, #$03BF, #$03C0,
      #$03C1, #$03C3, #$03C4, #$03C5, #$03C6, #$03C7, #$03C8, #$03C9,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0401, #$0416,
      #$0417, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E,
      #$041F, #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426,
      #$0427, #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E,
      #$042F, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0451, #$0436,
      #$0437, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E,
      #$043F, #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446,
      #$0447, #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E,
      #$044F, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0101, #$00E1, #$01CE, #$00E0, #$0113, #$00E9, #$011B, #$00E8,
      #$012B, #$00ED, #$01D0, #$00EC, #$014D, #$00F3, #$01D2, #$00F2,
      #$016B, #$00FA, #$01D4, #$00F9, #$01D6, #$01D8, #$01DA, #$01DC,
      #$00FC, #$00EA, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$3105, #$3106, #$3107, #$3108,
      #$3109, #$310A, #$310B, #$310C, #$310D, #$310E, #$310F, #$3110,
      #$3111, #$3112, #$3113, #$3114, #$3115, #$3116, #$3117, #$3118,
      #$3119, #$311A, #$311B, #$311C, #$311D, #$311E, #$311F, #$3120,
      #$3121, #$3122, #$3123, #$3124, #$3125, #$3126, #$3127, #$3128,
      #$3129, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$2500, #$2501, #$2502, #$2503, #$2504,
      #$2505, #$2506, #$2507, #$2508, #$2509, #$250A, #$250B, #$250C,
      #$250D, #$250E, #$250F, #$2510, #$2511, #$2512, #$2513, #$2514,
      #$2515, #$2516, #$2517, #$2518, #$2519, #$251A, #$251B, #$251C,
      #$251D, #$251E, #$251F, #$2520, #$2521, #$2522, #$2523, #$2524,
      #$2525, #$2526, #$2527, #$2528, #$2529, #$252A, #$252B, #$252C,
      #$252D, #$252E, #$252F, #$2530, #$2531, #$2532, #$2533, #$2534,
      #$2535, #$2536, #$2537, #$2538, #$2539, #$253A, #$253B, #$253C,
      #$253D, #$253E, #$253F, #$2540, #$2541, #$2542, #$2543, #$2544,
      #$2545, #$2546, #$2547, #$2548, #$2549, #$254A, #$254B);
  GB2312_2Map: array[0..6767] of TBuffChar = (
      #$554A, #$963F, #$57C3, #$6328, #$54CE, #$5509, #$54C0, #$7691,
      #$764C, #$853C, #$77EE, #$827E, #$788D, #$7231, #$9698, #$978D,
      #$6C28, #$5B89, #$4FFA, #$6309, #$6697, #$5CB8, #$80FA, #$6848,
      #$80AE, #$6602, #$76CE, #$51F9, #$6556, #$71AC, #$7FF1, #$8884,
      #$50B2, #$5965, #$61CA, #$6FB3, #$82AD, #$634C, #$6252, #$53ED,
      #$5427, #$7B06, #$516B, #$75A4, #$5DF4, #$62D4, #$8DCB, #$9776,
      #$628A, #$8019, #$575D, #$9738, #$7F62, #$7238, #$767D, #$67CF,
      #$767E, #$6446, #$4F70, #$8D25, #$62DC, #$7A17, #$6591, #$73ED,
      #$642C, #$6273, #$822C, #$9881, #$677F, #$7248, #$626E, #$62CC,
      #$4F34, #$74E3, #$534A, #$529E, #$7ECA, #$90A6, #$5E2E, #$6886,
      #$699C, #$8180, #$7ED1, #$68D2, #$78C5, #$868C, #$9551, #$508D,
      #$8C24, #$82DE, #$80DE, #$5305, #$8912, #$5265,
      #$8584, #$96F9, #$4FDD, #$5821, #$9971, #$5B9D, #$62B1, #$62A5,
      #$66B4, #$8C79, #$9C8D, #$7206, #$676F, #$7891, #$60B2, #$5351,
      #$5317, #$8F88, #$80CC, #$8D1D, #$94A1, #$500D, #$72C8, #$5907,
      #$60EB, #$7119, #$88AB, #$5954, #$82EF, #$672C, #$7B28, #$5D29,
      #$7EF7, #$752D, #$6CF5, #$8E66, #$8FF8, #$903C, #$9F3B, #$6BD4,
      #$9119, #$7B14, #$5F7C, #$78A7, #$84D6, #$853D, #$6BD5, #$6BD9,
      #$6BD6, #$5E01, #$5E87, #$75F9, #$95ED, #$655D, #$5F0A, #$5FC5,
      #$8F9F, #$58C1, #$81C2, #$907F, #$965B, #$97AD, #$8FB9, #$7F16,
      #$8D2C, #$6241, #$4FBF, #$53D8, #$535E, #$8FA8, #$8FA9, #$8FAB,
      #$904D, #$6807, #$5F6A, #$8198, #$8868, #$9CD6, #$618B, #$522B,
      #$762A, #$5F6C, #$658C, #$6FD2, #$6EE8, #$5BBE, #$6448, #$5175,
      #$51B0, #$67C4, #$4E19, #$79C9, #$997C, #$70B3,
      #$75C5, #$5E76, #$73BB, #$83E0, #$64AD, #$62E8, #$94B5, #$6CE2,
      #$535A, #$52C3, #$640F, #$94C2, #$7B94, #$4F2F, #$5E1B, #$8236,
      #$8116, #$818A, #$6E24, #$6CCA, #$9A73, #$6355, #$535C, #$54FA,
      #$8865, #$57E0, #$4E0D, #$5E03, #$6B65, #$7C3F, #$90E8, #$6016,
      #$64E6, #$731C, #$88C1, #$6750, #$624D, #$8D22, #$776C, #$8E29,
      #$91C7, #$5F69, #$83DC, #$8521, #$9910, #$53C2, #$8695, #$6B8B,
      #$60ED, #$60E8, #$707F, #$82CD, #$8231, #$4ED3, #$6CA7, #$85CF,
      #$64CD, #$7CD9, #$69FD, #$66F9, #$8349, #$5395, #$7B56, #$4FA7,
      #$518C, #$6D4B, #$5C42, #$8E6D, #$63D2, #$53C9, #$832C, #$8336,
      #$67E5, #$78B4, #$643D, #$5BDF, #$5C94, #$5DEE, #$8BE7, #$62C6,
      #$67F4, #$8C7A, #$6400, #$63BA, #$8749, #$998B, #$8C17, #$7F20,
      #$94F2, #$4EA7, #$9610, #$98A4, #$660C, #$7316,
      #$573A, #$5C1D, #$5E38, #$957F, #$507F, #$80A0, #$5382, #$655E,
      #$7545, #$5531, #$5021, #$8D85, #$6284, #$949E, #$671D, #$5632,
      #$6F6E, #$5DE2, #$5435, #$7092, #$8F66, #$626F, #$64A4, #$63A3,
      #$5F7B, #$6F88, #$90F4, #$81E3, #$8FB0, #$5C18, #$6668, #$5FF1,
      #$6C89, #$9648, #$8D81, #$886C, #$6491, #$79F0, #$57CE, #$6A59,
      #$6210, #$5448, #$4E58, #$7A0B, #$60E9, #$6F84, #$8BDA, #$627F,
      #$901E, #$9A8B, #$79E4, #$5403, #$75F4, #$6301, #$5319, #$6C60,
      #$8FDF, #$5F1B, #$9A70, #$803B, #$9F7F, #$4F88, #$5C3A, #$8D64,
      #$7FC5, #$65A5, #$70BD, #$5145, #$51B2, #$866B, #$5D07, #$5BA0,
      #$62BD, #$916C, #$7574, #$8E0C, #$7A20, #$6101, #$7B79, #$4EC7,
      #$7EF8, #$7785, #$4E11, #$81ED, #$521D, #$51FA, #$6A71, #$53A8,
      #$8E87, #$9504, #$96CF, #$6EC1, #$9664, #$695A,
      #$7840, #$50A8, #$77D7, #$6410, #$89E6, #$5904, #$63E3, #$5DDD,
      #$7A7F, #$693D, #$4F20, #$8239, #$5598, #$4E32, #$75AE, #$7A97,
      #$5E62, #$5E8A, #$95EF, #$521B, #$5439, #$708A, #$6376, #$9524,
      #$5782, #$6625, #$693F, #$9187, #$5507, #$6DF3, #$7EAF, #$8822,
      #$6233, #$7EF0, #$75B5, #$8328, #$78C1, #$96CC, #$8F9E, #$6148,
      #$74F7, #$8BCD, #$6B64, #$523A, #$8D50, #$6B21, #$806A, #$8471,
      #$56F1, #$5306, #$4ECE, #$4E1B, #$51D1, #$7C97, #$918B, #$7C07,
      #$4FC3, #$8E7F, #$7BE1, #$7A9C, #$6467, #$5D14, #$50AC, #$8106,
      #$7601, #$7CB9, #$6DEC, #$7FE0, #$6751, #$5B58, #$5BF8, #$78CB,
      #$64AE, #$6413, #$63AA, #$632B, #$9519, #$642D, #$8FBE, #$7B54,
      #$7629, #$6253, #$5927, #$5446, #$6B79, #$50A3, #$6234, #$5E26,
      #$6B86, #$4EE3, #$8D37, #$888B, #$5F85, #$902E,
      #$6020, #$803D, #$62C5, #$4E39, #$5355, #$90F8, #$63B8, #$80C6,
      #$65E6, #$6C2E, #$4F46, #$60EE, #$6DE1, #$8BDE, #$5F39, #$86CB,
      #$5F53, #$6321, #$515A, #$8361, #$6863, #$5200, #$6363, #$8E48,
      #$5012, #$5C9B, #$7977, #$5BFC, #$5230, #$7A3B, #$60BC, #$9053,
      #$76D7, #$5FB7, #$5F97, #$7684, #$8E6C, #$706F, #$767B, #$7B49,
      #$77AA, #$51F3, #$9093, #$5824, #$4F4E, #$6EF4, #$8FEA, #$654C,
      #$7B1B, #$72C4, #$6DA4, #$7FDF, #$5AE1, #$62B5, #$5E95, #$5730,
      #$8482, #$7B2C, #$5E1D, #$5F1F, #$9012, #$7F14, #$98A0, #$6382,
      #$6EC7, #$7898, #$70B9, #$5178, #$975B, #$57AB, #$7535, #$4F43,
      #$7538, #$5E97, #$60E6, #$5960, #$6DC0, #$6BBF, #$7889, #$53FC,
      #$96D5, #$51CB, #$5201, #$6389, #$540A, #$9493, #$8C03, #$8DCC,
      #$7239, #$789F, #$8776, #$8FED, #$8C0D, #$53E0,
      #$4E01, #$76EF, #$53EE, #$9489, #$9876, #$9F0E, #$952D, #$5B9A,
      #$8BA2, #$4E22, #$4E1C, #$51AC, #$8463, #$61C2, #$52A8, #$680B,
      #$4F97, #$606B, #$51BB, #$6D1E, #$515C, #$6296, #$6597, #$9661,
      #$8C46, #$9017, #$75D8, #$90FD, #$7763, #$6BD2, #$728A, #$72EC,
      #$8BFB, #$5835, #$7779, #$8D4C, #$675C, #$9540, #$809A, #$5EA6,
      #$6E21, #$5992, #$7AEF, #$77ED, #$953B, #$6BB5, #$65AD, #$7F0E,
      #$5806, #$5151, #$961F, #$5BF9, #$58A9, #$5428, #$8E72, #$6566,
      #$987F, #$56E4, #$949D, #$76FE, #$9041, #$6387, #$54C6, #$591A,
      #$593A, #$579B, #$8EB2, #$6735, #$8DFA, #$8235, #$5241, #$60F0,
      #$5815, #$86FE, #$5CE8, #$9E45, #$4FC4, #$989D, #$8BB9, #$5A25,
      #$6076, #$5384, #$627C, #$904F, #$9102, #$997F, #$6069, #$800C,
      #$513F, #$8033, #$5C14, #$9975, #$6D31, #$4E8C,
      #$8D30, #$53D1, #$7F5A, #$7B4F, #$4F10, #$4E4F, #$9600, #$6CD5,
      #$73D0, #$85E9, #$5E06, #$756A, #$7FFB, #$6A0A, #$77FE, #$9492,
      #$7E41, #$51E1, #$70E6, #$53CD, #$8FD4, #$8303, #$8D29, #$72AF,
      #$996D, #$6CDB, #$574A, #$82B3, #$65B9, #$80AA, #$623F, #$9632,
      #$59A8, #$4EFF, #$8BBF, #$7EBA, #$653E, #$83F2, #$975E, #$5561,
      #$98DE, #$80A5, #$532A, #$8BFD, #$5420, #$80BA, #$5E9F, #$6CB8,
      #$8D39, #$82AC, #$915A, #$5429, #$6C1B, #$5206, #$7EB7, #$575F,
      #$711A, #$6C7E, #$7C89, #$594B, #$4EFD, #$5FFF, #$6124, #$7CAA,
      #$4E30, #$5C01, #$67AB, #$8702, #$5CF0, #$950B, #$98CE, #$75AF,
      #$70FD, #$9022, #$51AF, #$7F1D, #$8BBD, #$5949, #$51E4, #$4F5B,
      #$5426, #$592B, #$6577, #$80A4, #$5B75, #$6276, #$62C2, #$8F90,
      #$5E45, #$6C1F, #$7B26, #$4F0F, #$4FD8, #$670D,
      #$6D6E, #$6DAA, #$798F, #$88B1, #$5F17, #$752B, #$629A, #$8F85,
      #$4FEF, #$91DC, #$65A7, #$812F, #$8151, #$5E9C, #$8150, #$8D74,
      #$526F, #$8986, #$8D4B, #$590D, #$5085, #$4ED8, #$961C, #$7236,
      #$8179, #$8D1F, #$5BCC, #$8BA3, #$9644, #$5987, #$7F1A, #$5490,
      #$5676, #$560E, #$8BE5, #$6539, #$6982, #$9499, #$76D6, #$6E89,
      #$5E72, #$7518, #$6746, #$67D1, #$7AFF, #$809D, #$8D76, #$611F,
      #$79C6, #$6562, #$8D63, #$5188, #$521A, #$94A2, #$7F38, #$809B,
      #$7EB2, #$5C97, #$6E2F, #$6760, #$7BD9, #$768B, #$9AD8, #$818F,
      #$7F94, #$7CD5, #$641E, #$9550, #$7A3F, #$544A, #$54E5, #$6B4C,
      #$6401, #$6208, #$9E3D, #$80F3, #$7599, #$5272, #$9769, #$845B,
      #$683C, #$86E4, #$9601, #$9694, #$94EC, #$4E2A, #$5404, #$7ED9,
      #$6839, #$8DDF, #$8015, #$66F4, #$5E9A, #$7FB9,
      #$57C2, #$803F, #$6897, #$5DE5, #$653B, #$529F, #$606D, #$9F9A,
      #$4F9B, #$8EAC, #$516C, #$5BAB, #$5F13, #$5DE9, #$6C5E, #$62F1,
      #$8D21, #$5171, #$94A9, #$52FE, #$6C9F, #$82DF, #$72D7, #$57A2,
      #$6784, #$8D2D, #$591F, #$8F9C, #$83C7, #$5495, #$7B8D, #$4F30,
      #$6CBD, #$5B64, #$59D1, #$9F13, #$53E4, #$86CA, #$9AA8, #$8C37,
      #$80A1, #$6545, #$987E, #$56FA, #$96C7, #$522E, #$74DC, #$5250,
      #$5BE1, #$6302, #$8902, #$4E56, #$62D0, #$602A, #$68FA, #$5173,
      #$5B98, #$51A0, #$89C2, #$7BA1, #$9986, #$7F50, #$60EF, #$704C,
      #$8D2F, #$5149, #$5E7F, #$901B, #$7470, #$89C4, #$572D, #$7845,
      #$5F52, #$9F9F, #$95FA, #$8F68, #$9B3C, #$8BE1, #$7678, #$6842,
      #$67DC, #$8DEA, #$8D35, #$523D, #$8F8A, #$6EDA, #$68CD, #$9505,
      #$90ED, #$56FD, #$679C, #$88F9, #$8FC7, #$54C8,
      #$9AB8, #$5B69, #$6D77, #$6C26, #$4EA5, #$5BB3, #$9A87, #$9163,
      #$61A8, #$90AF, #$97E9, #$542B, #$6DB5, #$5BD2, #$51FD, #$558A,
      #$7F55, #$7FF0, #$64BC, #$634D, #$65F1, #$61BE, #$608D, #$710A,
      #$6C57, #$6C49, #$592F, #$676D, #$822A, #$58D5, #$568E, #$8C6A,
      #$6BEB, #$90DD, #$597D, #$8017, #$53F7, #$6D69, #$5475, #$559D,
      #$8377, #$83CF, #$6838, #$79BE, #$548C, #$4F55, #$5408, #$76D2,
      #$8C89, #$9602, #$6CB3, #$6DB8, #$8D6B, #$8910, #$9E64, #$8D3A,
      #$563F, #$9ED1, #$75D5, #$5F88, #$72E0, #$6068, #$54FC, #$4EA8,
      #$6A2A, #$8861, #$6052, #$8F70, #$54C4, #$70D8, #$8679, #$9E3F,
      #$6D2A, #$5B8F, #$5F18, #$7EA2, #$5589, #$4FAF, #$7334, #$543C,
      #$539A, #$5019, #$540E, #$547C, #$4E4E, #$5FFD, #$745A, #$58F6,
      #$846B, #$80E1, #$8774, #$72D0, #$7CCA, #$6E56,
      #$5F27, #$864E, #$552C, #$62A4, #$4E92, #$6CAA, #$6237, #$82B1,
      #$54D7, #$534E, #$733E, #$6ED1, #$753B, #$5212, #$5316, #$8BDD,
      #$69D0, #$5F8A, #$6000, #$6DEE, #$574F, #$6B22, #$73AF, #$6853,
      #$8FD8, #$7F13, #$6362, #$60A3, #$5524, #$75EA, #$8C62, #$7115,
      #$6DA3, #$5BA6, #$5E7B, #$8352, #$614C, #$9EC4, #$78FA, #$8757,
      #$7C27, #$7687, #$51F0, #$60F6, #$714C, #$6643, #$5E4C, #$604D,
      #$8C0E, #$7070, #$6325, #$8F89, #$5FBD, #$6062, #$86D4, #$56DE,
      #$6BC1, #$6094, #$6167, #$5349, #$60E0, #$6666, #$8D3F, #$79FD,
      #$4F1A, #$70E9, #$6C47, #$8BB3, #$8BF2, #$7ED8, #$8364, #$660F,
      #$5A5A, #$9B42, #$6D51, #$6DF7, #$8C41, #$6D3B, #$4F19, #$706B,
      #$83B7, #$6216, #$60D1, #$970D, #$8D27, #$7978, #$51FB, #$573E,
      #$57FA, #$673A, #$7578, #$7A3D, #$79EF, #$7B95,
      #$808C, #$9965, #$8FF9, #$6FC0, #$8BA5, #$9E21, #$59EC, #$7EE9,
      #$7F09, #$5409, #$6781, #$68D8, #$8F91, #$7C4D, #$96C6, #$53CA,
      #$6025, #$75BE, #$6C72, #$5373, #$5AC9, #$7EA7, #$6324, #$51E0,
      #$810A, #$5DF1, #$84DF, #$6280, #$5180, #$5B63, #$4F0E, #$796D,
      #$5242, #$60B8, #$6D4E, #$5BC4, #$5BC2, #$8BA1, #$8BB0, #$65E2,
      #$5FCC, #$9645, #$5993, #$7EE7, #$7EAA, #$5609, #$67B7, #$5939,
      #$4F73, #$5BB6, #$52A0, #$835A, #$988A, #$8D3E, #$7532, #$94BE,
      #$5047, #$7A3C, #$4EF7, #$67B6, #$9A7E, #$5AC1, #$6B7C, #$76D1,
      #$575A, #$5C16, #$7B3A, #$95F4, #$714E, #$517C, #$80A9, #$8270,
      #$5978, #$7F04, #$8327, #$68C0, #$67EC, #$78B1, #$7877, #$62E3,
      #$6361, #$7B80, #$4FED, #$526A, #$51CF, #$8350, #$69DB, #$9274,
      #$8DF5, #$8D31, #$89C1, #$952E, #$7BAD, #$4EF6,
      #$5065, #$8230, #$5251, #$996F, #$6E10, #$6E85, #$6DA7, #$5EFA,
      #$50F5, #$59DC, #$5C06, #$6D46, #$6C5F, #$7586, #$848B, #$6868,
      #$5956, #$8BB2, #$5320, #$9171, #$964D, #$8549, #$6912, #$7901,
      #$7126, #$80F6, #$4EA4, #$90CA, #$6D47, #$9A84, #$5A07, #$56BC,
      #$6405, #$94F0, #$77EB, #$4FA5, #$811A, #$72E1, #$89D2, #$997A,
      #$7F34, #$7EDE, #$527F, #$6559, #$9175, #$8F7F, #$8F83, #$53EB,
      #$7A96, #$63ED, #$63A5, #$7686, #$79F8, #$8857, #$9636, #$622A,
      #$52AB, #$8282, #$6854, #$6770, #$6377, #$776B, #$7AED, #$6D01,
      #$7ED3, #$89E3, #$59D0, #$6212, #$85C9, #$82A5, #$754C, #$501F,
      #$4ECB, #$75A5, #$8BEB, #$5C4A, #$5DFE, #$7B4B, #$65A4, #$91D1,
      #$4ECA, #$6D25, #$895F, #$7D27, #$9526, #$4EC5, #$8C28, #$8FDB,
      #$9773, #$664B, #$7981, #$8FD1, #$70EC, #$6D78,
      #$5C3D, #$52B2, #$8346, #$5162, #$830E, #$775B, #$6676, #$9CB8,
      #$4EAC, #$60CA, #$7CBE, #$7CB3, #$7ECF, #$4E95, #$8B66, #$666F,
      #$9888, #$9759, #$5883, #$656C, #$955C, #$5F84, #$75C9, #$9756,
      #$7ADF, #$7ADE, #$51C0, #$70AF, #$7A98, #$63EA, #$7A76, #$7EA0,
      #$7396, #$97ED, #$4E45, #$7078, #$4E5D, #$9152, #$53A9, #$6551,
      #$65E7, #$81FC, #$8205, #$548E, #$5C31, #$759A, #$97A0, #$62D8,
      #$72D9, #$75BD, #$5C45, #$9A79, #$83CA, #$5C40, #$5480, #$77E9,
      #$4E3E, #$6CAE, #$805A, #$62D2, #$636E, #$5DE8, #$5177, #$8DDD,
      #$8E1E, #$952F, #$4FF1, #$53E5, #$60E7, #$70AC, #$5267, #$6350,
      #$9E43, #$5A1F, #$5026, #$7737, #$5377, #$7EE2, #$6485, #$652B,
      #$6289, #$6398, #$5014, #$7235, #$89C9, #$51B3, #$8BC0, #$7EDD,
      #$5747, #$83CC, #$94A7, #$519B, #$541B, #$5CFB,
      #$4FCA, #$7AE3, #$6D5A, #$90E1, #$9A8F, #$5580, #$5496, #$5361,
      #$54AF, #$5F00, #$63E9, #$6977, #$51EF, #$6168, #$520A, #$582A,
      #$52D8, #$574E, #$780D, #$770B, #$5EB7, #$6177, #$7CE0, #$625B,
      #$6297, #$4EA2, #$7095, #$8003, #$62F7, #$70E4, #$9760, #$5777,
      #$82DB, #$67EF, #$68F5, #$78D5, #$9897, #$79D1, #$58F3, #$54B3,
      #$53EF, #$6E34, #$514B, #$523B, #$5BA2, #$8BFE, #$80AF, #$5543,
      #$57A6, #$6073, #$5751, #$542D, #$7A7A, #$6050, #$5B54, #$63A7,
      #$62A0, #$53E3, #$6263, #$5BC7, #$67AF, #$54ED, #$7A9F, #$82E6,
      #$9177, #$5E93, #$88E4, #$5938, #$57AE, #$630E, #$8DE8, #$80EF,
      #$5757, #$7B77, #$4FA9, #$5FEB, #$5BBD, #$6B3E, #$5321, #$7B50,
      #$72C2, #$6846, #$77FF, #$7736, #$65F7, #$51B5, #$4E8F, #$76D4,
      #$5CBF, #$7AA5, #$8475, #$594E, #$9B41, #$5080,
      #$9988, #$6127, #$6E83, #$5764, #$6606, #$6346, #$56F0, #$62EC,
      #$6269, #$5ED3, #$9614, #$5783, #$62C9, #$5587, #$8721, #$814A,
      #$8FA3, #$5566, #$83B1, #$6765, #$8D56, #$84DD, #$5A6A, #$680F,
      #$62E6, #$7BEE, #$9611, #$5170, #$6F9C, #$8C30, #$63FD, #$89C8,
      #$61D2, #$7F06, #$70C2, #$6EE5, #$7405, #$6994, #$72FC, #$5ECA,
      #$90CE, #$6717, #$6D6A, #$635E, #$52B3, #$7262, #$8001, #$4F6C,
      #$59E5, #$916A, #$70D9, #$6D9D, #$52D2, #$4E50, #$96F7, #$956D,
      #$857E, #$78CA, #$7D2F, #$5121, #$5792, #$64C2, #$808B, #$7C7B,
      #$6CEA, #$68F1, #$695E, #$51B7, #$5398, #$68A8, #$7281, #$9ECE,
      #$7BF1, #$72F8, #$79BB, #$6F13, #$7406, #$674E, #$91CC, #$9CA4,
      #$793C, #$8389, #$8354, #$540F, #$6817, #$4E3D, #$5389, #$52B1,
      #$783E, #$5386, #$5229, #$5088, #$4F8B, #$4FD0,
      #$75E2, #$7ACB, #$7C92, #$6CA5, #$96B6, #$529B, #$7483, #$54E9,
      #$4FE9, #$8054, #$83B2, #$8FDE, #$9570, #$5EC9, #$601C, #$6D9F,
      #$5E18, #$655B, #$8138, #$94FE, #$604B, #$70BC, #$7EC3, #$7CAE,
      #$51C9, #$6881, #$7CB1, #$826F, #$4E24, #$8F86, #$91CF, #$667E,
      #$4EAE, #$8C05, #$64A9, #$804A, #$50DA, #$7597, #$71CE, #$5BE5,
      #$8FBD, #$6F66, #$4E86, #$6482, #$9563, #$5ED6, #$6599, #$5217,
      #$88C2, #$70C8, #$52A3, #$730E, #$7433, #$6797, #$78F7, #$9716,
      #$4E34, #$90BB, #$9CDE, #$6DCB, #$51DB, #$8D41, #$541D, #$62CE,
      #$73B2, #$83F1, #$96F6, #$9F84, #$94C3, #$4F36, #$7F9A, #$51CC,
      #$7075, #$9675, #$5CAD, #$9886, #$53E6, #$4EE4, #$6E9C, #$7409,
      #$69B4, #$786B, #$998F, #$7559, #$5218, #$7624, #$6D41, #$67F3,
      #$516D, #$9F99, #$804B, #$5499, #$7B3C, #$7ABF,
      #$9686, #$5784, #$62E2, #$9647, #$697C, #$5A04, #$6402, #$7BD3,
      #$6F0F, #$964B, #$82A6, #$5362, #$9885, #$5E90, #$7089, #$63B3,
      #$5364, #$864F, #$9C81, #$9E93, #$788C, #$9732, #$8DEF, #$8D42,
      #$9E7F, #$6F5E, #$7984, #$5F55, #$9646, #$622E, #$9A74, #$5415,
      #$94DD, #$4FA3, #$65C5, #$5C65, #$5C61, #$7F15, #$8651, #$6C2F,
      #$5F8B, #$7387, #$6EE4, #$7EFF, #$5CE6, #$631B, #$5B6A, #$6EE6,
      #$5375, #$4E71, #$63A0, #$7565, #$62A1, #$8F6E, #$4F26, #$4ED1,
      #$6CA6, #$7EB6, #$8BBA, #$841D, #$87BA, #$7F57, #$903B, #$9523,
      #$7BA9, #$9AA1, #$88F8, #$843D, #$6D1B, #$9A86, #$7EDC, #$5988,
      #$9EBB, #$739B, #$7801, #$8682, #$9A6C, #$9A82, #$561B, #$5417,
      #$57CB, #$4E70, #$9EA6, #$5356, #$8FC8, #$8109, #$7792, #$9992,
      #$86EE, #$6EE1, #$8513, #$66FC, #$6162, #$6F2B,
      #$8C29, #$8292, #$832B, #$76F2, #$6C13, #$5FD9, #$83BD, #$732B,
      #$8305, #$951A, #$6BDB, #$77DB, #$94C6, #$536F, #$8302, #$5192,
      #$5E3D, #$8C8C, #$8D38, #$4E48, #$73AB, #$679A, #$6885, #$9176,
      #$9709, #$7164, #$6CA1, #$7709, #$5A92, #$9541, #$6BCF, #$7F8E,
      #$6627, #$5BD0, #$59B9, #$5A9A, #$95E8, #$95F7, #$4EEC, #$840C,
      #$8499, #$6AAC, #$76DF, #$9530, #$731B, #$68A6, #$5B5F, #$772F,
      #$919A, #$9761, #$7CDC, #$8FF7, #$8C1C, #$5F25, #$7C73, #$79D8,
      #$89C5, #$6CCC, #$871C, #$5BC6, #$5E42, #$68C9, #$7720, #$7EF5,
      #$5195, #$514D, #$52C9, #$5A29, #$7F05, #$9762, #$82D7, #$63CF,
      #$7784, #$85D0, #$79D2, #$6E3A, #$5E99, #$5999, #$8511, #$706D,
      #$6C11, #$62BF, #$76BF, #$654F, #$60AF, #$95FD, #$660E, #$879F,
      #$9E23, #$94ED, #$540D, #$547D, #$8C2C, #$6478,
      #$6479, #$8611, #$6A21, #$819C, #$78E8, #$6469, #$9B54, #$62B9,
      #$672B, #$83AB, #$58A8, #$9ED8, #$6CAB, #$6F20, #$5BDE, #$964C,
      #$8C0B, #$725F, #$67D0, #$62C7, #$7261, #$4EA9, #$59C6, #$6BCD,
      #$5893, #$66AE, #$5E55, #$52DF, #$6155, #$6728, #$76EE, #$7766,
      #$7267, #$7A46, #$62FF, #$54EA, #$5450, #$94A0, #$90A3, #$5A1C,
      #$7EB3, #$6C16, #$4E43, #$5976, #$8010, #$5948, #$5357, #$7537,
      #$96BE, #$56CA, #$6320, #$8111, #$607C, #$95F9, #$6DD6, #$5462,
      #$9981, #$5185, #$5AE9, #$80FD, #$59AE, #$9713, #$502A, #$6CE5,
      #$5C3C, #$62DF, #$4F60, #$533F, #$817B, #$9006, #$6EBA, #$852B,
      #$62C8, #$5E74, #$78BE, #$64B5, #$637B, #$5FF5, #$5A18, #$917F,
      #$9E1F, #$5C3F, #$634F, #$8042, #$5B7D, #$556E, #$954A, #$954D,
      #$6D85, #$60A8, #$67E0, #$72DE, #$51DD, #$5B81,
      #$62E7, #$6CDE, #$725B, #$626D, #$94AE, #$7EBD, #$8113, #$6D53,
      #$519C, #$5F04, #$5974, #$52AA, #$6012, #$5973, #$6696, #$8650,
      #$759F, #$632A, #$61E6, #$7CEF, #$8BFA, #$54E6, #$6B27, #$9E25,
      #$6BB4, #$85D5, #$5455, #$5076, #$6CA4, #$556A, #$8DB4, #$722C,
      #$5E15, #$6015, #$7436, #$62CD, #$6392, #$724C, #$5F98, #$6E43,
      #$6D3E, #$6500, #$6F58, #$76D8, #$78D0, #$76FC, #$7554, #$5224,
      #$53DB, #$4E53, #$5E9E, #$65C1, #$802A, #$80D6, #$629B, #$5486,
      #$5228, #$70AE, #$888D, #$8DD1, #$6CE1, #$5478, #$80DA, #$57F9,
      #$88F4, #$8D54, #$966A, #$914D, #$4F69, #$6C9B, #$55B7, #$76C6,
      #$7830, #$62A8, #$70F9, #$6F8E, #$5F6D, #$84EC, #$68DA, #$787C,
      #$7BF7, #$81A8, #$670B, #$9E4F, #$6367, #$78B0, #$576F, #$7812,
      #$9739, #$6279, #$62AB, #$5288, #$7435, #$6BD7,
      #$5564, #$813E, #$75B2, #$76AE, #$5339, #$75DE, #$50FB, #$5C41,
      #$8B6C, #$7BC7, #$504F, #$7247, #$9A97, #$98D8, #$6F02, #$74E2,
      #$7968, #$6487, #$77A5, #$62FC, #$9891, #$8D2B, #$54C1, #$8058,
      #$4E52, #$576A, #$82F9, #$840D, #$5E73, #$51ED, #$74F6, #$8BC4,
      #$5C4F, #$5761, #$6CFC, #$9887, #$5A46, #$7834, #$9B44, #$8FEB,
      #$7C95, #$5256, #$6251, #$94FA, #$4EC6, #$8386, #$8461, #$83E9,
      #$84B2, #$57D4, #$6734, #$5703, #$666E, #$6D66, #$8C31, #$66DD,
      #$7011, #$671F, #$6B3A, #$6816, #$621A, #$59BB, #$4E03, #$51C4,
      #$6F06, #$67D2, #$6C8F, #$5176, #$68CB, #$5947, #$6B67, #$7566,
      #$5D0E, #$8110, #$9F50, #$65D7, #$7948, #$7941, #$9A91, #$8D77,
      #$5C82, #$4E5E, #$4F01, #$542F, #$5951, #$780C, #$5668, #$6C14,
      #$8FC4, #$5F03, #$6C7D, #$6CE3, #$8BAB, #$6390,
      #$6070, #$6D3D, #$7275, #$6266, #$948E, #$94C5, #$5343, #$8FC1,
      #$7B7E, #$4EDF, #$8C26, #$4E7E, #$9ED4, #$94B1, #$94B3, #$524D,
      #$6F5C, #$9063, #$6D45, #$8C34, #$5811, #$5D4C, #$6B20, #$6B49,
      #$67AA, #$545B, #$8154, #$7F8C, #$5899, #$8537, #$5F3A, #$62A2,
      #$6A47, #$9539, #$6572, #$6084, #$6865, #$77A7, #$4E54, #$4FA8,
      #$5DE7, #$9798, #$64AC, #$7FD8, #$5CED, #$4FCF, #$7A8D, #$5207,
      #$8304, #$4E14, #$602F, #$7A83, #$94A6, #$4FB5, #$4EB2, #$79E6,
      #$7434, #$52E4, #$82B9, #$64D2, #$79BD, #$5BDD, #$6C81, #$9752,
      #$8F7B, #$6C22, #$503E, #$537F, #$6E05, #$64CE, #$6674, #$6C30,
      #$60C5, #$9877, #$8BF7, #$5E86, #$743C, #$7A77, #$79CB, #$4E18,
      #$90B1, #$7403, #$6C42, #$56DA, #$914B, #$6CC5, #$8D8B, #$533A,
      #$86C6, #$66F2, #$8EAF, #$5C48, #$9A71, #$6E20,
      #$53D6, #$5A36, #$9F8B, #$8DA3, #$53BB, #$5708, #$98A7, #$6743,
      #$919B, #$6CC9, #$5168, #$75CA, #$62F3, #$72AC, #$5238, #$529D,
      #$7F3A, #$7094, #$7638, #$5374, #$9E4A, #$69B7, #$786E, #$96C0,
      #$88D9, #$7FA4, #$7136, #$71C3, #$5189, #$67D3, #$74E4, #$58E4,
      #$6518, #$56B7, #$8BA9, #$9976, #$6270, #$7ED5, #$60F9, #$70ED,
      #$58EC, #$4EC1, #$4EBA, #$5FCD, #$97E7, #$4EFB, #$8BA4, #$5203,
      #$598A, #$7EAB, #$6254, #$4ECD, #$65E5, #$620E, #$8338, #$84C9,
      #$8363, #$878D, #$7194, #$6EB6, #$5BB9, #$7ED2, #$5197, #$63C9,
      #$67D4, #$8089, #$8339, #$8815, #$5112, #$5B7A, #$5982, #$8FB1,
      #$4E73, #$6C5D, #$5165, #$8925, #$8F6F, #$962E, #$854A, #$745E,
      #$9510, #$95F0, #$6DA6, #$82E5, #$5F31, #$6492, #$6D12, #$8428,
      #$816E, #$9CC3, #$585E, #$8D5B, #$4E09, #$53C1,
      #$4F1E, #$6563, #$6851, #$55D3, #$4E27, #$6414, #$9A9A, #$626B,
      #$5AC2, #$745F, #$8272, #$6DA9, #$68EE, #$50E7, #$838E, #$7802,
      #$6740, #$5239, #$6C99, #$7EB1, #$50BB, #$5565, #$715E, #$7B5B,
      #$6652, #$73CA, #$82EB, #$6749, #$5C71, #$5220, #$717D, #$886B,
      #$95EA, #$9655, #$64C5, #$8D61, #$81B3, #$5584, #$6C55, #$6247,
      #$7F2E, #$5892, #$4F24, #$5546, #$8D4F, #$664C, #$4E0A, #$5C1A,
      #$88F3, #$68A2, #$634E, #$7A0D, #$70E7, #$828D, #$52FA, #$97F6,
      #$5C11, #$54E8, #$90B5, #$7ECD, #$5962, #$8D4A, #$86C7, #$820C,
      #$820D, #$8D66, #$6444, #$5C04, #$6151, #$6D89, #$793E, #$8BBE,
      #$7837, #$7533, #$547B, #$4F38, #$8EAB, #$6DF1, #$5A20, #$7EC5,
      #$795E, #$6C88, #$5BA1, #$5A76, #$751A, #$80BE, #$614E, #$6E17,
      #$58F0, #$751F, #$7525, #$7272, #$5347, #$7EF3,
      #$7701, #$76DB, #$5269, #$80DC, #$5723, #$5E08, #$5931, #$72EE,
      #$65BD, #$6E7F, #$8BD7, #$5C38, #$8671, #$5341, #$77F3, #$62FE,
      #$65F6, #$4EC0, #$98DF, #$8680, #$5B9E, #$8BC6, #$53F2, #$77E2,
      #$4F7F, #$5C4E, #$9A76, #$59CB, #$5F0F, #$793A, #$58EB, #$4E16,
      #$67FF, #$4E8B, #$62ED, #$8A93, #$901D, #$52BF, #$662F, #$55DC,
      #$566C, #$9002, #$4ED5, #$4F8D, #$91CA, #$9970, #$6C0F, #$5E02,
      #$6043, #$5BA4, #$89C6, #$8BD5, #$6536, #$624B, #$9996, #$5B88,
      #$5BFF, #$6388, #$552E, #$53D7, #$7626, #$517D, #$852C, #$67A2,
      #$68B3, #$6B8A, #$6292, #$8F93, #$53D4, #$8212, #$6DD1, #$758F,
      #$4E66, #$8D4E, #$5B70, #$719F, #$85AF, #$6691, #$66D9, #$7F72,
      #$8700, #$9ECD, #$9F20, #$5C5E, #$672F, #$8FF0, #$6811, #$675F,
      #$620D, #$7AD6, #$5885, #$5EB6, #$6570, #$6F31,
      #$6055, #$5237, #$800D, #$6454, #$8870, #$7529, #$5E05, #$6813,
      #$62F4, #$971C, #$53CC, #$723D, #$8C01, #$6C34, #$7761, #$7A0E,
      #$542E, #$77AC, #$987A, #$821C, #$8BF4, #$7855, #$6714, #$70C1,
      #$65AF, #$6495, #$5636, #$601D, #$79C1, #$53F8, #$4E1D, #$6B7B,
      #$8086, #$5BFA, #$55E3, #$56DB, #$4F3A, #$4F3C, #$9972, #$5DF3,
      #$677E, #$8038, #$6002, #$9882, #$9001, #$5B8B, #$8BBC, #$8BF5,
      #$641C, #$8258, #$64DE, #$55FD, #$82CF, #$9165, #$4FD7, #$7D20,
      #$901F, #$7C9F, #$50F3, #$5851, #$6EAF, #$5BBF, #$8BC9, #$8083,
      #$9178, #$849C, #$7B97, #$867D, #$968B, #$968F, #$7EE5, #$9AD3,
      #$788E, #$5C81, #$7A57, #$9042, #$96A7, #$795F, #$5B59, #$635F,
      #$7B0B, #$84D1, #$68AD, #$5506, #$7F29, #$7410, #$7D22, #$9501,
      #$6240, #$584C, #$4ED6, #$5B83, #$5979, #$5854,
      #$736D, #$631E, #$8E4B, #$8E0F, #$80CE, #$82D4, #$62AC, #$53F0,
      #$6CF0, #$915E, #$592A, #$6001, #$6C70, #$574D, #$644A, #$8D2A,
      #$762B, #$6EE9, #$575B, #$6A80, #$75F0, #$6F6D, #$8C2D, #$8C08,
      #$5766, #$6BEF, #$8892, #$78B3, #$63A2, #$53F9, #$70AD, #$6C64,
      #$5858, #$642A, #$5802, #$68E0, #$819B, #$5510, #$7CD6, #$5018,
      #$8EBA, #$6DCC, #$8D9F, #$70EB, #$638F, #$6D9B, #$6ED4, #$7EE6,
      #$8404, #$6843, #$9003, #$6DD8, #$9676, #$8BA8, #$5957, #$7279,
      #$85E4, #$817E, #$75BC, #$8A8A, #$68AF, #$5254, #$8E22, #$9511,
      #$63D0, #$9898, #$8E44, #$557C, #$4F53, #$66FF, #$568F, #$60D5,
      #$6D95, #$5243, #$5C49, #$5929, #$6DFB, #$586B, #$7530, #$751C,
      #$606C, #$8214, #$8146, #$6311, #$6761, #$8FE2, #$773A, #$8DF3,
      #$8D34, #$94C1, #$5E16, #$5385, #$542C, #$70C3,
      #$6C40, #$5EF7, #$505C, #$4EAD, #$5EAD, #$633A, #$8247, #$901A,
      #$6850, #$916E, #$77B3, #$540C, #$94DC, #$5F64, #$7AE5, #$6876,
      #$6345, #$7B52, #$7EDF, #$75DB, #$5077, #$6295, #$5934, #$900F,
      #$51F8, #$79C3, #$7A81, #$56FE, #$5F92, #$9014, #$6D82, #$5C60,
      #$571F, #$5410, #$5154, #$6E4D, #$56E2, #$63A8, #$9893, #$817F,
      #$8715, #$892A, #$9000, #$541E, #$5C6F, #$81C0, #$62D6, #$6258,
      #$8131, #$9E35, #$9640, #$9A6E, #$9A7C, #$692D, #$59A5, #$62D3,
      #$553E, #$6316, #$54C7, #$86D9, #$6D3C, #$5A03, #$74E6, #$889C,
      #$6B6A, #$5916, #$8C4C, #$5F2F, #$6E7E, #$73A9, #$987D, #$4E38,
      #$70F7, #$5B8C, #$7897, #$633D, #$665A, #$7696, #$60CB, #$5B9B,
      #$5A49, #$4E07, #$8155, #$6C6A, #$738B, #$4EA1, #$6789, #$7F51,
      #$5F80, #$65FA, #$671B, #$5FD8, #$5984, #$5A01,
      #$5DCD, #$5FAE, #$5371, #$97E6, #$8FDD, #$6845, #$56F4, #$552F,
      #$60DF, #$4E3A, #$6F4D, #$7EF4, #$82C7, #$840E, #$59D4, #$4F1F,
      #$4F2A, #$5C3E, #$7EAC, #$672A, #$851A, #$5473, #$754F, #$80C3,
      #$5582, #$9B4F, #$4F4D, #$6E2D, #$8C13, #$5C09, #$6170, #$536B,
      #$761F, #$6E29, #$868A, #$6587, #$95FB, #$7EB9, #$543B, #$7A33,
      #$7D0A, #$95EE, #$55E1, #$7FC1, #$74EE, #$631D, #$8717, #$6DA1,
      #$7A9D, #$6211, #$65A1, #$5367, #$63E1, #$6C83, #$5DEB, #$545C,
      #$94A8, #$4E4C, #$6C61, #$8BEC, #$5C4B, #$65E0, #$829C, #$68A7,
      #$543E, #$5434, #$6BCB, #$6B66, #$4E94, #$6342, #$5348, #$821E,
      #$4F0D, #$4FAE, #$575E, #$620A, #$96FE, #$6664, #$7269, #$52FF,
      #$52A1, #$609F, #$8BEF, #$6614, #$7199, #$6790, #$897F, #$7852,
      #$77FD, #$6670, #$563B, #$5438, #$9521, #$727A,
      #$7A00, #$606F, #$5E0C, #$6089, #$819D, #$5915, #$60DC, #$7184,
      #$70EF, #$6EAA, #$6C50, #$7280, #$6A84, #$88AD, #$5E2D, #$4E60,
      #$5AB3, #$559C, #$94E3, #$6D17, #$7CFB, #$9699, #$620F, #$7EC6,
      #$778E, #$867E, #$5323, #$971E, #$8F96, #$6687, #$5CE1, #$4FA0,
      #$72ED, #$4E0B, #$53A6, #$590F, #$5413, #$6380, #$9528, #$5148,
      #$4ED9, #$9C9C, #$7EA4, #$54B8, #$8D24, #$8854, #$8237, #$95F2,
      #$6D8E, #$5F26, #$5ACC, #$663E, #$9669, #$73B0, #$732E, #$53BF,
      #$817A, #$9985, #$7FA1, #$5BAA, #$9677, #$9650, #$7EBF, #$76F8,
      #$53A2, #$9576, #$9999, #$7BB1, #$8944, #$6E58, #$4E61, #$7FD4,
      #$7965, #$8BE6, #$60F3, #$54CD, #$4EAB, #$9879, #$5DF7, #$6A61,
      #$50CF, #$5411, #$8C61, #$8427, #$785D, #$9704, #$524A, #$54EE,
      #$56A3, #$9500, #$6D88, #$5BB5, #$6DC6, #$6653,
      #$5C0F, #$5B5D, #$6821, #$8096, #$5578, #$7B11, #$6548, #$6954,
      #$4E9B, #$6B47, #$874E, #$978B, #$534F, #$631F, #$643A, #$90AA,
      #$659C, #$80C1, #$8C10, #$5199, #$68B0, #$5378, #$87F9, #$61C8,
      #$6CC4, #$6CFB, #$8C22, #$5C51, #$85AA, #$82AF, #$950C, #$6B23,
      #$8F9B, #$65B0, #$5FFB, #$5FC3, #$4FE1, #$8845, #$661F, #$8165,
      #$7329, #$60FA, #$5174, #$5211, #$578B, #$5F62, #$90A2, #$884C,
      #$9192, #$5E78, #$674F, #$6027, #$59D3, #$5144, #$51F6, #$80F8,
      #$5308, #$6C79, #$96C4, #$718A, #$4F11, #$4FEE, #$7F9E, #$673D,
      #$55C5, #$9508, #$79C0, #$8896, #$7EE3, #$589F, #$620C, #$9700,
      #$865A, #$5618, #$987B, #$5F90, #$8BB8, #$84C4, #$9157, #$53D9,
      #$65ED, #$5E8F, #$755C, #$6064, #$7D6E, #$5A7F, #$7EEA, #$7EED,
      #$8F69, #$55A7, #$5BA3, #$60AC, #$65CB, #$7384,
      #$9009, #$7663, #$7729, #$7EDA, #$9774, #$859B, #$5B66, #$7A74,
      #$96EA, #$8840, #$52CB, #$718F, #$5FAA, #$65EC, #$8BE2, #$5BFB,
      #$9A6F, #$5DE1, #$6B89, #$6C5B, #$8BAD, #$8BAF, #$900A, #$8FC5,
      #$538B, #$62BC, #$9E26, #$9E2D, #$5440, #$4E2B, #$82BD, #$7259,
      #$869C, #$5D16, #$8859, #$6DAF, #$96C5, #$54D1, #$4E9A, #$8BB6,
      #$7109, #$54BD, #$9609, #$70DF, #$6DF9, #$76D0, #$4E25, #$7814,
      #$8712, #$5CA9, #$5EF6, #$8A00, #$989C, #$960E, #$708E, #$6CBF,
      #$5944, #$63A9, #$773C, #$884D, #$6F14, #$8273, #$5830, #$71D5,
      #$538C, #$781A, #$96C1, #$5501, #$5F66, #$7130, #$5BB4, #$8C1A,
      #$9A8C, #$6B83, #$592E, #$9E2F, #$79E7, #$6768, #$626C, #$4F6F,
      #$75A1, #$7F8A, #$6D0B, #$9633, #$6C27, #$4EF0, #$75D2, #$517B,
      #$6837, #$6F3E, #$9080, #$8170, #$5996, #$7476,
      #$6447, #$5C27, #$9065, #$7A91, #$8C23, #$59DA, #$54AC, #$8200,
      #$836F, #$8981, #$8000, #$6930, #$564E, #$8036, #$7237, #$91CE,
      #$51B6, #$4E5F, #$9875, #$6396, #$4E1A, #$53F6, #$66F3, #$814B,
      #$591C, #$6DB2, #$4E00, #$58F9, #$533B, #$63D6, #$94F1, #$4F9D,
      #$4F0A, #$8863, #$9890, #$5937, #$9057, #$79FB, #$4EEA, #$80F0,
      #$7591, #$6C82, #$5B9C, #$59E8, #$5F5D, #$6905, #$8681, #$501A,
      #$5DF2, #$4E59, #$77E3, #$4EE5, #$827A, #$6291, #$6613, #$9091,
      #$5C79, #$4EBF, #$5F79, #$81C6, #$9038, #$8084, #$75AB, #$4EA6,
      #$88D4, #$610F, #$6BC5, #$5FC6, #$4E49, #$76CA, #$6EA2, #$8BE3,
      #$8BAE, #$8C0A, #$8BD1, #$5F02, #$7FFC, #$7FCC, #$7ECE, #$8335,
      #$836B, #$56E0, #$6BB7, #$97F3, #$9634, #$59FB, #$541F, #$94F6,
      #$6DEB, #$5BC5, #$996E, #$5C39, #$5F15, #$9690,
      #$5370, #$82F1, #$6A31, #$5A74, #$9E70, #$5E94, #$7F28, #$83B9,
      #$8424, #$8425, #$8367, #$8747, #$8FCE, #$8D62, #$76C8, #$5F71,
      #$9896, #$786C, #$6620, #$54DF, #$62E5, #$4F63, #$81C3, #$75C8,
      #$5EB8, #$96CD, #$8E0A, #$86F9, #$548F, #$6CF3, #$6D8C, #$6C38,
      #$607F, #$52C7, #$7528, #$5E7D, #$4F18, #$60A0, #$5FE7, #$5C24,
      #$7531, #$90AE, #$94C0, #$72B9, #$6CB9, #$6E38, #$9149, #$6709,
      #$53CB, #$53F3, #$4F51, #$91C9, #$8BF1, #$53C8, #$5E7C, #$8FC2,
      #$6DE4, #$4E8E, #$76C2, #$6986, #$865E, #$611A, #$8206, #$4F59,
      #$4FDE, #$903E, #$9C7C, #$6109, #$6E1D, #$6E14, #$9685, #$4E88,
      #$5A31, #$96E8, #$4E0E, #$5C7F, #$79B9, #$5B87, #$8BED, #$7FBD,
      #$7389, #$57DF, #$828B, #$90C1, #$5401, #$9047, #$55BB, #$5CEA,
      #$5FA1, #$6108, #$6B32, #$72F1, #$80B2, #$8A89,
      #$6D74, #$5BD3, #$88D5, #$9884, #$8C6B, #$9A6D, #$9E33, #$6E0A,
      #$51A4, #$5143, #$57A3, #$8881, #$539F, #$63F4, #$8F95, #$56ED,
      #$5458, #$5706, #$733F, #$6E90, #$7F18, #$8FDC, #$82D1, #$613F,
      #$6028, #$9662, #$66F0, #$7EA6, #$8D8A, #$8DC3, #$94A5, #$5CB3,
      #$7CA4, #$6708, #$60A6, #$9605, #$8018, #$4E91, #$90E7, #$5300,
      #$9668, #$5141, #$8FD0, #$8574, #$915D, #$6655, #$97F5, #$5B55,
      #$531D, #$7838, #$6742, #$683D, #$54C9, #$707E, #$5BB0, #$8F7D,
      #$518D, #$5728, #$54B1, #$6512, #$6682, #$8D5E, #$8D43, #$810F,
      #$846C, #$906D, #$7CDF, #$51FF, #$85FB, #$67A3, #$65E9, #$6FA1,
      #$86A4, #$8E81, #$566A, #$9020, #$7682, #$7076, #$71E5, #$8D23,
      #$62E9, #$5219, #$6CFD, #$8D3C, #$600E, #$589E, #$618E, #$66FE,
      #$8D60, #$624E, #$55B3, #$6E23, #$672D, #$8F67,
      #$94E1, #$95F8, #$7728, #$6805, #$69A8, #$548B, #$4E4D, #$70B8,
      #$8BC8, #$6458, #$658B, #$5B85, #$7A84, #$503A, #$5BE8, #$77BB,
      #$6BE1, #$8A79, #$7C98, #$6CBE, #$76CF, #$65A9, #$8F97, #$5D2D,
      #$5C55, #$8638, #$6808, #$5360, #$6218, #$7AD9, #$6E5B, #$7EFD,
      #$6A1F, #$7AE0, #$5F70, #$6F33, #$5F20, #$638C, #$6DA8, #$6756,
      #$4E08, #$5E10, #$8D26, #$4ED7, #$80C0, #$7634, #$969C, #$62DB,
      #$662D, #$627E, #$6CBC, #$8D75, #$7167, #$7F69, #$5146, #$8087,
      #$53EC, #$906E, #$6298, #$54F2, #$86F0, #$8F99, #$8005, #$9517,
      #$8517, #$8FD9, #$6D59, #$73CD, #$659F, #$771F, #$7504, #$7827,
      #$81FB, #$8D1E, #$9488, #$4FA6, #$6795, #$75B9, #$8BCA, #$9707,
      #$632F, #$9547, #$9635, #$84B8, #$6323, #$7741, #$5F81, #$72F0,
      #$4E89, #$6014, #$6574, #$62EF, #$6B63, #$653F,
      #$5E27, #$75C7, #$90D1, #$8BC1, #$829D, #$679D, #$652F, #$5431,
      #$8718, #$77E5, #$80A2, #$8102, #$6C41, #$4E4B, #$7EC7, #$804C,
      #$76F4, #$690D, #$6B96, #$6267, #$503C, #$4F84, #$5740, #$6307,
      #$6B62, #$8DBE, #$53EA, #$65E8, #$7EB8, #$5FD7, #$631A, #$63B7,
      #$81F3, #$81F4, #$7F6E, #$5E1C, #$5CD9, #$5236, #$667A, #$79E9,
      #$7A1A, #$8D28, #$7099, #$75D4, #$6EDE, #$6CBB, #$7A92, #$4E2D,
      #$76C5, #$5FE0, #$949F, #$8877, #$7EC8, #$79CD, #$80BF, #$91CD,
      #$4EF2, #$4F17, #$821F, #$5468, #$5DDE, #$6D32, #$8BCC, #$7CA5,
      #$8F74, #$8098, #$5E1A, #$5492, #$76B1, #$5B99, #$663C, #$9AA4,
      #$73E0, #$682A, #$86DB, #$6731, #$732A, #$8BF8, #$8BDB, #$9010,
      #$7AF9, #$70DB, #$716E, #$62C4, #$77A9, #$5631, #$4E3B, #$8457,
      #$67F1, #$52A9, #$86C0, #$8D2E, #$94F8, #$7B51,
      #$4F4F, #$6CE8, #$795D, #$9A7B, #$6293, #$722A, #$62FD, #$4E13,
      #$7816, #$8F6C, #$64B0, #$8D5A, #$7BC6, #$6869, #$5E84, #$88C5,
      #$5986, #$649E, #$58EE, #$72B6, #$690E, #$9525, #$8FFD, #$8D58,
      #$5760, #$7F00, #$8C06, #$51C6, #$6349, #$62D9, #$5353, #$684C,
      #$7422, #$8301, #$914C, #$5544, #$7740, #$707C, #$6D4A, #$5179,
      #$54A8, #$8D44, #$59FF, #$6ECB, #$6DC4, #$5B5C, #$7D2B, #$4ED4,
      #$7C7D, #$6ED3, #$5B50, #$81EA, #$6E0D, #$5B57, #$9B03, #$68D5,
      #$8E2A, #$5B97, #$7EFC, #$603B, #$7EB5, #$90B9, #$8D70, #$594F,
      #$63CD, #$79DF, #$8DB3, #$5352, #$65CF, #$7956, #$8BC5, #$963B,
      #$7EC4, #$94BB, #$7E82, #$5634, #$9189, #$6700, #$7F6A, #$5C0A,
      #$9075, #$6628, #$5DE6, #$4F50, #$67DE, #$505A, #$4F5C, #$5750,
      #$5EA7, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$4E8D, #$4E0C, #$5140, #$4E10, #$5EFF, #$5345, #$4E15, #$4E98,
      #$4E1E, #$9B32, #$5B6C, #$5669, #$4E28, #$79BA, #$4E3F, #$5315,
      #$4E47, #$592D, #$723B, #$536E, #$6C10, #$56DF, #$80E4, #$9997,
      #$6BD3, #$777E, #$9F17, #$4E36, #$4E9F, #$9F10, #$4E5C, #$4E69,
      #$4E93, #$8288, #$5B5B, #$556C, #$560F, #$4EC4, #$538D, #$539D,
      #$53A3, #$53A5, #$53AE, #$9765, #$8D5D, #$531A, #$53F5, #$5326,
      #$532E, #$533E, #$8D5C, #$5366, #$5363, #$5202, #$5208, #$520E,
      #$522D, #$5233, #$523F, #$5240, #$524C, #$525E, #$5261, #$525C,
      #$84AF, #$527D, #$5282, #$5281, #$5290, #$5293, #$5182, #$7F54,
      #$4EBB, #$4EC3, #$4EC9, #$4EC2, #$4EE8, #$4EE1, #$4EEB, #$4EDE,
      #$4F1B, #$4EF3, #$4F22, #$4F64, #$4EF5, #$4F25, #$4F27, #$4F09,
      #$4F2B, #$4F5E, #$4F67, #$6538, #$4F5A, #$4F5D,
      #$4F5F, #$4F57, #$4F32, #$4F3D, #$4F76, #$4F74, #$4F91, #$4F89,
      #$4F83, #$4F8F, #$4F7E, #$4F7B, #$4FAA, #$4F7C, #$4FAC, #$4F94,
      #$4FE6, #$4FE8, #$4FEA, #$4FC5, #$4FDA, #$4FE3, #$4FDC, #$4FD1,
      #$4FDF, #$4FF8, #$5029, #$504C, #$4FF3, #$502C, #$500F, #$502E,
      #$502D, #$4FFE, #$501C, #$500C, #$5025, #$5028, #$507E, #$5043,
      #$5055, #$5048, #$504E, #$506C, #$507B, #$50A5, #$50A7, #$50A9,
      #$50BA, #$50D6, #$5106, #$50ED, #$50EC, #$50E6, #$50EE, #$5107,
      #$510B, #$4EDD, #$6C3D, #$4F58, #$4F65, #$4FCE, #$9FA0, #$6C46,
      #$7C74, #$516E, #$5DFD, #$9EC9, #$9998, #$5181, #$5914, #$52F9,
      #$530D, #$8A07, #$5310, #$51EB, #$5919, #$5155, #$4EA0, #$5156,
      #$4EB3, #$886E, #$88A4, #$4EB5, #$8114, #$88D2, #$7980, #$5B34,
      #$8803, #$7FB8, #$51AB, #$51B1, #$51BD, #$51BC,
      #$51C7, #$5196, #$51A2, #$51A5, #$8BA0, #$8BA6, #$8BA7, #$8BAA,
      #$8BB4, #$8BB5, #$8BB7, #$8BC2, #$8BC3, #$8BCB, #$8BCF, #$8BCE,
      #$8BD2, #$8BD3, #$8BD4, #$8BD6, #$8BD8, #$8BD9, #$8BDC, #$8BDF,
      #$8BE0, #$8BE4, #$8BE8, #$8BE9, #$8BEE, #$8BF0, #$8BF3, #$8BF6,
      #$8BF9, #$8BFC, #$8BFF, #$8C00, #$8C02, #$8C04, #$8C07, #$8C0C,
      #$8C0F, #$8C11, #$8C12, #$8C14, #$8C15, #$8C16, #$8C19, #$8C1B,
      #$8C18, #$8C1D, #$8C1F, #$8C20, #$8C21, #$8C25, #$8C27, #$8C2A,
      #$8C2B, #$8C2E, #$8C2F, #$8C32, #$8C33, #$8C35, #$8C36, #$5369,
      #$537A, #$961D, #$9622, #$9621, #$9631, #$962A, #$963D, #$963C,
      #$9642, #$9649, #$9654, #$965F, #$9667, #$966C, #$9672, #$9674,
      #$9688, #$968D, #$9697, #$96B0, #$9097, #$909B, #$909D, #$9099,
      #$90AC, #$90A1, #$90B4, #$90B3, #$90B6, #$90BA,
      #$90B8, #$90B0, #$90CF, #$90C5, #$90BE, #$90D0, #$90C4, #$90C7,
      #$90D3, #$90E6, #$90E2, #$90DC, #$90D7, #$90DB, #$90EB, #$90EF,
      #$90FE, #$9104, #$9122, #$911E, #$9123, #$9131, #$912F, #$9139,
      #$9143, #$9146, #$520D, #$5942, #$52A2, #$52AC, #$52AD, #$52BE,
      #$54FF, #$52D0, #$52D6, #$52F0, #$53DF, #$71EE, #$77CD, #$5EF4,
      #$51F5, #$51FC, #$9B2F, #$53B6, #$5F01, #$755A, #$5DEF, #$574C,
      #$57A9, #$57A1, #$587E, #$58BC, #$58C5, #$58D1, #$5729, #$572C,
      #$572A, #$5733, #$5739, #$572E, #$572F, #$575C, #$573B, #$5742,
      #$5769, #$5785, #$576B, #$5786, #$577C, #$577B, #$5768, #$576D,
      #$5776, #$5773, #$57AD, #$57A4, #$578C, #$57B2, #$57CF, #$57A7,
      #$57B4, #$5793, #$57A0, #$57D5, #$57D8, #$57DA, #$57D9, #$57D2,
      #$57B8, #$57F4, #$57EF, #$57F8, #$57E4, #$57DD,
      #$580B, #$580D, #$57FD, #$57ED, #$5800, #$581E, #$5819, #$5844,
      #$5820, #$5865, #$586C, #$5881, #$5889, #$589A, #$5880, #$99A8,
      #$9F19, #$61FF, #$8279, #$827D, #$827F, #$828F, #$828A, #$82A8,
      #$8284, #$828E, #$8291, #$8297, #$8299, #$82AB, #$82B8, #$82BE,
      #$82B0, #$82C8, #$82CA, #$82E3, #$8298, #$82B7, #$82AE, #$82CB,
      #$82CC, #$82C1, #$82A9, #$82B4, #$82A1, #$82AA, #$829F, #$82C4,
      #$82CE, #$82A4, #$82E1, #$8309, #$82F7, #$82E4, #$830F, #$8307,
      #$82DC, #$82F4, #$82D2, #$82D8, #$830C, #$82FB, #$82D3, #$8311,
      #$831A, #$8306, #$8314, #$8315, #$82E0, #$82D5, #$831C, #$8351,
      #$835B, #$835C, #$8308, #$8392, #$833C, #$8334, #$8331, #$839B,
      #$835E, #$832F, #$834F, #$8347, #$8343, #$835F, #$8340, #$8317,
      #$8360, #$832D, #$833A, #$8333, #$8366, #$8365,
      #$8368, #$831B, #$8369, #$836C, #$836A, #$836D, #$836E, #$83B0,
      #$8378, #$83B3, #$83B4, #$83A0, #$83AA, #$8393, #$839C, #$8385,
      #$837C, #$83B6, #$83A9, #$837D, #$83B8, #$837B, #$8398, #$839E,
      #$83A8, #$83BA, #$83BC, #$83C1, #$8401, #$83E5, #$83D8, #$5807,
      #$8418, #$840B, #$83DD, #$83FD, #$83D6, #$841C, #$8438, #$8411,
      #$8406, #$83D4, #$83DF, #$840F, #$8403, #$83F8, #$83F9, #$83EA,
      #$83C5, #$83C0, #$8426, #$83F0, #$83E1, #$845C, #$8451, #$845A,
      #$8459, #$8473, #$8487, #$8488, #$847A, #$8489, #$8478, #$843C,
      #$8446, #$8469, #$8476, #$848C, #$848E, #$8431, #$846D, #$84C1,
      #$84CD, #$84D0, #$84E6, #$84BD, #$84D3, #$84CA, #$84BF, #$84BA,
      #$84E0, #$84A1, #$84B9, #$84B4, #$8497, #$84E5, #$84E3, #$850C,
      #$750D, #$8538, #$84F0, #$8539, #$851F, #$853A,
      #$8556, #$853B, #$84FF, #$84FC, #$8559, #$8548, #$8568, #$8564,
      #$855E, #$857A, #$77A2, #$8543, #$8572, #$857B, #$85A4, #$85A8,
      #$8587, #$858F, #$8579, #$85AE, #$859C, #$8585, #$85B9, #$85B7,
      #$85B0, #$85D3, #$85C1, #$85DC, #$85FF, #$8627, #$8605, #$8629,
      #$8616, #$863C, #$5EFE, #$5F08, #$593C, #$5941, #$8037, #$5955,
      #$595A, #$5958, #$530F, #$5C22, #$5C25, #$5C2C, #$5C34, #$624C,
      #$626A, #$629F, #$62BB, #$62CA, #$62DA, #$62D7, #$62EE, #$6322,
      #$62F6, #$6339, #$634B, #$6343, #$63AD, #$63F6, #$6371, #$637A,
      #$638E, #$63B4, #$636D, #$63AC, #$638A, #$6369, #$63AE, #$63BC,
      #$63F2, #$63F8, #$63E0, #$63FF, #$63C4, #$63DE, #$63CE, #$6452,
      #$63C6, #$63BE, #$6445, #$6441, #$640B, #$641B, #$6420, #$640C,
      #$6426, #$6421, #$645E, #$6484, #$646D, #$6496,
      #$647A, #$64B7, #$64B8, #$6499, #$64BA, #$64C0, #$64D0, #$64D7,
      #$64E4, #$64E2, #$6509, #$6525, #$652E, #$5F0B, #$5FD2, #$7519,
      #$5F11, #$535F, #$53F1, #$53FD, #$53E9, #$53E8, #$53FB, #$5412,
      #$5416, #$5406, #$544B, #$5452, #$5453, #$5454, #$5456, #$5443,
      #$5421, #$5457, #$5459, #$5423, #$5432, #$5482, #$5494, #$5477,
      #$5471, #$5464, #$549A, #$549B, #$5484, #$5476, #$5466, #$549D,
      #$54D0, #$54AD, #$54C2, #$54B4, #$54D2, #$54A7, #$54A6, #$54D3,
      #$54D4, #$5472, #$54A3, #$54D5, #$54BB, #$54BF, #$54CC, #$54D9,
      #$54DA, #$54DC, #$54A9, #$54AA, #$54A4, #$54DD, #$54CF, #$54DE,
      #$551B, #$54E7, #$5520, #$54FD, #$5514, #$54F3, #$5522, #$5523,
      #$550F, #$5511, #$5527, #$552A, #$5567, #$558F, #$55B5, #$5549,
      #$556D, #$5541, #$5555, #$553F, #$5550, #$553C,
      #$5537, #$5556, #$5575, #$5576, #$5577, #$5533, #$5530, #$555C,
      #$558B, #$55D2, #$5583, #$55B1, #$55B9, #$5588, #$5581, #$559F,
      #$557E, #$55D6, #$5591, #$557B, #$55DF, #$55BD, #$55BE, #$5594,
      #$5599, #$55EA, #$55F7, #$55C9, #$561F, #$55D1, #$55EB, #$55EC,
      #$55D4, #$55E6, #$55DD, #$55C4, #$55EF, #$55E5, #$55F2, #$55F3,
      #$55CC, #$55CD, #$55E8, #$55F5, #$55E4, #$8F94, #$561E, #$5608,
      #$560C, #$5601, #$5624, #$5623, #$55FE, #$5600, #$5627, #$562D,
      #$5658, #$5639, #$5657, #$562C, #$564D, #$5662, #$5659, #$565C,
      #$564C, #$5654, #$5686, #$5664, #$5671, #$566B, #$567B, #$567C,
      #$5685, #$5693, #$56AF, #$56D4, #$56D7, #$56DD, #$56E1, #$56F5,
      #$56EB, #$56F9, #$56FF, #$5704, #$570A, #$5709, #$571C, #$5E0F,
      #$5E19, #$5E14, #$5E11, #$5E31, #$5E3B, #$5E3C,
      #$5E37, #$5E44, #$5E54, #$5E5B, #$5E5E, #$5E61, #$5C8C, #$5C7A,
      #$5C8D, #$5C90, #$5C96, #$5C88, #$5C98, #$5C99, #$5C91, #$5C9A,
      #$5C9C, #$5CB5, #$5CA2, #$5CBD, #$5CAC, #$5CAB, #$5CB1, #$5CA3,
      #$5CC1, #$5CB7, #$5CC4, #$5CD2, #$5CE4, #$5CCB, #$5CE5, #$5D02,
      #$5D03, #$5D27, #$5D26, #$5D2E, #$5D24, #$5D1E, #$5D06, #$5D1B,
      #$5D58, #$5D3E, #$5D34, #$5D3D, #$5D6C, #$5D5B, #$5D6F, #$5D5D,
      #$5D6B, #$5D4B, #$5D4A, #$5D69, #$5D74, #$5D82, #$5D99, #$5D9D,
      #$8C73, #$5DB7, #$5DC5, #$5F73, #$5F77, #$5F82, #$5F87, #$5F89,
      #$5F8C, #$5F95, #$5F99, #$5F9C, #$5FA8, #$5FAD, #$5FB5, #$5FBC,
      #$8862, #$5F61, #$72AD, #$72B0, #$72B4, #$72B7, #$72B8, #$72C3,
      #$72C1, #$72CE, #$72CD, #$72D2, #$72E8, #$72EF, #$72E9, #$72F2,
      #$72F4, #$72F7, #$7301, #$72F3, #$7303, #$72FA,
      #$72FB, #$7317, #$7313, #$7321, #$730A, #$731E, #$731D, #$7315,
      #$7322, #$7339, #$7325, #$732C, #$7338, #$7331, #$7350, #$734D,
      #$7357, #$7360, #$736C, #$736F, #$737E, #$821B, #$5925, #$98E7,
      #$5924, #$5902, #$9963, #$9967, #$9968, #$9969, #$996A, #$996B,
      #$996C, #$9974, #$9977, #$997D, #$9980, #$9984, #$9987, #$998A,
      #$998D, #$9990, #$9991, #$9993, #$9994, #$9995, #$5E80, #$5E91,
      #$5E8B, #$5E96, #$5EA5, #$5EA0, #$5EB9, #$5EB5, #$5EBE, #$5EB3,
      #$8D53, #$5ED2, #$5ED1, #$5EDB, #$5EE8, #$5EEA, #$81BA, #$5FC4,
      #$5FC9, #$5FD6, #$5FCF, #$6003, #$5FEE, #$6004, #$5FE1, #$5FE4,
      #$5FFE, #$6005, #$6006, #$5FEA, #$5FED, #$5FF8, #$6019, #$6035,
      #$6026, #$601B, #$600F, #$600D, #$6029, #$602B, #$600A, #$603F,
      #$6021, #$6078, #$6079, #$607B, #$607A, #$6042,
      #$606A, #$607D, #$6096, #$609A, #$60AD, #$609D, #$6083, #$6092,
      #$608C, #$609B, #$60EC, #$60BB, #$60B1, #$60DD, #$60D8, #$60C6,
      #$60DA, #$60B4, #$6120, #$6126, #$6115, #$6123, #$60F4, #$6100,
      #$610E, #$612B, #$614A, #$6175, #$61AC, #$6194, #$61A7, #$61B7,
      #$61D4, #$61F5, #$5FDD, #$96B3, #$95E9, #$95EB, #$95F1, #$95F3,
      #$95F5, #$95F6, #$95FC, #$95FE, #$9603, #$9604, #$9606, #$9608,
      #$960A, #$960B, #$960C, #$960D, #$960F, #$9612, #$9615, #$9616,
      #$9617, #$9619, #$961A, #$4E2C, #$723F, #$6215, #$6C35, #$6C54,
      #$6C5C, #$6C4A, #$6CA3, #$6C85, #$6C90, #$6C94, #$6C8C, #$6C68,
      #$6C69, #$6C74, #$6C76, #$6C86, #$6CA9, #$6CD0, #$6CD4, #$6CAD,
      #$6CF7, #$6CF8, #$6CF1, #$6CD7, #$6CB2, #$6CE0, #$6CD6, #$6CFA,
      #$6CEB, #$6CEE, #$6CB1, #$6CD3, #$6CEF, #$6CFE,
      #$6D39, #$6D27, #$6D0C, #$6D43, #$6D48, #$6D07, #$6D04, #$6D19,
      #$6D0E, #$6D2B, #$6D4D, #$6D2E, #$6D35, #$6D1A, #$6D4F, #$6D52,
      #$6D54, #$6D33, #$6D91, #$6D6F, #$6D9E, #$6DA0, #$6D5E, #$6D93,
      #$6D94, #$6D5C, #$6D60, #$6D7C, #$6D63, #$6E1A, #$6DC7, #$6DC5,
      #$6DDE, #$6E0E, #$6DBF, #$6DE0, #$6E11, #$6DE6, #$6DDD, #$6DD9,
      #$6E16, #$6DAB, #$6E0C, #$6DAE, #$6E2B, #$6E6E, #$6E4E, #$6E6B,
      #$6EB2, #$6E5F, #$6E86, #$6E53, #$6E54, #$6E32, #$6E25, #$6E44,
      #$6EDF, #$6EB1, #$6E98, #$6EE0, #$6F2D, #$6EE2, #$6EA5, #$6EA7,
      #$6EBD, #$6EBB, #$6EB7, #$6ED7, #$6EB4, #$6ECF, #$6E8F, #$6EC2,
      #$6E9F, #$6F62, #$6F46, #$6F47, #$6F24, #$6F15, #$6EF9, #$6F2F,
      #$6F36, #$6F4B, #$6F74, #$6F2A, #$6F09, #$6F29, #$6F89, #$6F8D,
      #$6F8C, #$6F78, #$6F72, #$6F7C, #$6F7A, #$6FD1,
      #$6FC9, #$6FA7, #$6FB9, #$6FB6, #$6FC2, #$6FE1, #$6FEE, #$6FDE,
      #$6FE0, #$6FEF, #$701A, #$7023, #$701B, #$7039, #$7035, #$704F,
      #$705E, #$5B80, #$5B84, #$5B95, #$5B93, #$5BA5, #$5BB8, #$752F,
      #$9A9E, #$6434, #$5BE4, #$5BEE, #$8930, #$5BF0, #$8E47, #$8B07,
      #$8FB6, #$8FD3, #$8FD5, #$8FE5, #$8FEE, #$8FE4, #$8FE9, #$8FE6,
      #$8FF3, #$8FE8, #$9005, #$9004, #$900B, #$9026, #$9011, #$900D,
      #$9016, #$9021, #$9035, #$9036, #$902D, #$902F, #$9044, #$9051,
      #$9052, #$9050, #$9068, #$9058, #$9062, #$905B, #$66B9, #$9074,
      #$907D, #$9082, #$9088, #$9083, #$908B, #$5F50, #$5F57, #$5F56,
      #$5F58, #$5C3B, #$54AB, #$5C50, #$5C59, #$5B71, #$5C63, #$5C66,
      #$7FBC, #$5F2A, #$5F29, #$5F2D, #$8274, #$5F3C, #$9B3B, #$5C6E,
      #$5981, #$5983, #$598D, #$59A9, #$59AA, #$59A3,
      #$5997, #$59CA, #$59AB, #$599E, #$59A4, #$59D2, #$59B2, #$59AF,
      #$59D7, #$59BE, #$5A05, #$5A06, #$59DD, #$5A08, #$59E3, #$59D8,
      #$59F9, #$5A0C, #$5A09, #$5A32, #$5A34, #$5A11, #$5A23, #$5A13,
      #$5A40, #$5A67, #$5A4A, #$5A55, #$5A3C, #$5A62, #$5A75, #$80EC,
      #$5AAA, #$5A9B, #$5A77, #$5A7A, #$5ABE, #$5AEB, #$5AB2, #$5AD2,
      #$5AD4, #$5AB8, #$5AE0, #$5AE3, #$5AF1, #$5AD6, #$5AE6, #$5AD8,
      #$5ADC, #$5B09, #$5B17, #$5B16, #$5B32, #$5B37, #$5B40, #$5C15,
      #$5C1C, #$5B5A, #$5B65, #$5B73, #$5B51, #$5B53, #$5B62, #$9A75,
      #$9A77, #$9A78, #$9A7A, #$9A7F, #$9A7D, #$9A80, #$9A81, #$9A85,
      #$9A88, #$9A8A, #$9A90, #$9A92, #$9A93, #$9A96, #$9A98, #$9A9B,
      #$9A9C, #$9A9D, #$9A9F, #$9AA0, #$9AA2, #$9AA3, #$9AA5, #$9AA7,
      #$7E9F, #$7EA1, #$7EA3, #$7EA5, #$7EA8, #$7EA9,
      #$7EAD, #$7EB0, #$7EBE, #$7EC0, #$7EC1, #$7EC2, #$7EC9, #$7ECB,
      #$7ECC, #$7ED0, #$7ED4, #$7ED7, #$7EDB, #$7EE0, #$7EE1, #$7EE8,
      #$7EEB, #$7EEE, #$7EEF, #$7EF1, #$7EF2, #$7F0D, #$7EF6, #$7EFA,
      #$7EFB, #$7EFE, #$7F01, #$7F02, #$7F03, #$7F07, #$7F08, #$7F0B,
      #$7F0C, #$7F0F, #$7F11, #$7F12, #$7F17, #$7F19, #$7F1C, #$7F1B,
      #$7F1F, #$7F21, #$7F22, #$7F23, #$7F24, #$7F25, #$7F26, #$7F27,
      #$7F2A, #$7F2B, #$7F2C, #$7F2D, #$7F2F, #$7F30, #$7F31, #$7F32,
      #$7F33, #$7F35, #$5E7A, #$757F, #$5DDB, #$753E, #$9095, #$738E,
      #$7391, #$73AE, #$73A2, #$739F, #$73CF, #$73C2, #$73D1, #$73B7,
      #$73B3, #$73C0, #$73C9, #$73C8, #$73E5, #$73D9, #$987C, #$740A,
      #$73E9, #$73E7, #$73DE, #$73BA, #$73F2, #$740F, #$742A, #$745B,
      #$7426, #$7425, #$7428, #$7430, #$742E, #$742C,
      #$741B, #$741A, #$7441, #$745C, #$7457, #$7455, #$7459, #$7477,
      #$746D, #$747E, #$749C, #$748E, #$7480, #$7481, #$7487, #$748B,
      #$749E, #$74A8, #$74A9, #$7490, #$74A7, #$74D2, #$74BA, #$97EA,
      #$97EB, #$97EC, #$674C, #$6753, #$675E, #$6748, #$6769, #$67A5,
      #$6787, #$676A, #$6773, #$6798, #$67A7, #$6775, #$67A8, #$679E,
      #$67AD, #$678B, #$6777, #$677C, #$67F0, #$6809, #$67D8, #$680A,
      #$67E9, #$67B0, #$680C, #$67D9, #$67B5, #$67DA, #$67B3, #$67DD,
      #$6800, #$67C3, #$67B8, #$67E2, #$680E, #$67C1, #$67FD, #$6832,
      #$6833, #$6860, #$6861, #$684E, #$6862, #$6844, #$6864, #$6883,
      #$681D, #$6855, #$6866, #$6841, #$6867, #$6840, #$683E, #$684A,
      #$6849, #$6829, #$68B5, #$688F, #$6874, #$6877, #$6893, #$686B,
      #$68C2, #$696E, #$68FC, #$691F, #$6920, #$68F9,
      #$6924, #$68F0, #$690B, #$6901, #$6957, #$68E3, #$6910, #$6971,
      #$6939, #$6960, #$6942, #$695D, #$6984, #$696B, #$6980, #$6998,
      #$6978, #$6934, #$69CC, #$6987, #$6988, #$69CE, #$6989, #$6966,
      #$6963, #$6979, #$699B, #$69A7, #$69BB, #$69AB, #$69AD, #$69D4,
      #$69B1, #$69C1, #$69CA, #$69DF, #$6995, #$69E0, #$698D, #$69FF,
      #$6A2F, #$69ED, #$6A17, #$6A18, #$6A65, #$69F2, #$6A44, #$6A3E,
      #$6AA0, #$6A50, #$6A5B, #$6A35, #$6A8E, #$6A79, #$6A3D, #$6A28,
      #$6A58, #$6A7C, #$6A91, #$6A90, #$6AA9, #$6A97, #$6AAB, #$7337,
      #$7352, #$6B81, #$6B82, #$6B87, #$6B84, #$6B92, #$6B93, #$6B8D,
      #$6B9A, #$6B9B, #$6BA1, #$6BAA, #$8F6B, #$8F6D, #$8F71, #$8F72,
      #$8F73, #$8F75, #$8F76, #$8F78, #$8F77, #$8F79, #$8F7A, #$8F7C,
      #$8F7E, #$8F81, #$8F82, #$8F84, #$8F87, #$8F8B,
      #$8F8D, #$8F8E, #$8F8F, #$8F98, #$8F9A, #$8ECE, #$620B, #$6217,
      #$621B, #$621F, #$6222, #$6221, #$6225, #$6224, #$622C, #$81E7,
      #$74EF, #$74F4, #$74FF, #$750F, #$7511, #$7513, #$6534, #$65EE,
      #$65EF, #$65F0, #$660A, #$6619, #$6772, #$6603, #$6615, #$6600,
      #$7085, #$66F7, #$661D, #$6634, #$6631, #$6636, #$6635, #$8006,
      #$665F, #$6654, #$6641, #$664F, #$6656, #$6661, #$6657, #$6677,
      #$6684, #$668C, #$66A7, #$669D, #$66BE, #$66DB, #$66DC, #$66E6,
      #$66E9, #$8D32, #$8D33, #$8D36, #$8D3B, #$8D3D, #$8D40, #$8D45,
      #$8D46, #$8D48, #$8D49, #$8D47, #$8D4D, #$8D55, #$8D59, #$89C7,
      #$89CA, #$89CB, #$89CC, #$89CE, #$89CF, #$89D0, #$89D1, #$726E,
      #$729F, #$725D, #$7266, #$726F, #$727E, #$727F, #$7284, #$728B,
      #$728D, #$728F, #$7292, #$6308, #$6332, #$63B0,
      #$643F, #$64D8, #$8004, #$6BEA, #$6BF3, #$6BFD, #$6BF5, #$6BF9,
      #$6C05, #$6C07, #$6C06, #$6C0D, #$6C15, #$6C18, #$6C19, #$6C1A,
      #$6C21, #$6C29, #$6C24, #$6C2A, #$6C32, #$6535, #$6555, #$656B,
      #$724D, #$7252, #$7256, #$7230, #$8662, #$5216, #$809F, #$809C,
      #$8093, #$80BC, #$670A, #$80BD, #$80B1, #$80AB, #$80AD, #$80B4,
      #$80B7, #$80E7, #$80E8, #$80E9, #$80EA, #$80DB, #$80C2, #$80C4,
      #$80D9, #$80CD, #$80D7, #$6710, #$80DD, #$80EB, #$80F1, #$80F4,
      #$80ED, #$810D, #$810E, #$80F2, #$80FC, #$6715, #$8112, #$8C5A,
      #$8136, #$811E, #$812C, #$8118, #$8132, #$8148, #$814C, #$8153,
      #$8174, #$8159, #$815A, #$8171, #$8160, #$8169, #$817C, #$817D,
      #$816D, #$8167, #$584D, #$5AB5, #$8188, #$8182, #$8191, #$6ED5,
      #$81A3, #$81AA, #$81CC, #$6726, #$81CA, #$81BB,
      #$81C1, #$81A6, #$6B24, #$6B37, #$6B39, #$6B43, #$6B46, #$6B59,
      #$98D1, #$98D2, #$98D3, #$98D5, #$98D9, #$98DA, #$6BB3, #$5F40,
      #$6BC2, #$89F3, #$6590, #$9F51, #$6593, #$65BC, #$65C6, #$65C4,
      #$65C3, #$65CC, #$65CE, #$65D2, #$65D6, #$7080, #$709C, #$7096,
      #$709D, #$70BB, #$70C0, #$70B7, #$70AB, #$70B1, #$70E8, #$70CA,
      #$7110, #$7113, #$7116, #$712F, #$7131, #$7173, #$715C, #$7168,
      #$7145, #$7172, #$714A, #$7178, #$717A, #$7198, #$71B3, #$71B5,
      #$71A8, #$71A0, #$71E0, #$71D4, #$71E7, #$71F9, #$721D, #$7228,
      #$706C, #$7118, #$7166, #$71B9, #$623E, #$623D, #$6243, #$6248,
      #$6249, #$793B, #$7940, #$7946, #$7949, #$795B, #$795C, #$7953,
      #$795A, #$7962, #$7957, #$7960, #$796F, #$7967, #$797A, #$7985,
      #$798A, #$799A, #$79A7, #$79B3, #$5FD1, #$5FD0,
      #$603C, #$605D, #$605A, #$6067, #$6041, #$6059, #$6063, #$60AB,
      #$6106, #$610D, #$615D, #$61A9, #$619D, #$61CB, #$61D1, #$6206,
      #$8080, #$807F, #$6C93, #$6CF6, #$6DFC, #$77F6, #$77F8, #$7800,
      #$7809, #$7817, #$7818, #$7811, #$65AB, #$782D, #$781C, #$781D,
      #$7839, #$783A, #$783B, #$781F, #$783C, #$7825, #$782C, #$7823,
      #$7829, #$784E, #$786D, #$7856, #$7857, #$7826, #$7850, #$7847,
      #$784C, #$786A, #$789B, #$7893, #$789A, #$7887, #$789C, #$78A1,
      #$78A3, #$78B2, #$78B9, #$78A5, #$78D4, #$78D9, #$78C9, #$78EC,
      #$78F2, #$7905, #$78F4, #$7913, #$7924, #$791E, #$7934, #$9F9B,
      #$9EF9, #$9EFB, #$9EFC, #$76F1, #$7704, #$770D, #$76F9, #$7707,
      #$7708, #$771A, #$7722, #$7719, #$772D, #$7726, #$7735, #$7738,
      #$7750, #$7751, #$7747, #$7743, #$775A, #$7768,
      #$7762, #$7765, #$777F, #$778D, #$777D, #$7780, #$778C, #$7791,
      #$779F, #$77A0, #$77B0, #$77B5, #$77BD, #$753A, #$7540, #$754E,
      #$754B, #$7548, #$755B, #$7572, #$7579, #$7583, #$7F58, #$7F61,
      #$7F5F, #$8A48, #$7F68, #$7F74, #$7F71, #$7F79, #$7F81, #$7F7E,
      #$76CD, #$76E5, #$8832, #$9485, #$9486, #$9487, #$948B, #$948A,
      #$948C, #$948D, #$948F, #$9490, #$9494, #$9497, #$9495, #$949A,
      #$949B, #$949C, #$94A3, #$94A4, #$94AB, #$94AA, #$94AD, #$94AC,
      #$94AF, #$94B0, #$94B2, #$94B4, #$94B6, #$94B7, #$94B8, #$94B9,
      #$94BA, #$94BC, #$94BD, #$94BF, #$94C4, #$94C8, #$94C9, #$94CA,
      #$94CB, #$94CC, #$94CD, #$94CE, #$94D0, #$94D1, #$94D2, #$94D5,
      #$94D6, #$94D7, #$94D9, #$94D8, #$94DB, #$94DE, #$94DF, #$94E0,
      #$94E2, #$94E4, #$94E5, #$94E7, #$94E8, #$94EA,
      #$94E9, #$94EB, #$94EE, #$94EF, #$94F3, #$94F4, #$94F5, #$94F7,
      #$94F9, #$94FC, #$94FD, #$94FF, #$9503, #$9502, #$9506, #$9507,
      #$9509, #$950A, #$950D, #$950E, #$950F, #$9512, #$9513, #$9514,
      #$9515, #$9516, #$9518, #$951B, #$951D, #$951E, #$951F, #$9522,
      #$952A, #$952B, #$9529, #$952C, #$9531, #$9532, #$9534, #$9536,
      #$9537, #$9538, #$953C, #$953E, #$953F, #$9542, #$9535, #$9544,
      #$9545, #$9546, #$9549, #$954C, #$954E, #$954F, #$9552, #$9553,
      #$9554, #$9556, #$9557, #$9558, #$9559, #$955B, #$955E, #$955F,
      #$955D, #$9561, #$9562, #$9564, #$9565, #$9566, #$9567, #$9568,
      #$9569, #$956A, #$956B, #$956C, #$956F, #$9571, #$9572, #$9573,
      #$953A, #$77E7, #$77EC, #$96C9, #$79D5, #$79ED, #$79E3, #$79EB,
      #$7A06, #$5D47, #$7A03, #$7A02, #$7A1E, #$7A14,
      #$7A39, #$7A37, #$7A51, #$9ECF, #$99A5, #$7A70, #$7688, #$768E,
      #$7693, #$7699, #$76A4, #$74DE, #$74E0, #$752C, #$9E20, #$9E22,
      #$9E28, #$9E29, #$9E2A, #$9E2B, #$9E2C, #$9E32, #$9E31, #$9E36,
      #$9E38, #$9E37, #$9E39, #$9E3A, #$9E3E, #$9E41, #$9E42, #$9E44,
      #$9E46, #$9E47, #$9E48, #$9E49, #$9E4B, #$9E4C, #$9E4E, #$9E51,
      #$9E55, #$9E57, #$9E5A, #$9E5B, #$9E5C, #$9E5E, #$9E63, #$9E66,
      #$9E67, #$9E68, #$9E69, #$9E6A, #$9E6B, #$9E6C, #$9E71, #$9E6D,
      #$9E73, #$7592, #$7594, #$7596, #$75A0, #$759D, #$75AC, #$75A3,
      #$75B3, #$75B4, #$75B8, #$75C4, #$75B1, #$75B0, #$75C3, #$75C2,
      #$75D6, #$75CD, #$75E3, #$75E8, #$75E6, #$75E4, #$75EB, #$75E7,
      #$7603, #$75F1, #$75FC, #$75FF, #$7610, #$7600, #$7605, #$760C,
      #$7617, #$760A, #$7625, #$7618, #$7615, #$7619,
      #$761B, #$763C, #$7622, #$7620, #$7640, #$762D, #$7630, #$763F,
      #$7635, #$7643, #$763E, #$7633, #$764D, #$765E, #$7654, #$765C,
      #$7656, #$766B, #$766F, #$7FCA, #$7AE6, #$7A78, #$7A79, #$7A80,
      #$7A86, #$7A88, #$7A95, #$7AA6, #$7AA0, #$7AAC, #$7AA8, #$7AAD,
      #$7AB3, #$8864, #$8869, #$8872, #$887D, #$887F, #$8882, #$88A2,
      #$88C6, #$88B7, #$88BC, #$88C9, #$88E2, #$88CE, #$88E3, #$88E5,
      #$88F1, #$891A, #$88FC, #$88E8, #$88FE, #$88F0, #$8921, #$8919,
      #$8913, #$891B, #$890A, #$8934, #$892B, #$8936, #$8941, #$8966,
      #$897B, #$758B, #$80E5, #$76B2, #$76B4, #$77DC, #$8012, #$8014,
      #$8016, #$801C, #$8020, #$8022, #$8025, #$8026, #$8027, #$8029,
      #$8028, #$8031, #$800B, #$8035, #$8043, #$8046, #$804D, #$8052,
      #$8069, #$8071, #$8983, #$9878, #$9880, #$9883,
      #$9889, #$988C, #$988D, #$988F, #$9894, #$989A, #$989B, #$989E,
      #$989F, #$98A1, #$98A2, #$98A5, #$98A6, #$864D, #$8654, #$866C,
      #$866E, #$867F, #$867A, #$867C, #$867B, #$86A8, #$868D, #$868B,
      #$86AC, #$869D, #$86A7, #$86A3, #$86AA, #$8693, #$86A9, #$86B6,
      #$86C4, #$86B5, #$86CE, #$86B0, #$86BA, #$86B1, #$86AF, #$86C9,
      #$86CF, #$86B4, #$86E9, #$86F1, #$86F2, #$86ED, #$86F3, #$86D0,
      #$8713, #$86DE, #$86F4, #$86DF, #$86D8, #$86D1, #$8703, #$8707,
      #$86F8, #$8708, #$870A, #$870D, #$8709, #$8723, #$873B, #$871E,
      #$8725, #$872E, #$871A, #$873E, #$8748, #$8734, #$8731, #$8729,
      #$8737, #$873F, #$8782, #$8722, #$877D, #$877E, #$877B, #$8760,
      #$8770, #$874C, #$876E, #$878B, #$8753, #$8763, #$877C, #$8764,
      #$8759, #$8765, #$8793, #$87AF, #$87A8, #$87D2,
      #$87C6, #$8788, #$8785, #$87AD, #$8797, #$8783, #$87AB, #$87E5,
      #$87AC, #$87B5, #$87B3, #$87CB, #$87D3, #$87BD, #$87D1, #$87C0,
      #$87CA, #$87DB, #$87EA, #$87E0, #$87EE, #$8816, #$8813, #$87FE,
      #$880A, #$881B, #$8821, #$8839, #$883C, #$7F36, #$7F42, #$7F44,
      #$7F45, #$8210, #$7AFA, #$7AFD, #$7B08, #$7B03, #$7B04, #$7B15,
      #$7B0A, #$7B2B, #$7B0F, #$7B47, #$7B38, #$7B2A, #$7B19, #$7B2E,
      #$7B31, #$7B20, #$7B25, #$7B24, #$7B33, #$7B3E, #$7B1E, #$7B58,
      #$7B5A, #$7B45, #$7B75, #$7B4C, #$7B5D, #$7B60, #$7B6E, #$7B7B,
      #$7B62, #$7B72, #$7B71, #$7B90, #$7BA6, #$7BA7, #$7BB8, #$7BAC,
      #$7B9D, #$7BA8, #$7B85, #$7BAA, #$7B9C, #$7BA2, #$7BAB, #$7BB4,
      #$7BD1, #$7BC1, #$7BCC, #$7BDD, #$7BDA, #$7BE5, #$7BE6, #$7BEA,
      #$7C0C, #$7BFE, #$7BFC, #$7C0F, #$7C16, #$7C0B,
      #$7C1F, #$7C2A, #$7C26, #$7C38, #$7C41, #$7C40, #$81FE, #$8201,
      #$8202, #$8204, #$81EC, #$8844, #$8221, #$8222, #$8223, #$822D,
      #$822F, #$8228, #$822B, #$8238, #$823B, #$8233, #$8234, #$823E,
      #$8244, #$8249, #$824B, #$824F, #$825A, #$825F, #$8268, #$887E,
      #$8885, #$8888, #$88D8, #$88DF, #$895E, #$7F9D, #$7F9F, #$7FA7,
      #$7FAF, #$7FB0, #$7FB2, #$7C7C, #$6549, #$7C91, #$7C9D, #$7C9C,
      #$7C9E, #$7CA2, #$7CB2, #$7CBC, #$7CBD, #$7CC1, #$7CC7, #$7CCC,
      #$7CCD, #$7CC8, #$7CC5, #$7CD7, #$7CE8, #$826E, #$66A8, #$7FBF,
      #$7FCE, #$7FD5, #$7FE5, #$7FE1, #$7FE6, #$7FE9, #$7FEE, #$7FF3,
      #$7CF8, #$7D77, #$7DA6, #$7DAE, #$7E47, #$7E9B, #$9EB8, #$9EB4,
      #$8D73, #$8D84, #$8D94, #$8D91, #$8DB1, #$8D67, #$8D6D, #$8C47,
      #$8C49, #$914A, #$9150, #$914E, #$914F, #$9164,
      #$9162, #$9161, #$9170, #$9169, #$916F, #$917D, #$917E, #$9172,
      #$9174, #$9179, #$918C, #$9185, #$9190, #$918D, #$9191, #$91A2,
      #$91A3, #$91AA, #$91AD, #$91AE, #$91AF, #$91B5, #$91B4, #$91BA,
      #$8C55, #$9E7E, #$8DB8, #$8DEB, #$8E05, #$8E59, #$8E69, #$8DB5,
      #$8DBF, #$8DBC, #$8DBA, #$8DC4, #$8DD6, #$8DD7, #$8DDA, #$8DDE,
      #$8DCE, #$8DCF, #$8DDB, #$8DC6, #$8DEC, #$8DF7, #$8DF8, #$8DE3,
      #$8DF9, #$8DFB, #$8DE4, #$8E09, #$8DFD, #$8E14, #$8E1D, #$8E1F,
      #$8E2C, #$8E2E, #$8E23, #$8E2F, #$8E3A, #$8E40, #$8E39, #$8E35,
      #$8E3D, #$8E31, #$8E49, #$8E41, #$8E42, #$8E51, #$8E52, #$8E4A,
      #$8E70, #$8E76, #$8E7C, #$8E6F, #$8E74, #$8E85, #$8E8F, #$8E94,
      #$8E90, #$8E9C, #$8E9E, #$8C78, #$8C82, #$8C8A, #$8C85, #$8C98,
      #$8C94, #$659B, #$89D6, #$89DE, #$89DA, #$89DC,
      #$89E5, #$89EB, #$89EF, #$8A3E, #$8B26, #$9753, #$96E9, #$96F3,
      #$96EF, #$9706, #$9701, #$9708, #$970F, #$970E, #$972A, #$972D,
      #$9730, #$973E, #$9F80, #$9F83, #$9F85, #$9F86, #$9F87, #$9F88,
      #$9F89, #$9F8A, #$9F8C, #$9EFE, #$9F0B, #$9F0D, #$96B9, #$96BC,
      #$96BD, #$96CE, #$96D2, #$77BF, #$96E0, #$928E, #$92AE, #$92C8,
      #$933E, #$936A, #$93CA, #$938F, #$943E, #$946B, #$9C7F, #$9C82,
      #$9C85, #$9C86, #$9C87, #$9C88, #$7A23, #$9C8B, #$9C8E, #$9C90,
      #$9C91, #$9C92, #$9C94, #$9C95, #$9C9A, #$9C9B, #$9C9E, #$9C9F,
      #$9CA0, #$9CA1, #$9CA2, #$9CA3, #$9CA5, #$9CA6, #$9CA7, #$9CA8,
      #$9CA9, #$9CAB, #$9CAD, #$9CAE, #$9CB0, #$9CB1, #$9CB2, #$9CB3,
      #$9CB4, #$9CB5, #$9CB6, #$9CB7, #$9CBA, #$9CBB, #$9CBC, #$9CBD,
      #$9CC4, #$9CC5, #$9CC6, #$9CC7, #$9CCA, #$9CCB,
      #$9CCC, #$9CCD, #$9CCE, #$9CCF, #$9CD0, #$9CD3, #$9CD4, #$9CD5,
      #$9CD7, #$9CD8, #$9CD9, #$9CDC, #$9CDD, #$9CDF, #$9CE2, #$977C,
      #$9785, #$9791, #$9792, #$9794, #$97AF, #$97AB, #$97A3, #$97B2,
      #$97B4, #$9AB1, #$9AB0, #$9AB7, #$9E58, #$9AB6, #$9ABA, #$9ABC,
      #$9AC1, #$9AC0, #$9AC5, #$9AC2, #$9ACB, #$9ACC, #$9AD1, #$9B45,
      #$9B43, #$9B47, #$9B49, #$9B48, #$9B4D, #$9B51, #$98E8, #$990D,
      #$992E, #$9955, #$9954, #$9ADF, #$9AE1, #$9AE6, #$9AEF, #$9AEB,
      #$9AFB, #$9AED, #$9AF9, #$9B08, #$9B0F, #$9B13, #$9B1F, #$9B23,
      #$9EBD, #$9EBE, #$7E3B, #$9E82, #$9E87, #$9E88, #$9E8B, #$9E92,
      #$93D6, #$9E9D, #$9E9F, #$9EDB, #$9EDC, #$9EDD, #$9EE0, #$9EDF,
      #$9EE2, #$9EE9, #$9EE7, #$9EE5, #$9EEA, #$9EEF, #$9F22, #$9F2C,
      #$9F2F, #$9F39, #$9F37, #$9F3D, #$9F3E, #$9F44);
  KSC5601_1Map: array[0..1114] of TBuffChar = (
      #$3000, #$3001, #$3002, #$00B7, #$2025, #$2026, #$00A8, #$3003,
      #$00AD, #$2015, #$2225, #$FF3C, #$223C, #$2018, #$2019, #$201C,
      #$201D, #$3014, #$3015, #$3008, #$3009, #$300A, #$300B, #$300C,
      #$300D, #$300E, #$300F, #$3010, #$3011, #$00B1, #$00D7, #$00F7,
      #$2260, #$2264, #$2265, #$221E, #$2234, #$00B0, #$2032, #$2033,
      #$2103, #$212B, #$FFE0, #$FFE1, #$FFE5, #$2642, #$2640, #$2220,
      #$22A5, #$2312, #$2202, #$2207, #$2261, #$2252, #$00A7, #$203B,
      #$2606, #$2605, #$25CB, #$25CF, #$25CE, #$25C7, #$25C6, #$25A1,
      #$25A0, #$25B3, #$25B2, #$25BD, #$25BC, #$2192, #$2190, #$2191,
      #$2193, #$2194, #$3013, #$226A, #$226B, #$221A, #$223D, #$221D,
      #$2235, #$222B, #$222C, #$2208, #$220B, #$2286, #$2287, #$2282,
      #$2283, #$222A, #$2229, #$2227, #$2228, #$FFE2,
      #$21D2, #$21D4, #$2200, #$2203, #$00B4, #$FF5E, #$02C7, #$02D8,
      #$02DD, #$02DA, #$02D9, #$00B8, #$02DB, #$00A1, #$00BF, #$02D0,
      #$222E, #$2211, #$220F, #$00A4, #$2109, #$2030, #$25C1, #$25C0,
      #$25B7, #$25B6, #$2664, #$2660, #$2661, #$2665, #$2667, #$2663,
      #$2299, #$25C8, #$25A3, #$25D0, #$25D1, #$2592, #$25A4, #$25A5,
      #$25A8, #$25A7, #$25A6, #$25A9, #$2668, #$260F, #$260E, #$261C,
      #$261E, #$00B6, #$2020, #$2021, #$2195, #$2197, #$2199, #$2196,
      #$2198, #$266D, #$2669, #$266A, #$266C, #$327F, #$321C, #$2116,
      #$33C7, #$2122, #$33C2, #$33D8, #$2121, #$20AC, #$00AE, #$327E,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FF01, #$FF02, #$FF03, #$FF04, #$FF05, #$FF06, #$FF07, #$FF08,
      #$FF09, #$FF0A, #$FF0B, #$FF0C, #$FF0D, #$FF0E, #$FF0F, #$FF10,
      #$FF11, #$FF12, #$FF13, #$FF14, #$FF15, #$FF16, #$FF17, #$FF18,
      #$FF19, #$FF1A, #$FF1B, #$FF1C, #$FF1D, #$FF1E, #$FF1F, #$FF20,
      #$FF21, #$FF22, #$FF23, #$FF24, #$FF25, #$FF26, #$FF27, #$FF28,
      #$FF29, #$FF2A, #$FF2B, #$FF2C, #$FF2D, #$FF2E, #$FF2F, #$FF30,
      #$FF31, #$FF32, #$FF33, #$FF34, #$FF35, #$FF36, #$FF37, #$FF38,
      #$FF39, #$FF3A, #$FF3B, #$FFE6, #$FF3D, #$FF3E, #$FF3F, #$FF40,
      #$FF41, #$FF42, #$FF43, #$FF44, #$FF45, #$FF46, #$FF47, #$FF48,
      #$FF49, #$FF4A, #$FF4B, #$FF4C, #$FF4D, #$FF4E, #$FF4F, #$FF50,
      #$FF51, #$FF52, #$FF53, #$FF54, #$FF55, #$FF56, #$FF57, #$FF58,
      #$FF59, #$FF5A, #$FF5B, #$FF5C, #$FF5D, #$FFE3,
      #$3131, #$3132, #$3133, #$3134, #$3135, #$3136, #$3137, #$3138,
      #$3139, #$313A, #$313B, #$313C, #$313D, #$313E, #$313F, #$3140,
      #$3141, #$3142, #$3143, #$3144, #$3145, #$3146, #$3147, #$3148,
      #$3149, #$314A, #$314B, #$314C, #$314D, #$314E, #$314F, #$3150,
      #$3151, #$3152, #$3153, #$3154, #$3155, #$3156, #$3157, #$3158,
      #$3159, #$315A, #$315B, #$315C, #$315D, #$315E, #$315F, #$3160,
      #$3161, #$3162, #$3163, #$3164, #$3165, #$3166, #$3167, #$3168,
      #$3169, #$316A, #$316B, #$316C, #$316D, #$316E, #$316F, #$3170,
      #$3171, #$3172, #$3173, #$3174, #$3175, #$3176, #$3177, #$3178,
      #$3179, #$317A, #$317B, #$317C, #$317D, #$317E, #$317F, #$3180,
      #$3181, #$3182, #$3183, #$3184, #$3185, #$3186, #$3187, #$3188,
      #$3189, #$318A, #$318B, #$318C, #$318D, #$318E,
      #$2170, #$2171, #$2172, #$2173, #$2174, #$2175, #$2176, #$2177,
      #$2178, #$2179, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$2160,
      #$2161, #$2162, #$2163, #$2164, #$2165, #$2166, #$2167, #$2168,
      #$2169, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0391, #$0392, #$0393, #$0394, #$0395, #$0396, #$0397, #$0398,
      #$0399, #$039A, #$039B, #$039C, #$039D, #$039E, #$039F, #$03A0,
      #$03A1, #$03A3, #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$03B1, #$03B2, #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8,
      #$03B9, #$03BA, #$03BB, #$03BC, #$03BD, #$03BE, #$03BF, #$03C0,
      #$03C1, #$03C3, #$03C4, #$03C5, #$03C6, #$03C7, #$03C8, #$03C9,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$2500, #$2502, #$250C, #$2510, #$2518, #$2514, #$251C, #$252C,
      #$2524, #$2534, #$253C, #$2501, #$2503, #$250F, #$2513, #$251B,
      #$2517, #$2523, #$2533, #$252B, #$253B, #$254B, #$2520, #$252F,
      #$2528, #$2537, #$253F, #$251D, #$2530, #$2525, #$2538, #$2542,
      #$2512, #$2511, #$251A, #$2519, #$2516, #$2515, #$250E, #$250D,
      #$251E, #$251F, #$2521, #$2522, #$2526, #$2527, #$2529, #$252A,
      #$252D, #$252E, #$2531, #$2532, #$2535, #$2536, #$2539, #$253A,
      #$253D, #$253E, #$2540, #$2541, #$2543, #$2544, #$2545, #$2546,
      #$2547, #$2548, #$2549, #$254A, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$3395, #$3396, #$3397, #$2113, #$3398, #$33C4, #$33A3, #$33A4,
      #$33A5, #$33A6, #$3399, #$339A, #$339B, #$339C, #$339D, #$339E,
      #$339F, #$33A0, #$33A1, #$33A2, #$33CA, #$338D, #$338E, #$338F,
      #$33CF, #$3388, #$3389, #$33C8, #$33A7, #$33A8, #$33B0, #$33B1,
      #$33B2, #$33B3, #$33B4, #$33B5, #$33B6, #$33B7, #$33B8, #$33B9,
      #$3380, #$3381, #$3382, #$3383, #$3384, #$33BA, #$33BB, #$33BC,
      #$33BD, #$33BE, #$33BF, #$3390, #$3391, #$3392, #$3393, #$3394,
      #$2126, #$33C0, #$33C1, #$338A, #$338B, #$338C, #$33D6, #$33C5,
      #$33AD, #$33AE, #$33AF, #$33DB, #$33A9, #$33AA, #$33AB, #$33AC,
      #$33DD, #$33D0, #$33D3, #$33C3, #$33C9, #$33DC, #$33C6, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$00C6, #$00D0, #$00AA, #$0126, #$FFFD, #$0132, #$FFFD, #$013F,
      #$0141, #$00D8, #$0152, #$00BA, #$00DE, #$0166, #$014A, #$FFFD,
      #$3260, #$3261, #$3262, #$3263, #$3264, #$3265, #$3266, #$3267,
      #$3268, #$3269, #$326A, #$326B, #$326C, #$326D, #$326E, #$326F,
      #$3270, #$3271, #$3272, #$3273, #$3274, #$3275, #$3276, #$3277,
      #$3278, #$3279, #$327A, #$327B, #$24D0, #$24D1, #$24D2, #$24D3,
      #$24D4, #$24D5, #$24D6, #$24D7, #$24D8, #$24D9, #$24DA, #$24DB,
      #$24DC, #$24DD, #$24DE, #$24DF, #$24E0, #$24E1, #$24E2, #$24E3,
      #$24E4, #$24E5, #$24E6, #$24E7, #$24E8, #$24E9, #$2460, #$2461,
      #$2462, #$2463, #$2464, #$2465, #$2466, #$2467, #$2468, #$2469,
      #$246A, #$246B, #$246C, #$246D, #$246E, #$00BD, #$2153, #$2154,
      #$00BC, #$00BE, #$215B, #$215C, #$215D, #$215E,
      #$00E6, #$0111, #$00F0, #$0127, #$0131, #$0133, #$0138, #$0140,
      #$0142, #$00F8, #$0153, #$00DF, #$00FE, #$0167, #$014B, #$0149,
      #$3200, #$3201, #$3202, #$3203, #$3204, #$3205, #$3206, #$3207,
      #$3208, #$3209, #$320A, #$320B, #$320C, #$320D, #$320E, #$320F,
      #$3210, #$3211, #$3212, #$3213, #$3214, #$3215, #$3216, #$3217,
      #$3218, #$3219, #$321A, #$321B, #$249C, #$249D, #$249E, #$249F,
      #$24A0, #$24A1, #$24A2, #$24A3, #$24A4, #$24A5, #$24A6, #$24A7,
      #$24A8, #$24A9, #$24AA, #$24AB, #$24AC, #$24AD, #$24AE, #$24AF,
      #$24B0, #$24B1, #$24B2, #$24B3, #$24B4, #$24B5, #$2474, #$2475,
      #$2476, #$2477, #$2478, #$2479, #$247A, #$247B, #$247C, #$247D,
      #$247E, #$247F, #$2480, #$2481, #$2482, #$00B9, #$00B2, #$00B3,
      #$2074, #$207F, #$2081, #$2082, #$2083, #$2084,
      #$3041, #$3042, #$3043, #$3044, #$3045, #$3046, #$3047, #$3048,
      #$3049, #$304A, #$304B, #$304C, #$304D, #$304E, #$304F, #$3050,
      #$3051, #$3052, #$3053, #$3054, #$3055, #$3056, #$3057, #$3058,
      #$3059, #$305A, #$305B, #$305C, #$305D, #$305E, #$305F, #$3060,
      #$3061, #$3062, #$3063, #$3064, #$3065, #$3066, #$3067, #$3068,
      #$3069, #$306A, #$306B, #$306C, #$306D, #$306E, #$306F, #$3070,
      #$3071, #$3072, #$3073, #$3074, #$3075, #$3076, #$3077, #$3078,
      #$3079, #$307A, #$307B, #$307C, #$307D, #$307E, #$307F, #$3080,
      #$3081, #$3082, #$3083, #$3084, #$3085, #$3086, #$3087, #$3088,
      #$3089, #$308A, #$308B, #$308C, #$308D, #$308E, #$308F, #$3090,
      #$3091, #$3092, #$3093, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$30A1, #$30A2, #$30A3, #$30A4, #$30A5, #$30A6, #$30A7, #$30A8,
      #$30A9, #$30AA, #$30AB, #$30AC, #$30AD, #$30AE, #$30AF, #$30B0,
      #$30B1, #$30B2, #$30B3, #$30B4, #$30B5, #$30B6, #$30B7, #$30B8,
      #$30B9, #$30BA, #$30BB, #$30BC, #$30BD, #$30BE, #$30BF, #$30C0,
      #$30C1, #$30C2, #$30C3, #$30C4, #$30C5, #$30C6, #$30C7, #$30C8,
      #$30C9, #$30CA, #$30CB, #$30CC, #$30CD, #$30CE, #$30CF, #$30D0,
      #$30D1, #$30D2, #$30D3, #$30D4, #$30D5, #$30D6, #$30D7, #$30D8,
      #$30D9, #$30DA, #$30DB, #$30DC, #$30DD, #$30DE, #$30DF, #$30E0,
      #$30E1, #$30E2, #$30E3, #$30E4, #$30E5, #$30E6, #$30E7, #$30E8,
      #$30E9, #$30EA, #$30EB, #$30EC, #$30ED, #$30EE, #$30EF, #$30F0,
      #$30F1, #$30F2, #$30F3, #$30F4, #$30F5, #$30F6, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0401, #$0416,
      #$0417, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E,
      #$041F, #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426,
      #$0427, #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E,
      #$042F, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0451, #$0436,
      #$0437, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E,
      #$043F, #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446,
      #$0447, #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E,
      #$044F);
  KSC5601_2Map: array[0..2349] of TBuffChar = (
      #$AC00, #$AC01, #$AC04, #$AC07, #$AC08, #$AC09, #$AC0A, #$AC10,
      #$AC11, #$AC12, #$AC13, #$AC14, #$AC15, #$AC16, #$AC17, #$AC19,
      #$AC1A, #$AC1B, #$AC1C, #$AC1D, #$AC20, #$AC24, #$AC2C, #$AC2D,
      #$AC2F, #$AC30, #$AC31, #$AC38, #$AC39, #$AC3C, #$AC40, #$AC4B,
      #$AC4D, #$AC54, #$AC58, #$AC5C, #$AC70, #$AC71, #$AC74, #$AC77,
      #$AC78, #$AC7A, #$AC80, #$AC81, #$AC83, #$AC84, #$AC85, #$AC86,
      #$AC89, #$AC8A, #$AC8B, #$AC8C, #$AC90, #$AC94, #$AC9C, #$AC9D,
      #$AC9F, #$ACA0, #$ACA1, #$ACA8, #$ACA9, #$ACAA, #$ACAC, #$ACAF,
      #$ACB0, #$ACB8, #$ACB9, #$ACBB, #$ACBC, #$ACBD, #$ACC1, #$ACC4,
      #$ACC8, #$ACCC, #$ACD5, #$ACD7, #$ACE0, #$ACE1, #$ACE4, #$ACE7,
      #$ACE8, #$ACEA, #$ACEC, #$ACEF, #$ACF0, #$ACF1, #$ACF3, #$ACF5,
      #$ACF6, #$ACFC, #$ACFD, #$AD00, #$AD04, #$AD06,
      #$AD0C, #$AD0D, #$AD0F, #$AD11, #$AD18, #$AD1C, #$AD20, #$AD29,
      #$AD2C, #$AD2D, #$AD34, #$AD35, #$AD38, #$AD3C, #$AD44, #$AD45,
      #$AD47, #$AD49, #$AD50, #$AD54, #$AD58, #$AD61, #$AD63, #$AD6C,
      #$AD6D, #$AD70, #$AD73, #$AD74, #$AD75, #$AD76, #$AD7B, #$AD7C,
      #$AD7D, #$AD7F, #$AD81, #$AD82, #$AD88, #$AD89, #$AD8C, #$AD90,
      #$AD9C, #$AD9D, #$ADA4, #$ADB7, #$ADC0, #$ADC1, #$ADC4, #$ADC8,
      #$ADD0, #$ADD1, #$ADD3, #$ADDC, #$ADE0, #$ADE4, #$ADF8, #$ADF9,
      #$ADFC, #$ADFF, #$AE00, #$AE01, #$AE08, #$AE09, #$AE0B, #$AE0D,
      #$AE14, #$AE30, #$AE31, #$AE34, #$AE37, #$AE38, #$AE3A, #$AE40,
      #$AE41, #$AE43, #$AE45, #$AE46, #$AE4A, #$AE4C, #$AE4D, #$AE4E,
      #$AE50, #$AE54, #$AE56, #$AE5C, #$AE5D, #$AE5F, #$AE60, #$AE61,
      #$AE65, #$AE68, #$AE69, #$AE6C, #$AE70, #$AE78,
      #$AE79, #$AE7B, #$AE7C, #$AE7D, #$AE84, #$AE85, #$AE8C, #$AEBC,
      #$AEBD, #$AEBE, #$AEC0, #$AEC4, #$AECC, #$AECD, #$AECF, #$AED0,
      #$AED1, #$AED8, #$AED9, #$AEDC, #$AEE8, #$AEEB, #$AEED, #$AEF4,
      #$AEF8, #$AEFC, #$AF07, #$AF08, #$AF0D, #$AF10, #$AF2C, #$AF2D,
      #$AF30, #$AF32, #$AF34, #$AF3C, #$AF3D, #$AF3F, #$AF41, #$AF42,
      #$AF43, #$AF48, #$AF49, #$AF50, #$AF5C, #$AF5D, #$AF64, #$AF65,
      #$AF79, #$AF80, #$AF84, #$AF88, #$AF90, #$AF91, #$AF95, #$AF9C,
      #$AFB8, #$AFB9, #$AFBC, #$AFC0, #$AFC7, #$AFC8, #$AFC9, #$AFCB,
      #$AFCD, #$AFCE, #$AFD4, #$AFDC, #$AFE8, #$AFE9, #$AFF0, #$AFF1,
      #$AFF4, #$AFF8, #$B000, #$B001, #$B004, #$B00C, #$B010, #$B014,
      #$B01C, #$B01D, #$B028, #$B044, #$B045, #$B048, #$B04A, #$B04C,
      #$B04E, #$B053, #$B054, #$B055, #$B057, #$B059,
      #$B05D, #$B07C, #$B07D, #$B080, #$B084, #$B08C, #$B08D, #$B08F,
      #$B091, #$B098, #$B099, #$B09A, #$B09C, #$B09F, #$B0A0, #$B0A1,
      #$B0A2, #$B0A8, #$B0A9, #$B0AB, #$B0AC, #$B0AD, #$B0AE, #$B0AF,
      #$B0B1, #$B0B3, #$B0B4, #$B0B5, #$B0B8, #$B0BC, #$B0C4, #$B0C5,
      #$B0C7, #$B0C8, #$B0C9, #$B0D0, #$B0D1, #$B0D4, #$B0D8, #$B0E0,
      #$B0E5, #$B108, #$B109, #$B10B, #$B10C, #$B110, #$B112, #$B113,
      #$B118, #$B119, #$B11B, #$B11C, #$B11D, #$B123, #$B124, #$B125,
      #$B128, #$B12C, #$B134, #$B135, #$B137, #$B138, #$B139, #$B140,
      #$B141, #$B144, #$B148, #$B150, #$B151, #$B154, #$B155, #$B158,
      #$B15C, #$B160, #$B178, #$B179, #$B17C, #$B180, #$B182, #$B188,
      #$B189, #$B18B, #$B18D, #$B192, #$B193, #$B194, #$B198, #$B19C,
      #$B1A8, #$B1CC, #$B1D0, #$B1D4, #$B1DC, #$B1DD,
      #$B1DF, #$B1E8, #$B1E9, #$B1EC, #$B1F0, #$B1F9, #$B1FB, #$B1FD,
      #$B204, #$B205, #$B208, #$B20B, #$B20C, #$B214, #$B215, #$B217,
      #$B219, #$B220, #$B234, #$B23C, #$B258, #$B25C, #$B260, #$B268,
      #$B269, #$B274, #$B275, #$B27C, #$B284, #$B285, #$B289, #$B290,
      #$B291, #$B294, #$B298, #$B299, #$B29A, #$B2A0, #$B2A1, #$B2A3,
      #$B2A5, #$B2A6, #$B2AA, #$B2AC, #$B2B0, #$B2B4, #$B2C8, #$B2C9,
      #$B2CC, #$B2D0, #$B2D2, #$B2D8, #$B2D9, #$B2DB, #$B2DD, #$B2E2,
      #$B2E4, #$B2E5, #$B2E6, #$B2E8, #$B2EB, #$B2EC, #$B2ED, #$B2EE,
      #$B2EF, #$B2F3, #$B2F4, #$B2F5, #$B2F7, #$B2F8, #$B2F9, #$B2FA,
      #$B2FB, #$B2FF, #$B300, #$B301, #$B304, #$B308, #$B310, #$B311,
      #$B313, #$B314, #$B315, #$B31C, #$B354, #$B355, #$B356, #$B358,
      #$B35B, #$B35C, #$B35E, #$B35F, #$B364, #$B365,
      #$B367, #$B369, #$B36B, #$B36E, #$B370, #$B371, #$B374, #$B378,
      #$B380, #$B381, #$B383, #$B384, #$B385, #$B38C, #$B390, #$B394,
      #$B3A0, #$B3A1, #$B3A8, #$B3AC, #$B3C4, #$B3C5, #$B3C8, #$B3CB,
      #$B3CC, #$B3CE, #$B3D0, #$B3D4, #$B3D5, #$B3D7, #$B3D9, #$B3DB,
      #$B3DD, #$B3E0, #$B3E4, #$B3E8, #$B3FC, #$B410, #$B418, #$B41C,
      #$B420, #$B428, #$B429, #$B42B, #$B434, #$B450, #$B451, #$B454,
      #$B458, #$B460, #$B461, #$B463, #$B465, #$B46C, #$B480, #$B488,
      #$B49D, #$B4A4, #$B4A8, #$B4AC, #$B4B5, #$B4B7, #$B4B9, #$B4C0,
      #$B4C4, #$B4C8, #$B4D0, #$B4D5, #$B4DC, #$B4DD, #$B4E0, #$B4E3,
      #$B4E4, #$B4E6, #$B4EC, #$B4ED, #$B4EF, #$B4F1, #$B4F8, #$B514,
      #$B515, #$B518, #$B51B, #$B51C, #$B524, #$B525, #$B527, #$B528,
      #$B529, #$B52A, #$B530, #$B531, #$B534, #$B538,
      #$B540, #$B541, #$B543, #$B544, #$B545, #$B54B, #$B54C, #$B54D,
      #$B550, #$B554, #$B55C, #$B55D, #$B55F, #$B560, #$B561, #$B5A0,
      #$B5A1, #$B5A4, #$B5A8, #$B5AA, #$B5AB, #$B5B0, #$B5B1, #$B5B3,
      #$B5B4, #$B5B5, #$B5BB, #$B5BC, #$B5BD, #$B5C0, #$B5C4, #$B5CC,
      #$B5CD, #$B5CF, #$B5D0, #$B5D1, #$B5D8, #$B5EC, #$B610, #$B611,
      #$B614, #$B618, #$B625, #$B62C, #$B634, #$B648, #$B664, #$B668,
      #$B69C, #$B69D, #$B6A0, #$B6A4, #$B6AB, #$B6AC, #$B6B1, #$B6D4,
      #$B6F0, #$B6F4, #$B6F8, #$B700, #$B701, #$B705, #$B728, #$B729,
      #$B72C, #$B72F, #$B730, #$B738, #$B739, #$B73B, #$B744, #$B748,
      #$B74C, #$B754, #$B755, #$B760, #$B764, #$B768, #$B770, #$B771,
      #$B773, #$B775, #$B77C, #$B77D, #$B780, #$B784, #$B78C, #$B78D,
      #$B78F, #$B790, #$B791, #$B792, #$B796, #$B797,
      #$B798, #$B799, #$B79C, #$B7A0, #$B7A8, #$B7A9, #$B7AB, #$B7AC,
      #$B7AD, #$B7B4, #$B7B5, #$B7B8, #$B7C7, #$B7C9, #$B7EC, #$B7ED,
      #$B7F0, #$B7F4, #$B7FC, #$B7FD, #$B7FF, #$B800, #$B801, #$B807,
      #$B808, #$B809, #$B80C, #$B810, #$B818, #$B819, #$B81B, #$B81D,
      #$B824, #$B825, #$B828, #$B82C, #$B834, #$B835, #$B837, #$B838,
      #$B839, #$B840, #$B844, #$B851, #$B853, #$B85C, #$B85D, #$B860,
      #$B864, #$B86C, #$B86D, #$B86F, #$B871, #$B878, #$B87C, #$B88D,
      #$B8A8, #$B8B0, #$B8B4, #$B8B8, #$B8C0, #$B8C1, #$B8C3, #$B8C5,
      #$B8CC, #$B8D0, #$B8D4, #$B8DD, #$B8DF, #$B8E1, #$B8E8, #$B8E9,
      #$B8EC, #$B8F0, #$B8F8, #$B8F9, #$B8FB, #$B8FD, #$B904, #$B918,
      #$B920, #$B93C, #$B93D, #$B940, #$B944, #$B94C, #$B94F, #$B951,
      #$B958, #$B959, #$B95C, #$B960, #$B968, #$B969,
      #$B96B, #$B96D, #$B974, #$B975, #$B978, #$B97C, #$B984, #$B985,
      #$B987, #$B989, #$B98A, #$B98D, #$B98E, #$B9AC, #$B9AD, #$B9B0,
      #$B9B4, #$B9BC, #$B9BD, #$B9BF, #$B9C1, #$B9C8, #$B9C9, #$B9CC,
      #$B9CE, #$B9CF, #$B9D0, #$B9D1, #$B9D2, #$B9D8, #$B9D9, #$B9DB,
      #$B9DD, #$B9DE, #$B9E1, #$B9E3, #$B9E4, #$B9E5, #$B9E8, #$B9EC,
      #$B9F4, #$B9F5, #$B9F7, #$B9F8, #$B9F9, #$B9FA, #$BA00, #$BA01,
      #$BA08, #$BA15, #$BA38, #$BA39, #$BA3C, #$BA40, #$BA42, #$BA48,
      #$BA49, #$BA4B, #$BA4D, #$BA4E, #$BA53, #$BA54, #$BA55, #$BA58,
      #$BA5C, #$BA64, #$BA65, #$BA67, #$BA68, #$BA69, #$BA70, #$BA71,
      #$BA74, #$BA78, #$BA83, #$BA84, #$BA85, #$BA87, #$BA8C, #$BAA8,
      #$BAA9, #$BAAB, #$BAAC, #$BAB0, #$BAB2, #$BAB8, #$BAB9, #$BABB,
      #$BABD, #$BAC4, #$BAC8, #$BAD8, #$BAD9, #$BAFC,
      #$BB00, #$BB04, #$BB0D, #$BB0F, #$BB11, #$BB18, #$BB1C, #$BB20,
      #$BB29, #$BB2B, #$BB34, #$BB35, #$BB36, #$BB38, #$BB3B, #$BB3C,
      #$BB3D, #$BB3E, #$BB44, #$BB45, #$BB47, #$BB49, #$BB4D, #$BB4F,
      #$BB50, #$BB54, #$BB58, #$BB61, #$BB63, #$BB6C, #$BB88, #$BB8C,
      #$BB90, #$BBA4, #$BBA8, #$BBAC, #$BBB4, #$BBB7, #$BBC0, #$BBC4,
      #$BBC8, #$BBD0, #$BBD3, #$BBF8, #$BBF9, #$BBFC, #$BBFF, #$BC00,
      #$BC02, #$BC08, #$BC09, #$BC0B, #$BC0C, #$BC0D, #$BC0F, #$BC11,
      #$BC14, #$BC15, #$BC16, #$BC17, #$BC18, #$BC1B, #$BC1C, #$BC1D,
      #$BC1E, #$BC1F, #$BC24, #$BC25, #$BC27, #$BC29, #$BC2D, #$BC30,
      #$BC31, #$BC34, #$BC38, #$BC40, #$BC41, #$BC43, #$BC44, #$BC45,
      #$BC49, #$BC4C, #$BC4D, #$BC50, #$BC5D, #$BC84, #$BC85, #$BC88,
      #$BC8B, #$BC8C, #$BC8E, #$BC94, #$BC95, #$BC97,
      #$BC99, #$BC9A, #$BCA0, #$BCA1, #$BCA4, #$BCA7, #$BCA8, #$BCB0,
      #$BCB1, #$BCB3, #$BCB4, #$BCB5, #$BCBC, #$BCBD, #$BCC0, #$BCC4,
      #$BCCD, #$BCCF, #$BCD0, #$BCD1, #$BCD5, #$BCD8, #$BCDC, #$BCF4,
      #$BCF5, #$BCF6, #$BCF8, #$BCFC, #$BD04, #$BD05, #$BD07, #$BD09,
      #$BD10, #$BD14, #$BD24, #$BD2C, #$BD40, #$BD48, #$BD49, #$BD4C,
      #$BD50, #$BD58, #$BD59, #$BD64, #$BD68, #$BD80, #$BD81, #$BD84,
      #$BD87, #$BD88, #$BD89, #$BD8A, #$BD90, #$BD91, #$BD93, #$BD95,
      #$BD99, #$BD9A, #$BD9C, #$BDA4, #$BDB0, #$BDB8, #$BDD4, #$BDD5,
      #$BDD8, #$BDDC, #$BDE9, #$BDF0, #$BDF4, #$BDF8, #$BE00, #$BE03,
      #$BE05, #$BE0C, #$BE0D, #$BE10, #$BE14, #$BE1C, #$BE1D, #$BE1F,
      #$BE44, #$BE45, #$BE48, #$BE4C, #$BE4E, #$BE54, #$BE55, #$BE57,
      #$BE59, #$BE5A, #$BE5B, #$BE60, #$BE61, #$BE64,
      #$BE68, #$BE6A, #$BE70, #$BE71, #$BE73, #$BE74, #$BE75, #$BE7B,
      #$BE7C, #$BE7D, #$BE80, #$BE84, #$BE8C, #$BE8D, #$BE8F, #$BE90,
      #$BE91, #$BE98, #$BE99, #$BEA8, #$BED0, #$BED1, #$BED4, #$BED7,
      #$BED8, #$BEE0, #$BEE3, #$BEE4, #$BEE5, #$BEEC, #$BF01, #$BF08,
      #$BF09, #$BF18, #$BF19, #$BF1B, #$BF1C, #$BF1D, #$BF40, #$BF41,
      #$BF44, #$BF48, #$BF50, #$BF51, #$BF55, #$BF94, #$BFB0, #$BFC5,
      #$BFCC, #$BFCD, #$BFD0, #$BFD4, #$BFDC, #$BFDF, #$BFE1, #$C03C,
      #$C051, #$C058, #$C05C, #$C060, #$C068, #$C069, #$C090, #$C091,
      #$C094, #$C098, #$C0A0, #$C0A1, #$C0A3, #$C0A5, #$C0AC, #$C0AD,
      #$C0AF, #$C0B0, #$C0B3, #$C0B4, #$C0B5, #$C0B6, #$C0BC, #$C0BD,
      #$C0BF, #$C0C0, #$C0C1, #$C0C5, #$C0C8, #$C0C9, #$C0CC, #$C0D0,
      #$C0D8, #$C0D9, #$C0DB, #$C0DC, #$C0DD, #$C0E4,
      #$C0E5, #$C0E8, #$C0EC, #$C0F4, #$C0F5, #$C0F7, #$C0F9, #$C100,
      #$C104, #$C108, #$C110, #$C115, #$C11C, #$C11D, #$C11E, #$C11F,
      #$C120, #$C123, #$C124, #$C126, #$C127, #$C12C, #$C12D, #$C12F,
      #$C130, #$C131, #$C136, #$C138, #$C139, #$C13C, #$C140, #$C148,
      #$C149, #$C14B, #$C14C, #$C14D, #$C154, #$C155, #$C158, #$C15C,
      #$C164, #$C165, #$C167, #$C168, #$C169, #$C170, #$C174, #$C178,
      #$C185, #$C18C, #$C18D, #$C18E, #$C190, #$C194, #$C196, #$C19C,
      #$C19D, #$C19F, #$C1A1, #$C1A5, #$C1A8, #$C1A9, #$C1AC, #$C1B0,
      #$C1BD, #$C1C4, #$C1C8, #$C1CC, #$C1D4, #$C1D7, #$C1D8, #$C1E0,
      #$C1E4, #$C1E8, #$C1F0, #$C1F1, #$C1F3, #$C1FC, #$C1FD, #$C200,
      #$C204, #$C20C, #$C20D, #$C20F, #$C211, #$C218, #$C219, #$C21C,
      #$C21F, #$C220, #$C228, #$C229, #$C22B, #$C22D,
      #$C22F, #$C231, #$C232, #$C234, #$C248, #$C250, #$C251, #$C254,
      #$C258, #$C260, #$C265, #$C26C, #$C26D, #$C270, #$C274, #$C27C,
      #$C27D, #$C27F, #$C281, #$C288, #$C289, #$C290, #$C298, #$C29B,
      #$C29D, #$C2A4, #$C2A5, #$C2A8, #$C2AC, #$C2AD, #$C2B4, #$C2B5,
      #$C2B7, #$C2B9, #$C2DC, #$C2DD, #$C2E0, #$C2E3, #$C2E4, #$C2EB,
      #$C2EC, #$C2ED, #$C2EF, #$C2F1, #$C2F6, #$C2F8, #$C2F9, #$C2FB,
      #$C2FC, #$C300, #$C308, #$C309, #$C30C, #$C30D, #$C313, #$C314,
      #$C315, #$C318, #$C31C, #$C324, #$C325, #$C328, #$C329, #$C345,
      #$C368, #$C369, #$C36C, #$C370, #$C372, #$C378, #$C379, #$C37C,
      #$C37D, #$C384, #$C388, #$C38C, #$C3C0, #$C3D8, #$C3D9, #$C3DC,
      #$C3DF, #$C3E0, #$C3E2, #$C3E8, #$C3E9, #$C3ED, #$C3F4, #$C3F5,
      #$C3F8, #$C408, #$C410, #$C424, #$C42C, #$C430,
      #$C434, #$C43C, #$C43D, #$C448, #$C464, #$C465, #$C468, #$C46C,
      #$C474, #$C475, #$C479, #$C480, #$C494, #$C49C, #$C4B8, #$C4BC,
      #$C4E9, #$C4F0, #$C4F1, #$C4F4, #$C4F8, #$C4FA, #$C4FF, #$C500,
      #$C501, #$C50C, #$C510, #$C514, #$C51C, #$C528, #$C529, #$C52C,
      #$C530, #$C538, #$C539, #$C53B, #$C53D, #$C544, #$C545, #$C548,
      #$C549, #$C54A, #$C54C, #$C54D, #$C54E, #$C553, #$C554, #$C555,
      #$C557, #$C558, #$C559, #$C55D, #$C55E, #$C560, #$C561, #$C564,
      #$C568, #$C570, #$C571, #$C573, #$C574, #$C575, #$C57C, #$C57D,
      #$C580, #$C584, #$C587, #$C58C, #$C58D, #$C58F, #$C591, #$C595,
      #$C597, #$C598, #$C59C, #$C5A0, #$C5A9, #$C5B4, #$C5B5, #$C5B8,
      #$C5B9, #$C5BB, #$C5BC, #$C5BD, #$C5BE, #$C5C4, #$C5C5, #$C5C6,
      #$C5C7, #$C5C8, #$C5C9, #$C5CA, #$C5CC, #$C5CE,
      #$C5D0, #$C5D1, #$C5D4, #$C5D8, #$C5E0, #$C5E1, #$C5E3, #$C5E5,
      #$C5EC, #$C5ED, #$C5EE, #$C5F0, #$C5F4, #$C5F6, #$C5F7, #$C5FC,
      #$C5FD, #$C5FE, #$C5FF, #$C600, #$C601, #$C605, #$C606, #$C607,
      #$C608, #$C60C, #$C610, #$C618, #$C619, #$C61B, #$C61C, #$C624,
      #$C625, #$C628, #$C62C, #$C62D, #$C62E, #$C630, #$C633, #$C634,
      #$C635, #$C637, #$C639, #$C63B, #$C640, #$C641, #$C644, #$C648,
      #$C650, #$C651, #$C653, #$C654, #$C655, #$C65C, #$C65D, #$C660,
      #$C66C, #$C66F, #$C671, #$C678, #$C679, #$C67C, #$C680, #$C688,
      #$C689, #$C68B, #$C68D, #$C694, #$C695, #$C698, #$C69C, #$C6A4,
      #$C6A5, #$C6A7, #$C6A9, #$C6B0, #$C6B1, #$C6B4, #$C6B8, #$C6B9,
      #$C6BA, #$C6C0, #$C6C1, #$C6C3, #$C6C5, #$C6CC, #$C6CD, #$C6D0,
      #$C6D4, #$C6DC, #$C6DD, #$C6E0, #$C6E1, #$C6E8,
      #$C6E9, #$C6EC, #$C6F0, #$C6F8, #$C6F9, #$C6FD, #$C704, #$C705,
      #$C708, #$C70C, #$C714, #$C715, #$C717, #$C719, #$C720, #$C721,
      #$C724, #$C728, #$C730, #$C731, #$C733, #$C735, #$C737, #$C73C,
      #$C73D, #$C740, #$C744, #$C74A, #$C74C, #$C74D, #$C74F, #$C751,
      #$C752, #$C753, #$C754, #$C755, #$C756, #$C757, #$C758, #$C75C,
      #$C760, #$C768, #$C76B, #$C774, #$C775, #$C778, #$C77C, #$C77D,
      #$C77E, #$C783, #$C784, #$C785, #$C787, #$C788, #$C789, #$C78A,
      #$C78E, #$C790, #$C791, #$C794, #$C796, #$C797, #$C798, #$C79A,
      #$C7A0, #$C7A1, #$C7A3, #$C7A4, #$C7A5, #$C7A6, #$C7AC, #$C7AD,
      #$C7B0, #$C7B4, #$C7BC, #$C7BD, #$C7BF, #$C7C0, #$C7C1, #$C7C8,
      #$C7C9, #$C7CC, #$C7CE, #$C7D0, #$C7D8, #$C7DD, #$C7E4, #$C7E8,
      #$C7EC, #$C800, #$C801, #$C804, #$C808, #$C80A,
      #$C810, #$C811, #$C813, #$C815, #$C816, #$C81C, #$C81D, #$C820,
      #$C824, #$C82C, #$C82D, #$C82F, #$C831, #$C838, #$C83C, #$C840,
      #$C848, #$C849, #$C84C, #$C84D, #$C854, #$C870, #$C871, #$C874,
      #$C878, #$C87A, #$C880, #$C881, #$C883, #$C885, #$C886, #$C887,
      #$C88B, #$C88C, #$C88D, #$C894, #$C89D, #$C89F, #$C8A1, #$C8A8,
      #$C8BC, #$C8BD, #$C8C4, #$C8C8, #$C8CC, #$C8D4, #$C8D5, #$C8D7,
      #$C8D9, #$C8E0, #$C8E1, #$C8E4, #$C8F5, #$C8FC, #$C8FD, #$C900,
      #$C904, #$C905, #$C906, #$C90C, #$C90D, #$C90F, #$C911, #$C918,
      #$C92C, #$C934, #$C950, #$C951, #$C954, #$C958, #$C960, #$C961,
      #$C963, #$C96C, #$C970, #$C974, #$C97C, #$C988, #$C989, #$C98C,
      #$C990, #$C998, #$C999, #$C99B, #$C99D, #$C9C0, #$C9C1, #$C9C4,
      #$C9C7, #$C9C8, #$C9CA, #$C9D0, #$C9D1, #$C9D3,
      #$C9D5, #$C9D6, #$C9D9, #$C9DA, #$C9DC, #$C9DD, #$C9E0, #$C9E2,
      #$C9E4, #$C9E7, #$C9EC, #$C9ED, #$C9EF, #$C9F0, #$C9F1, #$C9F8,
      #$C9F9, #$C9FC, #$CA00, #$CA08, #$CA09, #$CA0B, #$CA0C, #$CA0D,
      #$CA14, #$CA18, #$CA29, #$CA4C, #$CA4D, #$CA50, #$CA54, #$CA5C,
      #$CA5D, #$CA5F, #$CA60, #$CA61, #$CA68, #$CA7D, #$CA84, #$CA98,
      #$CABC, #$CABD, #$CAC0, #$CAC4, #$CACC, #$CACD, #$CACF, #$CAD1,
      #$CAD3, #$CAD8, #$CAD9, #$CAE0, #$CAEC, #$CAF4, #$CB08, #$CB10,
      #$CB14, #$CB18, #$CB20, #$CB21, #$CB41, #$CB48, #$CB49, #$CB4C,
      #$CB50, #$CB58, #$CB59, #$CB5D, #$CB64, #$CB78, #$CB79, #$CB9C,
      #$CBB8, #$CBD4, #$CBE4, #$CBE7, #$CBE9, #$CC0C, #$CC0D, #$CC10,
      #$CC14, #$CC1C, #$CC1D, #$CC21, #$CC22, #$CC27, #$CC28, #$CC29,
      #$CC2C, #$CC2E, #$CC30, #$CC38, #$CC39, #$CC3B,
      #$CC3C, #$CC3D, #$CC3E, #$CC44, #$CC45, #$CC48, #$CC4C, #$CC54,
      #$CC55, #$CC57, #$CC58, #$CC59, #$CC60, #$CC64, #$CC66, #$CC68,
      #$CC70, #$CC75, #$CC98, #$CC99, #$CC9C, #$CCA0, #$CCA8, #$CCA9,
      #$CCAB, #$CCAC, #$CCAD, #$CCB4, #$CCB5, #$CCB8, #$CCBC, #$CCC4,
      #$CCC5, #$CCC7, #$CCC9, #$CCD0, #$CCD4, #$CCE4, #$CCEC, #$CCF0,
      #$CD01, #$CD08, #$CD09, #$CD0C, #$CD10, #$CD18, #$CD19, #$CD1B,
      #$CD1D, #$CD24, #$CD28, #$CD2C, #$CD39, #$CD5C, #$CD60, #$CD64,
      #$CD6C, #$CD6D, #$CD6F, #$CD71, #$CD78, #$CD88, #$CD94, #$CD95,
      #$CD98, #$CD9C, #$CDA4, #$CDA5, #$CDA7, #$CDA9, #$CDB0, #$CDC4,
      #$CDCC, #$CDD0, #$CDE8, #$CDEC, #$CDF0, #$CDF8, #$CDF9, #$CDFB,
      #$CDFD, #$CE04, #$CE08, #$CE0C, #$CE14, #$CE19, #$CE20, #$CE21,
      #$CE24, #$CE28, #$CE30, #$CE31, #$CE33, #$CE35,
      #$CE58, #$CE59, #$CE5C, #$CE5F, #$CE60, #$CE61, #$CE68, #$CE69,
      #$CE6B, #$CE6D, #$CE74, #$CE75, #$CE78, #$CE7C, #$CE84, #$CE85,
      #$CE87, #$CE89, #$CE90, #$CE91, #$CE94, #$CE98, #$CEA0, #$CEA1,
      #$CEA3, #$CEA4, #$CEA5, #$CEAC, #$CEAD, #$CEC1, #$CEE4, #$CEE5,
      #$CEE8, #$CEEB, #$CEEC, #$CEF4, #$CEF5, #$CEF7, #$CEF8, #$CEF9,
      #$CF00, #$CF01, #$CF04, #$CF08, #$CF10, #$CF11, #$CF13, #$CF15,
      #$CF1C, #$CF20, #$CF24, #$CF2C, #$CF2D, #$CF2F, #$CF30, #$CF31,
      #$CF38, #$CF54, #$CF55, #$CF58, #$CF5C, #$CF64, #$CF65, #$CF67,
      #$CF69, #$CF70, #$CF71, #$CF74, #$CF78, #$CF80, #$CF85, #$CF8C,
      #$CFA1, #$CFA8, #$CFB0, #$CFC4, #$CFE0, #$CFE1, #$CFE4, #$CFE8,
      #$CFF0, #$CFF1, #$CFF3, #$CFF5, #$CFFC, #$D000, #$D004, #$D011,
      #$D018, #$D02D, #$D034, #$D035, #$D038, #$D03C,
      #$D044, #$D045, #$D047, #$D049, #$D050, #$D054, #$D058, #$D060,
      #$D06C, #$D06D, #$D070, #$D074, #$D07C, #$D07D, #$D081, #$D0A4,
      #$D0A5, #$D0A8, #$D0AC, #$D0B4, #$D0B5, #$D0B7, #$D0B9, #$D0C0,
      #$D0C1, #$D0C4, #$D0C8, #$D0C9, #$D0D0, #$D0D1, #$D0D3, #$D0D4,
      #$D0D5, #$D0DC, #$D0DD, #$D0E0, #$D0E4, #$D0EC, #$D0ED, #$D0EF,
      #$D0F0, #$D0F1, #$D0F8, #$D10D, #$D130, #$D131, #$D134, #$D138,
      #$D13A, #$D140, #$D141, #$D143, #$D144, #$D145, #$D14C, #$D14D,
      #$D150, #$D154, #$D15C, #$D15D, #$D15F, #$D161, #$D168, #$D16C,
      #$D17C, #$D184, #$D188, #$D1A0, #$D1A1, #$D1A4, #$D1A8, #$D1B0,
      #$D1B1, #$D1B3, #$D1B5, #$D1BA, #$D1BC, #$D1C0, #$D1D8, #$D1F4,
      #$D1F8, #$D207, #$D209, #$D210, #$D22C, #$D22D, #$D230, #$D234,
      #$D23C, #$D23D, #$D23F, #$D241, #$D248, #$D25C,
      #$D264, #$D280, #$D281, #$D284, #$D288, #$D290, #$D291, #$D295,
      #$D29C, #$D2A0, #$D2A4, #$D2AC, #$D2B1, #$D2B8, #$D2B9, #$D2BC,
      #$D2BF, #$D2C0, #$D2C2, #$D2C8, #$D2C9, #$D2CB, #$D2D4, #$D2D8,
      #$D2DC, #$D2E4, #$D2E5, #$D2F0, #$D2F1, #$D2F4, #$D2F8, #$D300,
      #$D301, #$D303, #$D305, #$D30C, #$D30D, #$D30E, #$D310, #$D314,
      #$D316, #$D31C, #$D31D, #$D31F, #$D320, #$D321, #$D325, #$D328,
      #$D329, #$D32C, #$D330, #$D338, #$D339, #$D33B, #$D33C, #$D33D,
      #$D344, #$D345, #$D37C, #$D37D, #$D380, #$D384, #$D38C, #$D38D,
      #$D38F, #$D390, #$D391, #$D398, #$D399, #$D39C, #$D3A0, #$D3A8,
      #$D3A9, #$D3AB, #$D3AD, #$D3B4, #$D3B8, #$D3BC, #$D3C4, #$D3C5,
      #$D3C8, #$D3C9, #$D3D0, #$D3D8, #$D3E1, #$D3E3, #$D3EC, #$D3ED,
      #$D3F0, #$D3F4, #$D3FC, #$D3FD, #$D3FF, #$D401,
      #$D408, #$D41D, #$D440, #$D444, #$D45C, #$D460, #$D464, #$D46D,
      #$D46F, #$D478, #$D479, #$D47C, #$D47F, #$D480, #$D482, #$D488,
      #$D489, #$D48B, #$D48D, #$D494, #$D4A9, #$D4CC, #$D4D0, #$D4D4,
      #$D4DC, #$D4DF, #$D4E8, #$D4EC, #$D4F0, #$D4F8, #$D4FB, #$D4FD,
      #$D504, #$D508, #$D50C, #$D514, #$D515, #$D517, #$D53C, #$D53D,
      #$D540, #$D544, #$D54C, #$D54D, #$D54F, #$D551, #$D558, #$D559,
      #$D55C, #$D560, #$D565, #$D568, #$D569, #$D56B, #$D56D, #$D574,
      #$D575, #$D578, #$D57C, #$D584, #$D585, #$D587, #$D588, #$D589,
      #$D590, #$D5A5, #$D5C8, #$D5C9, #$D5CC, #$D5D0, #$D5D2, #$D5D8,
      #$D5D9, #$D5DB, #$D5DD, #$D5E4, #$D5E5, #$D5E8, #$D5EC, #$D5F4,
      #$D5F5, #$D5F7, #$D5F9, #$D600, #$D601, #$D604, #$D608, #$D610,
      #$D611, #$D613, #$D614, #$D615, #$D61C, #$D620,
      #$D624, #$D62D, #$D638, #$D639, #$D63C, #$D640, #$D645, #$D648,
      #$D649, #$D64B, #$D64D, #$D651, #$D654, #$D655, #$D658, #$D65C,
      #$D667, #$D669, #$D670, #$D671, #$D674, #$D683, #$D685, #$D68C,
      #$D68D, #$D690, #$D694, #$D69D, #$D69F, #$D6A1, #$D6A8, #$D6AC,
      #$D6B0, #$D6B9, #$D6BB, #$D6C4, #$D6C5, #$D6C8, #$D6CC, #$D6D1,
      #$D6D4, #$D6D7, #$D6D9, #$D6E0, #$D6E4, #$D6E8, #$D6F0, #$D6F5,
      #$D6FC, #$D6FD, #$D700, #$D704, #$D711, #$D718, #$D719, #$D71C,
      #$D720, #$D728, #$D729, #$D72B, #$D72D, #$D734, #$D735, #$D738,
      #$D73C, #$D744, #$D747, #$D749, #$D750, #$D751, #$D754, #$D756,
      #$D757, #$D758, #$D759, #$D760, #$D761, #$D763, #$D765, #$D769,
      #$D76C, #$D770, #$D774, #$D77C, #$D77D, #$D781, #$D788, #$D789,
      #$D78C, #$D790, #$D798, #$D799, #$D79B, #$D79D);
  KSC5601_3Map: array[0..4887] of TBuffChar = (
      #$4F3D, #$4F73, #$5047, #$50F9, #$52A0, #$53EF, #$5475, #$54E5,
      #$5609, #$5AC1, #$5BB6, #$6687, #$67B6, #$67B7, #$67EF, #$6B4C,
      #$73C2, #$75C2, #$7A3C, #$82DB, #$8304, #$8857, #$8888, #$8A36,
      #$8CC8, #$8DCF, #$8EFB, #$8FE6, #$99D5, #$523B, #$5374, #$5404,
      #$606A, #$6164, #$6BBC, #$73CF, #$811A, #$89BA, #$89D2, #$95A3,
      #$4F83, #$520A, #$58BE, #$5978, #$59E6, #$5E72, #$5E79, #$61C7,
      #$63C0, #$6746, #$67EC, #$687F, #$6F97, #$764E, #$770B, #$78F5,
      #$7A08, #$7AFF, #$7C21, #$809D, #$826E, #$8271, #$8AEB, #$9593,
      #$4E6B, #$559D, #$66F7, #$6E34, #$78A3, #$7AED, #$845B, #$8910,
      #$874E, #$97A8, #$52D8, #$574E, #$582A, #$5D4C, #$611F, #$61BE,
      #$6221, #$6562, #$67D1, #$6A44, #$6E1B, #$7518, #$75B3, #$76E3,
      #$77B0, #$7D3A, #$90AF, #$9451, #$9452, #$9F95,
      #$5323, #$5CAC, #$7532, #$80DB, #$9240, #$9598, #$525B, #$5808,
      #$59DC, #$5CA1, #$5D17, #$5EB7, #$5F3A, #$5F4A, #$6177, #$6C5F,
      #$757A, #$7586, #$7CE0, #$7D73, #$7DB1, #$7F8C, #$8154, #$8221,
      #$8591, #$8941, #$8B1B, #$92FC, #$964D, #$9C47, #$4ECB, #$4EF7,
      #$500B, #$51F1, #$584F, #$6137, #$613E, #$6168, #$6539, #$69EA,
      #$6F11, #$75A5, #$7686, #$76D6, #$7B87, #$82A5, #$84CB, #$F900,
      #$93A7, #$958B, #$5580, #$5BA2, #$5751, #$F901, #$7CB3, #$7FB9,
      #$91B5, #$5028, #$53BB, #$5C45, #$5DE8, #$62D2, #$636E, #$64DA,
      #$64E7, #$6E20, #$70AC, #$795B, #$8DDD, #$8E1E, #$F902, #$907D,
      #$9245, #$92F8, #$4E7E, #$4EF6, #$5065, #$5DFE, #$5EFA, #$6106,
      #$6957, #$8171, #$8654, #$8E47, #$9375, #$9A2B, #$4E5E, #$5091,
      #$6770, #$6840, #$5109, #$528D, #$5292, #$6AA2,
      #$77BC, #$9210, #$9ED4, #$52AB, #$602F, #$8FF2, #$5048, #$61A9,
      #$63ED, #$64CA, #$683C, #$6A84, #$6FC0, #$8188, #$89A1, #$9694,
      #$5805, #$727D, #$72AC, #$7504, #$7D79, #$7E6D, #$80A9, #$898B,
      #$8B74, #$9063, #$9D51, #$6289, #$6C7A, #$6F54, #$7D50, #$7F3A,
      #$8A23, #$517C, #$614A, #$7B9D, #$8B19, #$9257, #$938C, #$4EAC,
      #$4FD3, #$501E, #$50BE, #$5106, #$52C1, #$52CD, #$537F, #$5770,
      #$5883, #$5E9A, #$5F91, #$6176, #$61AC, #$64CE, #$656C, #$666F,
      #$66BB, #$66F4, #$6897, #$6D87, #$7085, #$70F1, #$749F, #$74A5,
      #$74CA, #$75D9, #$786C, #$78EC, #$7ADF, #$7AF6, #$7D45, #$7D93,
      #$8015, #$803F, #$811B, #$8396, #$8B66, #$8F15, #$9015, #$93E1,
      #$9803, #$9838, #$9A5A, #$9BE8, #$4FC2, #$5553, #$583A, #$5951,
      #$5B63, #$5C46, #$60B8, #$6212, #$6842, #$68B0,
      #$68E8, #$6EAA, #$754C, #$7678, #$78CE, #$7A3D, #$7CFB, #$7E6B,
      #$7E7C, #$8A08, #$8AA1, #$8C3F, #$968E, #$9DC4, #$53E4, #$53E9,
      #$544A, #$5471, #$56FA, #$59D1, #$5B64, #$5C3B, #$5EAB, #$62F7,
      #$6537, #$6545, #$6572, #$66A0, #$67AF, #$69C1, #$6CBD, #$75FC,
      #$7690, #$777E, #$7A3F, #$7F94, #$8003, #$80A1, #$818F, #$82E6,
      #$82FD, #$83F0, #$85C1, #$8831, #$88B4, #$8AA5, #$F903, #$8F9C,
      #$932E, #$96C7, #$9867, #$9AD8, #$9F13, #$54ED, #$659B, #$66F2,
      #$688F, #$7A40, #$8C37, #$9D60, #$56F0, #$5764, #$5D11, #$6606,
      #$68B1, #$68CD, #$6EFE, #$7428, #$889E, #$9BE4, #$6C68, #$F904,
      #$9AA8, #$4F9B, #$516C, #$5171, #$529F, #$5B54, #$5DE5, #$6050,
      #$606D, #$62F1, #$63A7, #$653B, #$73D9, #$7A7A, #$86A3, #$8CA2,
      #$978F, #$4E32, #$5BE1, #$6208, #$679C, #$74DC,
      #$79D1, #$83D3, #$8A87, #$8AB2, #$8DE8, #$904E, #$934B, #$9846,
      #$5ED3, #$69E8, #$85FF, #$90ED, #$F905, #$51A0, #$5B98, #$5BEC,
      #$6163, #$68FA, #$6B3E, #$704C, #$742F, #$74D8, #$7BA1, #$7F50,
      #$83C5, #$89C0, #$8CAB, #$95DC, #$9928, #$522E, #$605D, #$62EC,
      #$9002, #$4F8A, #$5149, #$5321, #$58D9, #$5EE3, #$66E0, #$6D38,
      #$709A, #$72C2, #$73D6, #$7B50, #$80F1, #$945B, #$5366, #$639B,
      #$7F6B, #$4E56, #$5080, #$584A, #$58DE, #$602A, #$6127, #$62D0,
      #$69D0, #$9B41, #$5B8F, #$7D18, #$80B1, #$8F5F, #$4EA4, #$50D1,
      #$54AC, #$55AC, #$5B0C, #$5DA0, #$5DE7, #$652A, #$654E, #$6821,
      #$6A4B, #$72E1, #$768E, #$77EF, #$7D5E, #$7FF9, #$81A0, #$854E,
      #$86DF, #$8F03, #$8F4E, #$90CA, #$9903, #$9A55, #$9BAB, #$4E18,
      #$4E45, #$4E5D, #$4EC7, #$4FF1, #$5177, #$52FE,
      #$5340, #$53E3, #$53E5, #$548E, #$5614, #$5775, #$57A2, #$5BC7,
      #$5D87, #$5ED0, #$61FC, #$62D8, #$6551, #$67B8, #$67E9, #$69CB,
      #$6B50, #$6BC6, #$6BEC, #$6C42, #$6E9D, #$7078, #$72D7, #$7396,
      #$7403, #$77BF, #$77E9, #$7A76, #$7D7F, #$8009, #$81FC, #$8205,
      #$820A, #$82DF, #$8862, #$8B33, #$8CFC, #$8EC0, #$9011, #$90B1,
      #$9264, #$92B6, #$99D2, #$9A45, #$9CE9, #$9DD7, #$9F9C, #$570B,
      #$5C40, #$83CA, #$97A0, #$97AB, #$9EB4, #$541B, #$7A98, #$7FA4,
      #$88D9, #$8ECD, #$90E1, #$5800, #$5C48, #$6398, #$7A9F, #$5BAE,
      #$5F13, #$7A79, #$7AAE, #$828E, #$8EAC, #$5026, #$5238, #$52F8,
      #$5377, #$5708, #$62F3, #$6372, #$6B0A, #$6DC3, #$7737, #$53A5,
      #$7357, #$8568, #$8E76, #$95D5, #$673A, #$6AC3, #$6F70, #$8A6D,
      #$8ECC, #$994B, #$F906, #$6677, #$6B78, #$8CB4,
      #$9B3C, #$F907, #$53EB, #$572D, #$594E, #$63C6, #$69FB, #$73EA,
      #$7845, #$7ABA, #$7AC5, #$7CFE, #$8475, #$898F, #$8D73, #$9035,
      #$95A8, #$52FB, #$5747, #$7547, #$7B60, #$83CC, #$921E, #$F908,
      #$6A58, #$514B, #$524B, #$5287, #$621F, #$68D8, #$6975, #$9699,
      #$50C5, #$52A4, #$52E4, #$61C3, #$65A4, #$6839, #$69FF, #$747E,
      #$7B4B, #$82B9, #$83EB, #$89B2, #$8B39, #$8FD1, #$9949, #$F909,
      #$4ECA, #$5997, #$64D2, #$6611, #$6A8E, #$7434, #$7981, #$79BD,
      #$82A9, #$887E, #$887F, #$895F, #$F90A, #$9326, #$4F0B, #$53CA,
      #$6025, #$6271, #$6C72, #$7D1A, #$7D66, #$4E98, #$5162, #$77DC,
      #$80AF, #$4F01, #$4F0E, #$5176, #$5180, #$55DC, #$5668, #$573B,
      #$57FA, #$57FC, #$5914, #$5947, #$5993, #$5BC4, #$5C90, #$5D0E,
      #$5DF1, #$5E7E, #$5FCC, #$6280, #$65D7, #$65E3,
      #$671E, #$671F, #$675E, #$68CB, #$68C4, #$6A5F, #$6B3A, #$6C23,
      #$6C7D, #$6C82, #$6DC7, #$7398, #$7426, #$742A, #$7482, #$74A3,
      #$7578, #$757F, #$7881, #$78EF, #$7941, #$7947, #$7948, #$797A,
      #$7B95, #$7D00, #$7DBA, #$7F88, #$8006, #$802D, #$808C, #$8A18,
      #$8B4F, #$8C48, #$8D77, #$9321, #$9324, #$98E2, #$9951, #$9A0E,
      #$9A0F, #$9A65, #$9E92, #$7DCA, #$4F76, #$5409, #$62EE, #$6854,
      #$91D1, #$55AB, #$513A, #$F90B, #$F90C, #$5A1C, #$61E6, #$F90D,
      #$62CF, #$62FF, #$F90E, #$F90F, #$F910, #$F911, #$F912, #$F913,
      #$90A3, #$F914, #$F915, #$F916, #$F917, #$F918, #$8AFE, #$F919,
      #$F91A, #$F91B, #$F91C, #$6696, #$F91D, #$7156, #$F91E, #$F91F,
      #$96E3, #$F920, #$634F, #$637A, #$5357, #$F921, #$678F, #$6960,
      #$6E73, #$F922, #$7537, #$F923, #$F924, #$F925,
      #$7D0D, #$F926, #$F927, #$8872, #$56CA, #$5A18, #$F928, #$F929,
      #$F92A, #$F92B, #$F92C, #$4E43, #$F92D, #$5167, #$5948, #$67F0,
      #$8010, #$F92E, #$5973, #$5E74, #$649A, #$79CA, #$5FF5, #$606C,
      #$62C8, #$637B, #$5BE7, #$5BD7, #$52AA, #$F92F, #$5974, #$5F29,
      #$6012, #$F930, #$F931, #$F932, #$7459, #$F933, #$F934, #$F935,
      #$F936, #$F937, #$F938, #$99D1, #$F939, #$F93A, #$F93B, #$F93C,
      #$F93D, #$F93E, #$F93F, #$F940, #$F941, #$F942, #$F943, #$6FC3,
      #$F944, #$F945, #$81BF, #$8FB2, #$60F1, #$F946, #$F947, #$8166,
      #$F948, #$F949, #$5C3F, #$F94A, #$F94B, #$F94C, #$F94D, #$F94E,
      #$F94F, #$F950, #$F951, #$5AE9, #$8A25, #$677B, #$7D10, #$F952,
      #$F953, #$F954, #$F955, #$F956, #$F957, #$80FD, #$F958, #$F959,
      #$5C3C, #$6CE5, #$533F, #$6EBA, #$591A, #$8336,
      #$4E39, #$4EB6, #$4F46, #$55AE, #$5718, #$58C7, #$5F56, #$65B7,
      #$65E6, #$6A80, #$6BB5, #$6E4D, #$77ED, #$7AEF, #$7C1E, #$7DDE,
      #$86CB, #$8892, #$9132, #$935B, #$64BB, #$6FBE, #$737A, #$75B8,
      #$9054, #$5556, #$574D, #$61BA, #$64D4, #$66C7, #$6DE1, #$6E5B,
      #$6F6D, #$6FB9, #$75F0, #$8043, #$81BD, #$8541, #$8983, #$8AC7,
      #$8B5A, #$931F, #$6C93, #$7553, #$7B54, #$8E0F, #$905D, #$5510,
      #$5802, #$5858, #$5E62, #$6207, #$649E, #$68E0, #$7576, #$7CD6,
      #$87B3, #$9EE8, #$4EE3, #$5788, #$576E, #$5927, #$5C0D, #$5CB1,
      #$5E36, #$5F85, #$6234, #$64E1, #$73B3, #$81FA, #$888B, #$8CB8,
      #$968A, #$9EDB, #$5B85, #$5FB7, #$60B3, #$5012, #$5200, #$5230,
      #$5716, #$5835, #$5857, #$5C0E, #$5C60, #$5CF6, #$5D8B, #$5EA6,
      #$5F92, #$60BC, #$6311, #$6389, #$6417, #$6843,
      #$68F9, #$6AC2, #$6DD8, #$6E21, #$6ED4, #$6FE4, #$71FE, #$76DC,
      #$7779, #$79B1, #$7A3B, #$8404, #$89A9, #$8CED, #$8DF3, #$8E48,
      #$9003, #$9014, #$9053, #$90FD, #$934D, #$9676, #$97DC, #$6BD2,
      #$7006, #$7258, #$72A2, #$7368, #$7763, #$79BF, #$7BE4, #$7E9B,
      #$8B80, #$58A9, #$60C7, #$6566, #$65FD, #$66BE, #$6C8C, #$711E,
      #$71C9, #$8C5A, #$9813, #$4E6D, #$7A81, #$4EDD, #$51AC, #$51CD,
      #$52D5, #$540C, #$61A7, #$6771, #$6850, #$68DF, #$6D1E, #$6F7C,
      #$75BC, #$77B3, #$7AE5, #$80F4, #$8463, #$9285, #$515C, #$6597,
      #$675C, #$6793, #$75D8, #$7AC7, #$8373, #$F95A, #$8C46, #$9017,
      #$982D, #$5C6F, #$81C0, #$829A, #$9041, #$906F, #$920D, #$5F97,
      #$5D9D, #$6A59, #$71C8, #$767B, #$7B49, #$85E4, #$8B04, #$9127,
      #$9A30, #$5587, #$61F6, #$F95B, #$7669, #$7F85,
      #$863F, #$87BA, #$88F8, #$908F, #$F95C, #$6D1B, #$70D9, #$73DE,
      #$7D61, #$843D, #$F95D, #$916A, #$99F1, #$F95E, #$4E82, #$5375,
      #$6B04, #$6B12, #$703E, #$721B, #$862D, #$9E1E, #$524C, #$8FA3,
      #$5D50, #$64E5, #$652C, #$6B16, #$6FEB, #$7C43, #$7E9C, #$85CD,
      #$8964, #$89BD, #$62C9, #$81D8, #$881F, #$5ECA, #$6717, #$6D6A,
      #$72FC, #$7405, #$746F, #$8782, #$90DE, #$4F86, #$5D0D, #$5FA0,
      #$840A, #$51B7, #$63A0, #$7565, #$4EAE, #$5006, #$5169, #$51C9,
      #$6881, #$6A11, #$7CAE, #$7CB1, #$7CE7, #$826F, #$8AD2, #$8F1B,
      #$91CF, #$4FB6, #$5137, #$52F5, #$5442, #$5EEC, #$616E, #$623E,
      #$65C5, #$6ADA, #$6FFE, #$792A, #$85DC, #$8823, #$95AD, #$9A62,
      #$9A6A, #$9E97, #$9ECE, #$529B, #$66C6, #$6B77, #$701D, #$792B,
      #$8F62, #$9742, #$6190, #$6200, #$6523, #$6F23,
      #$7149, #$7489, #$7DF4, #$806F, #$84EE, #$8F26, #$9023, #$934A,
      #$51BD, #$5217, #$52A3, #$6D0C, #$70C8, #$88C2, #$5EC9, #$6582,
      #$6BAE, #$6FC2, #$7C3E, #$7375, #$4EE4, #$4F36, #$56F9, #$F95F,
      #$5CBA, #$5DBA, #$601C, #$73B2, #$7B2D, #$7F9A, #$7FCE, #$8046,
      #$901E, #$9234, #$96F6, #$9748, #$9818, #$9F61, #$4F8B, #$6FA7,
      #$79AE, #$91B4, #$96B7, #$52DE, #$F960, #$6488, #$64C4, #$6AD3,
      #$6F5E, #$7018, #$7210, #$76E7, #$8001, #$8606, #$865C, #$8DEF,
      #$8F05, #$9732, #$9B6F, #$9DFA, #$9E75, #$788C, #$797F, #$7DA0,
      #$83C9, #$9304, #$9E7F, #$9E93, #$8AD6, #$58DF, #$5F04, #$6727,
      #$7027, #$74CF, #$7C60, #$807E, #$5121, #$7028, #$7262, #$78CA,
      #$8CC2, #$8CDA, #$8CF4, #$96F7, #$4E86, #$50DA, #$5BEE, #$5ED6,
      #$6599, #$71CE, #$7642, #$77AD, #$804A, #$84FC,
      #$907C, #$9B27, #$9F8D, #$58D8, #$5A41, #$5C62, #$6A13, #$6DDA,
      #$6F0F, #$763B, #$7D2F, #$7E37, #$851E, #$8938, #$93E4, #$964B,
      #$5289, #$65D2, #$67F3, #$69B4, #$6D41, #$6E9C, #$700F, #$7409,
      #$7460, #$7559, #$7624, #$786B, #$8B2C, #$985E, #$516D, #$622E,
      #$9678, #$4F96, #$502B, #$5D19, #$6DEA, #$7DB8, #$8F2A, #$5F8B,
      #$6144, #$6817, #$F961, #$9686, #$52D2, #$808B, #$51DC, #$51CC,
      #$695E, #$7A1C, #$7DBE, #$83F1, #$9675, #$4FDA, #$5229, #$5398,
      #$540F, #$550E, #$5C65, #$60A7, #$674E, #$68A8, #$6D6C, #$7281,
      #$72F8, #$7406, #$7483, #$F962, #$75E2, #$7C6C, #$7F79, #$7FB8,
      #$8389, #$88CF, #$88E1, #$91CC, #$91D0, #$96E2, #$9BC9, #$541D,
      #$6F7E, #$71D0, #$7498, #$85FA, #$8EAA, #$96A3, #$9C57, #$9E9F,
      #$6797, #$6DCB, #$7433, #$81E8, #$9716, #$782C,
      #$7ACB, #$7B20, #$7C92, #$6469, #$746A, #$75F2, #$78BC, #$78E8,
      #$99AC, #$9B54, #$9EBB, #$5BDE, #$5E55, #$6F20, #$819C, #$83AB,
      #$9088, #$4E07, #$534D, #$5A29, #$5DD2, #$5F4E, #$6162, #$633D,
      #$6669, #$66FC, #$6EFF, #$6F2B, #$7063, #$779E, #$842C, #$8513,
      #$883B, #$8F13, #$9945, #$9C3B, #$551C, #$62B9, #$672B, #$6CAB,
      #$8309, #$896A, #$977A, #$4EA1, #$5984, #$5FD8, #$5FD9, #$671B,
      #$7DB2, #$7F54, #$8292, #$832B, #$83BD, #$8F1E, #$9099, #$57CB,
      #$59B9, #$5A92, #$5BD0, #$6627, #$679A, #$6885, #$6BCF, #$7164,
      #$7F75, #$8CB7, #$8CE3, #$9081, #$9B45, #$8108, #$8C8A, #$964C,
      #$9A40, #$9EA5, #$5B5F, #$6C13, #$731B, #$76F2, #$76DF, #$840C,
      #$51AA, #$8993, #$514D, #$5195, #$52C9, #$68C9, #$6C94, #$7704,
      #$7720, #$7DBF, #$7DEC, #$9762, #$9EB5, #$6EC5,
      #$8511, #$51A5, #$540D, #$547D, #$660E, #$669D, #$6927, #$6E9F,
      #$76BF, #$7791, #$8317, #$84C2, #$879F, #$9169, #$9298, #$9CF4,
      #$8882, #$4FAE, #$5192, #$52DF, #$59C6, #$5E3D, #$6155, #$6478,
      #$6479, #$66AE, #$67D0, #$6A21, #$6BCD, #$6BDB, #$725F, #$7261,
      #$7441, #$7738, #$77DB, #$8017, #$82BC, #$8305, #$8B00, #$8B28,
      #$8C8C, #$6728, #$6C90, #$7267, #$76EE, #$7766, #$7A46, #$9DA9,
      #$6B7F, #$6C92, #$5922, #$6726, #$8499, #$536F, #$5893, #$5999,
      #$5EDF, #$63CF, #$6634, #$6773, #$6E3A, #$732B, #$7AD7, #$82D7,
      #$9328, #$52D9, #$5DEB, #$61AE, #$61CB, #$620A, #$62C7, #$64AB,
      #$65E0, #$6959, #$6B66, #$6BCB, #$7121, #$73F7, #$755D, #$7E46,
      #$821E, #$8302, #$856A, #$8AA3, #$8CBF, #$9727, #$9D61, #$58A8,
      #$9ED8, #$5011, #$520E, #$543B, #$554F, #$6587,
      #$6C76, #$7D0A, #$7D0B, #$805E, #$868A, #$9580, #$96EF, #$52FF,
      #$6C95, #$7269, #$5473, #$5A9A, #$5C3E, #$5D4B, #$5F4C, #$5FAE,
      #$672A, #$68B6, #$6963, #$6E3C, #$6E44, #$7709, #$7C73, #$7F8E,
      #$8587, #$8B0E, #$8FF7, #$9761, #$9EF4, #$5CB7, #$60B6, #$610D,
      #$61AB, #$654F, #$65FB, #$65FC, #$6C11, #$6CEF, #$739F, #$73C9,
      #$7DE1, #$9594, #$5BC6, #$871C, #$8B10, #$525D, #$535A, #$62CD,
      #$640F, #$64B2, #$6734, #$6A38, #$6CCA, #$73C0, #$749E, #$7B94,
      #$7C95, #$7E1B, #$818A, #$8236, #$8584, #$8FEB, #$96F9, #$99C1,
      #$4F34, #$534A, #$53CD, #$53DB, #$62CC, #$642C, #$6500, #$6591,
      #$69C3, #$6CEE, #$6F58, #$73ED, #$7554, #$7622, #$76E4, #$76FC,
      #$78D0, #$78FB, #$792C, #$7D46, #$822C, #$87E0, #$8FD4, #$9812,
      #$98EF, #$52C3, #$62D4, #$64A5, #$6E24, #$6F51,
      #$767C, #$8DCB, #$91B1, #$9262, #$9AEE, #$9B43, #$5023, #$508D,
      #$574A, #$59A8, #$5C28, #$5E47, #$5F77, #$623F, #$653E, #$65B9,
      #$65C1, #$6609, #$678B, #$699C, #$6EC2, #$78C5, #$7D21, #$80AA,
      #$8180, #$822B, #$82B3, #$84A1, #$868C, #$8A2A, #$8B17, #$90A6,
      #$9632, #$9F90, #$500D, #$4FF3, #$F963, #$57F9, #$5F98, #$62DC,
      #$6392, #$676F, #$6E43, #$7119, #$76C3, #$80CC, #$80DA, #$88F4,
      #$88F5, #$8919, #$8CE0, #$8F29, #$914D, #$966A, #$4F2F, #$4F70,
      #$5E1B, #$67CF, #$6822, #$767D, #$767E, #$9B44, #$5E61, #$6A0A,
      #$7169, #$71D4, #$756A, #$F964, #$7E41, #$8543, #$85E9, #$98DC,
      #$4F10, #$7B4F, #$7F70, #$95A5, #$51E1, #$5E06, #$68B5, #$6C3E,
      #$6C4E, #$6CDB, #$72AF, #$7BC4, #$8303, #$6CD5, #$743A, #$50FB,
      #$5288, #$58C1, #$64D8, #$6A97, #$74A7, #$7656,
      #$78A7, #$8617, #$95E2, #$9739, #$F965, #$535E, #$5F01, #$8B8A,
      #$8FA8, #$8FAF, #$908A, #$5225, #$77A5, #$9C49, #$9F08, #$4E19,
      #$5002, #$5175, #$5C5B, #$5E77, #$661E, #$663A, #$67C4, #$68C5,
      #$70B3, #$7501, #$75C5, #$79C9, #$7ADD, #$8F27, #$9920, #$9A08,
      #$4FDD, #$5821, #$5831, #$5BF6, #$666E, #$6B65, #$6D11, #$6E7A,
      #$6F7D, #$73E4, #$752B, #$83E9, #$88DC, #$8913, #$8B5C, #$8F14,
      #$4F0F, #$50D5, #$5310, #$535C, #$5B93, #$5FA9, #$670D, #$798F,
      #$8179, #$832F, #$8514, #$8907, #$8986, #$8F39, #$8F3B, #$99A5,
      #$9C12, #$672C, #$4E76, #$4FF8, #$5949, #$5C01, #$5CEF, #$5CF0,
      #$6367, #$68D2, #$70FD, #$71A2, #$742B, #$7E2B, #$84EC, #$8702,
      #$9022, #$92D2, #$9CF3, #$4E0D, #$4ED8, #$4FEF, #$5085, #$5256,
      #$526F, #$5426, #$5490, #$57E0, #$592B, #$5A66,
      #$5B5A, #$5B75, #$5BCC, #$5E9C, #$F966, #$6276, #$6577, #$65A7,
      #$6D6E, #$6EA5, #$7236, #$7B26, #$7C3F, #$7F36, #$8150, #$8151,
      #$819A, #$8240, #$8299, #$83A9, #$8A03, #$8CA0, #$8CE6, #$8CFB,
      #$8D74, #$8DBA, #$90E8, #$91DC, #$961C, #$9644, #$99D9, #$9CE7,
      #$5317, #$5206, #$5429, #$5674, #$58B3, #$5954, #$596E, #$5FFF,
      #$61A4, #$626E, #$6610, #$6C7E, #$711A, #$76C6, #$7C89, #$7CDE,
      #$7D1B, #$82AC, #$8CC1, #$96F0, #$F967, #$4F5B, #$5F17, #$5F7F,
      #$62C2, #$5D29, #$670B, #$68DA, #$787C, #$7E43, #$9D6C, #$4E15,
      #$5099, #$5315, #$532A, #$5351, #$5983, #$5A62, #$5E87, #$60B2,
      #$618A, #$6249, #$6279, #$6590, #$6787, #$69A7, #$6BD4, #$6BD6,
      #$6BD7, #$6BD8, #$6CB8, #$F968, #$7435, #$75FA, #$7812, #$7891,
      #$79D5, #$79D8, #$7C83, #$7DCB, #$7FE1, #$80A5,
      #$813E, #$81C2, #$83F2, #$871A, #$88E8, #$8AB9, #$8B6C, #$8CBB,
      #$9119, #$975E, #$98DB, #$9F3B, #$56AC, #$5B2A, #$5F6C, #$658C,
      #$6AB3, #$6BAF, #$6D5C, #$6FF1, #$7015, #$725D, #$73AD, #$8CA7,
      #$8CD3, #$983B, #$6191, #$6C37, #$8058, #$9A01, #$4E4D, #$4E8B,
      #$4E9B, #$4ED5, #$4F3A, #$4F3C, #$4F7F, #$4FDF, #$50FF, #$53F2,
      #$53F8, #$5506, #$55E3, #$56DB, #$58EB, #$5962, #$5A11, #$5BEB,
      #$5BFA, #$5C04, #$5DF3, #$5E2B, #$5F99, #$601D, #$6368, #$659C,
      #$65AF, #$67F6, #$67FB, #$68AD, #$6B7B, #$6C99, #$6CD7, #$6E23,
      #$7009, #$7345, #$7802, #$793E, #$7940, #$7960, #$79C1, #$7BE9,
      #$7D17, #$7D72, #$8086, #$820D, #$838E, #$84D1, #$86C7, #$88DF,
      #$8A50, #$8A5E, #$8B1D, #$8CDC, #$8D66, #$8FAD, #$90AA, #$98FC,
      #$99DF, #$9E9D, #$524A, #$F969, #$6714, #$F96A,
      #$5098, #$522A, #$5C71, #$6563, #$6C55, #$73CA, #$7523, #$759D,
      #$7B97, #$849C, #$9178, #$9730, #$4E77, #$6492, #$6BBA, #$715E,
      #$85A9, #$4E09, #$F96B, #$6749, #$68EE, #$6E17, #$829F, #$8518,
      #$886B, #$63F7, #$6F81, #$9212, #$98AF, #$4E0A, #$50B7, #$50CF,
      #$511F, #$5546, #$55AA, #$5617, #$5B40, #$5C19, #$5CE0, #$5E38,
      #$5E8A, #$5EA0, #$5EC2, #$60F3, #$6851, #$6A61, #$6E58, #$723D,
      #$7240, #$72C0, #$76F8, #$7965, #$7BB1, #$7FD4, #$88F3, #$89F4,
      #$8A73, #$8C61, #$8CDE, #$971C, #$585E, #$74BD, #$8CFD, #$55C7,
      #$F96C, #$7A61, #$7D22, #$8272, #$7272, #$751F, #$7525, #$F96D,
      #$7B19, #$5885, #$58FB, #$5DBC, #$5E8F, #$5EB6, #$5F90, #$6055,
      #$6292, #$637F, #$654D, #$6691, #$66D9, #$66F8, #$6816, #$68F2,
      #$7280, #$745E, #$7B6E, #$7D6E, #$7DD6, #$7F72,
      #$80E5, #$8212, #$85AF, #$897F, #$8A93, #$901D, #$92E4, #$9ECD,
      #$9F20, #$5915, #$596D, #$5E2D, #$60DC, #$6614, #$6673, #$6790,
      #$6C50, #$6DC5, #$6F5F, #$77F3, #$78A9, #$84C6, #$91CB, #$932B,
      #$4ED9, #$50CA, #$5148, #$5584, #$5B0B, #$5BA3, #$6247, #$657E,
      #$65CB, #$6E32, #$717D, #$7401, #$7444, #$7487, #$74BF, #$766C,
      #$79AA, #$7DDA, #$7E55, #$7FA8, #$817A, #$81B3, #$8239, #$861A,
      #$87EC, #$8A75, #$8DE3, #$9078, #$9291, #$9425, #$994D, #$9BAE,
      #$5368, #$5C51, #$6954, #$6CC4, #$6D29, #$6E2B, #$820C, #$859B,
      #$893B, #$8A2D, #$8AAA, #$96EA, #$9F67, #$5261, #$66B9, #$6BB2,
      #$7E96, #$87FE, #$8D0D, #$9583, #$965D, #$651D, #$6D89, #$71EE,
      #$F96E, #$57CE, #$59D3, #$5BAC, #$6027, #$60FA, #$6210, #$661F,
      #$665F, #$7329, #$73F9, #$76DB, #$7701, #$7B6C,
      #$8056, #$8072, #$8165, #$8AA0, #$9192, #$4E16, #$52E2, #$6B72,
      #$6D17, #$7A05, #$7B39, #$7D30, #$F96F, #$8CB0, #$53EC, #$562F,
      #$5851, #$5BB5, #$5C0F, #$5C11, #$5DE2, #$6240, #$6383, #$6414,
      #$662D, #$68B3, #$6CBC, #$6D88, #$6EAF, #$701F, #$70A4, #$71D2,
      #$7526, #$758F, #$758E, #$7619, #$7B11, #$7BE0, #$7C2B, #$7D20,
      #$7D39, #$852C, #$856D, #$8607, #$8A34, #$900D, #$9061, #$90B5,
      #$92B7, #$97F6, #$9A37, #$4FD7, #$5C6C, #$675F, #$6D91, #$7C9F,
      #$7E8C, #$8B16, #$8D16, #$901F, #$5B6B, #$5DFD, #$640D, #$84C0,
      #$905C, #$98E1, #$7387, #$5B8B, #$609A, #$677E, #$6DDE, #$8A1F,
      #$8AA6, #$9001, #$980C, #$5237, #$F970, #$7051, #$788E, #$9396,
      #$8870, #$91D7, #$4FEE, #$53D7, #$55FD, #$56DA, #$5782, #$58FD,
      #$5AC2, #$5B88, #$5CAB, #$5CC0, #$5E25, #$6101,
      #$620D, #$624B, #$6388, #$641C, #$6536, #$6578, #$6A39, #$6B8A,
      #$6C34, #$6D19, #$6F31, #$71E7, #$72E9, #$7378, #$7407, #$74B2,
      #$7626, #$7761, #$79C0, #$7A57, #$7AEA, #$7CB9, #$7D8F, #$7DAC,
      #$7E61, #$7F9E, #$8129, #$8331, #$8490, #$84DA, #$85EA, #$8896,
      #$8AB0, #$8B90, #$8F38, #$9042, #$9083, #$916C, #$9296, #$92B9,
      #$968B, #$96A7, #$96A8, #$96D6, #$9700, #$9808, #$9996, #$9AD3,
      #$9B1A, #$53D4, #$587E, #$5919, #$5B70, #$5BBF, #$6DD1, #$6F5A,
      #$719F, #$7421, #$74B9, #$8085, #$83FD, #$5DE1, #$5F87, #$5FAA,
      #$6042, #$65EC, #$6812, #$696F, #$6A53, #$6B89, #$6D35, #$6DF3,
      #$73E3, #$76FE, #$77AC, #$7B4D, #$7D14, #$8123, #$821C, #$8340,
      #$84F4, #$8563, #$8A62, #$8AC4, #$9187, #$931E, #$9806, #$99B4,
      #$620C, #$8853, #$8FF0, #$9265, #$5D07, #$5D27,
      #$5D69, #$745F, #$819D, #$8768, #$6FD5, #$62FE, #$7FD2, #$8936,
      #$8972, #$4E1E, #$4E58, #$50E7, #$52DD, #$5347, #$627F, #$6607,
      #$7E69, #$8805, #$965E, #$4F8D, #$5319, #$5636, #$59CB, #$5AA4,
      #$5C38, #$5C4E, #$5C4D, #$5E02, #$5F11, #$6043, #$65BD, #$662F,
      #$6642, #$67BE, #$67F4, #$731C, #$77E2, #$793A, #$7FC5, #$8494,
      #$84CD, #$8996, #$8A66, #$8A69, #$8AE1, #$8C55, #$8C7A, #$57F4,
      #$5BD4, #$5F0F, #$606F, #$62ED, #$690D, #$6B96, #$6E5C, #$7184,
      #$7BD2, #$8755, #$8B58, #$8EFE, #$98DF, #$98FE, #$4F38, #$4F81,
      #$4FE1, #$547B, #$5A20, #$5BB8, #$613C, #$65B0, #$6668, #$71FC,
      #$7533, #$795E, #$7D33, #$814E, #$81E3, #$8398, #$85AA, #$85CE,
      #$8703, #$8A0A, #$8EAB, #$8F9B, #$F971, #$8FC5, #$5931, #$5BA4,
      #$5BE6, #$6089, #$5BE9, #$5C0B, #$5FC3, #$6C81,
      #$F972, #$6DF1, #$700B, #$751A, #$82AF, #$8AF6, #$4EC0, #$5341,
      #$F973, #$96D9, #$6C0F, #$4E9E, #$4FC4, #$5152, #$555E, #$5A25,
      #$5CE8, #$6211, #$7259, #$82BD, #$83AA, #$86FE, #$8859, #$8A1D,
      #$963F, #$96C5, #$9913, #$9D09, #$9D5D, #$580A, #$5CB3, #$5DBD,
      #$5E44, #$60E1, #$6115, #$63E1, #$6A02, #$6E25, #$9102, #$9354,
      #$984E, #$9C10, #$9F77, #$5B89, #$5CB8, #$6309, #$664F, #$6848,
      #$773C, #$96C1, #$978D, #$9854, #$9B9F, #$65A1, #$8B01, #$8ECB,
      #$95BC, #$5535, #$5CA9, #$5DD6, #$5EB5, #$6697, #$764C, #$83F4,
      #$95C7, #$58D3, #$62BC, #$72CE, #$9D28, #$4EF0, #$592E, #$600F,
      #$663B, #$6B83, #$79E7, #$9D26, #$5393, #$54C0, #$57C3, #$5D16,
      #$611B, #$66D6, #$6DAF, #$788D, #$827E, #$9698, #$9744, #$5384,
      #$627C, #$6396, #$6DB2, #$7E0A, #$814B, #$984D,
      #$6AFB, #$7F4C, #$9DAF, #$9E1A, #$4E5F, #$503B, #$51B6, #$591C,
      #$60F9, #$63F6, #$6930, #$723A, #$8036, #$F974, #$91CE, #$5F31,
      #$F975, #$F976, #$7D04, #$82E5, #$846F, #$84BB, #$85E5, #$8E8D,
      #$F977, #$4F6F, #$F978, #$F979, #$58E4, #$5B43, #$6059, #$63DA,
      #$6518, #$656D, #$6698, #$F97A, #$694A, #$6A23, #$6D0B, #$7001,
      #$716C, #$75D2, #$760D, #$79B3, #$7A70, #$F97B, #$7F8A, #$F97C,
      #$8944, #$F97D, #$8B93, #$91C0, #$967D, #$F97E, #$990A, #$5704,
      #$5FA1, #$65BC, #$6F01, #$7600, #$79A6, #$8A9E, #$99AD, #$9B5A,
      #$9F6C, #$5104, #$61B6, #$6291, #$6A8D, #$81C6, #$5043, #$5830,
      #$5F66, #$7109, #$8A00, #$8AFA, #$5B7C, #$8616, #$4FFA, #$513C,
      #$56B4, #$5944, #$63A9, #$6DF9, #$5DAA, #$696D, #$5186, #$4E88,
      #$4F59, #$F97F, #$F980, #$F981, #$5982, #$F982,
      #$F983, #$6B5F, #$6C5D, #$F984, #$74B5, #$7916, #$F985, #$8207,
      #$8245, #$8339, #$8F3F, #$8F5D, #$F986, #$9918, #$F987, #$F988,
      #$F989, #$4EA6, #$F98A, #$57DF, #$5F79, #$6613, #$F98B, #$F98C,
      #$75AB, #$7E79, #$8B6F, #$F98D, #$9006, #$9A5B, #$56A5, #$5827,
      #$59F8, #$5A1F, #$5BB4, #$F98E, #$5EF6, #$F98F, #$F990, #$6350,
      #$633B, #$F991, #$693D, #$6C87, #$6CBF, #$6D8E, #$6D93, #$6DF5,
      #$6F14, #$F992, #$70DF, #$7136, #$7159, #$F993, #$71C3, #$71D5,
      #$F994, #$784F, #$786F, #$F995, #$7B75, #$7DE3, #$F996, #$7E2F,
      #$F997, #$884D, #$8EDF, #$F998, #$F999, #$F99A, #$925B, #$F99B,
      #$9CF6, #$F99C, #$F99D, #$F99E, #$6085, #$6D85, #$F99F, #$71B1,
      #$F9A0, #$F9A1, #$95B1, #$53AD, #$F9A2, #$F9A3, #$F9A4, #$67D3,
      #$F9A5, #$708E, #$7130, #$7430, #$8276, #$82D2,
      #$F9A6, #$95BB, #$9AE5, #$9E7D, #$66C4, #$F9A7, #$71C1, #$8449,
      #$F9A8, #$F9A9, #$584B, #$F9AA, #$F9AB, #$5DB8, #$5F71, #$F9AC,
      #$6620, #$668E, #$6979, #$69AE, #$6C38, #$6CF3, #$6E36, #$6F41,
      #$6FDA, #$701B, #$702F, #$7150, #$71DF, #$7370, #$F9AD, #$745B,
      #$F9AE, #$74D4, #$76C8, #$7A4E, #$7E93, #$F9AF, #$F9B0, #$82F1,
      #$8A60, #$8FCE, #$F9B1, #$9348, #$F9B2, #$9719, #$F9B3, #$F9B4,
      #$4E42, #$502A, #$F9B5, #$5208, #$53E1, #$66F3, #$6C6D, #$6FCA,
      #$730A, #$777F, #$7A62, #$82AE, #$85DD, #$8602, #$F9B6, #$88D4,
      #$8A63, #$8B7D, #$8C6B, #$F9B7, #$92B3, #$F9B8, #$9713, #$9810,
      #$4E94, #$4F0D, #$4FC9, #$50B2, #$5348, #$543E, #$5433, #$55DA,
      #$5862, #$58BA, #$5967, #$5A1B, #$5BE4, #$609F, #$F9B9, #$61CA,
      #$6556, #$65FF, #$6664, #$68A7, #$6C5A, #$6FB3,
      #$70CF, #$71AC, #$7352, #$7B7D, #$8708, #$8AA4, #$9C32, #$9F07,
      #$5C4B, #$6C83, #$7344, #$7389, #$923A, #$6EAB, #$7465, #$761F,
      #$7A69, #$7E15, #$860A, #$5140, #$58C5, #$64C1, #$74EE, #$7515,
      #$7670, #$7FC1, #$9095, #$96CD, #$9954, #$6E26, #$74E6, #$7AA9,
      #$7AAA, #$81E5, #$86D9, #$8778, #$8A1B, #$5A49, #$5B8C, #$5B9B,
      #$68A1, #$6900, #$6D63, #$73A9, #$7413, #$742C, #$7897, #$7DE9,
      #$7FEB, #$8118, #$8155, #$839E, #$8C4C, #$962E, #$9811, #$66F0,
      #$5F80, #$65FA, #$6789, #$6C6A, #$738B, #$502D, #$5A03, #$6B6A,
      #$77EE, #$5916, #$5D6C, #$5DCD, #$7325, #$754F, #$F9BA, #$F9BB,
      #$50E5, #$51F9, #$582F, #$592D, #$5996, #$59DA, #$5BE5, #$F9BC,
      #$F9BD, #$5DA2, #$62D7, #$6416, #$6493, #$64FE, #$F9BE, #$66DC,
      #$F9BF, #$6A48, #$F9C0, #$71FF, #$7464, #$F9C1,
      #$7A88, #$7AAF, #$7E47, #$7E5E, #$8000, #$8170, #$F9C2, #$87EF,
      #$8981, #$8B20, #$9059, #$F9C3, #$9080, #$9952, #$617E, #$6B32,
      #$6D74, #$7E1F, #$8925, #$8FB1, #$4FD1, #$50AD, #$5197, #$52C7,
      #$57C7, #$5889, #$5BB9, #$5EB8, #$6142, #$6995, #$6D8C, #$6E67,
      #$6EB6, #$7194, #$7462, #$7528, #$752C, #$8073, #$8338, #$84C9,
      #$8E0A, #$9394, #$93DE, #$F9C4, #$4E8E, #$4F51, #$5076, #$512A,
      #$53C8, #$53CB, #$53F3, #$5B87, #$5BD3, #$5C24, #$611A, #$6182,
      #$65F4, #$725B, #$7397, #$7440, #$76C2, #$7950, #$7991, #$79B9,
      #$7D06, #$7FBD, #$828B, #$85D5, #$865E, #$8FC2, #$9047, #$90F5,
      #$91EA, #$9685, #$96E8, #$96E9, #$52D6, #$5F67, #$65ED, #$6631,
      #$682F, #$715C, #$7A36, #$90C1, #$980A, #$4E91, #$F9C5, #$6A52,
      #$6B9E, #$6F90, #$7189, #$8018, #$82B8, #$8553,
      #$904B, #$9695, #$96F2, #$97FB, #$851A, #$9B31, #$4E90, #$718A,
      #$96C4, #$5143, #$539F, #$54E1, #$5713, #$5712, #$57A3, #$5A9B,
      #$5AC4, #$5BC3, #$6028, #$613F, #$63F4, #$6C85, #$6D39, #$6E72,
      #$6E90, #$7230, #$733F, #$7457, #$82D1, #$8881, #$8F45, #$9060,
      #$F9C6, #$9662, #$9858, #$9D1B, #$6708, #$8D8A, #$925E, #$4F4D,
      #$5049, #$50DE, #$5371, #$570D, #$59D4, #$5A01, #$5C09, #$6170,
      #$6690, #$6E2D, #$7232, #$744B, #$7DEF, #$80C3, #$840E, #$8466,
      #$853F, #$875F, #$885B, #$8918, #$8B02, #$9055, #$97CB, #$9B4F,
      #$4E73, #$4F91, #$5112, #$516A, #$F9C7, #$552F, #$55A9, #$5B7A,
      #$5BA5, #$5E7C, #$5E7D, #$5EBE, #$60A0, #$60DF, #$6108, #$6109,
      #$63C4, #$6538, #$6709, #$F9C8, #$67D4, #$67DA, #$F9C9, #$6961,
      #$6962, #$6CB9, #$6D27, #$F9CA, #$6E38, #$F9CB,
      #$6FE1, #$7336, #$7337, #$F9CC, #$745C, #$7531, #$F9CD, #$7652,
      #$F9CE, #$F9CF, #$7DAD, #$81FE, #$8438, #$88D5, #$8A98, #$8ADB,
      #$8AED, #$8E30, #$8E42, #$904A, #$903E, #$907A, #$9149, #$91C9,
      #$936E, #$F9D0, #$F9D1, #$5809, #$F9D2, #$6BD3, #$8089, #$80B2,
      #$F9D3, #$F9D4, #$5141, #$596B, #$5C39, #$F9D5, #$F9D6, #$6F64,
      #$73A7, #$80E4, #$8D07, #$F9D7, #$9217, #$958F, #$F9D8, #$F9D9,
      #$F9DA, #$F9DB, #$807F, #$620E, #$701C, #$7D68, #$878D, #$F9DC,
      #$57A0, #$6069, #$6147, #$6BB7, #$8ABE, #$9280, #$96B1, #$4E59,
      #$541F, #$6DEB, #$852D, #$9670, #$97F3, #$98EE, #$63D6, #$6CE3,
      #$9091, #$51DD, #$61C9, #$81BA, #$9DF9, #$4F9D, #$501A, #$5100,
      #$5B9C, #$610F, #$61FF, #$64EC, #$6905, #$6BC5, #$7591, #$77E3,
      #$7FA9, #$8264, #$858F, #$87FB, #$8863, #$8ABC,
      #$8B70, #$91AB, #$4E8C, #$4EE5, #$4F0A, #$F9DD, #$F9DE, #$5937,
      #$59E8, #$F9DF, #$5DF2, #$5F1B, #$5F5B, #$6021, #$F9E0, #$F9E1,
      #$F9E2, #$F9E3, #$723E, #$73E5, #$F9E4, #$7570, #$75CD, #$F9E5,
      #$79FB, #$F9E6, #$800C, #$8033, #$8084, #$82E1, #$8351, #$F9E7,
      #$F9E8, #$8CBD, #$8CB3, #$9087, #$F9E9, #$F9EA, #$98F4, #$990C,
      #$F9EB, #$F9EC, #$7037, #$76CA, #$7FCA, #$7FCC, #$7FFC, #$8B1A,
      #$4EBA, #$4EC1, #$5203, #$5370, #$F9ED, #$54BD, #$56E0, #$59FB,
      #$5BC5, #$5F15, #$5FCD, #$6E6E, #$F9EE, #$F9EF, #$7D6A, #$8335,
      #$F9F0, #$8693, #$8A8D, #$F9F1, #$976D, #$9777, #$F9F2, #$F9F3,
      #$4E00, #$4F5A, #$4F7E, #$58F9, #$65E5, #$6EA2, #$9038, #$93B0,
      #$99B9, #$4EFB, #$58EC, #$598A, #$59D9, #$6041, #$F9F4, #$F9F5,
      #$7A14, #$F9F6, #$834F, #$8CC3, #$5165, #$5344,
      #$F9F7, #$F9F8, #$F9F9, #$4ECD, #$5269, #$5B55, #$82BF, #$4ED4,
      #$523A, #$54A8, #$59C9, #$59FF, #$5B50, #$5B57, #$5B5C, #$6063,
      #$6148, #$6ECB, #$7099, #$716E, #$7386, #$74F7, #$75B5, #$78C1,
      #$7D2B, #$8005, #$81EA, #$8328, #$8517, #$85C9, #$8AEE, #$8CC7,
      #$96CC, #$4F5C, #$52FA, #$56BC, #$65AB, #$6628, #$707C, #$70B8,
      #$7235, #$7DBD, #$828D, #$914C, #$96C0, #$9D72, #$5B71, #$68E7,
      #$6B98, #$6F7A, #$76DE, #$5C91, #$66AB, #$6F5B, #$7BB4, #$7C2A,
      #$8836, #$96DC, #$4E08, #$4ED7, #$5320, #$5834, #$58BB, #$58EF,
      #$596C, #$5C07, #$5E33, #$5E84, #$5F35, #$638C, #$66B2, #$6756,
      #$6A1F, #$6AA3, #$6B0C, #$6F3F, #$7246, #$F9FA, #$7350, #$748B,
      #$7AE0, #$7CA7, #$8178, #$81DF, #$81E7, #$838A, #$846C, #$8523,
      #$8594, #$85CF, #$88DD, #$8D13, #$91AC, #$9577,
      #$969C, #$518D, #$54C9, #$5728, #$5BB0, #$624D, #$6750, #$683D,
      #$6893, #$6E3D, #$6ED3, #$707D, #$7E21, #$88C1, #$8CA1, #$8F09,
      #$9F4B, #$9F4E, #$722D, #$7B8F, #$8ACD, #$931A, #$4F47, #$4F4E,
      #$5132, #$5480, #$59D0, #$5E95, #$62B5, #$6775, #$696E, #$6A17,
      #$6CAE, #$6E1A, #$72D9, #$732A, #$75BD, #$7BB8, #$7D35, #$82E7,
      #$83F9, #$8457, #$85F7, #$8A5B, #$8CAF, #$8E87, #$9019, #$90B8,
      #$96CE, #$9F5F, #$52E3, #$540A, #$5AE1, #$5BC2, #$6458, #$6575,
      #$6EF4, #$72C4, #$F9FB, #$7684, #$7A4D, #$7B1B, #$7C4D, #$7E3E,
      #$7FDF, #$837B, #$8B2B, #$8CCA, #$8D64, #$8DE1, #$8E5F, #$8FEA,
      #$8FF9, #$9069, #$93D1, #$4F43, #$4F7A, #$50B3, #$5168, #$5178,
      #$524D, #$526A, #$5861, #$587C, #$5960, #$5C08, #$5C55, #$5EDB,
      #$609B, #$6230, #$6813, #$6BBF, #$6C08, #$6FB1,
      #$714E, #$7420, #$7530, #$7538, #$7551, #$7672, #$7B4C, #$7B8B,
      #$7BAD, #$7BC6, #$7E8F, #$8A6E, #$8F3E, #$8F49, #$923F, #$9293,
      #$9322, #$942B, #$96FB, #$985A, #$986B, #$991E, #$5207, #$622A,
      #$6298, #$6D59, #$7664, #$7ACA, #$7BC0, #$7D76, #$5360, #$5CBE,
      #$5E97, #$6F38, #$70B9, #$7C98, #$9711, #$9B8E, #$9EDE, #$63A5,
      #$647A, #$8776, #$4E01, #$4E95, #$4EAD, #$505C, #$5075, #$5448,
      #$59C3, #$5B9A, #$5E40, #$5EAD, #$5EF7, #$5F81, #$60C5, #$633A,
      #$653F, #$6574, #$65CC, #$6676, #$6678, #$67FE, #$6968, #$6A89,
      #$6B63, #$6C40, #$6DC0, #$6DE8, #$6E1F, #$6E5E, #$701E, #$70A1,
      #$738E, #$73FD, #$753A, #$775B, #$7887, #$798E, #$7A0B, #$7A7D,
      #$7CBE, #$7D8E, #$8247, #$8A02, #$8AEA, #$8C9E, #$912D, #$914A,
      #$91D8, #$9266, #$92CC, #$9320, #$9706, #$9756,
      #$975C, #$9802, #$9F0E, #$5236, #$5291, #$557C, #$5824, #$5E1D,
      #$5F1F, #$608C, #$63D0, #$68AF, #$6FDF, #$796D, #$7B2C, #$81CD,
      #$85BA, #$88FD, #$8AF8, #$8E44, #$918D, #$9664, #$969B, #$973D,
      #$984C, #$9F4A, #$4FCE, #$5146, #$51CB, #$52A9, #$5632, #$5F14,
      #$5F6B, #$63AA, #$64CD, #$65E9, #$6641, #$66FA, #$66F9, #$671D,
      #$689D, #$68D7, #$69FD, #$6F15, #$6F6E, #$7167, #$71E5, #$722A,
      #$74AA, #$773A, #$7956, #$795A, #$79DF, #$7A20, #$7A95, #$7C97,
      #$7CDF, #$7D44, #$7E70, #$8087, #$85FB, #$86A4, #$8A54, #$8ABF,
      #$8D99, #$8E81, #$9020, #$906D, #$91E3, #$963B, #$96D5, #$9CE5,
      #$65CF, #$7C07, #$8DB3, #$93C3, #$5B58, #$5C0A, #$5352, #$62D9,
      #$731D, #$5027, #$5B97, #$5F9E, #$60B0, #$616B, #$68D5, #$6DD9,
      #$742E, #$7A2E, #$7D42, #$7D9C, #$7E31, #$816B,
      #$8E2A, #$8E35, #$937E, #$9418, #$4F50, #$5750, #$5DE6, #$5EA7,
      #$632B, #$7F6A, #$4E3B, #$4F4F, #$4F8F, #$505A, #$59DD, #$80C4,
      #$546A, #$5468, #$55FE, #$594F, #$5B99, #$5DDE, #$5EDA, #$665D,
      #$6731, #$67F1, #$682A, #$6CE8, #$6D32, #$6E4A, #$6F8D, #$70B7,
      #$73E0, #$7587, #$7C4C, #$7D02, #$7D2C, #$7DA2, #$821F, #$86DB,
      #$8A3B, #$8A85, #$8D70, #$8E8A, #$8F33, #$9031, #$914E, #$9152,
      #$9444, #$99D0, #$7AF9, #$7CA5, #$4FCA, #$5101, #$51C6, #$57C8,
      #$5BEF, #$5CFB, #$6659, #$6A3D, #$6D5A, #$6E96, #$6FEC, #$710C,
      #$756F, #$7AE3, #$8822, #$9021, #$9075, #$96CB, #$99FF, #$8301,
      #$4E2D, #$4EF2, #$8846, #$91CD, #$537D, #$6ADB, #$696B, #$6C41,
      #$847A, #$589E, #$618E, #$66FE, #$62EF, #$70DD, #$7511, #$75C7,
      #$7E52, #$84B8, #$8B49, #$8D08, #$4E4B, #$53EA,
      #$54AB, #$5730, #$5740, #$5FD7, #$6301, #$6307, #$646F, #$652F,
      #$65E8, #$667A, #$679D, #$67B3, #$6B62, #$6C60, #$6C9A, #$6F2C,
      #$77E5, #$7825, #$7949, #$7957, #$7D19, #$80A2, #$8102, #$81F3,
      #$829D, #$82B7, #$8718, #$8A8C, #$F9FC, #$8D04, #$8DBE, #$9072,
      #$76F4, #$7A19, #$7A37, #$7E54, #$8077, #$5507, #$55D4, #$5875,
      #$632F, #$6422, #$6649, #$664B, #$686D, #$699B, #$6B84, #$6D25,
      #$6EB1, #$73CD, #$7468, #$74A1, #$755B, #$75B9, #$76E1, #$771E,
      #$778B, #$79E6, #$7E09, #$7E1D, #$81FB, #$852F, #$8897, #$8A3A,
      #$8CD1, #$8EEB, #$8FB0, #$9032, #$93AD, #$9663, #$9673, #$9707,
      #$4F84, #$53F1, #$59EA, #$5AC9, #$5E19, #$684E, #$74C6, #$75BE,
      #$79E9, #$7A92, #$81A3, #$86ED, #$8CEA, #$8DCC, #$8FED, #$659F,
      #$6715, #$F9FD, #$57F7, #$6F57, #$7DDD, #$8F2F,
      #$93F6, #$96C6, #$5FB5, #$61F2, #$6F84, #$4E14, #$4F98, #$501F,
      #$53C9, #$55DF, #$5D6F, #$5DEE, #$6B21, #$6B64, #$78CB, #$7B9A,
      #$F9FE, #$8E49, #$8ECA, #$906E, #$6349, #$643E, #$7740, #$7A84,
      #$932F, #$947F, #$9F6A, #$64B0, #$6FAF, #$71E6, #$74A8, #$74DA,
      #$7AC4, #$7C12, #$7E82, #$7CB2, #$7E98, #$8B9A, #$8D0A, #$947D,
      #$9910, #$994C, #$5239, #$5BDF, #$64E6, #$672D, #$7D2E, #$50ED,
      #$53C3, #$5879, #$6158, #$6159, #$61FA, #$65AC, #$7AD9, #$8B92,
      #$8B96, #$5009, #$5021, #$5275, #$5531, #$5A3C, #$5EE0, #$5F70,
      #$6134, #$655E, #$660C, #$6636, #$66A2, #$69CD, #$6EC4, #$6F32,
      #$7316, #$7621, #$7A93, #$8139, #$8259, #$83D6, #$84BC, #$50B5,
      #$57F0, #$5BC0, #$5BE8, #$5F69, #$63A1, #$7826, #$7DB5, #$83DC,
      #$8521, #$91C7, #$91F5, #$518A, #$67F5, #$7B56,
      #$8CAC, #$51C4, #$59BB, #$60BD, #$8655, #$501C, #$F9FF, #$5254,
      #$5C3A, #$617D, #$621A, #$62D3, #$64F2, #$65A5, #$6ECC, #$7620,
      #$810A, #$8E60, #$965F, #$96BB, #$4EDF, #$5343, #$5598, #$5929,
      #$5DDD, #$64C5, #$6CC9, #$6DFA, #$7394, #$7A7F, #$821B, #$85A6,
      #$8CE4, #$8E10, #$9077, #$91E7, #$95E1, #$9621, #$97C6, #$51F8,
      #$54F2, #$5586, #$5FB9, #$64A4, #$6F88, #$7DB4, #$8F1F, #$8F4D,
      #$9435, #$50C9, #$5C16, #$6CBE, #$6DFB, #$751B, #$77BB, #$7C3D,
      #$7C64, #$8A79, #$8AC2, #$581E, #$59BE, #$5E16, #$6377, #$7252,
      #$758A, #$776B, #$8ADC, #$8CBC, #$8F12, #$5EF3, #$6674, #$6DF8,
      #$807D, #$83C1, #$8ACB, #$9751, #$9BD6, #$FA00, #$5243, #$66FF,
      #$6D95, #$6EEF, #$7DE0, #$8AE6, #$902E, #$905E, #$9AD4, #$521D,
      #$527F, #$54E8, #$6194, #$6284, #$62DB, #$68A2,
      #$6912, #$695A, #$6A35, #$7092, #$7126, #$785D, #$7901, #$790E,
      #$79D2, #$7A0D, #$8096, #$8278, #$82D5, #$8349, #$8549, #$8C82,
      #$8D85, #$9162, #$918B, #$91AE, #$4FC3, #$56D1, #$71ED, #$77D7,
      #$8700, #$89F8, #$5BF8, #$5FD6, #$6751, #$90A8, #$53E2, #$585A,
      #$5BF5, #$60A4, #$6181, #$6460, #$7E3D, #$8070, #$8525, #$9283,
      #$64AE, #$50AC, #$5D14, #$6700, #$589C, #$62BD, #$63A8, #$690E,
      #$6978, #$6A1E, #$6E6B, #$76BA, #$79CB, #$82BB, #$8429, #$8ACF,
      #$8DA8, #$8FFD, #$9112, #$914B, #$919C, #$9310, #$9318, #$939A,
      #$96DB, #$9A36, #$9C0D, #$4E11, #$755C, #$795D, #$7AFA, #$7B51,
      #$7BC9, #$7E2E, #$84C4, #$8E59, #$8E74, #$8EF8, #$9010, #$6625,
      #$693F, #$7443, #$51FA, #$672E, #$9EDC, #$5145, #$5FE0, #$6C96,
      #$87F2, #$885D, #$8877, #$60B4, #$81B5, #$8403,
      #$8D05, #$53D6, #$5439, #$5634, #$5A36, #$5C31, #$708A, #$7FE0,
      #$805A, #$8106, #$81ED, #$8DA3, #$9189, #$9A5F, #$9DF2, #$5074,
      #$4EC4, #$53A0, #$60FB, #$6E2C, #$5C64, #$4F88, #$5024, #$55E4,
      #$5CD9, #$5E5F, #$6065, #$6894, #$6CBB, #$6DC4, #$71BE, #$75D4,
      #$75F4, #$7661, #$7A1A, #$7A49, #$7DC7, #$7DFB, #$7F6E, #$81F4,
      #$86A9, #$8F1C, #$96C9, #$99B3, #$9F52, #$5247, #$52C5, #$98ED,
      #$89AA, #$4E03, #$67D2, #$6F06, #$4FB5, #$5BE2, #$6795, #$6C88,
      #$6D78, #$741B, #$7827, #$91DD, #$937C, #$87C4, #$79E4, #$7A31,
      #$5FEB, #$4ED6, #$54A4, #$553E, #$58AE, #$59A5, #$60F0, #$6253,
      #$62D6, #$6736, #$6955, #$8235, #$9640, #$99B1, #$99DD, #$502C,
      #$5353, #$5544, #$577C, #$FA01, #$6258, #$FA02, #$64E2, #$666B,
      #$67DD, #$6FC1, #$6FEF, #$7422, #$7438, #$8A17,
      #$9438, #$5451, #$5606, #$5766, #$5F48, #$619A, #$6B4E, #$7058,
      #$70AD, #$7DBB, #$8A95, #$596A, #$812B, #$63A2, #$7708, #$803D,
      #$8CAA, #$5854, #$642D, #$69BB, #$5B95, #$5E11, #$6E6F, #$FA03,
      #$8569, #$514C, #$53F0, #$592A, #$6020, #$614B, #$6B86, #$6C70,
      #$6CF0, #$7B1E, #$80CE, #$82D4, #$8DC6, #$90B0, #$98B1, #$FA04,
      #$64C7, #$6FA4, #$6491, #$6504, #$514E, #$5410, #$571F, #$8A0E,
      #$615F, #$6876, #$FA05, #$75DB, #$7B52, #$7D71, #$901A, #$5806,
      #$69CC, #$817F, #$892A, #$9000, #$9839, #$5078, #$5957, #$59AC,
      #$6295, #$900F, #$9B2A, #$615D, #$7279, #$95D6, #$5761, #$5A46,
      #$5DF4, #$628A, #$64AD, #$64FA, #$6777, #$6CE2, #$6D3E, #$722C,
      #$7436, #$7834, #$7F77, #$82AD, #$8DDB, #$9817, #$5224, #$5742,
      #$677F, #$7248, #$74E3, #$8CA9, #$8FA6, #$9211,
      #$962A, #$516B, #$53ED, #$634C, #$4F69, #$5504, #$6096, #$6557,
      #$6C9B, #$6D7F, #$724C, #$72FD, #$7A17, #$8987, #$8C9D, #$5F6D,
      #$6F8E, #$70F9, #$81A8, #$610E, #$4FBF, #$504F, #$6241, #$7247,
      #$7BC7, #$7DE8, #$7FE9, #$904D, #$97AD, #$9A19, #$8CB6, #$576A,
      #$5E73, #$67B0, #$840D, #$8A55, #$5420, #$5B16, #$5E63, #$5EE2,
      #$5F0A, #$6583, #$80BA, #$853D, #$9589, #$965B, #$4F48, #$5305,
      #$530D, #$530F, #$5486, #$54FA, #$5703, #$5E03, #$6016, #$629B,
      #$62B1, #$6355, #$FA06, #$6CE1, #$6D66, #$75B1, #$7832, #$80DE,
      #$812F, #$82DE, #$8461, #$84B2, #$888D, #$8912, #$900B, #$92EA,
      #$98FD, #$9B91, #$5E45, #$66B4, #$66DD, #$7011, #$7206, #$FA07,
      #$4FF5, #$527D, #$5F6A, #$6153, #$6753, #$6A19, #$6F02, #$74E2,
      #$7968, #$8868, #$8C79, #$98C7, #$98C4, #$9A43,
      #$54C1, #$7A1F, #$6953, #$8AF7, #$8C4A, #$98A8, #$99AE, #$5F7C,
      #$62AB, #$75B2, #$76AE, #$88AB, #$907F, #$9642, #$5339, #$5F3C,
      #$5FC5, #$6CCC, #$73CC, #$7562, #$758B, #$7B46, #$82FE, #$999D,
      #$4E4F, #$903C, #$4E0B, #$4F55, #$53A6, #$590F, #$5EC8, #$6630,
      #$6CB3, #$7455, #$8377, #$8766, #$8CC0, #$9050, #$971E, #$9C15,
      #$58D1, #$5B78, #$8650, #$8B14, #$9DB4, #$5BD2, #$6068, #$608D,
      #$65F1, #$6C57, #$6F22, #$6FA3, #$701A, #$7F55, #$7FF0, #$9591,
      #$9592, #$9650, #$97D3, #$5272, #$8F44, #$51FD, #$542B, #$54B8,
      #$5563, #$558A, #$6ABB, #$6DB5, #$7DD8, #$8266, #$929C, #$9677,
      #$9E79, #$5408, #$54C8, #$76D2, #$86E4, #$95A4, #$95D4, #$965C,
      #$4EA2, #$4F09, #$59EE, #$5AE6, #$5DF7, #$6052, #$6297, #$676D,
      #$6841, #$6C86, #$6E2F, #$7F38, #$809B, #$822A,
      #$FA08, #$FA09, #$9805, #$4EA5, #$5055, #$54B3, #$5793, #$595A,
      #$5B69, #$5BB3, #$61C8, #$6977, #$6D77, #$7023, #$87F9, #$89E3,
      #$8A72, #$8AE7, #$9082, #$99ED, #$9AB8, #$52BE, #$6838, #$5016,
      #$5E78, #$674F, #$8347, #$884C, #$4EAB, #$5411, #$56AE, #$73E6,
      #$9115, #$97FF, #$9909, #$9957, #$9999, #$5653, #$589F, #$865B,
      #$8A31, #$61B2, #$6AF6, #$737B, #$8ED2, #$6B47, #$96AA, #$9A57,
      #$5955, #$7200, #$8D6B, #$9769, #$4FD4, #$5CF4, #$5F26, #$61F8,
      #$665B, #$6CEB, #$70AB, #$7384, #$73B9, #$73FE, #$7729, #$774D,
      #$7D43, #$7D62, #$7E23, #$8237, #$8852, #$FA0A, #$8CE2, #$9249,
      #$986F, #$5B51, #$7A74, #$8840, #$9801, #$5ACC, #$4FE0, #$5354,
      #$593E, #$5CFD, #$633E, #$6D79, #$72F9, #$8105, #$8107, #$83A2,
      #$92CF, #$9830, #$4EA8, #$5144, #$5211, #$578B,
      #$5F62, #$6CC2, #$6ECE, #$7005, #$7050, #$70AF, #$7192, #$73E9,
      #$7469, #$834A, #$87A2, #$8861, #$9008, #$90A2, #$93A3, #$99A8,
      #$516E, #$5F57, #$60E0, #$6167, #$66B3, #$8559, #$8E4A, #$91AF,
      #$978B, #$4E4E, #$4E92, #$547C, #$58D5, #$58FA, #$597D, #$5CB5,
      #$5F27, #$6236, #$6248, #$660A, #$6667, #$6BEB, #$6D69, #$6DCF,
      #$6E56, #$6EF8, #$6F94, #$6FE0, #$6FE9, #$705D, #$72D0, #$7425,
      #$745A, #$74E0, #$7693, #$795C, #$7CCA, #$7E1E, #$80E1, #$82A6,
      #$846B, #$84BF, #$864E, #$865F, #$8774, #$8B77, #$8C6A, #$93AC,
      #$9800, #$9865, #$60D1, #$6216, #$9177, #$5A5A, #$660F, #$6DF7,
      #$6E3E, #$743F, #$9B42, #$5FFD, #$60DA, #$7B0F, #$54C4, #$5F18,
      #$6C5E, #$6CD3, #$6D2A, #$70D8, #$7D05, #$8679, #$8A0C, #$9D3B,
      #$5316, #$548C, #$5B05, #$6A3A, #$706B, #$7575,
      #$798D, #$79BE, #$82B1, #$83EF, #$8A71, #$8B41, #$8CA8, #$9774,
      #$FA0B, #$64F4, #$652B, #$78BA, #$78BB, #$7A6B, #$4E38, #$559A,
      #$5950, #$5BA6, #$5E7B, #$60A3, #$63DB, #$6B61, #$6665, #$6853,
      #$6E19, #$7165, #$74B0, #$7D08, #$9084, #$9A69, #$9C25, #$6D3B,
      #$6ED1, #$733E, #$8C41, #$95CA, #$51F0, #$5E4C, #$5FA8, #$604D,
      #$60F6, #$6130, #$614C, #$6643, #$6644, #$69A5, #$6CC1, #$6E5F,
      #$6EC9, #$6F62, #$714C, #$749C, #$7687, #$7BC1, #$7C27, #$8352,
      #$8757, #$9051, #$968D, #$9EC3, #$532F, #$56DE, #$5EFB, #$5F8A,
      #$6062, #$6094, #$61F7, #$6666, #$6703, #$6A9C, #$6DEE, #$6FAE,
      #$7070, #$736A, #$7E6A, #$81BE, #$8334, #$86D4, #$8AA8, #$8CC4,
      #$5283, #$7372, #$5B96, #$6A6B, #$9404, #$54EE, #$5686, #$5B5D,
      #$6548, #$6585, #$66C9, #$689F, #$6D8D, #$6DC6,
      #$723B, #$80B4, #$9175, #$9A4D, #$4FAF, #$5019, #$539A, #$540E,
      #$543C, #$5589, #$55C5, #$5E3F, #$5F8C, #$673D, #$7166, #$73DD,
      #$9005, #$52DB, #$52F3, #$5864, #$58CE, #$7104, #$718F, #$71FB,
      #$85B0, #$8A13, #$6688, #$85A8, #$55A7, #$6684, #$714A, #$8431,
      #$5349, #$5599, #$6BC1, #$5F59, #$5FBD, #$63EE, #$6689, #$7147,
      #$8AF1, #$8F1D, #$9EBE, #$4F11, #$643A, #$70CB, #$7566, #$8667,
      #$6064, #$8B4E, #$9DF8, #$5147, #$51F6, #$5308, #$6D36, #$80F8,
      #$9ED1, #$6615, #$6B23, #$7098, #$75D5, #$5403, #$5C79, #$7D07,
      #$8A16, #$6B20, #$6B3D, #$6B46, #$5438, #$6070, #$6D3D, #$7FD5,
      #$8208, #$50D6, #$51DE, #$559C, #$566B, #$56CD, #$59EC, #$5B09,
      #$5E0C, #$6199, #$6198, #$6231, #$665E, #$66E6, #$7199, #$71B9,
      #$71BA, #$72A7, #$79A7, #$7A00, #$7FB2, #$8A70);
  ISO8859_2Map: ThtAnsiCharISOMap = (
      #$00A0, #$0104, #$02D8, #$0141, #$00A4, #$013D, #$015A, #$00A7,
      #$00A8, #$0160, #$015E, #$0164, #$0179, #$00AD, #$017D, #$017B,
      #$00B0, #$0105, #$02DB, #$0142, #$00B4, #$013E, #$015B, #$02C7,
      #$00B8, #$0161, #$015F, #$0165, #$017A, #$02DD, #$017E, #$017C,
      #$0154, #$00C1, #$00C2, #$0102, #$00C4, #$0139, #$0106, #$00C7,
      #$010C, #$00C9, #$0118, #$00CB, #$011A, #$00CD, #$00CE, #$010E,
      #$0110, #$0143, #$0147, #$00D3, #$00D4, #$0150, #$00D6, #$00D7,
      #$0158, #$016E, #$00DA, #$0170, #$00DC, #$00DD, #$0162, #$00DF,
      #$0155, #$00E1, #$00E2, #$0103, #$00E4, #$013A, #$0107, #$00E7,
      #$010D, #$00E9, #$0119, #$00EB, #$011B, #$00ED, #$00EE, #$010F,
      #$0111, #$0144, #$0148, #$00F3, #$00F4, #$0151, #$00F6, #$00F7,
      #$0159, #$016F, #$00FA, #$0171, #$00FC, #$00FD, #$0163, #$02D9);
  ISO8859_3Map: ThtAnsiCharISOMap = (
      #$00A0, #$0126, #$02D8, #$00A3, #$00A4, #$FFFF, #$0124, #$00A7,
      #$00A8, #$0130, #$015E, #$011E, #$0134, #$00AD, #$FFFF, #$017B,
      #$00B0, #$0127, #$00B2, #$00B3, #$00B4, #$00B5, #$0125, #$00B7,
      #$00B8, #$0131, #$015F, #$011F, #$0135, #$00BD, #$FFFF, #$017C,
      #$00C0, #$00C1, #$00C2, #$FFFF, #$00C4, #$010A, #$0108, #$00C7,
      #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$FFFF, #$00D1, #$00D2, #$00D3, #$00D4, #$0120, #$00D6, #$00D7,
      #$011C, #$00D9, #$00DA, #$00DB, #$00DC, #$016C, #$015C, #$00DF,
      #$00E0, #$00E1, #$00E2, #$FFFF, #$00E4, #$010B, #$0109, #$00E7,
      #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$FFFF, #$00F1, #$00F2, #$00F3, #$00F4, #$0121, #$00F6, #$00F7,
      #$011D, #$00F9, #$00FA, #$00FB, #$00FC, #$016D, #$015D, #$02D9);
  ISO8859_4Map: ThtAnsiCharISOMap = (
      #$00A0, #$0104, #$0138, #$0156, #$00A4, #$0128, #$013B, #$00A7,
      #$00A8, #$0160, #$0112, #$0122, #$0166, #$00AD, #$017D, #$00AF,
      #$00B0, #$0105, #$02DB, #$0157, #$00B4, #$0129, #$013C, #$02C7,
      #$00B8, #$0161, #$0113, #$0123, #$0167, #$014A, #$017E, #$014B,
      #$0100, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$012E,
      #$010C, #$00C9, #$0118, #$00CB, #$0116, #$00CD, #$00CE, #$012A,
      #$0110, #$0145, #$014C, #$0136, #$00D4, #$00D5, #$00D6, #$00D7,
      #$00D8, #$0172, #$00DA, #$00DB, #$00DC, #$0168, #$016A, #$00DF,
      #$0101, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$012F,
      #$010D, #$00E9, #$0119, #$00EB, #$0117, #$00ED, #$00EE, #$012B,
      #$0111, #$0146, #$014D, #$0137, #$00F4, #$00F5, #$00F6, #$00F7,
      #$00F8, #$0173, #$00FA, #$00FB, #$00FC, #$0169, #$016B, #$02D9);
  ISO8859_10Map: ThtAnsiCharISOMap = (
      #$00A0, #$0104, #$0112, #$0122, #$012A, #$0128, #$0136, #$00A7,
      #$013B, #$0110, #$0160, #$0166, #$017D, #$00AD, #$016A, #$014A,
      #$00B0, #$0105, #$0113, #$0123, #$012B, #$0129, #$0137, #$00B7,
      #$013C, #$0111, #$0161, #$0167, #$017E, #$2014, #$016B, #$014B,
      #$0100, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$012E,
      #$010C, #$00C9, #$0118, #$00CB, #$0116, #$00CD, #$00CE, #$00CF,
      #$00D0, #$0145, #$014C, #$00D3, #$00D4, #$00D5, #$00D6, #$0168,
      #$00D8, #$0172, #$00DA, #$00DB, #$00DC, #$00DD, #$00DE, #$00DF,
      #$0101, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$012F,
      #$010D, #$00E9, #$0119, #$00EB, #$0117, #$00ED, #$00EE, #$00EF,
      #$00F0, #$0146, #$014D, #$00F3, #$00F4, #$00F5, #$00F6, #$0169,
      #$00F8, #$0173, #$00FA, #$00FB, #$00FC, #$00FD, #$00FE, #$0138);
  ISO8859_13Map: ThtAnsiCharISOMap = (
      #$00A0, #$201D, #$00A2, #$00A3, #$00A4, #$201E, #$00A6, #$00A7,
      #$00D8, #$00A9, #$0156, #$00AB, #$00AC, #$00AD, #$00AE, #$00C6,
      #$00B0, #$00B1, #$00B2, #$00B3, #$201C, #$00B5, #$00B6, #$00B7,
      #$00F8, #$00B9, #$0157, #$00BB, #$00BC, #$00BD, #$00BE, #$00E6,
      #$0104, #$012E, #$0100, #$0106, #$00C4, #$00C5, #$0118, #$0112,
      #$010C, #$00C9, #$0179, #$0116, #$0122, #$0136, #$012A, #$013B,
      #$0160, #$0143, #$0145, #$00D3, #$014C, #$00D5, #$00D6, #$00D7,
      #$0172, #$0141, #$015A, #$016A, #$00DC, #$017B, #$017D, #$00DF,
      #$0105, #$012F, #$0101, #$0107, #$00E4, #$00E5, #$0119, #$0113,
      #$010D, #$00E9, #$017A, #$0117, #$0123, #$0137, #$012B, #$013C,
      #$0161, #$0144, #$0146, #$00F3, #$014D, #$00F5, #$00F6, #$00F7,
      #$0173, #$0142, #$015B, #$016B, #$00FC, #$017B, #$017E, #$2019);
  ISO8859_14Map: ThtAnsiCharISOMap = (
      #$00A0, #$1E02, #$1E03, #$00A3, #$010A, #$010B, #$1E0A, #$00A7,
      #$1E80, #$00A9, #$1E82, #$1E0B, #$1EF2, #$00AD, #$00AE, #$0178,
      #$1E1E, #$1E1F, #$0120, #$0121, #$1E40, #$1E41, #$00B6, #$1E56,
      #$1E81, #$1E57, #$1E83, #$1E60, #$1EF3, #$1E84, #$1E85, #$1E61,
      #$00C0, #$00C1, #$00C2, #$00C3, #$00C4, #$00C5, #$00C6, #$00C7,
      #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$0174, #$00D1, #$00D2, #$00D3, #$00D4, #$00D5, #$00D6, #$1E6A,
      #$00D8, #$00D9, #$00DA, #$00DB, #$00DC, #$00DD, #$0176, #$00DF,
      #$00E0, #$00E1, #$00E2, #$00E3, #$00E4, #$00E5, #$00E6, #$00E7,
      #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$0175, #$00F1, #$00F2, #$00F3, #$00F4, #$00F5, #$00F6, #$1E6B,
      #$00F8, #$00F9, #$00FA, #$00FB, #$00FC, #$00FD, #$0177, #$00FF);
  ISO8859_16Map: ThtAnsiCharISOMap = (
      #$00A0, #$0104, #$0105, #$0141, #$20AC, #$201E, #$0160, #$00A7,
      #$0161, #$00A9, #$0218, #$00AB, #$0179, #$00AD, #$017A, #$017B,
      #$00B0, #$00B1, #$010C, #$0142, #$017D, #$201D, #$00B6, #$00B7,
      #$017E, #$010D, #$0219, #$00BB, #$0152, #$0153, #$0178, #$017C,
      #$00C0, #$00C1, #$00C2, #$0102, #$00C4, #$0106, #$00C6, #$00C7,
      #$00C8, #$00C9, #$00CA, #$00CB, #$00CC, #$00CD, #$00CE, #$00CF,
      #$0110, #$0143, #$00D2, #$00D3, #$00D4, #$0150, #$00D6, #$015A,
      #$0170, #$00D9, #$00DA, #$00DB, #$00DC, #$0118, #$021A, #$00DF,
      #$00E0, #$00E1, #$00E2, #$0103, #$00E4, #$0107, #$00E6, #$00E7,
      #$00E8, #$00E9, #$00EA, #$00EB, #$00EC, #$00ED, #$00EE, #$00EF,
      #$0111, #$0144, #$00F2, #$00F3, #$00F4, #$0151, #$00F6, #$015B,
      #$0171, #$00F9, #$00FA, #$00FB, #$00FC, #$0119, #$021B, #$00FF);
  BIG5_1Map: array[0..6120] of TBuffChar = (
      #$3000, #$FF0C, #$3001, #$3002, #$FF0E, #$2022, #$FF1B, #$FF1A,
      #$FF1F, #$FF01, #$FE30, #$2026, #$2025, #$FE50, #$FF64, #$FE52,
      #$00B7, #$FE54, #$FE55, #$FE56, #$FE57, #$FF5C, #$2013, #$FE31,
      #$2014, #$FE33, #$FFFD, #$FE34, #$FE4F, #$FF08, #$FF09, #$FE35,
      #$FE36, #$FF5B, #$FF5D, #$FE37, #$FE38, #$3014, #$3015, #$FE39,
      #$FE3A, #$3010, #$3011, #$FE3B, #$FE3C, #$300A, #$300B, #$FE3D,
      #$FE3E, #$3008, #$3009, #$FE3F, #$FE40, #$300C, #$300D, #$FE41,
      #$FE42, #$300E, #$300F, #$FE43, #$FE44, #$FE59, #$FE5A, #$FE5B,
      #$FE5C, #$FE5D, #$FE5E, #$2018, #$2019, #$201C, #$201D, #$301D,
      #$301E, #$2035, #$2032, #$FF03, #$FF06, #$FF0A, #$203B, #$00A7,
      #$3003, #$25CB, #$25CF, #$25B3, #$25B2, #$25CE, #$2606, #$2605,
      #$25C7, #$25C6, #$25A1, #$25A0, #$25BD, #$25BC, #$32A3, #$2105,
      #$203E, #$FFFD, #$FF3F, #$FFFD, #$FE49, #$FE4A, #$FE4D, #$FE4E,
      #$FE4B, #$FE4C, #$FE5F, #$FE60, #$FE61, #$FF0B, #$FF0D, #$00D7,
      #$00F7, #$00B1, #$221A, #$FF1C, #$FF1E, #$FF1D, #$2266, #$2267,
      #$2260, #$221E, #$2252, #$2261, #$FE62, #$FE63, #$FE64, #$FE65,
      #$FE66, #$223C, #$2229, #$222A, #$22A5, #$2220, #$221F, #$22BF,
      #$33D2, #$33D1, #$222B, #$222E, #$2235, #$2234, #$2640, #$2642,
      #$2641, #$2609, #$2191, #$2193, #$2190, #$2192, #$2196, #$2197,
      #$2199, #$2198, #$2225, #$2223, #$FFFD,
      #$FFFD, #$FF0F, #$FF3C, #$FF04, #$00A5, #$3012, #$00A2, #$00A3,
      #$FF05, #$FF20, #$2103, #$2109, #$FE69, #$FE6A, #$FE6B, #$33D5,
      #$339C, #$339D, #$339E, #$33CE, #$33A1, #$338E, #$338F, #$33C4,
      #$00B0, #$5159, #$515B, #$515E, #$515D, #$5161, #$5163, #$55E7,
      #$74E9, #$7CCE, #$2581, #$2582, #$2583, #$2584, #$2585, #$2586,
      #$2587, #$2588, #$258F, #$258E, #$258D, #$258C, #$258B, #$258A,
      #$2589, #$253C, #$2534, #$252C, #$2524, #$251C, #$2594, #$2500,
      #$2502, #$2595, #$250C, #$2510, #$2514, #$2518, #$256D, #$256E,
      #$2570, #$256F, #$2550, #$255E, #$256A, #$2561, #$25E2, #$25E3,
      #$25E5, #$25E4, #$2571, #$2572, #$2573, #$FF10, #$FF11, #$FF12,
      #$FF13, #$FF14, #$FF15, #$FF16, #$FF17, #$FF18, #$FF19, #$2160,
      #$2161, #$2162, #$2163, #$2164, #$2165, #$2166, #$2167, #$2168,
      #$2169, #$3021, #$3022, #$3023, #$3024, #$3025, #$3026, #$3027,
      #$3028, #$3029, #$FFFD, #$5344, #$FFFD, #$FF21, #$FF22, #$FF23,
      #$FF24, #$FF25, #$FF26, #$FF27, #$FF28, #$FF29, #$FF2A, #$FF2B,
      #$FF2C, #$FF2D, #$FF2E, #$FF2F, #$FF30, #$FF31, #$FF32, #$FF33,
      #$FF34, #$FF35, #$FF36, #$FF37, #$FF38, #$FF39, #$FF3A, #$FF41,
      #$FF42, #$FF43, #$FF44, #$FF45, #$FF46, #$FF47, #$FF48, #$FF49,
      #$FF4A, #$FF4B, #$FF4C, #$FF4D, #$FF4E, #$FF4F, #$FF50, #$FF51,
      #$FF52, #$FF53, #$FF54, #$FF55, #$FF56,
      #$FF57, #$FF58, #$FF59, #$FF5A, #$0391, #$0392, #$0393, #$0394,
      #$0395, #$0396, #$0397, #$0398, #$0399, #$039A, #$039B, #$039C,
      #$039D, #$039E, #$039F, #$03A0, #$03A1, #$03A3, #$03A4, #$03A5,
      #$03A6, #$03A7, #$03A8, #$03A9, #$03B1, #$03B2, #$03B3, #$03B4,
      #$03B5, #$03B6, #$03B7, #$03B8, #$03B9, #$03BA, #$03BB, #$03BC,
      #$03BD, #$03BE, #$03BF, #$03C0, #$03C1, #$03C3, #$03C4, #$03C5,
      #$03C6, #$03C7, #$03C8, #$03C9, #$3105, #$3106, #$3107, #$3108,
      #$3109, #$310A, #$310B, #$310C, #$310D, #$310E, #$310F, #$3110,
      #$3111, #$3112, #$3113, #$3114, #$3115, #$3116, #$3117, #$3118,
      #$3119, #$311A, #$311B, #$311C, #$311D, #$311E, #$311F, #$3120,
      #$3121, #$3122, #$3123, #$3124, #$3125, #$3126, #$3127, #$3128,
      #$3129, #$02D9, #$02C9, #$02CA, #$02C7, #$02CB, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$4E00, #$4E59, #$4E01, #$4E03, #$4E43, #$4E5D, #$4E86, #$4E8C,
      #$4EBA, #$513F, #$5165, #$516B, #$51E0, #$5200, #$5201, #$529B,
      #$5315, #$5341, #$535C, #$53C8, #$4E09, #$4E0B, #$4E08, #$4E0A,
      #$4E2B, #$4E38, #$51E1, #$4E45, #$4E48, #$4E5F, #$4E5E, #$4E8E,
      #$4EA1, #$5140, #$5203, #$52FA, #$5343, #$53C9, #$53E3, #$571F,
      #$58EB, #$5915, #$5927, #$5973, #$5B50, #$5B51, #$5B53, #$5BF8,
      #$5C0F, #$5C22, #$5C38, #$5C71, #$5DDD, #$5DE5, #$5DF1, #$5DF2,
      #$5DF3, #$5DFE, #$5E72, #$5EFE, #$5F0B, #$5F13, #$624D, #$4E11,
      #$4E10, #$4E0D, #$4E2D, #$4E30, #$4E39, #$4E4B, #$5C39, #$4E88,
      #$4E91, #$4E95, #$4E92, #$4E94, #$4EA2, #$4EC1, #$4EC0, #$4EC3,
      #$4EC6, #$4EC7, #$4ECD, #$4ECA, #$4ECB, #$4EC4, #$5143, #$5141,
      #$5167, #$516D, #$516E, #$516C, #$5197, #$51F6, #$5206, #$5207,
      #$5208, #$52FB, #$52FE, #$52FF, #$5316, #$5339, #$5348, #$5347,
      #$5345, #$535E, #$5384, #$53CB, #$53CA, #$53CD, #$58EC, #$5929,
      #$592B, #$592A, #$592D, #$5B54, #$5C11, #$5C24, #$5C3A, #$5C6F,
      #$5DF4, #$5E7B, #$5EFF, #$5F14, #$5F15, #$5FC3, #$6208, #$6236,
      #$624B, #$624E, #$652F, #$6587, #$6597, #$65A4, #$65B9, #$65E5,
      #$66F0, #$6708, #$6728, #$6B20, #$6B62, #$6B79, #$6BCB, #$6BD4,
      #$6BDB, #$6C0F, #$6C34, #$706B, #$722A, #$7236, #$723B, #$7247,
      #$7259, #$725B, #$72AC, #$738B, #$4E19,
      #$4E16, #$4E15, #$4E14, #$4E18, #$4E3B, #$4E4D, #$4E4F, #$4E4E,
      #$4EE5, #$4ED8, #$4ED4, #$4ED5, #$4ED6, #$4ED7, #$4EE3, #$4EE4,
      #$4ED9, #$4EDE, #$5145, #$5144, #$5189, #$518A, #$51AC, #$51F9,
      #$51FA, #$51F8, #$520A, #$52A0, #$529F, #$5305, #$5306, #$5317,
      #$531D, #$4EDF, #$534A, #$5349, #$5361, #$5360, #$536F, #$536E,
      #$53BB, #$53EF, #$53E4, #$53F3, #$53EC, #$53EE, #$53E9, #$53E8,
      #$53FC, #$53F8, #$53F5, #$53EB, #$53E6, #$53EA, #$53F2, #$53F1,
      #$53F0, #$53E5, #$53ED, #$53FB, #$56DB, #$56DA, #$5916, #$592E,
      #$5931, #$5974, #$5976, #$5B55, #$5B83, #$5C3C, #$5DE8, #$5DE7,
      #$5DE6, #$5E02, #$5E03, #$5E73, #$5E7C, #$5F01, #$5F18, #$5F17,
      #$5FC5, #$620A, #$6253, #$6254, #$6252, #$6251, #$65A5, #$65E6,
      #$672E, #$672C, #$672A, #$672B, #$672D, #$6B63, #$6BCD, #$6C11,
      #$6C10, #$6C38, #$6C41, #$6C40, #$6C3E, #$72AF, #$7384, #$7389,
      #$74DC, #$74E6, #$7518, #$751F, #$7528, #$7529, #$7530, #$7531,
      #$7532, #$7533, #$758B, #$767D, #$76AE, #$76BF, #$76EE, #$77DB,
      #$77E2, #$77F3, #$793A, #$79BE, #$7A74, #$7ACB, #$4E1E, #$4E1F,
      #$4E52, #$4E53, #$4E69, #$4E99, #$4EA4, #$4EA6, #$4EA5, #$4EFF,
      #$4F09, #$4F19, #$4F0A, #$4F15, #$4F0D, #$4F10, #$4F11, #$4F0F,
      #$4EF2, #$4EF6, #$4EFB, #$4EF0, #$4EF3, #$4EFD, #$4F01, #$4F0B,
      #$5149, #$5147, #$5146, #$5148, #$5168,
      #$5171, #$518D, #$51B0, #$5217, #$5211, #$5212, #$520E, #$5216,
      #$52A3, #$5308, #$5321, #$5320, #$5370, #$5371, #$5409, #$540F,
      #$540C, #$540A, #$5410, #$5401, #$540B, #$5404, #$5411, #$540D,
      #$5408, #$5403, #$540E, #$5406, #$5412, #$56E0, #$56DE, #$56DD,
      #$5733, #$5730, #$5728, #$572D, #$572C, #$572F, #$5729, #$5919,
      #$591A, #$5937, #$5938, #$5984, #$5978, #$5983, #$597D, #$5979,
      #$5982, #$5981, #$5B57, #$5B58, #$5B87, #$5B88, #$5B85, #$5B89,
      #$5BFA, #$5C16, #$5C79, #$5DDE, #$5E06, #$5E76, #$5E74, #$5F0F,
      #$5F1B, #$5FD9, #$5FD6, #$620E, #$620C, #$620D, #$6210, #$6263,
      #$625B, #$6258, #$6536, #$65E9, #$65E8, #$65EC, #$65ED, #$66F2,
      #$66F3, #$6709, #$673D, #$6734, #$6731, #$6735, #$6B21, #$6B64,
      #$6B7B, #$6C16, #$6C5D, #$6C57, #$6C59, #$6C5F, #$6C60, #$6C50,
      #$6C55, #$6C61, #$6C5B, #$6C4D, #$6C4E, #$7070, #$725F, #$725D,
      #$767E, #$7AF9, #$7C73, #$7CF8, #$7F36, #$7F8A, #$7FBD, #$8001,
      #$8003, #$800C, #$8012, #$8033, #$807F, #$8089, #$808B, #$808C,
      #$81E3, #$81EA, #$81F3, #$81FC, #$820C, #$821B, #$821F, #$826E,
      #$8272, #$827E, #$866B, #$8840, #$884C, #$8863, #$897F, #$9621,
      #$4E32, #$4EA8, #$4F4D, #$4F4F, #$4F47, #$4F57, #$4F5E, #$4F34,
      #$4F5B, #$4F55, #$4F30, #$4F50, #$4F51, #$4F3D, #$4F3A, #$4F38,
      #$4F43, #$4F54, #$4F3C, #$4F46, #$4F63,
      #$4F5C, #$4F60, #$4F2F, #$4F4E, #$4F36, #$4F59, #$4F5D, #$4F48,
      #$4F5A, #$514C, #$514B, #$514D, #$5175, #$51B6, #$51B7, #$5225,
      #$5224, #$5229, #$522A, #$5228, #$52AB, #$52A9, #$52AA, #$52AC,
      #$5323, #$5373, #$5375, #$541D, #$542D, #$541E, #$543E, #$5426,
      #$544E, #$5427, #$5446, #$5443, #$5433, #$5448, #$5442, #$541B,
      #$5429, #$544A, #$5439, #$543B, #$5438, #$542E, #$5435, #$5436,
      #$5420, #$543C, #$5440, #$5431, #$542B, #$541F, #$542C, #$56EA,
      #$56F0, #$56E4, #$56EB, #$574A, #$5751, #$5740, #$574D, #$5747,
      #$574E, #$573E, #$5750, #$574F, #$573B, #$58EF, #$593E, #$599D,
      #$5992, #$59A8, #$599E, #$59A3, #$5999, #$5996, #$598D, #$59A4,
      #$5993, #$598A, #$59A5, #$5B5D, #$5B5C, #$5B5A, #$5B5B, #$5B8C,
      #$5B8B, #$5B8F, #$5C2C, #$5C40, #$5C41, #$5C3F, #$5C3E, #$5C90,
      #$5C91, #$5C94, #$5C8C, #$5DEB, #$5E0C, #$5E8F, #$5E87, #$5E8A,
      #$5EF7, #$5F04, #$5F1F, #$5F64, #$5F62, #$5F77, #$5F79, #$5FD8,
      #$5FCC, #$5FD7, #$5FCD, #$5FF1, #$5FEB, #$5FF8, #$5FEA, #$6212,
      #$6211, #$6284, #$6297, #$6296, #$6280, #$6276, #$6289, #$626D,
      #$628A, #$627C, #$627E, #$6279, #$6273, #$6292, #$626F, #$6298,
      #$626E, #$6295, #$6293, #$6291, #$6286, #$6539, #$653B, #$6538,
      #$65F1, #$66F4, #$675F, #$674E, #$674F, #$6750, #$6751, #$675C,
      #$6756, #$675E, #$6749, #$6746, #$6760,
      #$6753, #$6757, #$6B65, #$6BCF, #$6C42, #$6C5E, #$6C99, #$6C81,
      #$6C88, #$6C89, #$6C85, #$6C9B, #$6C6A, #$6C7A, #$6C90, #$6C70,
      #$6C8C, #$6C68, #$6C96, #$6C92, #$6C7D, #$6C83, #$6C72, #$6C7E,
      #$6C74, #$6C86, #$6C76, #$6C8D, #$6C94, #$6C98, #$6C82, #$7076,
      #$707C, #$707D, #$7078, #$7262, #$7261, #$7260, #$72C4, #$72C2,
      #$7396, #$752C, #$752B, #$7537, #$7538, #$7682, #$76EF, #$77E3,
      #$79C1, #$79C0, #$79BF, #$7A76, #$7CFB, #$7F55, #$8096, #$8093,
      #$809D, #$8098, #$809B, #$809A, #$80B2, #$826F, #$8292, #$828B,
      #$828D, #$898B, #$89D2, #$8A00, #$8C37, #$8C46, #$8C55, #$8C9D,
      #$8D64, #$8D70, #$8DB3, #$8EAB, #$8ECA, #$8F9B, #$8FB0, #$8FC2,
      #$8FC6, #$8FC5, #$8FC4, #$5DE1, #$9091, #$90A2, #$90AA, #$90A6,
      #$90A3, #$9149, #$91C6, #$91CC, #$9632, #$962E, #$9631, #$962A,
      #$962C, #$4E26, #$4E56, #$4E73, #$4E8B, #$4E9B, #$4E9E, #$4EAB,
      #$4EAC, #$4F6F, #$4F9D, #$4F8D, #$4F73, #$4F7F, #$4F6C, #$4F9B,
      #$4F8B, #$4F86, #$4F83, #$4F70, #$4F75, #$4F88, #$4F69, #$4F7B,
      #$4F96, #$4F7E, #$4F8F, #$4F91, #$4F7A, #$5154, #$5152, #$5155,
      #$5169, #$5177, #$5176, #$5178, #$51BD, #$51FD, #$523B, #$5238,
      #$5237, #$523A, #$5230, #$522E, #$5236, #$5241, #$52BE, #$52BB,
      #$5352, #$5354, #$5353, #$5351, #$5366, #$5377, #$5378, #$5379,
      #$53D6, #$53D4, #$53D7, #$5473, #$5475,
      #$5496, #$5478, #$5495, #$5480, #$547B, #$5477, #$5484, #$5492,
      #$5486, #$547C, #$5490, #$5471, #$5476, #$548C, #$549A, #$5462,
      #$5468, #$548B, #$547D, #$548E, #$56FA, #$5783, #$5777, #$576A,
      #$5769, #$5761, #$5766, #$5764, #$577C, #$591C, #$5949, #$5947,
      #$5948, #$5944, #$5954, #$59BE, #$59BB, #$59D4, #$59B9, #$59AE,
      #$59D1, #$59C6, #$59D0, #$59CD, #$59CB, #$59D3, #$59CA, #$59AF,
      #$59B3, #$59D2, #$59C5, #$5B5F, #$5B64, #$5B63, #$5B97, #$5B9A,
      #$5B98, #$5B9C, #$5B99, #$5B9B, #$5C1A, #$5C48, #$5C45, #$5C46,
      #$5CB7, #$5CA1, #$5CB8, #$5CA9, #$5CAB, #$5CB1, #$5CB3, #$5E18,
      #$5E1A, #$5E16, #$5E15, #$5E1B, #$5E11, #$5E78, #$5E9A, #$5E97,
      #$5E9C, #$5E95, #$5E96, #$5EF6, #$5F26, #$5F27, #$5F29, #$5F80,
      #$5F81, #$5F7F, #$5F7C, #$5FDD, #$5FE0, #$5FFD, #$5FF5, #$5FFF,
      #$600F, #$6014, #$602F, #$6035, #$6016, #$602A, #$6015, #$6021,
      #$6027, #$6029, #$602B, #$601B, #$6216, #$6215, #$623F, #$623E,
      #$6240, #$627F, #$62C9, #$62CC, #$62C4, #$62BF, #$62C2, #$62B9,
      #$62D2, #$62DB, #$62AB, #$62D3, #$62D4, #$62CB, #$62C8, #$62A8,
      #$62BD, #$62BC, #$62D0, #$62D9, #$62C7, #$62CD, #$62B5, #$62DA,
      #$62B1, #$62D8, #$62D6, #$62D7, #$62C6, #$62AC, #$62CE, #$653E,
      #$65A7, #$65BC, #$65FA, #$6614, #$6613, #$660C, #$6606, #$6602,
      #$660E, #$6600, #$660F, #$6615, #$660A,
      #$6607, #$670D, #$670B, #$676D, #$678B, #$6795, #$6771, #$679C,
      #$6773, #$6777, #$6787, #$679D, #$6797, #$676F, #$6770, #$677F,
      #$6789, #$677E, #$6790, #$6775, #$679A, #$6793, #$677C, #$676A,
      #$6772, #$6B23, #$6B66, #$6B67, #$6B7F, #$6C13, #$6C1B, #$6CE3,
      #$6CE8, #$6CF3, #$6CB1, #$6CCC, #$6CE5, #$6CB3, #$6CBD, #$6CBE,
      #$6CBC, #$6CE2, #$6CAB, #$6CD5, #$6CD3, #$6CB8, #$6CC4, #$6CB9,
      #$6CC1, #$6CAE, #$6CD7, #$6CC5, #$6CF1, #$6CBF, #$6CBB, #$6CE1,
      #$6CDB, #$6CCA, #$6CAC, #$6CEF, #$6CDC, #$6CD6, #$6CE0, #$7095,
      #$708E, #$7092, #$708A, #$7099, #$722C, #$722D, #$7238, #$7248,
      #$7267, #$7269, #$72C0, #$72CE, #$72D9, #$72D7, #$72D0, #$73A9,
      #$73A8, #$739F, #$73AB, #$73A5, #$753D, #$759D, #$7599, #$759A,
      #$7684, #$76C2, #$76F2, #$76F4, #$77E5, #$77FD, #$793E, #$7940,
      #$7941, #$79C9, #$79C8, #$7A7A, #$7A79, #$7AFA, #$7CFE, #$7F54,
      #$7F8C, #$7F8B, #$8005, #$80BA, #$80A5, #$80A2, #$80B1, #$80A1,
      #$80AB, #$80A9, #$80B4, #$80AA, #$80AF, #$81E5, #$81FE, #$820D,
      #$82B3, #$829D, #$8299, #$82AD, #$82BD, #$829F, #$82B9, #$82B1,
      #$82AC, #$82A5, #$82AF, #$82B8, #$82A3, #$82B0, #$82BE, #$82B7,
      #$864E, #$8671, #$521D, #$8868, #$8ECB, #$8FCE, #$8FD4, #$8FD1,
      #$90B5, #$90B8, #$90B1, #$90B6, #$91C7, #$91D1, #$9577, #$9580,
      #$961C, #$9640, #$963F, #$963B, #$9644,
      #$9642, #$96B9, #$96E8, #$9752, #$975E, #$4E9F, #$4EAD, #$4EAE,
      #$4FE1, #$4FB5, #$4FAF, #$4FBF, #$4FE0, #$4FD1, #$4FCF, #$4FDD,
      #$4FC3, #$4FB6, #$4FD8, #$4FDF, #$4FCA, #$4FD7, #$4FAE, #$4FD0,
      #$4FC4, #$4FC2, #$4FDA, #$4FCE, #$4FDE, #$4FB7, #$5157, #$5192,
      #$5191, #$51A0, #$524E, #$5243, #$524A, #$524D, #$524C, #$524B,
      #$5247, #$52C7, #$52C9, #$52C3, #$52C1, #$530D, #$5357, #$537B,
      #$539A, #$53DB, #$54AC, #$54C0, #$54A8, #$54CE, #$54C9, #$54B8,
      #$54A6, #$54B3, #$54C7, #$54C2, #$54BD, #$54AA, #$54C1, #$54C4,
      #$54C8, #$54AF, #$54AB, #$54B1, #$54BB, #$54A9, #$54A7, #$54BF,
      #$56FF, #$5782, #$578B, #$57A0, #$57A3, #$57A2, #$57CE, #$57AE,
      #$5793, #$5955, #$5951, #$594F, #$594E, #$5950, #$59DC, #$59D8,
      #$59FF, #$59E3, #$59E8, #$5A03, #$59E5, #$59EA, #$59DA, #$59E6,
      #$5A01, #$59FB, #$5B69, #$5BA3, #$5BA6, #$5BA4, #$5BA2, #$5BA5,
      #$5C01, #$5C4E, #$5C4F, #$5C4D, #$5C4B, #$5CD9, #$5CD2, #$5DF7,
      #$5E1D, #$5E25, #$5E1F, #$5E7D, #$5EA0, #$5EA6, #$5EFA, #$5F08,
      #$5F2D, #$5F65, #$5F88, #$5F85, #$5F8A, #$5F8B, #$5F87, #$5F8C,
      #$5F89, #$6012, #$601D, #$6020, #$6025, #$600E, #$6028, #$604D,
      #$6070, #$6068, #$6062, #$6046, #$6043, #$606C, #$606B, #$606A,
      #$6064, #$6241, #$62DC, #$6316, #$6309, #$62FC, #$62ED, #$6301,
      #$62EE, #$62FD, #$6307, #$62F1, #$62F7,
      #$62EF, #$62EC, #$62FE, #$62F4, #$6311, #$6302, #$653F, #$6545,
      #$65AB, #$65BD, #$65E2, #$6625, #$662D, #$6620, #$6627, #$662F,
      #$661F, #$6628, #$6631, #$6624, #$66F7, #$67FF, #$67D3, #$67F1,
      #$67D4, #$67D0, #$67EC, #$67B6, #$67AF, #$67F5, #$67E9, #$67EF,
      #$67C4, #$67D1, #$67B4, #$67DA, #$67E5, #$67B8, #$67CF, #$67DE,
      #$67F3, #$67B0, #$67D9, #$67E2, #$67DD, #$67D2, #$6B6A, #$6B83,
      #$6B86, #$6BB5, #$6BD2, #$6BD7, #$6C1F, #$6CC9, #$6D0B, #$6D32,
      #$6D2A, #$6D41, #$6D25, #$6D0C, #$6D31, #$6D1E, #$6D17, #$6D3B,
      #$6D3D, #$6D3E, #$6D36, #$6D1B, #$6CF5, #$6D39, #$6D27, #$6D38,
      #$6D29, #$6D2E, #$6D35, #$6D0E, #$6D2B, #$70AB, #$70BA, #$70B3,
      #$70AC, #$70AF, #$70AD, #$70B8, #$70AE, #$70A4, #$7230, #$7272,
      #$726F, #$7274, #$72E9, #$72E0, #$72E1, #$73B7, #$73CA, #$73BB,
      #$73B2, #$73CD, #$73C0, #$73B3, #$751A, #$752D, #$754F, #$754C,
      #$754E, #$754B, #$75AB, #$75A4, #$75A5, #$75A2, #$75A3, #$7678,
      #$7686, #$7687, #$7688, #$76C8, #$76C6, #$76C3, #$76C5, #$7701,
      #$76F9, #$76F8, #$7709, #$770B, #$76FE, #$76FC, #$7707, #$77DC,
      #$7802, #$7814, #$780C, #$780D, #$7946, #$7949, #$7948, #$7947,
      #$79B9, #$79BA, #$79D1, #$79D2, #$79CB, #$7A7F, #$7A81, #$7AFF,
      #$7AFD, #$7C7D, #$7D02, #$7D05, #$7D00, #$7D09, #$7D07, #$7D04,
      #$7D06, #$7F38, #$7F8E, #$7FBF, #$8004,
      #$8010, #$800D, #$8011, #$8036, #$80D6, #$80E5, #$80DA, #$80C3,
      #$80C4, #$80CC, #$80E1, #$80DB, #$80CE, #$80DE, #$80E4, #$80DD,
      #$81F4, #$8222, #$82E7, #$8303, #$8305, #$82E3, #$82DB, #$82E6,
      #$8304, #$82E5, #$8302, #$8309, #$82D2, #$82D7, #$82F1, #$8301,
      #$82DC, #$82D4, #$82D1, #$82DE, #$82D3, #$82DF, #$82EF, #$8306,
      #$8650, #$8679, #$867B, #$867A, #$884D, #$886B, #$8981, #$89D4,
      #$8A08, #$8A02, #$8A03, #$8C9E, #$8CA0, #$8D74, #$8D73, #$8DB4,
      #$8ECD, #$8ECC, #$8FF0, #$8FE6, #$8FE2, #$8FEA, #$8FE5, #$8FED,
      #$8FEB, #$8FE4, #$8FE8, #$90CA, #$90CE, #$90C1, #$90C3, #$914B,
      #$914A, #$91CD, #$9582, #$9650, #$964B, #$964C, #$964D, #$9762,
      #$9769, #$97CB, #$97ED, #$97F3, #$9801, #$98A8, #$98DB, #$98DF,
      #$9996, #$9999, #$4E58, #$4EB3, #$500C, #$500D, #$5023, #$4FEF,
      #$5026, #$5025, #$4FF8, #$5029, #$5016, #$5006, #$503C, #$501F,
      #$501A, #$5012, #$5011, #$4FFA, #$5000, #$5014, #$5028, #$4FF1,
      #$5021, #$500B, #$5019, #$5018, #$4FF3, #$4FEE, #$502D, #$502A,
      #$4FFE, #$502B, #$5009, #$517C, #$51A4, #$51A5, #$51A2, #$51CD,
      #$51CC, #$51C6, #$51CB, #$5256, #$525C, #$5254, #$525B, #$525D,
      #$532A, #$537F, #$539F, #$539D, #$53DF, #$54E8, #$5510, #$5501,
      #$5537, #$54FC, #$54E5, #$54F2, #$5506, #$54FA, #$5514, #$54E9,
      #$54ED, #$54E1, #$5509, #$54EE, #$54EA,
      #$54E6, #$5527, #$5507, #$54FD, #$550F, #$5703, #$5704, #$57C2,
      #$57D4, #$57CB, #$57C3, #$5809, #$590F, #$5957, #$5958, #$595A,
      #$5A11, #$5A18, #$5A1C, #$5A1F, #$5A1B, #$5A13, #$59EC, #$5A20,
      #$5A23, #$5A29, #$5A25, #$5A0C, #$5A09, #$5B6B, #$5C58, #$5BB0,
      #$5BB3, #$5BB6, #$5BB4, #$5BAE, #$5BB5, #$5BB9, #$5BB8, #$5C04,
      #$5C51, #$5C55, #$5C50, #$5CED, #$5CFD, #$5CFB, #$5CEA, #$5CE8,
      #$5CF0, #$5CF6, #$5D01, #$5CF4, #$5DEE, #$5E2D, #$5E2B, #$5EAB,
      #$5EAD, #$5EA7, #$5F31, #$5F92, #$5F91, #$5F90, #$6059, #$6063,
      #$6065, #$6050, #$6055, #$606D, #$6069, #$606F, #$6084, #$609F,
      #$609A, #$608D, #$6094, #$608C, #$6085, #$6096, #$6247, #$62F3,
      #$6308, #$62FF, #$634E, #$633E, #$632F, #$6355, #$6342, #$6346,
      #$634F, #$6349, #$633A, #$6350, #$633D, #$632A, #$632B, #$6328,
      #$634D, #$634C, #$6548, #$6549, #$6599, #$65C1, #$65C5, #$6642,
      #$6649, #$664F, #$6643, #$6652, #$664C, #$6645, #$6641, #$66F8,
      #$6714, #$6715, #$6717, #$6821, #$6838, #$6848, #$6846, #$6853,
      #$6839, #$6842, #$6854, #$6829, #$68B3, #$6817, #$684C, #$6851,
      #$683D, #$67F4, #$6850, #$6840, #$683C, #$6843, #$682A, #$6845,
      #$6813, #$6818, #$6841, #$6B8A, #$6B89, #$6BB7, #$6C23, #$6C27,
      #$6C28, #$6C26, #$6C24, #$6CF0, #$6D6A, #$6D95, #$6D88, #$6D87,
      #$6D66, #$6D78, #$6D77, #$6D59, #$6D93,
      #$6D6C, #$6D89, #$6D6E, #$6D5A, #$6D74, #$6D69, #$6D8C, #$6D8A,
      #$6D79, #$6D85, #$6D65, #$6D94, #$70CA, #$70D8, #$70E4, #$70D9,
      #$70C8, #$70CF, #$7239, #$7279, #$72FC, #$72F9, #$72FD, #$72F8,
      #$72F7, #$7386, #$73ED, #$7409, #$73EE, #$73E0, #$73EA, #$73DE,
      #$7554, #$755D, #$755C, #$755A, #$7559, #$75BE, #$75C5, #$75C7,
      #$75B2, #$75B3, #$75BD, #$75BC, #$75B9, #$75C2, #$75B8, #$768B,
      #$76B0, #$76CA, #$76CD, #$76CE, #$7729, #$771F, #$7720, #$7728,
      #$77E9, #$7830, #$7827, #$7838, #$781D, #$7834, #$7837, #$7825,
      #$782D, #$7820, #$781F, #$7832, #$7955, #$7950, #$7960, #$795F,
      #$7956, #$795E, #$795D, #$7957, #$795A, #$79E4, #$79E3, #$79E7,
      #$79DF, #$79E6, #$79E9, #$79D8, #$7A84, #$7A88, #$7AD9, #$7B06,
      #$7B11, #$7C89, #$7D21, #$7D17, #$7D0B, #$7D0A, #$7D20, #$7D22,
      #$7D14, #$7D10, #$7D15, #$7D1A, #$7D1C, #$7D0D, #$7D19, #$7D1B,
      #$7F3A, #$7F5F, #$7F94, #$7FC5, #$7FC1, #$8006, #$8018, #$8015,
      #$8019, #$8017, #$803D, #$803F, #$80F1, #$8102, #$80F0, #$8105,
      #$80ED, #$80F4, #$8106, #$80F8, #$80F3, #$8108, #$80FD, #$810A,
      #$80FC, #$80EF, #$81ED, #$81EC, #$8200, #$8210, #$822A, #$822B,
      #$8228, #$822C, #$82BB, #$832B, #$8352, #$8354, #$834A, #$8338,
      #$8350, #$8349, #$8335, #$8334, #$834F, #$8332, #$8339, #$8336,
      #$8317, #$8340, #$8331, #$8328, #$8343,
      #$8654, #$868A, #$86AA, #$8693, #$86A4, #$86A9, #$868C, #$86A3,
      #$869C, #$8870, #$8877, #$8881, #$8882, #$887D, #$8879, #$8A18,
      #$8A10, #$8A0E, #$8A0C, #$8A15, #$8A0A, #$8A17, #$8A13, #$8A16,
      #$8A0F, #$8A11, #$8C48, #$8C7A, #$8C79, #$8CA1, #$8CA2, #$8D77,
      #$8EAC, #$8ED2, #$8ED4, #$8ECF, #$8FB1, #$9001, #$9006, #$8FF7,
      #$9000, #$8FFA, #$8FF4, #$9003, #$8FFD, #$9005, #$8FF8, #$9095,
      #$90E1, #$90DD, #$90E2, #$9152, #$914D, #$914C, #$91D8, #$91DD,
      #$91D7, #$91DC, #$91D9, #$9583, #$9662, #$9663, #$9661, #$965B,
      #$965D, #$9664, #$9658, #$965E, #$96BB, #$98E2, #$99AC, #$9AA8,
      #$9AD8, #$9B25, #$9B32, #$9B3C, #$4E7E, #$507A, #$507D, #$505C,
      #$5047, #$5043, #$504C, #$505A, #$5049, #$5065, #$5076, #$504E,
      #$5055, #$5075, #$5074, #$5077, #$504F, #$500F, #$506F, #$506D,
      #$515C, #$5195, #$51F0, #$526A, #$526F, #$52D2, #$52D9, #$52D8,
      #$52D5, #$5310, #$530F, #$5319, #$533F, #$5340, #$533E, #$53C3,
      #$66FC, #$5546, #$556A, #$5566, #$5544, #$555E, #$5561, #$5543,
      #$554A, #$5531, #$5556, #$554F, #$5555, #$552F, #$5564, #$5538,
      #$552E, #$555C, #$552C, #$5563, #$5533, #$5541, #$5557, #$5708,
      #$570B, #$5709, #$57DF, #$5805, #$580A, #$5806, #$57E0, #$57E4,
      #$57FA, #$5802, #$5835, #$57F7, #$57F9, #$5920, #$5962, #$5A36,
      #$5A41, #$5A49, #$5A66, #$5A6A, #$5A40,
      #$5A3C, #$5A62, #$5A5A, #$5A46, #$5A4A, #$5B70, #$5BC7, #$5BC5,
      #$5BC4, #$5BC2, #$5BBF, #$5BC6, #$5C09, #$5C08, #$5C07, #$5C60,
      #$5C5C, #$5C5D, #$5D07, #$5D06, #$5D0E, #$5D1B, #$5D16, #$5D22,
      #$5D11, #$5D29, #$5D14, #$5D19, #$5D24, #$5D27, #$5D17, #$5DE2,
      #$5E38, #$5E36, #$5E33, #$5E37, #$5EB7, #$5EB8, #$5EB6, #$5EB5,
      #$5EBE, #$5F35, #$5F37, #$5F57, #$5F6C, #$5F69, #$5F6B, #$5F97,
      #$5F99, #$5F9E, #$5F98, #$5FA1, #$5FA0, #$5F9C, #$607F, #$60A3,
      #$6089, #$60A0, #$60A8, #$60CB, #$60B4, #$60E6, #$60BD, #$60C5,
      #$60BB, #$60B5, #$60DC, #$60BC, #$60D8, #$60D5, #$60C6, #$60DF,
      #$60B8, #$60DA, #$60C7, #$621A, #$621B, #$6248, #$63A0, #$63A7,
      #$6372, #$6396, #$63A2, #$63A5, #$6377, #$6367, #$6398, #$63AA,
      #$6371, #$63A9, #$6389, #$6383, #$639B, #$636B, #$63A8, #$6384,
      #$6388, #$6399, #$63A1, #$63AC, #$6392, #$638F, #$6380, #$637B,
      #$6369, #$6368, #$637A, #$655D, #$6556, #$6551, #$6559, #$6557,
      #$555F, #$654F, #$6558, #$6555, #$6554, #$659C, #$659B, #$65AC,
      #$65CF, #$65CB, #$65CC, #$65CE, #$665D, #$665A, #$6664, #$6668,
      #$6666, #$665E, #$66F9, #$52D7, #$671B, #$6881, #$68AF, #$68A2,
      #$6893, #$68B5, #$687F, #$6876, #$68B1, #$68A7, #$6897, #$68B0,
      #$6883, #$68C4, #$68AD, #$6886, #$6885, #$6894, #$689D, #$68A8,
      #$689F, #$68A1, #$6882, #$6B32, #$6BBA,
      #$6BEB, #$6BEC, #$6C2B, #$6D8E, #$6DBC, #$6DF3, #$6DD9, #$6DB2,
      #$6DE1, #$6DCC, #$6DE4, #$6DFB, #$6DFA, #$6E05, #$6DC7, #$6DCB,
      #$6DAF, #$6DD1, #$6DAE, #$6DDE, #$6DF9, #$6DB8, #$6DF7, #$6DF5,
      #$6DC5, #$6DD2, #$6E1A, #$6DB5, #$6DDA, #$6DEB, #$6DD8, #$6DEA,
      #$6DF1, #$6DEE, #$6DE8, #$6DC6, #$6DC4, #$6DAA, #$6DEC, #$6DBF,
      #$6DE6, #$70F9, #$7109, #$710A, #$70FD, #$70EF, #$723D, #$727D,
      #$7281, #$731C, #$731B, #$7316, #$7313, #$7319, #$7387, #$7405,
      #$740A, #$7403, #$7406, #$73FE, #$740D, #$74E0, #$74F6, #$74F7,
      #$751C, #$7522, #$7565, #$7566, #$7562, #$7570, #$758F, #$75D4,
      #$75D5, #$75B5, #$75CA, #$75CD, #$768E, #$76D4, #$76D2, #$76DB,
      #$7737, #$773E, #$773C, #$7736, #$7738, #$773A, #$786B, #$7843,
      #$784E, #$7965, #$7968, #$796D, #$79FB, #$7A92, #$7A95, #$7B20,
      #$7B28, #$7B1B, #$7B2C, #$7B26, #$7B19, #$7B1E, #$7B2E, #$7C92,
      #$7C97, #$7C95, #$7D46, #$7D43, #$7D71, #$7D2E, #$7D39, #$7D3C,
      #$7D40, #$7D30, #$7D33, #$7D44, #$7D2F, #$7D42, #$7D32, #$7D31,
      #$7F3D, #$7F9E, #$7F9A, #$7FCC, #$7FCE, #$7FD2, #$801C, #$804A,
      #$8046, #$812F, #$8116, #$8123, #$812B, #$8129, #$8130, #$8124,
      #$8202, #$8235, #$8237, #$8236, #$8239, #$838E, #$839E, #$8398,
      #$8378, #$83A2, #$8396, #$83BD, #$83AB, #$8392, #$838A, #$8393,
      #$8389, #$83A0, #$8377, #$837B, #$837C,
      #$8386, #$83A7, #$8655, #$5F6A, #$86C7, #$86C0, #$86B6, #$86C4,
      #$86B5, #$86C6, #$86CB, #$86B1, #$86AF, #$86C9, #$8853, #$889E,
      #$8888, #$88AB, #$8892, #$8896, #$888D, #$888B, #$8993, #$898F,
      #$8A2A, #$8A1D, #$8A23, #$8A25, #$8A31, #$8A2D, #$8A1F, #$8A1B,
      #$8A22, #$8C49, #$8C5A, #$8CA9, #$8CAC, #$8CAB, #$8CA8, #$8CAA,
      #$8CA7, #$8D67, #$8D66, #$8DBE, #$8DBA, #$8EDB, #$8EDF, #$9019,
      #$900D, #$901A, #$9017, #$9023, #$901F, #$901D, #$9010, #$9015,
      #$901E, #$9020, #$900F, #$9022, #$9016, #$901B, #$9014, #$90E8,
      #$90ED, #$90FD, #$9157, #$91CE, #$91F5, #$91E6, #$91E3, #$91E7,
      #$91ED, #$91E9, #$9589, #$966A, #$9675, #$9673, #$9678, #$9670,
      #$9674, #$9676, #$9677, #$966C, #$96C0, #$96EA, #$96E9, #$7AE0,
      #$7ADF, #$9802, #$9803, #$9B5A, #$9CE5, #$9E75, #$9E7F, #$9EA5,
      #$9EBB, #$50A2, #$508D, #$5085, #$5099, #$5091, #$5080, #$5096,
      #$5098, #$509A, #$6700, #$51F1, #$5272, #$5274, #$5275, #$5269,
      #$52DE, #$52DD, #$52DB, #$535A, #$53A5, #$557B, #$5580, #$55A7,
      #$557C, #$558A, #$559D, #$5598, #$5582, #$559C, #$55AA, #$5594,
      #$5587, #$558B, #$5583, #$55B3, #$55AE, #$559F, #$553E, #$55B2,
      #$559A, #$55BB, #$55AC, #$55B1, #$557E, #$5589, #$55AB, #$5599,
      #$570D, #$582F, #$582A, #$5834, #$5824, #$5830, #$5831, #$5821,
      #$581D, #$5820, #$58F9, #$58FA, #$5960,
      #$5A77, #$5A9A, #$5A7F, #$5A92, #$5A9B, #$5AA7, #$5B73, #$5B71,
      #$5BD2, #$5BCC, #$5BD3, #$5BD0, #$5C0A, #$5C0B, #$5C31, #$5D4C,
      #$5D50, #$5D34, #$5D47, #$5DFD, #$5E45, #$5E3D, #$5E40, #$5E43,
      #$5E7E, #$5ECA, #$5EC1, #$5EC2, #$5EC4, #$5F3C, #$5F6D, #$5FA9,
      #$5FAA, #$5FA8, #$60D1, #$60E1, #$60B2, #$60B6, #$60E0, #$611C,
      #$6123, #$60FA, #$6115, #$60F0, #$60FB, #$60F4, #$6168, #$60F1,
      #$610E, #$60F6, #$6109, #$6100, #$6112, #$621F, #$6249, #$63A3,
      #$638C, #$63CF, #$63C0, #$63E9, #$63C9, #$63C6, #$63CD, #$63D2,
      #$63E3, #$63D0, #$63E1, #$63D6, #$63ED, #$63EE, #$6376, #$63F4,
      #$63EA, #$63DB, #$6452, #$63DA, #$63F9, #$655E, #$6566, #$6562,
      #$6563, #$6591, #$6590, #$65AF, #$666E, #$6670, #$6674, #$6676,
      #$666F, #$6691, #$667A, #$667E, #$6677, #$66FE, #$66FF, #$671F,
      #$671D, #$68FA, #$68D5, #$68E0, #$68D8, #$68D7, #$6905, #$68DF,
      #$68F5, #$68EE, #$68E7, #$68F9, #$68D2, #$68F2, #$68E3, #$68CB,
      #$68CD, #$690D, #$6912, #$690E, #$68C9, #$68DA, #$696E, #$68FB,
      #$6B3E, #$6B3A, #$6B3D, #$6B98, #$6B96, #$6BBC, #$6BEF, #$6C2E,
      #$6C2F, #$6C2C, #$6E2F, #$6E38, #$6E54, #$6E21, #$6E32, #$6E67,
      #$6E4A, #$6E20, #$6E25, #$6E23, #$6E1B, #$6E5B, #$6E58, #$6E24,
      #$6E56, #$6E6E, #$6E2D, #$6E26, #$6E6F, #$6E34, #$6E4D, #$6E3A,
      #$6E2C, #$6E43, #$6E1D, #$6E3E, #$6ECB,
      #$6E89, #$6E19, #$6E4E, #$6E63, #$6E44, #$6E72, #$6E69, #$6E5F,
      #$7119, #$711A, #$7126, #$7130, #$7121, #$7136, #$716E, #$711C,
      #$724C, #$7284, #$7280, #$7336, #$7325, #$7334, #$7329, #$743A,
      #$742A, #$7433, #$7422, #$7425, #$7435, #$7436, #$7434, #$742F,
      #$741B, #$7426, #$7428, #$7525, #$7526, #$756B, #$756A, #$75E2,
      #$75DB, #$75E3, #$75D9, #$75D8, #$75DE, #$75E0, #$767B, #$767C,
      #$7696, #$7693, #$76B4, #$76DC, #$774F, #$77ED, #$785D, #$786C,
      #$786F, #$7A0D, #$7A08, #$7A0B, #$7A05, #$7A00, #$7A98, #$7A97,
      #$7A96, #$7AE5, #$7AE3, #$7B49, #$7B56, #$7B46, #$7B50, #$7B52,
      #$7B54, #$7B4D, #$7B4B, #$7B4F, #$7B51, #$7C9F, #$7CA5, #$7D5E,
      #$7D50, #$7D68, #$7D55, #$7D2B, #$7D6E, #$7D72, #$7D61, #$7D66,
      #$7D62, #$7D70, #$7D73, #$5584, #$7FD4, #$7FD5, #$800B, #$8052,
      #$8085, #$8155, #$8154, #$814B, #$8151, #$814E, #$8139, #$8146,
      #$813E, #$814C, #$8153, #$8174, #$8212, #$821C, #$83E9, #$8403,
      #$83F8, #$840D, #$83E0, #$83C5, #$840B, #$83C1, #$83EF, #$83F1,
      #$83F4, #$8457, #$840A, #$83F0, #$840C, #$83CC, #$83FD, #$83F2,
      #$83CA, #$8438, #$840E, #$8404, #$83DC, #$8407, #$83D4, #$83DF,
      #$865B, #$86DF, #$86D9, #$86ED, #$86D4, #$86DB, #$86E4, #$86D0,
      #$86DE, #$8857, #$88C1, #$88C2, #$88B1, #$8983, #$8996, #$8A3B,
      #$8A60, #$8A55, #$8A5E, #$8A3C, #$8A41,
      #$8A54, #$8A5B, #$8A50, #$8A46, #$8A34, #$8A3A, #$8A36, #$8A56,
      #$8C61, #$8C82, #$8CAF, #$8CBC, #$8CB3, #$8CBD, #$8CC1, #$8CBB,
      #$8CC0, #$8CB4, #$8CB7, #$8CB6, #$8CBF, #$8CB8, #$8D8A, #$8D85,
      #$8D81, #$8DCE, #$8DDD, #$8DCB, #$8DDA, #$8DD1, #$8DCC, #$8DDB,
      #$8DC6, #$8EFB, #$8EF8, #$8EFC, #$8F9C, #$902E, #$9035, #$9031,
      #$9038, #$9032, #$9036, #$9102, #$90F5, #$9109, #$90FE, #$9163,
      #$9165, #$91CF, #$9214, #$9215, #$9223, #$9209, #$921E, #$920D,
      #$9210, #$9207, #$9211, #$9594, #$958F, #$958B, #$9591, #$9593,
      #$9592, #$958E, #$968A, #$968E, #$968B, #$967D, #$9685, #$9686,
      #$968D, #$9672, #$9684, #$96C1, #$96C5, #$96C4, #$96C6, #$96C7,
      #$96EF, #$96F2, #$97CC, #$9805, #$9806, #$9808, #$98E7, #$98EA,
      #$98EF, #$98E9, #$98F2, #$98ED, #$99AE, #$99AD, #$9EC3, #$9ECD,
      #$9ED1, #$4E82, #$50AD, #$50B5, #$50B2, #$50B3, #$50C5, #$50BE,
      #$50AC, #$50B7, #$50BB, #$50AF, #$50C7, #$527F, #$5277, #$527D,
      #$52DF, #$52E6, #$52E4, #$52E2, #$52E3, #$532F, #$55DF, #$55E8,
      #$55D3, #$55E6, #$55CE, #$55DC, #$55C7, #$55D1, #$55E3, #$55E4,
      #$55EF, #$55DA, #$55E1, #$55C5, #$55C6, #$55E5, #$55C9, #$5712,
      #$5713, #$585E, #$5851, #$5858, #$5857, #$585A, #$5854, #$586B,
      #$584C, #$586D, #$584A, #$5862, #$5852, #$584B, #$5967, #$5AC1,
      #$5AC9, #$5ACC, #$5ABE, #$5ABD, #$5ABC,
      #$5AB3, #$5AC2, #$5AB2, #$5D69, #$5D6F, #$5E4C, #$5E79, #$5EC9,
      #$5EC8, #$5F12, #$5F59, #$5FAC, #$5FAE, #$611A, #$610F, #$6148,
      #$611F, #$60F3, #$611B, #$60F9, #$6101, #$6108, #$614E, #$614C,
      #$6144, #$614D, #$613E, #$6134, #$6127, #$610D, #$6106, #$6137,
      #$6221, #$6222, #$6413, #$643E, #$641E, #$642A, #$642D, #$643D,
      #$642C, #$640F, #$641C, #$6414, #$640D, #$6436, #$6416, #$6417,
      #$6406, #$656C, #$659F, #$65B0, #$6697, #$6689, #$6687, #$6688,
      #$6696, #$6684, #$6698, #$668D, #$6703, #$6994, #$696D, #$695A,
      #$6977, #$6960, #$6954, #$6975, #$6930, #$6982, #$694A, #$6968,
      #$696B, #$695E, #$6953, #$6979, #$6986, #$695D, #$6963, #$695B,
      #$6B47, #$6B72, #$6BC0, #$6BBF, #$6BD3, #$6BFD, #$6EA2, #$6EAF,
      #$6ED3, #$6EB6, #$6EC2, #$6E90, #$6E9D, #$6EC7, #$6EC5, #$6EA5,
      #$6E98, #$6EBC, #$6EBA, #$6EAB, #$6ED1, #$6E96, #$6E9C, #$6EC4,
      #$6ED4, #$6EAA, #$6EA7, #$6EB4, #$714E, #$7159, #$7169, #$7164,
      #$7149, #$7167, #$715C, #$716C, #$7166, #$714C, #$7165, #$715E,
      #$7146, #$7168, #$7156, #$723A, #$7252, #$7337, #$7345, #$733F,
      #$733E, #$746F, #$745A, #$7455, #$745F, #$745E, #$7441, #$743F,
      #$7459, #$745B, #$745C, #$7576, #$7578, #$7600, #$75F0, #$7601,
      #$75F2, #$75F1, #$75FA, #$75FF, #$75F4, #$75F3, #$76DE, #$76DF,
      #$775B, #$776B, #$7766, #$775E, #$7763,
      #$7779, #$776A, #$776C, #$775C, #$7765, #$7768, #$7762, #$77EE,
      #$788E, #$78B0, #$7897, #$7898, #$788C, #$7889, #$787C, #$7891,
      #$7893, #$787F, #$797A, #$797F, #$7981, #$842C, #$79BD, #$7A1C,
      #$7A1A, #$7A20, #$7A14, #$7A1F, #$7A1E, #$7A9F, #$7AA0, #$7B77,
      #$7BC0, #$7B60, #$7B6E, #$7B67, #$7CB1, #$7CB3, #$7CB5, #$7D93,
      #$7D79, #$7D91, #$7D81, #$7D8F, #$7D5B, #$7F6E, #$7F69, #$7F6A,
      #$7F72, #$7FA9, #$7FA8, #$7FA4, #$8056, #$8058, #$8086, #$8084,
      #$8171, #$8170, #$8178, #$8165, #$816E, #$8173, #$816B, #$8179,
      #$817A, #$8166, #$8205, #$8247, #$8482, #$8477, #$843D, #$8431,
      #$8475, #$8466, #$846B, #$8449, #$846C, #$845B, #$843C, #$8435,
      #$8461, #$8463, #$8469, #$846D, #$8446, #$865E, #$865C, #$865F,
      #$86F9, #$8713, #$8708, #$8707, #$8700, #$86FE, #$86FB, #$8702,
      #$8703, #$8706, #$870A, #$8859, #$88DF, #$88D4, #$88D9, #$88DC,
      #$88D8, #$88DD, #$88E1, #$88CA, #$88D5, #$88D2, #$899C, #$89E3,
      #$8A6B, #$8A72, #$8A73, #$8A66, #$8A69, #$8A70, #$8A87, #$8A7C,
      #$8A63, #$8AA0, #$8A71, #$8A85, #$8A6D, #$8A62, #$8A6E, #$8A6C,
      #$8A79, #$8A7B, #$8A3E, #$8A68, #$8C62, #$8C8A, #$8C89, #$8CCA,
      #$8CC7, #$8CC8, #$8CC4, #$8CB2, #$8CC3, #$8CC2, #$8CC5, #$8DE1,
      #$8DDF, #$8DE8, #$8DEF, #$8DF3, #$8DFA, #$8DEA, #$8DE4, #$8DE6,
      #$8EB2, #$8F03, #$8F09, #$8EFE, #$8F0A,
      #$8F9F, #$8FB2, #$904B, #$904A, #$9053, #$9042, #$9054, #$903C,
      #$9055, #$9050, #$9047, #$904F, #$904E, #$904D, #$9051, #$903E,
      #$9041, #$9112, #$9117, #$916C, #$916A, #$9169, #$91C9, #$9237,
      #$9257, #$9238, #$923D, #$9240, #$923E, #$925B, #$924B, #$9264,
      #$9251, #$9234, #$9249, #$924D, #$9245, #$9239, #$923F, #$925A,
      #$9598, #$9698, #$9694, #$9695, #$96CD, #$96CB, #$96C9, #$96CA,
      #$96F7, #$96FB, #$96F9, #$96F6, #$9756, #$9774, #$9776, #$9810,
      #$9811, #$9813, #$980A, #$9812, #$980C, #$98FC, #$98F4, #$98FD,
      #$98FE, #$99B3, #$99B1, #$99B4, #$9AE1, #$9CE9, #$9E82, #$9F0E,
      #$9F13, #$9F20, #$50E7, #$50EE, #$50E5, #$50D6, #$50ED, #$50DA,
      #$50D5, #$50CF, #$50D1, #$50F1, #$50CE, #$50E9, #$5162, #$51F3,
      #$5283, #$5282, #$5331, #$53AD, #$55FE, #$5600, #$561B, #$5617,
      #$55FD, #$5614, #$5606, #$5609, #$560D, #$560E, #$55F7, #$5616,
      #$561F, #$5608, #$5610, #$55F6, #$5718, #$5716, #$5875, #$587E,
      #$5883, #$5893, #$588A, #$5879, #$5885, #$587D, #$58FD, #$5925,
      #$5922, #$5924, #$596A, #$5969, #$5AE1, #$5AE6, #$5AE9, #$5AD7,
      #$5AD6, #$5AD8, #$5AE3, #$5B75, #$5BDE, #$5BE7, #$5BE1, #$5BE5,
      #$5BE6, #$5BE8, #$5BE2, #$5BE4, #$5BDF, #$5C0D, #$5C62, #$5D84,
      #$5D87, #$5E5B, #$5E63, #$5E55, #$5E57, #$5E54, #$5ED3, #$5ED6,
      #$5F0A, #$5F46, #$5F70, #$5FB9, #$6147,
      #$613F, #$614B, #$6177, #$6162, #$6163, #$615F, #$615A, #$6158,
      #$6175, #$622A, #$6487, #$6458, #$6454, #$64A4, #$6478, #$645F,
      #$647A, #$6451, #$6467, #$6434, #$646D, #$647B, #$6572, #$65A1,
      #$65D7, #$65D6, #$66A2, #$66A8, #$669D, #$699C, #$69A8, #$6995,
      #$69C1, #$69AE, #$69D3, #$69CB, #$699B, #$69B7, #$69BB, #$69AB,
      #$69B4, #$69D0, #$69CD, #$69AD, #$69CC, #$69A6, #$69C3, #$69A3,
      #$6B49, #$6B4C, #$6C33, #$6F33, #$6F14, #$6EFE, #$6F13, #$6EF4,
      #$6F29, #$6F3E, #$6F20, #$6F2C, #$6F0F, #$6F02, #$6F22, #$6EFF,
      #$6EEF, #$6F06, #$6F31, #$6F38, #$6F32, #$6F23, #$6F15, #$6F2B,
      #$6F2F, #$6F88, #$6F2A, #$6EEC, #$6F01, #$6EF2, #$6ECC, #$6EF7,
      #$7194, #$7199, #$717D, #$718A, #$7184, #$7192, #$723E, #$7292,
      #$7296, #$7344, #$7350, #$7464, #$7463, #$746A, #$7470, #$746D,
      #$7504, #$7591, #$7627, #$760D, #$760B, #$7609, #$7613, #$76E1,
      #$76E3, #$7784, #$777D, #$777F, #$7761, #$78C1, #$789F, #$78A7,
      #$78B3, #$78A9, #$78A3, #$798E, #$798F, #$798D, #$7A2E, #$7A31,
      #$7AAA, #$7AA9, #$7AED, #$7AEF, #$7BA1, #$7B95, #$7B8B, #$7B75,
      #$7B97, #$7B9D, #$7B94, #$7B8F, #$7BB8, #$7B87, #$7B84, #$7CB9,
      #$7CBD, #$7CBE, #$7DBB, #$7DB0, #$7D9C, #$7DBD, #$7DBE, #$7DA0,
      #$7DCA, #$7DB4, #$7DB2, #$7DB1, #$7DBA, #$7DA2, #$7DBF, #$7DB5,
      #$7DB8, #$7DAD, #$7DD2, #$7DC7, #$7DAC,
      #$7F70, #$7FE0, #$7FE1, #$7FDF, #$805E, #$805A, #$8087, #$8150,
      #$8180, #$818F, #$8188, #$818A, #$817F, #$8182, #$81E7, #$81FA,
      #$8207, #$8214, #$821E, #$824B, #$84C9, #$84BF, #$84C6, #$84C4,
      #$8499, #$849E, #$84B2, #$849C, #$84CB, #$84B8, #$84C0, #$84D3,
      #$8490, #$84BC, #$84D1, #$84CA, #$873F, #$871C, #$873B, #$8722,
      #$8725, #$8734, #$8718, #$8755, #$8737, #$8729, #$88F3, #$8902,
      #$88F4, #$88F9, #$88F8, #$88FD, #$88E8, #$891A, #$88EF, #$8AA6,
      #$8A8C, #$8A9E, #$8AA3, #$8A8D, #$8AA1, #$8A93, #$8AA4, #$8AAA,
      #$8AA5, #$8AA8, #$8A98, #$8A91, #$8A9A, #$8AA7, #$8C6A, #$8C8D,
      #$8C8C, #$8CD3, #$8CD1, #$8CD2, #$8D6B, #$8D99, #$8D95, #$8DFC,
      #$8F14, #$8F12, #$8F15, #$8F13, #$8FA3, #$9060, #$9058, #$905C,
      #$9063, #$9059, #$905E, #$9062, #$905D, #$905B, #$9119, #$9118,
      #$911E, #$9175, #$9178, #$9177, #$9174, #$9278, #$9280, #$9285,
      #$9298, #$9296, #$927B, #$9293, #$929C, #$92A8, #$927C, #$9291,
      #$95A1, #$95A8, #$95A9, #$95A3, #$95A5, #$95A4, #$9699, #$969C,
      #$969B, #$96CC, #$96D2, #$9700, #$977C, #$9785, #$97F6, #$9817,
      #$9818, #$98AF, #$98B1, #$9903, #$9905, #$990C, #$9909, #$99C1,
      #$9AAF, #$9AB0, #$9AE6, #$9B41, #$9B42, #$9CF4, #$9CF6, #$9CF3,
      #$9EBC, #$9F3B, #$9F4A, #$5104, #$5100, #$50FB, #$50F5, #$50F9,
      #$5102, #$5108, #$5109, #$5105, #$51DC,
      #$5287, #$5288, #$5289, #$528D, #$528A, #$52F0, #$53B2, #$562E,
      #$563B, #$5639, #$5632, #$563F, #$5634, #$5629, #$5653, #$564E,
      #$5657, #$5674, #$5636, #$562F, #$5630, #$5880, #$589F, #$589E,
      #$58B3, #$589C, #$58AE, #$58A9, #$58A6, #$596D, #$5B09, #$5AFB,
      #$5B0B, #$5AF5, #$5B0C, #$5B08, #$5BEE, #$5BEC, #$5BE9, #$5BEB,
      #$5C64, #$5C65, #$5D9D, #$5D94, #$5E62, #$5E5F, #$5E61, #$5EE2,
      #$5EDA, #$5EDF, #$5EDD, #$5EE3, #$5EE0, #$5F48, #$5F71, #$5FB7,
      #$5FB5, #$6176, #$6167, #$616E, #$615D, #$6155, #$6182, #$617C,
      #$6170, #$616B, #$617E, #$61A7, #$6190, #$61AB, #$618E, #$61AC,
      #$619A, #$61A4, #$6194, #$61AE, #$622E, #$6469, #$646F, #$6479,
      #$649E, #$64B2, #$6488, #$6490, #$64B0, #$64A5, #$6493, #$6495,
      #$64A9, #$6492, #$64AE, #$64AD, #$64AB, #$649A, #$64AC, #$6499,
      #$64A2, #$64B3, #$6575, #$6577, #$6578, #$66AE, #$66AB, #$66B4,
      #$66B1, #$6A23, #$6A1F, #$69E8, #$6A01, #$6A1E, #$6A19, #$69FD,
      #$6A21, #$6A13, #$6A0A, #$69F3, #$6A02, #$6A05, #$69ED, #$6A11,
      #$6B50, #$6B4E, #$6BA4, #$6BC5, #$6BC6, #$6F3F, #$6F7C, #$6F84,
      #$6F51, #$6F66, #$6F54, #$6F86, #$6F6D, #$6F5B, #$6F78, #$6F6E,
      #$6F8E, #$6F7A, #$6F70, #$6F64, #$6F97, #$6F58, #$6ED5, #$6F6F,
      #$6F60, #$6F5F, #$719F, #$71AC, #$71B1, #$71A8, #$7256, #$729B,
      #$734E, #$7357, #$7469, #$748B, #$7483,
      #$747E, #$7480, #$757F, #$7620, #$7629, #$761F, #$7624, #$7626,
      #$7621, #$7622, #$769A, #$76BA, #$76E4, #$778E, #$7787, #$778C,
      #$7791, #$778B, #$78CB, #$78C5, #$78BA, #$78CA, #$78BE, #$78D5,
      #$78BC, #$78D0, #$7A3F, #$7A3C, #$7A40, #$7A3D, #$7A37, #$7A3B,
      #$7AAF, #$7AAE, #$7BAD, #$7BB1, #$7BC4, #$7BB4, #$7BC6, #$7BC7,
      #$7BC1, #$7BA0, #$7BCC, #$7CCA, #$7DE0, #$7DF4, #$7DEF, #$7DFB,
      #$7DD8, #$7DEC, #$7DDD, #$7DE8, #$7DE3, #$7DDA, #$7DDE, #$7DE9,
      #$7D9E, #$7DD9, #$7DF2, #$7DF9, #$7F75, #$7F77, #$7FAF, #$7FE9,
      #$8026, #$819B, #$819C, #$819D, #$81A0, #$819A, #$8198, #$8517,
      #$853D, #$851A, #$84EE, #$852C, #$852D, #$8513, #$8511, #$8523,
      #$8521, #$8514, #$84EC, #$8525, #$84FF, #$8506, #$8782, #$8774,
      #$8776, #$8760, #$8766, #$8778, #$8768, #$8759, #$8757, #$874C,
      #$8753, #$885B, #$885D, #$8910, #$8907, #$8912, #$8913, #$8915,
      #$890A, #$8ABC, #$8AD2, #$8AC7, #$8AC4, #$8A95, #$8ACB, #$8AF8,
      #$8AB2, #$8AC9, #$8AC2, #$8ABF, #$8AB0, #$8AD6, #$8ACD, #$8AB6,
      #$8AB9, #$8ADB, #$8C4C, #$8C4E, #$8C6C, #$8CE0, #$8CDE, #$8CE6,
      #$8CE4, #$8CEC, #$8CED, #$8CE2, #$8CE3, #$8CDC, #$8CEA, #$8CE1,
      #$8D6D, #$8D9F, #$8DA3, #$8E2B, #$8E10, #$8E1D, #$8E22, #$8E0F,
      #$8E29, #$8E1F, #$8E21, #$8E1E, #$8EBA, #$8F1D, #$8F1B, #$8F1F,
      #$8F29, #$8F26, #$8F2A, #$8F1C, #$8F1E,
      #$8F25, #$9069, #$906E, #$9068, #$906D, #$9077, #$9130, #$912D,
      #$9127, #$9131, #$9187, #$9189, #$918B, #$9183, #$92C5, #$92BB,
      #$92B7, #$92EA, #$92AC, #$92E4, #$92C1, #$92B3, #$92BC, #$92D2,
      #$92C7, #$92F0, #$92B2, #$95AD, #$95B1, #$9704, #$9706, #$9707,
      #$9709, #$9760, #$978D, #$978B, #$978F, #$9821, #$982B, #$981C,
      #$98B3, #$990A, #$9913, #$9912, #$9918, #$99DD, #$99D0, #$99DF,
      #$99DB, #$99D1, #$99D5, #$99D2, #$99D9, #$9AB7, #$9AEE, #$9AEF,
      #$9B27, #$9B45, #$9B44, #$9B77, #$9B6F, #$9D06, #$9D09, #$9D03,
      #$9EA9, #$9EBE, #$9ECE, #$58A8, #$9F52, #$5112, #$5118, #$5114,
      #$5110, #$5115, #$5180, #$51AA, #$51DD, #$5291, #$5293, #$52F3,
      #$5659, #$566B, #$5679, #$5669, #$5664, #$5678, #$566A, #$5668,
      #$5665, #$5671, #$566F, #$566C, #$5662, #$5676, #$58C1, #$58BE,
      #$58C7, #$58C5, #$596E, #$5B1D, #$5B34, #$5B78, #$5BF0, #$5C0E,
      #$5F4A, #$61B2, #$6191, #$61A9, #$618A, #$61CD, #$61B6, #$61BE,
      #$61CA, #$61C8, #$6230, #$64C5, #$64C1, #$64CB, #$64BB, #$64BC,
      #$64DA, #$64C4, #$64C7, #$64C2, #$64CD, #$64BF, #$64D2, #$64D4,
      #$64BE, #$6574, #$66C6, #$66C9, #$66B9, #$66C4, #$66C7, #$66B8,
      #$6A3D, #$6A38, #$6A3A, #$6A59, #$6A6B, #$6A58, #$6A39, #$6A44,
      #$6A62, #$6A61, #$6A4B, #$6A47, #$6A35, #$6A5F, #$6A48, #$6B59,
      #$6B77, #$6C05, #$6FC2, #$6FB1, #$6FA1,
      #$6FC3, #$6FA4, #$6FC1, #$6FA7, #$6FB3, #$6FC0, #$6FB9, #$6FB6,
      #$6FA6, #$6FA0, #$6FB4, #$71BE, #$71C9, #$71D0, #$71D2, #$71C8,
      #$71D5, #$71B9, #$71CE, #$71D9, #$71DC, #$71C3, #$71C4, #$7368,
      #$749C, #$74A3, #$7498, #$749F, #$749E, #$74E2, #$750C, #$750D,
      #$7634, #$7638, #$763A, #$76E7, #$76E5, #$77A0, #$779E, #$779F,
      #$77A5, #$78E8, #$78DA, #$78EC, #$78E7, #$79A6, #$7A4D, #$7A4E,
      #$7A46, #$7A4C, #$7A4B, #$7ABA, #$7BD9, #$7C11, #$7BC9, #$7BE4,
      #$7BDB, #$7BE1, #$7BE9, #$7BE6, #$7CD5, #$7CD6, #$7E0A, #$7E11,
      #$7E08, #$7E1B, #$7E23, #$7E1E, #$7E1D, #$7E09, #$7E10, #$7F79,
      #$7FB2, #$7FF0, #$7FF1, #$7FEE, #$8028, #$81B3, #$81A9, #$81A8,
      #$81FB, #$8208, #$8258, #$8259, #$854A, #$8559, #$8548, #$8568,
      #$8569, #$8543, #$8549, #$856D, #$856A, #$855E, #$8783, #$879F,
      #$879E, #$87A2, #$878D, #$8861, #$892A, #$8932, #$8925, #$892B,
      #$8921, #$89AA, #$89A6, #$8AE6, #$8AFA, #$8AEB, #$8AF1, #$8B00,
      #$8ADC, #$8AE7, #$8AEE, #$8AFE, #$8B01, #$8B02, #$8AF7, #$8AED,
      #$8AF3, #$8AF6, #$8AFC, #$8C6B, #$8C6D, #$8C93, #$8CF4, #$8E44,
      #$8E31, #$8E34, #$8E42, #$8E39, #$8E35, #$8F3B, #$8F2F, #$8F38,
      #$8F33, #$8FA8, #$8FA6, #$9075, #$9074, #$9078, #$9072, #$907C,
      #$907A, #$9134, #$9192, #$9320, #$9336, #$92F8, #$9333, #$932F,
      #$9322, #$92FC, #$932B, #$9304, #$931A,
      #$9310, #$9326, #$9321, #$9315, #$932E, #$9319, #$95BB, #$96A7,
      #$96A8, #$96AA, #$96D5, #$970E, #$9711, #$9716, #$970D, #$9713,
      #$970F, #$975B, #$975C, #$9766, #$9798, #$9830, #$9838, #$983B,
      #$9837, #$982D, #$9839, #$9824, #$9910, #$9928, #$991E, #$991B,
      #$9921, #$991A, #$99ED, #$99E2, #$99F1, #$9AB8, #$9ABC, #$9AFB,
      #$9AED, #$9B28, #$9B91, #$9D15, #$9D23, #$9D26, #$9D28, #$9D12,
      #$9D1B, #$9ED8, #$9ED4, #$9F8D, #$9F9C, #$512A, #$511F, #$5121,
      #$5132, #$52F5, #$568E, #$5680, #$5690, #$5685, #$5687, #$568F,
      #$58D5, #$58D3, #$58D1, #$58CE, #$5B30, #$5B2A, #$5B24, #$5B7A,
      #$5C37, #$5C68, #$5DBC, #$5DBA, #$5DBD, #$5DB8, #$5E6B, #$5F4C,
      #$5FBD, #$61C9, #$61C2, #$61C7, #$61E6, #$61CB, #$6232, #$6234,
      #$64CE, #$64CA, #$64D8, #$64E0, #$64F0, #$64E6, #$64EC, #$64F1,
      #$64E2, #$64ED, #$6582, #$6583, #$66D9, #$66D6, #$6A80, #$6A94,
      #$6A84, #$6AA2, #$6A9C, #$6ADB, #$6AA3, #$6A7E, #$6A97, #$6A90,
      #$6AA0, #$6B5C, #$6BAE, #$6BDA, #$6C08, #$6FD8, #$6FF1, #$6FDF,
      #$6FE0, #$6FDB, #$6FE4, #$6FEB, #$6FEF, #$6F80, #$6FEC, #$6FE1,
      #$6FE9, #$6FD5, #$6FEE, #$6FF0, #$71E7, #$71DF, #$71EE, #$71E6,
      #$71E5, #$71ED, #$71EC, #$71F4, #$71E0, #$7235, #$7246, #$7370,
      #$7372, #$74A9, #$74B0, #$74A6, #$74A8, #$7646, #$7642, #$764C,
      #$76EA, #$77B3, #$77AA, #$77B0, #$77AC,
      #$77A7, #$77AD, #$77EF, #$78F7, #$78FA, #$78F4, #$78EF, #$7901,
      #$79A7, #$79AA, #$7A57, #$7ABF, #$7C07, #$7C0D, #$7BFE, #$7BF7,
      #$7C0C, #$7BE0, #$7CE0, #$7CDC, #$7CDE, #$7CE2, #$7CDF, #$7CD9,
      #$7CDD, #$7E2E, #$7E3E, #$7E46, #$7E37, #$7E32, #$7E43, #$7E2B,
      #$7E3D, #$7E31, #$7E45, #$7E41, #$7E34, #$7E39, #$7E48, #$7E35,
      #$7E3F, #$7E2F, #$7F44, #$7FF3, #$7FFC, #$8071, #$8072, #$8070,
      #$806F, #$8073, #$81C6, #$81C3, #$81BA, #$81C2, #$81C0, #$81BF,
      #$81BD, #$81C9, #$81BE, #$81E8, #$8209, #$8271, #$85AA, #$8584,
      #$857E, #$859C, #$8591, #$8594, #$85AF, #$859B, #$8587, #$85A8,
      #$858A, #$8667, #$87C0, #$87D1, #$87B3, #$87D2, #$87C6, #$87AB,
      #$87BB, #$87BA, #$87C8, #$87CB, #$893B, #$8936, #$8944, #$8938,
      #$893D, #$89AC, #$8B0E, #$8B17, #$8B19, #$8B1B, #$8B0A, #$8B20,
      #$8B1D, #$8B04, #$8B10, #$8C41, #$8C3F, #$8C73, #$8CFA, #$8CFD,
      #$8CFC, #$8CF8, #$8CFB, #$8DA8, #$8E49, #$8E4B, #$8E48, #$8E4A,
      #$8F44, #$8F3E, #$8F42, #$8F45, #$8F3F, #$907F, #$907D, #$9084,
      #$9081, #$9082, #$9080, #$9139, #$91A3, #$919E, #$919C, #$934D,
      #$9382, #$9328, #$9375, #$934A, #$9365, #$934B, #$9318, #$937E,
      #$936C, #$935B, #$9370, #$935A, #$9354, #$95CA, #$95CB, #$95CC,
      #$95C8, #$95C6, #$96B1, #$96B8, #$96D6, #$971C, #$971E, #$97A0,
      #$97D3, #$9846, #$98B6, #$9935, #$9A01,
      #$99FF, #$9BAE, #$9BAB, #$9BAA, #$9BAD, #$9D3B, #$9D3F, #$9E8B,
      #$9ECF, #$9EDE, #$9EDC, #$9EDD, #$9EDB, #$9F3E, #$9F4B, #$53E2,
      #$5695, #$56AE, #$58D9, #$58D8, #$5B38, #$5F5D, #$61E3, #$6233,
      #$64F4, #$64F2, #$64FE, #$6506, #$64FA, #$64FB, #$64F7, #$65B7,
      #$66DC, #$6726, #$6AB3, #$6AAC, #$6AC3, #$6ABB, #$6AB8, #$6AC2,
      #$6AAE, #$6AAF, #$6B5F, #$6B78, #$6BAF, #$7009, #$700B, #$6FFE,
      #$7006, #$6FFA, #$7011, #$700F, #$71FB, #$71FC, #$71FE, #$71F8,
      #$7377, #$7375, #$74A7, #$74BF, #$7515, #$7656, #$7658, #$7652,
      #$77BD, #$77BF, #$77BB, #$77BC, #$790E, #$79AE, #$7A61, #$7A62,
      #$7A60, #$7AC4, #$7AC5, #$7C2B, #$7C27, #$7C2A, #$7C1E, #$7C23,
      #$7C21, #$7CE7, #$7E54, #$7E55, #$7E5E, #$7E5A, #$7E61, #$7E52,
      #$7E59, #$7F48, #$7FF9, #$7FFB, #$8077, #$8076, #$81CD, #$81CF,
      #$820A, #$85CF, #$85A9, #$85CD, #$85D0, #$85C9, #$85B0, #$85BA,
      #$85B9, #$85A6, #$87EF, #$87EC, #$87F2, #$87E0, #$8986, #$89B2,
      #$89F4, #$8B28, #$8B39, #$8B2C, #$8B2B, #$8C50, #$8D05, #$8E59,
      #$8E63, #$8E66, #$8E64, #$8E5F, #$8E55, #$8EC0, #$8F49, #$8F4D,
      #$9087, #$9083, #$9088, #$91AB, #$91AC, #$91D0, #$9394, #$938A,
      #$9396, #$93A2, #$93B3, #$93AE, #$93AC, #$93B0, #$9398, #$939A,
      #$9397, #$95D4, #$95D6, #$95D0, #$95D5, #$96E2, #$96DC, #$96D9,
      #$96DB, #$96DE, #$9724, #$97A3, #$97A6,
      #$97AD, #$97F9, #$984D, #$984F, #$984C, #$984E, #$9853, #$98BA,
      #$993E, #$993F, #$993D, #$992E, #$99A5, #$9A0E, #$9AC1, #$9B03,
      #$9B06, #$9B4F, #$9B4E, #$9B4D, #$9BCA, #$9BC9, #$9BFD, #$9BC8,
      #$9BC0, #$9D51, #$9D5D, #$9D60, #$9EE0, #$9F15, #$9F2C, #$5133,
      #$56A5, #$58DE, #$58DF, #$58E2, #$5BF5, #$9F90, #$5EEC, #$61F2,
      #$61F7, #$61F6, #$61F5, #$6500, #$650F, #$66E0, #$66DD, #$6AE5,
      #$6ADD, #$6ADA, #$6AD3, #$701B, #$701F, #$7028, #$701A, #$701D,
      #$7015, #$7018, #$7206, #$720D, #$7258, #$72A2, #$7378, #$737A,
      #$74BD, #$74CA, #$74E3, #$7587, #$7586, #$765F, #$7661, #$77C7,
      #$7919, #$79B1, #$7A6B, #$7A69, #$7C3E, #$7C3F, #$7C38, #$7C3D,
      #$7C37, #$7C40, #$7E6B, #$7E6D, #$7E79, #$7E69, #$7E6A, #$7F85,
      #$7E73, #$7FB6, #$7FB9, #$7FB8, #$81D8, #$85E9, #$85DD, #$85EA,
      #$85D5, #$85E4, #$85E5, #$85F7, #$87FB, #$8805, #$880D, #$87F9,
      #$87FE, #$8960, #$895F, #$8956, #$895E, #$8B41, #$8B5C, #$8B58,
      #$8B49, #$8B5A, #$8B4E, #$8B4F, #$8B46, #$8B59, #$8D08, #$8D0A,
      #$8E7C, #$8E72, #$8E87, #$8E76, #$8E6C, #$8E7A, #$8E74, #$8F54,
      #$8F4E, #$8FAD, #$908A, #$908B, #$91B1, #$91AE, #$93E1, #$93D1,
      #$93DF, #$93C3, #$93C8, #$93DC, #$93DD, #$93D6, #$93E2, #$93CD,
      #$93D8, #$93E4, #$93D7, #$93E8, #$95DC, #$96B4, #$96E3, #$972A,
      #$9727, #$9761, #$97DC, #$97FB, #$985E,
      #$9858, #$985B, #$98BC, #$9945, #$9949, #$9A16, #$9A19, #$9B0D,
      #$9BE8, #$9BE7, #$9BD6, #$9BDB, #$9D89, #$9D61, #$9D72, #$9D6A,
      #$9D6C, #$9E92, #$9E97, #$9E93, #$9EB4, #$52F8, #$56A8, #$56B7,
      #$56B6, #$56B4, #$56BC, #$58E4, #$5B40, #$5B43, #$5B7D, #$5BF6,
      #$5DC9, #$61F8, #$61FA, #$6518, #$6514, #$6519, #$66E6, #$6727,
      #$6AEC, #$703E, #$7030, #$7032, #$7210, #$737B, #$74CF, #$7662,
      #$7665, #$7926, #$792A, #$792C, #$792B, #$7AC7, #$7AF6, #$7C4C,
      #$7C43, #$7C4D, #$7CEF, #$7CF0, #$8FAE, #$7E7D, #$7E7C, #$7E82,
      #$7F4C, #$8000, #$81DA, #$8266, #$85FB, #$85F9, #$8611, #$85FA,
      #$8606, #$860B, #$8607, #$860A, #$8814, #$8815, #$8964, #$89BA,
      #$89F8, #$8B70, #$8B6C, #$8B66, #$8B6F, #$8B5F, #$8B6B, #$8D0F,
      #$8D0D, #$8E89, #$8E81, #$8E85, #$8E82, #$91B4, #$91CB, #$9418,
      #$9403, #$93FD, #$95E1, #$9730, #$98C4, #$9952, #$9951, #$99A8,
      #$9A2B, #$9A30, #$9A37, #$9A35, #$9C13, #$9C0D, #$9E79, #$9EB5,
      #$9EE8, #$9F2F, #$9F5F, #$9F63, #$9F61, #$5137, #$5138, #$56C1,
      #$56C0, #$56C2, #$5914, #$5C6C, #$5DCD, #$61FC, #$61FE, #$651D,
      #$651C, #$6595, #$66E9, #$6AFB, #$6B04, #$6AFA, #$6BB2, #$704C,
      #$721B, #$72A7, #$74D6, #$74D4, #$7669, #$77D3, #$7C50, #$7E8F,
      #$7E8C, #$7FBC, #$8617, #$862D, #$861A, #$8823, #$8822, #$8821,
      #$881F, #$896A, #$896C, #$89BD, #$8B74,
      #$8B77, #$8B7D, #$8D13, #$8E8A, #$8E8D, #$8E8B, #$8F5F, #$8FAF,
      #$91BA, #$942E, #$9433, #$9435, #$943A, #$9438, #$9432, #$942B,
      #$95E2, #$9738, #$9739, #$9732, #$97FF, #$9867, #$9865, #$9957,
      #$9A45, #$9A43, #$9A40, #$9A3E, #$9ACF, #$9B54, #$9B51, #$9C2D,
      #$9C25, #$9DAF, #$9DB4, #$9DC2, #$9DB8, #$9E9D, #$9EEF, #$9F19,
      #$9F5C, #$9F66, #$9F67, #$513C, #$513B, #$56C8, #$56CA, #$56C9,
      #$5B7F, #$5DD4, #$5DD2, #$5F4E, #$61FF, #$6524, #$6B0A, #$6B61,
      #$7051, #$7058, #$7380, #$74E4, #$758A, #$766E, #$766C, #$79B3,
      #$7C60, #$7C5F, #$807E, #$807D, #$81DF, #$8972, #$896F, #$89FC,
      #$8B80, #$8D16, #$8D17, #$8E91, #$8E93, #$8F61, #$9148, #$9444,
      #$9451, #$9452, #$973D, #$973E, #$97C3, #$97C1, #$986B, #$9955,
      #$9A55, #$9A4D, #$9AD2, #$9B1A, #$9C49, #$9C31, #$9C3E, #$9C3B,
      #$9DD3, #$9DD7, #$9F34, #$9F6C, #$9F6A, #$9F94, #$56CC, #$5DD6,
      #$6200, #$6523, #$652B, #$652A, #$66EC, #$6B10, #$74DA, #$7ACA,
      #$7C64, #$7C63, #$7C65, #$7E93, #$7E96, #$7E94, #$81E2, #$8638,
      #$863F, #$8831, #$8B8A, #$9090, #$908F, #$9463, #$9460, #$9464,
      #$9768, #$986F, #$995C, #$9A5A, #$9A5B, #$9A57, #$9AD3, #$9AD4,
      #$9AD1, #$9C54, #$9C57, #$9C56, #$9DE5, #$9E9F, #$9EF4, #$56D1,
      #$58E9, #$652C, #$705E, #$7671, #$7672, #$77D7, #$7F50, #$7F88,
      #$8836, #$8839, #$8862, #$8B93, #$8B92,
      #$8B96, #$8277, #$8D1B, #$91C0, #$946A, #$9742, #$9748, #$9744,
      #$97C6, #$9870, #$9A5F, #$9B22, #$9B58, #$9C5F, #$9DF9, #$9DFA,
      #$9E7C, #$9E7D, #$9F07, #$9F77, #$9F72, #$5EF3, #$6B16, #$7063,
      #$7C6C, #$7C6E, #$883B, #$89C0, #$8EA1, #$91C1, #$9472, #$9470,
      #$9871, #$995E, #$9AD6, #$9B23, #$9ECC, #$7064, #$77DA, #$8B9A,
      #$9477, #$97C9, #$9A62, #$9A65, #$7E9C, #$8B9C, #$8EAA, #$91C5,
      #$947D, #$947E, #$947C, #$9C77, #$9C78, #$9EF7, #$8C54, #$947F,
      #$9E1A, #$7228, #$9A6A, #$9B31, #$9E1B, #$9E1E, #$7C72, #$30FE,
      #$309D, #$309E, #$3005, #$3041, #$3042, #$3043, #$3044, #$3045,
      #$3046, #$3047, #$3048, #$3049, #$304A, #$304B, #$304C, #$304D,
      #$304E, #$304F, #$3050, #$3051, #$3052, #$3053, #$3054, #$3055,
      #$3056, #$3057, #$3058, #$3059, #$305A, #$305B, #$305C, #$305D,
      #$305E, #$305F, #$3060, #$3061, #$3062, #$3063, #$3064, #$3065,
      #$3066, #$3067, #$3068, #$3069, #$306A, #$306B, #$306C, #$306D,
      #$306E, #$306F, #$3070, #$3071, #$3072, #$3073, #$3074, #$3075,
      #$3076, #$3077, #$3078, #$3079, #$307A, #$307B, #$307C, #$307D,
      #$307E, #$307F, #$3080, #$3081, #$3082, #$3083, #$3084, #$3085,
      #$3086, #$3087, #$3088, #$3089, #$308A, #$308B, #$308C, #$308D,
      #$308E, #$308F, #$3090, #$3091, #$3092, #$3093, #$30A1, #$30A2,
      #$30A3, #$30A4, #$30A5, #$30A6, #$30A7,
      #$30A8, #$30A9, #$30AA, #$30AB, #$30AC, #$30AD, #$30AE, #$30AF,
      #$30B0, #$30B1, #$30B2, #$30B3, #$30B4, #$30B5, #$30B6, #$30B7,
      #$30B8, #$30B9, #$30BA, #$30BB, #$30BC, #$30BD, #$30BE, #$30BF,
      #$30C0, #$30C1, #$30C2, #$30C3, #$30C4, #$30C5, #$30C6, #$30C7,
      #$30C8, #$30C9, #$30CA, #$30CB, #$30CC, #$30CD, #$30CE, #$30CF,
      #$30D0, #$30D1, #$30D2, #$30D3, #$30D4, #$30D5, #$30D6, #$30D7,
      #$30D8, #$30D9, #$30DA, #$30DB, #$30DC, #$30DD, #$30DE, #$30DF,
      #$30E0, #$30E1, #$30E2, #$30E3, #$30E4, #$30E5, #$30E6, #$30E7,
      #$30E8, #$30E9, #$30EA, #$30EB, #$30EC, #$30ED, #$30EE, #$30EF,
      #$30F0, #$30F1, #$30F2, #$30F3, #$30F4, #$30F5, #$30F6, #$0414,
      #$0415, #$0401, #$0416, #$0417, #$0418, #$0419, #$041A, #$041B,
      #$041C, #$0423, #$0424, #$0425, #$0426, #$0427, #$0428, #$0429,
      #$042A, #$042B, #$042C, #$042D, #$042E, #$042F, #$0430, #$0431,
      #$0432, #$0433, #$0434, #$0435, #$0451, #$0436, #$0437, #$0438,
      #$0439, #$043A, #$043B, #$043C, #$043D, #$043E, #$043F, #$0440,
      #$0441, #$0442, #$0443, #$0444, #$0445, #$0446, #$0447, #$0448,
      #$0449, #$044A, #$044B, #$044C, #$044D, #$044E, #$044F, #$2460,
      #$2461, #$2462, #$2463, #$2464, #$2465, #$2466, #$2467, #$2468,
      #$2469, #$2474, #$2475, #$2476, #$2477, #$2478, #$2479, #$247A,
      #$247B, #$247C, #$247D);
  BIG5_2Map: array[0..7651] of TBuffChar = (
      #$4E42, #$4E5C, #$51F5, #$531A, #$5382, #$4E07, #$4E0C, #$4E47,
      #$4E8D, #$56D7, #$FA0C, #$5C6E, #$5F73, #$4E0F, #$5187, #$4E0E,
      #$4E2E, #$4E93, #$4EC2, #$4EC9, #$4EC8, #$5198, #$52FC, #$536C,
      #$53B9, #$5720, #$5903, #$592C, #$5C10, #$5DFF, #$65E1, #$6BB3,
      #$6BCC, #$6C14, #$723F, #$4E31, #$4E3C, #$4EE8, #$4EDC, #$4EE9,
      #$4EE1, #$4EDD, #$4EDA, #$520C, #$531C, #$534C, #$5722, #$5723,
      #$5917, #$592F, #$5B81, #$5B84, #$5C12, #$5C3B, #$5C74, #$5C73,
      #$5E04, #$5E80, #$5E82, #$5FC9, #$6209, #$6250, #$6C15, #$6C36,
      #$6C43, #$6C3F, #$6C3B, #$72AE, #$72B0, #$738A, #$79B8, #$808A,
      #$961E, #$4F0E, #$4F18, #$4F2C, #$4EF5, #$4F14, #$4EF1, #$4F00,
      #$4EF7, #$4F08, #$4F1D, #$4F02, #$4F05, #$4F22, #$4F13, #$4F04,
      #$4EF4, #$4F12, #$51B1, #$5213, #$5209, #$5210, #$52A6, #$5322,
      #$531F, #$534D, #$538A, #$5407, #$56E1, #$56DF, #$572E, #$572A,
      #$5734, #$593C, #$5980, #$597C, #$5985, #$597B, #$597E, #$5977,
      #$597F, #$5B56, #$5C15, #$5C25, #$5C7C, #$5C7A, #$5C7B, #$5C7E,
      #$5DDF, #$5E75, #$5E84, #$5F02, #$5F1A, #$5F74, #$5FD5, #$5FD4,
      #$5FCF, #$625C, #$625E, #$6264, #$6261, #$6266, #$6262, #$6259,
      #$6260, #$625A, #$6265, #$65EF, #$65EE, #$673E, #$6739, #$6738,
      #$673B, #$673A, #$673F, #$673C, #$6733, #$6C18, #$6C46, #$6C52,
      #$6C5C, #$6C4F, #$6C4A, #$6C54, #$6C4B,
      #$6C4C, #$7071, #$725E, #$72B4, #$72B5, #$738E, #$752A, #$767F,
      #$7A75, #$7F51, #$8278, #$827C, #$8280, #$827D, #$827F, #$864D,
      #$897E, #$9099, #$9097, #$9098, #$909B, #$9094, #$9622, #$9624,
      #$9620, #$9623, #$4F56, #$4F3B, #$4F62, #$4F49, #$4F53, #$4F64,
      #$4F3E, #$4F67, #$4F52, #$4F5F, #$4F41, #$4F58, #$4F2D, #$4F33,
      #$4F3F, #$4F61, #$518F, #$51B9, #$521C, #$521E, #$5221, #$52AD,
      #$52AE, #$5309, #$5363, #$5372, #$538E, #$538F, #$5430, #$5437,
      #$542A, #$5454, #$5445, #$5419, #$541C, #$5425, #$5418, #$543D,
      #$544F, #$5441, #$5428, #$5424, #$5447, #$56EE, #$56E7, #$56E5,
      #$5741, #$5745, #$574C, #$5749, #$574B, #$5752, #$5906, #$5940,
      #$59A6, #$5998, #$59A0, #$5997, #$598E, #$59A2, #$5990, #$598F,
      #$59A7, #$59A1, #$5B8E, #$5B92, #$5C28, #$5C2A, #$5C8D, #$5C8F,
      #$5C88, #$5C8B, #$5C89, #$5C92, #$5C8A, #$5C86, #$5C93, #$5C95,
      #$5DE0, #$5E0A, #$5E0E, #$5E8B, #$5E89, #$5E8C, #$5E88, #$5E8D,
      #$5F05, #$5F1D, #$5F78, #$5F76, #$5FD2, #$5FD1, #$5FD0, #$5FED,
      #$5FE8, #$5FEE, #$5FF3, #$5FE1, #$5FE4, #$5FE3, #$5FFA, #$5FEF,
      #$5FF7, #$5FFB, #$6000, #$5FF4, #$623A, #$6283, #$628C, #$628E,
      #$628F, #$6294, #$6287, #$6271, #$627B, #$627A, #$6270, #$6281,
      #$6288, #$6277, #$627D, #$6272, #$6274, #$6537, #$65F0, #$65F4,
      #$65F3, #$65F2, #$65F5, #$6745, #$6747,
      #$6759, #$6755, #$674C, #$6748, #$675D, #$674D, #$675A, #$674B,
      #$6BD0, #$6C19, #$6C1A, #$6C78, #$6C67, #$6C6B, #$6C84, #$6C8B,
      #$6C8F, #$6C71, #$6C6F, #$6C69, #$6C9A, #$6C6D, #$6C87, #$6C95,
      #$6C9C, #$6C66, #$6C73, #$6C65, #$6C7B, #$6C8E, #$7074, #$707A,
      #$7263, #$72BF, #$72BD, #$72C3, #$72C6, #$72C1, #$72BA, #$72C5,
      #$7395, #$7397, #$7393, #$7394, #$7392, #$753A, #$7539, #$7594,
      #$7595, #$7681, #$793D, #$8034, #$8095, #$8099, #$8090, #$8092,
      #$809C, #$8290, #$828F, #$8285, #$828E, #$8291, #$8293, #$828A,
      #$8283, #$8284, #$8C78, #$8FC9, #$8FBF, #$909F, #$90A1, #$90A5,
      #$909E, #$90A7, #$90A0, #$9630, #$9628, #$962F, #$962D, #$4E33,
      #$4F98, #$4F7C, #$4F85, #$4F7D, #$4F80, #$4F87, #$4F76, #$4F74,
      #$4F89, #$4F84, #$4F77, #$4F4C, #$4F97, #$4F6A, #$4F9A, #$4F79,
      #$4F81, #$4F78, #$4F90, #$4F9C, #$4F94, #$4F9E, #$4F92, #$4F82,
      #$4F95, #$4F6B, #$4F6E, #$519E, #$51BC, #$51BE, #$5235, #$5232,
      #$5233, #$5246, #$5231, #$52BC, #$530A, #$530B, #$533C, #$5392,
      #$5394, #$5487, #$547F, #$5481, #$5491, #$5482, #$5488, #$546B,
      #$547A, #$547E, #$5465, #$546C, #$5474, #$5466, #$548D, #$546F,
      #$5461, #$5460, #$5498, #$5463, #$5467, #$5464, #$56F7, #$56F9,
      #$576F, #$5772, #$576D, #$576B, #$5771, #$5770, #$5776, #$5780,
      #$5775, #$577B, #$5773, #$5774, #$5762,
      #$5768, #$577D, #$590C, #$5945, #$59B5, #$59BA, #$59CF, #$59CE,
      #$59B2, #$59CC, #$59C1, #$59B6, #$59BC, #$59C3, #$59D6, #$59B1,
      #$59BD, #$59C0, #$59C8, #$59B4, #$59C7, #$5B62, #$5B65, #$5B93,
      #$5B95, #$5C44, #$5C47, #$5CAE, #$5CA4, #$5CA0, #$5CB5, #$5CAF,
      #$5CA8, #$5CAC, #$5C9F, #$5CA3, #$5CAD, #$5CA2, #$5CAA, #$5CA7,
      #$5C9D, #$5CA5, #$5CB6, #$5CB0, #$5CA6, #$5E17, #$5E14, #$5E19,
      #$5F28, #$5F22, #$5F23, #$5F24, #$5F54, #$5F82, #$5F7E, #$5F7D,
      #$5FDE, #$5FE5, #$602D, #$6026, #$6019, #$6032, #$600B, #$6034,
      #$600A, #$6017, #$6033, #$601A, #$601E, #$602C, #$6022, #$600D,
      #$6010, #$602E, #$6013, #$6011, #$600C, #$6009, #$601C, #$6214,
      #$623D, #$62AD, #$62B4, #$62D1, #$62BE, #$62AA, #$62B6, #$62CA,
      #$62AE, #$62B3, #$62AF, #$62BB, #$62A9, #$62B0, #$62B8, #$653D,
      #$65A8, #$65BB, #$6609, #$65FC, #$6604, #$6612, #$6608, #$65FB,
      #$6603, #$660B, #$660D, #$6605, #$65FD, #$6611, #$6610, #$66F6,
      #$670A, #$6785, #$676C, #$678E, #$6792, #$6776, #$677B, #$6798,
      #$6786, #$6784, #$6774, #$678D, #$678C, #$677A, #$679F, #$6791,
      #$6799, #$6783, #$677D, #$6781, #$6778, #$6779, #$6794, #$6B25,
      #$6B80, #$6B7E, #$6BDE, #$6C1D, #$6C93, #$6CEC, #$6CEB, #$6CEE,
      #$6CD9, #$6CB6, #$6CD4, #$6CAD, #$6CE7, #$6CB7, #$6CD0, #$6CC2,
      #$6CBA, #$6CC3, #$6CC6, #$6CED, #$6CF2,
      #$6CD2, #$6CDD, #$6CB4, #$6C8A, #$6C9D, #$6C80, #$6CDE, #$6CC0,
      #$6D30, #$6CCD, #$6CC7, #$6CB0, #$6CF9, #$6CCF, #$6CE9, #$6CD1,
      #$7094, #$7098, #$7085, #$7093, #$7086, #$7084, #$7091, #$7096,
      #$7082, #$709A, #$7083, #$726A, #$72D6, #$72CB, #$72D8, #$72C9,
      #$72DC, #$72D2, #$72D4, #$72DA, #$72CC, #$72D1, #$73A4, #$73A1,
      #$73AD, #$73A6, #$73A2, #$73A0, #$73AC, #$739D, #$74DD, #$74E8,
      #$753F, #$7540, #$753E, #$758C, #$7598, #$76AF, #$76F3, #$76F1,
      #$76F0, #$76F5, #$77F8, #$77FC, #$77F9, #$77FB, #$77FA, #$77F7,
      #$7942, #$793F, #$79C5, #$7A78, #$7A7B, #$7AFB, #$7C75, #$7CFD,
      #$8035, #$808F, #$80AE, #$80A3, #$80B8, #$80B5, #$80AD, #$8220,
      #$82A0, #$82C0, #$82AB, #$829A, #$8298, #$829B, #$82B5, #$82A7,
      #$82AE, #$82BC, #$829E, #$82BA, #$82B4, #$82A8, #$82A1, #$82A9,
      #$82C2, #$82A4, #$82C3, #$82B6, #$82A2, #$8670, #$866F, #$866D,
      #$866E, #$8C56, #$8FD2, #$8FCB, #$8FD3, #$8FCD, #$8FD6, #$8FD5,
      #$8FD7, #$90B2, #$90B4, #$90AF, #$90B3, #$90B0, #$9639, #$963D,
      #$963C, #$963A, #$9643, #$4FCD, #$4FC5, #$4FD3, #$4FB2, #$4FC9,
      #$4FCB, #$4FC1, #$4FD4, #$4FDC, #$4FD9, #$4FBB, #$4FB3, #$4FDB,
      #$4FC7, #$4FD6, #$4FBA, #$4FC0, #$4FB9, #$4FEC, #$5244, #$5249,
      #$52C0, #$52C2, #$533D, #$537C, #$5397, #$5396, #$5399, #$5398,
      #$54BA, #$54A1, #$54AD, #$54A5, #$54CF,
      #$54C3, #$830D, #$54B7, #$54AE, #$54D6, #$54B6, #$54C5, #$54C6,
      #$54A0, #$5470, #$54BC, #$54A2, #$54BE, #$5472, #$54DE, #$54B0,
      #$57B5, #$579E, #$579F, #$57A4, #$578C, #$5797, #$579D, #$579B,
      #$5794, #$5798, #$578F, #$5799, #$57A5, #$579A, #$5795, #$58F4,
      #$590D, #$5953, #$59E1, #$59DE, #$59EE, #$5A00, #$59F1, #$59DD,
      #$59FA, #$59FD, #$59FC, #$59F6, #$59E4, #$59F2, #$59F7, #$59DB,
      #$59E9, #$59F3, #$59F5, #$59E0, #$59FE, #$59F4, #$59ED, #$5BA8,
      #$5C4C, #$5CD0, #$5CD8, #$5CCC, #$5CD7, #$5CCB, #$5CDB, #$5CDE,
      #$5CDA, #$5CC9, #$5CC7, #$5CCA, #$5CD6, #$5CD3, #$5CD4, #$5CCF,
      #$5CC8, #$5CC6, #$5CCE, #$5CDF, #$5CF8, #$5DF9, #$5E21, #$5E22,
      #$5E23, #$5E20, #$5E24, #$5EB0, #$5EA4, #$5EA2, #$5E9B, #$5EA3,
      #$5EA5, #$5F07, #$5F2E, #$5F56, #$5F86, #$6037, #$6039, #$6054,
      #$6072, #$605E, #$6045, #$6053, #$6047, #$6049, #$605B, #$604C,
      #$6040, #$6042, #$605F, #$6024, #$6044, #$6058, #$6066, #$606E,
      #$6242, #$6243, #$62CF, #$630D, #$630B, #$62F5, #$630E, #$6303,
      #$62EB, #$62F9, #$630F, #$630C, #$62F8, #$62F6, #$6300, #$6313,
      #$6314, #$62FA, #$6315, #$62FB, #$62F0, #$6541, #$6543, #$65AA,
      #$65BF, #$6636, #$6621, #$6632, #$6635, #$661C, #$6626, #$6622,
      #$6633, #$662B, #$663A, #$661D, #$6634, #$6639, #$662E, #$670F,
      #$6710, #$67C1, #$67F2, #$67C8, #$67BA,
      #$67DC, #$67BB, #$67F8, #$67D8, #$67C0, #$67B7, #$67C5, #$67EB,
      #$67E4, #$67DF, #$67B5, #$67CD, #$67B3, #$67F7, #$67F6, #$67EE,
      #$67E3, #$67C2, #$67B9, #$67CE, #$67E7, #$67F0, #$67B2, #$67FC,
      #$67C6, #$67ED, #$67CC, #$67AE, #$67E6, #$67DB, #$67FA, #$67C9,
      #$67CA, #$67C3, #$67EA, #$67CB, #$6B28, #$6B82, #$6B84, #$6BB6,
      #$6BD6, #$6BD8, #$6BE0, #$6C20, #$6C21, #$6D28, #$6D34, #$6D2D,
      #$6D1F, #$6D3C, #$6D3F, #$6D12, #$6D0A, #$6CDA, #$6D33, #$6D04,
      #$6D19, #$6D3A, #$6D1A, #$6D11, #$6D00, #$6D1D, #$6D42, #$6D01,
      #$6D18, #$6D37, #$6D03, #$6D0F, #$6D40, #$6D07, #$6D20, #$6D2C,
      #$6D08, #$6D22, #$6D09, #$6D10, #$70B7, #$709F, #$70BE, #$70B1,
      #$70B0, #$70A1, #$70B4, #$70B5, #$70A9, #$7241, #$7249, #$724A,
      #$726C, #$7270, #$7273, #$726E, #$72CA, #$72E4, #$72E8, #$72EB,
      #$72DF, #$72EA, #$72E6, #$72E3, #$7385, #$73CC, #$73C2, #$73C8,
      #$73C5, #$73B9, #$73B6, #$73B5, #$73B4, #$73EB, #$73BF, #$73C7,
      #$73BE, #$73C3, #$73C6, #$73B8, #$73CB, #$74EC, #$74EE, #$752E,
      #$7547, #$7548, #$75A7, #$75AA, #$7679, #$76C4, #$7708, #$7703,
      #$7704, #$7705, #$770A, #$76F7, #$76FB, #$76FA, #$77E7, #$77E8,
      #$7806, #$7811, #$7812, #$7805, #$7810, #$780F, #$780E, #$7809,
      #$7803, #$7813, #$794A, #$794C, #$794B, #$7945, #$7944, #$79D5,
      #$79CD, #$79CF, #$79D6, #$79CE, #$7A80,
      #$7A7E, #$7AD1, #$7B00, #$7B01, #$7C7A, #$7C78, #$7C79, #$7C7F,
      #$7C80, #$7C81, #$7D03, #$7D08, #$7D01, #$7F58, #$7F91, #$7F8D,
      #$7FBE, #$8007, #$800E, #$800F, #$8014, #$8037, #$80D8, #$80C7,
      #$80E0, #$80D1, #$80C8, #$80C2, #$80D0, #$80C5, #$80E3, #$80D9,
      #$80DC, #$80CA, #$80D5, #$80C9, #$80CF, #$80D7, #$80E6, #$80CD,
      #$81FF, #$8221, #$8294, #$82D9, #$82FE, #$82F9, #$8307, #$82E8,
      #$8300, #$82D5, #$833A, #$82EB, #$82D6, #$82F4, #$82EC, #$82E1,
      #$82F2, #$82F5, #$830C, #$82FB, #$82F6, #$82F0, #$82EA, #$82E4,
      #$82E0, #$82FA, #$82F3, #$82ED, #$8677, #$8674, #$867C, #$8673,
      #$8841, #$884E, #$8867, #$886A, #$8869, #$89D3, #$8A04, #$8A07,
      #$8D72, #$8FE3, #$8FE1, #$8FEE, #$8FE0, #$90F1, #$90BD, #$90BF,
      #$90D5, #$90C5, #$90BE, #$90C7, #$90CB, #$90C8, #$91D4, #$91D3,
      #$9654, #$964F, #$9651, #$9653, #$964A, #$964E, #$501E, #$5005,
      #$5007, #$5013, #$5022, #$5030, #$501B, #$4FF5, #$4FF4, #$5033,
      #$5037, #$502C, #$4FF6, #$4FF7, #$5017, #$501C, #$5020, #$5027,
      #$5035, #$502F, #$5031, #$500E, #$515A, #$5194, #$5193, #$51CA,
      #$51C4, #$51C5, #$51C8, #$51CE, #$5261, #$525A, #$5252, #$525E,
      #$525F, #$5255, #$5262, #$52CD, #$530E, #$539E, #$5526, #$54E2,
      #$5517, #$5512, #$54E7, #$54F3, #$54E4, #$551A, #$54FF, #$5504,
      #$5508, #$54EB, #$5511, #$5505, #$54F1,
      #$550A, #$54FB, #$54F7, #$54F8, #$54E0, #$550E, #$5503, #$550B,
      #$5701, #$5702, #$57CC, #$5832, #$57D5, #$57D2, #$57BA, #$57C6,
      #$57BD, #$57BC, #$57B8, #$57B6, #$57BF, #$57C7, #$57D0, #$57B9,
      #$57C1, #$590E, #$594A, #$5A19, #$5A16, #$5A2D, #$5A2E, #$5A15,
      #$5A0F, #$5A17, #$5A0A, #$5A1E, #$5A33, #$5B6C, #$5BA7, #$5BAD,
      #$5BAC, #$5C03, #$5C56, #$5C54, #$5CEC, #$5CFF, #$5CEE, #$5CF1,
      #$5CF7, #$5D00, #$5CF9, #$5E29, #$5E28, #$5EA8, #$5EAE, #$5EAA,
      #$5EAC, #$5F33, #$5F30, #$5F67, #$605D, #$605A, #$6067, #$6041,
      #$60A2, #$6088, #$6080, #$6092, #$6081, #$609D, #$6083, #$6095,
      #$609B, #$6097, #$6087, #$609C, #$608E, #$6219, #$6246, #$62F2,
      #$6310, #$6356, #$632C, #$6344, #$6345, #$6336, #$6343, #$63E4,
      #$6339, #$634B, #$634A, #$633C, #$6329, #$6341, #$6334, #$6358,
      #$6354, #$6359, #$632D, #$6347, #$6333, #$635A, #$6351, #$6338,
      #$6357, #$6340, #$6348, #$654A, #$6546, #$65C6, #$65C3, #$65C4,
      #$65C2, #$664A, #$665F, #$6647, #$6651, #$6712, #$6713, #$681F,
      #$681A, #$6849, #$6832, #$6833, #$683B, #$684B, #$684F, #$6816,
      #$6831, #$681C, #$6835, #$682B, #$682D, #$682F, #$684E, #$6844,
      #$6834, #$681D, #$6812, #$6814, #$6826, #$6828, #$682E, #$684D,
      #$683A, #$6825, #$6820, #$6B2C, #$6B2F, #$6B2D, #$6B31, #$6B34,
      #$6B6D, #$8082, #$6B88, #$6BE6, #$6BE4,
      #$6BE8, #$6BE3, #$6BE2, #$6BE7, #$6C25, #$6D7A, #$6D63, #$6D64,
      #$6D76, #$6D0D, #$6D61, #$6D92, #$6D58, #$6D62, #$6D6D, #$6D6F,
      #$6D91, #$6D8D, #$6DEF, #$6D7F, #$6D86, #$6D5E, #$6D67, #$6D60,
      #$6D97, #$6D70, #$6D7C, #$6D5F, #$6D82, #$6D98, #$6D2F, #$6D68,
      #$6D8B, #$6D7E, #$6D80, #$6D84, #$6D16, #$6D83, #$6D7B, #$6D7D,
      #$6D75, #$6D90, #$70DC, #$70D3, #$70D1, #$70DD, #$70CB, #$7F39,
      #$70E2, #$70D7, #$70D2, #$70DE, #$70E0, #$70D4, #$70CD, #$70C5,
      #$70C6, #$70C7, #$70DA, #$70CE, #$70E1, #$7242, #$7278, #$7277,
      #$7276, #$7300, #$72FA, #$72F4, #$72FE, #$72F6, #$72F3, #$72FB,
      #$7301, #$73D3, #$73D9, #$73E5, #$73D6, #$73BC, #$73E7, #$73E3,
      #$73E9, #$73DC, #$73D2, #$73DB, #$73D4, #$73DD, #$73DA, #$73D7,
      #$73D8, #$73E8, #$74DE, #$74DF, #$74F4, #$74F5, #$7521, #$755B,
      #$755F, #$75B0, #$75C1, #$75BB, #$75C4, #$75C0, #$75BF, #$75B6,
      #$75BA, #$768A, #$76C9, #$771D, #$771B, #$7710, #$7713, #$7712,
      #$7723, #$7711, #$7715, #$7719, #$771A, #$7722, #$7727, #$7823,
      #$782C, #$7822, #$7835, #$782F, #$7828, #$782E, #$782B, #$7821,
      #$7829, #$7833, #$782A, #$7831, #$7954, #$795B, #$794F, #$795C,
      #$7953, #$7952, #$7951, #$79EB, #$79EC, #$79E0, #$79EE, #$79ED,
      #$79EA, #$79DC, #$79DE, #$79DD, #$7A86, #$7A89, #$7A85, #$7A8B,
      #$7A8C, #$7A8A, #$7A87, #$7AD8, #$7B10,
      #$7B04, #$7B13, #$7B05, #$7B0F, #$7B08, #$7B0A, #$7B0E, #$7B09,
      #$7B12, #$7C84, #$7C91, #$7C8A, #$7C8C, #$7C88, #$7C8D, #$7C85,
      #$7D1E, #$7D1D, #$7D11, #$7D0E, #$7D18, #$7D16, #$7D13, #$7D1F,
      #$7D12, #$7D0F, #$7D0C, #$7F5C, #$7F61, #$7F5E, #$7F60, #$7F5D,
      #$7F5B, #$7F96, #$7F92, #$7FC3, #$7FC2, #$7FC0, #$8016, #$803E,
      #$8039, #$80FA, #$80F2, #$80F9, #$80F5, #$8101, #$80FB, #$8100,
      #$8201, #$822F, #$8225, #$8333, #$832D, #$8344, #$8319, #$8351,
      #$8325, #$8356, #$833F, #$8341, #$8326, #$831C, #$8322, #$8342,
      #$834E, #$831B, #$832A, #$8308, #$833C, #$834D, #$8316, #$8324,
      #$8320, #$8337, #$832F, #$8329, #$8347, #$8345, #$834C, #$8353,
      #$831E, #$832C, #$834B, #$8327, #$8348, #$8653, #$8652, #$86A2,
      #$86A8, #$8696, #$868D, #$8691, #$869E, #$8687, #$8697, #$8686,
      #$868B, #$869A, #$8685, #$86A5, #$8699, #$86A1, #$86A7, #$8695,
      #$8698, #$868E, #$869D, #$8690, #$8694, #$8843, #$8844, #$886D,
      #$8875, #$8876, #$8872, #$8880, #$8871, #$887F, #$886F, #$8883,
      #$887E, #$8874, #$887C, #$8A12, #$8C47, #$8C57, #$8C7B, #$8CA4,
      #$8CA3, #$8D76, #$8D78, #$8DB5, #$8DB7, #$8DB6, #$8ED1, #$8ED3,
      #$8FFE, #$8FF5, #$9002, #$8FFF, #$8FFB, #$9004, #$8FFC, #$8FF6,
      #$90D6, #$90E0, #$90D9, #$90DA, #$90E3, #$90DF, #$90E5, #$90D8,
      #$90DB, #$90D7, #$90DC, #$90E4, #$9150,
      #$914E, #$914F, #$91D5, #$91E2, #$91DA, #$965C, #$965F, #$96BC,
      #$98E3, #$9ADF, #$9B2F, #$4E7F, #$5070, #$506A, #$5061, #$505E,
      #$5060, #$5053, #$504B, #$505D, #$5072, #$5048, #$504D, #$5041,
      #$505B, #$504A, #$5062, #$5015, #$5045, #$505F, #$5069, #$506B,
      #$5063, #$5064, #$5046, #$5040, #$506E, #$5073, #$5057, #$5051,
      #$51D0, #$526B, #$526D, #$526C, #$526E, #$52D6, #$52D3, #$532D,
      #$539C, #$5575, #$5576, #$553C, #$554D, #$5550, #$5534, #$552A,
      #$5551, #$5562, #$5536, #$5535, #$5530, #$5552, #$5545, #$550C,
      #$5532, #$5565, #$554E, #$5539, #$5548, #$552D, #$553B, #$5540,
      #$554B, #$570A, #$5707, #$57FB, #$5814, #$57E2, #$57F6, #$57DC,
      #$57F4, #$5800, #$57ED, #$57FD, #$5808, #$57F8, #$580B, #$57F3,
      #$57CF, #$5807, #$57EE, #$57E3, #$57F2, #$57E5, #$57EC, #$57E1,
      #$580E, #$57FC, #$5810, #$57E7, #$5801, #$580C, #$57F1, #$57E9,
      #$57F0, #$580D, #$5804, #$595C, #$5A60, #$5A58, #$5A55, #$5A67,
      #$5A5E, #$5A38, #$5A35, #$5A6D, #$5A50, #$5A5F, #$5A65, #$5A6C,
      #$5A53, #$5A64, #$5A57, #$5A43, #$5A5D, #$5A52, #$5A44, #$5A5B,
      #$5A48, #$5A8E, #$5A3E, #$5A4D, #$5A39, #$5A4C, #$5A70, #$5A69,
      #$5A47, #$5A51, #$5A56, #$5A42, #$5A5C, #$5B72, #$5B6E, #$5BC1,
      #$5BC0, #$5C59, #$5D1E, #$5D0B, #$5D1D, #$5D1A, #$5D20, #$5D0C,
      #$5D28, #$5D0D, #$5D26, #$5D25, #$5D0F,
      #$5D30, #$5D12, #$5D23, #$5D1F, #$5D2E, #$5E3E, #$5E34, #$5EB1,
      #$5EB4, #$5EB9, #$5EB2, #$5EB3, #$5F36, #$5F38, #$5F9B, #$5F96,
      #$5F9F, #$608A, #$6090, #$6086, #$60BE, #$60B0, #$60BA, #$60D3,
      #$60D4, #$60CF, #$60E4, #$60D9, #$60DD, #$60C8, #$60B1, #$60DB,
      #$60B7, #$60CA, #$60BF, #$60C3, #$60CD, #$60C0, #$6332, #$6365,
      #$638A, #$6382, #$637D, #$63BD, #$639E, #$63AD, #$639D, #$6397,
      #$63AB, #$638E, #$636F, #$6387, #$6390, #$636E, #$63AF, #$6375,
      #$639C, #$636D, #$63AE, #$637C, #$63A4, #$633B, #$639F, #$6378,
      #$6385, #$6381, #$6391, #$638D, #$6370, #$6553, #$65CD, #$6665,
      #$6661, #$665B, #$6659, #$665C, #$6662, #$6718, #$6879, #$6887,
      #$6890, #$689C, #$686D, #$686E, #$68AE, #$68AB, #$6956, #$686F,
      #$68A3, #$68AC, #$68A9, #$6875, #$6874, #$68B2, #$688F, #$6877,
      #$6892, #$687C, #$686B, #$6872, #$68AA, #$6880, #$6871, #$687E,
      #$689B, #$6896, #$688B, #$68A0, #$6889, #$68A4, #$6878, #$687B,
      #$6891, #$688C, #$688A, #$687D, #$6B36, #$6B33, #$6B37, #$6B38,
      #$6B91, #$6B8F, #$6B8D, #$6B8E, #$6B8C, #$6C2A, #$6DC0, #$6DAB,
      #$6DB4, #$6DB3, #$6E74, #$6DAC, #$6DE9, #$6DE2, #$6DB7, #$6DF6,
      #$6DD4, #$6E00, #$6DC8, #$6DE0, #$6DDF, #$6DD6, #$6DBE, #$6DE5,
      #$6DDC, #$6DDD, #$6DDB, #$6DF4, #$6DCA, #$6DBD, #$6DED, #$6DF0,
      #$6DBA, #$6DD5, #$6DC2, #$6DCF, #$6DC9,
      #$6DD0, #$6DF2, #$6DD3, #$6DFD, #$6DD7, #$6DCD, #$6DE3, #$6DBB,
      #$70FA, #$710D, #$70F7, #$7117, #$70F4, #$710C, #$70F0, #$7104,
      #$70F3, #$7110, #$70FC, #$70FF, #$7106, #$7113, #$7100, #$70F8,
      #$70F6, #$710B, #$7102, #$710E, #$727E, #$727B, #$727C, #$727F,
      #$731D, #$7317, #$7307, #$7311, #$7318, #$730A, #$7308, #$72FF,
      #$730F, #$731E, #$7388, #$73F6, #$73F8, #$73F5, #$7404, #$7401,
      #$73FD, #$7407, #$7400, #$73FA, #$73FC, #$73FF, #$740C, #$740B,
      #$73F4, #$7408, #$7564, #$7563, #$75CE, #$75D2, #$75CF, #$75CB,
      #$75CC, #$75D1, #$75D0, #$768F, #$7689, #$76D3, #$7739, #$772F,
      #$772D, #$7731, #$7732, #$7734, #$7733, #$773D, #$7725, #$773B,
      #$7735, #$7848, #$7852, #$7849, #$784D, #$784A, #$784C, #$7826,
      #$7845, #$7850, #$7964, #$7967, #$7969, #$796A, #$7963, #$796B,
      #$7961, #$79BB, #$79FA, #$79F8, #$79F6, #$79F7, #$7A8F, #$7A94,
      #$7A90, #$7B35, #$7B47, #$7B34, #$7B25, #$7B30, #$7B22, #$7B24,
      #$7B33, #$7B18, #$7B2A, #$7B1D, #$7B31, #$7B2B, #$7B2D, #$7B2F,
      #$7B32, #$7B38, #$7B1A, #$7B23, #$7C94, #$7C98, #$7C96, #$7CA3,
      #$7D35, #$7D3D, #$7D38, #$7D36, #$7D3A, #$7D45, #$7D2C, #$7D29,
      #$7D41, #$7D47, #$7D3E, #$7D3F, #$7D4A, #$7D3B, #$7D28, #$7F63,
      #$7F95, #$7F9C, #$7F9D, #$7F9B, #$7FCA, #$7FCB, #$7FCD, #$7FD0,
      #$7FD1, #$7FC7, #$7FCF, #$7FC9, #$801F,
      #$801E, #$801B, #$8047, #$8043, #$8048, #$8118, #$8125, #$8119,
      #$811B, #$812D, #$811F, #$812C, #$811E, #$8121, #$8115, #$8127,
      #$811D, #$8122, #$8211, #$8238, #$8233, #$823A, #$8234, #$8232,
      #$8274, #$8390, #$83A3, #$83A8, #$838D, #$837A, #$8373, #$83A4,
      #$8374, #$838F, #$8381, #$8395, #$8399, #$8375, #$8394, #$83A9,
      #$837D, #$8383, #$838C, #$839D, #$839B, #$83AA, #$838B, #$837E,
      #$83A5, #$83AF, #$8388, #$8397, #$83B0, #$837F, #$83A6, #$8387,
      #$83AE, #$8376, #$839A, #$8659, #$8656, #$86BF, #$86B7, #$86C2,
      #$86C1, #$86C5, #$86BA, #$86B0, #$86C8, #$86B9, #$86B3, #$86B8,
      #$86CC, #$86B4, #$86BB, #$86BC, #$86C3, #$86BD, #$86BE, #$8852,
      #$8889, #$8895, #$88A8, #$88A2, #$88AA, #$889A, #$8891, #$88A1,
      #$889F, #$8898, #$88A7, #$8899, #$889B, #$8897, #$88A4, #$88AC,
      #$888C, #$8893, #$888E, #$8982, #$89D6, #$89D9, #$89D5, #$8A30,
      #$8A27, #$8A2C, #$8A1E, #$8C39, #$8C3B, #$8C5C, #$8C5D, #$8C7D,
      #$8CA5, #$8D7D, #$8D7B, #$8D79, #$8DBC, #$8DC2, #$8DB9, #$8DBF,
      #$8DC1, #$8ED8, #$8EDE, #$8EDD, #$8EDC, #$8ED7, #$8EE0, #$8EE1,
      #$9024, #$900B, #$9011, #$901C, #$900C, #$9021, #$90EF, #$90EA,
      #$90F0, #$90F4, #$90F2, #$90F3, #$90D4, #$90EB, #$90EC, #$90E9,
      #$9156, #$9158, #$915A, #$9153, #$9155, #$91EC, #$91F4, #$91F1,
      #$91F3, #$91F8, #$91E4, #$91F9, #$91EA,
      #$91EB, #$91F7, #$91E8, #$91EE, #$957A, #$9586, #$9588, #$967C,
      #$966D, #$966B, #$9671, #$966F, #$96BF, #$976A, #$9804, #$98E5,
      #$9997, #$509B, #$5095, #$5094, #$509E, #$508B, #$50A3, #$5083,
      #$508C, #$508E, #$509D, #$5068, #$509C, #$5092, #$5082, #$5087,
      #$515F, #$51D4, #$5312, #$5311, #$53A4, #$53A7, #$5591, #$55A8,
      #$55A5, #$55AD, #$5577, #$5645, #$55A2, #$5593, #$5588, #$558F,
      #$55B5, #$5581, #$55A3, #$5592, #$55A4, #$557D, #$558C, #$55A6,
      #$557F, #$5595, #$55A1, #$558E, #$570C, #$5829, #$5837, #$5819,
      #$581E, #$5827, #$5823, #$5828, #$57F5, #$5848, #$5825, #$581C,
      #$581B, #$5833, #$583F, #$5836, #$582E, #$5839, #$5838, #$582D,
      #$582C, #$583B, #$5961, #$5AAF, #$5A94, #$5A9F, #$5A7A, #$5AA2,
      #$5A9E, #$5A78, #$5AA6, #$5A7C, #$5AA5, #$5AAC, #$5A95, #$5AAE,
      #$5A37, #$5A84, #$5A8A, #$5A97, #$5A83, #$5A8B, #$5AA9, #$5A7B,
      #$5A7D, #$5A8C, #$5A9C, #$5A8F, #$5A93, #$5A9D, #$5BEA, #$5BCD,
      #$5BCB, #$5BD4, #$5BD1, #$5BCA, #$5BCE, #$5C0C, #$5C30, #$5D37,
      #$5D43, #$5D6B, #$5D41, #$5D4B, #$5D3F, #$5D35, #$5D51, #$5D4E,
      #$5D55, #$5D33, #$5D3A, #$5D52, #$5D3D, #$5D31, #$5D59, #$5D42,
      #$5D39, #$5D49, #$5D38, #$5D3C, #$5D32, #$5D36, #$5D40, #$5D45,
      #$5E44, #$5E41, #$5F58, #$5FA6, #$5FA5, #$5FAB, #$60C9, #$60B9,
      #$60CC, #$60E2, #$60CE, #$60C4, #$6114,
      #$60F2, #$610A, #$6116, #$6105, #$60F5, #$6113, #$60F8, #$60FC,
      #$60FE, #$60C1, #$6103, #$6118, #$611D, #$6110, #$60FF, #$6104,
      #$610B, #$624A, #$6394, #$63B1, #$63B0, #$63CE, #$63E5, #$63E8,
      #$63EF, #$63C3, #$649D, #$63F3, #$63CA, #$63E0, #$63F6, #$63D5,
      #$63F2, #$63F5, #$6461, #$63DF, #$63BE, #$63DD, #$63DC, #$63C4,
      #$63D8, #$63D3, #$63C2, #$63C7, #$63CC, #$63CB, #$63C8, #$63F0,
      #$63D7, #$63D9, #$6532, #$6567, #$656A, #$6564, #$655C, #$6568,
      #$6565, #$658C, #$659D, #$659E, #$65AE, #$65D0, #$65D2, #$667C,
      #$666C, #$667B, #$6680, #$6671, #$6679, #$666A, #$6672, #$6701,
      #$690C, #$68D3, #$6904, #$68DC, #$692A, #$68EC, #$68EA, #$68F1,
      #$690F, #$68D6, #$68F7, #$68EB, #$68E4, #$68F6, #$6913, #$6910,
      #$68F3, #$68E1, #$6907, #$68CC, #$6908, #$6970, #$68B4, #$6911,
      #$68EF, #$68C6, #$6914, #$68F8, #$68D0, #$68FD, #$68FC, #$68E8,
      #$690B, #$690A, #$6917, #$68CE, #$68C8, #$68DD, #$68DE, #$68E6,
      #$68F4, #$68D1, #$6906, #$68D4, #$68E9, #$6915, #$6925, #$68C7,
      #$6B39, #$6B3B, #$6B3F, #$6B3C, #$6B94, #$6B97, #$6B99, #$6B95,
      #$6BBD, #$6BF0, #$6BF2, #$6BF3, #$6C30, #$6DFC, #$6E46, #$6E47,
      #$6E1F, #$6E49, #$6E88, #$6E3C, #$6E3D, #$6E45, #$6E62, #$6E2B,
      #$6E3F, #$6E41, #$6E5D, #$6E73, #$6E1C, #$6E33, #$6E4B, #$6E40,
      #$6E51, #$6E3B, #$6E03, #$6E2E, #$6E5E,
      #$6E68, #$6E5C, #$6E61, #$6E31, #$6E28, #$6E60, #$6E71, #$6E6B,
      #$6E39, #$6E22, #$6E30, #$6E53, #$6E65, #$6E27, #$6E78, #$6E64,
      #$6E77, #$6E55, #$6E79, #$6E52, #$6E66, #$6E35, #$6E36, #$6E5A,
      #$7120, #$711E, #$712F, #$70FB, #$712E, #$7131, #$7123, #$7125,
      #$7122, #$7132, #$711F, #$7128, #$713A, #$711B, #$724B, #$725A,
      #$7288, #$7289, #$7286, #$7285, #$728B, #$7312, #$730B, #$7330,
      #$7322, #$7331, #$7333, #$7327, #$7332, #$732D, #$7326, #$7323,
      #$7335, #$730C, #$742E, #$742C, #$7430, #$742B, #$7416, #$741A,
      #$7421, #$742D, #$7431, #$7424, #$7423, #$741D, #$7429, #$7420,
      #$7432, #$74FB, #$752F, #$756F, #$756C, #$75E7, #$75DA, #$75E1,
      #$75E6, #$75DD, #$75DF, #$75E4, #$75D7, #$7695, #$7692, #$76DA,
      #$7746, #$7747, #$7744, #$774D, #$7745, #$774A, #$774E, #$774B,
      #$774C, #$77DE, #$77EC, #$7860, #$7864, #$7865, #$785C, #$786D,
      #$7871, #$786A, #$786E, #$7870, #$7869, #$7868, #$785E, #$7862,
      #$7974, #$7973, #$7972, #$7970, #$7A02, #$7A0A, #$7A03, #$7A0C,
      #$7A04, #$7A99, #$7AE6, #$7AE4, #$7B4A, #$7B3B, #$7B44, #$7B48,
      #$7B4C, #$7B4E, #$7B40, #$7B58, #$7B45, #$7CA2, #$7C9E, #$7CA8,
      #$7CA1, #$7D58, #$7D6F, #$7D63, #$7D53, #$7D56, #$7D67, #$7D6A,
      #$7D4F, #$7D6D, #$7D5C, #$7D6B, #$7D52, #$7D54, #$7D69, #$7D51,
      #$7D5F, #$7D4E, #$7F3E, #$7F3F, #$7F65,
      #$7F66, #$7FA2, #$7FA0, #$7FA1, #$7FD7, #$8051, #$804F, #$8050,
      #$80FE, #$80D4, #$8143, #$814A, #$8152, #$814F, #$8147, #$813D,
      #$814D, #$813A, #$81E6, #$81EE, #$81F7, #$81F8, #$81F9, #$8204,
      #$823C, #$823D, #$823F, #$8275, #$833B, #$83CF, #$83F9, #$8423,
      #$83C0, #$83E8, #$8412, #$83E7, #$83E4, #$83FC, #$83F6, #$8410,
      #$83C6, #$83C8, #$83EB, #$83E3, #$83BF, #$8401, #$83DD, #$83E5,
      #$83D8, #$83FF, #$83E1, #$83CB, #$83CE, #$83D6, #$83F5, #$83C9,
      #$8409, #$840F, #$83DE, #$8411, #$8406, #$83C2, #$83F3, #$83D5,
      #$83FA, #$83C7, #$83D1, #$83EA, #$8413, #$83C3, #$83EC, #$83EE,
      #$83C4, #$83FB, #$83D7, #$83E2, #$841B, #$83DB, #$83FE, #$86D8,
      #$86E2, #$86E6, #$86D3, #$86E3, #$86DA, #$86EA, #$86DD, #$86EB,
      #$86DC, #$86EC, #$86E9, #$86D7, #$86E8, #$86D1, #$8848, #$8856,
      #$8855, #$88BA, #$88D7, #$88B9, #$88B8, #$88C0, #$88BE, #$88B6,
      #$88BC, #$88B7, #$88BD, #$88B2, #$8901, #$88C9, #$8995, #$8998,
      #$8997, #$89DD, #$89DA, #$89DB, #$8A4E, #$8A4D, #$8A39, #$8A59,
      #$8A40, #$8A57, #$8A58, #$8A44, #$8A45, #$8A52, #$8A48, #$8A51,
      #$8A4A, #$8A4C, #$8A4F, #$8C5F, #$8C81, #$8C80, #$8CBA, #$8CBE,
      #$8CB0, #$8CB9, #$8CB5, #$8D84, #$8D80, #$8D89, #$8DD8, #$8DD3,
      #$8DCD, #$8DC7, #$8DD6, #$8DDC, #$8DCF, #$8DD5, #$8DD9, #$8DC8,
      #$8DD7, #$8DC5, #$8EEF, #$8EF7, #$8EFA,
      #$8EF9, #$8EE6, #$8EEE, #$8EE5, #$8EF5, #$8EE7, #$8EE8, #$8EF6,
      #$8EEB, #$8EF1, #$8EEC, #$8EF4, #$8EE9, #$902D, #$9034, #$902F,
      #$9106, #$912C, #$9104, #$90FF, #$90FC, #$9108, #$90F9, #$90FB,
      #$9101, #$9100, #$9107, #$9105, #$9103, #$9161, #$9164, #$915F,
      #$9162, #$9160, #$9201, #$920A, #$9225, #$9203, #$921A, #$9226,
      #$920F, #$920C, #$9200, #$9212, #$91FF, #$91FD, #$9206, #$9204,
      #$9227, #$9202, #$921C, #$9224, #$9219, #$9217, #$9205, #$9216,
      #$957B, #$958D, #$958C, #$9590, #$9687, #$967E, #$9688, #$9689,
      #$9683, #$9680, #$96C2, #$96C8, #$96C3, #$96F1, #$96F0, #$976C,
      #$9770, #$976E, #$9807, #$98A9, #$98EB, #$9CE6, #$9EF9, #$4E83,
      #$4E84, #$4EB6, #$50BD, #$50BF, #$50C6, #$50AE, #$50C4, #$50CA,
      #$50B4, #$50C8, #$50C2, #$50B0, #$50C1, #$50BA, #$50B1, #$50CB,
      #$50C9, #$50B6, #$50B8, #$51D7, #$527A, #$5278, #$527B, #$527C,
      #$55C3, #$55DB, #$55CC, #$55D0, #$55CB, #$55CA, #$55DD, #$55C0,
      #$55D4, #$55C4, #$55E9, #$55BF, #$55D2, #$558D, #$55CF, #$55D5,
      #$55E2, #$55D6, #$55C8, #$55F2, #$55CD, #$55D9, #$55C2, #$5714,
      #$5853, #$5868, #$5864, #$584F, #$584D, #$5849, #$586F, #$5855,
      #$584E, #$585D, #$5859, #$5865, #$585B, #$583D, #$5863, #$5871,
      #$58FC, #$5AC7, #$5AC4, #$5ACB, #$5ABA, #$5AB8, #$5AB1, #$5AB5,
      #$5AB0, #$5ABF, #$5AC8, #$5ABB, #$5AC6,
      #$5AB7, #$5AC0, #$5ACA, #$5AB4, #$5AB6, #$5ACD, #$5AB9, #$5A90,
      #$5BD6, #$5BD8, #$5BD9, #$5C1F, #$5C33, #$5D71, #$5D63, #$5D4A,
      #$5D65, #$5D72, #$5D6C, #$5D5E, #$5D68, #$5D67, #$5D62, #$5DF0,
      #$5E4F, #$5E4E, #$5E4A, #$5E4D, #$5E4B, #$5EC5, #$5ECC, #$5EC6,
      #$5ECB, #$5EC7, #$5F40, #$5FAF, #$5FAD, #$60F7, #$6149, #$614A,
      #$612B, #$6145, #$6136, #$6132, #$612E, #$6146, #$612F, #$614F,
      #$6129, #$6140, #$6220, #$9168, #$6223, #$6225, #$6224, #$63C5,
      #$63F1, #$63EB, #$6410, #$6412, #$6409, #$6420, #$6424, #$6433,
      #$6443, #$641F, #$6415, #$6418, #$6439, #$6437, #$6422, #$6423,
      #$640C, #$6426, #$6430, #$6428, #$6441, #$6435, #$642F, #$640A,
      #$641A, #$6440, #$6425, #$6427, #$640B, #$63E7, #$641B, #$642E,
      #$6421, #$640E, #$656F, #$6592, #$65D3, #$6686, #$668C, #$6695,
      #$6690, #$668B, #$668A, #$6699, #$6694, #$6678, #$6720, #$6966,
      #$695F, #$6938, #$694E, #$6962, #$6971, #$693F, #$6945, #$696A,
      #$6939, #$6942, #$6957, #$6959, #$697A, #$6948, #$6949, #$6935,
      #$696C, #$6933, #$693D, #$6965, #$68F0, #$6978, #$6934, #$6969,
      #$6940, #$696F, #$6944, #$6976, #$6958, #$6941, #$6974, #$694C,
      #$693B, #$694B, #$6937, #$695C, #$694F, #$6951, #$6932, #$6952,
      #$692F, #$697B, #$693C, #$6B46, #$6B45, #$6B43, #$6B42, #$6B48,
      #$6B41, #$6B9B, #$FA0D, #$6BFB, #$6BFC,
      #$6BF9, #$6BF7, #$6BF8, #$6E9B, #$6ED6, #$6EC8, #$6E8F, #$6EC0,
      #$6E9F, #$6E93, #$6E94, #$6EA0, #$6EB1, #$6EB9, #$6EC6, #$6ED2,
      #$6EBD, #$6EC1, #$6E9E, #$6EC9, #$6EB7, #$6EB0, #$6ECD, #$6EA6,
      #$6ECF, #$6EB2, #$6EBE, #$6EC3, #$6EDC, #$6ED8, #$6E99, #$6E92,
      #$6E8E, #$6E8D, #$6EA4, #$6EA1, #$6EBF, #$6EB3, #$6ED0, #$6ECA,
      #$6E97, #$6EAE, #$6EA3, #$7147, #$7154, #$7152, #$7163, #$7160,
      #$7141, #$715D, #$7162, #$7172, #$7178, #$716A, #$7161, #$7142,
      #$7158, #$7143, #$714B, #$7170, #$715F, #$7150, #$7153, #$7144,
      #$714D, #$715A, #$724F, #$728D, #$728C, #$7291, #$7290, #$728E,
      #$733C, #$7342, #$733B, #$733A, #$7340, #$734A, #$7349, #$7444,
      #$744A, #$744B, #$7452, #$7451, #$7457, #$7440, #$744F, #$7450,
      #$744E, #$7442, #$7446, #$744D, #$7454, #$74E1, #$74FF, #$74FE,
      #$74FD, #$751D, #$7579, #$7577, #$6983, #$75EF, #$760F, #$7603,
      #$75F7, #$75FE, #$75FC, #$75F9, #$75F8, #$7610, #$75FB, #$75F6,
      #$75ED, #$75F5, #$75FD, #$7699, #$76B5, #$76DD, #$7755, #$775F,
      #$7760, #$7752, #$7756, #$775A, #$7769, #$7767, #$7754, #$7759,
      #$776D, #$77E0, #$7887, #$789A, #$7894, #$788F, #$7884, #$7895,
      #$7885, #$7886, #$78A1, #$7883, #$7879, #$7899, #$7880, #$7896,
      #$787B, #$797C, #$7982, #$797D, #$7979, #$7A11, #$7A18, #$7A19,
      #$7A12, #$7A17, #$7A15, #$7A22, #$7A13,
      #$7A1B, #$7A10, #$7AA3, #$7AA2, #$7A9E, #$7AEB, #$7B66, #$7B64,
      #$7B6D, #$7B74, #$7B69, #$7B72, #$7B65, #$7B73, #$7B71, #$7B70,
      #$7B61, #$7B78, #$7B76, #$7B63, #$7CB2, #$7CB4, #$7CAF, #$7D88,
      #$7D86, #$7D80, #$7D8D, #$7D7F, #$7D85, #$7D7A, #$7D8E, #$7D7B,
      #$7D83, #$7D7C, #$7D8C, #$7D94, #$7D84, #$7D7D, #$7D92, #$7F6D,
      #$7F6B, #$7F67, #$7F68, #$7F6C, #$7FA6, #$7FA5, #$7FA7, #$7FDB,
      #$7FDC, #$8021, #$8164, #$8160, #$8177, #$815C, #$8169, #$815B,
      #$8162, #$8172, #$6721, #$815E, #$8176, #$8167, #$816F, #$8144,
      #$8161, #$821D, #$8249, #$8244, #$8240, #$8242, #$8245, #$84F1,
      #$843F, #$8456, #$8476, #$8479, #$848F, #$848D, #$8465, #$8451,
      #$8440, #$8486, #$8467, #$8430, #$844D, #$847D, #$845A, #$8459,
      #$8474, #$8473, #$845D, #$8507, #$845E, #$8437, #$843A, #$8434,
      #$847A, #$8443, #$8478, #$8432, #$8445, #$8429, #$83D9, #$844B,
      #$842F, #$8442, #$842D, #$845F, #$8470, #$8439, #$844E, #$844C,
      #$8452, #$846F, #$84C5, #$848E, #$843B, #$8447, #$8436, #$8433,
      #$8468, #$847E, #$8444, #$842B, #$8460, #$8454, #$846E, #$8450,
      #$870B, #$8704, #$86F7, #$870C, #$86FA, #$86D6, #$86F5, #$874D,
      #$86F8, #$870E, #$8709, #$8701, #$86F6, #$870D, #$8705, #$88D6,
      #$88CB, #$88CD, #$88CE, #$88DE, #$88DB, #$88DA, #$88CC, #$88D0,
      #$8985, #$899B, #$89DF, #$89E5, #$89E4,
      #$89E1, #$89E0, #$89E2, #$89DC, #$89E6, #$8A76, #$8A86, #$8A7F,
      #$8A61, #$8A3F, #$8A77, #$8A82, #$8A84, #$8A75, #$8A83, #$8A81,
      #$8A74, #$8A7A, #$8C3C, #$8C4B, #$8C4A, #$8C65, #$8C64, #$8C66,
      #$8C86, #$8C84, #$8C85, #$8CCC, #$8D68, #$8D69, #$8D91, #$8D8C,
      #$8D8E, #$8D8F, #$8D8D, #$8D93, #$8D94, #$8D90, #$8D92, #$8DF0,
      #$8DE0, #$8DEC, #$8DF1, #$8DEE, #$8DD0, #$8DE9, #$8DE3, #$8DE2,
      #$8DE7, #$8DF2, #$8DEB, #$8DF4, #$8F06, #$8EFF, #$8F01, #$8F00,
      #$8F05, #$8F07, #$8F08, #$8F02, #$8F0B, #$9052, #$903F, #$9044,
      #$9049, #$903D, #$9110, #$910D, #$910F, #$9111, #$9116, #$9114,
      #$910B, #$910E, #$916E, #$916F, #$9248, #$9252, #$9230, #$923A,
      #$9266, #$9233, #$9265, #$925E, #$9283, #$922E, #$924A, #$9246,
      #$926D, #$926C, #$924F, #$9260, #$9267, #$926F, #$9236, #$9261,
      #$9270, #$9231, #$9254, #$9263, #$9250, #$9272, #$924E, #$9253,
      #$924C, #$9256, #$9232, #$959F, #$959C, #$959E, #$959B, #$9692,
      #$9693, #$9691, #$9697, #$96CE, #$96FA, #$96FD, #$96F8, #$96F5,
      #$9773, #$9777, #$9778, #$9772, #$980F, #$980D, #$980E, #$98AC,
      #$98F6, #$98F9, #$99AF, #$99B2, #$99B0, #$99B5, #$9AAD, #$9AAB,
      #$9B5B, #$9CEA, #$9CED, #$9CE7, #$9E80, #$9EFD, #$50E6, #$50D4,
      #$50D7, #$50E8, #$50F3, #$50DB, #$50EA, #$50DD, #$50E4, #$50D3,
      #$50EC, #$50F0, #$50EF, #$50E3, #$50E0,
      #$51D8, #$5280, #$5281, #$52E9, #$52EB, #$5330, #$53AC, #$5627,
      #$5615, #$560C, #$5612, #$55FC, #$560F, #$561C, #$5601, #$5613,
      #$5602, #$55FA, #$561D, #$5604, #$55FF, #$55F9, #$5889, #$587C,
      #$5890, #$5898, #$5886, #$5881, #$587F, #$5874, #$588B, #$587A,
      #$5887, #$5891, #$588E, #$5876, #$5882, #$5888, #$587B, #$5894,
      #$588F, #$58FE, #$596B, #$5ADC, #$5AEE, #$5AE5, #$5AD5, #$5AEA,
      #$5ADA, #$5AED, #$5AEB, #$5AF3, #$5AE2, #$5AE0, #$5ADB, #$5AEC,
      #$5ADE, #$5ADD, #$5AD9, #$5AE8, #$5ADF, #$5B77, #$5BE0, #$5BE3,
      #$5C63, #$5D82, #$5D80, #$5D7D, #$5D86, #$5D7A, #$5D81, #$5D77,
      #$5D8A, #$5D89, #$5D88, #$5D7E, #$5D7C, #$5D8D, #$5D79, #$5D7F,
      #$5E58, #$5E59, #$5E53, #$5ED8, #$5ED1, #$5ED7, #$5ECE, #$5EDC,
      #$5ED5, #$5ED9, #$5ED2, #$5ED4, #$5F44, #$5F43, #$5F6F, #$5FB6,
      #$612C, #$6128, #$6141, #$615E, #$6171, #$6173, #$6152, #$6153,
      #$6172, #$616C, #$6180, #$6174, #$6154, #$617A, #$615B, #$6165,
      #$613B, #$616A, #$6161, #$6156, #$6229, #$6227, #$622B, #$642B,
      #$644D, #$645B, #$645D, #$6474, #$6476, #$6472, #$6473, #$647D,
      #$6475, #$6466, #$64A6, #$644E, #$6482, #$645E, #$645C, #$644B,
      #$6453, #$6460, #$6450, #$647F, #$643F, #$646C, #$646B, #$6459,
      #$6465, #$6477, #$6573, #$65A0, #$66A1, #$66A0, #$669F, #$6705,
      #$6704, #$6722, #$69B1, #$69B6, #$69C9,
      #$69A0, #$69CE, #$6996, #$69B0, #$69AC, #$69BC, #$6991, #$6999,
      #$698E, #$69A7, #$698D, #$69A9, #$69BE, #$69AF, #$69BF, #$69C4,
      #$69BD, #$69A4, #$69D4, #$69B9, #$69CA, #$699A, #$69CF, #$69B3,
      #$6993, #$69AA, #$69A1, #$699E, #$69D9, #$6997, #$6990, #$69C2,
      #$69B5, #$69A5, #$69C6, #$6B4A, #$6B4D, #$6B4B, #$6B9E, #$6B9F,
      #$6BA0, #$6BC3, #$6BC4, #$6BFE, #$6ECE, #$6EF5, #$6EF1, #$6F03,
      #$6F25, #$6EF8, #$6F37, #$6EFB, #$6F2E, #$6F09, #$6F4E, #$6F19,
      #$6F1A, #$6F27, #$6F18, #$6F3B, #$6F12, #$6EED, #$6F0A, #$6F36,
      #$6F73, #$6EF9, #$6EEE, #$6F2D, #$6F40, #$6F30, #$6F3C, #$6F35,
      #$6EEB, #$6F07, #$6F0E, #$6F43, #$6F05, #$6EFD, #$6EF6, #$6F39,
      #$6F1C, #$6EFC, #$6F3A, #$6F1F, #$6F0D, #$6F1E, #$6F08, #$6F21,
      #$7187, #$7190, #$7189, #$7180, #$7185, #$7182, #$718F, #$717B,
      #$7186, #$7181, #$7197, #$7244, #$7253, #$7297, #$7295, #$7293,
      #$7343, #$734D, #$7351, #$734C, #$7462, #$7473, #$7471, #$7475,
      #$7472, #$7467, #$746E, #$7500, #$7502, #$7503, #$757D, #$7590,
      #$7616, #$7608, #$760C, #$7615, #$7611, #$760A, #$7614, #$76B8,
      #$7781, #$777C, #$7785, #$7782, #$776E, #$7780, #$776F, #$777E,
      #$7783, #$78B2, #$78AA, #$78B4, #$78AD, #$78A8, #$787E, #$78AB,
      #$789E, #$78A5, #$78A0, #$78AC, #$78A2, #$78A4, #$7998, #$798A,
      #$798B, #$7996, #$7995, #$7994, #$7993,
      #$7997, #$7988, #$7992, #$7990, #$7A2B, #$7A4A, #$7A30, #$7A2F,
      #$7A28, #$7A26, #$7AA8, #$7AAB, #$7AAC, #$7AEE, #$7B88, #$7B9C,
      #$7B8A, #$7B91, #$7B90, #$7B96, #$7B8D, #$7B8C, #$7B9B, #$7B8E,
      #$7B85, #$7B98, #$5284, #$7B99, #$7BA4, #$7B82, #$7CBB, #$7CBF,
      #$7CBC, #$7CBA, #$7DA7, #$7DB7, #$7DC2, #$7DA3, #$7DAA, #$7DC1,
      #$7DC0, #$7DC5, #$7D9D, #$7DCE, #$7DC4, #$7DC6, #$7DCB, #$7DCC,
      #$7DAF, #$7DB9, #$7D96, #$7DBC, #$7D9F, #$7DA6, #$7DAE, #$7DA9,
      #$7DA1, #$7DC9, #$7F73, #$7FE2, #$7FE3, #$7FE5, #$7FDE, #$8024,
      #$805D, #$805C, #$8189, #$8186, #$8183, #$8187, #$818D, #$818C,
      #$818B, #$8215, #$8497, #$84A4, #$84A1, #$849F, #$84BA, #$84CE,
      #$84C2, #$84AC, #$84AE, #$84AB, #$84B9, #$84B4, #$84C1, #$84CD,
      #$84AA, #$849A, #$84B1, #$84D0, #$849D, #$84A7, #$84BB, #$84A2,
      #$8494, #$84C7, #$84CC, #$849B, #$84A9, #$84AF, #$84A8, #$84D6,
      #$8498, #$84B6, #$84CF, #$84A0, #$84D7, #$84D4, #$84D2, #$84DB,
      #$84B0, #$8491, #$8661, #$8733, #$8723, #$8728, #$876B, #$8740,
      #$872E, #$871E, #$8721, #$8719, #$871B, #$8743, #$872C, #$8741,
      #$873E, #$8746, #$8720, #$8732, #$872A, #$872D, #$873C, #$8712,
      #$873A, #$8731, #$8735, #$8742, #$8726, #$8727, #$8738, #$8724,
      #$871A, #$8730, #$8711, #$88F7, #$88E7, #$88F1, #$88F2, #$88FA,
      #$88FE, #$88EE, #$88FC, #$88F6, #$88FB,
      #$88F0, #$88EC, #$88EB, #$899D, #$89A1, #$899F, #$899E, #$89E9,
      #$89EB, #$89E8, #$8AAB, #$8A99, #$8A8B, #$8A92, #$8A8F, #$8A96,
      #$8C3D, #$8C68, #$8C69, #$8CD5, #$8CCF, #$8CD7, #$8D96, #$8E09,
      #$8E02, #$8DFF, #$8E0D, #$8DFD, #$8E0A, #$8E03, #$8E07, #$8E06,
      #$8E05, #$8DFE, #$8E00, #$8E04, #$8F10, #$8F11, #$8F0E, #$8F0D,
      #$9123, #$911C, #$9120, #$9122, #$911F, #$911D, #$911A, #$9124,
      #$9121, #$911B, #$917A, #$9172, #$9179, #$9173, #$92A5, #$92A4,
      #$9276, #$929B, #$927A, #$92A0, #$9294, #$92AA, #$928D, #$92A6,
      #$929A, #$92AB, #$9279, #$9297, #$927F, #$92A3, #$92EE, #$928E,
      #$9282, #$9295, #$92A2, #$927D, #$9288, #$92A1, #$928A, #$9286,
      #$928C, #$9299, #$92A7, #$927E, #$9287, #$92A9, #$929D, #$928B,
      #$922D, #$969E, #$96A1, #$96FF, #$9758, #$977D, #$977A, #$977E,
      #$9783, #$9780, #$9782, #$977B, #$9784, #$9781, #$977F, #$97CE,
      #$97CD, #$9816, #$98AD, #$98AE, #$9902, #$9900, #$9907, #$999D,
      #$999C, #$99C3, #$99B9, #$99BB, #$99BA, #$99C2, #$99BD, #$99C7,
      #$9AB1, #$9AE3, #$9AE7, #$9B3E, #$9B3F, #$9B60, #$9B61, #$9B5F,
      #$9CF1, #$9CF2, #$9CF5, #$9EA7, #$50FF, #$5103, #$5130, #$50F8,
      #$5106, #$5107, #$50F6, #$50FE, #$510B, #$510C, #$50FD, #$510A,
      #$528B, #$528C, #$52F1, #$52EF, #$5648, #$5642, #$564C, #$5635,
      #$5641, #$564A, #$5649, #$5646, #$5658,
      #$565A, #$5640, #$5633, #$563D, #$562C, #$563E, #$5638, #$562A,
      #$563A, #$571A, #$58AB, #$589D, #$58B1, #$58A0, #$58A3, #$58AF,
      #$58AC, #$58A5, #$58A1, #$58FF, #$5AFF, #$5AF4, #$5AFD, #$5AF7,
      #$5AF6, #$5B03, #$5AF8, #$5B02, #$5AF9, #$5B01, #$5B07, #$5B05,
      #$5B0F, #$5C67, #$5D99, #$5D97, #$5D9F, #$5D92, #$5DA2, #$5D93,
      #$5D95, #$5DA0, #$5D9C, #$5DA1, #$5D9A, #$5D9E, #$5E69, #$5E5D,
      #$5E60, #$5E5C, #$7DF3, #$5EDB, #$5EDE, #$5EE1, #$5F49, #$5FB2,
      #$618B, #$6183, #$6179, #$61B1, #$61B0, #$61A2, #$6189, #$619B,
      #$6193, #$61AF, #$61AD, #$619F, #$6192, #$61AA, #$61A1, #$618D,
      #$6166, #$61B3, #$622D, #$646E, #$6470, #$6496, #$64A0, #$6485,
      #$6497, #$649C, #$648F, #$648B, #$648A, #$648C, #$64A3, #$649F,
      #$6468, #$64B1, #$6498, #$6576, #$657A, #$6579, #$657B, #$65B2,
      #$65B3, #$66B5, #$66B0, #$66A9, #$66B2, #$66B7, #$66AA, #$66AF,
      #$6A00, #$6A06, #$6A17, #$69E5, #$69F8, #$6A15, #$69F1, #$69E4,
      #$6A20, #$69FF, #$69EC, #$69E2, #$6A1B, #$6A1D, #$69FE, #$6A27,
      #$69F2, #$69EE, #$6A14, #$69F7, #$69E7, #$6A40, #$6A08, #$69E6,
      #$69FB, #$6A0D, #$69FC, #$69EB, #$6A09, #$6A04, #$6A18, #$6A25,
      #$6A0F, #$69F6, #$6A26, #$6A07, #$69F4, #$6A16, #$6B51, #$6BA5,
      #$6BA3, #$6BA2, #$6BA6, #$6C01, #$6C00, #$6BFF, #$6C02, #$6F41,
      #$6F26, #$6F7E, #$6F87, #$6FC6, #$6F92,
      #$6F8D, #$6F89, #$6F8C, #$6F62, #$6F4F, #$6F85, #$6F5A, #$6F96,
      #$6F76, #$6F6C, #$6F82, #$6F55, #$6F72, #$6F52, #$6F50, #$6F57,
      #$6F94, #$6F93, #$6F5D, #$6F00, #$6F61, #$6F6B, #$6F7D, #$6F67,
      #$6F90, #$6F53, #$6F8B, #$6F69, #$6F7F, #$6F95, #$6F63, #$6F77,
      #$6F6A, #$6F7B, #$71B2, #$71AF, #$719B, #$71B0, #$71A0, #$719A,
      #$71A9, #$71B5, #$719D, #$71A5, #$719E, #$71A4, #$71A1, #$71AA,
      #$719C, #$71A7, #$71B3, #$7298, #$729A, #$7358, #$7352, #$735E,
      #$735F, #$7360, #$735D, #$735B, #$7361, #$735A, #$7359, #$7362,
      #$7487, #$7489, #$748A, #$7486, #$7481, #$747D, #$7485, #$7488,
      #$747C, #$7479, #$7508, #$7507, #$757E, #$7625, #$761E, #$7619,
      #$761D, #$761C, #$7623, #$761A, #$7628, #$761B, #$769C, #$769D,
      #$769E, #$769B, #$778D, #$778F, #$7789, #$7788, #$78CD, #$78BB,
      #$78CF, #$78CC, #$78D1, #$78CE, #$78D4, #$78C8, #$78C3, #$78C4,
      #$78C9, #$799A, #$79A1, #$79A0, #$799C, #$79A2, #$799B, #$6B76,
      #$7A39, #$7AB2, #$7AB4, #$7AB3, #$7BB7, #$7BCB, #$7BBE, #$7BAC,
      #$7BCE, #$7BAF, #$7BB9, #$7BCA, #$7BB5, #$7CC5, #$7CC8, #$7CCC,
      #$7CCB, #$7DF7, #$7DDB, #$7DEA, #$7DE7, #$7DD7, #$7DE1, #$7E03,
      #$7DFA, #$7DE6, #$7DF6, #$7DF1, #$7DF0, #$7DEE, #$7DDF, #$7F76,
      #$7FAC, #$7FB0, #$7FAD, #$7FED, #$7FEB, #$7FEA, #$7FEC, #$7FE6,
      #$7FE8, #$8064, #$8067, #$81A3, #$819F,
      #$819E, #$8195, #$81A2, #$8199, #$8197, #$8216, #$824F, #$8253,
      #$8252, #$8250, #$824E, #$8251, #$8524, #$853B, #$850F, #$8500,
      #$8529, #$850E, #$8509, #$850D, #$851F, #$850A, #$8527, #$851C,
      #$84FB, #$852B, #$84FA, #$8508, #$850C, #$84F4, #$852A, #$84F2,
      #$8515, #$84F7, #$84EB, #$84F3, #$84FC, #$8512, #$84EA, #$84E9,
      #$8516, #$84FE, #$8528, #$851D, #$852E, #$8502, #$84FD, #$851E,
      #$84F6, #$8531, #$8526, #$84E7, #$84E8, #$84F0, #$84EF, #$84F9,
      #$8518, #$8520, #$8530, #$850B, #$8519, #$852F, #$8662, #$8756,
      #$8763, #$8764, #$8777, #$87E1, #$8773, #$8758, #$8754, #$875B,
      #$8752, #$8761, #$875A, #$8751, #$875E, #$876D, #$876A, #$8750,
      #$874E, #$875F, #$875D, #$876F, #$876C, #$877A, #$876E, #$875C,
      #$8765, #$874F, #$877B, #$8775, #$8762, #$8767, #$8769, #$885A,
      #$8905, #$890C, #$8914, #$890B, #$8917, #$8918, #$8919, #$8906,
      #$8916, #$8911, #$890E, #$8909, #$89A2, #$89A4, #$89A3, #$89ED,
      #$89F0, #$89EC, #$8ACF, #$8AC6, #$8AB8, #$8AD3, #$8AD1, #$8AD4,
      #$8AD5, #$8ABB, #$8AD7, #$8ABE, #$8AC0, #$8AC5, #$8AD8, #$8AC3,
      #$8ABA, #$8ABD, #$8AD9, #$8C3E, #$8C4D, #$8C8F, #$8CE5, #$8CDF,
      #$8CD9, #$8CE8, #$8CDA, #$8CDD, #$8CE7, #$8DA0, #$8D9C, #$8DA1,
      #$8D9B, #$8E20, #$8E23, #$8E25, #$8E24, #$8E2E, #$8E15, #$8E1B,
      #$8E16, #$8E11, #$8E19, #$8E26, #$8E27,
      #$8E14, #$8E12, #$8E18, #$8E13, #$8E1C, #$8E17, #$8E1A, #$8F2C,
      #$8F24, #$8F18, #$8F1A, #$8F20, #$8F23, #$8F16, #$8F17, #$9073,
      #$9070, #$906F, #$9067, #$906B, #$912F, #$912B, #$9129, #$912A,
      #$9132, #$9126, #$912E, #$9185, #$9186, #$918A, #$9181, #$9182,
      #$9184, #$9180, #$92D0, #$92C3, #$92C4, #$92C0, #$92D9, #$92B6,
      #$92CF, #$92F1, #$92DF, #$92D8, #$92E9, #$92D7, #$92DD, #$92CC,
      #$92EF, #$92C2, #$92E8, #$92CA, #$92C8, #$92CE, #$92E6, #$92CD,
      #$92D5, #$92C9, #$92E0, #$92DE, #$92E7, #$92D1, #$92D3, #$92B5,
      #$92E1, #$92C6, #$92B4, #$957C, #$95AC, #$95AB, #$95AE, #$95B0,
      #$96A4, #$96A2, #$96D3, #$9705, #$9708, #$9702, #$975A, #$978A,
      #$978E, #$9788, #$97D0, #$97CF, #$981E, #$981D, #$9826, #$9829,
      #$9828, #$9820, #$981B, #$9827, #$98B2, #$9908, #$98FA, #$9911,
      #$9914, #$9916, #$9917, #$9915, #$99DC, #$99CD, #$99CF, #$99D3,
      #$99D4, #$99CE, #$99C9, #$99D6, #$99D8, #$99CB, #$99D7, #$99CC,
      #$9AB3, #$9AEC, #$9AEB, #$9AF3, #$9AF2, #$9AF1, #$9B46, #$9B43,
      #$9B67, #$9B74, #$9B71, #$9B66, #$9B76, #$9B75, #$9B70, #$9B68,
      #$9B64, #$9B6C, #$9CFC, #$9CFA, #$9CFD, #$9CFF, #$9CF7, #$9D07,
      #$9D00, #$9CF9, #$9CFB, #$9D08, #$9D05, #$9D04, #$9E83, #$9ED3,
      #$9F0F, #$9F10, #$511C, #$5113, #$5117, #$511A, #$5111, #$51DE,
      #$5334, #$53E1, #$5670, #$5660, #$566E,
      #$5673, #$5666, #$5663, #$566D, #$5672, #$565E, #$5677, #$571C,
      #$571B, #$58C8, #$58BD, #$58C9, #$58BF, #$58BA, #$58C2, #$58BC,
      #$58C6, #$5B17, #$5B19, #$5B1B, #$5B21, #$5B14, #$5B13, #$5B10,
      #$5B16, #$5B28, #$5B1A, #$5B20, #$5B1E, #$5BEF, #$5DAC, #$5DB1,
      #$5DA9, #$5DA7, #$5DB5, #$5DB0, #$5DAE, #$5DAA, #$5DA8, #$5DB2,
      #$5DAD, #$5DAF, #$5DB4, #$5E67, #$5E68, #$5E66, #$5E6F, #$5EE9,
      #$5EE7, #$5EE6, #$5EE8, #$5EE5, #$5F4B, #$5FBC, #$619D, #$61A8,
      #$6196, #$61C5, #$61B4, #$61C6, #$61C1, #$61CC, #$61BA, #$61BF,
      #$61B8, #$618C, #$64D7, #$64D6, #$64D0, #$64CF, #$64C9, #$64BD,
      #$6489, #$64C3, #$64DB, #$64F3, #$64D9, #$6533, #$657F, #$657C,
      #$65A2, #$66C8, #$66BE, #$66C0, #$66CA, #$66CB, #$66CF, #$66BD,
      #$66BB, #$66BA, #$66CC, #$6723, #$6A34, #$6A66, #$6A49, #$6A67,
      #$6A32, #$6A68, #$6A3E, #$6A5D, #$6A6D, #$6A76, #$6A5B, #$6A51,
      #$6A28, #$6A5A, #$6A3B, #$6A3F, #$6A41, #$6A6A, #$6A64, #$6A50,
      #$6A4F, #$6A54, #$6A6F, #$6A69, #$6A60, #$6A3C, #$6A5E, #$6A56,
      #$6A55, #$6A4D, #$6A4E, #$6A46, #$6B55, #$6B54, #$6B56, #$6BA7,
      #$6BAA, #$6BAB, #$6BC8, #$6BC7, #$6C04, #$6C03, #$6C06, #$6FAD,
      #$6FCB, #$6FA3, #$6FC7, #$6FBC, #$6FCE, #$6FC8, #$6F5E, #$6FC4,
      #$6FBD, #$6F9E, #$6FCA, #$6FA8, #$7004, #$6FA5, #$6FAE, #$6FBA,
      #$6FAC, #$6FAA, #$6FCF, #$6FBF, #$6FB8,
      #$6FA2, #$6FC9, #$6FAB, #$6FCD, #$6FAF, #$6FB2, #$6FB0, #$71C5,
      #$71C2, #$71BF, #$71B8, #$71D6, #$71C0, #$71C1, #$71CB, #$71D4,
      #$71CA, #$71C7, #$71CF, #$71BD, #$71D8, #$71BC, #$71C6, #$71DA,
      #$71DB, #$729D, #$729E, #$7369, #$7366, #$7367, #$736C, #$7365,
      #$736B, #$736A, #$747F, #$749A, #$74A0, #$7494, #$7492, #$7495,
      #$74A1, #$750B, #$7580, #$762F, #$762D, #$7631, #$763D, #$7633,
      #$763C, #$7635, #$7632, #$7630, #$76BB, #$76E6, #$779A, #$779D,
      #$77A1, #$779C, #$779B, #$77A2, #$77A3, #$7795, #$7799, #$7797,
      #$78DD, #$78E9, #$78E5, #$78EA, #$78DE, #$78E3, #$78DB, #$78E1,
      #$78E2, #$78ED, #$78DF, #$78E0, #$79A4, #$7A44, #$7A48, #$7A47,
      #$7AB6, #$7AB8, #$7AB5, #$7AB1, #$7AB7, #$7BDE, #$7BE3, #$7BE7,
      #$7BDD, #$7BD5, #$7BE5, #$7BDA, #$7BE8, #$7BF9, #$7BD4, #$7BEA,
      #$7BE2, #$7BDC, #$7BEB, #$7BD8, #$7BDF, #$7CD2, #$7CD4, #$7CD7,
      #$7CD0, #$7CD1, #$7E12, #$7E21, #$7E17, #$7E0C, #$7E1F, #$7E20,
      #$7E13, #$7E0E, #$7E1C, #$7E15, #$7E1A, #$7E22, #$7E0B, #$7E0F,
      #$7E16, #$7E0D, #$7E14, #$7E25, #$7E24, #$7F43, #$7F7B, #$7F7C,
      #$7F7A, #$7FB1, #$7FEF, #$802A, #$8029, #$806C, #$81B1, #$81A6,
      #$81AE, #$81B9, #$81B5, #$81AB, #$81B0, #$81AC, #$81B4, #$81B2,
      #$81B7, #$81A7, #$81F2, #$8255, #$8256, #$8257, #$8556, #$8545,
      #$856B, #$854D, #$8553, #$8561, #$8558,
      #$8540, #$8546, #$8564, #$8541, #$8562, #$8544, #$8551, #$8547,
      #$8563, #$853E, #$855B, #$8571, #$854E, #$856E, #$8575, #$8555,
      #$8567, #$8560, #$858C, #$8566, #$855D, #$8554, #$8565, #$856C,
      #$8663, #$8665, #$8664, #$879B, #$878F, #$8797, #$8793, #$8792,
      #$8788, #$8781, #$8796, #$8798, #$8779, #$8787, #$87A3, #$8785,
      #$8790, #$8791, #$879D, #$8784, #$8794, #$879C, #$879A, #$8789,
      #$891E, #$8926, #$8930, #$892D, #$892E, #$8927, #$8931, #$8922,
      #$8929, #$8923, #$892F, #$892C, #$891F, #$89F1, #$8AE0, #$8AE2,
      #$8AF2, #$8AF4, #$8AF5, #$8ADD, #$8B14, #$8AE4, #$8ADF, #$8AF0,
      #$8AC8, #$8ADE, #$8AE1, #$8AE8, #$8AFF, #$8AEF, #$8AFB, #$8C91,
      #$8C92, #$8C90, #$8CF5, #$8CEE, #$8CF1, #$8CF0, #$8CF3, #$8D6C,
      #$8D6E, #$8DA5, #$8DA7, #$8E33, #$8E3E, #$8E38, #$8E40, #$8E45,
      #$8E36, #$8E3C, #$8E3D, #$8E41, #$8E30, #$8E3F, #$8EBD, #$8F36,
      #$8F2E, #$8F35, #$8F32, #$8F39, #$8F37, #$8F34, #$9076, #$9079,
      #$907B, #$9086, #$90FA, #$9133, #$9135, #$9136, #$9193, #$9190,
      #$9191, #$918D, #$918F, #$9327, #$931E, #$9308, #$931F, #$9306,
      #$930F, #$937A, #$9338, #$933C, #$931B, #$9323, #$9312, #$9301,
      #$9346, #$932D, #$930E, #$930D, #$92CB, #$931D, #$92FA, #$9325,
      #$9313, #$92F9, #$92F7, #$9334, #$9302, #$9324, #$92FF, #$9329,
      #$9339, #$9335, #$932A, #$9314, #$930C,
      #$930B, #$92FE, #$9309, #$9300, #$92FB, #$9316, #$95BC, #$95CD,
      #$95BE, #$95B9, #$95BA, #$95B6, #$95BF, #$95B5, #$95BD, #$96A9,
      #$96D4, #$970B, #$9712, #$9710, #$9799, #$9797, #$9794, #$97F0,
      #$97F8, #$9835, #$982F, #$9832, #$9924, #$991F, #$9927, #$9929,
      #$999E, #$99EE, #$99EC, #$99E5, #$99E4, #$99F0, #$99E3, #$99EA,
      #$99E9, #$99E7, #$9AB9, #$9ABF, #$9AB4, #$9ABB, #$9AF6, #$9AFA,
      #$9AF9, #$9AF7, #$9B33, #$9B80, #$9B85, #$9B87, #$9B7C, #$9B7E,
      #$9B7B, #$9B82, #$9B93, #$9B92, #$9B90, #$9B7A, #$9B95, #$9B7D,
      #$9B88, #$9D25, #$9D17, #$9D20, #$9D1E, #$9D14, #$9D29, #$9D1D,
      #$9D18, #$9D22, #$9D10, #$9D19, #$9D1F, #$9E88, #$9E86, #$9E87,
      #$9EAE, #$9EAD, #$9ED5, #$9ED6, #$9EFA, #$9F12, #$9F3D, #$5126,
      #$5125, #$5122, #$5124, #$5120, #$5129, #$52F4, #$5693, #$568C,
      #$568D, #$5686, #$5684, #$5683, #$567E, #$5682, #$567F, #$5681,
      #$58D6, #$58D4, #$58CF, #$58D2, #$5B2D, #$5B25, #$5B32, #$5B23,
      #$5B2C, #$5B27, #$5B26, #$5B2F, #$5B2E, #$5B7B, #$5BF1, #$5BF2,
      #$5DB7, #$5E6C, #$5E6A, #$5FBE, #$5FBB, #$61C3, #$61B5, #$61BC,
      #$61E7, #$61E0, #$61E5, #$61E4, #$61E8, #$61DE, #$64EF, #$64E9,
      #$64E3, #$64EB, #$64E4, #$64E8, #$6581, #$6580, #$65B6, #$65DA,
      #$66D2, #$6A8D, #$6A96, #$6A81, #$6AA5, #$6A89, #$6A9F, #$6A9B,
      #$6AA1, #$6A9E, #$6A87, #$6A93, #$6A8E,
      #$6A95, #$6A83, #$6AA8, #$6AA4, #$6A91, #$6A7F, #$6AA6, #$6A9A,
      #$6A85, #$6A8C, #$6A92, #$6B5B, #$6BAD, #$6C09, #$6FCC, #$6FA9,
      #$6FF4, #$6FD4, #$6FE3, #$6FDC, #$6FED, #$6FE7, #$6FE6, #$6FDE,
      #$6FF2, #$6FDD, #$6FE2, #$6FE8, #$71E1, #$71F1, #$71E8, #$71F2,
      #$71E4, #$71F0, #$71E2, #$7373, #$736E, #$736F, #$7497, #$74B2,
      #$74AB, #$7490, #$74AA, #$74AD, #$74B1, #$74A5, #$74AF, #$7510,
      #$7511, #$7512, #$750F, #$7584, #$7643, #$7648, #$7649, #$7647,
      #$76A4, #$76E9, #$77B5, #$77AB, #$77B2, #$77B7, #$77B6, #$77B4,
      #$77B1, #$77A8, #$77F0, #$78F3, #$78FD, #$7902, #$78FB, #$78FC,
      #$78F2, #$7905, #$78F9, #$78FE, #$7904, #$79AB, #$79A8, #$7A5C,
      #$7A5B, #$7A56, #$7A58, #$7A54, #$7A5A, #$7ABE, #$7AC0, #$7AC1,
      #$7C05, #$7C0F, #$7BF2, #$7C00, #$7BFF, #$7BFB, #$7C0E, #$7BF4,
      #$7C0B, #$7BF3, #$7C02, #$7C09, #$7C03, #$7C01, #$7BF8, #$7BFD,
      #$7C06, #$7BF0, #$7BF1, #$7C10, #$7C0A, #$7CE8, #$7E2D, #$7E3C,
      #$7E42, #$7E33, #$9848, #$7E38, #$7E2A, #$7E49, #$7E40, #$7E47,
      #$7E29, #$7E4C, #$7E30, #$7E3B, #$7E36, #$7E44, #$7E3A, #$7F45,
      #$7F7F, #$7F7E, #$7F7D, #$7FF4, #$7FF2, #$802C, #$81BB, #$81C4,
      #$81CC, #$81CA, #$81C5, #$81C7, #$81BC, #$81E9, #$825B, #$825A,
      #$825C, #$8583, #$8580, #$858F, #$85A7, #$8595, #$85A0, #$858B,
      #$85A3, #$857B, #$85A4, #$859A, #$859E,
      #$8577, #$857C, #$8589, #$85A1, #$857A, #$8578, #$8557, #$858E,
      #$8596, #$8586, #$858D, #$8599, #$859D, #$8581, #$85A2, #$8582,
      #$8588, #$8585, #$8579, #$8576, #$8598, #$8590, #$859F, #$8668,
      #$87BE, #$87AA, #$87AD, #$87C5, #$87B0, #$87AC, #$87B9, #$87B5,
      #$87BC, #$87AE, #$87C9, #$87C3, #$87C2, #$87CC, #$87B7, #$87AF,
      #$87C4, #$87CA, #$87B4, #$87B6, #$87BF, #$87B8, #$87BD, #$87DE,
      #$87B2, #$8935, #$8933, #$893C, #$893E, #$8941, #$8952, #$8937,
      #$8942, #$89AD, #$89AF, #$89AE, #$89F2, #$89F3, #$8B1E, #$8B18,
      #$8B16, #$8B11, #$8B05, #$8B0B, #$8B22, #$8B0F, #$8B12, #$8B15,
      #$8B07, #$8B0D, #$8B08, #$8B06, #$8B1C, #$8B13, #$8B1A, #$8C4F,
      #$8C70, #$8C72, #$8C71, #$8C6F, #$8C95, #$8C94, #$8CF9, #$8D6F,
      #$8E4E, #$8E4D, #$8E53, #$8E50, #$8E4C, #$8E47, #$8F43, #$8F40,
      #$9085, #$907E, #$9138, #$919A, #$91A2, #$919B, #$9199, #$919F,
      #$91A1, #$919D, #$91A0, #$93A1, #$9383, #$93AF, #$9364, #$9356,
      #$9347, #$937C, #$9358, #$935C, #$9376, #$9349, #$9350, #$9351,
      #$9360, #$936D, #$938F, #$934C, #$936A, #$9379, #$9357, #$9355,
      #$9352, #$934F, #$9371, #$9377, #$937B, #$9361, #$935E, #$9363,
      #$9367, #$9380, #$934E, #$9359, #$95C7, #$95C0, #$95C9, #$95C3,
      #$95C5, #$95B7, #$96AE, #$96B0, #$96AC, #$9720, #$971F, #$9718,
      #$971D, #$9719, #$979A, #$97A1, #$979C,
      #$979E, #$979D, #$97D5, #$97D4, #$97F1, #$9841, #$9844, #$984A,
      #$9849, #$9845, #$9843, #$9925, #$992B, #$992C, #$992A, #$9933,
      #$9932, #$992F, #$992D, #$9931, #$9930, #$9998, #$99A3, #$99A1,
      #$9A02, #$99FA, #$99F4, #$99F7, #$99F9, #$99F8, #$99F6, #$99FB,
      #$99FD, #$99FE, #$99FC, #$9A03, #$9ABE, #$9AFE, #$9AFD, #$9B01,
      #$9AFC, #$9B48, #$9B9A, #$9BA8, #$9B9E, #$9B9B, #$9BA6, #$9BA1,
      #$9BA5, #$9BA4, #$9B86, #$9BA2, #$9BA0, #$9BAF, #$9D33, #$9D41,
      #$9D67, #$9D36, #$9D2E, #$9D2F, #$9D31, #$9D38, #$9D30, #$9D45,
      #$9D42, #$9D43, #$9D3E, #$9D37, #$9D40, #$9D3D, #$7FF5, #$9D2D,
      #$9E8A, #$9E89, #$9E8D, #$9EB0, #$9EC8, #$9EDA, #$9EFB, #$9EFF,
      #$9F24, #$9F23, #$9F22, #$9F54, #$9FA0, #$5131, #$512D, #$512E,
      #$5698, #$569C, #$5697, #$569A, #$569D, #$5699, #$5970, #$5B3C,
      #$5C69, #$5C6A, #$5DC0, #$5E6D, #$5E6E, #$61D8, #$61DF, #$61ED,
      #$61EE, #$61F1, #$61EA, #$61F0, #$61EB, #$61D6, #$61E9, #$64FF,
      #$6504, #$64FD, #$64F8, #$6501, #$6503, #$64FC, #$6594, #$65DB,
      #$66DA, #$66DB, #$66D8, #$6AC5, #$6AB9, #$6ABD, #$6AE1, #$6AC6,
      #$6ABA, #$6AB6, #$6AB7, #$6AC7, #$6AB4, #$6AAD, #$6B5E, #$6BC9,
      #$6C0B, #$7007, #$700C, #$700D, #$7001, #$7005, #$7014, #$700E,
      #$6FFF, #$7000, #$6FFB, #$7026, #$6FFC, #$6FF7, #$700A, #$7201,
      #$71FF, #$71F9, #$7203, #$71FD, #$7376,
      #$74B8, #$74C0, #$74B5, #$74C1, #$74BE, #$74B6, #$74BB, #$74C2,
      #$7514, #$7513, #$765C, #$7664, #$7659, #$7650, #$7653, #$7657,
      #$765A, #$76A6, #$76BD, #$76EC, #$77C2, #$77BA, #$78FF, #$790C,
      #$7913, #$7914, #$7909, #$7910, #$7912, #$7911, #$79AD, #$79AC,
      #$7A5F, #$7C1C, #$7C29, #$7C19, #$7C20, #$7C1F, #$7C2D, #$7C1D,
      #$7C26, #$7C28, #$7C22, #$7C25, #$7C30, #$7E5C, #$7E50, #$7E56,
      #$7E63, #$7E58, #$7E62, #$7E5F, #$7E51, #$7E60, #$7E57, #$7E53,
      #$7FB5, #$7FB3, #$7FF7, #$7FF8, #$8075, #$81D1, #$81D2, #$81D0,
      #$825F, #$825E, #$85B4, #$85C6, #$85C0, #$85C3, #$85C2, #$85B3,
      #$85B5, #$85BD, #$85C7, #$85C4, #$85BF, #$85CB, #$85CE, #$85C8,
      #$85C5, #$85B1, #$85B6, #$85D2, #$8624, #$85B8, #$85B7, #$85BE,
      #$8669, #$87E7, #$87E6, #$87E2, #$87DB, #$87EB, #$87EA, #$87E5,
      #$87DF, #$87F3, #$87E4, #$87D4, #$87DC, #$87D3, #$87ED, #$87D8,
      #$87E3, #$87A4, #$87D7, #$87D9, #$8801, #$87F4, #$87E8, #$87DD,
      #$8953, #$894B, #$894F, #$894C, #$8946, #$8950, #$8951, #$8949,
      #$8B2A, #$8B27, #$8B23, #$8B33, #$8B30, #$8B35, #$8B47, #$8B2F,
      #$8B3C, #$8B3E, #$8B31, #$8B25, #$8B37, #$8B26, #$8B36, #$8B2E,
      #$8B24, #$8B3B, #$8B3D, #$8B3A, #$8C42, #$8C75, #$8C99, #$8C98,
      #$8C97, #$8CFE, #$8D04, #$8D02, #$8D00, #$8E5C, #$8E62, #$8E60,
      #$8E57, #$8E56, #$8E5E, #$8E65, #$8E67,
      #$8E5B, #$8E5A, #$8E61, #$8E5D, #$8E69, #$8E54, #$8F46, #$8F47,
      #$8F48, #$8F4B, #$9128, #$913A, #$913B, #$913E, #$91A8, #$91A5,
      #$91A7, #$91AF, #$91AA, #$93B5, #$938C, #$9392, #$93B7, #$939B,
      #$939D, #$9389, #$93A7, #$938E, #$93AA, #$939E, #$93A6, #$9395,
      #$9388, #$9399, #$939F, #$938D, #$93B1, #$9391, #$93B2, #$93A4,
      #$93A8, #$93B4, #$93A3, #$93A5, #$95D2, #$95D3, #$95D1, #$96B3,
      #$96D7, #$96DA, #$5DC2, #$96DF, #$96D8, #$96DD, #$9723, #$9722,
      #$9725, #$97AC, #$97AE, #$97A8, #$97AB, #$97A4, #$97AA, #$97A2,
      #$97A5, #$97D7, #$97D9, #$97D6, #$97D8, #$97FA, #$9850, #$9851,
      #$9852, #$98B8, #$9941, #$993C, #$993A, #$9A0F, #$9A0B, #$9A09,
      #$9A0D, #$9A04, #$9A11, #$9A0A, #$9A05, #$9A07, #$9A06, #$9AC0,
      #$9ADC, #$9B08, #$9B04, #$9B05, #$9B29, #$9B35, #$9B4A, #$9B4C,
      #$9B4B, #$9BC7, #$9BC6, #$9BC3, #$9BBF, #$9BC1, #$9BB5, #$9BB8,
      #$9BD3, #$9BB6, #$9BC4, #$9BB9, #$9BBD, #$9D5C, #$9D53, #$9D4F,
      #$9D4A, #$9D5B, #$9D4B, #$9D59, #$9D56, #$9D4C, #$9D57, #$9D52,
      #$9D54, #$9D5F, #$9D58, #$9D5A, #$9E8E, #$9E8C, #$9EDF, #$9F01,
      #$9F00, #$9F16, #$9F25, #$9F2B, #$9F2A, #$9F29, #$9F28, #$9F4C,
      #$9F55, #$5134, #$5135, #$5296, #$52F7, #$53B4, #$56AB, #$56AD,
      #$56A6, #$56A7, #$56AA, #$56AC, #$58DA, #$58DD, #$58DB, #$5912,
      #$5B3D, #$5B3E, #$5B3F, #$5DC3, #$5E70,
      #$5FBF, #$61FB, #$6507, #$6510, #$650D, #$6509, #$650C, #$650E,
      #$6584, #$65DE, #$65DD, #$66DE, #$6AE7, #$6AE0, #$6ACC, #$6AD1,
      #$6AD9, #$6ACB, #$6ADF, #$6ADC, #$6AD0, #$6AEB, #$6ACF, #$6ACD,
      #$6ADE, #$6B60, #$6BB0, #$6C0C, #$7019, #$7027, #$7020, #$7016,
      #$702B, #$7021, #$7022, #$7023, #$7029, #$7017, #$7024, #$701C,
      #$702A, #$720C, #$720A, #$7207, #$7202, #$7205, #$72A5, #$72A6,
      #$72A4, #$72A3, #$72A1, #$74CB, #$74C5, #$74B7, #$74C3, #$7516,
      #$7660, #$77C9, #$77CA, #$77C4, #$77F1, #$791D, #$791B, #$7921,
      #$791C, #$7917, #$791E, #$79B0, #$7A67, #$7A68, #$7C33, #$7C3C,
      #$7C39, #$7C2C, #$7C3B, #$7CEC, #$7CEA, #$7E76, #$7E75, #$7E78,
      #$7E70, #$7E77, #$7E6F, #$7E7A, #$7E72, #$7E74, #$7E68, #$7F4B,
      #$7F4A, #$7F83, #$7F86, #$7FB7, #$7FFD, #$7FFE, #$8078, #$81D7,
      #$81D5, #$8264, #$8261, #$8263, #$85EB, #$85F1, #$85ED, #$85D9,
      #$85E1, #$85E8, #$85DA, #$85D7, #$85EC, #$85F2, #$85F8, #$85D8,
      #$85DF, #$85E3, #$85DC, #$85D1, #$85F0, #$85E6, #$85EF, #$85DE,
      #$85E2, #$8800, #$87FA, #$8803, #$87F6, #$87F7, #$8809, #$880C,
      #$880B, #$8806, #$87FC, #$8808, #$87FF, #$880A, #$8802, #$8962,
      #$895A, #$895B, #$8957, #$8961, #$895C, #$8958, #$895D, #$8959,
      #$8988, #$89B7, #$89B6, #$89F6, #$8B50, #$8B48, #$8B4A, #$8B40,
      #$8B53, #$8B56, #$8B54, #$8B4B, #$8B55,
      #$8B51, #$8B42, #$8B52, #$8B57, #$8C43, #$8C77, #$8C76, #$8C9A,
      #$8D06, #$8D07, #$8D09, #$8DAC, #$8DAA, #$8DAD, #$8DAB, #$8E6D,
      #$8E78, #$8E73, #$8E6A, #$8E6F, #$8E7B, #$8EC2, #$8F52, #$8F51,
      #$8F4F, #$8F50, #$8F53, #$8FB4, #$9140, #$913F, #$91B0, #$91AD,
      #$93DE, #$93C7, #$93CF, #$93C2, #$93DA, #$93D0, #$93F9, #$93EC,
      #$93CC, #$93D9, #$93A9, #$93E6, #$93CA, #$93D4, #$93EE, #$93E3,
      #$93D5, #$93C4, #$93CE, #$93C0, #$93D2, #$93E7, #$957D, #$95DA,
      #$95DB, #$96E1, #$9729, #$972B, #$972C, #$9728, #$9726, #$97B3,
      #$97B7, #$97B6, #$97DD, #$97DE, #$97DF, #$985C, #$9859, #$985D,
      #$9857, #$98BF, #$98BD, #$98BB, #$98BE, #$9948, #$9947, #$9943,
      #$99A6, #$99A7, #$9A1A, #$9A15, #$9A25, #$9A1D, #$9A24, #$9A1B,
      #$9A22, #$9A20, #$9A27, #$9A23, #$9A1E, #$9A1C, #$9A14, #$9AC2,
      #$9B0B, #$9B0A, #$9B0E, #$9B0C, #$9B37, #$9BEA, #$9BEB, #$9BE0,
      #$9BDE, #$9BE4, #$9BE6, #$9BE2, #$9BF0, #$9BD4, #$9BD7, #$9BEC,
      #$9BDC, #$9BD9, #$9BE5, #$9BD5, #$9BE1, #$9BDA, #$9D77, #$9D81,
      #$9D8A, #$9D84, #$9D88, #$9D71, #$9D80, #$9D78, #$9D86, #$9D8B,
      #$9D8C, #$9D7D, #$9D6B, #$9D74, #$9D75, #$9D70, #$9D69, #$9D85,
      #$9D73, #$9D7B, #$9D82, #$9D6F, #$9D79, #$9D7F, #$9D87, #$9D68,
      #$9E94, #$9E91, #$9EC0, #$9EFC, #$9F2D, #$9F40, #$9F41, #$9F4D,
      #$9F56, #$9F57, #$9F58, #$5337, #$56B2,
      #$56B5, #$56B3, #$58E3, #$5B45, #$5DC6, #$5DC7, #$5EEE, #$5EEF,
      #$5FC0, #$5FC1, #$61F9, #$6517, #$6516, #$6515, #$6513, #$65DF,
      #$66E8, #$66E3, #$66E4, #$6AF3, #$6AF0, #$6AEA, #$6AE8, #$6AF9,
      #$6AF1, #$6AEE, #$6AEF, #$703C, #$7035, #$702F, #$7037, #$7034,
      #$7031, #$7042, #$7038, #$703F, #$703A, #$7039, #$7040, #$703B,
      #$7033, #$7041, #$7213, #$7214, #$72A8, #$737D, #$737C, #$74BA,
      #$76AB, #$76AA, #$76BE, #$76ED, #$77CC, #$77CE, #$77CF, #$77CD,
      #$77F2, #$7925, #$7923, #$7927, #$7928, #$7924, #$7929, #$79B2,
      #$7A6E, #$7A6C, #$7A6D, #$7AF7, #$7C49, #$7C48, #$7C4A, #$7C47,
      #$7C45, #$7CEE, #$7E7B, #$7E7E, #$7E81, #$7E80, #$7FBA, #$7FFF,
      #$8079, #$81DB, #$81D9, #$820B, #$8268, #$8269, #$8622, #$85FF,
      #$8601, #$85FE, #$861B, #$8600, #$85F6, #$8604, #$8609, #$8605,
      #$860C, #$85FD, #$8819, #$8810, #$8811, #$8817, #$8813, #$8816,
      #$8963, #$8966, #$89B9, #$89F7, #$8B60, #$8B6A, #$8B5D, #$8B68,
      #$8B63, #$8B65, #$8B67, #$8B6D, #$8DAE, #$8E86, #$8E88, #$8E84,
      #$8F59, #$8F56, #$8F57, #$8F55, #$8F58, #$8F5A, #$908D, #$9143,
      #$9141, #$91B7, #$91B5, #$91B2, #$91B3, #$940B, #$9413, #$93FB,
      #$9420, #$940F, #$9414, #$93FE, #$9415, #$9410, #$9428, #$9419,
      #$940D, #$93F5, #$9400, #$93F7, #$9407, #$940E, #$9416, #$9412,
      #$93FA, #$9409, #$93F8, #$940A, #$93FF,
      #$93FC, #$940C, #$93F6, #$9411, #$9406, #$95DE, #$95E0, #$95DF,
      #$972E, #$972F, #$97B9, #$97BB, #$97FD, #$97FE, #$9860, #$9862,
      #$9863, #$985F, #$98C1, #$98C2, #$9950, #$994E, #$9959, #$994C,
      #$994B, #$9953, #$9A32, #$9A34, #$9A31, #$9A2C, #$9A2A, #$9A36,
      #$9A29, #$9A2E, #$9A38, #$9A2D, #$9AC7, #$9ACA, #$9AC6, #$9B10,
      #$9B12, #$9B11, #$9C0B, #$9C08, #$9BF7, #$9C05, #$9C12, #$9BF8,
      #$9C40, #$9C07, #$9C0E, #$9C06, #$9C17, #$9C14, #$9C09, #$9D9F,
      #$9D99, #$9DA4, #$9D9D, #$9D92, #$9D98, #$9D90, #$9D9B, #$9DA0,
      #$9D94, #$9D9C, #$9DAA, #$9D97, #$9DA1, #$9D9A, #$9DA2, #$9DA8,
      #$9D9E, #$9DA3, #$9DBF, #$9DA9, #$9D96, #$9DA6, #$9DA7, #$9E99,
      #$9E9B, #$9E9A, #$9EE5, #$9EE4, #$9EE7, #$9EE6, #$9F30, #$9F2E,
      #$9F5B, #$9F60, #$9F5E, #$9F5D, #$9F59, #$9F91, #$513A, #$5139,
      #$5298, #$5297, #$56C3, #$56BD, #$56BE, #$5B48, #$5B47, #$5DCB,
      #$5DCF, #$5EF1, #$61FD, #$651B, #$6B02, #$6AFC, #$6B03, #$6AF8,
      #$6B00, #$7043, #$7044, #$704A, #$7048, #$7049, #$7045, #$7046,
      #$721D, #$721A, #$7219, #$737E, #$7517, #$766A, #$77D0, #$792D,
      #$7931, #$792F, #$7C54, #$7C53, #$7CF2, #$7E8A, #$7E87, #$7E88,
      #$7E8B, #$7E86, #$7E8D, #$7F4D, #$7FBB, #$8030, #$81DD, #$8618,
      #$862A, #$8626, #$861F, #$8623, #$861C, #$8619, #$8627, #$862E,
      #$8621, #$8620, #$8629, #$861E, #$8625,
      #$8829, #$881D, #$881B, #$8820, #$8824, #$881C, #$882B, #$884A,
      #$896D, #$8969, #$896E, #$896B, #$89FA, #$8B79, #$8B78, #$8B45,
      #$8B7A, #$8B7B, #$8D10, #$8D14, #$8DAF, #$8E8E, #$8E8C, #$8F5E,
      #$8F5B, #$8F5D, #$9146, #$9144, #$9145, #$91B9, #$943F, #$943B,
      #$9436, #$9429, #$943D, #$943C, #$9430, #$9439, #$942A, #$9437,
      #$942C, #$9440, #$9431, #$95E5, #$95E4, #$95E3, #$9735, #$973A,
      #$97BF, #$97E1, #$9864, #$98C9, #$98C6, #$98C0, #$9958, #$9956,
      #$9A39, #$9A3D, #$9A46, #$9A44, #$9A42, #$9A41, #$9A3A, #$9A3F,
      #$9ACD, #$9B15, #$9B17, #$9B18, #$9B16, #$9B3A, #$9B52, #$9C2B,
      #$9C1D, #$9C1C, #$9C2C, #$9C23, #$9C28, #$9C29, #$9C24, #$9C21,
      #$9DB7, #$9DB6, #$9DBC, #$9DC1, #$9DC7, #$9DCA, #$9DCF, #$9DBE,
      #$9DC5, #$9DC3, #$9DBB, #$9DB5, #$9DCE, #$9DB9, #$9DBA, #$9DAC,
      #$9DC8, #$9DB1, #$9DAD, #$9DCC, #$9DB3, #$9DCD, #$9DB2, #$9E7A,
      #$9E9C, #$9EEB, #$9EEE, #$9EED, #$9F1B, #$9F18, #$9F1A, #$9F31,
      #$9F4E, #$9F65, #$9F64, #$9F92, #$4EB9, #$56C6, #$56C5, #$56CB,
      #$5971, #$5B4B, #$5B4C, #$5DD5, #$5DD1, #$5EF2, #$6521, #$6520,
      #$6526, #$6522, #$6B0B, #$6B08, #$6B09, #$6C0D, #$7055, #$7056,
      #$7057, #$7052, #$721E, #$721F, #$72A9, #$737F, #$74D8, #$74D5,
      #$74D9, #$74D7, #$766D, #$76AD, #$7935, #$79B4, #$7A70, #$7A71,
      #$7C57, #$7C5C, #$7C59, #$7C5B, #$7C5A,
      #$7CF4, #$7CF1, #$7E91, #$7F4F, #$7F87, #$81DE, #$826B, #$8634,
      #$8635, #$8633, #$862C, #$8632, #$8636, #$882C, #$8828, #$8826,
      #$882A, #$8825, #$8971, #$89BF, #$89BE, #$89FB, #$8B7E, #$8B84,
      #$8B82, #$8B86, #$8B85, #$8B7F, #$8D15, #$8E95, #$8E94, #$8E9A,
      #$8E92, #$8E90, #$8E96, #$8E97, #$8F60, #$8F62, #$9147, #$944C,
      #$9450, #$944A, #$944B, #$944F, #$9447, #$9445, #$9448, #$9449,
      #$9446, #$973F, #$97E3, #$986A, #$9869, #$98CB, #$9954, #$995B,
      #$9A4E, #$9A53, #$9A54, #$9A4C, #$9A4F, #$9A48, #$9A4A, #$9A49,
      #$9A52, #$9A50, #$9AD0, #$9B19, #$9B2B, #$9B3B, #$9B56, #$9B55,
      #$9C46, #$9C48, #$9C3F, #$9C44, #$9C39, #$9C33, #$9C41, #$9C3C,
      #$9C37, #$9C34, #$9C32, #$9C3D, #$9C36, #$9DDB, #$9DD2, #$9DDE,
      #$9DDA, #$9DCB, #$9DD0, #$9DDC, #$9DD1, #$9DDF, #$9DE9, #$9DD9,
      #$9DD8, #$9DD6, #$9DF5, #$9DD5, #$9DDD, #$9EB6, #$9EF0, #$9F35,
      #$9F33, #$9F32, #$9F42, #$9F6B, #$9F95, #$9FA2, #$513D, #$5299,
      #$58E8, #$58E7, #$5972, #$5B4D, #$5DD8, #$882F, #$5F4F, #$6201,
      #$6203, #$6204, #$6529, #$6525, #$6596, #$66EB, #$6B11, #$6B12,
      #$6B0F, #$6BCA, #$705B, #$705A, #$7222, #$7382, #$7381, #$7383,
      #$7670, #$77D4, #$7C67, #$7C66, #$7E95, #$826C, #$863A, #$8640,
      #$8639, #$863C, #$8631, #$863B, #$863E, #$8830, #$8832, #$882E,
      #$8833, #$8976, #$8974, #$8973, #$89FE,
      #$8B8C, #$8B8E, #$8B8B, #$8B88, #$8C45, #$8D19, #$8E98, #$8F64,
      #$8F63, #$91BC, #$9462, #$9455, #$945D, #$9457, #$945E, #$97C4,
      #$97C5, #$9800, #$9A56, #$9A59, #$9B1E, #$9B1F, #$9B20, #$9C52,
      #$9C58, #$9C50, #$9C4A, #$9C4D, #$9C4B, #$9C55, #$9C59, #$9C4C,
      #$9C4E, #$9DFB, #$9DF7, #$9DEF, #$9DE3, #$9DEB, #$9DF8, #$9DE4,
      #$9DF6, #$9DE1, #$9DEE, #$9DE6, #$9DF2, #$9DF0, #$9DE2, #$9DEC,
      #$9DF4, #$9DF3, #$9DE8, #$9DED, #$9EC2, #$9ED0, #$9EF2, #$9EF3,
      #$9F06, #$9F1C, #$9F38, #$9F37, #$9F36, #$9F43, #$9F4F, #$9F71,
      #$9F70, #$9F6E, #$9F6F, #$56D3, #$56CD, #$5B4E, #$5C6D, #$652D,
      #$66ED, #$66EE, #$6B13, #$705F, #$7061, #$705D, #$7060, #$7223,
      #$74DB, #$74E5, #$77D5, #$7938, #$79B7, #$79B6, #$7C6A, #$7E97,
      #$7F89, #$826D, #$8643, #$8838, #$8837, #$8835, #$884B, #$8B94,
      #$8B95, #$8E9E, #$8E9F, #$8EA0, #$8E9D, #$91BE, #$91BD, #$91C2,
      #$946B, #$9468, #$9469, #$96E5, #$9746, #$9743, #$9747, #$97C7,
      #$97E5, #$9A5E, #$9AD5, #$9B59, #$9C63, #$9C67, #$9C66, #$9C62,
      #$9C5E, #$9C60, #$9E02, #$9DFE, #$9E07, #$9E03, #$9E06, #$9E05,
      #$9E00, #$9E01, #$9E09, #$9DFF, #$9DFD, #$9E04, #$9EA0, #$9F1E,
      #$9F46, #$9F74, #$9F75, #$9F76, #$56D4, #$652E, #$65B8, #$6B18,
      #$6B19, #$6B17, #$6B1A, #$7062, #$7226, #$72AA, #$77D8, #$77D9,
      #$7939, #$7C69, #$7C6B, #$7CF6, #$7E9A,
      #$7E98, #$7E9B, #$7E99, #$81E0, #$81E1, #$8646, #$8647, #$8648,
      #$8979, #$897A, #$897C, #$897B, #$89FF, #$8B98, #$8B99, #$8EA5,
      #$8EA4, #$8EA3, #$946E, #$946D, #$946F, #$9471, #$9473, #$9749,
      #$9872, #$995F, #$9C68, #$9C6E, #$9C6D, #$9E0B, #$9E0D, #$9E10,
      #$9E0F, #$9E12, #$9E11, #$9EA1, #$9EF5, #$9F09, #$9F47, #$9F78,
      #$9F7B, #$9F7A, #$9F79, #$571E, #$7066, #$7C6F, #$883C, #$8DB2,
      #$8EA6, #$91C3, #$9474, #$9478, #$9476, #$9475, #$9A60, #$9C74,
      #$9C73, #$9C71, #$9C75, #$9E14, #$9E13, #$9EF6, #$9F0A, #$9FA4,
      #$7068, #$7065, #$7CF7, #$866A, #$883E, #$883D, #$883F, #$8B9E,
      #$8C9C, #$8EA9, #$8EC9, #$974B, #$9873, #$9874, #$98CC, #$9961,
      #$99AB, #$9A64, #$9A66, #$9A67, #$9B24, #$9E15, #$9E17, #$9F48,
      #$6207, #$6B1E, #$7227, #$864C, #$8EA8, #$9482, #$9480, #$9481,
      #$9A69, #$9A68, #$9B2E, #$9E19, #$7229, #$864B, #$8B9F, #$9483,
      #$9C79, #$9EB7, #$7675, #$9A6B, #$9C7A, #$9E1D, #$7069, #$706A,
      #$9EA4, #$9F7E, #$9F49, #$9F98);
  HKSCS_1Map: array[0..626] of TBuffChar = (
      #$7E43, #$7E44, #$7E45, #$7E46, #$7E47, #$7E48, #$7E49, #$7E4A,
      #$7E4B, #$7E4C, #$7E4D, #$7E4E, #$7E4F, #$7E50, #$7E51, #$7E52,
      #$7E53, #$7E54, #$7E55, #$7E56, #$7E57, #$7E58, #$0080, #$0041,
      #$010D, #$0040, #$0092, #$0049, #$009A, #$0048, #$00CC, #$0053,
      #$0111, #$0052, #$7E65, #$02BE, #$7E67, #$02C0, #$004A, #$0081,
      #$0061, #$010E, #$0060, #$0151, #$0093, #$0069, #$009B, #$0068,
      #$00AB, #$006D, #$0110, #$006C, #$00CD, #$0073, #$0112, #$0072,
      #$00EB, #$007A, #$0114, #$0079, #$0116, #$0118, #$011A, #$011C,
      #$007C, #$7E84, #$02BF, #$7E86, #$02C1, #$006A, #$0161, #$7E8A,
      #$7E8B, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$EA69, #$7EE1, #$81BD, #$36CA, #$81BD, #$81BD, #$1FFD, #$405D,
      #$6D8E, #$629F, #$81BD, #$81BD, #$D3B5, #$3651, #$20DA, #$20E8,
      #$2168, #$2316, #$2334, #$235C, #$23A4, #$2461, #$2468, #$24FB,
      #$250E, #$2591, #$2598, #$28A2, #$2AB0, #$2AC4, #$2AC7, #$2AF2,
      #$2AF4, #$2D26, #$2D5E, #$2D5F, #$2E5A, #$3046, #$31FB, #$3749,
      #$39BE, #$39C4, #$3A25, #$3F0E, #$423C, #$46B5, #$5024, #$502C,
      #$503A, #$5047, #$504F, #$505F, #$5086, #$50B7, #$53FA, #$544F,
      #$54EF, #$5B06, #$5CFE, #$5D22, #$6066, #$6067, #$606E, #$4591,
      #$4E7C, #$4F4D, #$3B06, #$4C49, #$23E7, #$81BD, #$81BD, #$81BD,
      #$81BD, #$624C, #$4A38, #$621E, #$523C, #$81BD, #$5E0B, #$5276,
      #$7F30, #$81BD, #$81BD, #$521F, #$6F07, #$1F0D, #$6E09, #$6E4C,
      #$1E7E, #$7F39, #$CFCE, #$6E4A, #$7F3C, #$0881, #$81BD, #$401A,
      #$53BE, #$4699, #$81BD, #$1B91, #$6B2C, #$6B4F, #$6FD9, #$4B07,
      #$7F48, #$970A, #$86D0, #$7F4B, #$1FE4, #$2041, #$2040, #$2047,
      #$207F, #$20AB, #$20F7, #$070C, #$217D, #$10C8, #$21C3, #$2248,
      #$073D, #$0753, #$0765, #$2346, #$2AC5, #$239B, #$23BC, #$23C5,
      #$2049, #$2439, #$2450, #$24E7, #$0887, #$2569, #$0811, #$2570,
      #$0813, #$2582, #$25E3, #$082D, #$0832, #$0941, #$2653, #$2663,
      #$2674, #$2679, #$2690, #$26AF, #$26D8, #$26E3, #$26E8, #$0858,
      #$26FF, #$0865, #$087F, #$2797, #$0885,
      #$7F7D, #$26E5, #$81BD, #$8A42, #$7F81, #$7F82, #$2750, #$A186,
      #$0CAC, #$8481, #$5F46, #$B8F8, #$7F89, #$12D3, #$D87E, #$48FA,
      #$7F8D, #$0CF4, #$1A55, #$7F90, #$CA72, #$B92A, #$369D, #$7F94,
      #$8CF4, #$8AD5, #$8E34, #$364D, #$5F7E, #$7F9A, #$7F9B, #$7F9C,
      #$7F9D, #$D996, #$B293, #$81BD, #$8B06, #$7FA2, #$D8A9, #$1A74,
      #$7FA5, #$7FA6, #$6B72, #$0D27, #$7FA9, #$126D, #$07C6, #$BB87,
      #$7FAD, #$7FAE, #$7FAF, #$6DAE, #$68D5, #$81BD, #$1659, #$C465,
      #$3674, #$26A3, #$7FB7, #$7FB8, #$8DB7, #$0CBB, #$8DAF, #$7FBC,
      #$7FBD, #$7FBE, #$36AA, #$7FC0, #$8A43, #$5F68, #$99E1, #$DF0C,
      #$7FC5, #$81BD, #$1A8B, #$7FC8, #$127A, #$2A33, #$7FCB, #$81BD,
      #$7FCD, #$863C, #$7FCF, #$7FD0, #$7FD1, #$2739, #$133B, #$163A,
      #$81BD, #$1CF4, #$7FD7, #$7FD8, #$532A, #$69B5, #$7FDB, #$3539,
      #$0CBE, #$9DB5, #$5EC0, #$2861, #$363C, #$10C3, #$81BD, #$7FE4,
      #$8B89, #$9FCF, #$7FE7, #$81BD, #$8E08, #$7FEA, #$0C52, #$0CC6,
      #$7FED, #$0838, #$7FEF, #$9907, #$2812, #$8CB1, #$7FF3, #$7FF4,
      #$077C, #$3DFD, #$7FF7, #$81BD, #$81BD, #$7FFA, #$7FFB, #$7FFC,
      #$7FFD, #$E00D, #$8BFA, #$8000, #$8001, #$5113, #$8003, #$9E03,
      #$9F39, #$08BB, #$BB23, #$8008, #$8CCD, #$8C2A, #$1213, #$8CB0,
      #$8B07, #$800E, #$800F, #$81BD, #$8C2B, #$8012, #$8B08, #$8E00,
      #$8E7D, #$1279, #$9CD6, #$35F2, #$8CED,
      #$A674, #$D2F9, #$A08E, #$8B3E, #$8B3F, #$A111, #$A115, #$0CD8,
      #$8022, #$8E07, #$8CAE, #$8025, #$CB50, #$8027, #$8028, #$8029,
      #$666A, #$268C, #$5444, #$2779, #$81BD, #$E783, #$6CE6, #$6B76,
      #$D3DE, #$8033, #$42C0, #$52ED, #$526C, #$2DDC, #$C772, #$52B4,
      #$0A57, #$251F, #$D87D, #$6276, #$8C7A, #$8B8F, #$8BF7, #$8C7B,
      #$089D, #$B92B, #$08C9, #$8AD6, #$286F, #$9DF5, #$8E09, #$8B90,
      #$8BF8, #$8DB8, #$8E88, #$D947, #$90D5, #$8BF9, #$B950, #$A264,
      #$2C14, #$8D5D, #$8D5E, #$8E35, #$8E36, #$295C, #$8B91, #$D354,
      #$D9CD, #$8CF5, #$8BFB, #$BAFE, #$09C3, #$8CF6, #$8EC0, #$BB98,
      #$8062, #$8063, #$93FA, #$8065, #$8066, #$2A59, #$2428, #$08DA,
      #$806A, #$4D32, #$2D28, #$1A80, #$1D6C, #$6F67, #$1C67, #$6CDF,
      #$6C4D, #$C0B4, #$A43D, #$27BB, #$08B2, #$2849, #$1FE8, #$2AC2,
      #$807A, #$807B, #$6811, #$807D, #$201B, #$207B, #$07FE, #$2DE3,
      #$3111, #$3184, #$0BBA, #$340C, #$36F5, #$3D3A, #$3DF5, #$3DFA,
      #$41EC, #$43AB, #$1FEC, #$442D, #$808E, #$50D2, #$4ABB, #$4E79,
      #$50D3, #$8093, #$0781, #$81BD, #$8096, #$5182, #$5200, #$8099,
      #$809A, #$251D, #$59A4, #$5B01, #$809E, #$5CE0, #$5E1D, #$6545,
      #$6638, #$663F, #$66A8, #$80A5, #$68A6, #$6935, #$698E, #$699E,
      #$6A23, #$80AB, #$6D3C, #$6E5F, #$6F04, #$3D2F, #$6FDC, #$1FF7,
      #$80B2, #$66DD, #$33F7, #$6562);
  HKSCS_2Map: array[0..3139] of TBuffChar = (
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$2EFE, #$2F08, #$2F16, #$107C, #$0ACF, #$2F64, #$2F79, #$0AE0,
      #$0AF8, #$3002, #$307D, #$30E5, #$3143, #$0BC8, #$0BD4, #$0BFF,
      #$0C0D, #$3297, #$32FD, #$2EA5, #$0C49, #$3377, #$3379, #$338F,
      #$0C78, #$33EC, #$3450, #$34A5, #$34D8, #$0CB8, #$2871, #$0CC3,
      #$35A2, #$35BB, #$35C7, #$361A, #$0D0B, #$3680, #$2ED5, #$27E1,
      #$6FDF, #$0D57, #$3746, #$0D7D, #$37BF, #$3813, #$0DB2, #$3852,
      #$0DE2, #$38D6, #$0E02, #$3964, #$39C0, #$0E18, #$3A0A, #$3A44,
      #$0E32, #$0E31, #$0E3B, #$3AC9, #$3B03, #$43DC, #$3B24, #$3B5F,
      #$3B45, #$0E7C, #$3B96, #$0E9D, #$3C25, #$3C34, #$3C31, #$3C42,
      #$0EAC, #$3C59, #$0EB2, #$3C6B, #$3C75, #$3C94, #$3CB6, #$3D41,
      #$3D81, #$3DAA, #$3E35, #$3E6A, #$0F4B, #$3EC2, #$3EC6, #$3EE6,
      #$3F41, #$0F6F, #$3F64, #$3F71, #$3F95, #$3F98, #$3FA9, #$4006,
      #$DD80, #$403B, #$4062, #$405A, #$6FBF, #$4068, #$4069, #$40A4,
      #$40B4, #$0FC6, #$AD01, #$4101, #$413E, #$0FEA, #$0FF5, #$4337,
      #$2E59, #$100A, #$41AC, #$1011, #$41D0, #$41D4, #$41EF, #$41FF,
      #$4209, #$8465, #$1641, #$08B1, #$80F0,
      #$7311, #$297E, #$CE93, #$42BE, #$BEE0, #$090E, #$3B62, #$DFA9,
      #$2D34, #$4BC9, #$BF61, #$E359, #$4BE5, #$4BFD, #$BFEC, #$4C3B,
      #$4C30, #$4C42, #$4C43, #$4351, #$7325, #$144A, #$4C5A, #$4C5D,
      #$4C6A, #$146F, #$2672, #$C141, #$4C8B, #$4CD5, #$4CA9, #$7330,
      #$C1FE, #$4D22, #$4CEF, #$551C, #$C0F4, #$CC7F, #$4D50, #$55A1,
      #$4D12, #$81BD, #$ADB0, #$102D, #$C1A5, #$5612, #$4D7A, #$81BD,
      #$4DB5, #$C1C1, #$4DC4, #$4E03, #$7345, #$4E26, #$383D, #$B338,
      #$4E49, #$4E47, #$4E66, #$4DF4, #$4E73, #$4E75, #$81BD, #$4FE7,
      #$179D, #$CE04, #$4EDD, #$CE96, #$460D, #$4F09, #$4F2B, #$42B5,
      #$4F33, #$81BD, #$AE17, #$C3E9, #$4F64, #$0F93, #$4F75, #$93B9,
      #$4F65, #$7362, #$81BD, #$C4A1, #$C4DA, #$4FEE, #$5012, #$15AB,
      #$652C, #$4FA7, #$50C0, #$50C1, #$50C7, #$4AB6, #$C5D0, #$6AA1,
      #$5117, #$C611, #$5123, #$9221, #$8228, #$17DC, #$A9A6, #$1783,
      #$DA3A, #$517A, #$C6C9, #$81BD, #$5188, #$519D, #$81BD, #$51AF,
      #$7381, #$7382, #$51BB, #$51BC, #$51E1, #$7386, #$1C09, #$C7E6,
      #$7389, #$C868, #$38E5, #$5227, #$DE08, #$5287, #$529A, #$2A70,
      #$9D36, #$3E3F, #$C6D8, #$7394, #$36A7, #$7396, #$5398, #$941E,
      #$3C13, #$B6A5, #$B6D5, #$16FA, #$53A9, #$739E, #$CAD2, #$73A0,
      #$21B9, #$917D, #$5662, #$54E2, #$CB0A, #$B5E7, #$A770, #$9333,
      #$ABF8, #$542A, #$3ADB, #$EBD4, #$145B,
      #$56CB, #$5450, #$549A, #$8B96, #$9374, #$0981, #$73B4, #$A79A,
      #$53FB, #$5462, #$5498, #$AC4B, #$CD63, #$73BB, #$CB97, #$A80E,
      #$103F, #$549D, #$27AC, #$5505, #$178B, #$CD65, #$552C, #$81BD,
      #$5553, #$073E, #$CE94, #$3C17, #$56DA, #$0756, #$CE02, #$73CD,
      #$55D8, #$73CF, #$55F1, #$1053, #$1764, #$3C67, #$55CA, #$73D5,
      #$4AD8, #$81BD, #$CB96, #$CE37, #$CE03, #$565E, #$81BD, #$5511,
      #$1720, #$5613, #$5664, #$73E1, #$14C0, #$C1C0, #$17C3, #$56B4,
      #$2CB2, #$73E7, #$17A7, #$56F3, #$1796, #$397F, #$5756, #$DBE5,
      #$DBFB, #$5701, #$73F0, #$5742, #$73F2, #$D08D, #$73F4, #$17EA,
      #$5768, #$0908, #$9462, #$25B7, #$D1DA, #$57BE, #$58B1, #$E878,
      #$592E, #$A0E7, #$58F1, #$591A, #$594F, #$2821, #$57AC, #$3A16,
      #$188F, #$5985, #$5986, #$D2A0, #$ABB9, #$D2A4, #$599E, #$59DC,
      #$18DB, #$59F4, #$59F5, #$3581, #$5A05, #$48F7, #$D38F, #$5AC7,
      #$5ACA, #$81BD, #$81BD, #$5AE7, #$5AFC, #$DDE5, #$5B27, #$D4A4,
      #$D5BD, #$5BDC, #$4913, #$62BE, #$5BD0, #$D559, #$4C69, #$D63A,
      #$7426, #$1993, #$D638, #$42FC, #$5C4C, #$5C5F, #$BC30, #$BCA5,
      #$5C7F, #$5C8C, #$5C8D, #$5BE9, #$B6BA, #$5CD0, #$5CDB, #$5BEF,
      #$7436, #$1895, #$598F, #$5D9B, #$D714, #$D74F, #$EC14, #$09E5,
      #$D713, #$5DD6, #$D758, #$D77D, #$5E12, #$5E03, #$94D0, #$5DDB,
      #$41DC, #$5E11, #$7448, #$1150, #$81BD,
      #$5EA9, #$D802, #$744D, #$B5CA, #$0E3C, #$7450, #$D0CC, #$4C67,
      #$5FAD, #$5FB6, #$5FC3, #$6394, #$6019, #$602D, #$DA65, #$DA92,
      #$60A5, #$63C3, #$E9DF, #$8910, #$60B3, #$1BAA, #$DD9E, #$DB3D,
      #$ABBB, #$30B8, #$A522, #$60F9, #$7467, #$7468, #$7469, #$9AA5,
      #$0C40, #$CE97, #$6137, #$DB3C, #$D5BE, #$6161, #$DB6C, #$DBCB,
      #$61A8, #$7474, #$61C4, #$DC66, #$61AE, #$81BD, #$6227, #$0DB0,
      #$6269, #$6284, #$4E2C, #$DCF3, #$9789, #$62CE, #$3E5F, #$6301,
      #$6322, #$BCF9, #$81BD, #$DE86, #$AADB, #$DECC, #$BD1B, #$748A,
      #$63EC, #$642B, #$DEA1, #$DFAB, #$420F, #$2C83, #$DEA2, #$DEA5,
      #$1BE5, #$6304, #$DFAC, #$DFF9, #$DFBF, #$6433, #$651B, #$5FBC,
      #$6645, #$6666, #$64E6, #$6660, #$4176, #$1539, #$74A1, #$DC58,
      #$8F7C, #$AC2E, #$1C5F, #$3DDC, #$673B, #$6756, #$13EC, #$6763,
      #$CE95, #$339A, #$6776, #$4A75, #$DEA0, #$677D, #$258C, #$1C21,
      #$CCB8, #$83B4, #$C690, #$E1AF, #$E1E5, #$B711, #$94D5, #$A5CA,
      #$67F1, #$5782, #$67F6, #$1C8F, #$17BD, #$1805, #$74C1, #$41F5,
      #$2D01, #$67DB, #$81BD, #$74C6, #$6817, #$2D0A, #$E2AB, #$681F,
      #$64E5, #$2290, #$A3B7, #$A3BC, #$6849, #$685F, #$6871, #$687E,
      #$6880, #$6892, #$68A0, #$BC6C, #$68AE, #$459C, #$E2F3, #$81BD,
      #$68B5, #$E2DD, #$74DD, #$1D11, #$68F4, #$68F3, #$690B, #$6926,
      #$0DCE, #$D135, #$0FD1, #$8730, #$AF1C,
      #$BE46, #$698A, #$6977, #$6988, #$6987, #$1D3F, #$CD27, #$9293,
      #$2770, #$69A1, #$69A6, #$69AC, #$6438, #$69F9, #$B669, #$1DB2,
      #$E417, #$E4C5, #$6AB5, #$6ACC, #$6AFB, #$6AD0, #$6B18, #$BE65,
      #$0984, #$E1B1, #$E5D5, #$6BA0, #$6BA2, #$E585, #$6BB4, #$1E4E,
      #$6BD4, #$6BED, #$DBC0, #$21F4, #$6BF4, #$CA28, #$0B83, #$A37D,
      #$6C10, #$6C00, #$E67E, #$2C05, #$9423, #$6C4E, #$B00B, #$6CC2,
      #$6CBF, #$6CCC, #$E728, #$6E14, #$E837, #$E912, #$751E, #$E861,
      #$E8A3, #$E95F, #$6DBE, #$6DC3, #$7524, #$6E4E, #$3A48, #$6E04,
      #$7528, #$E913, #$E9A0, #$94FB, #$E9B3, #$6D79, #$752E, #$752F,
      #$6ED0, #$6ED5, #$6EDE, #$6EE2, #$1F74, #$6EEA, #$6EEF, #$B124,
      #$6F01, #$0E20, #$0CA5, #$0F9D, #$20F2, #$0A7E, #$DFEB, #$6F42,
      #$6F48, #$1DD6, #$64E4, #$CD62, #$6F57, #$81BD, #$6F79, #$285F,
      #$284A, #$6F85, #$6A78, #$E18B, #$68B2, #$55FF, #$6FA2, #$6FA9,
      #$4C5C, #$6FCE, #$4396, #$1DFE, #$B5B5, #$B5FB, #$42F7, #$B638,
      #$B108, #$B691, #$451E, #$DF9A, #$94BA, #$4B1F, #$DD3E, #$E0B6,
      #$6429, #$64B3, #$DE04, #$63AC, #$6441, #$648B, #$DD2C, #$B279,
      #$4397, #$116B, #$48F2, #$4BC3, #$4250, #$756D, #$B1B8, #$42FE,
      #$7570, #$4223, #$947E, #$A7D9, #$1147, #$9445, #$BC2F, #$93B8,
      #$09E2, #$92BB, #$757A, #$09A1, #$9334, #$757D, #$C34B, #$09E3,
      #$9280, #$291B, #$B665, #$90BE, #$7584,
      #$9086, #$9136, #$5683, #$A8E6, #$81BD, #$55D5, #$758B, #$D125,
      #$AC31, #$BC9C, #$ACBB, #$D012, #$1774, #$A92E, #$E55D, #$CEE6,
      #$39B9, #$09F3, #$0ED5, #$1067, #$2A2C, #$759A, #$39D0, #$12D7,
      #$A97F, #$759E, #$AE4B, #$75A0, #$CC21, #$268B, #$285E, #$C831,
      #$2852, #$75A6, #$89A8, #$8B8D, #$6486, #$75AA, #$645C, #$20B8,
      #$22EB, #$0AD9, #$B1F6, #$207C, #$85A5, #$84BF, #$210B, #$214A,
      #$BD91, #$2C28, #$82EB, #$850B, #$0C59, #$844A, #$8554, #$06F5,
      #$20E9, #$8400, #$E133, #$83B5, #$5C1A, #$75C2, #$2058, #$228D,
      #$22CD, #$2162, #$20C3, #$75C8, #$AC4A, #$2102, #$21EE, #$222C,
      #$2241, #$218C, #$21A5, #$2218, #$22BC, #$81BD, #$81BD, #$81BD,
      #$81BD, #$3FF6, #$A7D5, #$75D8, #$AC7F, #$3F32, #$9444, #$AC49,
      #$2368, #$2383, #$86E0, #$175D, #$85E3, #$85D2, #$85D1, #$5E7A,
      #$DE5C, #$874E, #$2419, #$2464, #$8833, #$24A1, #$81BD, #$18FA,
      #$430C, #$B14C, #$8A20, #$B5EC, #$75F1, #$3B91, #$8B9D, #$81BD,
      #$115E, #$4619, #$4594, #$45D6, #$4518, #$1DCE, #$B6FC, #$AE4D,
      #$2590, #$0844, #$438F, #$AE89, #$2774, #$8485, #$268D, #$89C6,
      #$28DD, #$631D, #$67B4, #$6426, #$299D, #$294D, #$293F, #$08FE,
      #$2A8B, #$2C59, #$DE06, #$92BA, #$932F, #$92D0, #$2BEC, #$2B78,
      #$634F, #$2C3E, #$2C8F, #$2BD2, #$7619, #$95B3, #$9421, #$761C,
      #$09B5, #$3EC5, #$45C3, #$2BE1, #$C2C3,
      #$2C41, #$DF97, #$8553, #$64A0, #$460C, #$9003, #$4285, #$1BF2,
      #$64C8, #$DDBB, #$647D, #$0A60, #$2DDE, #$2E5E, #$301E, #$3008,
      #$9556, #$953C, #$AA6E, #$308D, #$2D0F, #$94C3, #$94C4, #$09C1,
      #$9460, #$099D, #$92BE, #$0993, #$52AA, #$DE07, #$96FA, #$A6F2,
      #$DD68, #$30CC, #$30CE, #$94E7, #$7646, #$2C2B, #$92FB, #$2D04,
      #$5754, #$D2BD, #$59A0, #$323E, #$9E60, #$9C6B, #$319B, #$1138,
      #$9C2F, #$9C3E, #$7654, #$CF33, #$3380, #$81FE, #$8206, #$9C5B,
      #$3359, #$3358, #$3235, #$A15B, #$A1C7, #$B414, #$7660, #$3631,
      #$B3A5, #$A06A, #$0CE9, #$A022, #$A6D0, #$E4AA, #$A2F8, #$34F7,
      #$766A, #$3676, #$34F1, #$3591, #$B623, #$A227, #$3464, #$A161,
      #$35FB, #$372B, #$3B32, #$0EB4, #$A38E, #$A56D, #$B5C9, #$A56B,
      #$26CD, #$A5A0, #$9499, #$767D, #$388E, #$A549, #$7680, #$0DA0,
      #$1410, #$BCC4, #$DEE2, #$BCCF, #$92BC, #$BC9B, #$BC25, #$4A6E,
      #$A403, #$93EA, #$A4F4, #$0724, #$768E, #$A442, #$B089, #$384E,
      #$CD24, #$382B, #$1DD3, #$37F0, #$D470, #$7697, #$3823, #$A592,
      #$A5A1, #$37DE, #$BF32, #$0B91, #$769E, #$A9FC, #$0E59, #$A9E2,
      #$A67E, #$4650, #$0E56, #$394F, #$B36A, #$3A76, #$39DE, #$0E84,
      #$3C7E, #$0B23, #$AA15, #$B247, #$3BF3, #$3C12, #$3C89, #$3CC5,
      #$94D2, #$36D1, #$3A58, #$3C0C, #$0E97, #$3C3A, #$3D17, #$AD80,
      #$AADA, #$6460, #$63B2, #$DFAA, #$DE8B,
      #$6349, #$76C0, #$DD9C, #$6527, #$3F65, #$408B, #$76C5, #$81BD,
      #$AD3F, #$100F, #$3F84, #$ADFC, #$2BFD, #$3F8A, #$2A07, #$3EE4,
      #$49C2, #$42BB, #$B0DA, #$B036, #$4271, #$43D0, #$4407, #$4414,
      #$B48F, #$B465, #$2339, #$B6E4, #$86EB, #$45FA, #$ACB8, #$76DE,
      #$76DF, #$B557, #$C3A1, #$1186, #$1131, #$B71F, #$DFE3, #$ACF5,
      #$3267, #$1173, #$464C, #$45BC, #$6447, #$45B7, #$171F, #$CDAA,
      #$17D1, #$4703, #$11E3, #$B859, #$B886, #$11D8, #$46D5, #$47F3,
      #$EA86, #$0DD9, #$45E8, #$DE8C, #$B5EB, #$B5CE, #$0DBB, #$104D,
      #$B68E, #$117F, #$7701, #$B533, #$62BA, #$28F2, #$6402, #$DEA3,
      #$9424, #$229F, #$BB61, #$BB27, #$48F8, #$A4F2, #$488E, #$488F,
      #$48FB, #$B3D7, #$A9C1, #$0D1E, #$7713, #$45B8, #$461B, #$113F,
      #$B6FA, #$B707, #$1348, #$B6D6, #$C52E, #$63C7, #$BCC1, #$499E,
      #$4A0D, #$4A08, #$4A52, #$4550, #$4AD9, #$D3C1, #$7725, #$138E,
      #$81BD, #$5616, #$4B25, #$3BED, #$ACBA, #$4BBA, #$4B74, #$13EE,
      #$92A6, #$13B2, #$62F5, #$4B71, #$8B0C, #$B5CC, #$83D9, #$ABBA,
      #$932E, #$0857, #$272B, #$0830, #$096A, #$8314, #$773D, #$4C62,
      #$2C19, #$9D35, #$7741, #$C01C, #$2BCD, #$839B, #$4A70, #$2BEA,
      #$C106, #$4C7E, #$1479, #$4DDD, #$4DED, #$1491, #$C0F3, #$C2FC,
      #$C2E6, #$4E4D, #$B639, #$7752, #$4E0E, #$4DFC, #$4E2E, #$3C72,
      #$4F5C, #$4F87, #$4F53, #$50CE, #$C5A1,
      #$C4DC, #$775D, #$4F17, #$C2C2, #$14EA, #$7761, #$8856, #$3996,
      #$820E, #$A80F, #$2984, #$C692, #$7768, #$B5A2, #$515D, #$4CA7,
      #$87EC, #$C069, #$C243, #$4C8C, #$C28E, #$6AA6, #$5785, #$6B23,
      #$3BDC, #$7775, #$0CA2, #$B637, #$C7AD, #$6ADF, #$777A, #$5600,
      #$D0E7, #$777D, #$176A, #$52B7, #$1682, #$5246, #$5289, #$52C2,
      #$C8F4, #$6983, #$CAC2, #$53E2, #$53E5, #$CAD1, #$55D3, #$CD67,
      #$5750, #$D15B, #$2C46, #$13FF, #$7790, #$2CEB, #$9461, #$2CA4,
      #$9498, #$57E0, #$5868, #$7797, #$596D, #$D222, #$2BC2, #$59AE,
      #$2105, #$59C7, #$59FF, #$5A26, #$5AA5, #$5A8D, #$BDC3, #$5A94,
      #$D405, #$D404, #$77A6, #$DF99, #$DF5C, #$DDB9, #$112D, #$5623,
      #$1975, #$194F, #$0AB2, #$5B7D, #$5B5C, #$E308, #$310D, #$62EB,
      #$77B4, #$3794, #$42A9, #$4244, #$9405, #$6DAD, #$5D9F, #$5DE9,
      #$D79C, #$2B5A, #$4943, #$2BB0, #$15EE, #$0994, #$5F2A, #$5FA7,
      #$B7C9, #$6030, #$604A, #$1574, #$3E18, #$413B, #$9AA1, #$1B1B,
      #$40F9, #$400B, #$939A, #$6CA9, #$0975, #$B56F, #$61BB, #$81BD,
      #$2731, #$1B86, #$627B, #$64C4, #$DE0B, #$12E2, #$77DA, #$64E7,
      #$DFDD, #$77DD, #$5665, #$5B6B, #$6659, #$6667, #$6657, #$6656,
      #$E074, #$45C5, #$1142, #$B53F, #$77E8, #$77E9, #$1167, #$A4E5,
      #$674F, #$77ED, #$E0E6, #$E0E5, #$114C, #$77F1, #$B6B8, #$ADAE,
      #$4592, #$45EB, #$117C, #$6801, #$E1B0,
      #$3A07, #$1C9D, #$77FB, #$77FC, #$81BD, #$6428, #$DD49, #$7800,
      #$DEEF, #$C67E, #$637A, #$2CD1, #$5CA9, #$1BBC, #$4579, #$AFDB,
      #$685B, #$6831, #$69F8, #$780C, #$2F81, #$DF85, #$B6F2, #$68DF,
      #$E35A, #$63B6, #$7813, #$62A5, #$1740, #$DF10, #$B6A7, #$DF24,
      #$699C, #$DE05, #$1180, #$62EA, #$1BA5, #$5594, #$69FB, #$6A0D,
      #$7821, #$107D, #$6A5B, #$1DAF, #$6A6A, #$6B1C, #$DF25, #$7828,
      #$3C4F, #$6AE1, #$2CBE, #$6AEF, #$782D, #$1DD0, #$782F, #$6A7C,
      #$1DFD, #$1DD7, #$643D, #$2A32, #$9002, #$29E2, #$B5F8, #$9168,
      #$49C4, #$9D5F, #$ABB8, #$3A85, #$0FFD, #$6518, #$0BE7, #$3310,
      #$9DC1, #$9F6B, #$32C7, #$6D0F, #$6D13, #$6D3B, #$6CF5, #$6CD0,
      #$6C3F, #$6C8F, #$E6ED, #$6C5F, #$784D, #$E87E, #$6D61, #$1EEE,
      #$AEC4, #$6E58, #$1EF0, #$6D4C, #$7855, #$7856, #$E873, #$E4EF,
      #$6DE5, #$563D, #$785B, #$CF9F, #$785D, #$573C, #$17B3, #$CD64,
      #$CE44, #$CDB0, #$55A0, #$572E, #$7865, #$AA17, #$C424, #$4B62,
      #$A7DC, #$A880, #$1BAD, #$B61E, #$0FE2, #$649B, #$637E, #$6408,
      #$83FF, #$4A39, #$6337, #$650D, #$21A4, #$0700, #$6164, #$BC9D,
      #$49BD, #$49D4, #$4A36, #$49CB, #$9317, #$A489, #$B581, #$095A,
      #$2132, #$415A, #$4159, #$81BD, #$419E, #$25D4, #$7887, #$297B,
      #$2AB3, #$294A, #$6D56, #$2997, #$42B4, #$076F, #$788F, #$436B,
      #$7891, #$BA17, #$81BD, #$9375, #$DE09,
      #$32CC, #$2C8E, #$2BCB, #$153C, #$B248, #$09EC, #$1DBB, #$DDBC,
      #$647B, #$6478, #$9496, #$78A1, #$55F2, #$CCC0, #$78A4, #$B0BA,
      #$A0E6, #$B181, #$2B54, #$ABB7, #$C881, #$4F28, #$C4DB, #$C464,
      #$B5F9, #$B5CB, #$DDBA, #$63A5, #$4562, #$1169, #$4634, #$DF23,
      #$945F, #$1161, #$B6F3, #$3C98, #$4573, #$457B, #$1156, #$B67E,
      #$B6D4, #$9399, #$B6A6, #$84E7, #$78C2, #$78C3, #$45C8, #$B556,
      #$4225, #$B5B6, #$6344, #$4566, #$641F, #$863E, #$63F1, #$78CD,
      #$DDD6, #$6446, #$DFA7, #$BD15, #$1BB5, #$DE42, #$42EB, #$78D5,
      #$78D6, #$2864, #$871A, #$78D9, #$78DA, #$26C2, #$4B44, #$93BA,
      #$4F7E, #$9282, #$B690, #$78E1, #$17AE, #$64C1, #$09CA, #$78E5,
      #$B5ED, #$2B70, #$947F, #$9443, #$D244, #$2C61, #$09A2, #$AB5B,
      #$0970, #$631F, #$2C39, #$DE41, #$9422, #$6434, #$0F4D, #$8974,
      #$1CD6, #$0C4A, #$22B4, #$0FE9, #$0FCC, #$905C, #$42F5, #$157B,
      #$78FE, #$3F8F, #$E1E4, #$176B, #$3F17, #$D7CF, #$41E7, #$3E6F,
      #$0F56, #$ADAD, #$AC2D, #$3F82, #$408C, #$0FEF, #$8535, #$46D1,
      #$097C, #$0788, #$1900, #$115A, #$1AF1, #$2B84, #$632E, #$1BBE,
      #$6041, #$7917, #$7918, #$29D2, #$2988, #$0996, #$90D2, #$427E,
      #$B122, #$791F, #$A323, #$8FB0, #$9AFD, #$3A79, #$3B27, #$7925,
      #$A725, #$D674, #$A91F, #$DE43, #$AA16, #$792B, #$B81F, #$3BDA,
      #$A8ED, #$CCB7, #$55BE, #$175F, #$174E,
      #$CD26, #$7934, #$CC82, #$CF9E, #$4097, #$D0C9, #$54BD, #$92FA,
      #$556D, #$CC80, #$D013, #$939B, #$2B49, #$2C42, #$9373, #$2C21,
      #$2C31, #$94C5, #$AFBC, #$09ED, #$2BAF, #$92FC, #$0987, #$430E,
      #$6450, #$385A, #$B065, #$2C2E, #$2BEB, #$7950, #$3BEB, #$ACB9,
      #$D3B6, #$B21B, #$B08A, #$429D, #$B019, #$DDA1, #$2170, #$CD28,
      #$2E82, #$B28E, #$D7CD, #$B17D, #$3BCC, #$B016, #$9004, #$4226,
      #$42B3, #$B1A9, #$1025, #$3E9F, #$7967, #$B68F, #$4FE5, #$2BAB,
      #$2EEF, #$1073, #$311C, #$796E, #$796F, #$4F24, #$55A6, #$2645,
      #$7973, #$A5C0, #$8354, #$293E, #$7977, #$8719, #$1265, #$797A,
      #$797B, #$4183, #$797D, #$2F30, #$450F, #$4E53, #$DE19, #$7982,
      #$2188, #$5167, #$444D, #$4490, #$D5F4, #$44B8, #$44B9, #$BE36,
      #$44C1, #$44C8, #$1129, #$D618, #$616C, #$4375, #$7991, #$4561,
      #$5376, #$114A, #$488C, #$1151, #$3E62, #$28BD, #$4599, #$459E,
      #$459F, #$1162, #$1170, #$1174, #$117A, #$4653, #$118E, #$11D3,
      #$46C2, #$46ED, #$46F2, #$470D, #$11FC, #$4748, #$475C, #$1240,
      #$47CD, #$1257, #$47F4, #$125C, #$47FA, #$B9DC, #$4308, #$27E3,
      #$5AC0, #$2A29, #$129D, #$48C3, #$12B9, #$3921, #$12C5, #$089B,
      #$4918, #$12EA, #$12EF, #$2E1E, #$493E, #$494B, #$2AB2, #$4998,
      #$4239, #$499C, #$1328, #$49B9, #$49C7, #$49D1, #$49E6, #$55C8,
      #$79CB, #$4AB3, #$39C3, #$4AB2, #$1383,
      #$1389, #$4B11, #$4B19, #$60BB, #$4B86, #$60BC, #$13E7, #$4C11,
      #$1432, #$4C3C, #$53F9, #$1444, #$4C4F, #$4C5B, #$144F, #$1FE1,
      #$4CE2, #$4CEC, #$4CFB, #$4D92, #$4D9B, #$14E0, #$14FA, #$4DFB,
      #$4E1C, #$150C, #$4E38, #$1514, #$4E6D, #$6093, #$4240, #$8ACF,
      #$4F4F, #$4F54, #$4F50, #$4F7D, #$512E, #$5134, #$441F, #$1617,
      #$51A0, #$51A5, #$4CB9, #$51AE, #$51B1, #$51D4, #$104C, #$2974,
      #$4220, #$5237, #$5269, #$166D, #$528C, #$44AA, #$528E, #$5292,
      #$46E0, #$5294, #$1681, #$0DF9, #$52D6, #$52D9, #$52DA, #$1693,
      #$29FA, #$52FC, #$5304, #$16A5, #$5313, #$16AD, #$5325, #$29AF,
      #$5341, #$5364, #$53D4, #$170F, #$5426, #$53F6, #$544A, #$5458,
      #$547F, #$1730, #$54D7, #$6729, #$3B4A, #$5585, #$4275, #$55E4,
      #$32A3, #$5608, #$1784, #$563E, #$5661, #$5678, #$5690, #$56B8,
      #$56D2, #$17BB, #$56EF, #$56F0, #$5720, #$17F7, #$57B2, #$57D2,
      #$57F2, #$582F, #$6705, #$58CB, #$1886, #$1897, #$59EE, #$5A3F,
      #$5A64, #$5A87, #$5AD1, #$D4E7, #$5B69, #$5B78, #$5BD4, #$5BF4,
      #$5D51, #$5DD4, #$5DF2, #$5E1C, #$1A18, #$2A1F, #$5EC3, #$1A6D,
      #$20AE, #$5F3A, #$2798, #$2914, #$5F71, #$27B5, #$5FB0, #$1AB7,
      #$5FCE, #$5FE2, #$5FE4, #$5FED, #$5FF2, #$60B7, #$60C1, #$60CA,
      #$60CC, #$6133, #$6A84, #$1B2D, #$69A0, #$62D3, #$1B9E, #$62E8,
      #$6318, #$632B, #$6371, #$636E, #$637F,
      #$63A3, #$63AB, #$63B3, #$63B4, #$63BD, #$6403, #$6444, #$646D,
      #$1BC5, #$1BD1, #$6EFF, #$64D7, #$24C1, #$64DD, #$64ED, #$64FE,
      #$1BEA, #$6514, #$6539, #$65ED, #$6662, #$1C27, #$66B4, #$66F3,
      #$1C65, #$3960, #$1CA4, #$6800, #$1CB5, #$6872, #$6882, #$2814,
      #$1D24, #$32A8, #$6979, #$1D59, #$69B1, #$2A04, #$69CE, #$69D9,
      #$2374, #$69DC, #$69F7, #$6A02, #$6A1D, #$6A22, #$1DB0, #$6A85,
      #$1DDD, #$6AFC, #$6BCF, #$4C03, #$6C29, #$6C41, #$6C9D, #$6CB1,
      #$6CB4, #$1EAD, #$6CE0, #$0A2F, #$7A29, #$6D89, #$6CFA, #$6F3E,
      #$2810, #$6DD3, #$6DFD, #$6E00, #$6E3C, #$65B6, #$60B6, #$6EBB,
      #$6EEC, #$6EF1, #$6EFD, #$6F06, #$659C, #$6F22, #$6F31, #$6F38,
      #$4C48, #$6F84, #$7A3F, #$7A40, #$7A41, #$3ADA, #$6583, #$2B6C,
      #$7A45, #$2A00, #$6581, #$0A79, #$7A49, #$7A4A, #$7A4B, #$7A4C,
      #$2917, #$42F3, #$7A4F, #$7A50, #$7A51, #$262A, #$7A53, #$7A54,
      #$265E, #$7A56, #$7A57, #$8A53, #$7A59, #$7A5A, #$32A7, #$7A5C,
      #$283A, #$7A5E, #$7A5F, #$7A60, #$7A61, #$7A62, #$7A63, #$3B15,
      #$6CEF, #$58E5, #$7A67, #$8B8E, #$7A69, #$7A6A, #$8CAD, #$7A6C,
      #$2DE0, #$7A6E, #$2FCB, #$7A70, #$7A71, #$8DB6, #$38DE, #$8DBB,
      #$7A75, #$7A76, #$0907, #$7A78, #$7A79, #$7A7A, #$7A7B, #$2524,
      #$562D, #$8FE3, #$7A7F, #$7A80, #$5CC1, #$7A82, #$7A83, #$7A84,
      #$7A85, #$2038, #$423B, #$7A88, #$7A89,
      #$7A8A, #$7A8B, #$7A8C, #$7A8D, #$7A8E, #$7A8F, #$3483, #$97D5,
      #$7A92, #$4318, #$3A15, #$7A95, #$3BA9, #$0988, #$9A7C, #$7A99,
      #$7A9A, #$7A9B, #$7A9C, #$7A9D, #$547D, #$7A9F, #$7AA0, #$9FD5,
      #$5AE5, #$7AA3, #$60A0, #$7AA5, #$6878, #$7AA7, #$6907, #$6B7D,
      #$7AAA, #$81BD, #$7AAC, #$7AAD, #$7AAE, #$A1C8, #$7AB0, #$7AB1,
      #$7AB2, #$7AB3, #$7AB4, #$7AB5, #$7AB6, #$7AB7, #$7AB8, #$7AB9,
      #$3171, #$3808, #$387F, #$7ABD, #$7ABE, #$7ABF, #$81BD, #$B5FA,
      #$81BD, #$7AC3, #$7AC4, #$81BD, #$8486, #$2A75, #$38CE, #$3AD8,
      #$7ACA, #$D317, #$C3A2, #$7ACD, #$7ACE, #$D2BE, #$98DA, #$1B50,
      #$1CF8, #$7AD3, #$DE5A, #$7AD5, #$7AD6, #$ADFB, #$7AD8, #$B156,
      #$7ADA, #$7ADB, #$2392, #$8711, #$2B5F, #$97A8, #$0E7E, #$AB3F,
      #$7AE2, #$7AE3, #$2948, #$7AE5, #$0C5B, #$7AE7, #$7AE8, #$7AE9,
      #$0A22, #$9A03, #$5C9E, #$DF0E, #$81BD, #$7AEF, #$7AF0, #$7AF1,
      #$4389, #$7AF3, #$8A78, #$2B25, #$7AF6, #$7AF7, #$87B9, #$5FDA,
      #$7AFA, #$244F, #$28FF, #$42F1, #$7AFE, #$7AFF, #$7B00, #$B6E7,
      #$277C, #$7B03, #$BC6E, #$CB52, #$81BD, #$0733, #$7B08, #$D2F2,
      #$7B0A, #$1998, #$7B0C, #$BCA6, #$BEC7, #$B57F, #$7B10, #$2226,
      #$07BB, #$7B13, #$81BD, #$7B15, #$19FC, #$DD08, #$C02E, #$7B19,
      #$C146, #$7B1B, #$2961, #$42D1, #$81BD, #$7B1F, #$D692, #$6156,
      #$7B22, #$BA1A, #$5CA2, #$7B25, #$7B26,
      #$2F1B, #$CBF7, #$81BD, #$7B2A, #$7B2B, #$5C2A, #$B636, #$7B2E,
      #$ADAF, #$C712, #$1E00, #$7B32, #$7B33, #$9D5B, #$6525, #$BEE1,
      #$3355, #$2BE7, #$EB8D, #$81BD, #$2879, #$B2E1, #$7B3D, #$202A,
      #$7B3F, #$6716, #$3F4F, #$CCBD, #$08D8, #$5AB7, #$7B45, #$C96E,
      #$C691, #$C95E, #$81BD, #$7B4A, #$4CC2, #$7B4C, #$88D1, #$7B4E,
      #$81BD, #$7B50, #$4BC5, #$81BD, #$CA7A, #$6AE6, #$7B55, #$091F,
      #$7B57, #$7B58, #$4B03, #$7B5A, #$7B5B, #$2EEC, #$7B5D, #$81BD,
      #$7B5F, #$1950, #$7B61, #$46BB, #$59A5, #$7B64, #$2A76, #$09DC,
      #$9C0D, #$7B68, #$7B69, #$0F14, #$7B6B, #$7B6C, #$6341, #$99BA,
      #$7B6F, #$63F0, #$D1A6, #$7B72, #$3DF9, #$655F, #$7B75, #$8C78,
      #$5967, #$5A35, #$7B79, #$7B7A, #$9371, #$4038, #$B66A, #$7B7E,
      #$0C64, #$0979, #$81BD, #$81BD, #$17BF, #$3876, #$E62D, #$E464,
      #$5A83, #$7B88, #$7B89, #$2896, #$135F, #$91CA, #$0C61, #$A96F,
      #$7B8F, #$9085, #$432D, #$54E6, #$7B93, #$E268, #$81BD, #$1EF7,
      #$D06F, #$DD6B, #$7B99, #$7B9A, #$7B9B, #$7B9C, #$AF3A, #$4CC3,
      #$4AFE, #$D809, #$4135, #$EA1F, #$3BC3, #$7BA4, #$2562, #$7BA6,
      #$647F, #$39F6, #$681D, #$D92F, #$7BAB, #$CA35, #$90AD, #$A4EF,
      #$7BAF, #$2F45, #$DFF0, #$7BB2, #$28D5, #$68E3, #$DD09, #$2F6B,
      #$B5C8, #$377E, #$3B95, #$2592, #$B6E5, #$AD41, #$0ED1, #$38F6,
      #$7BBF, #$D8B4, #$D8EE, #$9861, #$7BC3,
      #$7BC4, #$7BC5, #$7BC6, #$7BC7, #$7BC8, #$7BC9, #$088A, #$7BCB,
      #$DC2A, #$1B7A, #$35A6, #$7BCF, #$4988, #$6315, #$7BD2, #$1672,
      #$7BD4, #$165F, #$7BD6, #$7BD7, #$7BD8, #$2BB8, #$7BDA, #$81BD,
      #$7BDC, #$7BDD, #$81BD, #$E210, #$7BE0, #$1077, #$7BE2, #$7BE3,
      #$60D0, #$440F, #$284B, #$7BE7, #$E3E9, #$7BE9, #$7BEA, #$7BEB,
      #$7BEC, #$7BED, #$E52A, #$7BEF, #$7BF0, #$E58E, #$7BF2, #$7BF3,
      #$501F, #$7BF5, #$E7E3, #$1EE4, #$6607, #$7BF9, #$4322, #$7BFB,
      #$1F91, #$6112, #$7BFE, #$1F9C, #$8A9C, #$60BE, #$2781, #$60BA,
      #$7C04, #$60B9, #$B6D3, #$1789, #$4FFF, #$40D6, #$3C71, #$20AA,
      #$07A4, #$DEEC, #$7C0E, #$09FA, #$5F80, #$93B5, #$7C12, #$DF2C,
      #$DF59, #$7C15, #$C82F, #$106B, #$D315, #$AAF7, #$BD75, #$BF96,
      #$205A, #$C2C1, #$C598, #$287F, #$8BED, #$5F0E, #$2D2D, #$AC48,
      #$B81E, #$359E, #$81BD, #$93B6, #$943B, #$36F0, #$27ED, #$C18A,
      #$25DA, #$BBD1, #$1046, #$7C2F, #$1EBD, #$27E2, #$27DE, #$50C9,
      #$C318, #$2B35, #$7C36, #$58B0, #$1FDC, #$8D2A, #$8B09, #$A8FA,
      #$5297, #$6D9E, #$5E18, #$47BB, #$6D05, #$47CE, #$4939, #$6405,
      #$25F2, #$52C8, #$5477, #$27E5, #$52B2, #$5598, #$523D, #$27AA,
      #$4AE2, #$2803, #$25D6, #$7C4F, #$088E, #$27C5, #$27B1, #$38B1,
      #$D9E2, #$08ED, #$46B4, #$27B0, #$277A, #$2657, #$2732, #$8A41,
      #$7C5C, #$3090, #$BAC8, #$8BF6, #$7C60,
      #$7C61, #$6EEB, #$4EDA, #$279E, #$8DB5, #$345D, #$682D, #$2654,
      #$5DCD, #$4376, #$6236, #$35BC, #$3579, #$35BE, #$2729, #$7C70,
      #$6D32, #$7C72, #$235A, #$079F, #$8B67, #$2367, #$260D, #$26DE,
      #$26D3, #$47E6, #$5F2D, #$7C7C, #$4731, #$5236, #$5944, #$58C6,
      #$5A07, #$5336, #$559C, #$8E01, #$176C, #$4484, #$B446, #$2D50,
      #$548B, #$C993, #$283B, #$9D34, #$D6EF, #$AF63, #$D733, #$CE90,
      #$7C91, #$6230, #$8F19, #$62C8, #$AB3C, #$EAE9, #$8C2C, #$8C79,
      #$43E6, #$9662, #$19CE, #$BA42, #$7C9D, #$8D2B, #$137A, #$6D1D,
      #$36DF, #$A260, #$1B73, #$7CA4, #$E6BC, #$8D2C, #$8B8A, #$81BD,
      #$7CA9, #$8D2D, #$81BD, #$7CAC, #$8EC7, #$4323, #$500E, #$6D90,
      #$1FDA, #$1FC4, #$0837, #$2CCD, #$3E72, #$2527, #$096C, #$0C9C,
      #$253D, #$0965, #$7CBB, #$2A5A, #$B76E, #$53AD, #$260B, #$296A,
      #$7CC1, #$88B9, #$81BD, #$0D12, #$9B65, #$44F4, #$E76C, #$1F49,
      #$6CAD, #$AB3E, #$E7F0, #$1E9B, #$BA29, #$E39E, #$7CCF, #$55DC,
      #$ABB6, #$7CD2, #$C8F3, #$A960, #$34EE, #$4EA5, #$ACB7, #$AC2C,
      #$0CEA, #$6108, #$248C, #$10F4, #$093A, #$1869, #$7CDF, #$47C0,
      #$2CB0, #$8C36, #$49FA, #$1A36, #$2A67, #$133F, #$283C, #$6C4B,
      #$2F34, #$47D4, #$7CEB, #$6EC5, #$1F21, #$81BD, #$0ABB, #$32D9,
      #$A3DA, #$B1B2, #$81BD, #$281D, #$8FA9, #$2967, #$B5A3, #$7CF8,
      #$23F4, #$D06E, #$086D, #$81BD, #$6DBC,
      #$4DD6, #$6BF9, #$299E, #$932C, #$2E13, #$3693, #$7D04, #$7D05,
      #$D124, #$57ED, #$7D08, #$CD22, #$B722, #$7D0B, #$81BD, #$23BE,
      #$7D0E, #$2F4E, #$67C3, #$9711, #$6EC1, #$614C, #$4C9F, #$6BC2,
      #$2E91, #$4D23, #$3428, #$34F5, #$6BBF, #$4D4F, #$6BEA, #$4DFE,
      #$81BD, #$4DC2, #$4E06, #$6CD5, #$4D7C, #$6BC9, #$81BD, #$6CDB,
      #$B57E, #$6F9A, #$2733, #$2D83, #$21BD, #$6ED8, #$21B2, #$2420,
      #$1086, #$2491, #$2927, #$2216, #$2B77, #$2FD2, #$6888, #$6DEB,
      #$605C, #$2629, #$6874, #$6A00, #$687A, #$24EC, #$32F0, #$3AEC,
      #$259A, #$6CCA, #$6D42, #$1E7B, #$6701, #$3B40, #$2266, #$46C6,
      #$932D, #$6A9A, #$2433, #$81BD, #$6219, #$6741, #$621C, #$81BD,
      #$6211, #$7D4F, #$353F, #$CD23, #$3C8A, #$27D1, #$624E, #$46FA,
      #$3445, #$853C, #$44CF, #$4DF0, #$7D5A, #$AB3D, #$81BD, #$B559,
      #$4856, #$6C5D, #$1FEA, #$8AD4, #$553E, #$5982, #$81BD, #$2E0A,
      #$3B80, #$81BD, #$293A, #$23DF, #$2FB5, #$208E, #$3DF1, #$7D6D,
      #$20F9, #$265C, #$269A, #$245A, #$5E82, #$08BE, #$81BD, #$08B3,
      #$81BD, #$3D12, #$623C, #$6FE5, #$6C57, #$68EE, #$6974, #$6B7A,
      #$6EE8, #$6EC4, #$42FA, #$4C94, #$81BD, #$3DBA, #$5958, #$50F8,
      #$81BD, #$27E0, #$7D88, #$5F77, #$6F93, #$81BD, #$5ED4, #$5F4F,
      #$6E5C, #$5F01, #$3442, #$DA7D, #$5F28, #$5F75, #$4C53, #$B6B7,
      #$4BBE, #$4A58, #$3EAA, #$5BA7, #$4787,
      #$DE1A, #$6F66, #$3E8E, #$5916, #$4743, #$E9F2, #$49D3, #$EB00,
      #$5E0C, #$4462, #$44F1, #$5C6D, #$4482, #$4671, #$5DEB, #$B6FB,
      #$576F, #$317A, #$59E0, #$1737, #$81BD, #$93FB, #$CDC5, #$81BD,
      #$5BBE, #$9BDB, #$81BD, #$32BD, #$47E7, #$6B97, #$6D84, #$642E,
      #$6C4F, #$5935, #$81BD, #$81BD, #$5DF7, #$44AC, #$67E1, #$6C70,
      #$0896, #$4432, #$1E47, #$4DD1, #$6A0A, #$C4D9, #$3319, #$1E44,
      #$6ED6, #$333D, #$81BD, #$291F, #$332F, #$3466, #$33F9, #$81BD,
      #$0D1C, #$33A2, #$256A, #$A675, #$3524, #$39C2, #$0892, #$2F17,
      #$DF82, #$60DA, #$7DDD, #$81BD, #$2299, #$9686, #$4A86, #$24F2,
      #$66F8, #$8CBB, #$12E5, #$81BD, #$497E, #$81BD, #$4E42, #$7DEA,
      #$4E5A, #$4BAD, #$51E6, #$51E3, #$4ECD, #$4685, #$4672, #$5AD4,
      #$539A, #$38CC, #$51E2, #$D246, #$51DB, #$4670, #$5283, #$48A4,
      #$5AC9, #$C90C, #$46D3, #$CE91, #$58E9, #$590E, #$5348, #$58CC,
      #$5B89, #$5DAD, #$5C83, #$48AB, #$4678, #$565A, #$08F5, #$3B72,
      #$5EA6, #$81BD, #$5AE9, #$81BD, #$3F79, #$5901, #$ADD1, #$4667,
      #$105B, #$42F6, #$3264, #$335C, #$0F51, #$81BD, #$3237, #$81BD,
      #$50F1, #$DEED, #$81BD, #$32A9, #$1DBE, #$23E0, #$0ED8, #$AB07,
      #$C317, #$D316, #$7E25, #$9504, #$8FFE, #$E4C3, #$CD9C, #$D06D,
      #$2E81, #$C52D, #$DDCF, #$A8B7, #$826E, #$7E30, #$B98E, #$17E2,
      #$2CDF, #$7E34, #$6F90, #$6EE6, #$7E37);
  HKSCS_3Map: array[0..470] of TBuffChar = (
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$0420,
      #$0421, #$0422, #$0423, #$0424, #$0425, #$0426, #$0427, #$0428,
      #$0429, #$0434, #$0435, #$0436, #$0437, #$0438, #$0439, #$043A,
      #$043B, #$043C, #$043D, #$0370, #$0371, #$0372, #$0373, #$0374,
      #$0375, #$0376, #$0377, #$0378, #$0379, #$1FF6, #$1FFF, #$2045,
      #$2060, #$2342, #$2356, #$236B, #$24B9, #$24F8, #$2529, #$2576,
      #$2ACA, #$2D40, #$2F9B, #$0573, #$303F, #$81BD, #$3110, #$3121,
      #$36F4, #$81BD, #$4712, #$81BD, #$60B5, #$81BD, #$0028, #$01C6,
      #$067D, #$067E, #$061D, #$061E, #$81BD, #$81BD, #$0585, #$0586,
      #$0587, #$067C, #$817B, #$817D, #$04BD, #$05C1, #$05C2, #$05C3,
      #$05C4, #$05C5, #$05C6, #$05C7, #$05C8, #$05C9, #$05CA, #$05CB,
      #$05CC, #$05CD, #$05CE, #$05CF, #$05D0, #$05D1, #$05D2, #$05D3,
      #$05D4, #$05D5, #$05D6, #$05D7, #$05D8,
      #$05D9, #$05DA, #$05DB, #$05DC, #$05DD, #$05DE, #$05DF, #$05E0,
      #$05E1, #$05E2, #$05E3, #$05E4, #$05E5, #$05E6, #$05E7, #$05E8,
      #$05E9, #$05EA, #$05EB, #$05EC, #$05ED, #$05EE, #$05EF, #$05F0,
      #$05F1, #$05F2, #$05F3, #$05F4, #$05F5, #$05F6, #$05F7, #$05F8,
      #$05F9, #$05FA, #$05FB, #$05FC, #$05FD, #$05FE, #$05FF, #$0600,
      #$0601, #$0602, #$0603, #$0604, #$0605, #$0606, #$0607, #$0608,
      #$0609, #$060A, #$060B, #$060C, #$060D, #$060E, #$060F, #$0610,
      #$0611, #$0612, #$0613, #$0621, #$0622, #$0623, #$0624, #$0625,
      #$0626, #$0627, #$0628, #$0629, #$062A, #$062B, #$062C, #$062D,
      #$062E, #$062F, #$0630, #$0631, #$0632, #$0633, #$0634, #$0635,
      #$0636, #$0637, #$0638, #$0639, #$063A, #$063B, #$063C, #$063D,
      #$063E, #$063F, #$0640, #$0641, #$0642, #$0643, #$0644, #$0645,
      #$0646, #$0647, #$0648, #$0649, #$064A, #$064B, #$064C, #$064D,
      #$064E, #$064F, #$0650, #$0651, #$0652, #$0653, #$0654, #$0655,
      #$0656, #$0657, #$0658, #$0659, #$065A, #$065B, #$065C, #$065D,
      #$065E, #$065F, #$0660, #$0661, #$0662, #$0663, #$0664, #$0665,
      #$0666, #$0667, #$0668, #$0669, #$066A, #$066B, #$066C, #$066D,
      #$066E, #$066F, #$0670, #$0671, #$0672, #$0673, #$0674, #$0675,
      #$0676, #$0210, #$0211, #$0212, #$0213, #$0214, #$0215, #$0201,
      #$0216, #$0217, #$0218, #$0219, #$021A,
      #$021B, #$021C, #$021D, #$021E, #$021F, #$0220, #$0221, #$0222,
      #$0223, #$0224, #$0225, #$0226, #$0227, #$0228, #$0229, #$022A,
      #$022B, #$022C, #$022D, #$022E, #$022F, #$0230, #$0231, #$0232,
      #$0233, #$0234, #$0235, #$0251, #$0236, #$0237, #$0238, #$0239,
      #$023A, #$023B, #$023C, #$023D, #$023E, #$023F, #$0240, #$0241,
      #$0242, #$0243, #$0244, #$0245, #$0246, #$0247, #$0248, #$0249,
      #$024A, #$024B, #$024C, #$024D, #$024E, #$024F, #$03E7, #$03B8,
      #$03B9, #$8125, #$8126, #$201A, #$8128, #$23C2, #$812A, #$812B,
      #$2348, #$812D, #$812E, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81A2, #$81A4, #$8147, #$8142, #$06B1,
      #$0316, #$0321, #$061B, #$061C, #$04C0, #$04C4, #$04C6, #$04C7,
      #$04C8, #$04CA, #$04CC, #$04CD, #$04D5, #$04DC, #$04DD, #$04E5,
      #$04E7, #$04EA, #$04EC, #$04EE, #$04F6, #$04FC, #$04FE, #$0506,
      #$050A, #$050C, #$050D, #$050F, #$0516, #$0517, #$051E, #$0523,
      #$81BD, #$81BD, #$81BD, #$0183, #$0150, #$015B, #$0154, #$0175,
      #$00D3, #$0078, #$00CB, #$018A, #$016A);
  HKSCS_4Map: array[0..941] of TBuffChar = (
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD, #$81BD,
      #$81BD, #$81BD, #$81BD, #$81BD, #$4A01, #$6379, #$5A0F, #$2A7B,
      #$3212, #$4E27, #$2CBA, #$0454, #$0466, #$0457, #$0460, #$046C,
      #$0463, #$045A, #$0469, #$045D, #$0452, #$0464, #$0455, #$045E,
      #$046A, #$0461, #$0458, #$0467, #$045B, #$0453, #$0465, #$0456,
      #$045F, #$046B, #$0462, #$0459, #$0468, #$045C, #$0451, #$0450,
      #$046D, #$046E, #$0470, #$046F, #$81AD,
      #$8647, #$639B, #$86DF, #$7003, #$56CC, #$1535, #$456F, #$2375,
      #$0909, #$B582, #$DDA4, #$6404, #$959B, #$546E, #$AB08, #$49BC,
      #$3904, #$349F, #$B573, #$DD6A, #$83E0, #$CBB3, #$9005, #$216B,
      #$7018, #$21C8, #$CD29, #$701B, #$A840, #$B6F1, #$9BD3, #$81BD,
      #$84BE, #$3164, #$84C0, #$8487, #$405B, #$855F, #$81BD, #$22C1,
      #$073A, #$22CE, #$692C, #$0A03, #$5596, #$702D, #$85C7, #$2320,
      #$A634, #$232A, #$89FF, #$993C, #$8425, #$9BF0, #$868E, #$A4F3,
      #$7038, #$2D42, #$58BD, #$86B3, #$AAD9, #$2372, #$2378, #$6D74,
      #$2389, #$238F, #$2391, #$0F5C, #$2393, #$B6E6, #$2373, #$23A2,
      #$2502, #$23AD, #$554D, #$3AFE, #$704C, #$313B, #$23CB, #$23E6,
      #$23FC, #$2475, #$2417, #$2454, #$2479, #$2485, #$4D95, #$56C2,
      #$24A0, #$574D, #$705A, #$81BD, #$DE9E, #$2709, #$4059, #$AD40,
      #$8894, #$ADAC, #$24F3, #$81BD, #$89E2, #$3E8B, #$92E6, #$39DB,
      #$4555, #$320A, #$112A, #$0B8C, #$92A8, #$435D, #$1722, #$252D,
      #$2534, #$DC2B, #$253E, #$81BD, #$9196, #$91D3, #$4966, #$2553,
      #$DE5B, #$2560, #$256B, #$256E, #$4527, #$BEB2, #$11D9, #$451C,
      #$2581, #$2585, #$3E09, #$2009, #$29BE, #$2599, #$0D6B, #$898F,
      #$25A0, #$ADAB, #$A263, #$25B6, #$8A77, #$25D3, #$41F9, #$26EB,
      #$3817, #$3F1B, #$262D, #$CB53, #$7094, #$271D, #$264F, #$2664,
      #$1A26, #$7099, #$709A, #$1034, #$8B0D,
      #$DD7C, #$9CD8, #$2707, #$1F2D, #$25EF, #$4597, #$2746, #$2769,
      #$81BD, #$9497, #$ADFA, #$17D2, #$B1F5, #$3873, #$8DF4, #$27F7,
      #$388D, #$A54A, #$3864, #$386D, #$280D, #$280F, #$4A71, #$28B1,
      #$6847, #$25BE, #$28C0, #$28AF, #$28AD, #$DF26, #$08E3, #$8F4F,
      #$2906, #$AF65, #$3E2E, #$420B, #$2902, #$0971, #$CC7E, #$29A6,
      #$70C5, #$29C3, #$90D4, #$B123, #$29E6, #$B7B5, #$2A1C, #$2A6A,
      #$0821, #$2AA0, #$2A9C, #$70D0, #$2ABB, #$2DBF, #$2903, #$E8D0,
      #$B038, #$6493, #$0861, #$2ADF, #$3A66, #$0983, #$3FD9, #$91FE,
      #$2BE4, #$2713, #$9252, #$5685, #$2B89, #$8B0E, #$CC81, #$CD2A,
      #$939C, #$2B99, #$93BB, #$9372, #$CD66, #$3F31, #$93E8, #$9295,
      #$2BB9, #$CE05, #$2C6B, #$2C23, #$09A6, #$70F2, #$81BD, #$09C8,
      #$2C56, #$45E5, #$2C93, #$CF61, #$70F9, #$1005, #$94D1, #$09F2,
      #$70FD, #$3043, #$2490, #$2D36, #$3748, #$2D3C, #$D50E, #$1284,
      #$1ADD, #$7106, #$2D95, #$3320, #$7109, #$710A, #$86A5, #$2DB3,
      #$2D5D, #$1F50, #$2DC5, #$9604, #$2DD3, #$454E, #$2DD4, #$9665,
      #$CB28, #$2E09, #$1B5D, #$2E45, #$2EA9, #$2EAF, #$2F4B, #$9739,
      #$9777, #$2ED0, #$2ED8, #$2F06, #$97A4, #$2E7A, #$2F97, #$547C,
      #$0AED, #$B541, #$9889, #$99B3, #$5407, #$0AF6, #$0E82, #$2FEE,
      #$3C4A, #$81BD, #$303A, #$7130, #$8AD3, #$2566, #$2077, #$81BD,
      #$2568, #$9331, #$2FC9, #$30B4, #$DAC2,
      #$30B9, #$30BB, #$0B60, #$30BC, #$39FE, #$64DB, #$30CD, #$8301,
      #$EB54, #$0D9E, #$1B2E, #$903A, #$30FA, #$C988, #$9B10, #$81BD,
      #$9B71, #$3123, #$687D, #$CE2E, #$3132, #$6400, #$7150, #$3167,
      #$2F76, #$0FDF, #$7154, #$982A, #$D0B8, #$9CA8, #$6296, #$83DE,
      #$DDE9, #$31F1, #$3845, #$715D, #$0C23, #$1047, #$08F9, #$2950,
      #$9DF4, #$4AF1, #$10C0, #$325E, #$81BD, #$3273, #$7168, #$B5CF,
      #$716A, #$4624, #$22A1, #$2C60, #$3324, #$55A4, #$3302, #$7171,
      #$CE92, #$3341, #$23B4, #$7175, #$3347, #$2D6A, #$AD77, #$9E5F,
      #$3393, #$DF5D, #$E51D, #$3390, #$0BF2, #$9F80, #$9EC1, #$31E3,
      #$331C, #$36DE, #$354B, #$8298, #$3485, #$9330, #$3495, #$A28D,
      #$352C, #$B61F, #$0CD7, #$35F8, #$35B8, #$718F, #$93BC, #$81BD,
      #$410A, #$A2B6, #$68D4, #$AE4C, #$BE5D, #$36A1, #$36A5, #$653B,
      #$0D26, #$35FA, #$0D17, #$370D, #$4096, #$B668, #$B663, #$3745,
      #$372D, #$371F, #$A37E, #$3775, #$B580, #$1D77, #$3791, #$1358,
      #$93E9, #$37A0, #$37A3, #$319F, #$A680, #$37D8, #$A4B7, #$A4B8,
      #$3804, #$A464, #$A465, #$380B, #$8BF5, #$3827, #$BB26, #$3833,
      #$81BD, #$71BB, #$A4F1, #$DBB4, #$A488, #$BBD3, #$4945, #$9EF7,
      #$6A64, #$38C2, #$B15C, #$B661, #$0DEB, #$3BBA, #$AA02, #$81BD,
      #$3927, #$3922, #$71CC, #$71CD, #$3997, #$1769, #$39E2, #$3FD0,
      #$62FC, #$39C1, #$A666, #$CD60, #$3A1D,
      #$71D7, #$3BA1, #$3BCB, #$DE9F, #$3B33, #$3A83, #$A80D, #$3AC1,
      #$3AC0, #$0FB2, #$0CC1, #$A87C, #$0E40, #$396C, #$3B21, #$DE0A,
      #$157C, #$3AF6, #$3B58, #$0E61, #$8509, #$54E3, #$2250, #$3BB9,
      #$71EF, #$996A, #$3C05, #$71F2, #$3C5D, #$0EB3, #$3971, #$3C88,
      #$E25C, #$0ECD, #$3CDD, #$71FA, #$329E, #$3CF5, #$3D34, #$71FE,
      #$4035, #$AA5B, #$84F5, #$7202, #$0A00, #$25E1, #$AA9A, #$3DA1,
      #$ACBC, #$3D9C, #$3DF7, #$9B8B, #$720B, #$CB51, #$3E1A, #$53A6,
      #$3E39, #$ABBC, #$1745, #$ABBD, #$AF64, #$B54C, #$B540, #$AB09,
      #$09A5, #$0F6B, #$7219, #$6C43, #$A4B9, #$721C, #$510F, #$39F7,
      #$CD25, #$CD61, #$CDAB, #$3F56, #$3F1C, #$3FFC, #$4084, #$B5BF,
      #$7227, #$CE32, #$56B3, #$CF34, #$2387, #$81BD, #$81BD, #$55AE,
      #$DEE1, #$81BD, #$AC2F, #$45D3, #$AD42, #$4B4C, #$3FCF, #$2C51,
      #$A34B, #$4178, #$09CD, #$411D, #$AC30, #$407A, #$9117, #$ADFD,
      #$17D5, #$64B0, #$40C4, #$40DC, #$0FCE, #$40F4, #$7245, #$0FBB,
      #$411F, #$AF04, #$4153, #$724A, #$AF15, #$ADF9, #$C220, #$724E,
      #$AEFF, #$239F, #$AF16, #$AF17, #$AF00, #$C55D, #$41CB, #$41FE,
      #$4227, #$4201, #$424C, #$4255, #$4256, #$425F, #$1384, #$1068,
      #$4334, #$4316, #$B037, #$42AB, #$42C5, #$2C48, #$42CA, #$81BD,
      #$2E5C, #$B125, #$42CF, #$6422, #$726B, #$42AC, #$B21A, #$B667,
      #$B662, #$433A, #$DFA8, #$423D, #$438E,
      #$6502, #$4395, #$2AD1, #$6503, #$43A4, #$6401, #$727A, #$43AE,
      #$43C0, #$B5B4, #$3A7D, #$43D5, #$43D7, #$10D5, #$7282, #$39CD,
      #$40BD, #$4402, #$81BD, #$44AB, #$B4E3, #$DCAB, #$1B6D, #$DC84,
      #$44A8, #$44AE, #$454F, #$452A, #$7290, #$CAAE, #$4549, #$45C9,
      #$AFA2, #$92A7, #$B664, #$37E3, #$0985, #$B5F7, #$B5CD, #$729B,
      #$4577, #$4595, #$3AC3, #$B666, #$45B9, #$72A1, #$1157, #$81BD,
      #$9EAD, #$45E0, #$E132, #$45C7, #$4564, #$45F6, #$5539, #$45EC,
      #$09F0, #$45F4, #$64B1, #$3BEC, #$4602, #$1BD3, #$72B2, #$AF1F,
      #$B6B9, #$DF4F, #$2D06, #$72B7, #$945E, #$4648, #$9548, #$468E,
      #$81BD, #$469E, #$E159, #$95CB, #$2D97, #$72C1, #$6445, #$46CD,
      #$46CA, #$46E7, #$46EE, #$BA02, #$1184, #$72C9, #$470E, #$45DD,
      #$471E, #$4734, #$4782, #$47AC, #$47D1, #$47CF, #$47EF, #$47F6,
      #$72D4, #$4810, #$536F, #$0AB8, #$C9D1, #$C9CE, #$4821, #$4825,
      #$4837, #$484C, #$CF5F, #$55E2, #$BA9D, #$BAFD, #$72E2, #$489E,
      #$48A6, #$48C0, #$366F, #$BB60, #$48D8, #$A56C, #$492F, #$72EB,
      #$72EC, #$9281, #$4974, #$81BD, #$72F0, #$72F1, #$3A8A, #$4A2F,
      #$4A47, #$4A53, #$6765, #$4AAE, #$BD20, #$4A57, #$4AB4, #$4A31,
      #$D2CC, #$60B8, #$59C4, #$DEEB, #$7300, #$9C5C, #$4B06, #$5A40,
      #$3AC2, #$4B00, #$BF17, #$4B1D, #$D639, #$4ABC, #$4B29, #$3FAA,
      #$D0E6, #$1128, #$4B46, #$E20D, #$4B54);
  HKSCS_5Map: array[0..944] of Integer = (
      $00080, $000C0, $00100, $00140, $001C0, $00240, $00280, $002C0,
      $00400, $00440, $01E80, $01EC0, $02100, $02140, $02180, $021C0,
      $02440, $02540, $02700, $02E80, $02EC0, $02F00, $03000, $03040,
      $03080, $030C0, $03200, $03400, $03440, $03480, $034C0, $03500,
      $03540, $03580, $035C0, $03600, $03640, $03680, $036C0, $03700,
      $03740, $03780, $037C0, $03800, $03840, $03880, $038C0, $03900,
      $03940, $03980, $039C0, $03A00, $03A40, $03A80, $03AC0, $03B00,
      $03B40, $03B80, $03BC0, $03C00, $03C40, $03CC0, $03D00, $03D40,
      $03D80, $03DC0, $03E00, $03E40, $03E80, $03EC0, $03F00, $03F40,
      $03F80, $03FC0, $04000, $04040, $04080, $040C0, $04100, $04140,
      $04180, $041C0, $04200, $04240, $04280, $042C0, $04300, $04340,
      $04380, $043C0, $04400, $04440, $04480, $044C0, $04500, $04540,
      $04580, $045C0, $04600, $04640, $04680, $046C0, $04700, $04740,
      $04780, $047C0, $04800, $04840, $04880, $048C0, $04900, $04940,
      $04980, $049C0, $04A00, $04A80, $04AC0, $04B00, $04B40, $04B80,
      $04BC0, $04C00, $04C40, $04C80, $04CC0, $04D00, $04D80, $04E00,
      $04E40, $04E80, $04EC0, $04F00, $04F40, $04F80, $04FC0, $05000,
      $05040, $05080, $050C0, $05100, $05140, $05180, $051C0, $05200,
      $05240, $05280, $052C0, $05300, $05340, $05380, $053C0, $05400,
      $05440, $05480, $054C0, $05500, $05540, $05580, $055C0, $05600,
      $05640, $05680, $056C0, $05700, $05740, $05780, $057C0, $05800,
      $05840, $05880, $058C0, $05900, $05940, $05980, $059C0, $05A00,
      $05A40, $05A80, $05AC0, $05B00, $05B40, $05B80, $05BC0, $05C00,
      $05C40, $05C80, $05CC0, $05D00, $05D40, $05D80, $05DC0, $05E00,
      $05E40, $05E80, $05EC0, $05F00, $05F40, $05F80, $05FC0, $06000,
      $06040, $06080, $060C0, $06100, $06140, $06180, $061C0, $06200,
      $06240, $06280, $062C0, $06300, $06340, $06380, $063C0, $06400,
      $06440, $06480, $064C0, $06500, $06540, $06580, $065C0, $06600,
      $06640, $06680, $066C0, $06700, $06740, $06780, $067C0, $06800,
      $06840, $06880, $068C0, $06900, $06940, $06980, $069C0, $06A00,
      $06A40, $06A80, $06AC0, $06B00, $06B40, $06B80, $06BC0, $06C00,
      $06C40, $06C80, $06CC0, $06D00, $06D40, $06D80, $06E00, $06E40,
      $06E80, $06EC0, $06F00, $06F40, $06F80, $06FC0, $07000, $07040,
      $07080, $070C0, $07100, $07140, $07180, $071C0, $07200, $07240,
      $07280, $072C0, $07300, $07340, $07380, $073C0, $07400, $07440,
      $07480, $074C0, $07500, $07540, $07580, $075C0, $07600, $07640,
      $07680, $076C0, $07700, $07740, $07780, $077C0, $07800, $07840,
      $07880, $078C0, $07900, $07940, $07980, $079C0, $07A00, $07A40,
      $07A80, $07AC0, $07B00, $07B40, $07B80, $07BC0, $07C00, $07C40,
      $07C80, $07CC0, $07D00, $07D40, $07D80, $07DC0, $07E00, $07E40,
      $07E80, $07EC0, $07F00, $07F40, $07F80, $07FC0, $08000, $08040,
      $08080, $080C0, $08100, $08140, $08180, $081C0, $08200, $08240,
      $08280, $082C0, $08300, $08340, $08380, $083C0, $08400, $08440,
      $08480, $084C0, $08500, $08540, $085C0, $08600, $08640, $08680,
      $086C0, $08700, $08740, $08780, $087C0, $08800, $08840, $08880,
      $088C0, $08900, $08940, $08980, $089C0, $08A00, $08A40, $08A80,
      $08AC0, $08B00, $08B40, $08B80, $08BC0, $08C40, $08C80, $08CC0,
      $08D00, $08D40, $08D80, $08DC0, $08E00, $08E40, $08E80, $08EC0,
      $08F00, $08F40, $08F80, $08FC0, $09000, $09040, $09080, $090C0,
      $09140, $09180, $091C0, $09200, $09240, $09280, $092C0, $09300,
      $09340, $09380, $093C0, $09400, $09440, $09480, $094C0, $09500,
      $09540, $09580, $095C0, $09600, $09640, $09680, $096C0, $09700,
      $09740, $09780, $097C0, $09800, $09840, $09880, $098C0, $09900,
      $09940, $09980, $099C0, $09A00, $09A40, $09A80, $09AC0, $09B00,
      $09B40, $09B80, $09BC0, $09C00, $09C40, $09D00, $09D40, $09D80,
      $09DC0, $09E00, $09E40, $09E80, $09EC0, $09F00, $09F40, $09F80,
      $0E000, $0E040, $0E080, $0E0C0, $0E100, $0E140, $0E180, $0E1C0,
      $0E200, $0E240, $0E280, $0E2C0, $0E300, $0E340, $0E380, $0E3C0,
      $0E400, $0E440, $0E480, $0E4C0, $0E500, $0E540, $0E580, $0E5C0,
      $0E600, $0E640, $0E680, $0E6C0, $0E700, $0E740, $0E780, $0E7C0,
      $0E800, $0E840, $0E880, $0E8C0, $0E900, $0E940, $0E980, $0E9C0,
      $0EA80, $0EAC0, $0EB00, $0EB40, $0EB80, $0EBC0, $0EC00, $0EC40,
      $0EC80, $0ECC0, $0ED00, $0ED40, $0ED80, $0EDC0, $0EE00, $0EE40,
      $0EE80, $0F300, $0F340, $0F380, $0F3C0, $0F400, $0F440, $0F480,
      $0F4C0, $0F500, $0F540, $0F680, $0F7C0, $0FF00, $0FFC0, $20000,
      $20040, $200C0, $20100, $20180, $201C0, $20200, $20240, $20280,
      $202C0, $20300, $20340, $20380, $203C0, $20400, $20440, $20480,
      $204C0, $20540, $20580, $205C0, $20600, $20700, $20740, $20800,
      $20840, $20900, $20940, $20A00, $20A40, $20A80, $20B80, $20BC0,
      $20C00, $20C40, $20C80, $20CC0, $20D40, $20D80, $20E00, $20E40,
      $20E80, $20EC0, $20F00, $20F80, $20FC0, $21000, $21040, $21080,
      $210C0, $21100, $21140, $21180, $211C0, $21240, $21280, $212C0,
      $21300, $21380, $213C0, $21440, $21480, $214C0, $21580, $21600,
      $21640, $21680, $216C0, $21700, $21740, $21780, $217C0, $21800,
      $21840, $21880, $218C0, $21900, $21940, $21980, $219C0, $21A40,
      $21B40, $21C80, $21D40, $21D80, $21DC0, $21E00, $21E80, $21EC0,
      $21F40, $21F80, $22040, $22080, $220C0, $22100, $22140, $22180,
      $221C0, $22240, $22300, $22380, $223C0, $22440, $22480, $22500,
      $22580, $22600, $22640, $22680, $226C0, $22700, $22740, $22780,
      $22800, $22840, $22880, $228C0, $22900, $22940, $22980, $22AC0,
      $22B00, $22B40, $22BC0, $22C00, $22C40, $22C80, $22CC0, $22D00,
      $22D40, $22D80, $22E00, $22E40, $22FC0, $23040, $23080, $230C0,
      $23100, $23180, $231C0, $23200, $23240, $23280, $232C0, $23300,
      $23380, $233C0, $23400, $23440, $234C0, $23500, $23540, $23580,
      $235C0, $23600, $23640, $23680, $236C0, $23700, $23740, $23780,
      $237C0, $23AC0, $23B40, $23C80, $23CC0, $23D40, $23D80, $23DC0,
      $23E00, $23E80, $23EC0, $23F00, $23F40, $23F80, $23FC0, $24000,
      $24040, $24080, $240C0, $24100, $24140, $24180, $241C0, $24200,
      $24240, $24280, $242C0, $24300, $24340, $24380, $243C0, $24400,
      $24440, $24480, $244C0, $24500, $24540, $24600, $24640, $24680,
      $246C0, $24700, $24780, $24800, $248C0, $24900, $24940, $24980,
      $249C0, $24A00, $24A40, $24A80, $24AC0, $24B40, $24BC0, $24C00,
      $24C80, $24CC0, $24D00, $24D80, $24DC0, $24E40, $24F00, $24F40,
      $24F80, $24FC0, $25080, $25140, $251C0, $25200, $252C0, $25300,
      $25400, $25440, $25540, $25580, $255C0, $25600, $25640, $25680,
      $256C0, $25700, $25740, $257C0, $25840, $258C0, $25940, $25980,
      $25A80, $25AC0, $25B40, $25B80, $25BC0, $25C00, $25C40, $25CC0,
      $25D00, $25D40, $25E00, $25E80, $25EC0, $25F40, $25FC0, $26000,
      $26040, $26080, $26100, $26140, $26180, $261C0, $26240, $262C0,
      $26340, $26380, $26400, $26480, $26500, $26540, $26580, $26600,
      $26680, $266C0, $26740, $26780, $267C0, $26840, $26880, $26900,
      $26980, $269C0, $26A00, $26A40, $26B00, $26B40, $26B80, $26BC0,
      $26C00, $26C40, $26C80, $26CC0, $26D00, $26D80, $26DC0, $26E00,
      $26E40, $26E80, $26EC0, $26F00, $26F40, $26F80, $26FC0, $27000,
      $27040, $27080, $270C0, $27100, $27140, $27200, $272C0, $27380,
      $27400, $27480, $275C0, $27600, $27640, $27680, $27700, $27740,
      $27780, $27840, $27900, $27940, $27A00, $27A40, $27A80, $27AC0,
      $27B00, $27BC0, $27C00, $27D00, $27D40, $27D80, $27DC0, $27E40,
      $28000, $28080, $280C0, $28100, $28140, $28200, $28240, $282C0,
      $28300, $28340, $28400, $28480, $28500, $28540, $285C0, $28600,
      $28680, $286C0, $28800, $28900, $28940, $28980, $289C0, $28A00,
      $28A40, $28A80, $28AC0, $28B00, $28B40, $28B80, $28BC0, $28C00,
      $28CC0, $28D00, $28E00, $28E40, $28E80, $28EC0, $29080, $290C0,
      $29100, $29180, $291C0, $29400, $29440, $294C0, $29580, $295C0,
      $29840, $29880, $298C0, $29900, $29940, $29980, $29B00, $29BC0,
      $29C80, $29D00, $29D40, $29E00, $29E40, $29E80, $29EC0, $29F00,
      $29F80, $2A0C0, $2A100, $2A140, $2A180, $2A1C0, $2A200, $2A280,
      $2A2C0, $2A380, $2A5C0, $2A680, $2F840, $2F880, $2F8C0, $2F980,
      $2F9C0);
  JIS_X0208_1Map: array[0..689] of TBuffChar = (
      #$3000, #$3001, #$3002, #$FF0C, #$FF0E, #$30FB, #$FF1A, #$FF1B,
      #$FF1F, #$FF01, #$309B, #$309C, #$00B4, #$FF40, #$00A8, #$FF3E,
      #$FFE3, #$FF3F, #$30FD, #$30FE, #$309D, #$309E, #$3003, #$4EDD,
      #$3005, #$3006, #$3007, #$30FC, #$2015, #$2010, #$FF0F, #$FF3C,
      #$301C, #$2016, #$FF5C, #$2026, #$2025, #$2018, #$2019, #$201C,
      #$201D, #$FF08, #$FF09, #$3014, #$3015, #$FF3B, #$FF3D, #$FF5B,
      #$FF5D, #$3008, #$3009, #$300A, #$300B, #$300C, #$300D, #$300E,
      #$300F, #$3010, #$3011, #$FF0B, #$2212, #$00B1, #$00D7, #$00F7,
      #$FF1D, #$2260, #$FF1C, #$FF1E, #$2266, #$2267, #$221E, #$2234,
      #$2642, #$2640, #$00B0, #$2032, #$2033, #$2103, #$FFE5, #$FF04,
      #$00A2, #$00A3, #$FF05, #$FF03, #$FF06, #$FF0A, #$FF20, #$00A7,
      #$2606, #$2605, #$25CB, #$25CF, #$25CE, #$25C7,
      #$25C6, #$25A1, #$25A0, #$25B3, #$25B2, #$25BD, #$25BC, #$203B,
      #$3012, #$2192, #$2190, #$2191, #$2193, #$3013, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$2208, #$220B, #$2286, #$2287, #$2282, #$2283, #$222A,
      #$2229, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$2227, #$2228, #$00AC, #$21D2, #$21D4, #$2200, #$2203,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$2220, #$22A5, #$2312, #$2202, #$2207,
      #$2261, #$2252, #$226A, #$226B, #$221A, #$223D, #$221D, #$2235,
      #$222B, #$222C, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$212B, #$2030, #$266F, #$266D, #$266A, #$2020, #$2021,
      #$00B6, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$25EF,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FF10,
      #$FF11, #$FF12, #$FF13, #$FF14, #$FF15, #$FF16, #$FF17, #$FF18,
      #$FF19, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FF21, #$FF22, #$FF23, #$FF24, #$FF25, #$FF26, #$FF27, #$FF28,
      #$FF29, #$FF2A, #$FF2B, #$FF2C, #$FF2D, #$FF2E, #$FF2F, #$FF30,
      #$FF31, #$FF32, #$FF33, #$FF34, #$FF35, #$FF36, #$FF37, #$FF38,
      #$FF39, #$FF3A, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FF41, #$FF42, #$FF43, #$FF44, #$FF45, #$FF46, #$FF47, #$FF48,
      #$FF49, #$FF4A, #$FF4B, #$FF4C, #$FF4D, #$FF4E, #$FF4F, #$FF50,
      #$FF51, #$FF52, #$FF53, #$FF54, #$FF55, #$FF56, #$FF57, #$FF58,
      #$FF59, #$FF5A, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$3041, #$3042, #$3043, #$3044, #$3045, #$3046, #$3047, #$3048,
      #$3049, #$304A, #$304B, #$304C, #$304D, #$304E, #$304F, #$3050,
      #$3051, #$3052, #$3053, #$3054, #$3055, #$3056, #$3057, #$3058,
      #$3059, #$305A, #$305B, #$305C, #$305D, #$305E, #$305F, #$3060,
      #$3061, #$3062, #$3063, #$3064, #$3065, #$3066, #$3067, #$3068,
      #$3069, #$306A, #$306B, #$306C, #$306D, #$306E, #$306F, #$3070,
      #$3071, #$3072, #$3073, #$3074, #$3075, #$3076, #$3077, #$3078,
      #$3079, #$307A, #$307B, #$307C, #$307D, #$307E, #$307F, #$3080,
      #$3081, #$3082, #$3083, #$3084, #$3085, #$3086, #$3087, #$3088,
      #$3089, #$308A, #$308B, #$308C, #$308D, #$308E, #$308F, #$3090,
      #$3091, #$3092, #$3093, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$30A1, #$30A2, #$30A3, #$30A4, #$30A5, #$30A6, #$30A7, #$30A8,
      #$30A9, #$30AA, #$30AB, #$30AC, #$30AD, #$30AE, #$30AF, #$30B0,
      #$30B1, #$30B2, #$30B3, #$30B4, #$30B5, #$30B6, #$30B7, #$30B8,
      #$30B9, #$30BA, #$30BB, #$30BC, #$30BD, #$30BE, #$30BF, #$30C0,
      #$30C1, #$30C2, #$30C3, #$30C4, #$30C5, #$30C6, #$30C7, #$30C8,
      #$30C9, #$30CA, #$30CB, #$30CC, #$30CD, #$30CE, #$30CF, #$30D0,
      #$30D1, #$30D2, #$30D3, #$30D4, #$30D5, #$30D6, #$30D7, #$30D8,
      #$30D9, #$30DA, #$30DB, #$30DC, #$30DD, #$30DE, #$30DF, #$30E0,
      #$30E1, #$30E2, #$30E3, #$30E4, #$30E5, #$30E6, #$30E7, #$30E8,
      #$30E9, #$30EA, #$30EB, #$30EC, #$30ED, #$30EE, #$30EF, #$30F0,
      #$30F1, #$30F2, #$30F3, #$30F4, #$30F5, #$30F6, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0391, #$0392, #$0393, #$0394, #$0395, #$0396, #$0397, #$0398,
      #$0399, #$039A, #$039B, #$039C, #$039D, #$039E, #$039F, #$03A0,
      #$03A1, #$03A3, #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$03B1, #$03B2, #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8,
      #$03B9, #$03BA, #$03BB, #$03BC, #$03BD, #$03BE, #$03BF, #$03C0,
      #$03C1, #$03C3, #$03C4, #$03C5, #$03C6, #$03C7, #$03C8, #$03C9,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0410, #$0411, #$0412, #$0413, #$0414, #$0415, #$0401, #$0416,
      #$0417, #$0418, #$0419, #$041A, #$041B, #$041C, #$041D, #$041E,
      #$041F, #$0420, #$0421, #$0422, #$0423, #$0424, #$0425, #$0426,
      #$0427, #$0428, #$0429, #$042A, #$042B, #$042C, #$042D, #$042E,
      #$042F, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0430, #$0431, #$0432, #$0433, #$0434, #$0435, #$0451, #$0436,
      #$0437, #$0438, #$0439, #$043A, #$043B, #$043C, #$043D, #$043E,
      #$043F, #$0440, #$0441, #$0442, #$0443, #$0444, #$0445, #$0446,
      #$0447, #$0448, #$0449, #$044A, #$044B, #$044C, #$044D, #$044E,
      #$044F, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$2500, #$2502, #$250C, #$2510, #$2518, #$2514, #$251C, #$252C,
      #$2524, #$2534, #$253C, #$2501, #$2503, #$250F, #$2513, #$251B,
      #$2517, #$2523, #$2533, #$252B, #$253B, #$254B, #$2520, #$252F,
      #$2528, #$2537, #$253F, #$251D, #$2530, #$2525, #$2538, #$2542);
  JIS_X0208_2Map: array[0..6397] of TBuffChar = (
      #$4E9C, #$5516, #$5A03, #$963F, #$54C0, #$611B, #$6328, #$59F6,
      #$9022, #$8475, #$831C, #$7A50, #$60AA, #$63E1, #$6E25, #$65ED,
      #$8466, #$82A6, #$9BF5, #$6893, #$5727, #$65A1, #$6271, #$5B9B,
      #$59D0, #$867B, #$98F4, #$7D62, #$7DBE, #$9B8E, #$6216, #$7C9F,
      #$88B7, #$5B89, #$5EB5, #$6309, #$6697, #$6848, #$95C7, #$978D,
      #$674F, #$4EE5, #$4F0A, #$4F4D, #$4F9D, #$5049, #$56F2, #$5937,
      #$59D4, #$5A01, #$5C09, #$60DF, #$610F, #$6170, #$6613, #$6905,
      #$70BA, #$754F, #$7570, #$79FB, #$7DAD, #$7DEF, #$80C3, #$840E,
      #$8863, #$8B02, #$9055, #$907A, #$533B, #$4E95, #$4EA5, #$57DF,
      #$80B2, #$90C1, #$78EF, #$4E00, #$58F1, #$6EA2, #$9038, #$7A32,
      #$8328, #$828B, #$9C2F, #$5141, #$5370, #$54BD, #$54E1, #$56E0,
      #$59FB, #$5F15, #$98F2, #$6DEB, #$80E4, #$852D,
      #$9662, #$9670, #$96A0, #$97FB, #$540B, #$53F3, #$5B87, #$70CF,
      #$7FBD, #$8FC2, #$96E8, #$536F, #$9D5C, #$7ABA, #$4E11, #$7893,
      #$81FC, #$6E26, #$5618, #$5504, #$6B1D, #$851A, #$9C3B, #$59E5,
      #$53A9, #$6D66, #$74DC, #$958F, #$5642, #$4E91, #$904B, #$96F2,
      #$834F, #$990C, #$53E1, #$55B6, #$5B30, #$5F71, #$6620, #$66F3,
      #$6804, #$6C38, #$6CF3, #$6D29, #$745B, #$76C8, #$7A4E, #$9834,
      #$82F1, #$885B, #$8A60, #$92ED, #$6DB2, #$75AB, #$76CA, #$99C5,
      #$60A6, #$8B01, #$8D8A, #$95B2, #$698E, #$53AD, #$5186, #$5712,
      #$5830, #$5944, #$5BB4, #$5EF6, #$6028, #$63A9, #$63F4, #$6CBF,
      #$6F14, #$708E, #$7114, #$7159, #$71D5, #$733F, #$7E01, #$8276,
      #$82D1, #$8597, #$9060, #$925B, #$9D1B, #$5869, #$65BC, #$6C5A,
      #$7525, #$51F9, #$592E, #$5965, #$5F80, #$5FDC,
      #$62BC, #$65FA, #$6A2A, #$6B27, #$6BB4, #$738B, #$7FC1, #$8956,
      #$9D2C, #$9D0E, #$9EC4, #$5CA1, #$6C96, #$837B, #$5104, #$5C4B,
      #$61B6, #$81C6, #$6876, #$7261, #$4E59, #$4FFA, #$5378, #$6069,
      #$6E29, #$7A4F, #$97F3, #$4E0B, #$5316, #$4EEE, #$4F55, #$4F3D,
      #$4FA1, #$4F73, #$52A0, #$53EF, #$5609, #$590F, #$5AC1, #$5BB6,
      #$5BE1, #$79D1, #$6687, #$679C, #$67B6, #$6B4C, #$6CB3, #$706B,
      #$73C2, #$798D, #$79BE, #$7A3C, #$7B87, #$82B1, #$82DB, #$8304,
      #$8377, #$83EF, #$83D3, #$8766, #$8AB2, #$5629, #$8CA8, #$8FE6,
      #$904E, #$971E, #$868A, #$4FC4, #$5CE8, #$6211, #$7259, #$753B,
      #$81E5, #$82BD, #$86FE, #$8CC0, #$96C5, #$9913, #$99D5, #$4ECB,
      #$4F1A, #$89E3, #$56DE, #$584A, #$58CA, #$5EFB, #$5FEB, #$602A,
      #$6094, #$6062, #$61D0, #$6212, #$62D0, #$6539,
      #$9B41, #$6666, #$68B0, #$6D77, #$7070, #$754C, #$7686, #$7D75,
      #$82A5, #$87F9, #$958B, #$968E, #$8C9D, #$51F1, #$52BE, #$5916,
      #$54B3, #$5BB3, #$5D16, #$6168, #$6982, #$6DAF, #$788D, #$84CB,
      #$8857, #$8A72, #$93A7, #$9AB8, #$6D6C, #$99A8, #$86D9, #$57A3,
      #$67FF, #$86CE, #$920E, #$5283, #$5687, #$5404, #$5ED3, #$62E1,
      #$64B9, #$683C, #$6838, #$6BBB, #$7372, #$78BA, #$7A6B, #$899A,
      #$89D2, #$8D6B, #$8F03, #$90ED, #$95A3, #$9694, #$9769, #$5B66,
      #$5CB3, #$697D, #$984D, #$984E, #$639B, #$7B20, #$6A2B, #$6A7F,
      #$68B6, #$9C0D, #$6F5F, #$5272, #$559D, #$6070, #$62EC, #$6D3B,
      #$6E07, #$6ED1, #$845B, #$8910, #$8F44, #$4E14, #$9C39, #$53F6,
      #$691B, #$6A3A, #$9784, #$682A, #$515C, #$7AC3, #$84B2, #$91DC,
      #$938C, #$565B, #$9D28, #$6822, #$8305, #$8431,
      #$7CA5, #$5208, #$82C5, #$74E6, #$4E7E, #$4F83, #$51A0, #$5BD2,
      #$520A, #$52D8, #$52E7, #$5DFB, #$559A, #$582A, #$59E6, #$5B8C,
      #$5B98, #$5BDB, #$5E72, #$5E79, #$60A3, #$611F, #$6163, #$61BE,
      #$63DB, #$6562, #$67D1, #$6853, #$68FA, #$6B3E, #$6B53, #$6C57,
      #$6F22, #$6F97, #$6F45, #$74B0, #$7518, #$76E3, #$770B, #$7AFF,
      #$7BA1, #$7C21, #$7DE9, #$7F36, #$7FF0, #$809D, #$8266, #$839E,
      #$89B3, #$8ACC, #$8CAB, #$9084, #$9451, #$9593, #$9591, #$95A2,
      #$9665, #$97D3, #$9928, #$8218, #$4E38, #$542B, #$5CB8, #$5DCC,
      #$73A9, #$764C, #$773C, #$5CA9, #$7FEB, #$8D0B, #$96C1, #$9811,
      #$9854, #$9858, #$4F01, #$4F0E, #$5371, #$559C, #$5668, #$57FA,
      #$5947, #$5B09, #$5BC4, #$5C90, #$5E0C, #$5E7E, #$5FCC, #$63EE,
      #$673A, #$65D7, #$65E2, #$671F, #$68CB, #$68C4,
      #$6A5F, #$5E30, #$6BC5, #$6C17, #$6C7D, #$757F, #$7948, #$5B63,
      #$7A00, #$7D00, #$5FBD, #$898F, #$8A18, #$8CB4, #$8D77, #$8ECC,
      #$8F1D, #$98E2, #$9A0E, #$9B3C, #$4E80, #$507D, #$5100, #$5993,
      #$5B9C, #$622F, #$6280, #$64EC, #$6B3A, #$72A0, #$7591, #$7947,
      #$7FA9, #$87FB, #$8ABC, #$8B70, #$63AC, #$83CA, #$97A0, #$5409,
      #$5403, #$55AB, #$6854, #$6A58, #$8A70, #$7827, #$6775, #$9ECD,
      #$5374, #$5BA2, #$811A, #$8650, #$9006, #$4E18, #$4E45, #$4EC7,
      #$4F11, #$53CA, #$5438, #$5BAE, #$5F13, #$6025, #$6551, #$673D,
      #$6C42, #$6C72, #$6CE3, #$7078, #$7403, #$7A76, #$7AAE, #$7B08,
      #$7D1A, #$7CFE, #$7D66, #$65E7, #$725B, #$53BB, #$5C45, #$5DE8,
      #$62D2, #$62E0, #$6319, #$6E20, #$865A, #$8A31, #$8DDD, #$92F8,
      #$6F01, #$79A6, #$9B5A, #$4EA8, #$4EAB, #$4EAC,
      #$4F9B, #$4FA0, #$50D1, #$5147, #$7AF6, #$5171, #$51F6, #$5354,
      #$5321, #$537F, #$53EB, #$55AC, #$5883, #$5CE1, #$5F37, #$5F4A,
      #$602F, #$6050, #$606D, #$631F, #$6559, #$6A4B, #$6CC1, #$72C2,
      #$72ED, #$77EF, #$80F8, #$8105, #$8208, #$854E, #$90F7, #$93E1,
      #$97FF, #$9957, #$9A5A, #$4EF0, #$51DD, #$5C2D, #$6681, #$696D,
      #$5C40, #$66F2, #$6975, #$7389, #$6850, #$7C81, #$50C5, #$52E4,
      #$5747, #$5DFE, #$9326, #$65A4, #$6B23, #$6B3D, #$7434, #$7981,
      #$79BD, #$7B4B, #$7DCA, #$82B9, #$83CC, #$887F, #$895F, #$8B39,
      #$8FD1, #$91D1, #$541F, #$9280, #$4E5D, #$5036, #$53E5, #$533A,
      #$72D7, #$7396, #$77E9, #$82E6, #$8EAF, #$99C6, #$99C8, #$99D2,
      #$5177, #$611A, #$865E, #$55B0, #$7A7A, #$5076, #$5BD3, #$9047,
      #$9685, #$4E32, #$6ADB, #$91E7, #$5C51, #$5C48,
      #$6398, #$7A9F, #$6C93, #$9774, #$8F61, #$7AAA, #$718A, #$9688,
      #$7C82, #$6817, #$7E70, #$6851, #$936C, #$52F2, #$541B, #$85AB,
      #$8A13, #$7FA4, #$8ECD, #$90E1, #$5366, #$8888, #$7941, #$4FC2,
      #$50BE, #$5211, #$5144, #$5553, #$572D, #$73EA, #$578B, #$5951,
      #$5F62, #$5F84, #$6075, #$6176, #$6167, #$61A9, #$63B2, #$643A,
      #$656C, #$666F, #$6842, #$6E13, #$7566, #$7A3D, #$7CFB, #$7D4C,
      #$7D99, #$7E4B, #$7F6B, #$830E, #$834A, #$86CD, #$8A08, #$8A63,
      #$8B66, #$8EFD, #$981A, #$9D8F, #$82B8, #$8FCE, #$9BE8, #$5287,
      #$621F, #$6483, #$6FC0, #$9699, #$6841, #$5091, #$6B20, #$6C7A,
      #$6F54, #$7A74, #$7D50, #$8840, #$8A23, #$6708, #$4EF6, #$5039,
      #$5026, #$5065, #$517C, #$5238, #$5263, #$55A7, #$570F, #$5805,
      #$5ACC, #$5EFA, #$61B2, #$61F8, #$62F3, #$6372,
      #$691C, #$6A29, #$727D, #$72AC, #$732E, #$7814, #$786F, #$7D79,
      #$770C, #$80A9, #$898B, #$8B19, #$8CE2, #$8ED2, #$9063, #$9375,
      #$967A, #$9855, #$9A13, #$9E78, #$5143, #$539F, #$53B3, #$5E7B,
      #$5F26, #$6E1B, #$6E90, #$7384, #$73FE, #$7D43, #$8237, #$8A00,
      #$8AFA, #$9650, #$4E4E, #$500B, #$53E4, #$547C, #$56FA, #$59D1,
      #$5B64, #$5DF1, #$5EAB, #$5F27, #$6238, #$6545, #$67AF, #$6E56,
      #$72D0, #$7CCA, #$88B4, #$80A1, #$80E1, #$83F0, #$864E, #$8A87,
      #$8DE8, #$9237, #$96C7, #$9867, #$9F13, #$4E94, #$4E92, #$4F0D,
      #$5348, #$5449, #$543E, #$5A2F, #$5F8C, #$5FA1, #$609F, #$68A7,
      #$6A8E, #$745A, #$7881, #$8A9E, #$8AA4, #$8B77, #$9190, #$4E5E,
      #$9BC9, #$4EA4, #$4F7C, #$4FAF, #$5019, #$5016, #$5149, #$516C,
      #$529F, #$52B9, #$52FE, #$539A, #$53E3, #$5411,
      #$540E, #$5589, #$5751, #$57A2, #$597D, #$5B54, #$5B5D, #$5B8F,
      #$5DE5, #$5DE7, #$5DF7, #$5E78, #$5E83, #$5E9A, #$5EB7, #$5F18,
      #$6052, #$614C, #$6297, #$62D8, #$63A7, #$653B, #$6602, #$6643,
      #$66F4, #$676D, #$6821, #$6897, #$69CB, #$6C5F, #$6D2A, #$6D69,
      #$6E2F, #$6E9D, #$7532, #$7687, #$786C, #$7A3F, #$7CE0, #$7D05,
      #$7D18, #$7D5E, #$7DB1, #$8015, #$8003, #$80AF, #$80B1, #$8154,
      #$818F, #$822A, #$8352, #$884C, #$8861, #$8B1B, #$8CA2, #$8CFC,
      #$90CA, #$9175, #$9271, #$783F, #$92FC, #$95A4, #$964D, #$9805,
      #$9999, #$9AD8, #$9D3B, #$525B, #$52AB, #$53F7, #$5408, #$58D5,
      #$62F7, #$6FE0, #$8C6A, #$8F5F, #$9EB9, #$514B, #$523B, #$544A,
      #$56FD, #$7A40, #$9177, #$9D60, #$9ED2, #$7344, #$6F09, #$8170,
      #$7511, #$5FFD, #$60DA, #$9AA8, #$72DB, #$8FBC,
      #$6B64, #$9803, #$4ECA, #$56F0, #$5764, #$58BE, #$5A5A, #$6068,
      #$61C7, #$660F, #$6606, #$6839, #$68B1, #$6DF7, #$75D5, #$7D3A,
      #$826E, #$9B42, #$4E9B, #$4F50, #$53C9, #$5506, #$5D6F, #$5DE6,
      #$5DEE, #$67FB, #$6C99, #$7473, #$7802, #$8A50, #$9396, #$88DF,
      #$5750, #$5EA7, #$632B, #$50B5, #$50AC, #$518D, #$6700, #$54C9,
      #$585E, #$59BB, #$5BB0, #$5F69, #$624D, #$63A1, #$683D, #$6B73,
      #$6E08, #$707D, #$91C7, #$7280, #$7815, #$7826, #$796D, #$658E,
      #$7D30, #$83DC, #$88C1, #$8F09, #$969B, #$5264, #$5728, #$6750,
      #$7F6A, #$8CA1, #$51B4, #$5742, #$962A, #$583A, #$698A, #$80B4,
      #$54B2, #$5D0E, #$57FC, #$7895, #$9DFA, #$4F5C, #$524A, #$548B,
      #$643E, #$6628, #$6714, #$67F5, #$7A84, #$7B56, #$7D22, #$932F,
      #$685C, #$9BAD, #$7B39, #$5319, #$518A, #$5237,
      #$5BDF, #$62F6, #$64AE, #$64E6, #$672D, #$6BBA, #$85A9, #$96D1,
      #$7690, #$9BD6, #$634C, #$9306, #$9BAB, #$76BF, #$6652, #$4E09,
      #$5098, #$53C2, #$5C71, #$60E8, #$6492, #$6563, #$685F, #$71E6,
      #$73CA, #$7523, #$7B97, #$7E82, #$8695, #$8B83, #$8CDB, #$9178,
      #$9910, #$65AC, #$66AB, #$6B8B, #$4ED5, #$4ED4, #$4F3A, #$4F7F,
      #$523A, #$53F8, #$53F2, #$55E3, #$56DB, #$58EB, #$59CB, #$59C9,
      #$59FF, #$5B50, #$5C4D, #$5E02, #$5E2B, #$5FD7, #$601D, #$6307,
      #$652F, #$5B5C, #$65AF, #$65BD, #$65E8, #$679D, #$6B62, #$6B7B,
      #$6C0F, #$7345, #$7949, #$79C1, #$7CF8, #$7D19, #$7D2B, #$80A2,
      #$8102, #$81F3, #$8996, #$8A5E, #$8A69, #$8A66, #$8A8C, #$8AEE,
      #$8CC7, #$8CDC, #$96CC, #$98FC, #$6B6F, #$4E8B, #$4F3C, #$4F8D,
      #$5150, #$5B57, #$5BFA, #$6148, #$6301, #$6642,
      #$6B21, #$6ECB, #$6CBB, #$723E, #$74BD, #$75D4, #$78C1, #$793A,
      #$800C, #$8033, #$81EA, #$8494, #$8F9E, #$6C50, #$9E7F, #$5F0F,
      #$8B58, #$9D2B, #$7AFA, #$8EF8, #$5B8D, #$96EB, #$4E03, #$53F1,
      #$57F7, #$5931, #$5AC9, #$5BA4, #$6089, #$6E7F, #$6F06, #$75BE,
      #$8CEA, #$5B9F, #$8500, #$7BE0, #$5072, #$67F4, #$829D, #$5C61,
      #$854A, #$7E1E, #$820E, #$5199, #$5C04, #$6368, #$8D66, #$659C,
      #$716E, #$793E, #$7D17, #$8005, #$8B1D, #$8ECA, #$906E, #$86C7,
      #$90AA, #$501F, #$52FA, #$5C3A, #$6753, #$707C, #$7235, #$914C,
      #$91C8, #$932B, #$82E5, #$5BC2, #$5F31, #$60F9, #$4E3B, #$53D6,
      #$5B88, #$624B, #$6731, #$6B8A, #$72E9, #$73E0, #$7A2E, #$816B,
      #$8DA3, #$9152, #$9996, #$5112, #$53D7, #$546A, #$5BFF, #$6388,
      #$6A39, #$7DAC, #$9700, #$56DA, #$53CE, #$5468,
      #$5B97, #$5C31, #$5DDE, #$4FEE, #$6101, #$62FE, #$6D32, #$79C0,
      #$79CB, #$7D42, #$7E4D, #$7FD2, #$81ED, #$821F, #$8490, #$8846,
      #$8972, #$8B90, #$8E74, #$8F2F, #$9031, #$914B, #$916C, #$96C6,
      #$919C, #$4EC0, #$4F4F, #$5145, #$5341, #$5F93, #$620E, #$67D4,
      #$6C41, #$6E0B, #$7363, #$7E26, #$91CD, #$9283, #$53D4, #$5919,
      #$5BBF, #$6DD1, #$795D, #$7E2E, #$7C9B, #$587E, #$719F, #$51FA,
      #$8853, #$8FF0, #$4FCA, #$5CFB, #$6625, #$77AC, #$7AE3, #$821C,
      #$99FF, #$51C6, #$5FAA, #$65EC, #$696F, #$6B89, #$6DF3, #$6E96,
      #$6F64, #$76FE, #$7D14, #$5DE1, #$9075, #$9187, #$9806, #$51E6,
      #$521D, #$6240, #$6691, #$66D9, #$6E1A, #$5EB6, #$7DD2, #$7F72,
      #$66F8, #$85AF, #$85F7, #$8AF8, #$52A9, #$53D9, #$5973, #$5E8F,
      #$5F90, #$6055, #$92E4, #$9664, #$50B7, #$511F,
      #$52DD, #$5320, #$5347, #$53EC, #$54E8, #$5546, #$5531, #$5617,
      #$5968, #$59BE, #$5A3C, #$5BB5, #$5C06, #$5C0F, #$5C11, #$5C1A,
      #$5E84, #$5E8A, #$5EE0, #$5F70, #$627F, #$6284, #$62DB, #$638C,
      #$6377, #$6607, #$660C, #$662D, #$6676, #$677E, #$68A2, #$6A1F,
      #$6A35, #$6CBC, #$6D88, #$6E09, #$6E58, #$713C, #$7126, #$7167,
      #$75C7, #$7701, #$785D, #$7901, #$7965, #$79F0, #$7AE0, #$7B11,
      #$7CA7, #$7D39, #$8096, #$83D6, #$848B, #$8549, #$885D, #$88F3,
      #$8A1F, #$8A3C, #$8A54, #$8A73, #$8C61, #$8CDE, #$91A4, #$9266,
      #$937E, #$9418, #$969C, #$9798, #$4E0A, #$4E08, #$4E1E, #$4E57,
      #$5197, #$5270, #$57CE, #$5834, #$58CC, #$5B22, #$5E38, #$60C5,
      #$64FE, #$6761, #$6756, #$6D44, #$72B6, #$7573, #$7A63, #$84B8,
      #$8B72, #$91B8, #$9320, #$5631, #$57F4, #$98FE,
      #$62ED, #$690D, #$6B96, #$71ED, #$7E54, #$8077, #$8272, #$89E6,
      #$98DF, #$8755, #$8FB1, #$5C3B, #$4F38, #$4FE1, #$4FB5, #$5507,
      #$5A20, #$5BDD, #$5BE9, #$5FC3, #$614E, #$632F, #$65B0, #$664B,
      #$68EE, #$699B, #$6D78, #$6DF1, #$7533, #$75B9, #$771F, #$795E,
      #$79E6, #$7D33, #$81E3, #$82AF, #$85AA, #$89AA, #$8A3A, #$8EAB,
      #$8F9B, #$9032, #$91DD, #$9707, #$4EBA, #$4EC1, #$5203, #$5875,
      #$58EC, #$5C0B, #$751A, #$5C3D, #$814E, #$8A0A, #$8FC5, #$9663,
      #$976D, #$7B25, #$8ACF, #$9808, #$9162, #$56F3, #$53A8, #$9017,
      #$5439, #$5782, #$5E25, #$63A8, #$6C34, #$708A, #$7761, #$7C8B,
      #$7FE0, #$8870, #$9042, #$9154, #$9310, #$9318, #$968F, #$745E,
      #$9AC4, #$5D07, #$5D69, #$6570, #$67A2, #$8DA8, #$96DB, #$636E,
      #$6749, #$6919, #$83C5, #$9817, #$96C0, #$88FE,
      #$6F84, #$647A, #$5BF8, #$4E16, #$702C, #$755D, #$662F, #$51C4,
      #$5236, #$52E2, #$59D3, #$5F81, #$6027, #$6210, #$653F, #$6574,
      #$661F, #$6674, #$68F2, #$6816, #$6B63, #$6E05, #$7272, #$751F,
      #$76DB, #$7CBE, #$8056, #$58F0, #$88FD, #$897F, #$8AA0, #$8A93,
      #$8ACB, #$901D, #$9192, #$9752, #$9759, #$6589, #$7A0E, #$8106,
      #$96BB, #$5E2D, #$60DC, #$621A, #$65A5, #$6614, #$6790, #$77F3,
      #$7A4D, #$7C4D, #$7E3E, #$810A, #$8CAC, #$8D64, #$8DE1, #$8E5F,
      #$78A9, #$5207, #$62D9, #$63A5, #$6442, #$6298, #$8A2D, #$7A83,
      #$7BC0, #$8AAC, #$96EA, #$7D76, #$820C, #$8749, #$4ED9, #$5148,
      #$5343, #$5360, #$5BA3, #$5C02, #$5C16, #$5DDD, #$6226, #$6247,
      #$64B0, #$6813, #$6834, #$6CC9, #$6D45, #$6D17, #$67D3, #$6F5C,
      #$714E, #$717D, #$65CB, #$7A7F, #$7BAD, #$7DDA,
      #$7E4A, #$7FA8, #$817A, #$821B, #$8239, #$85A6, #$8A6E, #$8CCE,
      #$8DF5, #$9078, #$9077, #$92AD, #$9291, #$9583, #$9BAE, #$524D,
      #$5584, #$6F38, #$7136, #$5168, #$7985, #$7E55, #$81B3, #$7CCE,
      #$564C, #$5851, #$5CA8, #$63AA, #$66FE, #$66FD, #$695A, #$72D9,
      #$758F, #$758E, #$790E, #$7956, #$79DF, #$7C97, #$7D20, #$7D44,
      #$8607, #$8A34, #$963B, #$9061, #$9F20, #$50E7, #$5275, #$53CC,
      #$53E2, #$5009, #$55AA, #$58EE, #$594F, #$723D, #$5B8B, #$5C64,
      #$531D, #$60E3, #$60F3, #$635C, #$6383, #$633F, #$63BB, #$64CD,
      #$65E9, #$66F9, #$5DE3, #$69CD, #$69FD, #$6F15, #$71E5, #$4E89,
      #$75E9, #$76F8, #$7A93, #$7CDF, #$7DCF, #$7D9C, #$8061, #$8349,
      #$8358, #$846C, #$84BC, #$85FB, #$88C5, #$8D70, #$9001, #$906D,
      #$9397, #$971C, #$9A12, #$50CF, #$5897, #$618E,
      #$81D3, #$8535, #$8D08, #$9020, #$4FC3, #$5074, #$5247, #$5373,
      #$606F, #$6349, #$675F, #$6E2C, #$8DB3, #$901F, #$4FD7, #$5C5E,
      #$8CCA, #$65CF, #$7D9A, #$5352, #$8896, #$5176, #$63C3, #$5B58,
      #$5B6B, #$5C0A, #$640D, #$6751, #$905C, #$4ED6, #$591A, #$592A,
      #$6C70, #$8A51, #$553E, #$5815, #$59A5, #$60F0, #$6253, #$67C1,
      #$8235, #$6955, #$9640, #$99C4, #$9A28, #$4F53, #$5806, #$5BFE,
      #$8010, #$5CB1, #$5E2F, #$5F85, #$6020, #$614B, #$6234, #$66FF,
      #$6CF0, #$6EDE, #$80CE, #$817F, #$82D4, #$888B, #$8CB8, #$9000,
      #$902E, #$968A, #$9EDB, #$9BDB, #$4EE3, #$53F0, #$5927, #$7B2C,
      #$918D, #$984C, #$9DF9, #$6EDD, #$7027, #$5353, #$5544, #$5B85,
      #$6258, #$629E, #$62D3, #$6CA2, #$6FEF, #$7422, #$8A17, #$9438,
      #$6FC1, #$8AFE, #$8338, #$51E7, #$86F8, #$53EA,
      #$53E9, #$4F46, #$9054, #$8FB0, #$596A, #$8131, #$5DFD, #$7AEA,
      #$8FBF, #$68DA, #$8C37, #$72F8, #$9C48, #$6A3D, #$8AB0, #$4E39,
      #$5358, #$5606, #$5766, #$62C5, #$63A2, #$65E6, #$6B4E, #$6DE1,
      #$6E5B, #$70AD, #$77ED, #$7AEF, #$7BAA, #$7DBB, #$803D, #$80C6,
      #$86CB, #$8A95, #$935B, #$56E3, #$58C7, #$5F3E, #$65AD, #$6696,
      #$6A80, #$6BB5, #$7537, #$8AC7, #$5024, #$77E5, #$5730, #$5F1B,
      #$6065, #$667A, #$6C60, #$75F4, #$7A1A, #$7F6E, #$81F4, #$8718,
      #$9045, #$99B3, #$7BC9, #$755C, #$7AF9, #$7B51, #$84C4, #$9010,
      #$79E9, #$7A92, #$8336, #$5AE1, #$7740, #$4E2D, #$4EF2, #$5B99,
      #$5FE0, #$62BD, #$663C, #$67F1, #$6CE8, #$866B, #$8877, #$8A3B,
      #$914E, #$92F3, #$99D0, #$6A17, #$7026, #$732A, #$82E7, #$8457,
      #$8CAF, #$4E01, #$5146, #$51CB, #$558B, #$5BF5,
      #$5E16, #$5E33, #$5E81, #$5F14, #$5F35, #$5F6B, #$5FB4, #$61F2,
      #$6311, #$66A2, #$671D, #$6F6E, #$7252, #$753A, #$773A, #$8074,
      #$8139, #$8178, #$8776, #$8ABF, #$8ADC, #$8D85, #$8DF3, #$929A,
      #$9577, #$9802, #$9CE5, #$52C5, #$6357, #$76F4, #$6715, #$6C88,
      #$73CD, #$8CC3, #$93AE, #$9673, #$6D25, #$589C, #$690E, #$69CC,
      #$8FFD, #$939A, #$75DB, #$901A, #$585A, #$6802, #$63B4, #$69FB,
      #$4F43, #$6F2C, #$67D8, #$8FBB, #$8526, #$7DB4, #$9354, #$693F,
      #$6F70, #$576A, #$58F7, #$5B2C, #$7D2C, #$722A, #$540A, #$91E3,
      #$9DB4, #$4EAD, #$4F4E, #$505C, #$5075, #$5243, #$8C9E, #$5448,
      #$5824, #$5B9A, #$5E1D, #$5E95, #$5EAD, #$5EF7, #$5F1F, #$608C,
      #$62B5, #$633A, #$63D0, #$68AF, #$6C40, #$7887, #$798E, #$7A0B,
      #$7DE0, #$8247, #$8A02, #$8AE6, #$8E44, #$9013,
      #$90B8, #$912D, #$91D8, #$9F0E, #$6CE5, #$6458, #$64E2, #$6575,
      #$6EF4, #$7684, #$7B1B, #$9069, #$93D1, #$6EBA, #$54F2, #$5FB9,
      #$64A4, #$8F4D, #$8FED, #$9244, #$5178, #$586B, #$5929, #$5C55,
      #$5E97, #$6DFB, #$7E8F, #$751C, #$8CBC, #$8EE2, #$985B, #$70B9,
      #$4F1D, #$6BBF, #$6FB1, #$7530, #$96FB, #$514E, #$5410, #$5835,
      #$5857, #$59AC, #$5C60, #$5F92, #$6597, #$675C, #$6E21, #$767B,
      #$83DF, #$8CED, #$9014, #$90FD, #$934D, #$7825, #$783A, #$52AA,
      #$5EA6, #$571F, #$5974, #$6012, #$5012, #$515A, #$51AC, #$51CD,
      #$5200, #$5510, #$5854, #$5858, #$5957, #$5B95, #$5CF6, #$5D8B,
      #$60BC, #$6295, #$642D, #$6771, #$6843, #$68BC, #$68DF, #$76D7,
      #$6DD8, #$6E6F, #$6D9B, #$706F, #$71C8, #$5F53, #$75D8, #$7977,
      #$7B49, #$7B54, #$7B52, #$7CD6, #$7D71, #$5230,
      #$8463, #$8569, #$85E4, #$8A0E, #$8B04, #$8C46, #$8E0F, #$9003,
      #$900F, #$9419, #$9676, #$982D, #$9A30, #$95D8, #$50CD, #$52D5,
      #$540C, #$5802, #$5C0E, #$61A7, #$649E, #$6D1E, #$77B3, #$7AE5,
      #$80F4, #$8404, #$9053, #$9285, #$5CE0, #$9D07, #$533F, #$5F97,
      #$5FB3, #$6D9C, #$7279, #$7763, #$79BF, #$7BE4, #$6BD2, #$72EC,
      #$8AAD, #$6803, #$6A61, #$51F8, #$7A81, #$6934, #$5C4A, #$9CF6,
      #$82EB, #$5BC5, #$9149, #$701E, #$5678, #$5C6F, #$60C7, #$6566,
      #$6C8C, #$8C5A, #$9041, #$9813, #$5451, #$66C7, #$920D, #$5948,
      #$90A3, #$5185, #$4E4D, #$51EA, #$8599, #$8B0E, #$7058, #$637A,
      #$934B, #$6962, #$99B4, #$7E04, #$7577, #$5357, #$6960, #$8EDF,
      #$96E3, #$6C5D, #$4E8C, #$5C3C, #$5F10, #$8FE9, #$5302, #$8CD1,
      #$8089, #$8679, #$5EFF, #$65E5, #$4E73, #$5165,
      #$5982, #$5C3F, #$97EE, #$4EFB, #$598A, #$5FCD, #$8A8D, #$6FE1,
      #$79B0, #$7962, #$5BE7, #$8471, #$732B, #$71B1, #$5E74, #$5FF5,
      #$637B, #$649A, #$71C3, #$7C98, #$4E43, #$5EFC, #$4E4B, #$57DC,
      #$56A2, #$60A9, #$6FC3, #$7D0D, #$80FD, #$8133, #$81BF, #$8FB2,
      #$8997, #$86A4, #$5DF4, #$628A, #$64AD, #$8987, #$6777, #$6CE2,
      #$6D3E, #$7436, #$7834, #$5A46, #$7F75, #$82AD, #$99AC, #$4FF3,
      #$5EC3, #$62DD, #$6392, #$6557, #$676F, #$76C3, #$724C, #$80CC,
      #$80BA, #$8F29, #$914D, #$500D, #$57F9, #$5A92, #$6885, #$6973,
      #$7164, #$72FD, #$8CB7, #$58F2, #$8CE0, #$966A, #$9019, #$877F,
      #$79E4, #$77E7, #$8429, #$4F2F, #$5265, #$535A, #$62CD, #$67CF,
      #$6CCA, #$767D, #$7B94, #$7C95, #$8236, #$8584, #$8FEB, #$66DD,
      #$6F20, #$7206, #$7E1B, #$83AB, #$99C1, #$9EA6,
      #$51FD, #$7BB1, #$7872, #$7BB8, #$8087, #$7B48, #$6AE8, #$5E61,
      #$808C, #$7551, #$7560, #$516B, #$9262, #$6E8C, #$767A, #$9197,
      #$9AEA, #$4F10, #$7F70, #$629C, #$7B4F, #$95A5, #$9CE9, #$567A,
      #$5859, #$86E4, #$96BC, #$4F34, #$5224, #$534A, #$53CD, #$53DB,
      #$5E06, #$642C, #$6591, #$677F, #$6C3E, #$6C4E, #$7248, #$72AF,
      #$73ED, #$7554, #$7E41, #$822C, #$85E9, #$8CA9, #$7BC4, #$91C6,
      #$7169, #$9812, #$98EF, #$633D, #$6669, #$756A, #$76E4, #$78D0,
      #$8543, #$86EE, #$532A, #$5351, #$5426, #$5983, #$5E87, #$5F7C,
      #$60B2, #$6249, #$6279, #$62AB, #$6590, #$6BD4, #$6CCC, #$75B2,
      #$76AE, #$7891, #$79D8, #$7DCB, #$7F77, #$80A5, #$88AB, #$8AB9,
      #$8CBB, #$907F, #$975E, #$98DB, #$6A0B, #$7C38, #$5099, #$5C3E,
      #$5FAE, #$6787, #$6BD8, #$7435, #$7709, #$7F8E,
      #$9F3B, #$67CA, #$7A17, #$5339, #$758B, #$9AED, #$5F66, #$819D,
      #$83F1, #$8098, #$5F3C, #$5FC5, #$7562, #$7B46, #$903C, #$6867,
      #$59EB, #$5A9B, #$7D10, #$767E, #$8B2C, #$4FF5, #$5F6A, #$6A19,
      #$6C37, #$6F02, #$74E2, #$7968, #$8868, #$8A55, #$8C79, #$5EDF,
      #$63CF, #$75C5, #$79D2, #$82D7, #$9328, #$92F2, #$849C, #$86ED,
      #$9C2D, #$54C1, #$5F6C, #$658C, #$6D5C, #$7015, #$8CA7, #$8CD3,
      #$983B, #$654F, #$74F6, #$4E0D, #$4ED8, #$57E0, #$592B, #$5A66,
      #$5BCC, #$51A8, #$5E03, #$5E9C, #$6016, #$6276, #$6577, #$65A7,
      #$666E, #$6D6E, #$7236, #$7B26, #$8150, #$819A, #$8299, #$8B5C,
      #$8CA0, #$8CE6, #$8D74, #$961C, #$9644, #$4FAE, #$64AB, #$6B66,
      #$821E, #$8461, #$856A, #$90E8, #$5C01, #$6953, #$98A8, #$847A,
      #$8557, #$4F0F, #$526F, #$5FA9, #$5E45, #$670D,
      #$798F, #$8179, #$8907, #$8986, #$6DF5, #$5F17, #$6255, #$6CB8,
      #$4ECF, #$7269, #$9B92, #$5206, #$543B, #$5674, #$58B3, #$61A4,
      #$626E, #$711A, #$596E, #$7C89, #$7CDE, #$7D1B, #$96F0, #$6587,
      #$805E, #$4E19, #$4F75, #$5175, #$5840, #$5E63, #$5E73, #$5F0A,
      #$67C4, #$4E26, #$853D, #$9589, #$965B, #$7C73, #$9801, #$50FB,
      #$58C1, #$7656, #$78A7, #$5225, #$77A5, #$8511, #$7B86, #$504F,
      #$5909, #$7247, #$7BC7, #$7DE8, #$8FBA, #$8FD4, #$904D, #$4FBF,
      #$52C9, #$5A29, #$5F01, #$97AD, #$4FDD, #$8217, #$92EA, #$5703,
      #$6355, #$6B69, #$752B, #$88DC, #$8F14, #$7A42, #$52DF, #$5893,
      #$6155, #$620A, #$66AE, #$6BCD, #$7C3F, #$83E9, #$5023, #$4FF8,
      #$5305, #$5446, #$5831, #$5949, #$5B9D, #$5CF0, #$5CEF, #$5D29,
      #$5E96, #$62B1, #$6367, #$653E, #$65B9, #$670B,
      #$6CD5, #$6CE1, #$70F9, #$7832, #$7E2B, #$80DE, #$82B3, #$840C,
      #$84EC, #$8702, #$8912, #$8A2A, #$8C4A, #$90A6, #$92D2, #$98FD,
      #$9CF3, #$9D6C, #$4E4F, #$4EA1, #$508D, #$5256, #$574A, #$59A8,
      #$5E3D, #$5FD8, #$5FD9, #$623F, #$66B4, #$671B, #$67D0, #$68D2,
      #$5192, #$7D21, #$80AA, #$81A8, #$8B00, #$8C8C, #$8CBF, #$927E,
      #$9632, #$5420, #$982C, #$5317, #$50D5, #$535C, #$58A8, #$64B2,
      #$6734, #$7267, #$7766, #$7A46, #$91E6, #$52C3, #$6CA1, #$6B86,
      #$5800, #$5E4C, #$5954, #$672C, #$7FFB, #$51E1, #$76C6, #$6469,
      #$78E8, #$9B54, #$9EBB, #$57CB, #$59B9, #$6627, #$679A, #$6BCE,
      #$54E9, #$69D9, #$5E55, #$819C, #$6795, #$9BAA, #$67FE, #$9C52,
      #$685D, #$4EA6, #$4FE3, #$53C8, #$62B9, #$672B, #$6CAB, #$8FC4,
      #$4FAD, #$7E6D, #$9EBF, #$4E07, #$6162, #$6E80,
      #$6F2B, #$8513, #$5473, #$672A, #$9B45, #$5DF3, #$7B95, #$5CAC,
      #$5BC6, #$871C, #$6E4A, #$84D1, #$7A14, #$8108, #$5999, #$7C8D,
      #$6C11, #$7720, #$52D9, #$5922, #$7121, #$725F, #$77DB, #$9727,
      #$9D61, #$690B, #$5A7F, #$5A18, #$51A5, #$540D, #$547D, #$660E,
      #$76DF, #$8FF7, #$9298, #$9CF4, #$59EA, #$725D, #$6EC5, #$514D,
      #$68C9, #$7DBF, #$7DEC, #$9762, #$9EBA, #$6478, #$6A21, #$8302,
      #$5984, #$5B5F, #$6BDB, #$731B, #$76F2, #$7DB2, #$8017, #$8499,
      #$5132, #$6728, #$9ED9, #$76EE, #$6762, #$52FF, #$9905, #$5C24,
      #$623B, #$7C7E, #$8CB0, #$554F, #$60B6, #$7D0B, #$9580, #$5301,
      #$4E5F, #$51B6, #$591C, #$723A, #$8036, #$91CE, #$5F25, #$77E2,
      #$5384, #$5F79, #$7D04, #$85AC, #$8A33, #$8E8D, #$9756, #$67F3,
      #$85AE, #$9453, #$6109, #$6108, #$6CB9, #$7652,
      #$8AED, #$8F38, #$552F, #$4F51, #$512A, #$52C7, #$53CB, #$5BA5,
      #$5E7D, #$60A0, #$6182, #$63D6, #$6709, #$67DA, #$6E67, #$6D8C,
      #$7336, #$7337, #$7531, #$7950, #$88D5, #$8A98, #$904A, #$9091,
      #$90F5, #$96C4, #$878D, #$5915, #$4E88, #$4F59, #$4E0E, #$8A89,
      #$8F3F, #$9810, #$50AD, #$5E7C, #$5996, #$5BB9, #$5EB8, #$63DA,
      #$63FA, #$64C1, #$66DC, #$694A, #$69D8, #$6D0B, #$6EB6, #$7194,
      #$7528, #$7AAF, #$7F8A, #$8000, #$8449, #$84C9, #$8981, #$8B21,
      #$8E0A, #$9065, #$967D, #$990A, #$617E, #$6291, #$6B32, #$6C83,
      #$6D74, #$7FCC, #$7FFC, #$6DC0, #$7F85, #$87BA, #$88F8, #$6765,
      #$83B1, #$983C, #$96F7, #$6D1B, #$7D61, #$843D, #$916A, #$4E71,
      #$5375, #$5D50, #$6B04, #$6FEB, #$85CD, #$862D, #$89A7, #$5229,
      #$540F, #$5C65, #$674E, #$68A8, #$7406, #$7483,
      #$75E2, #$88CF, #$88E1, #$91CC, #$96E2, #$9678, #$5F8B, #$7387,
      #$7ACB, #$844E, #$63A0, #$7565, #$5289, #$6D41, #$6E9C, #$7409,
      #$7559, #$786B, #$7C92, #$9686, #$7ADC, #$9F8D, #$4FB6, #$616E,
      #$65C5, #$865C, #$4E86, #$4EAE, #$50DA, #$4E21, #$51CC, #$5BEE,
      #$6599, #$6881, #$6DBC, #$731F, #$7642, #$77AD, #$7A1C, #$7CE7,
      #$826F, #$8AD2, #$907C, #$91CF, #$9675, #$9818, #$529B, #$7DD1,
      #$502B, #$5398, #$6797, #$6DCB, #$71D0, #$7433, #$81E8, #$8F2A,
      #$96A3, #$9C57, #$9E9F, #$7460, #$5841, #$6D99, #$7D2F, #$985E,
      #$4EE4, #$4F36, #$4F8B, #$51B7, #$52B1, #$5DBA, #$601C, #$73B2,
      #$793C, #$82D3, #$9234, #$96B7, #$96F6, #$970A, #$9E97, #$9F62,
      #$66A6, #$6B74, #$5217, #$52A3, #$70C8, #$88C2, #$5EC9, #$604B,
      #$6190, #$6F23, #$7149, #$7C3E, #$7DF4, #$806F,
      #$84EE, #$9023, #$932C, #$5442, #$9B6F, #$6AD3, #$7089, #$8CC2,
      #$8DEF, #$9732, #$52B4, #$5A41, #$5ECA, #$5F04, #$6717, #$697C,
      #$6994, #$6D6A, #$6F0F, #$7262, #$72FC, #$7BED, #$8001, #$807E,
      #$874B, #$90CE, #$516D, #$9E93, #$7984, #$808B, #$9332, #$8AD6,
      #$502D, #$548C, #$8A71, #$6B6A, #$8CC4, #$8107, #$60D1, #$67A0,
      #$9DF2, #$4E99, #$4E98, #$9C10, #$8A6B, #$85C1, #$8568, #$6900,
      #$6E7E, #$7897, #$8155, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$5F0C, #$4E10, #$4E15, #$4E2A, #$4E31, #$4E36, #$4E3C, #$4E3F,
      #$4E42, #$4E56, #$4E58, #$4E82, #$4E85, #$8C6B, #$4E8A, #$8212,
      #$5F0D, #$4E8E, #$4E9E, #$4E9F, #$4EA0, #$4EA2, #$4EB0, #$4EB3,
      #$4EB6, #$4ECE, #$4ECD, #$4EC4, #$4EC6, #$4EC2, #$4ED7, #$4EDE,
      #$4EED, #$4EDF, #$4EF7, #$4F09, #$4F5A, #$4F30, #$4F5B, #$4F5D,
      #$4F57, #$4F47, #$4F76, #$4F88, #$4F8F, #$4F98, #$4F7B, #$4F69,
      #$4F70, #$4F91, #$4F6F, #$4F86, #$4F96, #$5118, #$4FD4, #$4FDF,
      #$4FCE, #$4FD8, #$4FDB, #$4FD1, #$4FDA, #$4FD0, #$4FE4, #$4FE5,
      #$501A, #$5028, #$5014, #$502A, #$5025, #$5005, #$4F1C, #$4FF6,
      #$5021, #$5029, #$502C, #$4FFE, #$4FEF, #$5011, #$5006, #$5043,
      #$5047, #$6703, #$5055, #$5050, #$5048, #$505A, #$5056, #$506C,
      #$5078, #$5080, #$509A, #$5085, #$50B4, #$50B2,
      #$50C9, #$50CA, #$50B3, #$50C2, #$50D6, #$50DE, #$50E5, #$50ED,
      #$50E3, #$50EE, #$50F9, #$50F5, #$5109, #$5101, #$5102, #$5116,
      #$5115, #$5114, #$511A, #$5121, #$513A, #$5137, #$513C, #$513B,
      #$513F, #$5140, #$5152, #$514C, #$5154, #$5162, #$7AF8, #$5169,
      #$516A, #$516E, #$5180, #$5182, #$56D8, #$518C, #$5189, #$518F,
      #$5191, #$5193, #$5195, #$5196, #$51A4, #$51A6, #$51A2, #$51A9,
      #$51AA, #$51AB, #$51B3, #$51B1, #$51B2, #$51B0, #$51B5, #$51BD,
      #$51C5, #$51C9, #$51DB, #$51E0, #$8655, #$51E9, #$51ED, #$51F0,
      #$51F5, #$51FE, #$5204, #$520B, #$5214, #$520E, #$5227, #$522A,
      #$522E, #$5233, #$5239, #$524F, #$5244, #$524B, #$524C, #$525E,
      #$5254, #$526A, #$5274, #$5269, #$5273, #$527F, #$527D, #$528D,
      #$5294, #$5292, #$5271, #$5288, #$5291, #$8FA8,
      #$8FA7, #$52AC, #$52AD, #$52BC, #$52B5, #$52C1, #$52CD, #$52D7,
      #$52DE, #$52E3, #$52E6, #$98ED, #$52E0, #$52F3, #$52F5, #$52F8,
      #$52F9, #$5306, #$5308, #$7538, #$530D, #$5310, #$530F, #$5315,
      #$531A, #$5323, #$532F, #$5331, #$5333, #$5338, #$5340, #$5346,
      #$5345, #$4E17, #$5349, #$534D, #$51D6, #$535E, #$5369, #$536E,
      #$5918, #$537B, #$5377, #$5382, #$5396, #$53A0, #$53A6, #$53A5,
      #$53AE, #$53B0, #$53B6, #$53C3, #$7C12, #$96D9, #$53DF, #$66FC,
      #$71EE, #$53EE, #$53E8, #$53ED, #$53FA, #$5401, #$543D, #$5440,
      #$542C, #$542D, #$543C, #$542E, #$5436, #$5429, #$541D, #$544E,
      #$548F, #$5475, #$548E, #$545F, #$5471, #$5477, #$5470, #$5492,
      #$547B, #$5480, #$5476, #$5484, #$5490, #$5486, #$54C7, #$54A2,
      #$54B8, #$54A5, #$54AC, #$54C4, #$54C8, #$54A8,
      #$54AB, #$54C2, #$54A4, #$54BE, #$54BC, #$54D8, #$54E5, #$54E6,
      #$550F, #$5514, #$54FD, #$54EE, #$54ED, #$54FA, #$54E2, #$5539,
      #$5540, #$5563, #$554C, #$552E, #$555C, #$5545, #$5556, #$5557,
      #$5538, #$5533, #$555D, #$5599, #$5580, #$54AF, #$558A, #$559F,
      #$557B, #$557E, #$5598, #$559E, #$55AE, #$557C, #$5583, #$55A9,
      #$5587, #$55A8, #$55DA, #$55C5, #$55DF, #$55C4, #$55DC, #$55E4,
      #$55D4, #$5614, #$55F7, #$5616, #$55FE, #$55FD, #$561B, #$55F9,
      #$564E, #$5650, #$71DF, #$5634, #$5636, #$5632, #$5638, #$566B,
      #$5664, #$562F, #$566C, #$566A, #$5686, #$5680, #$568A, #$56A0,
      #$5694, #$568F, #$56A5, #$56AE, #$56B6, #$56B4, #$56C2, #$56BC,
      #$56C1, #$56C3, #$56C0, #$56C8, #$56CE, #$56D1, #$56D3, #$56D7,
      #$56EE, #$56F9, #$5700, #$56FF, #$5704, #$5709,
      #$5708, #$570B, #$570D, #$5713, #$5718, #$5716, #$55C7, #$571C,
      #$5726, #$5737, #$5738, #$574E, #$573B, #$5740, #$574F, #$5769,
      #$57C0, #$5788, #$5761, #$577F, #$5789, #$5793, #$57A0, #$57B3,
      #$57A4, #$57AA, #$57B0, #$57C3, #$57C6, #$57D4, #$57D2, #$57D3,
      #$580A, #$57D6, #$57E3, #$580B, #$5819, #$581D, #$5872, #$5821,
      #$5862, #$584B, #$5870, #$6BC0, #$5852, #$583D, #$5879, #$5885,
      #$58B9, #$589F, #$58AB, #$58BA, #$58DE, #$58BB, #$58B8, #$58AE,
      #$58C5, #$58D3, #$58D1, #$58D7, #$58D9, #$58D8, #$58E5, #$58DC,
      #$58E4, #$58DF, #$58EF, #$58FA, #$58F9, #$58FB, #$58FC, #$58FD,
      #$5902, #$590A, #$5910, #$591B, #$68A6, #$5925, #$592C, #$592D,
      #$5932, #$5938, #$593E, #$7AD2, #$5955, #$5950, #$594E, #$595A,
      #$5958, #$5962, #$5960, #$5967, #$596C, #$5969,
      #$5978, #$5981, #$599D, #$4F5E, #$4FAB, #$59A3, #$59B2, #$59C6,
      #$59E8, #$59DC, #$598D, #$59D9, #$59DA, #$5A25, #$5A1F, #$5A11,
      #$5A1C, #$5A09, #$5A1A, #$5A40, #$5A6C, #$5A49, #$5A35, #$5A36,
      #$5A62, #$5A6A, #$5A9A, #$5ABC, #$5ABE, #$5ACB, #$5AC2, #$5ABD,
      #$5AE3, #$5AD7, #$5AE6, #$5AE9, #$5AD6, #$5AFA, #$5AFB, #$5B0C,
      #$5B0B, #$5B16, #$5B32, #$5AD0, #$5B2A, #$5B36, #$5B3E, #$5B43,
      #$5B45, #$5B40, #$5B51, #$5B55, #$5B5A, #$5B5B, #$5B65, #$5B69,
      #$5B70, #$5B73, #$5B75, #$5B78, #$6588, #$5B7A, #$5B80, #$5B83,
      #$5BA6, #$5BB8, #$5BC3, #$5BC7, #$5BC9, #$5BD4, #$5BD0, #$5BE4,
      #$5BE6, #$5BE2, #$5BDE, #$5BE5, #$5BEB, #$5BF0, #$5BF6, #$5BF3,
      #$5C05, #$5C07, #$5C08, #$5C0D, #$5C13, #$5C20, #$5C22, #$5C28,
      #$5C38, #$5C39, #$5C41, #$5C46, #$5C4E, #$5C53,
      #$5C50, #$5C4F, #$5B71, #$5C6C, #$5C6E, #$4E62, #$5C76, #$5C79,
      #$5C8C, #$5C91, #$5C94, #$599B, #$5CAB, #$5CBB, #$5CB6, #$5CBC,
      #$5CB7, #$5CC5, #$5CBE, #$5CC7, #$5CD9, #$5CE9, #$5CFD, #$5CFA,
      #$5CED, #$5D8C, #$5CEA, #$5D0B, #$5D15, #$5D17, #$5D5C, #$5D1F,
      #$5D1B, #$5D11, #$5D14, #$5D22, #$5D1A, #$5D19, #$5D18, #$5D4C,
      #$5D52, #$5D4E, #$5D4B, #$5D6C, #$5D73, #$5D76, #$5D87, #$5D84,
      #$5D82, #$5DA2, #$5D9D, #$5DAC, #$5DAE, #$5DBD, #$5D90, #$5DB7,
      #$5DBC, #$5DC9, #$5DCD, #$5DD3, #$5DD2, #$5DD6, #$5DDB, #$5DEB,
      #$5DF2, #$5DF5, #$5E0B, #$5E1A, #$5E19, #$5E11, #$5E1B, #$5E36,
      #$5E37, #$5E44, #$5E43, #$5E40, #$5E4E, #$5E57, #$5E54, #$5E5F,
      #$5E62, #$5E64, #$5E47, #$5E75, #$5E76, #$5E7A, #$9EBC, #$5E7F,
      #$5EA0, #$5EC1, #$5EC2, #$5EC8, #$5ED0, #$5ECF,
      #$5ED6, #$5EE3, #$5EDD, #$5EDA, #$5EDB, #$5EE2, #$5EE1, #$5EE8,
      #$5EE9, #$5EEC, #$5EF1, #$5EF3, #$5EF0, #$5EF4, #$5EF8, #$5EFE,
      #$5F03, #$5F09, #$5F5D, #$5F5C, #$5F0B, #$5F11, #$5F16, #$5F29,
      #$5F2D, #$5F38, #$5F41, #$5F48, #$5F4C, #$5F4E, #$5F2F, #$5F51,
      #$5F56, #$5F57, #$5F59, #$5F61, #$5F6D, #$5F73, #$5F77, #$5F83,
      #$5F82, #$5F7F, #$5F8A, #$5F88, #$5F91, #$5F87, #$5F9E, #$5F99,
      #$5F98, #$5FA0, #$5FA8, #$5FAD, #$5FBC, #$5FD6, #$5FFB, #$5FE4,
      #$5FF8, #$5FF1, #$5FDD, #$60B3, #$5FFF, #$6021, #$6060, #$6019,
      #$6010, #$6029, #$600E, #$6031, #$601B, #$6015, #$602B, #$6026,
      #$600F, #$603A, #$605A, #$6041, #$606A, #$6077, #$605F, #$604A,
      #$6046, #$604D, #$6063, #$6043, #$6064, #$6042, #$606C, #$606B,
      #$6059, #$6081, #$608D, #$60E7, #$6083, #$609A,
      #$6084, #$609B, #$6096, #$6097, #$6092, #$60A7, #$608B, #$60E1,
      #$60B8, #$60E0, #$60D3, #$60B4, #$5FF0, #$60BD, #$60C6, #$60B5,
      #$60D8, #$614D, #$6115, #$6106, #$60F6, #$60F7, #$6100, #$60F4,
      #$60FA, #$6103, #$6121, #$60FB, #$60F1, #$610D, #$610E, #$6147,
      #$613E, #$6128, #$6127, #$614A, #$613F, #$613C, #$612C, #$6134,
      #$613D, #$6142, #$6144, #$6173, #$6177, #$6158, #$6159, #$615A,
      #$616B, #$6174, #$616F, #$6165, #$6171, #$615F, #$615D, #$6153,
      #$6175, #$6199, #$6196, #$6187, #$61AC, #$6194, #$619A, #$618A,
      #$6191, #$61AB, #$61AE, #$61CC, #$61CA, #$61C9, #$61F7, #$61C8,
      #$61C3, #$61C6, #$61BA, #$61CB, #$7F79, #$61CD, #$61E6, #$61E3,
      #$61F6, #$61FA, #$61F4, #$61FF, #$61FD, #$61FC, #$61FE, #$6200,
      #$6208, #$6209, #$620D, #$620C, #$6214, #$621B,
      #$621E, #$6221, #$622A, #$622E, #$6230, #$6232, #$6233, #$6241,
      #$624E, #$625E, #$6263, #$625B, #$6260, #$6268, #$627C, #$6282,
      #$6289, #$627E, #$6292, #$6293, #$6296, #$62D4, #$6283, #$6294,
      #$62D7, #$62D1, #$62BB, #$62CF, #$62FF, #$62C6, #$64D4, #$62C8,
      #$62DC, #$62CC, #$62CA, #$62C2, #$62C7, #$629B, #$62C9, #$630C,
      #$62EE, #$62F1, #$6327, #$6302, #$6308, #$62EF, #$62F5, #$6350,
      #$633E, #$634D, #$641C, #$634F, #$6396, #$638E, #$6380, #$63AB,
      #$6376, #$63A3, #$638F, #$6389, #$639F, #$63B5, #$636B, #$6369,
      #$63BE, #$63E9, #$63C0, #$63C6, #$63E3, #$63C9, #$63D2, #$63F6,
      #$63C4, #$6416, #$6434, #$6406, #$6413, #$6426, #$6436, #$651D,
      #$6417, #$6428, #$640F, #$6467, #$646F, #$6476, #$644E, #$652A,
      #$6495, #$6493, #$64A5, #$64A9, #$6488, #$64BC,
      #$64DA, #$64D2, #$64C5, #$64C7, #$64BB, #$64D8, #$64C2, #$64F1,
      #$64E7, #$8209, #$64E0, #$64E1, #$62AC, #$64E3, #$64EF, #$652C,
      #$64F6, #$64F4, #$64F2, #$64FA, #$6500, #$64FD, #$6518, #$651C,
      #$6505, #$6524, #$6523, #$652B, #$6534, #$6535, #$6537, #$6536,
      #$6538, #$754B, #$6548, #$6556, #$6555, #$654D, #$6558, #$655E,
      #$655D, #$6572, #$6578, #$6582, #$6583, #$8B8A, #$659B, #$659F,
      #$65AB, #$65B7, #$65C3, #$65C6, #$65C1, #$65C4, #$65CC, #$65D2,
      #$65DB, #$65D9, #$65E0, #$65E1, #$65F1, #$6772, #$660A, #$6603,
      #$65FB, #$6773, #$6635, #$6636, #$6634, #$661C, #$664F, #$6644,
      #$6649, #$6641, #$665E, #$665D, #$6664, #$6667, #$6668, #$665F,
      #$6662, #$6670, #$6683, #$6688, #$668E, #$6689, #$6684, #$6698,
      #$669D, #$66C1, #$66B9, #$66C9, #$66BE, #$66BC,
      #$66C4, #$66B8, #$66D6, #$66DA, #$66E0, #$663F, #$66E6, #$66E9,
      #$66F0, #$66F5, #$66F7, #$670F, #$6716, #$671E, #$6726, #$6727,
      #$9738, #$672E, #$673F, #$6736, #$6741, #$6738, #$6737, #$6746,
      #$675E, #$6760, #$6759, #$6763, #$6764, #$6789, #$6770, #$67A9,
      #$677C, #$676A, #$678C, #$678B, #$67A6, #$67A1, #$6785, #$67B7,
      #$67EF, #$67B4, #$67EC, #$67B3, #$67E9, #$67B8, #$67E4, #$67DE,
      #$67DD, #$67E2, #$67EE, #$67B9, #$67CE, #$67C6, #$67E7, #$6A9C,
      #$681E, #$6846, #$6829, #$6840, #$684D, #$6832, #$684E, #$68B3,
      #$682B, #$6859, #$6863, #$6877, #$687F, #$689F, #$688F, #$68AD,
      #$6894, #$689D, #$689B, #$6883, #$6AAE, #$68B9, #$6874, #$68B5,
      #$68A0, #$68BA, #$690F, #$688D, #$687E, #$6901, #$68CA, #$6908,
      #$68D8, #$6922, #$6926, #$68E1, #$690C, #$68CD,
      #$68D4, #$68E7, #$68D5, #$6936, #$6912, #$6904, #$68D7, #$68E3,
      #$6925, #$68F9, #$68E0, #$68EF, #$6928, #$692A, #$691A, #$6923,
      #$6921, #$68C6, #$6979, #$6977, #$695C, #$6978, #$696B, #$6954,
      #$697E, #$696E, #$6939, #$6974, #$693D, #$6959, #$6930, #$6961,
      #$695E, #$695D, #$6981, #$696A, #$69B2, #$69AE, #$69D0, #$69BF,
      #$69C1, #$69D3, #$69BE, #$69CE, #$5BE8, #$69CA, #$69DD, #$69BB,
      #$69C3, #$69A7, #$6A2E, #$6991, #$69A0, #$699C, #$6995, #$69B4,
      #$69DE, #$69E8, #$6A02, #$6A1B, #$69FF, #$6B0A, #$69F9, #$69F2,
      #$69E7, #$6A05, #$69B1, #$6A1E, #$69ED, #$6A14, #$69EB, #$6A0A,
      #$6A12, #$6AC1, #$6A23, #$6A13, #$6A44, #$6A0C, #$6A72, #$6A36,
      #$6A78, #$6A47, #$6A62, #$6A59, #$6A66, #$6A48, #$6A38, #$6A22,
      #$6A90, #$6A8D, #$6AA0, #$6A84, #$6AA2, #$6AA3,
      #$6A97, #$8617, #$6ABB, #$6AC3, #$6AC2, #$6AB8, #$6AB3, #$6AAC,
      #$6ADE, #$6AD1, #$6ADF, #$6AAA, #$6ADA, #$6AEA, #$6AFB, #$6B05,
      #$8616, #$6AFA, #$6B12, #$6B16, #$9B31, #$6B1F, #$6B38, #$6B37,
      #$76DC, #$6B39, #$98EE, #$6B47, #$6B43, #$6B49, #$6B50, #$6B59,
      #$6B54, #$6B5B, #$6B5F, #$6B61, #$6B78, #$6B79, #$6B7F, #$6B80,
      #$6B84, #$6B83, #$6B8D, #$6B98, #$6B95, #$6B9E, #$6BA4, #$6BAA,
      #$6BAB, #$6BAF, #$6BB2, #$6BB1, #$6BB3, #$6BB7, #$6BBC, #$6BC6,
      #$6BCB, #$6BD3, #$6BDF, #$6BEC, #$6BEB, #$6BF3, #$6BEF, #$9EBE,
      #$6C08, #$6C13, #$6C14, #$6C1B, #$6C24, #$6C23, #$6C5E, #$6C55,
      #$6C62, #$6C6A, #$6C82, #$6C8D, #$6C9A, #$6C81, #$6C9B, #$6C7E,
      #$6C68, #$6C73, #$6C92, #$6C90, #$6CC4, #$6CF1, #$6CD3, #$6CBD,
      #$6CD7, #$6CC5, #$6CDD, #$6CAE, #$6CB1, #$6CBE,
      #$6CBA, #$6CDB, #$6CEF, #$6CD9, #$6CEA, #$6D1F, #$884D, #$6D36,
      #$6D2B, #$6D3D, #$6D38, #$6D19, #$6D35, #$6D33, #$6D12, #$6D0C,
      #$6D63, #$6D93, #$6D64, #$6D5A, #$6D79, #$6D59, #$6D8E, #$6D95,
      #$6FE4, #$6D85, #$6DF9, #$6E15, #$6E0A, #$6DB5, #$6DC7, #$6DE6,
      #$6DB8, #$6DC6, #$6DEC, #$6DDE, #$6DCC, #$6DE8, #$6DD2, #$6DC5,
      #$6DFA, #$6DD9, #$6DE4, #$6DD5, #$6DEA, #$6DEE, #$6E2D, #$6E6E,
      #$6E2E, #$6E19, #$6E72, #$6E5F, #$6E3E, #$6E23, #$6E6B, #$6E2B,
      #$6E76, #$6E4D, #$6E1F, #$6E43, #$6E3A, #$6E4E, #$6E24, #$6EFF,
      #$6E1D, #$6E38, #$6E82, #$6EAA, #$6E98, #$6EC9, #$6EB7, #$6ED3,
      #$6EBD, #$6EAF, #$6EC4, #$6EB2, #$6ED4, #$6ED5, #$6E8F, #$6EA5,
      #$6EC2, #$6E9F, #$6F41, #$6F11, #$704C, #$6EEC, #$6EF8, #$6EFE,
      #$6F3F, #$6EF2, #$6F31, #$6EEF, #$6F32, #$6ECC,
      #$6F3E, #$6F13, #$6EF7, #$6F86, #$6F7A, #$6F78, #$6F81, #$6F80,
      #$6F6F, #$6F5B, #$6FF3, #$6F6D, #$6F82, #$6F7C, #$6F58, #$6F8E,
      #$6F91, #$6FC2, #$6F66, #$6FB3, #$6FA3, #$6FA1, #$6FA4, #$6FB9,
      #$6FC6, #$6FAA, #$6FDF, #$6FD5, #$6FEC, #$6FD4, #$6FD8, #$6FF1,
      #$6FEE, #$6FDB, #$7009, #$700B, #$6FFA, #$7011, #$7001, #$700F,
      #$6FFE, #$701B, #$701A, #$6F74, #$701D, #$7018, #$701F, #$7030,
      #$703E, #$7032, #$7051, #$7063, #$7099, #$7092, #$70AF, #$70F1,
      #$70AC, #$70B8, #$70B3, #$70AE, #$70DF, #$70CB, #$70DD, #$70D9,
      #$7109, #$70FD, #$711C, #$7119, #$7165, #$7155, #$7188, #$7166,
      #$7162, #$714C, #$7156, #$716C, #$718F, #$71FB, #$7184, #$7195,
      #$71A8, #$71AC, #$71D7, #$71B9, #$71BE, #$71D2, #$71C9, #$71D4,
      #$71CE, #$71E0, #$71EC, #$71E7, #$71F5, #$71FC,
      #$71F9, #$71FF, #$720D, #$7210, #$721B, #$7228, #$722D, #$722C,
      #$7230, #$7232, #$723B, #$723C, #$723F, #$7240, #$7246, #$724B,
      #$7258, #$7274, #$727E, #$7282, #$7281, #$7287, #$7292, #$7296,
      #$72A2, #$72A7, #$72B9, #$72B2, #$72C3, #$72C6, #$72C4, #$72CE,
      #$72D2, #$72E2, #$72E0, #$72E1, #$72F9, #$72F7, #$500F, #$7317,
      #$730A, #$731C, #$7316, #$731D, #$7334, #$732F, #$7329, #$7325,
      #$733E, #$734E, #$734F, #$9ED8, #$7357, #$736A, #$7368, #$7370,
      #$7378, #$7375, #$737B, #$737A, #$73C8, #$73B3, #$73CE, #$73BB,
      #$73C0, #$73E5, #$73EE, #$73DE, #$74A2, #$7405, #$746F, #$7425,
      #$73F8, #$7432, #$743A, #$7455, #$743F, #$745F, #$7459, #$7441,
      #$745C, #$7469, #$7470, #$7463, #$746A, #$7476, #$747E, #$748B,
      #$749E, #$74A7, #$74CA, #$74CF, #$74D4, #$73F1,
      #$74E0, #$74E3, #$74E7, #$74E9, #$74EE, #$74F2, #$74F0, #$74F1,
      #$74F8, #$74F7, #$7504, #$7503, #$7505, #$750C, #$750E, #$750D,
      #$7515, #$7513, #$751E, #$7526, #$752C, #$753C, #$7544, #$754D,
      #$754A, #$7549, #$755B, #$7546, #$755A, #$7569, #$7564, #$7567,
      #$756B, #$756D, #$7578, #$7576, #$7586, #$7587, #$7574, #$758A,
      #$7589, #$7582, #$7594, #$759A, #$759D, #$75A5, #$75A3, #$75C2,
      #$75B3, #$75C3, #$75B5, #$75BD, #$75B8, #$75BC, #$75B1, #$75CD,
      #$75CA, #$75D2, #$75D9, #$75E3, #$75DE, #$75FE, #$75FF, #$75FC,
      #$7601, #$75F0, #$75FA, #$75F2, #$75F3, #$760B, #$760D, #$7609,
      #$761F, #$7627, #$7620, #$7621, #$7622, #$7624, #$7634, #$7630,
      #$763B, #$7647, #$7648, #$7646, #$765C, #$7658, #$7661, #$7662,
      #$7668, #$7669, #$766A, #$7667, #$766C, #$7670,
      #$7672, #$7676, #$7678, #$767C, #$7680, #$7683, #$7688, #$768B,
      #$768E, #$7696, #$7693, #$7699, #$769A, #$76B0, #$76B4, #$76B8,
      #$76B9, #$76BA, #$76C2, #$76CD, #$76D6, #$76D2, #$76DE, #$76E1,
      #$76E5, #$76E7, #$76EA, #$862F, #$76FB, #$7708, #$7707, #$7704,
      #$7729, #$7724, #$771E, #$7725, #$7726, #$771B, #$7737, #$7738,
      #$7747, #$775A, #$7768, #$776B, #$775B, #$7765, #$777F, #$777E,
      #$7779, #$778E, #$778B, #$7791, #$77A0, #$779E, #$77B0, #$77B6,
      #$77B9, #$77BF, #$77BC, #$77BD, #$77BB, #$77C7, #$77CD, #$77D7,
      #$77DA, #$77DC, #$77E3, #$77EE, #$77FC, #$780C, #$7812, #$7926,
      #$7820, #$792A, #$7845, #$788E, #$7874, #$7886, #$787C, #$789A,
      #$788C, #$78A3, #$78B5, #$78AA, #$78AF, #$78D1, #$78C6, #$78CB,
      #$78D4, #$78BE, #$78BC, #$78C5, #$78CA, #$78EC,
      #$78E7, #$78DA, #$78FD, #$78F4, #$7907, #$7912, #$7911, #$7919,
      #$792C, #$792B, #$7940, #$7960, #$7957, #$795F, #$795A, #$7955,
      #$7953, #$797A, #$797F, #$798A, #$799D, #$79A7, #$9F4B, #$79AA,
      #$79AE, #$79B3, #$79B9, #$79BA, #$79C9, #$79D5, #$79E7, #$79EC,
      #$79E1, #$79E3, #$7A08, #$7A0D, #$7A18, #$7A19, #$7A20, #$7A1F,
      #$7980, #$7A31, #$7A3B, #$7A3E, #$7A37, #$7A43, #$7A57, #$7A49,
      #$7A61, #$7A62, #$7A69, #$9F9D, #$7A70, #$7A79, #$7A7D, #$7A88,
      #$7A97, #$7A95, #$7A98, #$7A96, #$7AA9, #$7AC8, #$7AB0, #$7AB6,
      #$7AC5, #$7AC4, #$7ABF, #$9083, #$7AC7, #$7ACA, #$7ACD, #$7ACF,
      #$7AD5, #$7AD3, #$7AD9, #$7ADA, #$7ADD, #$7AE1, #$7AE2, #$7AE6,
      #$7AED, #$7AF0, #$7B02, #$7B0F, #$7B0A, #$7B06, #$7B33, #$7B18,
      #$7B19, #$7B1E, #$7B35, #$7B28, #$7B36, #$7B50,
      #$7B7A, #$7B04, #$7B4D, #$7B0B, #$7B4C, #$7B45, #$7B75, #$7B65,
      #$7B74, #$7B67, #$7B70, #$7B71, #$7B6C, #$7B6E, #$7B9D, #$7B98,
      #$7B9F, #$7B8D, #$7B9C, #$7B9A, #$7B8B, #$7B92, #$7B8F, #$7B5D,
      #$7B99, #$7BCB, #$7BC1, #$7BCC, #$7BCF, #$7BB4, #$7BC6, #$7BDD,
      #$7BE9, #$7C11, #$7C14, #$7BE6, #$7BE5, #$7C60, #$7C00, #$7C07,
      #$7C13, #$7BF3, #$7BF7, #$7C17, #$7C0D, #$7BF6, #$7C23, #$7C27,
      #$7C2A, #$7C1F, #$7C37, #$7C2B, #$7C3D, #$7C4C, #$7C43, #$7C54,
      #$7C4F, #$7C40, #$7C50, #$7C58, #$7C5F, #$7C64, #$7C56, #$7C65,
      #$7C6C, #$7C75, #$7C83, #$7C90, #$7CA4, #$7CAD, #$7CA2, #$7CAB,
      #$7CA1, #$7CA8, #$7CB3, #$7CB2, #$7CB1, #$7CAE, #$7CB9, #$7CBD,
      #$7CC0, #$7CC5, #$7CC2, #$7CD8, #$7CD2, #$7CDC, #$7CE2, #$9B3B,
      #$7CEF, #$7CF2, #$7CF4, #$7CF6, #$7CFA, #$7D06,
      #$7D02, #$7D1C, #$7D15, #$7D0A, #$7D45, #$7D4B, #$7D2E, #$7D32,
      #$7D3F, #$7D35, #$7D46, #$7D73, #$7D56, #$7D4E, #$7D72, #$7D68,
      #$7D6E, #$7D4F, #$7D63, #$7D93, #$7D89, #$7D5B, #$7D8F, #$7D7D,
      #$7D9B, #$7DBA, #$7DAE, #$7DA3, #$7DB5, #$7DC7, #$7DBD, #$7DAB,
      #$7E3D, #$7DA2, #$7DAF, #$7DDC, #$7DB8, #$7D9F, #$7DB0, #$7DD8,
      #$7DDD, #$7DE4, #$7DDE, #$7DFB, #$7DF2, #$7DE1, #$7E05, #$7E0A,
      #$7E23, #$7E21, #$7E12, #$7E31, #$7E1F, #$7E09, #$7E0B, #$7E22,
      #$7E46, #$7E66, #$7E3B, #$7E35, #$7E39, #$7E43, #$7E37, #$7E32,
      #$7E3A, #$7E67, #$7E5D, #$7E56, #$7E5E, #$7E59, #$7E5A, #$7E79,
      #$7E6A, #$7E69, #$7E7C, #$7E7B, #$7E83, #$7DD5, #$7E7D, #$8FAE,
      #$7E7F, #$7E88, #$7E89, #$7E8C, #$7E92, #$7E90, #$7E93, #$7E94,
      #$7E96, #$7E8E, #$7E9B, #$7E9C, #$7F38, #$7F3A,
      #$7F45, #$7F4C, #$7F4D, #$7F4E, #$7F50, #$7F51, #$7F55, #$7F54,
      #$7F58, #$7F5F, #$7F60, #$7F68, #$7F69, #$7F67, #$7F78, #$7F82,
      #$7F86, #$7F83, #$7F88, #$7F87, #$7F8C, #$7F94, #$7F9E, #$7F9D,
      #$7F9A, #$7FA3, #$7FAF, #$7FB2, #$7FB9, #$7FAE, #$7FB6, #$7FB8,
      #$8B71, #$7FC5, #$7FC6, #$7FCA, #$7FD5, #$7FD4, #$7FE1, #$7FE6,
      #$7FE9, #$7FF3, #$7FF9, #$98DC, #$8006, #$8004, #$800B, #$8012,
      #$8018, #$8019, #$801C, #$8021, #$8028, #$803F, #$803B, #$804A,
      #$8046, #$8052, #$8058, #$805A, #$805F, #$8062, #$8068, #$8073,
      #$8072, #$8070, #$8076, #$8079, #$807D, #$807F, #$8084, #$8086,
      #$8085, #$809B, #$8093, #$809A, #$80AD, #$5190, #$80AC, #$80DB,
      #$80E5, #$80D9, #$80DD, #$80C4, #$80DA, #$80D6, #$8109, #$80EF,
      #$80F1, #$811B, #$8129, #$8123, #$812F, #$814B,
      #$968B, #$8146, #$813E, #$8153, #$8151, #$80FC, #$8171, #$816E,
      #$8165, #$8166, #$8174, #$8183, #$8188, #$818A, #$8180, #$8182,
      #$81A0, #$8195, #$81A4, #$81A3, #$815F, #$8193, #$81A9, #$81B0,
      #$81B5, #$81BE, #$81B8, #$81BD, #$81C0, #$81C2, #$81BA, #$81C9,
      #$81CD, #$81D1, #$81D9, #$81D8, #$81C8, #$81DA, #$81DF, #$81E0,
      #$81E7, #$81FA, #$81FB, #$81FE, #$8201, #$8202, #$8205, #$8207,
      #$820A, #$820D, #$8210, #$8216, #$8229, #$822B, #$8238, #$8233,
      #$8240, #$8259, #$8258, #$825D, #$825A, #$825F, #$8264, #$8262,
      #$8268, #$826A, #$826B, #$822E, #$8271, #$8277, #$8278, #$827E,
      #$828D, #$8292, #$82AB, #$829F, #$82BB, #$82AC, #$82E1, #$82E3,
      #$82DF, #$82D2, #$82F4, #$82F3, #$82FA, #$8393, #$8303, #$82FB,
      #$82F9, #$82DE, #$8306, #$82DC, #$8309, #$82D9,
      #$8335, #$8334, #$8316, #$8332, #$8331, #$8340, #$8339, #$8350,
      #$8345, #$832F, #$832B, #$8317, #$8318, #$8385, #$839A, #$83AA,
      #$839F, #$83A2, #$8396, #$8323, #$838E, #$8387, #$838A, #$837C,
      #$83B5, #$8373, #$8375, #$83A0, #$8389, #$83A8, #$83F4, #$8413,
      #$83EB, #$83CE, #$83FD, #$8403, #$83D8, #$840B, #$83C1, #$83F7,
      #$8407, #$83E0, #$83F2, #$840D, #$8422, #$8420, #$83BD, #$8438,
      #$8506, #$83FB, #$846D, #$842A, #$843C, #$855A, #$8484, #$8477,
      #$846B, #$84AD, #$846E, #$8482, #$8469, #$8446, #$842C, #$846F,
      #$8479, #$8435, #$84CA, #$8462, #$84B9, #$84BF, #$849F, #$84D9,
      #$84CD, #$84BB, #$84DA, #$84D0, #$84C1, #$84C6, #$84D6, #$84A1,
      #$8521, #$84FF, #$84F4, #$8517, #$8518, #$852C, #$851F, #$8515,
      #$8514, #$84FC, #$8540, #$8563, #$8558, #$8548,
      #$8541, #$8602, #$854B, #$8555, #$8580, #$85A4, #$8588, #$8591,
      #$858A, #$85A8, #$856D, #$8594, #$859B, #$85EA, #$8587, #$859C,
      #$8577, #$857E, #$8590, #$85C9, #$85BA, #$85CF, #$85B9, #$85D0,
      #$85D5, #$85DD, #$85E5, #$85DC, #$85F9, #$860A, #$8613, #$860B,
      #$85FE, #$85FA, #$8606, #$8622, #$861A, #$8630, #$863F, #$864D,
      #$4E55, #$8654, #$865F, #$8667, #$8671, #$8693, #$86A3, #$86A9,
      #$86AA, #$868B, #$868C, #$86B6, #$86AF, #$86C4, #$86C6, #$86B0,
      #$86C9, #$8823, #$86AB, #$86D4, #$86DE, #$86E9, #$86EC, #$86DF,
      #$86DB, #$86EF, #$8712, #$8706, #$8708, #$8700, #$8703, #$86FB,
      #$8711, #$8709, #$870D, #$86F9, #$870A, #$8734, #$873F, #$8737,
      #$873B, #$8725, #$8729, #$871A, #$8760, #$875F, #$8778, #$874C,
      #$874E, #$8774, #$8757, #$8768, #$876E, #$8759,
      #$8753, #$8763, #$876A, #$8805, #$87A2, #$879F, #$8782, #$87AF,
      #$87CB, #$87BD, #$87C0, #$87D0, #$96D6, #$87AB, #$87C4, #$87B3,
      #$87C7, #$87C6, #$87BB, #$87EF, #$87F2, #$87E0, #$880F, #$880D,
      #$87FE, #$87F6, #$87F7, #$880E, #$87D2, #$8811, #$8816, #$8815,
      #$8822, #$8821, #$8831, #$8836, #$8839, #$8827, #$883B, #$8844,
      #$8842, #$8852, #$8859, #$885E, #$8862, #$886B, #$8881, #$887E,
      #$889E, #$8875, #$887D, #$88B5, #$8872, #$8882, #$8897, #$8892,
      #$88AE, #$8899, #$88A2, #$888D, #$88A4, #$88B0, #$88BF, #$88B1,
      #$88C3, #$88C4, #$88D4, #$88D8, #$88D9, #$88DD, #$88F9, #$8902,
      #$88FC, #$88F4, #$88E8, #$88F2, #$8904, #$890C, #$890A, #$8913,
      #$8943, #$891E, #$8925, #$892A, #$892B, #$8941, #$8944, #$893B,
      #$8936, #$8938, #$894C, #$891D, #$8960, #$895E,
      #$8966, #$8964, #$896D, #$896A, #$896F, #$8974, #$8977, #$897E,
      #$8983, #$8988, #$898A, #$8993, #$8998, #$89A1, #$89A9, #$89A6,
      #$89AC, #$89AF, #$89B2, #$89BA, #$89BD, #$89BF, #$89C0, #$89DA,
      #$89DC, #$89DD, #$89E7, #$89F4, #$89F8, #$8A03, #$8A16, #$8A10,
      #$8A0C, #$8A1B, #$8A1D, #$8A25, #$8A36, #$8A41, #$8A5B, #$8A52,
      #$8A46, #$8A48, #$8A7C, #$8A6D, #$8A6C, #$8A62, #$8A85, #$8A82,
      #$8A84, #$8AA8, #$8AA1, #$8A91, #$8AA5, #$8AA6, #$8A9A, #$8AA3,
      #$8AC4, #$8ACD, #$8AC2, #$8ADA, #$8AEB, #$8AF3, #$8AE7, #$8AE4,
      #$8AF1, #$8B14, #$8AE0, #$8AE2, #$8AF7, #$8ADE, #$8ADB, #$8B0C,
      #$8B07, #$8B1A, #$8AE1, #$8B16, #$8B10, #$8B17, #$8B20, #$8B33,
      #$97AB, #$8B26, #$8B2B, #$8B3E, #$8B28, #$8B41, #$8B4C, #$8B4F,
      #$8B4E, #$8B49, #$8B56, #$8B5B, #$8B5A, #$8B6B,
      #$8B5F, #$8B6C, #$8B6F, #$8B74, #$8B7D, #$8B80, #$8B8C, #$8B8E,
      #$8B92, #$8B93, #$8B96, #$8B99, #$8B9A, #$8C3A, #$8C41, #$8C3F,
      #$8C48, #$8C4C, #$8C4E, #$8C50, #$8C55, #$8C62, #$8C6C, #$8C78,
      #$8C7A, #$8C82, #$8C89, #$8C85, #$8C8A, #$8C8D, #$8C8E, #$8C94,
      #$8C7C, #$8C98, #$621D, #$8CAD, #$8CAA, #$8CBD, #$8CB2, #$8CB3,
      #$8CAE, #$8CB6, #$8CC8, #$8CC1, #$8CE4, #$8CE3, #$8CDA, #$8CFD,
      #$8CFA, #$8CFB, #$8D04, #$8D05, #$8D0A, #$8D07, #$8D0F, #$8D0D,
      #$8D10, #$9F4E, #$8D13, #$8CCD, #$8D14, #$8D16, #$8D67, #$8D6D,
      #$8D71, #$8D73, #$8D81, #$8D99, #$8DC2, #$8DBE, #$8DBA, #$8DCF,
      #$8DDA, #$8DD6, #$8DCC, #$8DDB, #$8DCB, #$8DEA, #$8DEB, #$8DDF,
      #$8DE3, #$8DFC, #$8E08, #$8E09, #$8DFF, #$8E1D, #$8E1E, #$8E10,
      #$8E1F, #$8E42, #$8E35, #$8E30, #$8E34, #$8E4A,
      #$8E47, #$8E49, #$8E4C, #$8E50, #$8E48, #$8E59, #$8E64, #$8E60,
      #$8E2A, #$8E63, #$8E55, #$8E76, #$8E72, #$8E7C, #$8E81, #$8E87,
      #$8E85, #$8E84, #$8E8B, #$8E8A, #$8E93, #$8E91, #$8E94, #$8E99,
      #$8EAA, #$8EA1, #$8EAC, #$8EB0, #$8EC6, #$8EB1, #$8EBE, #$8EC5,
      #$8EC8, #$8ECB, #$8EDB, #$8EE3, #$8EFC, #$8EFB, #$8EEB, #$8EFE,
      #$8F0A, #$8F05, #$8F15, #$8F12, #$8F19, #$8F13, #$8F1C, #$8F1F,
      #$8F1B, #$8F0C, #$8F26, #$8F33, #$8F3B, #$8F39, #$8F45, #$8F42,
      #$8F3E, #$8F4C, #$8F49, #$8F46, #$8F4E, #$8F57, #$8F5C, #$8F62,
      #$8F63, #$8F64, #$8F9C, #$8F9F, #$8FA3, #$8FAD, #$8FAF, #$8FB7,
      #$8FDA, #$8FE5, #$8FE2, #$8FEA, #$8FEF, #$9087, #$8FF4, #$9005,
      #$8FF9, #$8FFA, #$9011, #$9015, #$9021, #$900D, #$901E, #$9016,
      #$900B, #$9027, #$9036, #$9035, #$9039, #$8FF8,
      #$904F, #$9050, #$9051, #$9052, #$900E, #$9049, #$903E, #$9056,
      #$9058, #$905E, #$9068, #$906F, #$9076, #$96A8, #$9072, #$9082,
      #$907D, #$9081, #$9080, #$908A, #$9089, #$908F, #$90A8, #$90AF,
      #$90B1, #$90B5, #$90E2, #$90E4, #$6248, #$90DB, #$9102, #$9112,
      #$9119, #$9132, #$9130, #$914A, #$9156, #$9158, #$9163, #$9165,
      #$9169, #$9173, #$9172, #$918B, #$9189, #$9182, #$91A2, #$91AB,
      #$91AF, #$91AA, #$91B5, #$91B4, #$91BA, #$91C0, #$91C1, #$91C9,
      #$91CB, #$91D0, #$91D6, #$91DF, #$91E1, #$91DB, #$91FC, #$91F5,
      #$91F6, #$921E, #$91FF, #$9214, #$922C, #$9215, #$9211, #$925E,
      #$9257, #$9245, #$9249, #$9264, #$9248, #$9295, #$923F, #$924B,
      #$9250, #$929C, #$9296, #$9293, #$929B, #$925A, #$92CF, #$92B9,
      #$92B7, #$92E9, #$930F, #$92FA, #$9344, #$932E,
      #$9319, #$9322, #$931A, #$9323, #$933A, #$9335, #$933B, #$935C,
      #$9360, #$937C, #$936E, #$9356, #$93B0, #$93AC, #$93AD, #$9394,
      #$93B9, #$93D6, #$93D7, #$93E8, #$93E5, #$93D8, #$93C3, #$93DD,
      #$93D0, #$93C8, #$93E4, #$941A, #$9414, #$9413, #$9403, #$9407,
      #$9410, #$9436, #$942B, #$9435, #$9421, #$943A, #$9441, #$9452,
      #$9444, #$945B, #$9460, #$9462, #$945E, #$946A, #$9229, #$9470,
      #$9475, #$9477, #$947D, #$945A, #$947C, #$947E, #$9481, #$947F,
      #$9582, #$9587, #$958A, #$9594, #$9596, #$9598, #$9599, #$95A0,
      #$95A8, #$95A7, #$95AD, #$95BC, #$95BB, #$95B9, #$95BE, #$95CA,
      #$6FF6, #$95C3, #$95CD, #$95CC, #$95D5, #$95D4, #$95D6, #$95DC,
      #$95E1, #$95E5, #$95E2, #$9621, #$9628, #$962E, #$962F, #$9642,
      #$964C, #$964F, #$964B, #$9677, #$965C, #$965E,
      #$965D, #$965F, #$9666, #$9672, #$966C, #$968D, #$9698, #$9695,
      #$9697, #$96AA, #$96A7, #$96B1, #$96B2, #$96B0, #$96B4, #$96B6,
      #$96B8, #$96B9, #$96CE, #$96CB, #$96C9, #$96CD, #$894D, #$96DC,
      #$970D, #$96D5, #$96F9, #$9704, #$9706, #$9708, #$9713, #$970E,
      #$9711, #$970F, #$9716, #$9719, #$9724, #$972A, #$9730, #$9739,
      #$973D, #$973E, #$9744, #$9746, #$9748, #$9742, #$9749, #$975C,
      #$9760, #$9764, #$9766, #$9768, #$52D2, #$976B, #$9771, #$9779,
      #$9785, #$977C, #$9781, #$977A, #$9786, #$978B, #$978F, #$9790,
      #$979C, #$97A8, #$97A6, #$97A3, #$97B3, #$97B4, #$97C3, #$97C6,
      #$97C8, #$97CB, #$97DC, #$97ED, #$9F4F, #$97F2, #$7ADF, #$97F6,
      #$97F5, #$980F, #$980C, #$9838, #$9824, #$9821, #$9837, #$983D,
      #$9846, #$984F, #$984B, #$986B, #$986F, #$9870,
      #$9871, #$9874, #$9873, #$98AA, #$98AF, #$98B1, #$98B6, #$98C4,
      #$98C3, #$98C6, #$98E9, #$98EB, #$9903, #$9909, #$9912, #$9914,
      #$9918, #$9921, #$991D, #$991E, #$9924, #$9920, #$992C, #$992E,
      #$993D, #$993E, #$9942, #$9949, #$9945, #$9950, #$994B, #$9951,
      #$9952, #$994C, #$9955, #$9997, #$9998, #$99A5, #$99AD, #$99AE,
      #$99BC, #$99DF, #$99DB, #$99DD, #$99D8, #$99D1, #$99ED, #$99EE,
      #$99F1, #$99F2, #$99FB, #$99F8, #$9A01, #$9A0F, #$9A05, #$99E2,
      #$9A19, #$9A2B, #$9A37, #$9A45, #$9A42, #$9A40, #$9A43, #$9A3E,
      #$9A55, #$9A4D, #$9A5B, #$9A57, #$9A5F, #$9A62, #$9A65, #$9A64,
      #$9A69, #$9A6B, #$9A6A, #$9AAD, #$9AB0, #$9ABC, #$9AC0, #$9ACF,
      #$9AD1, #$9AD3, #$9AD4, #$9ADE, #$9ADF, #$9AE2, #$9AE3, #$9AE6,
      #$9AEF, #$9AEB, #$9AEE, #$9AF4, #$9AF1, #$9AF7,
      #$9AFB, #$9B06, #$9B18, #$9B1A, #$9B1F, #$9B22, #$9B23, #$9B25,
      #$9B27, #$9B28, #$9B29, #$9B2A, #$9B2E, #$9B2F, #$9B32, #$9B44,
      #$9B43, #$9B4F, #$9B4D, #$9B4E, #$9B51, #$9B58, #$9B74, #$9B93,
      #$9B83, #$9B91, #$9B96, #$9B97, #$9B9F, #$9BA0, #$9BA8, #$9BB4,
      #$9BC0, #$9BCA, #$9BB9, #$9BC6, #$9BCF, #$9BD1, #$9BD2, #$9BE3,
      #$9BE2, #$9BE4, #$9BD4, #$9BE1, #$9C3A, #$9BF2, #$9BF1, #$9BF0,
      #$9C15, #$9C14, #$9C09, #$9C13, #$9C0C, #$9C06, #$9C08, #$9C12,
      #$9C0A, #$9C04, #$9C2E, #$9C1B, #$9C25, #$9C24, #$9C21, #$9C30,
      #$9C47, #$9C32, #$9C46, #$9C3E, #$9C5A, #$9C60, #$9C67, #$9C76,
      #$9C78, #$9CE7, #$9CEC, #$9CF0, #$9D09, #$9D08, #$9CEB, #$9D03,
      #$9D06, #$9D2A, #$9D26, #$9DAF, #$9D23, #$9D1F, #$9D44, #$9D15,
      #$9D12, #$9D41, #$9D3F, #$9D3E, #$9D46, #$9D48,
      #$9D5D, #$9D5E, #$9D64, #$9D51, #$9D50, #$9D59, #$9D72, #$9D89,
      #$9D87, #$9DAB, #$9D6F, #$9D7A, #$9D9A, #$9DA4, #$9DA9, #$9DB2,
      #$9DC4, #$9DC1, #$9DBB, #$9DB8, #$9DBA, #$9DC6, #$9DCF, #$9DC2,
      #$9DD9, #$9DD3, #$9DF8, #$9DE6, #$9DED, #$9DEF, #$9DFD, #$9E1A,
      #$9E1B, #$9E1E, #$9E75, #$9E79, #$9E7D, #$9E81, #$9E88, #$9E8B,
      #$9E8C, #$9E92, #$9E95, #$9E91, #$9E9D, #$9EA5, #$9EA9, #$9EB8,
      #$9EAA, #$9EAD, #$9761, #$9ECC, #$9ECE, #$9ECF, #$9ED0, #$9ED4,
      #$9EDC, #$9EDE, #$9EDD, #$9EE0, #$9EE5, #$9EE8, #$9EEF, #$9EF4,
      #$9EF6, #$9EF7, #$9EF9, #$9EFB, #$9EFC, #$9EFD, #$9F07, #$9F08,
      #$76B7, #$9F15, #$9F21, #$9F2C, #$9F3E, #$9F4A, #$9F52, #$9F54,
      #$9F63, #$9F5F, #$9F60, #$9F61, #$9F66, #$9F67, #$9F6C, #$9F6A,
      #$9F77, #$9F72, #$9F76, #$9F95, #$9F9C, #$9FA0,
      #$582F, #$69C7, #$9059, #$7464, #$51DC, #$7199);
  GBKE_1Map: array[0..6079] of TBuffChar = (
      #$4E02, #$4E04, #$4E05, #$4E06, #$4E0F, #$4E12, #$4E17, #$4E1F,
      #$4E20, #$4E21, #$4E23, #$4E26, #$4E29, #$4E2E, #$4E2F, #$4E31,
      #$4E33, #$4E35, #$4E37, #$4E3C, #$4E40, #$4E41, #$4E42, #$4E44,
      #$4E46, #$4E4A, #$4E51, #$4E55, #$4E57, #$4E5A, #$4E5B, #$4E62,
      #$4E63, #$4E64, #$4E65, #$4E67, #$4E68, #$4E6A, #$4E6B, #$4E6C,
      #$4E6D, #$4E6E, #$4E6F, #$4E72, #$4E74, #$4E75, #$4E76, #$4E77,
      #$4E78, #$4E79, #$4E7A, #$4E7B, #$4E7C, #$4E7D, #$4E7F, #$4E80,
      #$4E81, #$4E82, #$4E83, #$4E84, #$4E85, #$4E87, #$4E8A, #$4E90,
      #$4E96, #$4E97, #$4E99, #$4E9C, #$4E9D, #$4E9E, #$4EA3, #$4EAA,
      #$4EAF, #$4EB0, #$4EB1, #$4EB4, #$4EB6, #$4EB7, #$4EB8, #$4EB9,
      #$4EBC, #$4EBD, #$4EBE, #$4EC8, #$4ECC, #$4ECF, #$4ED0, #$4ED2,
      #$4EDA, #$4EDB, #$4EDC, #$4EE0, #$4EE2, #$4EE6, #$4EE7, #$4EE9,
      #$4EED, #$4EEE, #$4EEF, #$4EF1, #$4EF4, #$4EF8, #$4EF9, #$4EFA,
      #$4EFC, #$4EFE, #$4F00, #$4F02, #$4F03, #$4F04, #$4F05, #$4F06,
      #$4F07, #$4F08, #$4F0B, #$4F0C, #$4F12, #$4F13, #$4F14, #$4F15,
      #$4F16, #$4F1C, #$4F1D, #$4F21, #$4F23, #$4F28, #$4F29, #$4F2C,
      #$4F2D, #$4F2E, #$4F31, #$4F33, #$4F35, #$4F37, #$4F39, #$4F3B,
      #$4F3E, #$4F3F, #$4F40, #$4F41, #$4F42, #$4F44, #$4F45, #$4F47,
      #$4F48, #$4F49, #$4F4A, #$4F4B, #$4F4C, #$4F52, #$4F54, #$4F56,
      #$4F61, #$4F62, #$4F66, #$4F68, #$4F6A, #$4F6B, #$4F6D, #$4F6E,
      #$4F71, #$4F72, #$4F75, #$4F77, #$4F78, #$4F79, #$4F7A, #$4F7D,
      #$4F80, #$4F81, #$4F82, #$4F85, #$4F86, #$4F87, #$4F8A, #$4F8C,
      #$4F8E, #$4F90, #$4F92, #$4F93, #$4F95, #$4F96, #$4F98, #$4F99,
      #$4F9A, #$4F9C, #$4F9E, #$4F9F, #$4FA1, #$4FA2,
      #$4FA4, #$4FAB, #$4FAD, #$4FB0, #$4FB1, #$4FB2, #$4FB3, #$4FB4,
      #$4FB6, #$4FB7, #$4FB8, #$4FB9, #$4FBA, #$4FBB, #$4FBC, #$4FBD,
      #$4FBE, #$4FC0, #$4FC1, #$4FC2, #$4FC6, #$4FC7, #$4FC8, #$4FC9,
      #$4FCB, #$4FCC, #$4FCD, #$4FD2, #$4FD3, #$4FD4, #$4FD5, #$4FD6,
      #$4FD9, #$4FDB, #$4FE0, #$4FE2, #$4FE4, #$4FE5, #$4FE7, #$4FEB,
      #$4FEC, #$4FF0, #$4FF2, #$4FF4, #$4FF5, #$4FF6, #$4FF7, #$4FF9,
      #$4FFB, #$4FFC, #$4FFD, #$4FFF, #$5000, #$5001, #$5002, #$5003,
      #$5004, #$5005, #$5006, #$5007, #$5008, #$5009, #$500A, #$500B,
      #$500E, #$5010, #$5011, #$5013, #$5015, #$5016, #$5017, #$501B,
      #$501D, #$501E, #$5020, #$5022, #$5023, #$5024, #$5027, #$502B,
      #$502F, #$5030, #$5031, #$5032, #$5033, #$5034, #$5035, #$5036,
      #$5037, #$5038, #$5039, #$503B, #$503D, #$503F, #$5040, #$5041,
      #$5042, #$5044, #$5045, #$5046, #$5049, #$504A, #$504B, #$504D,
      #$5050, #$5051, #$5052, #$5053, #$5054, #$5056, #$5057, #$5058,
      #$5059, #$505B, #$505D, #$505E, #$505F, #$5060, #$5061, #$5062,
      #$5063, #$5064, #$5066, #$5067, #$5068, #$5069, #$506A, #$506B,
      #$506D, #$506E, #$506F, #$5070, #$5071, #$5072, #$5073, #$5074,
      #$5075, #$5078, #$5079, #$507A, #$507C, #$507D, #$5081, #$5082,
      #$5083, #$5084, #$5086, #$5087, #$5089, #$508A, #$508B, #$508C,
      #$508E, #$508F, #$5090, #$5091, #$5092, #$5093, #$5094, #$5095,
      #$5096, #$5097, #$5098, #$5099, #$509A, #$509B, #$509C, #$509D,
      #$509E, #$509F, #$50A0, #$50A1, #$50A2, #$50A4, #$50A6, #$50AA,
      #$50AB, #$50AD, #$50AE, #$50AF, #$50B0, #$50B1, #$50B3, #$50B4,
      #$50B5, #$50B6, #$50B7, #$50B8, #$50B9, #$50BC,
      #$50BD, #$50BE, #$50BF, #$50C0, #$50C1, #$50C2, #$50C3, #$50C4,
      #$50C5, #$50C6, #$50C7, #$50C8, #$50C9, #$50CA, #$50CB, #$50CC,
      #$50CD, #$50CE, #$50D0, #$50D1, #$50D2, #$50D3, #$50D4, #$50D5,
      #$50D7, #$50D8, #$50D9, #$50DB, #$50DC, #$50DD, #$50DE, #$50DF,
      #$50E0, #$50E1, #$50E2, #$50E3, #$50E4, #$50E5, #$50E8, #$50E9,
      #$50EA, #$50EB, #$50EF, #$50F0, #$50F1, #$50F2, #$50F4, #$50F6,
      #$50F7, #$50F8, #$50F9, #$50FA, #$50FC, #$50FD, #$50FE, #$50FF,
      #$5100, #$5101, #$5102, #$5103, #$5104, #$5105, #$5108, #$5109,
      #$510A, #$510C, #$510D, #$510E, #$510F, #$5110, #$5111, #$5113,
      #$5114, #$5115, #$5116, #$5117, #$5118, #$5119, #$511A, #$511B,
      #$511C, #$511D, #$511E, #$511F, #$5120, #$5122, #$5123, #$5124,
      #$5125, #$5126, #$5127, #$5128, #$5129, #$512A, #$512B, #$512C,
      #$512D, #$512E, #$512F, #$5130, #$5131, #$5132, #$5133, #$5134,
      #$5135, #$5136, #$5137, #$5138, #$5139, #$513A, #$513B, #$513C,
      #$513D, #$513E, #$5142, #$5147, #$514A, #$514C, #$514E, #$514F,
      #$5150, #$5152, #$5153, #$5157, #$5158, #$5159, #$515B, #$515D,
      #$515E, #$515F, #$5160, #$5161, #$5163, #$5164, #$5166, #$5167,
      #$5169, #$516A, #$516F, #$5172, #$517A, #$517E, #$517F, #$5183,
      #$5184, #$5186, #$5187, #$518A, #$518B, #$518E, #$518F, #$5190,
      #$5191, #$5193, #$5194, #$5198, #$519A, #$519D, #$519E, #$519F,
      #$51A1, #$51A3, #$51A6, #$51A7, #$51A8, #$51A9, #$51AA, #$51AD,
      #$51AE, #$51B4, #$51B8, #$51B9, #$51BA, #$51BE, #$51BF, #$51C1,
      #$51C2, #$51C3, #$51C5, #$51C8, #$51CA, #$51CD, #$51CE, #$51D0,
      #$51D2, #$51D3, #$51D4, #$51D5, #$51D6, #$51D7,
      #$51D8, #$51D9, #$51DA, #$51DC, #$51DE, #$51DF, #$51E2, #$51E3,
      #$51E5, #$51E6, #$51E7, #$51E8, #$51E9, #$51EA, #$51EC, #$51EE,
      #$51F1, #$51F2, #$51F4, #$51F7, #$51FE, #$5204, #$5205, #$5209,
      #$520B, #$520C, #$520F, #$5210, #$5213, #$5214, #$5215, #$521C,
      #$521E, #$521F, #$5221, #$5222, #$5223, #$5225, #$5226, #$5227,
      #$522A, #$522C, #$522F, #$5231, #$5232, #$5234, #$5235, #$523C,
      #$523E, #$5244, #$5245, #$5246, #$5247, #$5248, #$5249, #$524B,
      #$524E, #$524F, #$5252, #$5253, #$5255, #$5257, #$5258, #$5259,
      #$525A, #$525B, #$525D, #$525F, #$5260, #$5262, #$5263, #$5264,
      #$5266, #$5268, #$526B, #$526C, #$526D, #$526E, #$5270, #$5271,
      #$5273, #$5274, #$5275, #$5276, #$5277, #$5278, #$5279, #$527A,
      #$527B, #$527C, #$527E, #$5280, #$5283, #$5284, #$5285, #$5286,
      #$5287, #$5289, #$528A, #$528B, #$528C, #$528D, #$528E, #$528F,
      #$5291, #$5292, #$5294, #$5295, #$5296, #$5297, #$5298, #$5299,
      #$529A, #$529C, #$52A4, #$52A5, #$52A6, #$52A7, #$52AE, #$52AF,
      #$52B0, #$52B4, #$52B5, #$52B6, #$52B7, #$52B8, #$52B9, #$52BA,
      #$52BB, #$52BC, #$52BD, #$52C0, #$52C1, #$52C2, #$52C4, #$52C5,
      #$52C6, #$52C8, #$52CA, #$52CC, #$52CD, #$52CE, #$52CF, #$52D1,
      #$52D3, #$52D4, #$52D5, #$52D7, #$52D9, #$52DA, #$52DB, #$52DC,
      #$52DD, #$52DE, #$52E0, #$52E1, #$52E2, #$52E3, #$52E5, #$52E6,
      #$52E7, #$52E8, #$52E9, #$52EA, #$52EB, #$52EC, #$52ED, #$52EE,
      #$52EF, #$52F1, #$52F2, #$52F3, #$52F4, #$52F5, #$52F6, #$52F7,
      #$52F8, #$52FB, #$52FC, #$52FD, #$5301, #$5302, #$5303, #$5304,
      #$5307, #$5309, #$530A, #$530B, #$530C, #$530E,
      #$5311, #$5312, #$5313, #$5314, #$5318, #$531B, #$531C, #$531E,
      #$531F, #$5322, #$5324, #$5325, #$5327, #$5328, #$5329, #$532B,
      #$532C, #$532D, #$532F, #$5330, #$5331, #$5332, #$5333, #$5334,
      #$5335, #$5336, #$5337, #$5338, #$533C, #$533D, #$5340, #$5342,
      #$5344, #$5346, #$534B, #$534C, #$534D, #$5350, #$5354, #$5358,
      #$5359, #$535B, #$535D, #$5365, #$5368, #$536A, #$536C, #$536D,
      #$5372, #$5376, #$5379, #$537B, #$537C, #$537D, #$537E, #$5380,
      #$5381, #$5383, #$5387, #$5388, #$538A, #$538E, #$538F, #$5390,
      #$5391, #$5392, #$5393, #$5394, #$5396, #$5397, #$5399, #$539B,
      #$539C, #$539E, #$53A0, #$53A1, #$53A4, #$53A7, #$53AA, #$53AB,
      #$53AC, #$53AD, #$53AF, #$53B0, #$53B1, #$53B2, #$53B3, #$53B4,
      #$53B5, #$53B7, #$53B8, #$53B9, #$53BA, #$53BC, #$53BD, #$53BE,
      #$53C0, #$53C3, #$53C4, #$53C5, #$53C6, #$53C7, #$53CE, #$53CF,
      #$53D0, #$53D2, #$53D3, #$53D5, #$53DA, #$53DC, #$53DD, #$53DE,
      #$53E1, #$53E2, #$53E7, #$53F4, #$53FA, #$53FE, #$53FF, #$5400,
      #$5402, #$5405, #$5407, #$540B, #$5414, #$5418, #$5419, #$541A,
      #$541C, #$5422, #$5424, #$5425, #$542A, #$5430, #$5433, #$5436,
      #$5437, #$543A, #$543D, #$543F, #$5441, #$5442, #$5444, #$5445,
      #$5447, #$5449, #$544C, #$544D, #$544E, #$544F, #$5451, #$545A,
      #$545D, #$545E, #$545F, #$5460, #$5461, #$5463, #$5465, #$5467,
      #$5469, #$546A, #$546B, #$546C, #$546D, #$546E, #$546F, #$5470,
      #$5474, #$5479, #$547A, #$547E, #$547F, #$5481, #$5483, #$5485,
      #$5487, #$5488, #$5489, #$548A, #$548D, #$5491, #$5493, #$5497,
      #$5498, #$549C, #$549E, #$549F, #$54A0, #$54A1,
      #$54A2, #$54A5, #$54AE, #$54B0, #$54B2, #$54B5, #$54B6, #$54B7,
      #$54B9, #$54BA, #$54BC, #$54BE, #$54C3, #$54C5, #$54CA, #$54CB,
      #$54D6, #$54D8, #$54DB, #$54E0, #$54E1, #$54E2, #$54E3, #$54E4,
      #$54EB, #$54EC, #$54EF, #$54F0, #$54F1, #$54F4, #$54F5, #$54F6,
      #$54F7, #$54F8, #$54F9, #$54FB, #$54FE, #$5500, #$5502, #$5503,
      #$5504, #$5505, #$5508, #$550A, #$550B, #$550C, #$550D, #$550E,
      #$5512, #$5513, #$5515, #$5516, #$5517, #$5518, #$5519, #$551A,
      #$551C, #$551D, #$551E, #$551F, #$5521, #$5525, #$5526, #$5528,
      #$5529, #$552B, #$552D, #$5532, #$5534, #$5535, #$5536, #$5538,
      #$5539, #$553A, #$553B, #$553D, #$5540, #$5542, #$5545, #$5547,
      #$5548, #$554B, #$554C, #$554D, #$554E, #$554F, #$5551, #$5552,
      #$5553, #$5554, #$5557, #$5558, #$5559, #$555A, #$555B, #$555D,
      #$555E, #$555F, #$5560, #$5562, #$5563, #$5568, #$5569, #$556B,
      #$556F, #$5570, #$5571, #$5572, #$5573, #$5574, #$5579, #$557A,
      #$557D, #$557F, #$5585, #$5586, #$558C, #$558D, #$558E, #$5590,
      #$5592, #$5593, #$5595, #$5596, #$5597, #$559A, #$559B, #$559E,
      #$55A0, #$55A1, #$55A2, #$55A3, #$55A4, #$55A5, #$55A6, #$55A8,
      #$55A9, #$55AA, #$55AB, #$55AC, #$55AD, #$55AE, #$55AF, #$55B0,
      #$55B2, #$55B4, #$55B6, #$55B8, #$55BA, #$55BC, #$55BF, #$55C0,
      #$55C1, #$55C2, #$55C3, #$55C6, #$55C7, #$55C8, #$55CA, #$55CB,
      #$55CE, #$55CF, #$55D0, #$55D5, #$55D7, #$55D8, #$55D9, #$55DA,
      #$55DB, #$55DE, #$55E0, #$55E2, #$55E7, #$55E9, #$55ED, #$55EE,
      #$55F0, #$55F1, #$55F4, #$55F6, #$55F8, #$55F9, #$55FA, #$55FB,
      #$55FC, #$55FF, #$5602, #$5603, #$5604, #$5605,
      #$5606, #$5607, #$560A, #$560B, #$560D, #$5610, #$5611, #$5612,
      #$5613, #$5614, #$5615, #$5616, #$5617, #$5619, #$561A, #$561C,
      #$561D, #$5620, #$5621, #$5622, #$5625, #$5626, #$5628, #$5629,
      #$562A, #$562B, #$562E, #$562F, #$5630, #$5633, #$5635, #$5637,
      #$5638, #$563A, #$563C, #$563D, #$563E, #$5640, #$5641, #$5642,
      #$5643, #$5644, #$5645, #$5646, #$5647, #$5648, #$5649, #$564A,
      #$564B, #$564F, #$5650, #$5651, #$5652, #$5653, #$5655, #$5656,
      #$565A, #$565B, #$565D, #$565E, #$565F, #$5660, #$5661, #$5663,
      #$5665, #$5666, #$5667, #$566D, #$566E, #$566F, #$5670, #$5672,
      #$5673, #$5674, #$5675, #$5677, #$5678, #$5679, #$567A, #$567D,
      #$567E, #$567F, #$5680, #$5681, #$5682, #$5683, #$5684, #$5687,
      #$5688, #$5689, #$568A, #$568B, #$568C, #$568D, #$5690, #$5691,
      #$5692, #$5694, #$5695, #$5696, #$5697, #$5698, #$5699, #$569A,
      #$569B, #$569C, #$569D, #$569E, #$569F, #$56A0, #$56A1, #$56A2,
      #$56A4, #$56A5, #$56A6, #$56A7, #$56A8, #$56A9, #$56AA, #$56AB,
      #$56AC, #$56AD, #$56AE, #$56B0, #$56B1, #$56B2, #$56B3, #$56B4,
      #$56B5, #$56B6, #$56B8, #$56B9, #$56BA, #$56BB, #$56BD, #$56BE,
      #$56BF, #$56C0, #$56C1, #$56C2, #$56C3, #$56C4, #$56C5, #$56C6,
      #$56C7, #$56C8, #$56C9, #$56CB, #$56CC, #$56CD, #$56CE, #$56CF,
      #$56D0, #$56D1, #$56D2, #$56D3, #$56D5, #$56D6, #$56D8, #$56D9,
      #$56DC, #$56E3, #$56E5, #$56E6, #$56E7, #$56E8, #$56E9, #$56EA,
      #$56EC, #$56EE, #$56EF, #$56F2, #$56F3, #$56F6, #$56F7, #$56F8,
      #$56FB, #$56FC, #$5700, #$5701, #$5702, #$5705, #$5707, #$570B,
      #$570C, #$570D, #$570E, #$570F, #$5710, #$5711,
      #$5712, #$5713, #$5714, #$5715, #$5716, #$5717, #$5718, #$5719,
      #$571A, #$571B, #$571D, #$571E, #$5720, #$5721, #$5722, #$5724,
      #$5725, #$5726, #$5727, #$572B, #$5731, #$5732, #$5734, #$5735,
      #$5736, #$5737, #$5738, #$573C, #$573D, #$573F, #$5741, #$5743,
      #$5744, #$5745, #$5746, #$5748, #$5749, #$574B, #$5752, #$5753,
      #$5754, #$5755, #$5756, #$5758, #$5759, #$5762, #$5763, #$5765,
      #$5767, #$576C, #$576E, #$5770, #$5771, #$5772, #$5774, #$5775,
      #$5778, #$5779, #$577A, #$577D, #$577E, #$577F, #$5780, #$5781,
      #$5787, #$5788, #$5789, #$578A, #$578D, #$578E, #$578F, #$5790,
      #$5791, #$5794, #$5795, #$5796, #$5797, #$5798, #$5799, #$579A,
      #$579C, #$579D, #$579E, #$579F, #$57A5, #$57A8, #$57AA, #$57AC,
      #$57AF, #$57B0, #$57B1, #$57B3, #$57B5, #$57B6, #$57B7, #$57B9,
      #$57BA, #$57BB, #$57BC, #$57BD, #$57BE, #$57BF, #$57C0, #$57C1,
      #$57C4, #$57C5, #$57C6, #$57C7, #$57C8, #$57C9, #$57CA, #$57CC,
      #$57CD, #$57D0, #$57D1, #$57D3, #$57D6, #$57D7, #$57DB, #$57DC,
      #$57DE, #$57E1, #$57E2, #$57E3, #$57E5, #$57E6, #$57E7, #$57E8,
      #$57E9, #$57EA, #$57EB, #$57EC, #$57EE, #$57F0, #$57F1, #$57F2,
      #$57F3, #$57F5, #$57F6, #$57F7, #$57FB, #$57FC, #$57FE, #$57FF,
      #$5801, #$5803, #$5804, #$5805, #$5808, #$5809, #$580A, #$580C,
      #$580E, #$580F, #$5810, #$5812, #$5813, #$5814, #$5816, #$5817,
      #$5818, #$581A, #$581B, #$581C, #$581D, #$581F, #$5822, #$5823,
      #$5825, #$5826, #$5827, #$5828, #$5829, #$582B, #$582C, #$582D,
      #$582E, #$582F, #$5831, #$5832, #$5833, #$5834, #$5836, #$5837,
      #$5838, #$5839, #$583A, #$583B, #$583C, #$583D,
      #$583E, #$583F, #$5840, #$5841, #$5842, #$5843, #$5845, #$5846,
      #$5847, #$5848, #$5849, #$584A, #$584B, #$584E, #$584F, #$5850,
      #$5852, #$5853, #$5855, #$5856, #$5857, #$5859, #$585A, #$585B,
      #$585C, #$585D, #$585F, #$5860, #$5861, #$5862, #$5863, #$5864,
      #$5866, #$5867, #$5868, #$5869, #$586A, #$586D, #$586E, #$586F,
      #$5870, #$5871, #$5872, #$5873, #$5874, #$5875, #$5876, #$5877,
      #$5878, #$5879, #$587A, #$587B, #$587C, #$587D, #$587F, #$5882,
      #$5884, #$5886, #$5887, #$5888, #$588A, #$588B, #$588C, #$588D,
      #$588E, #$588F, #$5890, #$5891, #$5894, #$5895, #$5896, #$5897,
      #$5898, #$589B, #$589C, #$589D, #$58A0, #$58A1, #$58A2, #$58A3,
      #$58A4, #$58A5, #$58A6, #$58A7, #$58AA, #$58AB, #$58AC, #$58AD,
      #$58AE, #$58AF, #$58B0, #$58B1, #$58B2, #$58B3, #$58B4, #$58B5,
      #$58B6, #$58B7, #$58B8, #$58B9, #$58BA, #$58BB, #$58BD, #$58BE,
      #$58BF, #$58C0, #$58C2, #$58C3, #$58C4, #$58C6, #$58C7, #$58C8,
      #$58C9, #$58CA, #$58CB, #$58CC, #$58CD, #$58CE, #$58CF, #$58D0,
      #$58D2, #$58D3, #$58D4, #$58D6, #$58D7, #$58D8, #$58D9, #$58DA,
      #$58DB, #$58DC, #$58DD, #$58DE, #$58DF, #$58E0, #$58E1, #$58E2,
      #$58E3, #$58E5, #$58E6, #$58E7, #$58E8, #$58E9, #$58EA, #$58ED,
      #$58EF, #$58F1, #$58F2, #$58F4, #$58F5, #$58F7, #$58F8, #$58FA,
      #$58FB, #$58FC, #$58FD, #$58FE, #$58FF, #$5900, #$5901, #$5903,
      #$5905, #$5906, #$5908, #$5909, #$590A, #$590B, #$590C, #$590E,
      #$5910, #$5911, #$5912, #$5913, #$5917, #$5918, #$591B, #$591D,
      #$591E, #$5920, #$5921, #$5922, #$5923, #$5926, #$5928, #$592C,
      #$5930, #$5932, #$5933, #$5935, #$5936, #$593B,
      #$593D, #$593E, #$593F, #$5940, #$5943, #$5945, #$5946, #$594A,
      #$594C, #$594D, #$5950, #$5952, #$5953, #$5959, #$595B, #$595C,
      #$595D, #$595E, #$595F, #$5961, #$5963, #$5964, #$5966, #$5967,
      #$5968, #$5969, #$596A, #$596B, #$596C, #$596D, #$596E, #$596F,
      #$5970, #$5971, #$5972, #$5975, #$5977, #$597A, #$597B, #$597C,
      #$597E, #$597F, #$5980, #$5985, #$5989, #$598B, #$598C, #$598E,
      #$598F, #$5990, #$5991, #$5994, #$5995, #$5998, #$599A, #$599B,
      #$599C, #$599D, #$599F, #$59A0, #$59A1, #$59A2, #$59A6, #$59A7,
      #$59AC, #$59AD, #$59B0, #$59B1, #$59B3, #$59B4, #$59B5, #$59B6,
      #$59B7, #$59B8, #$59BA, #$59BC, #$59BD, #$59BF, #$59C0, #$59C1,
      #$59C2, #$59C3, #$59C4, #$59C5, #$59C7, #$59C8, #$59C9, #$59CC,
      #$59CD, #$59CE, #$59CF, #$59D5, #$59D6, #$59D9, #$59DB, #$59DE,
      #$59DF, #$59E0, #$59E1, #$59E2, #$59E4, #$59E6, #$59E7, #$59E9,
      #$59EA, #$59EB, #$59ED, #$59EE, #$59EF, #$59F0, #$59F1, #$59F2,
      #$59F3, #$59F4, #$59F5, #$59F6, #$59F7, #$59F8, #$59FA, #$59FC,
      #$59FD, #$59FE, #$5A00, #$5A02, #$5A0A, #$5A0B, #$5A0D, #$5A0E,
      #$5A0F, #$5A10, #$5A12, #$5A14, #$5A15, #$5A16, #$5A17, #$5A19,
      #$5A1A, #$5A1B, #$5A1D, #$5A1E, #$5A21, #$5A22, #$5A24, #$5A26,
      #$5A27, #$5A28, #$5A2A, #$5A2B, #$5A2C, #$5A2D, #$5A2E, #$5A2F,
      #$5A30, #$5A33, #$5A35, #$5A37, #$5A38, #$5A39, #$5A3A, #$5A3B,
      #$5A3D, #$5A3E, #$5A3F, #$5A41, #$5A42, #$5A43, #$5A44, #$5A45,
      #$5A47, #$5A48, #$5A4B, #$5A4C, #$5A4D, #$5A4E, #$5A4F, #$5A50,
      #$5A51, #$5A52, #$5A53, #$5A54, #$5A56, #$5A57, #$5A58, #$5A59,
      #$5A5B, #$5A5C, #$5A5D, #$5A5E, #$5A5F, #$5A60,
      #$5A61, #$5A63, #$5A64, #$5A65, #$5A66, #$5A68, #$5A69, #$5A6B,
      #$5A6C, #$5A6D, #$5A6E, #$5A6F, #$5A70, #$5A71, #$5A72, #$5A73,
      #$5A78, #$5A79, #$5A7B, #$5A7C, #$5A7D, #$5A7E, #$5A80, #$5A81,
      #$5A82, #$5A83, #$5A84, #$5A85, #$5A86, #$5A87, #$5A88, #$5A89,
      #$5A8A, #$5A8B, #$5A8C, #$5A8D, #$5A8E, #$5A8F, #$5A90, #$5A91,
      #$5A93, #$5A94, #$5A95, #$5A96, #$5A97, #$5A98, #$5A99, #$5A9C,
      #$5A9D, #$5A9E, #$5A9F, #$5AA0, #$5AA1, #$5AA2, #$5AA3, #$5AA4,
      #$5AA5, #$5AA6, #$5AA7, #$5AA8, #$5AA9, #$5AAB, #$5AAC, #$5AAD,
      #$5AAE, #$5AAF, #$5AB0, #$5AB1, #$5AB4, #$5AB6, #$5AB7, #$5AB9,
      #$5ABA, #$5ABB, #$5ABC, #$5ABD, #$5ABF, #$5AC0, #$5AC3, #$5AC4,
      #$5AC5, #$5AC6, #$5AC7, #$5AC8, #$5ACA, #$5ACB, #$5ACD, #$5ACE,
      #$5ACF, #$5AD0, #$5AD1, #$5AD3, #$5AD5, #$5AD7, #$5AD9, #$5ADA,
      #$5ADB, #$5ADD, #$5ADE, #$5ADF, #$5AE2, #$5AE4, #$5AE5, #$5AE7,
      #$5AE8, #$5AEA, #$5AEC, #$5AED, #$5AEE, #$5AEF, #$5AF0, #$5AF2,
      #$5AF3, #$5AF4, #$5AF5, #$5AF6, #$5AF7, #$5AF8, #$5AF9, #$5AFA,
      #$5AFB, #$5AFC, #$5AFD, #$5AFE, #$5AFF, #$5B00, #$5B01, #$5B02,
      #$5B03, #$5B04, #$5B05, #$5B06, #$5B07, #$5B08, #$5B0A, #$5B0B,
      #$5B0C, #$5B0D, #$5B0E, #$5B0F, #$5B10, #$5B11, #$5B12, #$5B13,
      #$5B14, #$5B15, #$5B18, #$5B19, #$5B1A, #$5B1B, #$5B1C, #$5B1D,
      #$5B1E, #$5B1F, #$5B20, #$5B21, #$5B22, #$5B23, #$5B24, #$5B25,
      #$5B26, #$5B27, #$5B28, #$5B29, #$5B2A, #$5B2B, #$5B2C, #$5B2D,
      #$5B2E, #$5B2F, #$5B30, #$5B31, #$5B33, #$5B35, #$5B36, #$5B38,
      #$5B39, #$5B3A, #$5B3B, #$5B3C, #$5B3D, #$5B3E, #$5B3F, #$5B41,
      #$5B42, #$5B43, #$5B44, #$5B45, #$5B46, #$5B47,
      #$5B48, #$5B49, #$5B4A, #$5B4B, #$5B4C, #$5B4D, #$5B4E, #$5B4F,
      #$5B52, #$5B56, #$5B5E, #$5B60, #$5B61, #$5B67, #$5B68, #$5B6B,
      #$5B6D, #$5B6E, #$5B6F, #$5B72, #$5B74, #$5B76, #$5B77, #$5B78,
      #$5B79, #$5B7B, #$5B7C, #$5B7E, #$5B7F, #$5B82, #$5B86, #$5B8A,
      #$5B8D, #$5B8E, #$5B90, #$5B91, #$5B92, #$5B94, #$5B96, #$5B9F,
      #$5BA7, #$5BA8, #$5BA9, #$5BAC, #$5BAD, #$5BAE, #$5BAF, #$5BB1,
      #$5BB2, #$5BB7, #$5BBA, #$5BBB, #$5BBC, #$5BC0, #$5BC1, #$5BC3,
      #$5BC8, #$5BC9, #$5BCA, #$5BCB, #$5BCD, #$5BCE, #$5BCF, #$5BD1,
      #$5BD4, #$5BD5, #$5BD6, #$5BD7, #$5BD8, #$5BD9, #$5BDA, #$5BDB,
      #$5BDC, #$5BE0, #$5BE2, #$5BE3, #$5BE6, #$5BE7, #$5BE9, #$5BEA,
      #$5BEB, #$5BEC, #$5BED, #$5BEF, #$5BF1, #$5BF2, #$5BF3, #$5BF4,
      #$5BF5, #$5BF6, #$5BF7, #$5BFD, #$5BFE, #$5C00, #$5C02, #$5C03,
      #$5C05, #$5C07, #$5C08, #$5C0B, #$5C0C, #$5C0D, #$5C0E, #$5C10,
      #$5C12, #$5C13, #$5C17, #$5C19, #$5C1B, #$5C1E, #$5C1F, #$5C20,
      #$5C21, #$5C23, #$5C26, #$5C28, #$5C29, #$5C2A, #$5C2B, #$5C2D,
      #$5C2E, #$5C2F, #$5C30, #$5C32, #$5C33, #$5C35, #$5C36, #$5C37,
      #$5C43, #$5C44, #$5C46, #$5C47, #$5C4C, #$5C4D, #$5C52, #$5C53,
      #$5C54, #$5C56, #$5C57, #$5C58, #$5C5A, #$5C5B, #$5C5C, #$5C5D,
      #$5C5F, #$5C62, #$5C64, #$5C67, #$5C68, #$5C69, #$5C6A, #$5C6B,
      #$5C6C, #$5C6D, #$5C70, #$5C72, #$5C73, #$5C74, #$5C75, #$5C76,
      #$5C77, #$5C78, #$5C7B, #$5C7C, #$5C7D, #$5C7E, #$5C80, #$5C83,
      #$5C84, #$5C85, #$5C86, #$5C87, #$5C89, #$5C8A, #$5C8B, #$5C8E,
      #$5C8F, #$5C92, #$5C93, #$5C95, #$5C9D, #$5C9E, #$5C9F, #$5CA0,
      #$5CA1, #$5CA4, #$5CA5, #$5CA6, #$5CA7, #$5CA8,
      #$5CAA, #$5CAE, #$5CAF, #$5CB0, #$5CB2, #$5CB4, #$5CB6, #$5CB9,
      #$5CBA, #$5CBB, #$5CBC, #$5CBE, #$5CC0, #$5CC2, #$5CC3, #$5CC5,
      #$5CC6, #$5CC7, #$5CC8, #$5CC9, #$5CCA, #$5CCC, #$5CCD, #$5CCE,
      #$5CCF, #$5CD0, #$5CD1, #$5CD3, #$5CD4, #$5CD5, #$5CD6, #$5CD7,
      #$5CD8, #$5CDA, #$5CDB, #$5CDC, #$5CDD, #$5CDE, #$5CDF, #$5CE0,
      #$5CE2, #$5CE3, #$5CE7, #$5CE9, #$5CEB, #$5CEC, #$5CEE, #$5CEF,
      #$5CF1, #$5CF2, #$5CF3, #$5CF4, #$5CF5, #$5CF6, #$5CF7, #$5CF8,
      #$5CF9, #$5CFA, #$5CFC, #$5CFD, #$5CFE, #$5CFF, #$5D00, #$5D01,
      #$5D04, #$5D05, #$5D08, #$5D09, #$5D0A, #$5D0B, #$5D0C, #$5D0D,
      #$5D0F, #$5D10, #$5D11, #$5D12, #$5D13, #$5D15, #$5D17, #$5D18,
      #$5D19, #$5D1A, #$5D1C, #$5D1D, #$5D1F, #$5D20, #$5D21, #$5D22,
      #$5D23, #$5D25, #$5D28, #$5D2A, #$5D2B, #$5D2C, #$5D2F, #$5D30,
      #$5D31, #$5D32, #$5D33, #$5D35, #$5D36, #$5D37, #$5D38, #$5D39,
      #$5D3A, #$5D3B, #$5D3C, #$5D3F, #$5D40, #$5D41, #$5D42, #$5D43,
      #$5D44, #$5D45, #$5D46, #$5D48, #$5D49, #$5D4D, #$5D4E, #$5D4F,
      #$5D50, #$5D51, #$5D52, #$5D53, #$5D54, #$5D55, #$5D56, #$5D57,
      #$5D59, #$5D5A, #$5D5C, #$5D5E, #$5D5F, #$5D60, #$5D61, #$5D62,
      #$5D63, #$5D64, #$5D65, #$5D66, #$5D67, #$5D68, #$5D6A, #$5D6D,
      #$5D6E, #$5D70, #$5D71, #$5D72, #$5D73, #$5D75, #$5D76, #$5D77,
      #$5D78, #$5D79, #$5D7A, #$5D7B, #$5D7C, #$5D7D, #$5D7E, #$5D7F,
      #$5D80, #$5D81, #$5D83, #$5D84, #$5D85, #$5D86, #$5D87, #$5D88,
      #$5D89, #$5D8A, #$5D8B, #$5D8C, #$5D8D, #$5D8E, #$5D8F, #$5D90,
      #$5D91, #$5D92, #$5D93, #$5D94, #$5D95, #$5D96, #$5D97, #$5D98,
      #$5D9A, #$5D9B, #$5D9C, #$5D9E, #$5D9F, #$5DA0,
      #$5DA1, #$5DA2, #$5DA3, #$5DA4, #$5DA5, #$5DA6, #$5DA7, #$5DA8,
      #$5DA9, #$5DAA, #$5DAB, #$5DAC, #$5DAD, #$5DAE, #$5DAF, #$5DB0,
      #$5DB1, #$5DB2, #$5DB3, #$5DB4, #$5DB5, #$5DB6, #$5DB8, #$5DB9,
      #$5DBA, #$5DBB, #$5DBC, #$5DBD, #$5DBE, #$5DBF, #$5DC0, #$5DC1,
      #$5DC2, #$5DC3, #$5DC4, #$5DC6, #$5DC7, #$5DC8, #$5DC9, #$5DCA,
      #$5DCB, #$5DCC, #$5DCE, #$5DCF, #$5DD0, #$5DD1, #$5DD2, #$5DD3,
      #$5DD4, #$5DD5, #$5DD6, #$5DD7, #$5DD8, #$5DD9, #$5DDA, #$5DDC,
      #$5DDF, #$5DE0, #$5DE3, #$5DE4, #$5DEA, #$5DEC, #$5DED, #$5DF0,
      #$5DF5, #$5DF6, #$5DF8, #$5DF9, #$5DFA, #$5DFB, #$5DFC, #$5DFF,
      #$5E00, #$5E04, #$5E07, #$5E09, #$5E0A, #$5E0B, #$5E0D, #$5E0E,
      #$5E12, #$5E13, #$5E17, #$5E1E, #$5E1F, #$5E20, #$5E21, #$5E22,
      #$5E23, #$5E24, #$5E25, #$5E28, #$5E29, #$5E2A, #$5E2B, #$5E2C,
      #$5E2F, #$5E30, #$5E32, #$5E33, #$5E34, #$5E35, #$5E36, #$5E39,
      #$5E3A, #$5E3E, #$5E3F, #$5E40, #$5E41, #$5E43, #$5E46, #$5E47,
      #$5E48, #$5E49, #$5E4A, #$5E4B, #$5E4D, #$5E4E, #$5E4F, #$5E50,
      #$5E51, #$5E52, #$5E53, #$5E56, #$5E57, #$5E58, #$5E59, #$5E5A,
      #$5E5C, #$5E5D, #$5E5F, #$5E60, #$5E63, #$5E64, #$5E65, #$5E66,
      #$5E67, #$5E68, #$5E69, #$5E6A, #$5E6B, #$5E6C, #$5E6D, #$5E6E,
      #$5E6F, #$5E70, #$5E71, #$5E75, #$5E77, #$5E79, #$5E7E, #$5E81,
      #$5E82, #$5E83, #$5E85, #$5E88, #$5E89, #$5E8C, #$5E8D, #$5E8E,
      #$5E92, #$5E98, #$5E9B, #$5E9D, #$5EA1, #$5EA2, #$5EA3, #$5EA4,
      #$5EA8, #$5EA9, #$5EAA, #$5EAB, #$5EAC, #$5EAE, #$5EAF, #$5EB0,
      #$5EB1, #$5EB2, #$5EB4, #$5EBA, #$5EBB, #$5EBC, #$5EBD, #$5EBF,
      #$5EC0, #$5EC1, #$5EC2, #$5EC3, #$5EC4, #$5EC5,
      #$5EC6, #$5EC7, #$5EC8, #$5ECB, #$5ECC, #$5ECD, #$5ECE, #$5ECF,
      #$5ED0, #$5ED4, #$5ED5, #$5ED7, #$5ED8, #$5ED9, #$5EDA, #$5EDC,
      #$5EDD, #$5EDE, #$5EDF, #$5EE0, #$5EE1, #$5EE2, #$5EE3, #$5EE4,
      #$5EE5, #$5EE6, #$5EE7, #$5EE9, #$5EEB, #$5EEC, #$5EED, #$5EEE,
      #$5EEF, #$5EF0, #$5EF1, #$5EF2, #$5EF3, #$5EF5, #$5EF8, #$5EF9,
      #$5EFB, #$5EFC, #$5EFD, #$5F05, #$5F06, #$5F07, #$5F09, #$5F0C,
      #$5F0D, #$5F0E, #$5F10, #$5F12, #$5F14, #$5F16, #$5F19, #$5F1A,
      #$5F1C, #$5F1D, #$5F1E, #$5F21, #$5F22, #$5F23, #$5F24, #$5F28,
      #$5F2B, #$5F2C, #$5F2E, #$5F30, #$5F32, #$5F33, #$5F34, #$5F35,
      #$5F36, #$5F37, #$5F38, #$5F3B, #$5F3D, #$5F3E, #$5F3F, #$5F41,
      #$5F42, #$5F43, #$5F44, #$5F45, #$5F46, #$5F47, #$5F48, #$5F49,
      #$5F4A, #$5F4B, #$5F4C, #$5F4D, #$5F4E, #$5F4F, #$5F51, #$5F54,
      #$5F59, #$5F5A, #$5F5B, #$5F5C, #$5F5E, #$5F5F, #$5F60, #$5F63,
      #$5F65, #$5F67, #$5F68, #$5F6B, #$5F6E, #$5F6F, #$5F72, #$5F74,
      #$5F75, #$5F76, #$5F78, #$5F7A, #$5F7D, #$5F7E, #$5F7F, #$5F83,
      #$5F86, #$5F8D, #$5F8E, #$5F8F, #$5F91, #$5F93, #$5F94, #$5F96,
      #$5F9A, #$5F9B, #$5F9D, #$5F9E, #$5F9F, #$5FA0, #$5FA2, #$5FA3,
      #$5FA4, #$5FA5, #$5FA6, #$5FA7, #$5FA9, #$5FAB, #$5FAC, #$5FAF,
      #$5FB0, #$5FB1, #$5FB2, #$5FB3, #$5FB4, #$5FB6, #$5FB8, #$5FB9,
      #$5FBA, #$5FBB, #$5FBE, #$5FBF, #$5FC0, #$5FC1, #$5FC2, #$5FC7,
      #$5FC8, #$5FCA, #$5FCB, #$5FCE, #$5FD3, #$5FD4, #$5FD5, #$5FDA,
      #$5FDB, #$5FDC, #$5FDE, #$5FDF, #$5FE2, #$5FE3, #$5FE5, #$5FE6,
      #$5FE8, #$5FE9, #$5FEC, #$5FEF, #$5FF0, #$5FF2, #$5FF3, #$5FF4,
      #$5FF6, #$5FF7, #$5FF9, #$5FFA, #$5FFC, #$6007,
      #$6008, #$6009, #$600B, #$600C, #$6010, #$6011, #$6013, #$6017,
      #$6018, #$601A, #$601E, #$601F, #$6022, #$6023, #$6024, #$602C,
      #$602D, #$602E, #$6030, #$6031, #$6032, #$6033, #$6034, #$6036,
      #$6037, #$6038, #$6039, #$603A, #$603D, #$603E, #$6040, #$6044,
      #$6045, #$6046, #$6047, #$6048, #$6049, #$604A, #$604C, #$604E,
      #$604F, #$6051, #$6053, #$6054, #$6056, #$6057, #$6058, #$605B,
      #$605C, #$605E, #$605F, #$6060, #$6061, #$6065, #$6066, #$606E,
      #$6071, #$6072, #$6074, #$6075, #$6077, #$607E, #$6080, #$6081,
      #$6082, #$6085, #$6086, #$6087, #$6088, #$608A, #$608B, #$608E,
      #$608F, #$6090, #$6091, #$6093, #$6095, #$6097, #$6098, #$6099,
      #$609C, #$609E, #$60A1, #$60A2, #$60A4, #$60A5, #$60A7, #$60A9,
      #$60AA, #$60AE, #$60B0, #$60B3, #$60B5, #$60B6, #$60B7, #$60B9,
      #$60BA, #$60BD, #$60BE, #$60BF, #$60C0, #$60C1, #$60C2, #$60C3,
      #$60C4, #$60C7, #$60C8, #$60C9, #$60CC, #$60CD, #$60CE, #$60CF,
      #$60D0, #$60D2, #$60D3, #$60D4, #$60D6, #$60D7, #$60D9, #$60DB,
      #$60DE, #$60E1, #$60E2, #$60E3, #$60E4, #$60E5, #$60EA, #$60F1,
      #$60F2, #$60F5, #$60F7, #$60F8, #$60FB, #$60FC, #$60FD, #$60FE,
      #$60FF, #$6102, #$6103, #$6104, #$6105, #$6107, #$610A, #$610B,
      #$610C, #$6110, #$6111, #$6112, #$6113, #$6114, #$6116, #$6117,
      #$6118, #$6119, #$611B, #$611C, #$611D, #$611E, #$6121, #$6122,
      #$6125, #$6128, #$6129, #$612A, #$612C, #$612D, #$612E, #$612F,
      #$6130, #$6131, #$6132, #$6133, #$6134, #$6135, #$6136, #$6137,
      #$6138, #$6139, #$613A, #$613B, #$613C, #$613D, #$613E, #$6140,
      #$6141, #$6142, #$6143, #$6144, #$6145, #$6146,
      #$6147, #$6149, #$614B, #$614D, #$614F, #$6150, #$6152, #$6153,
      #$6154, #$6156, #$6157, #$6158, #$6159, #$615A, #$615B, #$615C,
      #$615E, #$615F, #$6160, #$6161, #$6163, #$6164, #$6165, #$6166,
      #$6169, #$616A, #$616B, #$616C, #$616D, #$616E, #$616F, #$6171,
      #$6172, #$6173, #$6174, #$6176, #$6178, #$6179, #$617A, #$617B,
      #$617C, #$617D, #$617E, #$617F, #$6180, #$6181, #$6182, #$6183,
      #$6184, #$6185, #$6186, #$6187, #$6188, #$6189, #$618A, #$618C,
      #$618D, #$618F, #$6190, #$6191, #$6192, #$6193, #$6195, #$6196,
      #$6197, #$6198, #$6199, #$619A, #$619B, #$619C, #$619E, #$619F,
      #$61A0, #$61A1, #$61A2, #$61A3, #$61A4, #$61A5, #$61A6, #$61AA,
      #$61AB, #$61AD, #$61AE, #$61AF, #$61B0, #$61B1, #$61B2, #$61B3,
      #$61B4, #$61B5, #$61B6, #$61B8, #$61B9, #$61BA, #$61BB, #$61BC,
      #$61BD, #$61BF, #$61C0, #$61C1, #$61C3, #$61C4, #$61C5, #$61C6,
      #$61C7, #$61C9, #$61CC, #$61CD, #$61CE, #$61CF, #$61D0, #$61D3,
      #$61D5, #$61D6, #$61D7, #$61D8, #$61D9, #$61DA, #$61DB, #$61DC,
      #$61DD, #$61DE, #$61DF, #$61E0, #$61E1, #$61E2, #$61E3, #$61E4,
      #$61E5, #$61E7, #$61E8, #$61E9, #$61EA, #$61EB, #$61EC, #$61ED,
      #$61EE, #$61EF, #$61F0, #$61F1, #$61F2, #$61F3, #$61F4, #$61F6,
      #$61F7, #$61F8, #$61F9, #$61FA, #$61FB, #$61FC, #$61FD, #$61FE,
      #$6200, #$6201, #$6202, #$6203, #$6204, #$6205, #$6207, #$6209,
      #$6213, #$6214, #$6219, #$621C, #$621D, #$621E, #$6220, #$6223,
      #$6226, #$6227, #$6228, #$6229, #$622B, #$622D, #$622F, #$6230,
      #$6231, #$6232, #$6235, #$6236, #$6238, #$6239, #$623A, #$623B,
      #$623C, #$6242, #$6244, #$6245, #$6246, #$624A,
      #$624F, #$6250, #$6255, #$6256, #$6257, #$6259, #$625A, #$625C,
      #$625D, #$625E, #$625F, #$6260, #$6261, #$6262, #$6264, #$6265,
      #$6268, #$6271, #$6272, #$6274, #$6275, #$6277, #$6278, #$627A,
      #$627B, #$627D, #$6281, #$6282, #$6283, #$6285, #$6286, #$6287,
      #$6288, #$628B, #$628C, #$628D, #$628E, #$628F, #$6290, #$6294,
      #$6299, #$629C, #$629D, #$629E, #$62A3, #$62A6, #$62A7, #$62A9,
      #$62AA, #$62AD, #$62AE, #$62AF, #$62B0, #$62B2, #$62B3, #$62B4,
      #$62B6, #$62B7, #$62B8, #$62BA, #$62BE, #$62C0, #$62C1, #$62C3,
      #$62CB, #$62CF, #$62D1, #$62D5, #$62DD, #$62DE, #$62E0, #$62E1,
      #$62E4, #$62EA, #$62EB, #$62F0, #$62F2, #$62F5, #$62F8, #$62F9,
      #$62FA, #$62FB, #$6300, #$6303, #$6304, #$6305, #$6306, #$630A,
      #$630B, #$630C, #$630D, #$630F, #$6310, #$6312, #$6313, #$6314,
      #$6315, #$6317, #$6318, #$6319, #$631C, #$6326, #$6327, #$6329,
      #$632C, #$632D, #$632E, #$6330, #$6331, #$6333, #$6334, #$6335,
      #$6336, #$6337, #$6338, #$633B, #$633C, #$633E, #$633F, #$6340,
      #$6341, #$6344, #$6347, #$6348, #$634A, #$6351, #$6352, #$6353,
      #$6354, #$6356, #$6357, #$6358, #$6359, #$635A, #$635B, #$635C,
      #$635D, #$6360, #$6364, #$6365, #$6366, #$6368, #$636A, #$636B,
      #$636C, #$636F, #$6370, #$6372, #$6373, #$6374, #$6375, #$6378,
      #$6379, #$637C, #$637D, #$637E, #$637F, #$6381, #$6383, #$6384,
      #$6385, #$6386, #$638B, #$638D, #$6391, #$6393, #$6394, #$6395,
      #$6397, #$6399, #$639A, #$639B, #$639C, #$639D, #$639E, #$639F,
      #$63A1, #$63A4, #$63A6, #$63AB, #$63AF, #$63B1, #$63B2, #$63B5,
      #$63B6, #$63B9, #$63BB, #$63BD, #$63BF, #$63C0,
      #$63C1, #$63C2, #$63C3, #$63C5, #$63C7, #$63C8, #$63CA, #$63CB,
      #$63CC, #$63D1, #$63D3, #$63D4, #$63D5, #$63D7, #$63D8, #$63D9,
      #$63DA, #$63DB, #$63DC, #$63DD, #$63DF, #$63E2, #$63E4, #$63E5,
      #$63E6, #$63E7, #$63E8, #$63EB, #$63EC, #$63EE, #$63EF, #$63F0,
      #$63F1, #$63F3, #$63F5, #$63F7, #$63F9, #$63FA, #$63FB, #$63FC,
      #$63FE, #$6403, #$6404, #$6406, #$6407, #$6408, #$6409, #$640A,
      #$640D, #$640E, #$6411, #$6412, #$6415, #$6416, #$6417, #$6418,
      #$6419, #$641A, #$641D, #$641F, #$6422, #$6423, #$6424, #$6425,
      #$6427, #$6428, #$6429, #$642B, #$642E, #$642F, #$6430, #$6431,
      #$6432, #$6433, #$6435, #$6436, #$6437, #$6438, #$6439, #$643B,
      #$643C, #$643E, #$6440, #$6442, #$6443, #$6449, #$644B, #$644C,
      #$644D, #$644E, #$644F, #$6450, #$6451, #$6453, #$6455, #$6456,
      #$6457, #$6459, #$645A, #$645B, #$645C, #$645D, #$645F, #$6460,
      #$6461, #$6462, #$6463, #$6464, #$6465, #$6466, #$6468, #$646A,
      #$646B, #$646C, #$646E, #$646F, #$6470, #$6471, #$6472, #$6473,
      #$6474, #$6475, #$6476, #$6477, #$647B, #$647C, #$647D, #$647E,
      #$647F, #$6480, #$6481, #$6483, #$6486, #$6488, #$6489, #$648A,
      #$648B, #$648C, #$648D, #$648E, #$648F, #$6490, #$6493, #$6494,
      #$6497, #$6498, #$649A, #$649B, #$649C, #$649D, #$649F, #$64A0,
      #$64A1, #$64A2, #$64A3, #$64A5, #$64A6, #$64A7, #$64A8, #$64AA,
      #$64AB, #$64AF, #$64B1, #$64B2, #$64B3, #$64B4, #$64B6, #$64B9,
      #$64BB, #$64BD, #$64BE, #$64BF, #$64C1, #$64C3, #$64C4, #$64C6,
      #$64C7, #$64C8, #$64C9, #$64CA, #$64CB, #$64CC, #$64CF, #$64D1,
      #$64D3, #$64D4, #$64D5, #$64D6, #$64D9, #$64DA,
      #$64DB, #$64DC, #$64DD, #$64DF, #$64E0, #$64E1, #$64E3, #$64E5,
      #$64E7, #$64E8, #$64E9, #$64EA, #$64EB, #$64EC, #$64ED, #$64EE,
      #$64EF, #$64F0, #$64F1, #$64F2, #$64F3, #$64F4, #$64F5, #$64F6,
      #$64F7, #$64F8, #$64F9, #$64FA, #$64FB, #$64FC, #$64FD, #$64FE,
      #$64FF, #$6501, #$6502, #$6503, #$6504, #$6505, #$6506, #$6507,
      #$6508, #$650A, #$650B, #$650C, #$650D, #$650E, #$650F, #$6510,
      #$6511, #$6513, #$6514, #$6515, #$6516, #$6517, #$6519, #$651A,
      #$651B, #$651C, #$651D, #$651E, #$651F, #$6520, #$6521, #$6522,
      #$6523, #$6524, #$6526, #$6527, #$6528, #$6529, #$652A, #$652C,
      #$652D, #$6530, #$6531, #$6532, #$6533, #$6537, #$653A, #$653C,
      #$653D, #$6540, #$6541, #$6542, #$6543, #$6544, #$6546, #$6547,
      #$654A, #$654B, #$654D, #$654E, #$6550, #$6552, #$6553, #$6554,
      #$6557, #$6558, #$655A, #$655C, #$655F, #$6560, #$6561, #$6564,
      #$6565, #$6567, #$6568, #$6569, #$656A, #$656D, #$656E, #$656F,
      #$6571, #$6573, #$6575, #$6576, #$6578, #$6579, #$657A, #$657B,
      #$657C, #$657D, #$657E, #$657F, #$6580, #$6581, #$6582, #$6583,
      #$6584, #$6585, #$6586, #$6588, #$6589, #$658A, #$658D, #$658E,
      #$658F, #$6592, #$6594, #$6595, #$6596, #$6598, #$659A, #$659D,
      #$659E, #$65A0, #$65A2, #$65A3, #$65A6, #$65A8, #$65AA, #$65AC,
      #$65AE, #$65B1, #$65B2, #$65B3, #$65B4, #$65B5, #$65B6, #$65B7,
      #$65B8, #$65BA, #$65BB, #$65BE, #$65BF, #$65C0, #$65C2, #$65C7,
      #$65C8, #$65C9, #$65CA, #$65CD, #$65D0, #$65D1, #$65D3, #$65D4,
      #$65D5, #$65D8, #$65D9, #$65DA, #$65DB, #$65DC, #$65DD, #$65DE,
      #$65DF, #$65E1, #$65E3, #$65E4, #$65EA, #$65EB,
      #$65F2, #$65F3, #$65F4, #$65F5, #$65F8, #$65F9, #$65FB, #$65FC,
      #$65FD, #$65FE, #$65FF, #$6601, #$6604, #$6605, #$6607, #$6608,
      #$6609, #$660B, #$660D, #$6610, #$6611, #$6612, #$6616, #$6617,
      #$6618, #$661A, #$661B, #$661C, #$661E, #$6621, #$6622, #$6623,
      #$6624, #$6626, #$6629, #$662A, #$662B, #$662C, #$662E, #$6630,
      #$6632, #$6633, #$6637, #$6638, #$6639, #$663A, #$663B, #$663D,
      #$663F, #$6640, #$6642, #$6644, #$6645, #$6646, #$6647, #$6648,
      #$6649, #$664A, #$664D, #$664E, #$6650, #$6651, #$6658, #$6659,
      #$665B, #$665C, #$665D, #$665E, #$6660, #$6662, #$6663, #$6665,
      #$6667, #$6669, #$666A, #$666B, #$666C, #$666D, #$6671, #$6672,
      #$6673, #$6675, #$6678, #$6679, #$667B, #$667C, #$667D, #$667F,
      #$6680, #$6681, #$6683, #$6685, #$6686, #$6688, #$6689, #$668A,
      #$668B, #$668D, #$668E, #$668F, #$6690, #$6692, #$6693, #$6694,
      #$6695, #$6698, #$6699, #$669A, #$669B, #$669C, #$669E, #$669F,
      #$66A0, #$66A1, #$66A2, #$66A3, #$66A4, #$66A5, #$66A6, #$66A9,
      #$66AA, #$66AB, #$66AC, #$66AD, #$66AF, #$66B0, #$66B1, #$66B2,
      #$66B3, #$66B5, #$66B6, #$66B7, #$66B8, #$66BA, #$66BB, #$66BC,
      #$66BD, #$66BF, #$66C0, #$66C1, #$66C2, #$66C3, #$66C4, #$66C5,
      #$66C6, #$66C7, #$66C8, #$66C9, #$66CA, #$66CB, #$66CC, #$66CD,
      #$66CE, #$66CF, #$66D0, #$66D1, #$66D2, #$66D3, #$66D4, #$66D5,
      #$66D6, #$66D7, #$66D8, #$66DA, #$66DE, #$66DF, #$66E0, #$66E1,
      #$66E2, #$66E3, #$66E4, #$66E5, #$66E7, #$66E8, #$66EA, #$66EB,
      #$66EC, #$66ED, #$66EE, #$66EF, #$66F1, #$66F5, #$66F6, #$66F8,
      #$66FA, #$66FB, #$66FD, #$6701, #$6702, #$6703,
      #$6704, #$6705, #$6706, #$6707, #$670C, #$670E, #$670F, #$6711,
      #$6712, #$6713, #$6716, #$6718, #$6719, #$671A, #$671C, #$671E,
      #$6720, #$6721, #$6722, #$6723, #$6724, #$6725, #$6727, #$6729,
      #$672E, #$6730, #$6732, #$6733, #$6736, #$6737, #$6738, #$6739,
      #$673B, #$673C, #$673E, #$673F, #$6741, #$6744, #$6745, #$6747,
      #$674A, #$674B, #$674D, #$6752, #$6754, #$6755, #$6757, #$6758,
      #$6759, #$675A, #$675B, #$675D, #$6762, #$6763, #$6764, #$6766,
      #$6767, #$676B, #$676C, #$676E, #$6771, #$6774, #$6776, #$6778,
      #$6779, #$677A, #$677B, #$677D, #$6780, #$6782, #$6783, #$6785,
      #$6786, #$6788, #$678A, #$678C, #$678D, #$678E, #$678F, #$6791,
      #$6792, #$6793, #$6794, #$6796, #$6799, #$679B, #$679F, #$67A0,
      #$67A1, #$67A4, #$67A6, #$67A9, #$67AC, #$67AE, #$67B1, #$67B2,
      #$67B4, #$67B9, #$67BA, #$67BB, #$67BC, #$67BD, #$67BE, #$67BF,
      #$67C0, #$67C2, #$67C5, #$67C6, #$67C7, #$67C8, #$67C9, #$67CA,
      #$67CB, #$67CC, #$67CD, #$67CE, #$67D5, #$67D6, #$67D7, #$67DB,
      #$67DF, #$67E1, #$67E3, #$67E4, #$67E6, #$67E7, #$67E8, #$67EA,
      #$67EB, #$67ED, #$67EE, #$67F2, #$67F5, #$67F6, #$67F7, #$67F8,
      #$67F9, #$67FA, #$67FB, #$67FC, #$67FE, #$6801, #$6802, #$6803,
      #$6804, #$6806, #$680D, #$6810, #$6812, #$6814, #$6815, #$6818,
      #$6819, #$681A, #$681B, #$681C, #$681E, #$681F, #$6820, #$6822,
      #$6823, #$6824, #$6825, #$6826, #$6827, #$6828, #$682B, #$682C,
      #$682D, #$682E, #$682F, #$6830, #$6831, #$6834, #$6835, #$6836,
      #$683A, #$683B, #$683F, #$6847, #$684B, #$684D, #$684F, #$6852,
      #$6856, #$6857, #$6858, #$6859, #$685A, #$685B,
      #$685C, #$685D, #$685E, #$685F, #$686A, #$686C, #$686D, #$686E,
      #$686F, #$6870, #$6871, #$6872, #$6873, #$6875, #$6878, #$6879,
      #$687A, #$687B, #$687C, #$687D, #$687E, #$687F, #$6880, #$6882,
      #$6884, #$6887, #$6888, #$6889, #$688A, #$688B, #$688C, #$688D,
      #$688E, #$6890, #$6891, #$6892, #$6894, #$6895, #$6896, #$6898,
      #$6899, #$689A, #$689B, #$689C, #$689D, #$689E, #$689F, #$68A0,
      #$68A1, #$68A3, #$68A4, #$68A5, #$68A9, #$68AA, #$68AB, #$68AC,
      #$68AE, #$68B1, #$68B2, #$68B4, #$68B6, #$68B7, #$68B8, #$68B9,
      #$68BA, #$68BB, #$68BC, #$68BD, #$68BE, #$68BF, #$68C1, #$68C3,
      #$68C4, #$68C5, #$68C6, #$68C7, #$68C8, #$68CA, #$68CC, #$68CE,
      #$68CF, #$68D0, #$68D1, #$68D3, #$68D4, #$68D6, #$68D7, #$68D9,
      #$68DB, #$68DC, #$68DD, #$68DE, #$68DF, #$68E1, #$68E2, #$68E4,
      #$68E5, #$68E6, #$68E7, #$68E8, #$68E9, #$68EA, #$68EB, #$68EC,
      #$68ED, #$68EF, #$68F2, #$68F3, #$68F4, #$68F6, #$68F7, #$68F8,
      #$68FB, #$68FD, #$68FE, #$68FF, #$6900, #$6902, #$6903, #$6904,
      #$6906, #$6907, #$6908, #$6909, #$690A, #$690C, #$690F, #$6911,
      #$6913, #$6914, #$6915, #$6916, #$6917, #$6918, #$6919, #$691A,
      #$691B, #$691C, #$691D, #$691E, #$6921, #$6922, #$6923, #$6925,
      #$6926, #$6927, #$6928, #$6929, #$692A, #$692B, #$692C, #$692E,
      #$692F, #$6931, #$6932, #$6933, #$6935, #$6936, #$6937, #$6938,
      #$693A, #$693B, #$693C, #$693E, #$6940, #$6941, #$6943, #$6944,
      #$6945, #$6946, #$6947, #$6948, #$6949, #$694A, #$694B, #$694C,
      #$694D, #$694E, #$694F, #$6950, #$6951, #$6952, #$6953, #$6955,
      #$6956, #$6958, #$6959, #$695B, #$695C, #$695F,
      #$6961, #$6962, #$6964, #$6965, #$6967, #$6968, #$6969, #$696A,
      #$696C, #$696D, #$696F, #$6970, #$6972, #$6973, #$6974, #$6975,
      #$6976, #$697A, #$697B, #$697D, #$697E, #$697F, #$6981, #$6983,
      #$6985, #$698A, #$698B, #$698C, #$698E, #$698F, #$6990, #$6991,
      #$6992, #$6993, #$6996, #$6997, #$6999, #$699A, #$699D, #$699E,
      #$699F, #$69A0, #$69A1, #$69A2, #$69A3, #$69A4, #$69A5, #$69A6,
      #$69A9, #$69AA, #$69AC, #$69AE, #$69AF, #$69B0, #$69B2, #$69B3,
      #$69B5, #$69B6, #$69B8, #$69B9, #$69BA, #$69BC, #$69BD, #$69BE,
      #$69BF, #$69C0, #$69C2, #$69C3, #$69C4, #$69C5, #$69C6, #$69C7,
      #$69C8, #$69C9, #$69CB, #$69CD, #$69CF, #$69D1, #$69D2, #$69D3,
      #$69D5, #$69D6, #$69D7, #$69D8, #$69D9, #$69DA, #$69DC, #$69DD,
      #$69DE, #$69E1, #$69E2, #$69E3, #$69E4, #$69E5, #$69E6, #$69E7,
      #$69E8, #$69E9, #$69EA, #$69EB, #$69EC, #$69EE, #$69EF, #$69F0,
      #$69F1, #$69F3, #$69F4, #$69F5, #$69F6, #$69F7, #$69F8, #$69F9,
      #$69FA, #$69FB, #$69FC, #$69FE, #$6A00, #$6A01, #$6A02, #$6A03,
      #$6A04, #$6A05, #$6A06, #$6A07, #$6A08, #$6A09, #$6A0B, #$6A0C,
      #$6A0D, #$6A0E, #$6A0F, #$6A10, #$6A11, #$6A12, #$6A13, #$6A14,
      #$6A15, #$6A16, #$6A19, #$6A1A, #$6A1B, #$6A1C, #$6A1D, #$6A1E,
      #$6A20, #$6A22, #$6A23, #$6A24, #$6A25, #$6A26, #$6A27, #$6A29,
      #$6A2B, #$6A2C, #$6A2D, #$6A2E, #$6A30, #$6A32, #$6A33, #$6A34,
      #$6A36, #$6A37, #$6A38, #$6A39, #$6A3A, #$6A3B, #$6A3C, #$6A3F,
      #$6A40, #$6A41, #$6A42, #$6A43, #$6A45, #$6A46, #$6A48, #$6A49,
      #$6A4A, #$6A4B, #$6A4C, #$6A4D, #$6A4E, #$6A4F, #$6A51, #$6A52,
      #$6A53, #$6A54, #$6A55, #$6A56, #$6A57, #$6A5A,
      #$6A5C, #$6A5D, #$6A5E, #$6A5F, #$6A60, #$6A62, #$6A63, #$6A64,
      #$6A66, #$6A67, #$6A68, #$6A69, #$6A6A, #$6A6B, #$6A6C, #$6A6D,
      #$6A6E, #$6A6F, #$6A70, #$6A72, #$6A73, #$6A74, #$6A75, #$6A76,
      #$6A77, #$6A78, #$6A7A, #$6A7B, #$6A7D, #$6A7E, #$6A7F, #$6A81,
      #$6A82, #$6A83, #$6A85, #$6A86, #$6A87, #$6A88, #$6A89, #$6A8A,
      #$6A8B, #$6A8C, #$6A8D, #$6A8F, #$6A92, #$6A93, #$6A94, #$6A95,
      #$6A96, #$6A98, #$6A99, #$6A9A, #$6A9B, #$6A9C, #$6A9D, #$6A9E,
      #$6A9F, #$6AA1, #$6AA2, #$6AA3, #$6AA4, #$6AA5, #$6AA6, #$6AA7,
      #$6AA8, #$6AAA, #$6AAD, #$6AAE, #$6AAF, #$6AB0, #$6AB1, #$6AB2,
      #$6AB3, #$6AB4, #$6AB5, #$6AB6, #$6AB7, #$6AB8, #$6AB9, #$6ABA,
      #$6ABB, #$6ABC, #$6ABD, #$6ABE, #$6ABF, #$6AC0, #$6AC1, #$6AC2,
      #$6AC3, #$6AC4, #$6AC5, #$6AC6, #$6AC7, #$6AC8, #$6AC9, #$6ACA,
      #$6ACB, #$6ACC, #$6ACD, #$6ACE, #$6ACF, #$6AD0, #$6AD1, #$6AD2,
      #$6AD3, #$6AD4, #$6AD5, #$6AD6, #$6AD7, #$6AD8, #$6AD9, #$6ADA,
      #$6ADB, #$6ADC, #$6ADD, #$6ADE, #$6ADF, #$6AE0, #$6AE1, #$6AE2,
      #$6AE3, #$6AE4, #$6AE5, #$6AE6, #$6AE7, #$6AE8, #$6AE9, #$6AEA,
      #$6AEB, #$6AEC, #$6AED, #$6AEE, #$6AEF, #$6AF0, #$6AF1, #$6AF2,
      #$6AF3, #$6AF4, #$6AF5, #$6AF6, #$6AF7, #$6AF8, #$6AF9, #$6AFA,
      #$6AFB, #$6AFC, #$6AFD, #$6AFE, #$6AFF, #$6B00, #$6B01, #$6B02,
      #$6B03, #$6B04, #$6B05, #$6B06, #$6B07, #$6B08, #$6B09, #$6B0A,
      #$6B0B, #$6B0C, #$6B0D, #$6B0E, #$6B0F, #$6B10, #$6B11, #$6B12,
      #$6B13, #$6B14, #$6B15, #$6B16, #$6B17, #$6B18, #$6B19, #$6B1A,
      #$6B1B, #$6B1C, #$6B1D, #$6B1E, #$6B1F, #$6B25, #$6B26, #$6B28,
      #$6B29, #$6B2A, #$6B2B, #$6B2C, #$6B2D, #$6B2E,
      #$6B2F, #$6B30, #$6B31, #$6B33, #$6B34, #$6B35, #$6B36, #$6B38,
      #$6B3B, #$6B3C, #$6B3D, #$6B3F, #$6B40, #$6B41, #$6B42, #$6B44,
      #$6B45, #$6B48, #$6B4A, #$6B4B, #$6B4D, #$6B4E, #$6B4F, #$6B50,
      #$6B51, #$6B52, #$6B53, #$6B54, #$6B55, #$6B56, #$6B57, #$6B58,
      #$6B5A, #$6B5B, #$6B5C, #$6B5D, #$6B5E, #$6B5F, #$6B60, #$6B61,
      #$6B68, #$6B69, #$6B6B, #$6B6C, #$6B6D, #$6B6E, #$6B6F, #$6B70,
      #$6B71, #$6B72, #$6B73, #$6B74, #$6B75, #$6B76, #$6B77, #$6B78,
      #$6B7A, #$6B7D, #$6B7E, #$6B7F, #$6B80, #$6B85, #$6B88, #$6B8C,
      #$6B8E, #$6B8F, #$6B90, #$6B91, #$6B94, #$6B95, #$6B97, #$6B98,
      #$6B99, #$6B9C, #$6B9D, #$6B9E, #$6B9F, #$6BA0, #$6BA2, #$6BA3,
      #$6BA4, #$6BA5, #$6BA6, #$6BA7, #$6BA8, #$6BA9, #$6BAB, #$6BAC,
      #$6BAD, #$6BAE, #$6BAF, #$6BB0, #$6BB1, #$6BB2, #$6BB6, #$6BB8,
      #$6BB9, #$6BBA, #$6BBB, #$6BBC, #$6BBD, #$6BBE, #$6BC0, #$6BC3,
      #$6BC4, #$6BC6, #$6BC7, #$6BC8, #$6BC9, #$6BCA, #$6BCC, #$6BCE,
      #$6BD0, #$6BD1, #$6BD8, #$6BDA, #$6BDC, #$6BDD, #$6BDE, #$6BDF,
      #$6BE0, #$6BE2, #$6BE3, #$6BE4, #$6BE5, #$6BE6, #$6BE7, #$6BE8,
      #$6BE9, #$6BEC, #$6BED, #$6BEE, #$6BF0, #$6BF1, #$6BF2, #$6BF4,
      #$6BF6, #$6BF7, #$6BF8, #$6BFA, #$6BFB, #$6BFC, #$6BFE, #$6BFF,
      #$6C00, #$6C01, #$6C02, #$6C03, #$6C04, #$6C08, #$6C09, #$6C0A,
      #$6C0B, #$6C0C, #$6C0E, #$6C12, #$6C17, #$6C1C, #$6C1D, #$6C1E,
      #$6C20, #$6C23, #$6C25, #$6C2B, #$6C2C, #$6C2D, #$6C31, #$6C33,
      #$6C36, #$6C37, #$6C39, #$6C3A, #$6C3B, #$6C3C, #$6C3E, #$6C3F,
      #$6C43, #$6C44, #$6C45, #$6C48, #$6C4B, #$6C4C, #$6C4D, #$6C4E,
      #$6C4F, #$6C51, #$6C52, #$6C53, #$6C56, #$6C58,
      #$6C59, #$6C5A, #$6C62, #$6C63, #$6C65, #$6C66, #$6C67, #$6C6B,
      #$6C6C, #$6C6D, #$6C6E, #$6C6F, #$6C71, #$6C73, #$6C75, #$6C77,
      #$6C78, #$6C7A, #$6C7B, #$6C7C, #$6C7F, #$6C80, #$6C84, #$6C87,
      #$6C8A, #$6C8B, #$6C8D, #$6C8E, #$6C91, #$6C92, #$6C95, #$6C96,
      #$6C97, #$6C98, #$6C9A, #$6C9C, #$6C9D, #$6C9E, #$6CA0, #$6CA2,
      #$6CA8, #$6CAC, #$6CAF, #$6CB0, #$6CB4, #$6CB5, #$6CB6, #$6CB7,
      #$6CBA, #$6CC0, #$6CC1, #$6CC2, #$6CC3, #$6CC6, #$6CC7, #$6CC8,
      #$6CCB, #$6CCD, #$6CCE, #$6CCF, #$6CD1, #$6CD2, #$6CD8, #$6CD9,
      #$6CDA, #$6CDC, #$6CDD, #$6CDF, #$6CE4, #$6CE6, #$6CE7, #$6CE9,
      #$6CEC, #$6CED, #$6CF2, #$6CF4, #$6CF9, #$6CFF, #$6D00, #$6D02,
      #$6D03, #$6D05, #$6D06, #$6D08, #$6D09, #$6D0A, #$6D0D, #$6D0F,
      #$6D10, #$6D11, #$6D13, #$6D14, #$6D15, #$6D16, #$6D18, #$6D1C,
      #$6D1D, #$6D1F, #$6D20, #$6D21, #$6D22, #$6D23, #$6D24, #$6D26,
      #$6D28, #$6D29, #$6D2C, #$6D2D, #$6D2F, #$6D30, #$6D34, #$6D36,
      #$6D37, #$6D38, #$6D3A, #$6D3F, #$6D40, #$6D42, #$6D44, #$6D49,
      #$6D4C, #$6D50, #$6D55, #$6D56, #$6D57, #$6D58, #$6D5B, #$6D5D,
      #$6D5F, #$6D61, #$6D62, #$6D64, #$6D65, #$6D67, #$6D68, #$6D6B,
      #$6D6C, #$6D6D, #$6D70, #$6D71, #$6D72, #$6D73, #$6D75, #$6D76,
      #$6D79, #$6D7A, #$6D7B, #$6D7D, #$6D7E, #$6D7F, #$6D80, #$6D81,
      #$6D83, #$6D84, #$6D86, #$6D87, #$6D8A, #$6D8B, #$6D8D, #$6D8F,
      #$6D90, #$6D92, #$6D96, #$6D97, #$6D98, #$6D99, #$6D9A, #$6D9C,
      #$6DA2, #$6DA5, #$6DAC, #$6DAD, #$6DB0, #$6DB1, #$6DB3, #$6DB4,
      #$6DB6, #$6DB7, #$6DB9, #$6DBA, #$6DBB, #$6DBC, #$6DBD, #$6DBE,
      #$6DC1, #$6DC2, #$6DC3, #$6DC8, #$6DC9, #$6DCA,
      #$6DCD, #$6DCE, #$6DCF, #$6DD0, #$6DD2, #$6DD3, #$6DD4, #$6DD5,
      #$6DD7, #$6DDA, #$6DDB, #$6DDC, #$6DDF, #$6DE2, #$6DE3, #$6DE5,
      #$6DE7, #$6DE8, #$6DE9, #$6DEA, #$6DED, #$6DEF, #$6DF0, #$6DF2,
      #$6DF4, #$6DF5, #$6DF6, #$6DF8, #$6DFA, #$6DFD, #$6DFE, #$6DFF,
      #$6E00, #$6E01, #$6E02, #$6E03, #$6E04, #$6E06, #$6E07, #$6E08,
      #$6E09, #$6E0B, #$6E0F, #$6E12, #$6E13, #$6E15, #$6E18, #$6E19,
      #$6E1B, #$6E1C, #$6E1E, #$6E1F, #$6E22, #$6E26, #$6E27, #$6E28,
      #$6E2A, #$6E2C, #$6E2E, #$6E30, #$6E31, #$6E33, #$6E35, #$6E36,
      #$6E37, #$6E39, #$6E3B, #$6E3C, #$6E3D, #$6E3E, #$6E3F, #$6E40,
      #$6E41, #$6E42, #$6E45, #$6E46, #$6E47, #$6E48, #$6E49, #$6E4A,
      #$6E4B, #$6E4C, #$6E4F, #$6E50, #$6E51, #$6E52, #$6E55, #$6E57,
      #$6E59, #$6E5A, #$6E5C, #$6E5D, #$6E5E, #$6E60, #$6E61, #$6E62,
      #$6E63, #$6E64, #$6E65, #$6E66, #$6E67, #$6E68, #$6E69, #$6E6A,
      #$6E6C, #$6E6D, #$6E6F, #$6E70, #$6E71, #$6E72, #$6E73, #$6E74,
      #$6E75, #$6E76, #$6E77, #$6E78, #$6E79, #$6E7A, #$6E7B, #$6E7C,
      #$6E7D, #$6E80, #$6E81, #$6E82, #$6E84, #$6E87, #$6E88, #$6E8A,
      #$6E8B, #$6E8C, #$6E8D, #$6E8E, #$6E91, #$6E92, #$6E93, #$6E94,
      #$6E95, #$6E96, #$6E97, #$6E99, #$6E9A, #$6E9B, #$6E9D, #$6E9E,
      #$6EA0, #$6EA1, #$6EA3, #$6EA4, #$6EA6, #$6EA8, #$6EA9, #$6EAB,
      #$6EAC, #$6EAD, #$6EAE, #$6EB0, #$6EB3, #$6EB5, #$6EB8, #$6EB9,
      #$6EBC, #$6EBE, #$6EBF, #$6EC0, #$6EC3, #$6EC4, #$6EC5, #$6EC6,
      #$6EC8, #$6EC9, #$6ECA, #$6ECC, #$6ECD, #$6ECE, #$6ED0, #$6ED2,
      #$6ED6, #$6ED8, #$6ED9, #$6EDB, #$6EDC, #$6EDD, #$6EE3, #$6EE7,
      #$6EEA, #$6EEB, #$6EEC, #$6EED, #$6EEE, #$6EEF,
      #$6EF0, #$6EF1, #$6EF2, #$6EF3, #$6EF5, #$6EF6, #$6EF7, #$6EF8,
      #$6EFA, #$6EFB, #$6EFC, #$6EFD, #$6EFE, #$6EFF, #$6F00, #$6F01,
      #$6F03, #$6F04, #$6F05, #$6F07, #$6F08, #$6F0A, #$6F0B, #$6F0C,
      #$6F0D, #$6F0E, #$6F10, #$6F11, #$6F12, #$6F16, #$6F17, #$6F18,
      #$6F19, #$6F1A, #$6F1B, #$6F1C, #$6F1D, #$6F1E, #$6F1F, #$6F21,
      #$6F22, #$6F23, #$6F25, #$6F26, #$6F27, #$6F28, #$6F2C, #$6F2E,
      #$6F30, #$6F32, #$6F34, #$6F35, #$6F37, #$6F38, #$6F39, #$6F3A,
      #$6F3B, #$6F3C, #$6F3D, #$6F3F, #$6F40, #$6F41, #$6F42, #$6F43,
      #$6F44, #$6F45, #$6F48, #$6F49, #$6F4A, #$6F4C, #$6F4E, #$6F4F,
      #$6F50, #$6F51, #$6F52, #$6F53, #$6F54, #$6F55, #$6F56, #$6F57,
      #$6F59, #$6F5A, #$6F5B, #$6F5D, #$6F5F, #$6F60, #$6F61, #$6F63,
      #$6F64, #$6F65, #$6F67, #$6F68, #$6F69, #$6F6A, #$6F6B, #$6F6C,
      #$6F6F, #$6F70, #$6F71, #$6F73, #$6F75, #$6F76, #$6F77, #$6F79,
      #$6F7B, #$6F7D, #$6F7E, #$6F7F, #$6F80, #$6F81, #$6F82, #$6F83,
      #$6F85, #$6F86, #$6F87, #$6F8A, #$6F8B, #$6F8F, #$6F90, #$6F91,
      #$6F92, #$6F93, #$6F94, #$6F95, #$6F96, #$6F97, #$6F98, #$6F99,
      #$6F9A, #$6F9B, #$6F9D, #$6F9E, #$6F9F, #$6FA0, #$6FA2, #$6FA3,
      #$6FA4, #$6FA5, #$6FA6, #$6FA8, #$6FA9, #$6FAA, #$6FAB, #$6FAC,
      #$6FAD, #$6FAE, #$6FAF, #$6FB0, #$6FB1, #$6FB2, #$6FB4, #$6FB5,
      #$6FB7, #$6FB8, #$6FBA, #$6FBB, #$6FBC, #$6FBD, #$6FBE, #$6FBF,
      #$6FC1, #$6FC3, #$6FC4, #$6FC5, #$6FC6, #$6FC7, #$6FC8, #$6FCA,
      #$6FCB, #$6FCC, #$6FCD, #$6FCE, #$6FCF, #$6FD0, #$6FD3, #$6FD4,
      #$6FD5, #$6FD6, #$6FD7, #$6FD8, #$6FD9, #$6FDA, #$6FDB, #$6FDC,
      #$6FDD, #$6FDF, #$6FE2, #$6FE3, #$6FE4, #$6FE5,
      #$6FE6, #$6FE7, #$6FE8, #$6FE9, #$6FEA, #$6FEB, #$6FEC, #$6FED,
      #$6FF0, #$6FF1, #$6FF2, #$6FF3, #$6FF4, #$6FF5, #$6FF6, #$6FF7,
      #$6FF8, #$6FF9, #$6FFA, #$6FFB, #$6FFC, #$6FFD, #$6FFE, #$6FFF,
      #$7000, #$7001, #$7002, #$7003, #$7004, #$7005, #$7006, #$7007,
      #$7008, #$7009, #$700A, #$700B, #$700C, #$700D, #$700E, #$700F,
      #$7010, #$7012, #$7013, #$7014, #$7015, #$7016, #$7017, #$7018,
      #$7019, #$701C, #$701D, #$701E, #$701F, #$7020, #$7021, #$7022,
      #$7024, #$7025, #$7026, #$7027, #$7028, #$7029, #$702A, #$702B,
      #$702C, #$702D, #$702E, #$702F, #$7030, #$7031, #$7032, #$7033,
      #$7034, #$7036, #$7037, #$7038, #$703A, #$703B, #$703C, #$703D,
      #$703E, #$703F, #$7040, #$7041, #$7042, #$7043, #$7044, #$7045,
      #$7046, #$7047, #$7048, #$7049, #$704A, #$704B, #$704D, #$704E,
      #$7050, #$7051, #$7052, #$7053, #$7054, #$7055, #$7056, #$7057,
      #$7058, #$7059, #$705A, #$705B, #$705C, #$705D, #$705F, #$7060,
      #$7061, #$7062, #$7063, #$7064, #$7065, #$7066, #$7067, #$7068,
      #$7069, #$706A, #$706E, #$7071, #$7072, #$7073, #$7074, #$7077,
      #$7079, #$707A, #$707B, #$707D, #$7081, #$7082, #$7083, #$7084,
      #$7086, #$7087, #$7088, #$708B, #$708C, #$708D, #$708F, #$7090,
      #$7091, #$7093, #$7097, #$7098, #$709A, #$709B, #$709E, #$709F,
      #$70A0, #$70A1, #$70A2, #$70A3, #$70A4, #$70A5, #$70A6, #$70A7,
      #$70A8, #$70A9, #$70AA, #$70B0, #$70B2, #$70B4, #$70B5, #$70B6,
      #$70BA, #$70BE, #$70BF, #$70C4, #$70C5, #$70C6, #$70C7, #$70C9,
      #$70CB, #$70CC, #$70CD, #$70CE, #$70CF, #$70D0, #$70D1, #$70D2,
      #$70D3, #$70D4, #$70D5, #$70D6, #$70D7, #$70DA,
      #$70DC, #$70DD, #$70DE, #$70E0, #$70E1, #$70E2, #$70E3, #$70E5,
      #$70EA, #$70EE, #$70F0, #$70F1, #$70F2, #$70F3, #$70F4, #$70F5,
      #$70F6, #$70F8, #$70FA, #$70FB, #$70FC, #$70FE, #$70FF, #$7100,
      #$7101, #$7102, #$7103, #$7104, #$7105, #$7106, #$7107, #$7108,
      #$710B, #$710C, #$710D, #$710E, #$710F, #$7111, #$7112, #$7114,
      #$7117, #$711B, #$711C, #$711D, #$711E, #$711F, #$7120, #$7121,
      #$7122, #$7123, #$7124, #$7125, #$7127, #$7128, #$7129, #$712A,
      #$712B, #$712C, #$712D, #$712E, #$7132, #$7133, #$7134, #$7135,
      #$7137, #$7138, #$7139, #$713A, #$713B, #$713C, #$713D, #$713E,
      #$713F, #$7140, #$7141, #$7142, #$7143, #$7144, #$7146, #$7147,
      #$7148, #$7149, #$714B, #$714D, #$714F, #$7150, #$7151, #$7152,
      #$7153, #$7154, #$7155, #$7156, #$7157, #$7158, #$7159, #$715A,
      #$715B, #$715D, #$715F, #$7160, #$7161, #$7162, #$7163, #$7165,
      #$7169, #$716A, #$716B, #$716C, #$716D, #$716F, #$7170, #$7171,
      #$7174, #$7175, #$7176, #$7177, #$7179, #$717B, #$717C, #$717E,
      #$717F, #$7180, #$7181, #$7182, #$7183, #$7185, #$7186, #$7187,
      #$7188, #$7189, #$718B, #$718C, #$718D, #$718E, #$7190, #$7191,
      #$7192, #$7193, #$7195, #$7196, #$7197, #$719A, #$719B, #$719C,
      #$719D, #$719E, #$71A1, #$71A2, #$71A3, #$71A4, #$71A5, #$71A6,
      #$71A7, #$71A9, #$71AA, #$71AB, #$71AD, #$71AE, #$71AF, #$71B0,
      #$71B1, #$71B2, #$71B4, #$71B6, #$71B7, #$71B8, #$71BA, #$71BB,
      #$71BC, #$71BD, #$71BE, #$71BF, #$71C0, #$71C1, #$71C2, #$71C4,
      #$71C5, #$71C6, #$71C7, #$71C8, #$71C9, #$71CA, #$71CB, #$71CC,
      #$71CD, #$71CF, #$71D0, #$71D1, #$71D2, #$71D3,
      #$71D6, #$71D7, #$71D8, #$71D9, #$71DA, #$71DB, #$71DC, #$71DD,
      #$71DE, #$71DF, #$71E1, #$71E2, #$71E3, #$71E4, #$71E6, #$71E8,
      #$71E9, #$71EA, #$71EB, #$71EC, #$71ED, #$71EF, #$71F0, #$71F1,
      #$71F2, #$71F3, #$71F4, #$71F5, #$71F6, #$71F7, #$71F8, #$71FA,
      #$71FB, #$71FC, #$71FD, #$71FE, #$71FF, #$7200, #$7201, #$7202,
      #$7203, #$7204, #$7205, #$7207, #$7208, #$7209, #$720A, #$720B,
      #$720C, #$720D, #$720E, #$720F, #$7210, #$7211, #$7212, #$7213,
      #$7214, #$7215, #$7216, #$7217, #$7218, #$7219, #$721A, #$721B,
      #$721C, #$721E, #$721F, #$7220, #$7221, #$7222, #$7223, #$7224,
      #$7225, #$7226, #$7227, #$7229, #$722B, #$722D, #$722E, #$722F,
      #$7232, #$7233, #$7234, #$723A, #$723C, #$723E, #$7240, #$7241,
      #$7242, #$7243, #$7244, #$7245, #$7246, #$7249, #$724A, #$724B,
      #$724E, #$724F, #$7250, #$7251, #$7253, #$7254, #$7255, #$7257,
      #$7258, #$725A, #$725C, #$725E, #$7260, #$7263, #$7264, #$7265,
      #$7268, #$726A, #$726B, #$726C, #$726D, #$7270, #$7271, #$7273,
      #$7274, #$7276, #$7277, #$7278, #$727B, #$727C, #$727D, #$7282,
      #$7283, #$7285, #$7286, #$7287, #$7288, #$7289, #$728C, #$728E,
      #$7290, #$7291, #$7293, #$7294, #$7295, #$7296, #$7297, #$7298,
      #$7299, #$729A, #$729B, #$729C, #$729D, #$729E, #$72A0, #$72A1,
      #$72A2, #$72A3, #$72A4, #$72A5, #$72A6, #$72A7, #$72A8, #$72A9,
      #$72AA, #$72AB, #$72AE, #$72B1, #$72B2, #$72B3, #$72B5, #$72BA,
      #$72BB, #$72BC, #$72BD, #$72BE, #$72BF, #$72C0, #$72C5, #$72C6,
      #$72C7, #$72C9, #$72CA, #$72CB, #$72CC, #$72CF, #$72D1, #$72D3,
      #$72D4, #$72D5, #$72D6, #$72D8, #$72DA, #$72DB);
  GBKE_2Map: array[0..8271] of TBuffChar = (
      #$02CA, #$02CB, #$02D9, #$2013, #$2015, #$2025, #$2035, #$2105,
      #$2109, #$2196, #$2197, #$2198, #$2199, #$2215, #$221F, #$2223,
      #$2252, #$2266, #$2267, #$22BF, #$2550, #$2551, #$2552, #$2553,
      #$2554, #$2555, #$2556, #$2557, #$2558, #$2559, #$255A, #$255B,
      #$255C, #$255D, #$255E, #$255F, #$2560, #$2561, #$2562, #$2563,
      #$2564, #$2565, #$2566, #$2567, #$2568, #$2569, #$256A, #$256B,
      #$256C, #$256D, #$256E, #$256F, #$2570, #$2571, #$2572, #$2573,
      #$2581, #$2582, #$2583, #$2584, #$2585, #$2586, #$2587, #$2588,
      #$2589, #$258A, #$258B, #$258C, #$258D, #$258E, #$258F, #$2593,
      #$2594, #$2595, #$25BC, #$25BD, #$25E2, #$25E3, #$25E4, #$25E5,
      #$2609, #$2295, #$3012, #$301D, #$301E, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$3021, #$3022, #$3023, #$3024, #$3025, #$3026, #$3027, #$3028,
      #$3029, #$32A3, #$338E, #$338F, #$339C, #$339D, #$339E, #$33A1,
      #$33C4, #$33CE, #$33D1, #$33D2, #$33D5, #$FE30, #$FFE2, #$FFE4,
      #$FFFD, #$2121, #$3231, #$FFFD, #$2010, #$FFFD, #$FFFD, #$FFFD,
      #$30FC, #$309B, #$309C, #$30FD, #$30FE, #$3006, #$309D, #$309E,
      #$FE49, #$FE4A, #$FE4B, #$FE4C, #$FE4D, #$FE4E, #$FE4F, #$FE50,
      #$FE51, #$FE52, #$FE54, #$FE55, #$FE56, #$FE57, #$FE59, #$FE5A,
      #$FE5B, #$FE5C, #$FE5D, #$FE5E, #$FE5F, #$FE60, #$FE61, #$FE62,
      #$FE63, #$FE64, #$FE65, #$FE66, #$FE68, #$FE69, #$FE6A, #$FE6B,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$3007, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$72DC, #$72DD, #$72DF, #$72E2, #$72E3, #$72E4, #$72E5, #$72E6,
      #$72E7, #$72EA, #$72EB, #$72F5, #$72F6, #$72F9, #$72FD, #$72FE,
      #$72FF, #$7300, #$7302, #$7304, #$7305, #$7306, #$7307, #$7308,
      #$7309, #$730B, #$730C, #$730D, #$730F, #$7310, #$7311, #$7312,
      #$7314, #$7318, #$7319, #$731A, #$731F, #$7320, #$7323, #$7324,
      #$7326, #$7327, #$7328, #$732D, #$732F, #$7330, #$7332, #$7333,
      #$7335, #$7336, #$733A, #$733B, #$733C, #$733D, #$7340, #$7341,
      #$7342, #$7343, #$7344, #$7345, #$7346, #$7347, #$7348, #$7349,
      #$734A, #$734B, #$734C, #$734E, #$734F, #$7351, #$7353, #$7354,
      #$7355, #$7356, #$7358, #$7359, #$735A, #$735B, #$735C, #$735D,
      #$735E, #$735F, #$7361, #$7362, #$7363, #$7364, #$7365, #$7366,
      #$7367, #$7368, #$7369, #$736A, #$736B, #$736E, #$7370, #$7371,
      #$7372, #$7373, #$7374, #$7375, #$7376, #$7377, #$7378, #$7379,
      #$737A, #$737B, #$737C, #$737D, #$737F, #$7380, #$7381, #$7382,
      #$7383, #$7385, #$7386, #$7388, #$738A, #$738C, #$738D, #$738F,
      #$7390, #$7392, #$7393, #$7394, #$7395, #$7397, #$7398, #$7399,
      #$739A, #$739C, #$739D, #$739E, #$73A0, #$73A1, #$73A3, #$73A4,
      #$73A5, #$73A6, #$73A7, #$73A8, #$73AA, #$73AC, #$73AD, #$73B1,
      #$73B4, #$73B5, #$73B6, #$73B8, #$73B9, #$73BC, #$73BD, #$73BE,
      #$73BF, #$73C1, #$73C3, #$73C4, #$73C5, #$73C6, #$73C7, #$73CB,
      #$73CC, #$73CE, #$73D2, #$73D3, #$73D4, #$73D5, #$73D6, #$73D7,
      #$73D8, #$73DA, #$73DB, #$73DC, #$73DD, #$73DF, #$73E1, #$73E2,
      #$73E3, #$73E4, #$73E6, #$73E8, #$73EA, #$73EB, #$73EC, #$73EE,
      #$73EF, #$73F0, #$73F1, #$73F3, #$73F4, #$73F5, #$73F6, #$73F7,
      #$73F8, #$73F9, #$73FA, #$73FB, #$73FC, #$73FD, #$73FE, #$73FF,
      #$7400, #$7401, #$7402, #$7404, #$7407, #$7408, #$740B, #$740C,
      #$740D, #$740E, #$7411, #$7412, #$7413, #$7414, #$7415, #$7416,
      #$7417, #$7418, #$7419, #$741C, #$741D, #$741E, #$741F, #$7420,
      #$7421, #$7423, #$7424, #$7427, #$7429, #$742B, #$742D, #$742F,
      #$7431, #$7432, #$7437, #$7438, #$7439, #$743A, #$743B, #$743D,
      #$743E, #$743F, #$7440, #$7442, #$7443, #$7444, #$7445, #$7446,
      #$7447, #$7448, #$7449, #$744A, #$744B, #$744C, #$744D, #$744E,
      #$744F, #$7450, #$7451, #$7452, #$7453, #$7454, #$7456, #$7458,
      #$745D, #$7460, #$7461, #$7462, #$7463, #$7464, #$7465, #$7466,
      #$7467, #$7468, #$7469, #$746A, #$746B, #$746C, #$746E, #$746F,
      #$7471, #$7472, #$7473, #$7474, #$7475, #$7478, #$7479, #$747A,
      #$747B, #$747C, #$747D, #$747F, #$7482, #$7484, #$7485, #$7486,
      #$7488, #$7489, #$748A, #$748C, #$748D, #$748F, #$7491, #$7492,
      #$7493, #$7494, #$7495, #$7496, #$7497, #$7498, #$7499, #$749A,
      #$749B, #$749D, #$749F, #$74A0, #$74A1, #$74A2, #$74A3, #$74A4,
      #$74A5, #$74A6, #$74AA, #$74AB, #$74AC, #$74AD, #$74AE, #$74AF,
      #$74B0, #$74B1, #$74B2, #$74B3, #$74B4, #$74B5, #$74B6, #$74B7,
      #$74B8, #$74B9, #$74BB, #$74BC, #$74BD, #$74BE, #$74BF, #$74C0,
      #$74C1, #$74C2, #$74C3, #$74C4, #$74C5, #$74C6, #$74C7, #$74C8,
      #$74C9, #$74CA, #$74CB, #$74CC, #$74CD, #$74CE, #$74CF, #$74D0,
      #$74D1, #$74D3, #$74D4, #$74D5, #$74D6, #$74D7, #$74D8, #$74D9,
      #$74DA, #$74DB, #$74DD, #$74DF, #$74E1, #$74E5, #$74E7, #$74E8,
      #$74E9, #$74EA, #$74EB, #$74EC, #$74ED, #$74F0, #$74F1, #$74F2,
      #$74F3, #$74F5, #$74F8, #$74F9, #$74FA, #$74FB, #$74FC, #$74FD,
      #$74FE, #$7500, #$7501, #$7502, #$7503, #$7505, #$7506, #$7507,
      #$7508, #$7509, #$750A, #$750B, #$750C, #$750E, #$7510, #$7512,
      #$7514, #$7515, #$7516, #$7517, #$751B, #$751D, #$751E, #$7520,
      #$7521, #$7522, #$7523, #$7524, #$7526, #$7527, #$752A, #$752E,
      #$7534, #$7536, #$7539, #$753C, #$753D, #$753F, #$7541, #$7542,
      #$7543, #$7544, #$7546, #$7547, #$7549, #$754A, #$754D, #$7550,
      #$7551, #$7552, #$7553, #$7555, #$7556, #$7557, #$7558, #$755D,
      #$755E, #$755F, #$7560, #$7561, #$7562, #$7563, #$7564, #$7567,
      #$7568, #$7569, #$756B, #$756C, #$756D, #$756E, #$756F, #$7570,
      #$7571, #$7573, #$7575, #$7576, #$7577, #$757A, #$757B, #$757C,
      #$757D, #$757E, #$7580, #$7581, #$7582, #$7584, #$7585, #$7587,
      #$7588, #$7589, #$758A, #$758C, #$758D, #$758E, #$7590, #$7593,
      #$7595, #$7598, #$759B, #$759C, #$759E, #$75A2, #$75A6, #$75A7,
      #$75A8, #$75A9, #$75AA, #$75AD, #$75B6, #$75B7, #$75BA, #$75BB,
      #$75BF, #$75C0, #$75C1, #$75C6, #$75CB, #$75CC, #$75CE, #$75CF,
      #$75D0, #$75D1, #$75D3, #$75D7, #$75D9, #$75DA, #$75DC, #$75DD,
      #$75DF, #$75E0, #$75E1, #$75E5, #$75E9, #$75EC, #$75ED, #$75EE,
      #$75EF, #$75F2, #$75F3, #$75F5, #$75F6, #$75F7, #$75F8, #$75FA,
      #$75FB, #$75FD, #$75FE, #$7602, #$7604, #$7606, #$7607, #$7608,
      #$7609, #$760B, #$760D, #$760E, #$760F, #$7611, #$7612, #$7613,
      #$7614, #$7616, #$761A, #$761C, #$761D, #$761E, #$7621, #$7623,
      #$7627, #$7628, #$762C, #$762E, #$762F, #$7631, #$7632, #$7636,
      #$7637, #$7639, #$763A, #$763B, #$763D, #$7641, #$7642, #$7644,
      #$7645, #$7646, #$7647, #$7648, #$7649, #$764A, #$764B, #$764E,
      #$764F, #$7650, #$7651, #$7652, #$7653, #$7655, #$7657, #$7658,
      #$7659, #$765A, #$765B, #$765D, #$765F, #$7660, #$7661, #$7662,
      #$7664, #$7665, #$7666, #$7667, #$7668, #$7669, #$766A, #$766C,
      #$766D, #$766E, #$7670, #$7671, #$7672, #$7673, #$7674, #$7675,
      #$7676, #$7677, #$7679, #$767A, #$767C, #$767F, #$7680, #$7681,
      #$7683, #$7685, #$7689, #$768A, #$768C, #$768D, #$768F, #$7690,
      #$7692, #$7694, #$7695, #$7697, #$7698, #$769A, #$769B, #$769C,
      #$769D, #$769E, #$769F, #$76A0, #$76A1, #$76A2, #$76A3, #$76A5,
      #$76A6, #$76A7, #$76A8, #$76A9, #$76AA, #$76AB, #$76AC, #$76AD,
      #$76AF, #$76B0, #$76B3, #$76B5, #$76B6, #$76B7, #$76B8, #$76B9,
      #$76BA, #$76BB, #$76BC, #$76BD, #$76BE, #$76C0, #$76C1, #$76C3,
      #$76C4, #$76C7, #$76C9, #$76CB, #$76CC, #$76D3, #$76D5, #$76D9,
      #$76DA, #$76DC, #$76DD, #$76DE, #$76E0, #$76E1, #$76E2, #$76E3,
      #$76E4, #$76E6, #$76E7, #$76E8, #$76E9, #$76EA, #$76EB, #$76EC,
      #$76ED, #$76F0, #$76F3, #$76F5, #$76F6, #$76F7, #$76FA, #$76FB,
      #$76FD, #$76FF, #$7700, #$7702, #$7703, #$7705, #$7706, #$770A,
      #$770C, #$770E, #$770F, #$7710, #$7711, #$7712, #$7713, #$7714,
      #$7715, #$7716, #$7717, #$7718, #$771B, #$771C, #$771D, #$771E,
      #$7721, #$7723, #$7724, #$7725, #$7727, #$772A, #$772B, #$772C,
      #$772E, #$7730, #$7731, #$7732, #$7733, #$7734, #$7739, #$773B,
      #$773D, #$773E, #$773F, #$7742, #$7744, #$7745, #$7746, #$7748,
      #$7749, #$774A, #$774B, #$774C, #$774D, #$774E, #$774F, #$7752,
      #$7753, #$7754, #$7755, #$7756, #$7757, #$7758, #$7759, #$775C,
      #$775D, #$775E, #$775F, #$7760, #$7764, #$7767, #$7769, #$776A,
      #$776D, #$776E, #$776F, #$7770, #$7771, #$7772, #$7773, #$7774,
      #$7775, #$7776, #$7777, #$7778, #$777A, #$777B, #$777C, #$7781,
      #$7782, #$7783, #$7786, #$7787, #$7788, #$7789, #$778A, #$778B,
      #$778F, #$7790, #$7793, #$7794, #$7795, #$7796, #$7797, #$7798,
      #$7799, #$779A, #$779B, #$779C, #$779D, #$779E, #$77A1, #$77A3,
      #$77A4, #$77A6, #$77A8, #$77AB, #$77AD, #$77AE, #$77AF, #$77B1,
      #$77B2, #$77B4, #$77B6, #$77B7, #$77B8, #$77B9, #$77BA, #$77BC,
      #$77BE, #$77C0, #$77C1, #$77C2, #$77C3, #$77C4, #$77C5, #$77C6,
      #$77C7, #$77C8, #$77C9, #$77CA, #$77CB, #$77CC, #$77CE, #$77CF,
      #$77D0, #$77D1, #$77D2, #$77D3, #$77D4, #$77D5, #$77D6, #$77D8,
      #$77D9, #$77DA, #$77DD, #$77DE, #$77DF, #$77E0, #$77E1, #$77E4,
      #$77E6, #$77E8, #$77EA, #$77EF, #$77F0, #$77F1, #$77F2, #$77F4,
      #$77F5, #$77F7, #$77F9, #$77FA, #$77FB, #$77FC, #$7803, #$7804,
      #$7805, #$7806, #$7807, #$7808, #$780A, #$780B, #$780E, #$780F,
      #$7810, #$7813, #$7815, #$7819, #$781B, #$781E, #$7820, #$7821,
      #$7822, #$7824, #$7828, #$782A, #$782B, #$782E, #$782F, #$7831,
      #$7832, #$7833, #$7835, #$7836, #$783D, #$783F, #$7841, #$7842,
      #$7843, #$7844, #$7846, #$7848, #$7849, #$784A, #$784B, #$784D,
      #$784F, #$7851, #$7853, #$7854, #$7858, #$7859, #$785A, #$785B,
      #$785C, #$785E, #$785F, #$7860, #$7861, #$7862, #$7863, #$7864,
      #$7865, #$7866, #$7867, #$7868, #$7869, #$786F, #$7870, #$7871,
      #$7872, #$7873, #$7874, #$7875, #$7876, #$7878, #$7879, #$787A,
      #$787B, #$787D, #$787E, #$787F, #$7880, #$7881, #$7882, #$7883,
      #$7884, #$7885, #$7886, #$7888, #$788A, #$788B, #$788F, #$7890,
      #$7892, #$7894, #$7895, #$7896, #$7899, #$789D, #$789E, #$78A0,
      #$78A2, #$78A4, #$78A6, #$78A8, #$78A9, #$78AA, #$78AB, #$78AC,
      #$78AD, #$78AE, #$78AF, #$78B5, #$78B6, #$78B7, #$78B8, #$78BA,
      #$78BB, #$78BC, #$78BD, #$78BF, #$78C0, #$78C2, #$78C3, #$78C4,
      #$78C6, #$78C7, #$78C8, #$78CC, #$78CD, #$78CE, #$78CF, #$78D1,
      #$78D2, #$78D3, #$78D6, #$78D7, #$78D8, #$78DA, #$78DB, #$78DC,
      #$78DD, #$78DE, #$78DF, #$78E0, #$78E1, #$78E2, #$78E3, #$78E4,
      #$78E5, #$78E6, #$78E7, #$78E9, #$78EA, #$78EB, #$78ED, #$78EE,
      #$78EF, #$78F0, #$78F1, #$78F3, #$78F5, #$78F6, #$78F8, #$78F9,
      #$78FB, #$78FC, #$78FD, #$78FE, #$78FF, #$7900, #$7902, #$7903,
      #$7904, #$7906, #$7907, #$7908, #$7909, #$790A, #$790B, #$790C,
      #$790D, #$790E, #$790F, #$7910, #$7911, #$7912, #$7914, #$7915,
      #$7916, #$7917, #$7918, #$7919, #$791A, #$791B, #$791C, #$791D,
      #$791F, #$7920, #$7921, #$7922, #$7923, #$7925, #$7926, #$7927,
      #$7928, #$7929, #$792A, #$792B, #$792C, #$792D, #$792E, #$792F,
      #$7930, #$7931, #$7932, #$7933, #$7935, #$7936, #$7937, #$7938,
      #$7939, #$793D, #$793F, #$7942, #$7943, #$7944, #$7945, #$7947,
      #$794A, #$794B, #$794C, #$794D, #$794E, #$794F, #$7950, #$7951,
      #$7952, #$7954, #$7955, #$7958, #$7959, #$7961, #$7963, #$7964,
      #$7966, #$7969, #$796A, #$796B, #$796C, #$796E, #$7970, #$7971,
      #$7972, #$7973, #$7974, #$7975, #$7976, #$7979, #$797B, #$797C,
      #$797D, #$797E, #$797F, #$7982, #$7983, #$7986, #$7987, #$7988,
      #$7989, #$798B, #$798C, #$798D, #$798E, #$7990, #$7991, #$7992,
      #$7993, #$7994, #$7995, #$7996, #$7997, #$7998, #$7999, #$799B,
      #$799C, #$799D, #$799E, #$799F, #$79A0, #$79A1, #$79A2, #$79A3,
      #$79A4, #$79A5, #$79A6, #$79A8, #$79A9, #$79AA, #$79AB, #$79AC,
      #$79AD, #$79AE, #$79AF, #$79B0, #$79B1, #$79B2, #$79B4, #$79B5,
      #$79B6, #$79B7, #$79B8, #$79BC, #$79BF, #$79C2, #$79C4, #$79C5,
      #$79C7, #$79C8, #$79CA, #$79CC, #$79CE, #$79CF, #$79D0, #$79D3,
      #$79D4, #$79D6, #$79D7, #$79D9, #$79DA, #$79DB, #$79DC, #$79DD,
      #$79DE, #$79E0, #$79E1, #$79E2, #$79E5, #$79E8, #$79EA, #$79EC,
      #$79EE, #$79F1, #$79F2, #$79F3, #$79F4, #$79F5, #$79F6, #$79F7,
      #$79F9, #$79FA, #$79FC, #$79FE, #$79FF, #$7A01, #$7A04, #$7A05,
      #$7A07, #$7A08, #$7A09, #$7A0A, #$7A0C, #$7A0F, #$7A10, #$7A11,
      #$7A12, #$7A13, #$7A15, #$7A16, #$7A18, #$7A19, #$7A1B, #$7A1C,
      #$7A1D, #$7A1F, #$7A21, #$7A22, #$7A24, #$7A25, #$7A26, #$7A27,
      #$7A28, #$7A29, #$7A2A, #$7A2B, #$7A2C, #$7A2D, #$7A2E, #$7A2F,
      #$7A30, #$7A31, #$7A32, #$7A34, #$7A35, #$7A36, #$7A38, #$7A3A,
      #$7A3E, #$7A40, #$7A41, #$7A42, #$7A43, #$7A44, #$7A45, #$7A47,
      #$7A48, #$7A49, #$7A4A, #$7A4B, #$7A4C, #$7A4D, #$7A4E, #$7A4F,
      #$7A50, #$7A52, #$7A53, #$7A54, #$7A55, #$7A56, #$7A58, #$7A59,
      #$7A5A, #$7A5B, #$7A5C, #$7A5D, #$7A5E, #$7A5F, #$7A60, #$7A61,
      #$7A62, #$7A63, #$7A64, #$7A65, #$7A66, #$7A67, #$7A68, #$7A69,
      #$7A6A, #$7A6B, #$7A6C, #$7A6D, #$7A6E, #$7A6F, #$7A71, #$7A72,
      #$7A73, #$7A75, #$7A7B, #$7A7C, #$7A7D, #$7A7E, #$7A82, #$7A85,
      #$7A87, #$7A89, #$7A8A, #$7A8B, #$7A8C, #$7A8E, #$7A8F, #$7A90,
      #$7A93, #$7A94, #$7A99, #$7A9A, #$7A9B, #$7A9E, #$7AA1, #$7AA2,
      #$7AA3, #$7AA4, #$7AA7, #$7AA9, #$7AAA, #$7AAB, #$7AAE, #$7AAF,
      #$7AB0, #$7AB1, #$7AB2, #$7AB4, #$7AB5, #$7AB6, #$7AB7, #$7AB8,
      #$7AB9, #$7ABA, #$7ABB, #$7ABC, #$7ABD, #$7ABE, #$7AC0, #$7AC1,
      #$7AC2, #$7AC3, #$7AC4, #$7AC5, #$7AC6, #$7AC7, #$7AC8, #$7AC9,
      #$7ACA, #$7ACC, #$7ACD, #$7ACE, #$7ACF, #$7AD0, #$7AD1, #$7AD2,
      #$7AD3, #$7AD4, #$7AD5, #$7AD7, #$7AD8, #$7ADA, #$7ADB, #$7ADC,
      #$7ADD, #$7AE1, #$7AE2, #$7AE4, #$7AE7, #$7AE8, #$7AE9, #$7AEA,
      #$7AEB, #$7AEC, #$7AEE, #$7AF0, #$7AF1, #$7AF2, #$7AF3, #$7AF4,
      #$7AF5, #$7AF6, #$7AF7, #$7AF8, #$7AFB, #$7AFC, #$7AFE, #$7B00,
      #$7B01, #$7B02, #$7B05, #$7B07, #$7B09, #$7B0C, #$7B0D, #$7B0E,
      #$7B10, #$7B12, #$7B13, #$7B16, #$7B17, #$7B18, #$7B1A, #$7B1C,
      #$7B1D, #$7B1F, #$7B21, #$7B22, #$7B23, #$7B27, #$7B29, #$7B2D,
      #$7B2F, #$7B30, #$7B32, #$7B34, #$7B35, #$7B36, #$7B37, #$7B39,
      #$7B3B, #$7B3D, #$7B3F, #$7B40, #$7B41, #$7B42, #$7B43, #$7B44,
      #$7B46, #$7B48, #$7B4A, #$7B4D, #$7B4E, #$7B53, #$7B55, #$7B57,
      #$7B59, #$7B5C, #$7B5E, #$7B5F, #$7B61, #$7B63, #$7B64, #$7B65,
      #$7B66, #$7B67, #$7B68, #$7B69, #$7B6A, #$7B6B, #$7B6C, #$7B6D,
      #$7B6F, #$7B70, #$7B73, #$7B74, #$7B76, #$7B78, #$7B7A, #$7B7C,
      #$7B7D, #$7B7F, #$7B81, #$7B82, #$7B83, #$7B84, #$7B86, #$7B87,
      #$7B88, #$7B89, #$7B8A, #$7B8B, #$7B8C, #$7B8E, #$7B8F, #$7B91,
      #$7B92, #$7B93, #$7B96, #$7B98, #$7B99, #$7B9A, #$7B9B, #$7B9E,
      #$7B9F, #$7BA0, #$7BA3, #$7BA4, #$7BA5, #$7BAE, #$7BAF, #$7BB0,
      #$7BB2, #$7BB3, #$7BB5, #$7BB6, #$7BB7, #$7BB9, #$7BBA, #$7BBB,
      #$7BBC, #$7BBD, #$7BBE, #$7BBF, #$7BC0, #$7BC2, #$7BC3, #$7BC4,
      #$7BC5, #$7BC8, #$7BC9, #$7BCA, #$7BCB, #$7BCD, #$7BCE, #$7BCF,
      #$7BD0, #$7BD2, #$7BD4, #$7BD5, #$7BD6, #$7BD7, #$7BD8, #$7BDB,
      #$7BDC, #$7BDE, #$7BDF, #$7BE0, #$7BE2, #$7BE3, #$7BE4, #$7BE7,
      #$7BE8, #$7BE9, #$7BEB, #$7BEC, #$7BED, #$7BEF, #$7BF0, #$7BF2,
      #$7BF3, #$7BF4, #$7BF5, #$7BF6, #$7BF8, #$7BF9, #$7BFA, #$7BFB,
      #$7BFD, #$7BFF, #$7C00, #$7C01, #$7C02, #$7C03, #$7C04, #$7C05,
      #$7C06, #$7C08, #$7C09, #$7C0A, #$7C0D, #$7C0E, #$7C10, #$7C11,
      #$7C12, #$7C13, #$7C14, #$7C15, #$7C17, #$7C18, #$7C19, #$7C1A,
      #$7C1B, #$7C1C, #$7C1D, #$7C1E, #$7C20, #$7C21, #$7C22, #$7C23,
      #$7C24, #$7C25, #$7C28, #$7C29, #$7C2B, #$7C2C, #$7C2D, #$7C2E,
      #$7C2F, #$7C30, #$7C31, #$7C32, #$7C33, #$7C34, #$7C35, #$7C36,
      #$7C37, #$7C39, #$7C3A, #$7C3B, #$7C3C, #$7C3D, #$7C3E, #$7C42,
      #$7C43, #$7C44, #$7C45, #$7C46, #$7C47, #$7C48, #$7C49, #$7C4A,
      #$7C4B, #$7C4C, #$7C4E, #$7C4F, #$7C50, #$7C51, #$7C52, #$7C53,
      #$7C54, #$7C55, #$7C56, #$7C57, #$7C58, #$7C59, #$7C5A, #$7C5B,
      #$7C5C, #$7C5D, #$7C5E, #$7C5F, #$7C60, #$7C61, #$7C62, #$7C63,
      #$7C64, #$7C65, #$7C66, #$7C67, #$7C68, #$7C69, #$7C6A, #$7C6B,
      #$7C6C, #$7C6D, #$7C6E, #$7C6F, #$7C70, #$7C71, #$7C72, #$7C75,
      #$7C76, #$7C77, #$7C78, #$7C79, #$7C7A, #$7C7E, #$7C7F, #$7C80,
      #$7C81, #$7C82, #$7C83, #$7C84, #$7C85, #$7C86, #$7C87, #$7C88,
      #$7C8A, #$7C8B, #$7C8C, #$7C8D, #$7C8E, #$7C8F, #$7C90, #$7C93,
      #$7C94, #$7C96, #$7C99, #$7C9A, #$7C9B, #$7CA0, #$7CA1, #$7CA3,
      #$7CA6, #$7CA7, #$7CA8, #$7CA9, #$7CAB, #$7CAC, #$7CAD, #$7CAF,
      #$7CB0, #$7CB4, #$7CB5, #$7CB6, #$7CB7, #$7CB8, #$7CBA, #$7CBB,
      #$7CBF, #$7CC0, #$7CC2, #$7CC3, #$7CC4, #$7CC6, #$7CC9, #$7CCB,
      #$7CCE, #$7CCF, #$7CD0, #$7CD1, #$7CD2, #$7CD3, #$7CD4, #$7CD8,
      #$7CDA, #$7CDB, #$7CDD, #$7CDE, #$7CE1, #$7CE2, #$7CE3, #$7CE4,
      #$7CE5, #$7CE6, #$7CE7, #$7CE9, #$7CEA, #$7CEB, #$7CEC, #$7CED,
      #$7CEE, #$7CF0, #$7CF1, #$7CF2, #$7CF3, #$7CF4, #$7CF5, #$7CF6,
      #$7CF7, #$7CF9, #$7CFA, #$7CFC, #$7CFD, #$7CFE, #$7CFF, #$7D00,
      #$7D01, #$7D02, #$7D03, #$7D04, #$7D05, #$7D06, #$7D07, #$7D08,
      #$7D09, #$7D0B, #$7D0C, #$7D0D, #$7D0E, #$7D0F, #$7D10, #$7D11,
      #$7D12, #$7D13, #$7D14, #$7D15, #$7D16, #$7D17, #$7D18, #$7D19,
      #$7D1A, #$7D1B, #$7D1C, #$7D1D, #$7D1E, #$7D1F, #$7D21, #$7D23,
      #$7D24, #$7D25, #$7D26, #$7D28, #$7D29, #$7D2A, #$7D2C, #$7D2D,
      #$7D2E, #$7D30, #$7D31, #$7D32, #$7D33, #$7D34, #$7D35, #$7D36,
      #$7D37, #$7D38, #$7D39, #$7D3A, #$7D3B, #$7D3C, #$7D3D, #$7D3E,
      #$7D3F, #$7D40, #$7D41, #$7D42, #$7D43, #$7D44, #$7D45, #$7D46,
      #$7D47, #$7D48, #$7D49, #$7D4A, #$7D4B, #$7D4C, #$7D4D, #$7D4E,
      #$7D4F, #$7D50, #$7D51, #$7D52, #$7D53, #$7D54, #$7D55, #$7D56,
      #$7D57, #$7D58, #$7D59, #$7D5A, #$7D5B, #$7D5C, #$7D5D, #$7D5E,
      #$7D5F, #$7D60, #$7D61, #$7D62, #$7D63, #$7D64, #$7D65, #$7D66,
      #$7D67, #$7D68, #$7D69, #$7D6A, #$7D6B, #$7D6C, #$7D6D, #$7D6F,
      #$7D70, #$7D71, #$7D72, #$7D73, #$7D74, #$7D75, #$7D76, #$7D78,
      #$7D79, #$7D7A, #$7D7B, #$7D7C, #$7D7D, #$7D7E, #$7D7F, #$7D80,
      #$7D81, #$7D82, #$7D83, #$7D84, #$7D85, #$7D86, #$7D87, #$7D88,
      #$7D89, #$7D8A, #$7D8B, #$7D8C, #$7D8D, #$7D8E, #$7D8F, #$7D90,
      #$7D91, #$7D92, #$7D93, #$7D94, #$7D95, #$7D96, #$7D97, #$7D98,
      #$7D99, #$7D9A, #$7D9B, #$7D9C, #$7D9D, #$7D9E, #$7D9F, #$7DA0,
      #$7DA1, #$7DA2, #$7DA3, #$7DA4, #$7DA5, #$7DA7, #$7DA8, #$7DA9,
      #$7DAA, #$7DAB, #$7DAC, #$7DAD, #$7DAF, #$7DB0, #$7DB1, #$7DB2,
      #$7DB3, #$7DB4, #$7DB5, #$7DB6, #$7DB7, #$7DB8, #$7DB9, #$7DBA,
      #$7DBB, #$7DBC, #$7DBD, #$7DBE, #$7DBF, #$7DC0, #$7DC1, #$7DC2,
      #$7DC3, #$7DC4, #$7DC5, #$7DC6, #$7DC7, #$7DC8, #$7DC9, #$7DCA,
      #$7DCB, #$7DCC, #$7DCD, #$7DCE, #$7DCF, #$7DD0, #$7DD1, #$7DD2,
      #$7DD3, #$7DD4, #$7DD5, #$7DD6, #$7DD7, #$7DD8, #$7DD9, #$7DDA,
      #$7DDB, #$7DDC, #$7DDD, #$7DDE, #$7DDF, #$7DE0, #$7DE1, #$7DE2,
      #$7DE3, #$7DE4, #$7DE5, #$7DE6, #$7DE7, #$7DE8, #$7DE9, #$7DEA,
      #$7DEB, #$7DEC, #$7DED, #$7DEE, #$7DEF, #$7DF0, #$7DF1, #$7DF2,
      #$7DF3, #$7DF4, #$7DF5, #$7DF6, #$7DF7, #$7DF8, #$7DF9, #$7DFA,
      #$7DFB, #$7DFC, #$7DFD, #$7DFE, #$7DFF, #$7E00, #$7E01, #$7E02,
      #$7E03, #$7E04, #$7E05, #$7E06, #$7E07, #$7E08, #$7E09, #$7E0A,
      #$7E0B, #$7E0C, #$7E0D, #$7E0E, #$7E0F, #$7E10, #$7E11, #$7E12,
      #$7E13, #$7E14, #$7E15, #$7E16, #$7E17, #$7E18, #$7E19, #$7E1A,
      #$7E1B, #$7E1C, #$7E1D, #$7E1E, #$7E1F, #$7E20, #$7E21, #$7E22,
      #$7E23, #$7E24, #$7E25, #$7E26, #$7E27, #$7E28, #$7E29, #$7E2A,
      #$7E2B, #$7E2C, #$7E2D, #$7E2E, #$7E2F, #$7E30, #$7E31, #$7E32,
      #$7E33, #$7E34, #$7E35, #$7E36, #$7E37, #$7E38, #$7E39, #$7E3A,
      #$7E3C, #$7E3D, #$7E3E, #$7E3F, #$7E40, #$7E42, #$7E43, #$7E44,
      #$7E45, #$7E46, #$7E48, #$7E49, #$7E4A, #$7E4B, #$7E4C, #$7E4D,
      #$7E4E, #$7E4F, #$7E50, #$7E51, #$7E52, #$7E53, #$7E54, #$7E55,
      #$7E56, #$7E57, #$7E58, #$7E59, #$7E5A, #$7E5B, #$7E5C, #$7E5D,
      #$7E5E, #$7E5F, #$7E60, #$7E61, #$7E62, #$7E63, #$7E64, #$7E65,
      #$7E66, #$7E67, #$7E68, #$7E69, #$7E6A, #$7E6B, #$7E6C, #$7E6D,
      #$7E6E, #$7E6F, #$7E70, #$7E71, #$7E72, #$7E73, #$7E74, #$7E75,
      #$7E76, #$7E77, #$7E78, #$7E79, #$7E7A, #$7E7B, #$7E7C, #$7E7D,
      #$7E7E, #$7E7F, #$7E80, #$7E81, #$7E83, #$7E84, #$7E85, #$7E86,
      #$7E87, #$7E88, #$7E89, #$7E8A, #$7E8B, #$7E8C, #$7E8D, #$7E8E,
      #$7E8F, #$7E90, #$7E91, #$7E92, #$7E93, #$7E94, #$7E95, #$7E96,
      #$7E97, #$7E98, #$7E99, #$7E9A, #$7E9C, #$7E9D, #$7E9E, #$7EAE,
      #$7EB4, #$7EBB, #$7EBC, #$7ED6, #$7EE4, #$7EEC, #$7EF9, #$7F0A,
      #$7F10, #$7F1E, #$7F37, #$7F39, #$7F3B, #$7F3C, #$7F3D, #$7F3E,
      #$7F3F, #$7F40, #$7F41, #$7F43, #$7F46, #$7F47, #$7F48, #$7F49,
      #$7F4A, #$7F4B, #$7F4C, #$7F4D, #$7F4E, #$7F4F, #$7F52, #$7F53,
      #$7F56, #$7F59, #$7F5B, #$7F5C, #$7F5D, #$7F5E, #$7F60, #$7F63,
      #$7F64, #$7F65, #$7F66, #$7F67, #$7F6B, #$7F6C, #$7F6D, #$7F6F,
      #$7F70, #$7F73, #$7F75, #$7F76, #$7F77, #$7F78, #$7F7A, #$7F7B,
      #$7F7C, #$7F7D, #$7F7F, #$7F80, #$7F82, #$7F83, #$7F84, #$7F85,
      #$7F86, #$7F87, #$7F88, #$7F89, #$7F8B, #$7F8D, #$7F8F, #$7F90,
      #$7F91, #$7F92, #$7F93, #$7F95, #$7F96, #$7F97, #$7F98, #$7F99,
      #$7F9B, #$7F9C, #$7FA0, #$7FA2, #$7FA3, #$7FA5, #$7FA6, #$7FA8,
      #$7FA9, #$7FAA, #$7FAB, #$7FAC, #$7FAD, #$7FAE, #$7FB1, #$7FB3,
      #$7FB4, #$7FB5, #$7FB6, #$7FB7, #$7FBA, #$7FBB, #$7FBE, #$7FC0,
      #$7FC2, #$7FC3, #$7FC4, #$7FC6, #$7FC7, #$7FC8, #$7FC9, #$7FCB,
      #$7FCD, #$7FCF, #$7FD0, #$7FD1, #$7FD2, #$7FD3, #$7FD6, #$7FD7,
      #$7FD9, #$7FDA, #$7FDB, #$7FDC, #$7FDD, #$7FDE, #$7FE2, #$7FE3,
      #$7FE4, #$7FE7, #$7FE8, #$7FEA, #$7FEB, #$7FEC, #$7FED, #$7FEF,
      #$7FF2, #$7FF4, #$7FF5, #$7FF6, #$7FF7, #$7FF8, #$7FF9, #$7FFA,
      #$7FFD, #$7FFE, #$7FFF, #$8002, #$8007, #$8008, #$8009, #$800A,
      #$800E, #$800F, #$8011, #$8013, #$801A, #$801B, #$801D, #$801E,
      #$801F, #$8021, #$8023, #$8024, #$802B, #$802C, #$802D, #$802E,
      #$802F, #$8030, #$8032, #$8034, #$8039, #$803A, #$803C, #$803E,
      #$8040, #$8041, #$8044, #$8045, #$8047, #$8048, #$8049, #$804E,
      #$804F, #$8050, #$8051, #$8053, #$8055, #$8056, #$8057, #$8059,
      #$805B, #$805C, #$805D, #$805E, #$805F, #$8060, #$8061, #$8062,
      #$8063, #$8064, #$8065, #$8066, #$8067, #$8068, #$806B, #$806C,
      #$806D, #$806E, #$806F, #$8070, #$8072, #$8073, #$8074, #$8075,
      #$8076, #$8077, #$8078, #$8079, #$807A, #$807B, #$807C, #$807D,
      #$807E, #$8081, #$8082, #$8085, #$8088, #$808A, #$808D, #$808E,
      #$808F, #$8090, #$8091, #$8092, #$8094, #$8095, #$8097, #$8099,
      #$809E, #$80A3, #$80A6, #$80A7, #$80A8, #$80AC, #$80B0, #$80B3,
      #$80B5, #$80B6, #$80B8, #$80B9, #$80BB, #$80C5, #$80C7, #$80C8,
      #$80C9, #$80CA, #$80CB, #$80CF, #$80D0, #$80D1, #$80D2, #$80D3,
      #$80D4, #$80D5, #$80D8, #$80DF, #$80E0, #$80E2, #$80E3, #$80E6,
      #$80EE, #$80F5, #$80F7, #$80F9, #$80FB, #$80FE, #$80FF, #$8100,
      #$8101, #$8103, #$8104, #$8105, #$8107, #$8108, #$810B, #$810C,
      #$8115, #$8117, #$8119, #$811B, #$811C, #$811D, #$811F, #$8120,
      #$8121, #$8122, #$8123, #$8124, #$8125, #$8126, #$8127, #$8128,
      #$8129, #$812A, #$812B, #$812D, #$812E, #$8130, #$8133, #$8134,
      #$8135, #$8137, #$8139, #$813A, #$813B, #$813C, #$813D, #$813F,
      #$8140, #$8141, #$8142, #$8143, #$8144, #$8145, #$8147, #$8149,
      #$814D, #$814E, #$814F, #$8152, #$8156, #$8157, #$8158, #$815B,
      #$815C, #$815D, #$815E, #$815F, #$8161, #$8162, #$8163, #$8164,
      #$8166, #$8168, #$816A, #$816B, #$816C, #$816F, #$8172, #$8173,
      #$8175, #$8176, #$8177, #$8178, #$8181, #$8183, #$8184, #$8185,
      #$8186, #$8187, #$8189, #$818B, #$818C, #$818D, #$818E, #$8190,
      #$8192, #$8193, #$8194, #$8195, #$8196, #$8197, #$8199, #$819A,
      #$819E, #$819F, #$81A0, #$81A1, #$81A2, #$81A4, #$81A5, #$81A7,
      #$81A9, #$81AB, #$81AC, #$81AD, #$81AE, #$81AF, #$81B0, #$81B1,
      #$81B2, #$81B4, #$81B5, #$81B6, #$81B7, #$81B8, #$81B9, #$81BC,
      #$81BD, #$81BE, #$81BF, #$81C4, #$81C5, #$81C7, #$81C8, #$81C9,
      #$81CB, #$81CD, #$81CE, #$81CF, #$81D0, #$81D1, #$81D2, #$81D3,
      #$81D4, #$81D5, #$81D6, #$81D7, #$81D8, #$81D9, #$81DA, #$81DB,
      #$81DC, #$81DD, #$81DE, #$81DF, #$81E0, #$81E1, #$81E2, #$81E4,
      #$81E5, #$81E6, #$81E8, #$81E9, #$81EB, #$81EE, #$81EF, #$81F0,
      #$81F1, #$81F2, #$81F5, #$81F6, #$81F7, #$81F8, #$81F9, #$81FA,
      #$81FD, #$81FF, #$8203, #$8207, #$8208, #$8209, #$820A, #$820B,
      #$820E, #$820F, #$8211, #$8213, #$8215, #$8216, #$8217, #$8218,
      #$8219, #$821A, #$821D, #$8220, #$8224, #$8225, #$8226, #$8227,
      #$8229, #$822E, #$8232, #$823A, #$823C, #$823D, #$823F, #$8240,
      #$8241, #$8242, #$8243, #$8245, #$8246, #$8248, #$824A, #$824C,
      #$824D, #$824E, #$8250, #$8251, #$8252, #$8253, #$8254, #$8255,
      #$8256, #$8257, #$8259, #$825B, #$825C, #$825D, #$825E, #$8260,
      #$8261, #$8262, #$8263, #$8264, #$8265, #$8266, #$8267, #$8269,
      #$826A, #$826B, #$826C, #$826D, #$8271, #$8275, #$8276, #$8277,
      #$8278, #$827B, #$827C, #$8280, #$8281, #$8283, #$8285, #$8286,
      #$8287, #$8289, #$828C, #$8290, #$8293, #$8294, #$8295, #$8296,
      #$829A, #$829B, #$829E, #$82A0, #$82A2, #$82A3, #$82A7, #$82B2,
      #$82B5, #$82B6, #$82BA, #$82BB, #$82BC, #$82BF, #$82C0, #$82C2,
      #$82C3, #$82C5, #$82C6, #$82C9, #$82D0, #$82D6, #$82D9, #$82DA,
      #$82DD, #$82E2, #$82E7, #$82E8, #$82E9, #$82EA, #$82EC, #$82ED,
      #$82EE, #$82F0, #$82F2, #$82F3, #$82F5, #$82F6, #$82F8, #$82FA,
      #$82FC, #$82FD, #$82FE, #$82FF, #$8300, #$830A, #$830B, #$830D,
      #$8310, #$8312, #$8313, #$8316, #$8318, #$8319, #$831D, #$831E,
      #$831F, #$8320, #$8321, #$8322, #$8323, #$8324, #$8325, #$8326,
      #$8329, #$832A, #$832E, #$8330, #$8332, #$8337, #$833B, #$833D,
      #$833E, #$833F, #$8341, #$8342, #$8344, #$8345, #$8348, #$834A,
      #$834B, #$834C, #$834D, #$834E, #$8353, #$8355, #$8356, #$8357,
      #$8358, #$8359, #$835D, #$8362, #$8370, #$8371, #$8372, #$8373,
      #$8374, #$8375, #$8376, #$8379, #$837A, #$837E, #$837F, #$8380,
      #$8381, #$8382, #$8383, #$8384, #$8387, #$8388, #$838A, #$838B,
      #$838C, #$838D, #$838F, #$8390, #$8391, #$8394, #$8395, #$8396,
      #$8397, #$8399, #$839A, #$839D, #$839F, #$83A1, #$83A2, #$83A3,
      #$83A4, #$83A5, #$83A6, #$83A7, #$83AC, #$83AD, #$83AE, #$83AF,
      #$83B5, #$83BB, #$83BE, #$83BF, #$83C2, #$83C3, #$83C4, #$83C6,
      #$83C8, #$83C9, #$83CB, #$83CD, #$83CE, #$83D0, #$83D1, #$83D2,
      #$83D3, #$83D5, #$83D7, #$83D9, #$83DA, #$83DB, #$83DE, #$83E2,
      #$83E3, #$83E4, #$83E6, #$83E7, #$83E8, #$83EB, #$83EC, #$83ED,
      #$83EE, #$83EF, #$83F3, #$83F4, #$83F5, #$83F6, #$83F7, #$83FA,
      #$83FB, #$83FC, #$83FE, #$83FF, #$8400, #$8402, #$8405, #$8407,
      #$8408, #$8409, #$840A, #$8410, #$8412, #$8413, #$8414, #$8415,
      #$8416, #$8417, #$8419, #$841A, #$841B, #$841E, #$841F, #$8420,
      #$8421, #$8422, #$8423, #$8429, #$842A, #$842B, #$842C, #$842D,
      #$842E, #$842F, #$8430, #$8432, #$8433, #$8434, #$8435, #$8436,
      #$8437, #$8439, #$843A, #$843B, #$843E, #$843F, #$8440, #$8441,
      #$8442, #$8443, #$8444, #$8445, #$8447, #$8448, #$8449, #$844A,
      #$844B, #$844C, #$844D, #$844E, #$844F, #$8450, #$8452, #$8453,
      #$8454, #$8455, #$8456, #$8458, #$845D, #$845E, #$845F, #$8460,
      #$8462, #$8464, #$8465, #$8466, #$8467, #$8468, #$846A, #$846E,
      #$846F, #$8470, #$8472, #$8474, #$8477, #$8479, #$847B, #$847C,
      #$847D, #$847E, #$847F, #$8480, #$8481, #$8483, #$8484, #$8485,
      #$8486, #$848A, #$848D, #$848F, #$8490, #$8491, #$8492, #$8493,
      #$8494, #$8495, #$8496, #$8498, #$849A, #$849B, #$849D, #$849E,
      #$849F, #$84A0, #$84A2, #$84A3, #$84A4, #$84A5, #$84A6, #$84A7,
      #$84A8, #$84A9, #$84AA, #$84AB, #$84AC, #$84AD, #$84AE, #$84B0,
      #$84B1, #$84B3, #$84B5, #$84B6, #$84B7, #$84BB, #$84BC, #$84BE,
      #$84C0, #$84C2, #$84C3, #$84C5, #$84C6, #$84C7, #$84C8, #$84CB,
      #$84CC, #$84CE, #$84CF, #$84D2, #$84D4, #$84D5, #$84D7, #$84D8,
      #$84D9, #$84DA, #$84DB, #$84DC, #$84DE, #$84E1, #$84E2, #$84E4,
      #$84E7, #$84E8, #$84E9, #$84EA, #$84EB, #$84ED, #$84EE, #$84EF,
      #$84F1, #$84F2, #$84F3, #$84F4, #$84F5, #$84F6, #$84F7, #$84F8,
      #$84F9, #$84FA, #$84FB, #$84FD, #$84FE, #$8500, #$8501, #$8502,
      #$8503, #$8504, #$8505, #$8506, #$8507, #$8508, #$8509, #$850A,
      #$850B, #$850D, #$850E, #$850F, #$8510, #$8512, #$8514, #$8515,
      #$8516, #$8518, #$8519, #$851B, #$851C, #$851D, #$851E, #$8520,
      #$8522, #$8523, #$8524, #$8525, #$8526, #$8527, #$8528, #$8529,
      #$852A, #$852D, #$852E, #$852F, #$8530, #$8531, #$8532, #$8533,
      #$8534, #$8535, #$8536, #$853E, #$853F, #$8540, #$8541, #$8542,
      #$8544, #$8545, #$8546, #$8547, #$854B, #$854C, #$854D, #$854E,
      #$854F, #$8550, #$8551, #$8552, #$8553, #$8554, #$8555, #$8557,
      #$8558, #$855A, #$855B, #$855C, #$855D, #$855F, #$8560, #$8561,
      #$8562, #$8563, #$8565, #$8566, #$8567, #$8569, #$856A, #$856B,
      #$856C, #$856D, #$856E, #$856F, #$8570, #$8571, #$8573, #$8575,
      #$8576, #$8577, #$8578, #$857C, #$857D, #$857F, #$8580, #$8581,
      #$8582, #$8583, #$8586, #$8588, #$8589, #$858A, #$858B, #$858C,
      #$858D, #$858E, #$8590, #$8591, #$8592, #$8593, #$8594, #$8595,
      #$8596, #$8597, #$8598, #$8599, #$859A, #$859D, #$859E, #$859F,
      #$85A0, #$85A1, #$85A2, #$85A3, #$85A5, #$85A6, #$85A7, #$85A9,
      #$85AB, #$85AC, #$85AD, #$85B1, #$85B2, #$85B3, #$85B4, #$85B5,
      #$85B6, #$85B8, #$85BA, #$85BB, #$85BC, #$85BD, #$85BE, #$85BF,
      #$85C0, #$85C2, #$85C3, #$85C4, #$85C5, #$85C6, #$85C7, #$85C8,
      #$85CA, #$85CB, #$85CC, #$85CD, #$85CE, #$85D1, #$85D2, #$85D4,
      #$85D6, #$85D7, #$85D8, #$85D9, #$85DA, #$85DB, #$85DD, #$85DE,
      #$85DF, #$85E0, #$85E1, #$85E2, #$85E3, #$85E5, #$85E6, #$85E7,
      #$85E8, #$85EA, #$85EB, #$85EC, #$85ED, #$85EE, #$85EF, #$85F0,
      #$85F1, #$85F2, #$85F3, #$85F4, #$85F5, #$85F6, #$85F7, #$85F8,
      #$85F9, #$85FA, #$85FC, #$85FD, #$85FE, #$8600, #$8601, #$8602,
      #$8603, #$8604, #$8606, #$8607, #$8608, #$8609, #$860A, #$860B,
      #$860C, #$860D, #$860E, #$860F, #$8610, #$8612, #$8613, #$8614,
      #$8615, #$8617, #$8618, #$8619, #$861A, #$861B, #$861C, #$861D,
      #$861E, #$861F, #$8620, #$8621, #$8622, #$8623, #$8624, #$8625,
      #$8626, #$8628, #$862A, #$862B, #$862C, #$862D, #$862E, #$862F,
      #$8630, #$8631, #$8632, #$8633, #$8634, #$8635, #$8636, #$8637,
      #$8639, #$863A, #$863B, #$863D, #$863E, #$863F, #$8640, #$8641,
      #$8642, #$8643, #$8644, #$8645, #$8646, #$8647, #$8648, #$8649,
      #$864A, #$864B, #$864C, #$8652, #$8653, #$8655, #$8656, #$8657,
      #$8658, #$8659, #$865B, #$865C, #$865D, #$865F, #$8660, #$8661,
      #$8663, #$8664, #$8665, #$8666, #$8667, #$8668, #$8669, #$866A,
      #$866D, #$866F, #$8670, #$8672, #$8673, #$8674, #$8675, #$8676,
      #$8677, #$8678, #$8683, #$8684, #$8685, #$8686, #$8687, #$8688,
      #$8689, #$868E, #$868F, #$8690, #$8691, #$8692, #$8694, #$8696,
      #$8697, #$8698, #$8699, #$869A, #$869B, #$869E, #$869F, #$86A0,
      #$86A1, #$86A2, #$86A5, #$86A6, #$86AB, #$86AD, #$86AE, #$86B2,
      #$86B3, #$86B7, #$86B8, #$86B9, #$86BB, #$86BC, #$86BD, #$86BE,
      #$86BF, #$86C1, #$86C2, #$86C3, #$86C5, #$86C8, #$86CC, #$86CD,
      #$86D2, #$86D3, #$86D5, #$86D6, #$86D7, #$86DA, #$86DC, #$86DD,
      #$86E0, #$86E1, #$86E2, #$86E3, #$86E5, #$86E6, #$86E7, #$86E8,
      #$86EA, #$86EB, #$86EC, #$86EF, #$86F5, #$86F6, #$86F7, #$86FA,
      #$86FB, #$86FC, #$86FD, #$86FF, #$8701, #$8704, #$8705, #$8706,
      #$870B, #$870C, #$870E, #$870F, #$8710, #$8711, #$8714, #$8716,
      #$8719, #$871B, #$871D, #$871F, #$8720, #$8724, #$8726, #$8727,
      #$8728, #$872A, #$872B, #$872C, #$872D, #$872F, #$8730, #$8732,
      #$8733, #$8735, #$8736, #$8738, #$8739, #$873A, #$873C, #$873D,
      #$8740, #$8741, #$8742, #$8743, #$8744, #$8745, #$8746, #$874A,
      #$874B, #$874D, #$874F, #$8750, #$8751, #$8752, #$8754, #$8755,
      #$8756, #$8758, #$875A, #$875B, #$875C, #$875D, #$875E, #$875F,
      #$8761, #$8762, #$8766, #$8767, #$8768, #$8769, #$876A, #$876B,
      #$876C, #$876D, #$876F, #$8771, #$8772, #$8773, #$8775, #$8777,
      #$8778, #$8779, #$877A, #$877F, #$8780, #$8781, #$8784, #$8786,
      #$8787, #$8789, #$878A, #$878C, #$878E, #$878F, #$8790, #$8791,
      #$8792, #$8794, #$8795, #$8796, #$8798, #$8799, #$879A, #$879B,
      #$879C, #$879D, #$879E, #$87A0, #$87A1, #$87A2, #$87A3, #$87A4,
      #$87A5, #$87A6, #$87A7, #$87A9, #$87AA, #$87AE, #$87B0, #$87B1,
      #$87B2, #$87B4, #$87B6, #$87B7, #$87B8, #$87B9, #$87BB, #$87BC,
      #$87BE, #$87BF, #$87C1, #$87C2, #$87C3, #$87C4, #$87C5, #$87C7,
      #$87C8, #$87C9, #$87CC, #$87CD, #$87CE, #$87CF, #$87D0, #$87D4,
      #$87D5, #$87D6, #$87D7, #$87D8, #$87D9, #$87DA, #$87DC, #$87DD,
      #$87DE, #$87DF, #$87E1, #$87E2, #$87E3, #$87E4, #$87E6, #$87E7,
      #$87E8, #$87E9, #$87EB, #$87EC, #$87ED, #$87EF, #$87F0, #$87F1,
      #$87F2, #$87F3, #$87F4, #$87F5, #$87F6, #$87F7, #$87F8, #$87FA,
      #$87FB, #$87FC, #$87FD, #$87FF, #$8800, #$8801, #$8802, #$8804,
      #$8805, #$8806, #$8807, #$8808, #$8809, #$880B, #$880C, #$880D,
      #$880E, #$880F, #$8810, #$8811, #$8812, #$8814, #$8817, #$8818,
      #$8819, #$881A, #$881C, #$881D, #$881E, #$881F, #$8820, #$8823,
      #$8824, #$8825, #$8826, #$8827, #$8828, #$8829, #$882A, #$882B,
      #$882C, #$882D, #$882E, #$882F, #$8830, #$8831, #$8833, #$8834,
      #$8835, #$8836, #$8837, #$8838, #$883A, #$883B, #$883D, #$883E,
      #$883F, #$8841, #$8842, #$8843, #$8846, #$8847, #$8848, #$8849,
      #$884A, #$884B, #$884E, #$884F, #$8850, #$8851, #$8852, #$8853,
      #$8855, #$8856, #$8858, #$885A, #$885B, #$885C, #$885D, #$885E,
      #$885F, #$8860, #$8866, #$8867, #$886A, #$886D, #$886F, #$8871,
      #$8873, #$8874, #$8875, #$8876, #$8878, #$8879, #$887A, #$887B,
      #$887C, #$8880, #$8883, #$8886, #$8887, #$8889, #$888A, #$888C,
      #$888E, #$888F, #$8890, #$8891, #$8893, #$8894, #$8895, #$8897,
      #$8898, #$8899, #$889A, #$889B, #$889D, #$889E, #$889F, #$88A0,
      #$88A1, #$88A3, #$88A5, #$88A6, #$88A7, #$88A8, #$88A9, #$88AA,
      #$88AC, #$88AE, #$88AF, #$88B0, #$88B2, #$88B3, #$88B4, #$88B5,
      #$88B6, #$88B8, #$88B9, #$88BA, #$88BB, #$88BD, #$88BE, #$88BF,
      #$88C0, #$88C3, #$88C4, #$88C7, #$88C8, #$88CA, #$88CB, #$88CC,
      #$88CD, #$88CF, #$88D0, #$88D1, #$88D3, #$88D6, #$88D7, #$88DA,
      #$88DB, #$88DC, #$88DD, #$88DE, #$88E0, #$88E1, #$88E6, #$88E7,
      #$88E9, #$88EA, #$88EB, #$88EC, #$88ED, #$88EE, #$88EF, #$88F2,
      #$88F5, #$88F6, #$88F7, #$88FA, #$88FB, #$88FD, #$88FF, #$8900,
      #$8901, #$8903, #$8904, #$8905, #$8906, #$8907, #$8908, #$8909,
      #$890B, #$890C, #$890D, #$890E, #$890F, #$8911, #$8914, #$8915,
      #$8916, #$8917, #$8918, #$891C, #$891D, #$891E, #$891F, #$8920,
      #$8922, #$8923, #$8924, #$8926, #$8927, #$8928, #$8929, #$892C,
      #$892D, #$892E, #$892F, #$8931, #$8932, #$8933, #$8935, #$8937,
      #$8938, #$8939, #$893A, #$893B, #$893C, #$893D, #$893E, #$893F,
      #$8940, #$8942, #$8943, #$8945, #$8946, #$8947, #$8948, #$8949,
      #$894A, #$894B, #$894C, #$894D, #$894E, #$894F, #$8950, #$8951,
      #$8952, #$8953, #$8954, #$8955, #$8956, #$8957, #$8958, #$8959,
      #$895A, #$895B, #$895C, #$895D, #$8960, #$8961, #$8962, #$8963,
      #$8964, #$8965, #$8967, #$8968, #$8969, #$896A, #$896B, #$896C,
      #$896D, #$896E, #$896F, #$8970, #$8971, #$8972, #$8973, #$8974,
      #$8975, #$8976, #$8977, #$8978, #$8979, #$897A, #$897C, #$897D,
      #$897E, #$8980, #$8982, #$8984, #$8985, #$8987, #$8988, #$8989,
      #$898A, #$898B, #$898C, #$898D, #$898E, #$898F, #$8990, #$8991,
      #$8992, #$8993, #$8994, #$8995, #$8996, #$8997, #$8998, #$8999,
      #$899A, #$899B, #$899C, #$899D, #$899E, #$899F, #$89A0, #$89A1,
      #$89A2, #$89A3, #$89A4, #$89A5, #$89A6, #$89A7, #$89A8, #$89A9,
      #$89AA, #$89AB, #$89AC, #$89AD, #$89AE, #$89AF, #$89B0, #$89B1,
      #$89B2, #$89B3, #$89B4, #$89B5, #$89B6, #$89B7, #$89B8, #$89B9,
      #$89BA, #$89BB, #$89BC, #$89BD, #$89BE, #$89BF, #$89C0, #$89C3,
      #$89CD, #$89D3, #$89D4, #$89D5, #$89D7, #$89D8, #$89D9, #$89DB,
      #$89DD, #$89DF, #$89E0, #$89E1, #$89E2, #$89E4, #$89E7, #$89E8,
      #$89E9, #$89EA, #$89EC, #$89ED, #$89EE, #$89F0, #$89F1, #$89F2,
      #$89F4, #$89F5, #$89F6, #$89F7, #$89F8, #$89F9, #$89FA, #$89FB,
      #$89FC, #$89FD, #$89FE, #$89FF, #$8A01, #$8A02, #$8A03, #$8A04,
      #$8A05, #$8A06, #$8A08, #$8A09, #$8A0A, #$8A0B, #$8A0C, #$8A0D,
      #$8A0E, #$8A0F, #$8A10, #$8A11, #$8A12, #$8A13, #$8A14, #$8A15,
      #$8A16, #$8A17, #$8A18, #$8A19, #$8A1A, #$8A1B, #$8A1C, #$8A1D,
      #$8A1E, #$8A1F, #$8A20, #$8A21, #$8A22, #$8A23, #$8A24, #$8A25,
      #$8A26, #$8A27, #$8A28, #$8A29, #$8A2A, #$8A2B, #$8A2C, #$8A2D,
      #$8A2E, #$8A2F, #$8A30, #$8A31, #$8A32, #$8A33, #$8A34, #$8A35,
      #$8A36, #$8A37, #$8A38, #$8A39, #$8A3A, #$8A3B, #$8A3C, #$8A3D,
      #$8A3F, #$8A40, #$8A41, #$8A42, #$8A43, #$8A44, #$8A45, #$8A46,
      #$8A47, #$8A49, #$8A4A, #$8A4B, #$8A4C, #$8A4D, #$8A4E, #$8A4F,
      #$8A50, #$8A51, #$8A52, #$8A53, #$8A54, #$8A55, #$8A56, #$8A57,
      #$8A58, #$8A59, #$8A5A, #$8A5B, #$8A5C, #$8A5D, #$8A5E, #$8A5F,
      #$8A60, #$8A61, #$8A62, #$8A63, #$8A64, #$8A65, #$8A66, #$8A67,
      #$8A68, #$8A69, #$8A6A, #$8A6B, #$8A6C, #$8A6D, #$8A6E, #$8A6F,
      #$8A70, #$8A71, #$8A72, #$8A73, #$8A74, #$8A75, #$8A76, #$8A77,
      #$8A78, #$8A7A, #$8A7B, #$8A7C, #$8A7D, #$8A7E, #$8A7F, #$8A80,
      #$8A81, #$8A82, #$8A83, #$8A84, #$8A85, #$8A86, #$8A87, #$8A88,
      #$8A8B, #$8A8C, #$8A8D, #$8A8E, #$8A8F, #$8A90, #$8A91, #$8A92,
      #$8A94, #$8A95, #$8A96, #$8A97, #$8A98, #$8A99, #$8A9A, #$8A9B,
      #$8A9C, #$8A9D, #$8A9E, #$8A9F, #$8AA0, #$8AA1, #$8AA2, #$8AA3,
      #$8AA4, #$8AA5, #$8AA6, #$8AA7, #$8AA8, #$8AA9, #$8AAA, #$8AAB,
      #$8AAC, #$8AAD, #$8AAE, #$8AAF, #$8AB0, #$8AB1, #$8AB2, #$8AB3,
      #$8AB4, #$8AB5, #$8AB6, #$8AB7, #$8AB8, #$8AB9, #$8ABA, #$8ABB,
      #$8ABC, #$8ABD, #$8ABE, #$8ABF, #$8AC0, #$8AC1, #$8AC2, #$8AC3,
      #$8AC4, #$8AC5, #$8AC6, #$8AC7, #$8AC8, #$8AC9, #$8ACA, #$8ACB,
      #$8ACC, #$8ACD, #$8ACE, #$8ACF, #$8AD0, #$8AD1, #$8AD2, #$8AD3,
      #$8AD4, #$8AD5, #$8AD6, #$8AD7, #$8AD8, #$8AD9, #$8ADA, #$8ADB,
      #$8ADC, #$8ADD, #$8ADE, #$8ADF, #$8AE0, #$8AE1, #$8AE2, #$8AE3,
      #$8AE4, #$8AE5, #$8AE6, #$8AE7, #$8AE8, #$8AE9, #$8AEA, #$8AEB,
      #$8AEC, #$8AED, #$8AEE, #$8AEF, #$8AF0, #$8AF1, #$8AF2, #$8AF3,
      #$8AF4, #$8AF5, #$8AF6, #$8AF7, #$8AF8, #$8AF9, #$8AFA, #$8AFB,
      #$8AFC, #$8AFD, #$8AFE, #$8AFF, #$8B00, #$8B01, #$8B02, #$8B03,
      #$8B04, #$8B05, #$8B06, #$8B08, #$8B09, #$8B0A, #$8B0B, #$8B0C,
      #$8B0D, #$8B0E, #$8B0F, #$8B10, #$8B11, #$8B12, #$8B13, #$8B14,
      #$8B15, #$8B16, #$8B17, #$8B18, #$8B19, #$8B1A, #$8B1B, #$8B1C,
      #$8B1D, #$8B1E, #$8B1F, #$8B20, #$8B21, #$8B22, #$8B23, #$8B24,
      #$8B25, #$8B27, #$8B28, #$8B29, #$8B2A, #$8B2B, #$8B2C, #$8B2D,
      #$8B2E, #$8B2F, #$8B30, #$8B31, #$8B32, #$8B33, #$8B34, #$8B35,
      #$8B36, #$8B37, #$8B38, #$8B39, #$8B3A, #$8B3B, #$8B3C, #$8B3D,
      #$8B3E, #$8B3F, #$8B40, #$8B41, #$8B42, #$8B43, #$8B44, #$8B45,
      #$8B46, #$8B47, #$8B48, #$8B49, #$8B4A, #$8B4B, #$8B4C, #$8B4D,
      #$8B4E, #$8B4F, #$8B50, #$8B51, #$8B52, #$8B53, #$8B54, #$8B55,
      #$8B56, #$8B57, #$8B58, #$8B59, #$8B5A, #$8B5B, #$8B5C, #$8B5D,
      #$8B5E, #$8B5F, #$8B60, #$8B61, #$8B62, #$8B63, #$8B64, #$8B65,
      #$8B67, #$8B68, #$8B69, #$8B6A, #$8B6B, #$8B6D, #$8B6E, #$8B6F,
      #$8B70, #$8B71, #$8B72, #$8B73, #$8B74, #$8B75, #$8B76, #$8B77,
      #$8B78, #$8B79, #$8B7A, #$8B7B, #$8B7C, #$8B7D, #$8B7E, #$8B7F,
      #$8B80, #$8B81, #$8B82, #$8B83, #$8B84, #$8B85, #$8B86, #$8B87,
      #$8B88, #$8B89, #$8B8A, #$8B8B, #$8B8C, #$8B8D, #$8B8E, #$8B8F,
      #$8B90, #$8B91, #$8B92, #$8B93, #$8B94, #$8B95, #$8B96, #$8B97,
      #$8B98, #$8B99, #$8B9A, #$8B9B, #$8B9C, #$8B9D, #$8B9E, #$8B9F,
      #$8BAC, #$8BB1, #$8BBB, #$8BC7, #$8BD0, #$8BEA, #$8C09, #$8C1E,
      #$8C38, #$8C39, #$8C3A, #$8C3B, #$8C3C, #$8C3D, #$8C3E, #$8C3F,
      #$8C40, #$8C42, #$8C43, #$8C44, #$8C45, #$8C48, #$8C4A, #$8C4B,
      #$8C4D, #$8C4E, #$8C4F, #$8C50, #$8C51, #$8C52, #$8C53, #$8C54,
      #$8C56, #$8C57, #$8C58, #$8C59, #$8C5B, #$8C5C, #$8C5D, #$8C5E,
      #$8C5F, #$8C60, #$8C63, #$8C64, #$8C65, #$8C66, #$8C67, #$8C68,
      #$8C69, #$8C6C, #$8C6D, #$8C6E, #$8C6F, #$8C70, #$8C71, #$8C72,
      #$8C74, #$8C75, #$8C76, #$8C77, #$8C7B, #$8C7C, #$8C7D, #$8C7E,
      #$8C7F, #$8C80, #$8C81, #$8C83, #$8C84, #$8C86, #$8C87, #$8C88,
      #$8C8B, #$8C8D, #$8C8E, #$8C8F, #$8C90, #$8C91, #$8C92, #$8C93,
      #$8C95, #$8C96, #$8C97, #$8C99, #$8C9A, #$8C9B, #$8C9C, #$8C9D,
      #$8C9E, #$8C9F, #$8CA0, #$8CA1, #$8CA2, #$8CA3, #$8CA4, #$8CA5,
      #$8CA6, #$8CA7, #$8CA8, #$8CA9, #$8CAA, #$8CAB, #$8CAC, #$8CAD,
      #$8CAE, #$8CAF, #$8CB0, #$8CB1, #$8CB2, #$8CB3, #$8CB4, #$8CB5,
      #$8CB6, #$8CB7, #$8CB8, #$8CB9, #$8CBA, #$8CBB, #$8CBC, #$8CBD,
      #$8CBE, #$8CBF, #$8CC0, #$8CC1, #$8CC2, #$8CC3, #$8CC4, #$8CC5,
      #$8CC6, #$8CC7, #$8CC8, #$8CC9, #$8CCA, #$8CCB, #$8CCC, #$8CCD,
      #$8CCE, #$8CCF, #$8CD0, #$8CD1, #$8CD2, #$8CD3, #$8CD4, #$8CD5,
      #$8CD6, #$8CD7, #$8CD8, #$8CD9, #$8CDA, #$8CDB, #$8CDC, #$8CDD,
      #$8CDE, #$8CDF, #$8CE0, #$8CE1, #$8CE2, #$8CE3, #$8CE4, #$8CE5,
      #$8CE6, #$8CE7, #$8CE8, #$8CE9, #$8CEA, #$8CEB, #$8CEC, #$8CED,
      #$8CEE, #$8CEF, #$8CF0, #$8CF1, #$8CF2, #$8CF3, #$8CF4, #$8CF5,
      #$8CF6, #$8CF7, #$8CF8, #$8CF9, #$8CFA, #$8CFB, #$8CFC, #$8CFD,
      #$8CFE, #$8CFF, #$8D00, #$8D01, #$8D02, #$8D03, #$8D04, #$8D05,
      #$8D06, #$8D07, #$8D08, #$8D09, #$8D0A, #$8D0B, #$8D0C, #$8D0D,
      #$8D0E, #$8D0F, #$8D10, #$8D11, #$8D12, #$8D13, #$8D14, #$8D15,
      #$8D16, #$8D17, #$8D18, #$8D19, #$8D1A, #$8D1B, #$8D1C, #$8D20,
      #$8D51, #$8D52, #$8D57, #$8D5F, #$8D65, #$8D68, #$8D69, #$8D6A,
      #$8D6C, #$8D6E, #$8D6F, #$8D71, #$8D72, #$8D78, #$8D79, #$8D7A,
      #$8D7B, #$8D7C, #$8D7D, #$8D7E, #$8D7F, #$8D80, #$8D82, #$8D83,
      #$8D86, #$8D87, #$8D88, #$8D89, #$8D8C, #$8D8D, #$8D8E, #$8D8F,
      #$8D90, #$8D92, #$8D93, #$8D95, #$8D96, #$8D97, #$8D98, #$8D99,
      #$8D9A, #$8D9B, #$8D9C, #$8D9D, #$8D9E, #$8DA0, #$8DA1, #$8DA2,
      #$8DA4, #$8DA5, #$8DA6, #$8DA7, #$8DA8, #$8DA9, #$8DAA, #$8DAB,
      #$8DAC, #$8DAD, #$8DAE, #$8DAF, #$8DB0, #$8DB2, #$8DB6, #$8DB7,
      #$8DB9, #$8DBB, #$8DBD, #$8DC0, #$8DC1, #$8DC2, #$8DC5, #$8DC7,
      #$8DC8, #$8DC9, #$8DCA, #$8DCD, #$8DD0, #$8DD2, #$8DD3, #$8DD4,
      #$8DD5, #$8DD8, #$8DD9, #$8DDC, #$8DE0, #$8DE1, #$8DE2, #$8DE5,
      #$8DE6, #$8DE7, #$8DE9, #$8DED, #$8DEE, #$8DF0, #$8DF1, #$8DF2,
      #$8DF4, #$8DF6, #$8DFC, #$8DFE, #$8DFF, #$8E00, #$8E01, #$8E02,
      #$8E03, #$8E04, #$8E06, #$8E07, #$8E08, #$8E0B, #$8E0D, #$8E0E,
      #$8E10, #$8E11, #$8E12, #$8E13, #$8E15, #$8E16, #$8E17, #$8E18,
      #$8E19, #$8E1A, #$8E1B, #$8E1C, #$8E20, #$8E21, #$8E24, #$8E25,
      #$8E26, #$8E27, #$8E28, #$8E2B, #$8E2D, #$8E30, #$8E32, #$8E33,
      #$8E34, #$8E36, #$8E37, #$8E38, #$8E3B, #$8E3C, #$8E3E, #$8E3F,
      #$8E43, #$8E45, #$8E46, #$8E4C, #$8E4D, #$8E4E, #$8E4F, #$8E50,
      #$8E53, #$8E54, #$8E55, #$8E56, #$8E57, #$8E58, #$8E5A, #$8E5B,
      #$8E5C, #$8E5D, #$8E5E, #$8E5F, #$8E60, #$8E61, #$8E62, #$8E63,
      #$8E64, #$8E65, #$8E67, #$8E68, #$8E6A, #$8E6B, #$8E6E, #$8E71,
      #$8E73, #$8E75, #$8E77, #$8E78, #$8E79, #$8E7A, #$8E7B, #$8E7D,
      #$8E7E, #$8E80, #$8E82, #$8E83, #$8E84, #$8E86, #$8E88, #$8E89,
      #$8E8A, #$8E8B, #$8E8C, #$8E8D, #$8E8E, #$8E91, #$8E92, #$8E93,
      #$8E95, #$8E96, #$8E97, #$8E98, #$8E99, #$8E9A, #$8E9B, #$8E9D,
      #$8E9F, #$8EA0, #$8EA1, #$8EA2, #$8EA3, #$8EA4, #$8EA5, #$8EA6,
      #$8EA7, #$8EA8, #$8EA9, #$8EAA, #$8EAD, #$8EAE, #$8EB0, #$8EB1,
      #$8EB3, #$8EB4, #$8EB5, #$8EB6, #$8EB7, #$8EB8, #$8EB9, #$8EBB,
      #$8EBC, #$8EBD, #$8EBE, #$8EBF, #$8EC0, #$8EC1, #$8EC2, #$8EC3,
      #$8EC4, #$8EC5, #$8EC6, #$8EC7, #$8EC8, #$8EC9, #$8ECA, #$8ECB,
      #$8ECC, #$8ECD, #$8ECF, #$8ED0, #$8ED1, #$8ED2, #$8ED3, #$8ED4,
      #$8ED5, #$8ED6, #$8ED7, #$8ED8, #$8ED9, #$8EDA, #$8EDB, #$8EDC,
      #$8EDD, #$8EDE, #$8EDF, #$8EE0, #$8EE1, #$8EE2, #$8EE3, #$8EE4,
      #$8EE5, #$8EE6, #$8EE7, #$8EE8, #$8EE9, #$8EEA, #$8EEB, #$8EEC,
      #$8EED, #$8EEE, #$8EEF, #$8EF0, #$8EF1, #$8EF2, #$8EF3, #$8EF4,
      #$8EF5, #$8EF6, #$8EF7, #$8EF8, #$8EF9, #$8EFA, #$8EFB, #$8EFC,
      #$8EFD, #$8EFE, #$8EFF, #$8F00, #$8F01, #$8F02, #$8F03, #$8F04,
      #$8F05, #$8F06, #$8F07, #$8F08, #$8F09, #$8F0A, #$8F0B, #$8F0C,
      #$8F0D, #$8F0E, #$8F0F, #$8F10, #$8F11, #$8F12, #$8F13, #$8F14,
      #$8F15, #$8F16, #$8F17, #$8F18, #$8F19, #$8F1A, #$8F1B, #$8F1C,
      #$8F1D, #$8F1E, #$8F1F, #$8F20, #$8F21, #$8F22, #$8F23, #$8F24,
      #$8F25, #$8F26, #$8F27, #$8F28, #$8F29, #$8F2A, #$8F2B, #$8F2C,
      #$8F2D, #$8F2E, #$8F2F, #$8F30, #$8F31, #$8F32, #$8F33, #$8F34,
      #$8F35, #$8F36, #$8F37, #$8F38, #$8F39, #$8F3A, #$8F3B, #$8F3C,
      #$8F3D, #$8F3E, #$8F3F, #$8F40, #$8F41, #$8F42, #$8F43, #$8F44,
      #$8F45, #$8F46, #$8F47, #$8F48, #$8F49, #$8F4A, #$8F4B, #$8F4C,
      #$8F4D, #$8F4E, #$8F4F, #$8F50, #$8F51, #$8F52, #$8F53, #$8F54,
      #$8F55, #$8F56, #$8F57, #$8F58, #$8F59, #$8F5A, #$8F5B, #$8F5C,
      #$8F5D, #$8F5E, #$8F5F, #$8F60, #$8F61, #$8F62, #$8F63, #$8F64,
      #$8F65, #$8F6A, #$8F80, #$8F8C, #$8F92, #$8F9D, #$8FA0, #$8FA1,
      #$8FA2, #$8FA4, #$8FA5, #$8FA6, #$8FA7, #$8FAA, #$8FAC, #$8FAD,
      #$8FAE, #$8FAF, #$8FB2, #$8FB3, #$8FB4, #$8FB5, #$8FB7, #$8FB8,
      #$8FBA, #$8FBB, #$8FBC, #$8FBF, #$8FC0, #$8FC3, #$8FC6, #$8FC9,
      #$8FCA, #$8FCB, #$8FCC, #$8FCD, #$8FCF, #$8FD2, #$8FD6, #$8FD7,
      #$8FDA, #$8FE0, #$8FE1, #$8FE3, #$8FE7, #$8FEC, #$8FEF, #$8FF1,
      #$8FF2, #$8FF4, #$8FF5, #$8FF6, #$8FFA, #$8FFB, #$8FFC, #$8FFE,
      #$8FFF, #$9007, #$9008, #$900C, #$900E, #$9013, #$9015, #$9018,
      #$9019, #$901C, #$9023, #$9024, #$9025, #$9027, #$9028, #$9029,
      #$902A, #$902B, #$902C, #$9030, #$9031, #$9032, #$9033, #$9034,
      #$9037, #$9039, #$903A, #$903D, #$903F, #$9040, #$9043, #$9045,
      #$9046, #$9048, #$9049, #$904A, #$904B, #$904C, #$904E, #$9054,
      #$9055, #$9056, #$9059, #$905A, #$905C, #$905D, #$905E, #$905F,
      #$9060, #$9061, #$9064, #$9066, #$9067, #$9069, #$906A, #$906B,
      #$906C, #$906F, #$9070, #$9071, #$9072, #$9073, #$9076, #$9077,
      #$9078, #$9079, #$907A, #$907B, #$907C, #$907E, #$9081, #$9084,
      #$9085, #$9086, #$9087, #$9089, #$908A, #$908C, #$908D, #$908E,
      #$908F, #$9090, #$9092, #$9094, #$9096, #$9098, #$909A, #$909C,
      #$909E, #$909F, #$90A0, #$90A4, #$90A5, #$90A7, #$90A8, #$90A9,
      #$90AB, #$90AD, #$90B2, #$90B7, #$90BC, #$90BD, #$90BF, #$90C0,
      #$90C2, #$90C3, #$90C6, #$90C8, #$90C9, #$90CB, #$90CC, #$90CD,
      #$90D2, #$90D4, #$90D5, #$90D6, #$90D8, #$90D9, #$90DA, #$90DE,
      #$90DF, #$90E0, #$90E3, #$90E4, #$90E5, #$90E9, #$90EA, #$90EC,
      #$90EE, #$90F0, #$90F1, #$90F2, #$90F3, #$90F5, #$90F6, #$90F7,
      #$90F9, #$90FA, #$90FB, #$90FC, #$90FF, #$9100, #$9101, #$9103,
      #$9105, #$9106, #$9107, #$9108, #$9109, #$910A, #$910B, #$910C,
      #$910D, #$910E, #$910F, #$9110, #$9111, #$9112, #$9113, #$9114,
      #$9115, #$9116, #$9117, #$9118, #$911A, #$911B, #$911C, #$911D,
      #$911F, #$9120, #$9121, #$9124, #$9125, #$9126, #$9127, #$9128,
      #$9129, #$912A, #$912B, #$912C, #$912D, #$912E, #$9130, #$9132,
      #$9133, #$9134, #$9135, #$9136, #$9137, #$9138, #$913A, #$913B,
      #$913C, #$913D, #$913E, #$913F, #$9140, #$9141, #$9142, #$9144,
      #$9145, #$9147, #$9148, #$9151, #$9153, #$9154, #$9155, #$9156,
      #$9158, #$9159, #$915B, #$915C, #$915F, #$9160, #$9166, #$9167,
      #$9168, #$916B, #$916D, #$9173, #$917A, #$917B, #$917C, #$9180,
      #$9181, #$9182, #$9183, #$9184, #$9186, #$9188, #$918A, #$918E,
      #$918F, #$9193, #$9194, #$9195, #$9196, #$9197, #$9198, #$9199,
      #$919C, #$919D, #$919E, #$919F, #$91A0, #$91A1, #$91A4, #$91A5,
      #$91A6, #$91A7, #$91A8, #$91A9, #$91AB, #$91AC, #$91B0, #$91B1,
      #$91B2, #$91B3, #$91B6, #$91B7, #$91B8, #$91B9, #$91BB, #$91BC,
      #$91BD, #$91BE, #$91BF, #$91C0, #$91C1, #$91C2, #$91C3, #$91C4,
      #$91C5, #$91C6, #$91C8, #$91CB, #$91D0, #$91D2, #$91D3, #$91D4,
      #$91D5, #$91D6, #$91D7, #$91D8, #$91D9, #$91DA, #$91DB, #$91DD,
      #$91DE, #$91DF, #$91E0, #$91E1, #$91E2, #$91E3, #$91E4, #$91E5,
      #$91E6, #$91E7, #$91E8, #$91E9, #$91EA, #$91EB, #$91EC, #$91ED,
      #$91EE, #$91EF, #$91F0, #$91F1, #$91F2, #$91F3, #$91F4, #$91F5,
      #$91F6, #$91F7, #$91F8, #$91F9, #$91FA, #$91FB, #$91FC, #$91FD,
      #$91FE, #$91FF, #$9200, #$9201, #$9202, #$9203, #$9204, #$9205,
      #$9206, #$9207, #$9208, #$9209, #$920A, #$920B, #$920C, #$920D,
      #$920E, #$920F, #$9210, #$9211, #$9212, #$9213, #$9214, #$9215,
      #$9216, #$9217, #$9218, #$9219, #$921A, #$921B, #$921C, #$921D,
      #$921E, #$921F, #$9220, #$9221, #$9222, #$9223, #$9224, #$9225,
      #$9226, #$9227, #$9228, #$9229, #$922A, #$922B, #$922C, #$922D,
      #$922E, #$922F, #$9230, #$9231, #$9232, #$9233, #$9234, #$9235,
      #$9236, #$9237, #$9238, #$9239, #$923A, #$923B, #$923C, #$923D,
      #$923E, #$923F, #$9240, #$9241, #$9242, #$9243, #$9244, #$9245,
      #$9246, #$9247, #$9248, #$9249, #$924A, #$924B, #$924C, #$924D,
      #$924E, #$924F, #$9250, #$9251, #$9252, #$9253, #$9254, #$9255,
      #$9256, #$9257, #$9258, #$9259, #$925A, #$925B, #$925C, #$925D,
      #$925E, #$925F, #$9260, #$9261, #$9262, #$9263, #$9264, #$9265,
      #$9266, #$9267, #$9268, #$9269, #$926A, #$926B, #$926C, #$926D,
      #$926E, #$926F, #$9270, #$9271, #$9272, #$9273, #$9275, #$9276,
      #$9277, #$9278, #$9279, #$927A, #$927B, #$927C, #$927D, #$927E,
      #$927F, #$9280, #$9281, #$9282, #$9283, #$9284, #$9285, #$9286,
      #$9287, #$9288, #$9289, #$928A, #$928B, #$928C, #$928D, #$928F,
      #$9290, #$9291, #$9292, #$9293, #$9294, #$9295, #$9296, #$9297,
      #$9298, #$9299, #$929A, #$929B, #$929C, #$929D, #$929E, #$929F,
      #$92A0, #$92A1, #$92A2, #$92A3, #$92A4, #$92A5, #$92A6, #$92A7,
      #$92A8, #$92A9, #$92AA, #$92AB, #$92AC, #$92AD, #$92AF, #$92B0,
      #$92B1, #$92B2, #$92B3, #$92B4, #$92B5, #$92B6, #$92B7, #$92B8,
      #$92B9, #$92BA, #$92BB, #$92BC, #$92BD, #$92BE, #$92BF, #$92C0,
      #$92C1, #$92C2, #$92C3, #$92C4, #$92C5, #$92C6, #$92C7, #$92C9,
      #$92CA, #$92CB, #$92CC, #$92CD, #$92CE, #$92CF, #$92D0, #$92D1,
      #$92D2, #$92D3, #$92D4, #$92D5, #$92D6, #$92D7, #$92D8, #$92D9,
      #$92DA, #$92DB, #$92DC, #$92DD, #$92DE, #$92DF, #$92E0, #$92E1,
      #$92E2, #$92E3, #$92E4, #$92E5, #$92E6, #$92E7, #$92E8, #$92E9,
      #$92EA, #$92EB, #$92EC, #$92ED, #$92EE, #$92EF, #$92F0, #$92F1,
      #$92F2, #$92F3, #$92F4, #$92F5, #$92F6, #$92F7, #$92F8, #$92F9,
      #$92FA, #$92FB, #$92FC, #$92FD, #$92FE, #$92FF, #$9300, #$9301,
      #$9302, #$9303, #$9304, #$9305, #$9306, #$9307, #$9308, #$9309,
      #$930A, #$930B, #$930C, #$930D, #$930E, #$930F, #$9310, #$9311,
      #$9312, #$9313, #$9314, #$9315, #$9316, #$9317, #$9318, #$9319,
      #$931A, #$931B, #$931C, #$931D, #$931E, #$931F, #$9320, #$9321,
      #$9322, #$9323, #$9324, #$9325, #$9326, #$9327, #$9328, #$9329,
      #$932A, #$932B, #$932C, #$932D, #$932E, #$932F, #$9330, #$9331,
      #$9332, #$9333, #$9334, #$9335, #$9336, #$9337, #$9338, #$9339,
      #$933A, #$933B, #$933C, #$933D, #$933F, #$9340, #$9341, #$9342,
      #$9343, #$9344, #$9345, #$9346, #$9347, #$9348, #$9349, #$934A,
      #$934B, #$934C, #$934D, #$934E, #$934F, #$9350, #$9351, #$9352,
      #$9353, #$9354, #$9355, #$9356, #$9357, #$9358, #$9359, #$935A,
      #$935B, #$935C, #$935D, #$935E, #$935F, #$9360, #$9361, #$9362,
      #$9363, #$9364, #$9365, #$9366, #$9367, #$9368, #$9369, #$936B,
      #$936C, #$936D, #$936E, #$936F, #$9370, #$9371, #$9372, #$9373,
      #$9374, #$9375, #$9376, #$9377, #$9378, #$9379, #$937A, #$937B,
      #$937C, #$937D, #$937E, #$937F, #$9380, #$9381, #$9382, #$9383,
      #$9384, #$9385, #$9386, #$9387, #$9388, #$9389, #$938A, #$938B,
      #$938C, #$938D, #$938E, #$9390, #$9391, #$9392, #$9393, #$9394,
      #$9395, #$9396, #$9397, #$9398, #$9399, #$939A, #$939B, #$939C,
      #$939D, #$939E, #$939F, #$93A0, #$93A1, #$93A2, #$93A3, #$93A4,
      #$93A5, #$93A6, #$93A7, #$93A8, #$93A9, #$93AA, #$93AB, #$93AC,
      #$93AD, #$93AE, #$93AF, #$93B0, #$93B1, #$93B2, #$93B3, #$93B4,
      #$93B5, #$93B6, #$93B7, #$93B8, #$93B9, #$93BA, #$93BB, #$93BC,
      #$93BD, #$93BE, #$93BF, #$93C0, #$93C1, #$93C2, #$93C3, #$93C4,
      #$93C5, #$93C6, #$93C7, #$93C8, #$93C9, #$93CB, #$93CC, #$93CD,
      #$93CE, #$93CF, #$93D0, #$93D1, #$93D2, #$93D3, #$93D4, #$93D5,
      #$93D7, #$93D8, #$93D9, #$93DA, #$93DB, #$93DC, #$93DD, #$93DE,
      #$93DF, #$93E0, #$93E1, #$93E2, #$93E3, #$93E4, #$93E5, #$93E6,
      #$93E7, #$93E8, #$93E9, #$93EA, #$93EB, #$93EC, #$93ED, #$93EE,
      #$93EF, #$93F0, #$93F1, #$93F2, #$93F3, #$93F4, #$93F5, #$93F6,
      #$93F7, #$93F8, #$93F9, #$93FA, #$93FB, #$93FC, #$93FD, #$93FE,
      #$93FF, #$9400, #$9401, #$9402, #$9403, #$9404, #$9405, #$9406,
      #$9407, #$9408, #$9409, #$940A, #$940B, #$940C, #$940D, #$940E,
      #$940F, #$9410, #$9411, #$9412, #$9413, #$9414, #$9415, #$9416,
      #$9417, #$9418, #$9419, #$941A, #$941B, #$941C, #$941D, #$941E,
      #$941F, #$9420, #$9421, #$9422, #$9423, #$9424, #$9425, #$9426,
      #$9427, #$9428, #$9429, #$942A, #$942B, #$942C, #$942D, #$942E,
      #$942F, #$9430, #$9431, #$9432, #$9433, #$9434, #$9435, #$9436,
      #$9437, #$9438, #$9439, #$943A, #$943B, #$943C, #$943D, #$943F,
      #$9440, #$9441, #$9442, #$9443, #$9444, #$9445, #$9446, #$9447,
      #$9448, #$9449, #$944A, #$944B, #$944C, #$944D, #$944E, #$944F,
      #$9450, #$9451, #$9452, #$9453, #$9454, #$9455, #$9456, #$9457,
      #$9458, #$9459, #$945A, #$945B, #$945C, #$945D, #$945E, #$945F,
      #$9460, #$9461, #$9462, #$9463, #$9464, #$9465, #$9466, #$9467,
      #$9468, #$9469, #$946A, #$946C, #$946D, #$946E, #$946F, #$9470,
      #$9471, #$9472, #$9473, #$9474, #$9475, #$9476, #$9477, #$9478,
      #$9479, #$947A, #$947B, #$947C, #$947D, #$947E, #$947F, #$9480,
      #$9481, #$9482, #$9483, #$9484, #$9491, #$9496, #$9498, #$94C7,
      #$94CF, #$94D3, #$94D4, #$94DA, #$94E6, #$94FB, #$951C, #$9520,
      #$9527, #$9533, #$953D, #$9543, #$9548, #$954B, #$9555, #$955A,
      #$9560, #$956E, #$9574, #$9575, #$9577, #$9578, #$9579, #$957A,
      #$957B, #$957C, #$957D, #$957E, #$9580, #$9581, #$9582, #$9583,
      #$9584, #$9585, #$9586, #$9587, #$9588, #$9589, #$958A, #$958B,
      #$958C, #$958D, #$958E, #$958F, #$9590, #$9591, #$9592, #$9593,
      #$9594, #$9595, #$9596, #$9597, #$9598, #$9599, #$959A, #$959B,
      #$959C, #$959D, #$959E, #$959F, #$95A0, #$95A1, #$95A2, #$95A3,
      #$95A4, #$95A5, #$95A6, #$95A7, #$95A8, #$95A9, #$95AA, #$95AB,
      #$95AC, #$95AD, #$95AE, #$95AF, #$95B0, #$95B1, #$95B2, #$95B3,
      #$95B4, #$95B5, #$95B6, #$95B7, #$95B8, #$95B9, #$95BA, #$95BB,
      #$95BC, #$95BD, #$95BE, #$95BF, #$95C0, #$95C1, #$95C2, #$95C3,
      #$95C4, #$95C5, #$95C6, #$95C7, #$95C8, #$95C9, #$95CA, #$95CB,
      #$95CC, #$95CD, #$95CE, #$95CF, #$95D0, #$95D1, #$95D2, #$95D3,
      #$95D4, #$95D5, #$95D6, #$95D7, #$95D8, #$95D9, #$95DA, #$95DB,
      #$95DC, #$95DD, #$95DE, #$95DF, #$95E0, #$95E1, #$95E2, #$95E3,
      #$95E4, #$95E5, #$95E6, #$95E7, #$95EC, #$95FF, #$9607, #$9613,
      #$9618, #$961B, #$961E, #$9620, #$9623, #$9624, #$9625, #$9626,
      #$9627, #$9628, #$9629, #$962B, #$962C, #$962D, #$962F, #$9630,
      #$9637, #$9638, #$9639, #$963A, #$963E, #$9641, #$9643, #$964A,
      #$964E, #$964F, #$9651, #$9652, #$9653, #$9656, #$9657, #$9658,
      #$9659, #$965A, #$965C, #$965D, #$965E, #$9660, #$9663, #$9665,
      #$9666, #$966B, #$966D, #$966E, #$966F, #$9670, #$9671, #$9673,
      #$9678, #$9679, #$967A, #$967B, #$967C, #$967D, #$967E, #$967F,
      #$9680, #$9681, #$9682, #$9683, #$9684, #$9687, #$9689, #$968A,
      #$968C, #$968E, #$9691, #$9692, #$9693, #$9695, #$9696, #$969A,
      #$969B, #$969D, #$969E, #$969F, #$96A0, #$96A1, #$96A2, #$96A3,
      #$96A4, #$96A5, #$96A6, #$96A8, #$96A9, #$96AA, #$96AB, #$96AC,
      #$96AD, #$96AE, #$96AF, #$96B1, #$96B2, #$96B4, #$96B5, #$96B7,
      #$96B8, #$96BA, #$96BB, #$96BF, #$96C2, #$96C3, #$96C8, #$96CA,
      #$96CB, #$96D0, #$96D1, #$96D3, #$96D4, #$96D6, #$96D7, #$96D8,
      #$96D9, #$96DA, #$96DB, #$96DC, #$96DD, #$96DE, #$96DF, #$96E1,
      #$96E2, #$96E3, #$96E4, #$96E5, #$96E6, #$96E7, #$96EB, #$96EC,
      #$96ED, #$96EE, #$96F0, #$96F1, #$96F2, #$96F4, #$96F5, #$96F8,
      #$96FA, #$96FB, #$96FC, #$96FD, #$96FF, #$9702, #$9703, #$9705,
      #$970A, #$970B, #$970C, #$9710, #$9711, #$9712, #$9714, #$9715,
      #$9717, #$9718, #$9719, #$971A, #$971B, #$971D, #$971F, #$9720,
      #$9721, #$9722, #$9723, #$9724, #$9725, #$9726, #$9727, #$9728,
      #$9729, #$972B, #$972C, #$972E, #$972F, #$9731, #$9733, #$9734,
      #$9735, #$9736, #$9737, #$973A, #$973B, #$973C, #$973D, #$973F,
      #$9740, #$9741, #$9742, #$9743, #$9744, #$9745, #$9746, #$9747,
      #$9748, #$9749, #$974A, #$974B, #$974C, #$974D, #$974E, #$974F,
      #$9750, #$9751, #$9754, #$9755, #$9757, #$9758, #$975A, #$975C,
      #$975D, #$975F, #$9763, #$9764, #$9766, #$9767, #$9768, #$976A,
      #$976B, #$976C, #$976D, #$976E, #$976F, #$9770, #$9771, #$9772,
      #$9775, #$9777, #$9778, #$9779, #$977A, #$977B, #$977D, #$977E,
      #$977F, #$9780, #$9781, #$9782, #$9783, #$9784, #$9786, #$9787,
      #$9788, #$9789, #$978A, #$978C, #$978E, #$978F, #$9790, #$9793,
      #$9795, #$9796, #$9797, #$9799, #$979A, #$979B, #$979C, #$979D,
      #$979E, #$979F, #$97A1, #$97A2, #$97A4, #$97A5, #$97A6, #$97A7,
      #$97A8, #$97A9, #$97AA, #$97AC, #$97AE, #$97B0, #$97B1, #$97B3,
      #$97B5, #$97B6, #$97B7, #$97B8, #$97B9, #$97BA, #$97BB, #$97BC,
      #$97BD, #$97BE, #$97BF, #$97C0, #$97C1, #$97C2, #$97C3, #$97C4,
      #$97C5, #$97C6, #$97C7, #$97C8, #$97C9, #$97CA, #$97CB, #$97CC,
      #$97CD, #$97CE, #$97CF, #$97D0, #$97D1, #$97D2, #$97D3, #$97D4,
      #$97D5, #$97D6, #$97D7, #$97D8, #$97D9, #$97DA, #$97DB, #$97DC,
      #$97DD, #$97DE, #$97DF, #$97E0, #$97E1, #$97E2, #$97E3, #$97E4,
      #$97E5, #$97E8, #$97EE, #$97EF, #$97F0, #$97F1, #$97F2, #$97F4,
      #$97F7, #$97F8, #$97F9, #$97FA, #$97FB, #$97FC, #$97FD, #$97FE,
      #$97FF, #$9800, #$9801, #$9802, #$9803, #$9804, #$9805, #$9806,
      #$9807, #$9808, #$9809, #$980A, #$980B, #$980C, #$980D, #$980E,
      #$980F, #$9810, #$9811, #$9812, #$9813, #$9814, #$9815, #$9816,
      #$9817, #$9818, #$9819, #$981A, #$981B, #$981C, #$981D, #$981E,
      #$981F, #$9820, #$9821, #$9822, #$9823, #$9824, #$9825, #$9826,
      #$9827, #$9828, #$9829, #$982A, #$982B, #$982C, #$982D, #$982E,
      #$982F, #$9830, #$9831, #$9832, #$9833, #$9834, #$9835, #$9836,
      #$9837, #$9838, #$9839, #$983A, #$983B, #$983C, #$983D, #$983E,
      #$983F, #$9840, #$9841, #$9842, #$9843, #$9844, #$9845, #$9846,
      #$9847, #$9848, #$9849, #$984A, #$984B, #$984C, #$984D, #$984E,
      #$984F, #$9850, #$9851, #$9852, #$9853, #$9854, #$9855, #$9856,
      #$9857, #$9858, #$9859, #$985A, #$985B, #$985C, #$985D, #$985E,
      #$985F, #$9860, #$9861, #$9862, #$9863, #$9864, #$9865, #$9866,
      #$9867, #$9868, #$9869, #$986A, #$986B, #$986C, #$986D, #$986E,
      #$986F, #$9870, #$9871, #$9872, #$9873, #$9874, #$988B, #$988E,
      #$9892, #$9895, #$9899, #$98A3, #$98A8, #$98A9, #$98AA, #$98AB,
      #$98AC, #$98AD, #$98AE, #$98AF, #$98B0, #$98B1, #$98B2, #$98B3,
      #$98B4, #$98B5, #$98B6, #$98B7, #$98B8, #$98B9, #$98BA, #$98BB,
      #$98BC, #$98BD, #$98BE, #$98BF, #$98C0, #$98C1, #$98C2, #$98C3,
      #$98C4, #$98C5, #$98C6, #$98C7, #$98C8, #$98C9, #$98CA, #$98CB,
      #$98CC, #$98CD, #$98CF, #$98D0, #$98D4, #$98D6, #$98D7, #$98DB,
      #$98DC, #$98DD, #$98E0, #$98E1, #$98E2, #$98E3, #$98E4, #$98E5,
      #$98E6, #$98E9, #$98EA, #$98EB, #$98EC, #$98ED, #$98EE, #$98EF,
      #$98F0, #$98F1, #$98F2, #$98F3, #$98F4, #$98F5, #$98F6, #$98F7,
      #$98F8, #$98F9, #$98FA, #$98FB, #$98FC, #$98FD, #$98FE, #$98FF,
      #$9900, #$9901, #$9902, #$9903, #$9904, #$9905, #$9906, #$9907,
      #$9908, #$9909, #$990A, #$990B, #$990C, #$990E, #$990F, #$9911,
      #$9912, #$9913, #$9914, #$9915, #$9916, #$9917, #$9918, #$9919,
      #$991A, #$991B, #$991C, #$991D, #$991E, #$991F, #$9920, #$9921,
      #$9922, #$9923, #$9924, #$9925, #$9926, #$9927, #$9928, #$9929,
      #$992A, #$992B, #$992C, #$992D, #$992F, #$9930, #$9931, #$9932,
      #$9933, #$9934, #$9935, #$9936, #$9937, #$9938, #$9939, #$993A,
      #$993B, #$993C, #$993D, #$993E, #$993F, #$9940, #$9941, #$9942,
      #$9943, #$9944, #$9945, #$9946, #$9947, #$9948, #$9949, #$994A,
      #$994B, #$994C, #$994D, #$994E, #$994F, #$9950, #$9951, #$9952,
      #$9953, #$9956, #$9957, #$9958, #$9959, #$995A, #$995B, #$995C,
      #$995D, #$995E, #$995F, #$9960, #$9961, #$9962, #$9964, #$9966,
      #$9973, #$9978, #$9979, #$997B, #$997E, #$9982, #$9983, #$9989,
      #$998C, #$998E, #$999A, #$999B, #$999C, #$999D, #$999E, #$999F,
      #$99A0, #$99A1, #$99A2, #$99A3, #$99A4, #$99A6, #$99A7, #$99A9,
      #$99AA, #$99AB, #$99AC, #$99AD, #$99AE, #$99AF, #$99B0, #$99B1,
      #$99B2, #$99B3, #$99B4, #$99B5, #$99B6, #$99B7, #$99B8, #$99B9,
      #$99BA, #$99BB, #$99BC, #$99BD, #$99BE, #$99BF, #$99C0, #$99C1,
      #$99C2, #$99C3, #$99C4, #$99C5, #$99C6, #$99C7, #$99C8, #$99C9,
      #$99CA, #$99CB, #$99CC, #$99CD, #$99CE, #$99CF, #$99D0, #$99D1,
      #$99D2, #$99D3, #$99D4, #$99D5, #$99D6, #$99D7, #$99D8, #$99D9,
      #$99DA, #$99DB, #$99DC, #$99DD, #$99DE, #$99DF, #$99E0, #$99E1,
      #$99E2, #$99E3, #$99E4, #$99E5, #$99E6, #$99E7, #$99E8, #$99E9,
      #$99EA, #$99EB, #$99EC, #$99ED, #$99EE, #$99EF, #$99F0, #$99F1,
      #$99F2, #$99F3, #$99F4, #$99F5, #$99F6, #$99F7, #$99F8, #$99F9,
      #$99FA, #$99FB, #$99FC, #$99FD, #$99FE, #$99FF, #$9A00, #$9A01,
      #$9A02, #$9A03, #$9A04, #$9A05, #$9A06, #$9A07, #$9A08, #$9A09,
      #$9A0A, #$9A0B, #$9A0C, #$9A0D, #$9A0E, #$9A0F, #$9A10, #$9A11,
      #$9A12, #$9A13, #$9A14, #$9A15, #$9A16, #$9A17, #$9A18, #$9A19,
      #$9A1A, #$9A1B, #$9A1C, #$9A1D, #$9A1E, #$9A1F, #$9A20, #$9A21,
      #$9A22, #$9A23, #$9A24, #$9A25, #$9A26, #$9A27, #$9A28, #$9A29,
      #$9A2A, #$9A2B, #$9A2C, #$9A2D, #$9A2E, #$9A2F, #$9A30, #$9A31,
      #$9A32, #$9A33, #$9A34, #$9A35, #$9A36, #$9A37, #$9A38, #$9A39,
      #$9A3A, #$9A3B, #$9A3C, #$9A3D, #$9A3E, #$9A3F, #$9A40, #$9A41,
      #$9A42, #$9A43, #$9A44, #$9A45, #$9A46, #$9A47, #$9A48, #$9A49,
      #$9A4A, #$9A4B, #$9A4C, #$9A4D, #$9A4E, #$9A4F, #$9A50, #$9A51,
      #$9A52, #$9A53, #$9A54, #$9A55, #$9A56, #$9A57, #$9A58, #$9A59,
      #$9A5A, #$9A5B, #$9A5C, #$9A5D, #$9A5E, #$9A5F, #$9A60, #$9A61,
      #$9A62, #$9A63, #$9A64, #$9A65, #$9A66, #$9A67, #$9A68, #$9A69,
      #$9A6A, #$9A6B, #$9A72, #$9A83, #$9A89, #$9A8D, #$9A8E, #$9A94,
      #$9A95, #$9A99, #$9AA6, #$9AA9, #$9AAA, #$9AAB, #$9AAC, #$9AAD,
      #$9AAE, #$9AAF, #$9AB2, #$9AB3, #$9AB4, #$9AB5, #$9AB9, #$9ABB,
      #$9ABD, #$9ABE, #$9ABF, #$9AC3, #$9AC4, #$9AC6, #$9AC7, #$9AC8,
      #$9AC9, #$9ACA, #$9ACD, #$9ACE, #$9ACF, #$9AD0, #$9AD2, #$9AD4,
      #$9AD5, #$9AD6, #$9AD7, #$9AD9, #$9ADA, #$9ADB, #$9ADC, #$9ADD,
      #$9ADE, #$9AE0, #$9AE2, #$9AE3, #$9AE4, #$9AE5, #$9AE7, #$9AE8,
      #$9AE9, #$9AEA, #$9AEC, #$9AEE, #$9AF0, #$9AF1, #$9AF2, #$9AF3,
      #$9AF4, #$9AF5, #$9AF6, #$9AF7, #$9AF8, #$9AFA, #$9AFC, #$9AFD,
      #$9AFE, #$9AFF, #$9B00, #$9B01, #$9B02, #$9B04, #$9B05, #$9B06,
      #$9B07, #$9B09, #$9B0A, #$9B0B, #$9B0C, #$9B0D, #$9B0E, #$9B10,
      #$9B11, #$9B12, #$9B14, #$9B15, #$9B16, #$9B17, #$9B18, #$9B19,
      #$9B1A, #$9B1B, #$9B1C, #$9B1D, #$9B1E, #$9B20, #$9B21, #$9B22,
      #$9B24, #$9B25, #$9B26, #$9B27, #$9B28, #$9B29, #$9B2A, #$9B2B,
      #$9B2C, #$9B2D, #$9B2E, #$9B30, #$9B31, #$9B33, #$9B34, #$9B35,
      #$9B36, #$9B37, #$9B38, #$9B39, #$9B3A, #$9B3D, #$9B3E, #$9B3F,
      #$9B40, #$9B46, #$9B4A, #$9B4B, #$9B4C, #$9B4E, #$9B50, #$9B52,
      #$9B53, #$9B55, #$9B56, #$9B57, #$9B58, #$9B59, #$9B5A, #$9B5B,
      #$9B5C, #$9B5D, #$9B5E, #$9B5F, #$9B60, #$9B61, #$9B62, #$9B63,
      #$9B64, #$9B65, #$9B66, #$9B67, #$9B68, #$9B69, #$9B6A, #$9B6B,
      #$9B6C, #$9B6D, #$9B6E, #$9B6F, #$9B70, #$9B71, #$9B72, #$9B73,
      #$9B74, #$9B75, #$9B76, #$9B77, #$9B78, #$9B79, #$9B7A, #$9B7B,
      #$9B7C, #$9B7D, #$9B7E, #$9B7F, #$9B80, #$9B81, #$9B82, #$9B83,
      #$9B84, #$9B85, #$9B86, #$9B87, #$9B88, #$9B89, #$9B8A, #$9B8B,
      #$9B8C, #$9B8D, #$9B8E, #$9B8F, #$9B90, #$9B91, #$9B92, #$9B93,
      #$9B94, #$9B95, #$9B96, #$9B97, #$9B98, #$9B99, #$9B9A, #$9B9B,
      #$9B9C, #$9B9D, #$9B9E, #$9B9F, #$9BA0, #$9BA1, #$9BA2, #$9BA3,
      #$9BA4, #$9BA5, #$9BA6, #$9BA7, #$9BA8, #$9BA9, #$9BAA, #$9BAB,
      #$9BAC, #$9BAD, #$9BAE, #$9BAF, #$9BB0, #$9BB1, #$9BB2, #$9BB3,
      #$9BB4, #$9BB5, #$9BB6, #$9BB7, #$9BB8, #$9BB9, #$9BBA, #$9BBB,
      #$9BBC, #$9BBD, #$9BBE, #$9BBF, #$9BC0, #$9BC1, #$9BC2, #$9BC3,
      #$9BC4, #$9BC5, #$9BC6, #$9BC7, #$9BC8, #$9BC9, #$9BCA, #$9BCB,
      #$9BCC, #$9BCD, #$9BCE, #$9BCF, #$9BD0, #$9BD1, #$9BD2, #$9BD3,
      #$9BD4, #$9BD5, #$9BD6, #$9BD7, #$9BD8, #$9BD9, #$9BDA, #$9BDB,
      #$9BDC, #$9BDD, #$9BDE, #$9BDF, #$9BE0, #$9BE1, #$9BE2, #$9BE3,
      #$9BE4, #$9BE5, #$9BE6, #$9BE7, #$9BE8, #$9BE9, #$9BEA, #$9BEB,
      #$9BEC, #$9BED, #$9BEE, #$9BEF, #$9BF0, #$9BF1, #$9BF2, #$9BF3,
      #$9BF4, #$9BF5, #$9BF6, #$9BF7, #$9BF8, #$9BF9, #$9BFA, #$9BFB,
      #$9BFC, #$9BFD, #$9BFE, #$9BFF, #$9C00, #$9C01, #$9C02, #$9C03,
      #$9C04, #$9C05, #$9C06, #$9C07, #$9C08, #$9C09, #$9C0A, #$9C0B,
      #$9C0C, #$9C0D, #$9C0E, #$9C0F, #$9C10, #$9C11, #$9C12, #$9C13,
      #$9C14, #$9C15, #$9C16, #$9C17, #$9C18, #$9C19, #$9C1A, #$9C1B,
      #$9C1C, #$9C1D, #$9C1E, #$9C1F, #$9C20, #$9C21, #$9C22, #$9C23,
      #$9C24, #$9C25, #$9C26, #$9C27, #$9C28, #$9C29, #$9C2A, #$9C2B,
      #$9C2C, #$9C2D, #$9C2E, #$9C2F, #$9C30, #$9C31, #$9C32, #$9C33,
      #$9C34, #$9C35, #$9C36, #$9C37, #$9C38, #$9C39, #$9C3A, #$9C3B,
      #$9C3C, #$9C3D, #$9C3E, #$9C3F, #$9C40, #$9C41, #$9C42, #$9C43,
      #$9C44, #$9C45, #$9C46, #$9C47, #$9C48, #$9C49, #$9C4A, #$9C4B,
      #$9C4C, #$9C4D, #$9C4E, #$9C4F, #$9C50, #$9C51, #$9C52, #$9C53,
      #$9C54, #$9C55, #$9C56, #$9C57, #$9C58, #$9C59, #$9C5A, #$9C5B,
      #$9C5C, #$9C5D, #$9C5E, #$9C5F, #$9C60, #$9C61, #$9C62, #$9C63,
      #$9C64, #$9C65, #$9C66, #$9C67, #$9C68, #$9C69, #$9C6A, #$9C6B,
      #$9C6C, #$9C6D, #$9C6E, #$9C6F, #$9C70, #$9C71, #$9C72, #$9C73,
      #$9C74, #$9C75, #$9C76, #$9C77, #$9C78, #$9C79, #$9C7A, #$9C7B,
      #$9C7D, #$9C7E, #$9C80, #$9C83, #$9C84, #$9C89, #$9C8A, #$9C8C,
      #$9C8F, #$9C93, #$9C96, #$9C97, #$9C98, #$9C99, #$9C9D, #$9CAA,
      #$9CAC, #$9CAF, #$9CB9, #$9CBE, #$9CBF, #$9CC0, #$9CC1, #$9CC2,
      #$9CC8, #$9CC9, #$9CD1, #$9CD2, #$9CDA, #$9CDB, #$9CE0, #$9CE1,
      #$9CE3, #$9CE4, #$9CE5, #$9CE6, #$9CE7, #$9CE8, #$9CE9, #$9CEA,
      #$9CEB, #$9CEC, #$9CED, #$9CEE, #$9CEF, #$9CF0, #$9CF1, #$9CF2,
      #$9CF3, #$9CF4, #$9CF5, #$9CF6, #$9CF7, #$9CF8, #$9CF9, #$9CFA,
      #$9CFB, #$9CFC, #$9CFD, #$9CFE, #$9CFF, #$9D00, #$9D01, #$9D02,
      #$9D03, #$9D04, #$9D05, #$9D06, #$9D07, #$9D08, #$9D09, #$9D0A,
      #$9D0B, #$9D0C, #$9D0D, #$9D0E, #$9D0F, #$9D10, #$9D11, #$9D12,
      #$9D13, #$9D14, #$9D15, #$9D16, #$9D17, #$9D18, #$9D19, #$9D1A,
      #$9D1B, #$9D1C, #$9D1D, #$9D1E, #$9D1F, #$9D20, #$9D21, #$9D22,
      #$9D23, #$9D24, #$9D25, #$9D26, #$9D27, #$9D28, #$9D29, #$9D2A,
      #$9D2B, #$9D2C, #$9D2D, #$9D2E, #$9D2F, #$9D30, #$9D31, #$9D32,
      #$9D33, #$9D34, #$9D35, #$9D36, #$9D37, #$9D38, #$9D39, #$9D3A,
      #$9D3B, #$9D3C, #$9D3D, #$9D3E, #$9D3F, #$9D40, #$9D41, #$9D42,
      #$9D43, #$9D44, #$9D45, #$9D46, #$9D47, #$9D48, #$9D49, #$9D4A,
      #$9D4B, #$9D4C, #$9D4D, #$9D4E, #$9D4F, #$9D50, #$9D51, #$9D52,
      #$9D53, #$9D54, #$9D55, #$9D56, #$9D57, #$9D58, #$9D59, #$9D5A,
      #$9D5B, #$9D5C, #$9D5D, #$9D5E, #$9D5F, #$9D60, #$9D61, #$9D62,
      #$9D63, #$9D64, #$9D65, #$9D66, #$9D67, #$9D68, #$9D69, #$9D6A,
      #$9D6B, #$9D6C, #$9D6D, #$9D6E, #$9D6F, #$9D70, #$9D71, #$9D72,
      #$9D73, #$9D74, #$9D75, #$9D76, #$9D77, #$9D78, #$9D79, #$9D7A,
      #$9D7B, #$9D7C, #$9D7D, #$9D7E, #$9D7F, #$9D80, #$9D81, #$9D82,
      #$9D83, #$9D84, #$9D85, #$9D86, #$9D87, #$9D88, #$9D89, #$9D8A,
      #$9D8B, #$9D8C, #$9D8D, #$9D8E, #$9D8F, #$9D90, #$9D91, #$9D92,
      #$9D93, #$9D94, #$9D95, #$9D96, #$9D97, #$9D98, #$9D99, #$9D9A,
      #$9D9B, #$9D9C, #$9D9D, #$9D9E, #$9D9F, #$9DA0, #$9DA1, #$9DA2,
      #$9DA3, #$9DA4, #$9DA5, #$9DA6, #$9DA7, #$9DA8, #$9DA9, #$9DAA,
      #$9DAB, #$9DAC, #$9DAD, #$9DAE, #$9DAF, #$9DB0, #$9DB1, #$9DB2,
      #$9DB3, #$9DB4, #$9DB5, #$9DB6, #$9DB7, #$9DB8, #$9DB9, #$9DBA,
      #$9DBB, #$9DBC, #$9DBD, #$9DBE, #$9DBF, #$9DC0, #$9DC1, #$9DC2,
      #$9DC3, #$9DC4, #$9DC5, #$9DC6, #$9DC7, #$9DC8, #$9DC9, #$9DCA,
      #$9DCB, #$9DCC, #$9DCD, #$9DCE, #$9DCF, #$9DD0, #$9DD1, #$9DD2,
      #$9DD3, #$9DD4, #$9DD5, #$9DD6, #$9DD7, #$9DD8, #$9DD9, #$9DDA,
      #$9DDB, #$9DDC, #$9DDD, #$9DDE, #$9DDF, #$9DE0, #$9DE1, #$9DE2,
      #$9DE3, #$9DE4, #$9DE5, #$9DE6, #$9DE7, #$9DE8, #$9DE9, #$9DEA,
      #$9DEB, #$9DEC, #$9DED, #$9DEE, #$9DEF, #$9DF0, #$9DF1, #$9DF2,
      #$9DF3, #$9DF4, #$9DF5, #$9DF6, #$9DF7, #$9DF8, #$9DF9, #$9DFA,
      #$9DFB, #$9DFC, #$9DFD, #$9DFE, #$9DFF, #$9E00, #$9E01, #$9E02,
      #$9E03, #$9E04, #$9E05, #$9E06, #$9E07, #$9E08, #$9E09, #$9E0A,
      #$9E0B, #$9E0C, #$9E0D, #$9E0E, #$9E0F, #$9E10, #$9E11, #$9E12,
      #$9E13, #$9E14, #$9E15, #$9E16, #$9E17, #$9E18, #$9E19, #$9E1A,
      #$9E1B, #$9E1C, #$9E1D, #$9E1E, #$9E24, #$9E27, #$9E2E, #$9E30,
      #$9E34, #$9E3B, #$9E3C, #$9E40, #$9E4D, #$9E50, #$9E52, #$9E53,
      #$9E54, #$9E56, #$9E59, #$9E5D, #$9E5F, #$9E60, #$9E61, #$9E62,
      #$9E65, #$9E6E, #$9E6F, #$9E72, #$9E74, #$9E75, #$9E76, #$9E77,
      #$9E78, #$9E79, #$9E7A, #$9E7B, #$9E7C, #$9E7D, #$9E80, #$9E81,
      #$9E83, #$9E84, #$9E85, #$9E86, #$9E89, #$9E8A, #$9E8C, #$9E8D,
      #$9E8E, #$9E8F, #$9E90, #$9E91, #$9E94, #$9E95, #$9E96, #$9E97,
      #$9E98, #$9E99, #$9E9A, #$9E9B, #$9E9C, #$9E9E, #$9EA0, #$9EA1,
      #$9EA2, #$9EA3, #$9EA4, #$9EA5, #$9EA7, #$9EA8, #$9EA9, #$9EAA,
      #$9EAB, #$9EAC, #$9EAD, #$9EAE, #$9EAF, #$9EB0, #$9EB1, #$9EB2,
      #$9EB3, #$9EB5, #$9EB6, #$9EB7, #$9EB9, #$9EBA, #$9EBC, #$9EBF,
      #$9EC0, #$9EC1, #$9EC2, #$9EC3, #$9EC5, #$9EC6, #$9EC7, #$9EC8,
      #$9ECA, #$9ECB, #$9ECC, #$9ED0, #$9ED2, #$9ED3, #$9ED5, #$9ED6,
      #$9ED7, #$9ED9, #$9EDA, #$9EDE, #$9EE1, #$9EE3, #$9EE4, #$9EE6,
      #$9EE8, #$9EEB, #$9EEC, #$9EED, #$9EEE, #$9EF0, #$9EF1, #$9EF2,
      #$9EF3, #$9EF4, #$9EF5, #$9EF6, #$9EF7, #$9EF8, #$9EFA, #$9EFD,
      #$9EFF, #$9F00, #$9F01, #$9F02, #$9F03, #$9F04, #$9F05, #$9F06,
      #$9F07, #$9F08, #$9F09, #$9F0A, #$9F0C, #$9F0F, #$9F11, #$9F12,
      #$9F14, #$9F15, #$9F16, #$9F18, #$9F1A, #$9F1B, #$9F1C, #$9F1D,
      #$9F1E, #$9F1F, #$9F21, #$9F23, #$9F24, #$9F25, #$9F26, #$9F27,
      #$9F28, #$9F29, #$9F2A, #$9F2B, #$9F2D, #$9F2E, #$9F30, #$9F31,
      #$9F32, #$9F33, #$9F34, #$9F35, #$9F36, #$9F38, #$9F3A, #$9F3C,
      #$9F3F, #$9F40, #$9F41, #$9F42, #$9F43, #$9F45, #$9F46, #$9F47,
      #$9F48, #$9F49, #$9F4A, #$9F4B, #$9F4C, #$9F4D, #$9F4E, #$9F4F,
      #$9F52, #$9F53, #$9F54, #$9F55, #$9F56, #$9F57, #$9F58, #$9F59,
      #$9F5A, #$9F5B, #$9F5C, #$9F5D, #$9F5E, #$9F5F, #$9F60, #$9F61,
      #$9F62, #$9F63, #$9F64, #$9F65, #$9F66, #$9F67, #$9F68, #$9F69,
      #$9F6A, #$9F6B, #$9F6C, #$9F6D, #$9F6E, #$9F6F, #$9F70, #$9F71,
      #$9F72, #$9F73, #$9F74, #$9F75, #$9F76, #$9F77, #$9F78, #$9F79,
      #$9F7A, #$9F7B, #$9F7C, #$9F7D, #$9F7E, #$9F81, #$9F82, #$9F8D,
      #$9F8E, #$9F8F, #$9F90, #$9F91, #$9F92, #$9F93, #$9F94, #$9F95,
      #$9F96, #$9F97, #$9F98, #$9F9C, #$9F9D, #$9F9E, #$9FA1, #$9FA2,
      #$9FA3, #$9FA4, #$9FA5, #$F92C, #$F979, #$F995, #$F9E7, #$F9F1,
      #$FA0C, #$FA0D, #$FA0E, #$FA0F, #$FA11, #$FA13, #$FA14, #$FA18,
      #$FA1F, #$FA20, #$FA21, #$FA23, #$FA24, #$FA27, #$FA28, #$FA29);
  JIS_X0212_1Map: array[0..80] of TBuffChar = (
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$02D8, #$02C7,
      #$00B8, #$02D9, #$02DD, #$00AF, #$02DB, #$02DA, #$FF5E, #$0384,
      #$0385, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$00A1, #$00A6, #$00BF, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$00BA, #$00AA, #$00A9, #$00AE, #$2122, #$00A4,
      #$2116);
  JIS_X0212_2Map: array[0..187] of TBuffChar = (
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$0386, #$0388, #$0389, #$038A, #$03AA, #$FFFD, #$038C, #$FFFD,
      #$038E, #$03AB, #$FFFD, #$038F, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$03AC, #$03AD, #$03AE, #$03AF, #$03CA, #$0390, #$03CC, #$03C2,
      #$03CD, #$03CB, #$03B0, #$03CE, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$0402, #$0403, #$0404, #$0405, #$0406, #$0407, #$0408,
      #$0409, #$040A, #$040B, #$040C, #$040E, #$040F, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$0452, #$0453, #$0454, #$0455, #$0456, #$0457, #$0458,
      #$0459, #$045A, #$045B, #$045C, #$045E, #$045F);
  JIS_X0212_3Map: array[0..274] of TBuffChar = (
      #$00C6, #$0110, #$FFFD, #$0126, #$FFFD, #$0132, #$FFFD, #$0141,
      #$013F, #$FFFD, #$014A, #$00D8, #$0152, #$FFFD, #$0166, #$00DE,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$00E6, #$0111, #$00F0, #$0127, #$0131, #$0133, #$0138, #$0142,
      #$0140, #$0149, #$014B, #$00F8, #$0153, #$00DF, #$0167, #$00FE,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$00C1, #$00C0, #$00C4, #$00C2, #$0102, #$01CD, #$0100, #$0104,
      #$00C5, #$00C3, #$0106, #$0108, #$010C, #$00C7, #$010A, #$010E,
      #$00C9, #$00C8, #$00CB, #$00CA, #$011A, #$0116, #$0112, #$0118,
      #$FFFD, #$011C, #$011E, #$0122, #$0120, #$0124, #$00CD, #$00CC,
      #$00CF, #$00CE, #$01CF, #$0130, #$012A, #$012E, #$0128, #$0134,
      #$0136, #$0139, #$013D, #$013B, #$0143, #$0147, #$0145, #$00D1,
      #$00D3, #$00D2, #$00D6, #$00D4, #$01D1, #$0150, #$014C, #$00D5,
      #$0154, #$0158, #$0156, #$015A, #$015C, #$0160, #$015E, #$0164,
      #$0162, #$00DA, #$00D9, #$00DC, #$00DB, #$016C, #$01D3, #$0170,
      #$016A, #$0172, #$016E, #$0168, #$01D7, #$01DB, #$01D9, #$01D5,
      #$0174, #$00DD, #$0178, #$0176, #$0179, #$017D, #$017B, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$00E1, #$00E0, #$00E4, #$00E2, #$0103, #$01CE, #$0101, #$0105,
      #$00E5, #$00E3, #$0107, #$0109, #$010D, #$00E7, #$010B, #$010F,
      #$00E9, #$00E8, #$00EB, #$00EA, #$011B, #$0117, #$0113, #$0119,
      #$01F5, #$011D, #$011F, #$FFFD, #$0121, #$0125, #$00ED, #$00EC,
      #$00EF, #$00EE, #$01D0, #$FFFD, #$012B, #$012F, #$0129, #$0135,
      #$0137, #$013A, #$013E, #$013C, #$0144, #$0148, #$0146, #$00F1,
      #$00F3, #$00F2, #$00F6, #$00F4, #$01D2, #$0151, #$014D, #$00F5,
      #$0155, #$0159, #$0157, #$015B, #$015D, #$0161, #$015F, #$0165,
      #$0163, #$00FA, #$00F9, #$00FC, #$00FB, #$016D, #$01D4, #$0171,
      #$016B, #$0173, #$016F, #$0169, #$01D8, #$01DC, #$01DA, #$01D6,
      #$0175, #$00FD, #$00FF, #$0177, #$017A, #$017E, #$017C);
  JIS_X0212_4Map: array[0..5800] of TBuffChar = (
      #$4E02, #$4E04, #$4E05, #$4E0C, #$4E12, #$4E1F, #$4E23, #$4E24,
      #$4E28, #$4E2B, #$4E2E, #$4E2F, #$4E30, #$4E35, #$4E40, #$4E41,
      #$4E44, #$4E47, #$4E51, #$4E5A, #$4E5C, #$4E63, #$4E68, #$4E69,
      #$4E74, #$4E75, #$4E79, #$4E7F, #$4E8D, #$4E96, #$4E97, #$4E9D,
      #$4EAF, #$4EB9, #$4EC3, #$4ED0, #$4EDA, #$4EDB, #$4EE0, #$4EE1,
      #$4EE2, #$4EE8, #$4EEF, #$4EF1, #$4EF3, #$4EF5, #$4EFD, #$4EFE,
      #$4EFF, #$4F00, #$4F02, #$4F03, #$4F08, #$4F0B, #$4F0C, #$4F12,
      #$4F15, #$4F16, #$4F17, #$4F19, #$4F2E, #$4F31, #$4F60, #$4F33,
      #$4F35, #$4F37, #$4F39, #$4F3B, #$4F3E, #$4F40, #$4F42, #$4F48,
      #$4F49, #$4F4B, #$4F4C, #$4F52, #$4F54, #$4F56, #$4F58, #$4F5F,
      #$4F63, #$4F6A, #$4F6C, #$4F6E, #$4F71, #$4F77, #$4F78, #$4F79,
      #$4F7A, #$4F7D, #$4F7E, #$4F81, #$4F82, #$4F84,
      #$4F85, #$4F89, #$4F8A, #$4F8C, #$4F8E, #$4F90, #$4F92, #$4F93,
      #$4F94, #$4F97, #$4F99, #$4F9A, #$4F9E, #$4F9F, #$4FB2, #$4FB7,
      #$4FB9, #$4FBB, #$4FBC, #$4FBD, #$4FBE, #$4FC0, #$4FC1, #$4FC5,
      #$4FC6, #$4FC8, #$4FC9, #$4FCB, #$4FCC, #$4FCD, #$4FCF, #$4FD2,
      #$4FDC, #$4FE0, #$4FE2, #$4FF0, #$4FF2, #$4FFC, #$4FFD, #$4FFF,
      #$5000, #$5001, #$5004, #$5007, #$500A, #$500C, #$500E, #$5010,
      #$5013, #$5017, #$5018, #$501B, #$501C, #$501D, #$501E, #$5022,
      #$5027, #$502E, #$5030, #$5032, #$5033, #$5035, #$5040, #$5041,
      #$5042, #$5045, #$5046, #$504A, #$504C, #$504E, #$5051, #$5052,
      #$5053, #$5057, #$5059, #$505F, #$5060, #$5062, #$5063, #$5066,
      #$5067, #$506A, #$506D, #$5070, #$5071, #$503B, #$5081, #$5083,
      #$5084, #$5086, #$508A, #$508E, #$508F, #$5090,
      #$5092, #$5093, #$5094, #$5096, #$509B, #$509C, #$509E, #$509F,
      #$50A0, #$50A1, #$50A2, #$50AA, #$50AF, #$50B0, #$50B9, #$50BA,
      #$50BD, #$50C0, #$50C3, #$50C4, #$50C7, #$50CC, #$50CE, #$50D0,
      #$50D3, #$50D4, #$50D8, #$50DC, #$50DD, #$50DF, #$50E2, #$50E4,
      #$50E6, #$50E8, #$50E9, #$50EF, #$50F1, #$50F6, #$50FA, #$50FE,
      #$5103, #$5106, #$5107, #$5108, #$510B, #$510C, #$510D, #$510E,
      #$50F2, #$5110, #$5117, #$5119, #$511B, #$511C, #$511D, #$511E,
      #$5123, #$5127, #$5128, #$512C, #$512D, #$512F, #$5131, #$5133,
      #$5134, #$5135, #$5138, #$5139, #$5142, #$514A, #$514F, #$5153,
      #$5155, #$5157, #$5158, #$515F, #$5164, #$5166, #$517E, #$5183,
      #$5184, #$518B, #$518E, #$5198, #$519D, #$51A1, #$51A3, #$51AD,
      #$51B8, #$51BA, #$51BC, #$51BE, #$51BF, #$51C2,
      #$51C8, #$51CF, #$51D1, #$51D2, #$51D3, #$51D5, #$51D8, #$51DE,
      #$51E2, #$51E5, #$51EE, #$51F2, #$51F3, #$51F4, #$51F7, #$5201,
      #$5202, #$5205, #$5212, #$5213, #$5215, #$5216, #$5218, #$5222,
      #$5228, #$5231, #$5232, #$5235, #$523C, #$5245, #$5249, #$5255,
      #$5257, #$5258, #$525A, #$525C, #$525F, #$5260, #$5261, #$5266,
      #$526E, #$5277, #$5278, #$5279, #$5280, #$5282, #$5285, #$528A,
      #$528C, #$5293, #$5295, #$5296, #$5297, #$5298, #$529A, #$529C,
      #$52A4, #$52A5, #$52A6, #$52A7, #$52AF, #$52B0, #$52B6, #$52B7,
      #$52B8, #$52BA, #$52BB, #$52BD, #$52C0, #$52C4, #$52C6, #$52C8,
      #$52CC, #$52CF, #$52D1, #$52D4, #$52D6, #$52DB, #$52DC, #$52E1,
      #$52E5, #$52E8, #$52E9, #$52EA, #$52EC, #$52F0, #$52F1, #$52F4,
      #$52F6, #$52F7, #$5300, #$5303, #$530A, #$530B,
      #$530C, #$5311, #$5313, #$5318, #$531B, #$531C, #$531E, #$531F,
      #$5325, #$5327, #$5328, #$5329, #$532B, #$532C, #$532D, #$5330,
      #$5332, #$5335, #$533C, #$533D, #$533E, #$5342, #$534C, #$534B,
      #$5359, #$535B, #$5361, #$5363, #$5365, #$536C, #$536D, #$5372,
      #$5379, #$537E, #$5383, #$5387, #$5388, #$538E, #$5393, #$5394,
      #$5399, #$539D, #$53A1, #$53A4, #$53AA, #$53AB, #$53AF, #$53B2,
      #$53B4, #$53B5, #$53B7, #$53B8, #$53BA, #$53BD, #$53C0, #$53C5,
      #$53CF, #$53D2, #$53D3, #$53D5, #$53DA, #$53DD, #$53DE, #$53E0,
      #$53E6, #$53E7, #$53F5, #$5402, #$5413, #$541A, #$5421, #$5427,
      #$5428, #$542A, #$542F, #$5431, #$5434, #$5435, #$5443, #$5444,
      #$5447, #$544D, #$544F, #$545E, #$5462, #$5464, #$5466, #$5467,
      #$5469, #$546B, #$546D, #$546E, #$5474, #$547F,
      #$5481, #$5483, #$5485, #$5488, #$5489, #$548D, #$5491, #$5495,
      #$5496, #$549C, #$549F, #$54A1, #$54A6, #$54A7, #$54A9, #$54AA,
      #$54AD, #$54AE, #$54B1, #$54B7, #$54B9, #$54BA, #$54BB, #$54BF,
      #$54C6, #$54CA, #$54CD, #$54CE, #$54E0, #$54EA, #$54EC, #$54EF,
      #$54F6, #$54FC, #$54FE, #$54FF, #$5500, #$5501, #$5505, #$5508,
      #$5509, #$550C, #$550D, #$550E, #$5515, #$552A, #$552B, #$5532,
      #$5535, #$5536, #$553B, #$553C, #$553D, #$5541, #$5547, #$5549,
      #$554A, #$554D, #$5550, #$5551, #$5558, #$555A, #$555B, #$555E,
      #$5560, #$5561, #$5564, #$5566, #$557F, #$5581, #$5582, #$5586,
      #$5588, #$558E, #$558F, #$5591, #$5592, #$5593, #$5594, #$5597,
      #$55A3, #$55A4, #$55AD, #$55B2, #$55BF, #$55C1, #$55C3, #$55C6,
      #$55C9, #$55CB, #$55CC, #$55CE, #$55D1, #$55D2,
      #$55D3, #$55D7, #$55D8, #$55DB, #$55DE, #$55E2, #$55E9, #$55F6,
      #$55FF, #$5605, #$5608, #$560A, #$560D, #$560E, #$560F, #$5610,
      #$5611, #$5612, #$5619, #$562C, #$5630, #$5633, #$5635, #$5637,
      #$5639, #$563B, #$563C, #$563D, #$563F, #$5640, #$5641, #$5643,
      #$5644, #$5646, #$5649, #$564B, #$564D, #$564F, #$5654, #$565E,
      #$5660, #$5661, #$5662, #$5663, #$5666, #$5669, #$566D, #$566F,
      #$5671, #$5672, #$5675, #$5684, #$5685, #$5688, #$568B, #$568C,
      #$5695, #$5699, #$569A, #$569D, #$569E, #$569F, #$56A6, #$56A7,
      #$56A8, #$56A9, #$56AB, #$56AC, #$56AD, #$56B1, #$56B3, #$56B7,
      #$56BE, #$56C5, #$56C9, #$56CA, #$56CB, #$56CF, #$56D0, #$56CC,
      #$56CD, #$56D9, #$56DC, #$56DD, #$56DF, #$56E1, #$56E4, #$56E5,
      #$56E6, #$56E7, #$56E8, #$56F1, #$56EB, #$56ED,
      #$56F6, #$56F7, #$5701, #$5702, #$5707, #$570A, #$570C, #$5711,
      #$5715, #$571A, #$571B, #$571D, #$5720, #$5722, #$5723, #$5724,
      #$5725, #$5729, #$572A, #$572C, #$572E, #$572F, #$5733, #$5734,
      #$573D, #$573E, #$573F, #$5745, #$5746, #$574C, #$574D, #$5752,
      #$5762, #$5765, #$5767, #$5768, #$576B, #$576D, #$576E, #$576F,
      #$5770, #$5771, #$5773, #$5774, #$5775, #$5777, #$5779, #$577A,
      #$577B, #$577C, #$577E, #$5781, #$5783, #$578C, #$5794, #$5797,
      #$5799, #$579A, #$579C, #$579D, #$579E, #$579F, #$57A1, #$5795,
      #$57A7, #$57A8, #$57A9, #$57AC, #$57B8, #$57BD, #$57C7, #$57C8,
      #$57CC, #$57CF, #$57D5, #$57DD, #$57DE, #$57E4, #$57E6, #$57E7,
      #$57E9, #$57ED, #$57F0, #$57F5, #$57F6, #$57F8, #$57FD, #$57FE,
      #$57FF, #$5803, #$5804, #$5808, #$5809, #$57E1,
      #$580C, #$580D, #$581B, #$581E, #$581F, #$5820, #$5826, #$5827,
      #$582D, #$5832, #$5839, #$583F, #$5849, #$584C, #$584D, #$584F,
      #$5850, #$5855, #$585F, #$5861, #$5864, #$5867, #$5868, #$5878,
      #$587C, #$587F, #$5880, #$5881, #$5887, #$5888, #$5889, #$588A,
      #$588C, #$588D, #$588F, #$5890, #$5894, #$5896, #$589D, #$58A0,
      #$58A1, #$58A2, #$58A6, #$58A9, #$58B1, #$58B2, #$58C4, #$58BC,
      #$58C2, #$58C8, #$58CD, #$58CE, #$58D0, #$58D2, #$58D4, #$58D6,
      #$58DA, #$58DD, #$58E1, #$58E2, #$58E9, #$58F3, #$5905, #$5906,
      #$590B, #$590C, #$5912, #$5913, #$5914, #$8641, #$591D, #$5921,
      #$5923, #$5924, #$5928, #$592F, #$5930, #$5933, #$5935, #$5936,
      #$593F, #$5943, #$5946, #$5952, #$5953, #$5959, #$595B, #$595D,
      #$595E, #$595F, #$5961, #$5963, #$596B, #$596D,
      #$596F, #$5972, #$5975, #$5976, #$5979, #$597B, #$597C, #$598B,
      #$598C, #$598E, #$5992, #$5995, #$5997, #$599F, #$59A4, #$59A7,
      #$59AD, #$59AE, #$59AF, #$59B0, #$59B3, #$59B7, #$59BA, #$59BC,
      #$59C1, #$59C3, #$59C4, #$59C8, #$59CA, #$59CD, #$59D2, #$59DD,
      #$59DE, #$59DF, #$59E3, #$59E4, #$59E7, #$59EE, #$59EF, #$59F1,
      #$59F2, #$59F4, #$59F7, #$5A00, #$5A04, #$5A0C, #$5A0D, #$5A0E,
      #$5A12, #$5A13, #$5A1E, #$5A23, #$5A24, #$5A27, #$5A28, #$5A2A,
      #$5A2D, #$5A30, #$5A44, #$5A45, #$5A47, #$5A48, #$5A4C, #$5A50,
      #$5A55, #$5A5E, #$5A63, #$5A65, #$5A67, #$5A6D, #$5A77, #$5A7A,
      #$5A7B, #$5A7E, #$5A8B, #$5A90, #$5A93, #$5A96, #$5A99, #$5A9C,
      #$5A9E, #$5A9F, #$5AA0, #$5AA2, #$5AA7, #$5AAC, #$5AB1, #$5AB2,
      #$5AB3, #$5AB5, #$5AB8, #$5ABA, #$5ABB, #$5ABF,
      #$5AC4, #$5AC6, #$5AC8, #$5ACF, #$5ADA, #$5ADC, #$5AE0, #$5AE5,
      #$5AEA, #$5AEE, #$5AF5, #$5AF6, #$5AFD, #$5B00, #$5B01, #$5B08,
      #$5B17, #$5B34, #$5B19, #$5B1B, #$5B1D, #$5B21, #$5B25, #$5B2D,
      #$5B38, #$5B41, #$5B4B, #$5B4C, #$5B52, #$5B56, #$5B5E, #$5B68,
      #$5B6E, #$5B6F, #$5B7C, #$5B7D, #$5B7E, #$5B7F, #$5B81, #$5B84,
      #$5B86, #$5B8A, #$5B8E, #$5B90, #$5B91, #$5B93, #$5B94, #$5B96,
      #$5BA8, #$5BA9, #$5BAC, #$5BAD, #$5BAF, #$5BB1, #$5BB2, #$5BB7,
      #$5BBA, #$5BBC, #$5BC0, #$5BC1, #$5BCD, #$5BCF, #$5BD6, #$5BD7,
      #$5BD8, #$5BD9, #$5BDA, #$5BE0, #$5BEF, #$5BF1, #$5BF4, #$5BFD,
      #$5C0C, #$5C17, #$5C1E, #$5C1F, #$5C23, #$5C26, #$5C29, #$5C2B,
      #$5C2C, #$5C2E, #$5C30, #$5C32, #$5C35, #$5C36, #$5C59, #$5C5A,
      #$5C5C, #$5C62, #$5C63, #$5C67, #$5C68, #$5C69,
      #$5C6D, #$5C70, #$5C74, #$5C75, #$5C7A, #$5C7B, #$5C7C, #$5C7D,
      #$5C87, #$5C88, #$5C8A, #$5C8F, #$5C92, #$5C9D, #$5C9F, #$5CA0,
      #$5CA2, #$5CA3, #$5CA6, #$5CAA, #$5CB2, #$5CB4, #$5CB5, #$5CBA,
      #$5CC9, #$5CCB, #$5CD2, #$5CDD, #$5CD7, #$5CEE, #$5CF1, #$5CF2,
      #$5CF4, #$5D01, #$5D06, #$5D0D, #$5D12, #$5D2B, #$5D23, #$5D24,
      #$5D26, #$5D27, #$5D31, #$5D34, #$5D39, #$5D3D, #$5D3F, #$5D42,
      #$5D43, #$5D46, #$5D48, #$5D55, #$5D51, #$5D59, #$5D4A, #$5D5F,
      #$5D60, #$5D61, #$5D62, #$5D64, #$5D6A, #$5D6D, #$5D70, #$5D79,
      #$5D7A, #$5D7E, #$5D7F, #$5D81, #$5D83, #$5D88, #$5D8A, #$5D92,
      #$5D93, #$5D94, #$5D95, #$5D99, #$5D9B, #$5D9F, #$5DA0, #$5DA7,
      #$5DAB, #$5DB0, #$5DB4, #$5DB8, #$5DB9, #$5DC3, #$5DC7, #$5DCB,
      #$5DD0, #$5DCE, #$5DD8, #$5DD9, #$5DE0, #$5DE4,
      #$5DE9, #$5DF8, #$5DF9, #$5E00, #$5E07, #$5E0D, #$5E12, #$5E14,
      #$5E15, #$5E18, #$5E1F, #$5E20, #$5E2E, #$5E28, #$5E32, #$5E35,
      #$5E3E, #$5E4B, #$5E50, #$5E49, #$5E51, #$5E56, #$5E58, #$5E5B,
      #$5E5C, #$5E5E, #$5E68, #$5E6A, #$5E6B, #$5E6C, #$5E6D, #$5E6E,
      #$5E70, #$5E80, #$5E8B, #$5E8E, #$5EA2, #$5EA4, #$5EA5, #$5EA8,
      #$5EAA, #$5EAC, #$5EB1, #$5EB3, #$5EBD, #$5EBE, #$5EBF, #$5EC6,
      #$5ECC, #$5ECB, #$5ECE, #$5ED1, #$5ED2, #$5ED4, #$5ED5, #$5EDC,
      #$5EDE, #$5EE5, #$5EEB, #$5F02, #$5F06, #$5F07, #$5F08, #$5F0E,
      #$5F19, #$5F1C, #$5F1D, #$5F21, #$5F22, #$5F23, #$5F24, #$5F28,
      #$5F2B, #$5F2C, #$5F2E, #$5F30, #$5F34, #$5F36, #$5F3B, #$5F3D,
      #$5F3F, #$5F40, #$5F44, #$5F45, #$5F47, #$5F4D, #$5F50, #$5F54,
      #$5F58, #$5F5B, #$5F60, #$5F63, #$5F64, #$5F67,
      #$5F6F, #$5F72, #$5F74, #$5F75, #$5F78, #$5F7A, #$5F7D, #$5F7E,
      #$5F89, #$5F8D, #$5F8F, #$5F96, #$5F9C, #$5F9D, #$5FA2, #$5FA7,
      #$5FAB, #$5FA4, #$5FAC, #$5FAF, #$5FB0, #$5FB1, #$5FB8, #$5FC4,
      #$5FC7, #$5FC8, #$5FC9, #$5FCB, #$5FD0, #$5FD1, #$5FD2, #$5FD3,
      #$5FD4, #$5FDE, #$5FE1, #$5FE2, #$5FE8, #$5FE9, #$5FEA, #$5FEC,
      #$5FED, #$5FEE, #$5FEF, #$5FF2, #$5FF3, #$5FF6, #$5FFA, #$5FFC,
      #$6007, #$600A, #$600D, #$6013, #$6014, #$6017, #$6018, #$601A,
      #$601F, #$6024, #$602D, #$6033, #$6035, #$6040, #$6047, #$6048,
      #$6049, #$604C, #$6051, #$6054, #$6056, #$6057, #$605D, #$6061,
      #$6067, #$6071, #$607E, #$607F, #$6082, #$6086, #$6088, #$608A,
      #$608E, #$6091, #$6093, #$6095, #$6098, #$609D, #$609E, #$60A2,
      #$60A4, #$60A5, #$60A8, #$60B0, #$60B1, #$60B7,
      #$60BB, #$60BE, #$60C2, #$60C4, #$60C8, #$60C9, #$60CA, #$60CB,
      #$60CE, #$60CF, #$60D4, #$60D5, #$60D9, #$60DB, #$60DD, #$60DE,
      #$60E2, #$60E5, #$60F2, #$60F5, #$60F8, #$60FC, #$60FD, #$6102,
      #$6107, #$610A, #$610C, #$6110, #$6111, #$6112, #$6113, #$6114,
      #$6116, #$6117, #$6119, #$611C, #$611E, #$6122, #$612A, #$612B,
      #$6130, #$6131, #$6135, #$6136, #$6137, #$6139, #$6141, #$6145,
      #$6146, #$6149, #$615E, #$6160, #$616C, #$6172, #$6178, #$617B,
      #$617C, #$617F, #$6180, #$6181, #$6183, #$6184, #$618B, #$618D,
      #$6192, #$6193, #$6197, #$6198, #$619C, #$619D, #$619F, #$61A0,
      #$61A5, #$61A8, #$61AA, #$61AD, #$61B8, #$61B9, #$61BC, #$61C0,
      #$61C1, #$61C2, #$61CE, #$61CF, #$61D5, #$61DC, #$61DD, #$61DE,
      #$61DF, #$61E1, #$61E2, #$61E7, #$61E9, #$61E5,
      #$61EC, #$61ED, #$61EF, #$6201, #$6203, #$6204, #$6207, #$6213,
      #$6215, #$621C, #$6220, #$6222, #$6223, #$6227, #$6229, #$622B,
      #$6239, #$623D, #$6242, #$6243, #$6244, #$6246, #$624C, #$6250,
      #$6251, #$6252, #$6254, #$6256, #$625A, #$625C, #$6264, #$626D,
      #$626F, #$6273, #$627A, #$627D, #$628D, #$628E, #$628F, #$6290,
      #$62A6, #$62A8, #$62B3, #$62B6, #$62B7, #$62BA, #$62BE, #$62BF,
      #$62C4, #$62CE, #$62D5, #$62D6, #$62DA, #$62EA, #$62F2, #$62F4,
      #$62FC, #$62FD, #$6303, #$6304, #$630A, #$630B, #$630D, #$6310,
      #$6313, #$6316, #$6318, #$6329, #$632A, #$632D, #$6335, #$6336,
      #$6339, #$633C, #$6341, #$6342, #$6343, #$6344, #$6346, #$634A,
      #$634B, #$634E, #$6352, #$6353, #$6354, #$6358, #$635B, #$6365,
      #$6366, #$636C, #$636D, #$6371, #$6374, #$6375,
      #$6378, #$637C, #$637D, #$637F, #$6382, #$6384, #$6387, #$638A,
      #$6390, #$6394, #$6395, #$6399, #$639A, #$639E, #$63A4, #$63A6,
      #$63AD, #$63AE, #$63AF, #$63BD, #$63C1, #$63C5, #$63C8, #$63CE,
      #$63D1, #$63D3, #$63D4, #$63D5, #$63DC, #$63E0, #$63E5, #$63EA,
      #$63EC, #$63F2, #$63F3, #$63F5, #$63F8, #$63F9, #$6409, #$640A,
      #$6410, #$6412, #$6414, #$6418, #$641E, #$6420, #$6422, #$6424,
      #$6425, #$6429, #$642A, #$642F, #$6430, #$6435, #$643D, #$643F,
      #$644B, #$644F, #$6451, #$6452, #$6453, #$6454, #$645A, #$645B,
      #$645C, #$645D, #$645F, #$6460, #$6461, #$6463, #$646D, #$6473,
      #$6474, #$647B, #$647D, #$6485, #$6487, #$648F, #$6490, #$6491,
      #$6498, #$6499, #$649B, #$649D, #$649F, #$64A1, #$64A3, #$64A6,
      #$64A8, #$64AC, #$64B3, #$64BD, #$64BE, #$64BF,
      #$64C4, #$64C9, #$64CA, #$64CB, #$64CC, #$64CE, #$64D0, #$64D1,
      #$64D5, #$64D7, #$64E4, #$64E5, #$64E9, #$64EA, #$64ED, #$64F0,
      #$64F5, #$64F7, #$64FB, #$64FF, #$6501, #$6504, #$6508, #$6509,
      #$650A, #$650F, #$6513, #$6514, #$6516, #$6519, #$651B, #$651E,
      #$651F, #$6522, #$6526, #$6529, #$652E, #$6531, #$653A, #$653C,
      #$653D, #$6543, #$6547, #$6549, #$6550, #$6552, #$6554, #$655F,
      #$6560, #$6567, #$656B, #$657A, #$657D, #$6581, #$6585, #$658A,
      #$6592, #$6595, #$6598, #$659D, #$65A0, #$65A3, #$65A6, #$65AE,
      #$65B2, #$65B3, #$65B4, #$65BF, #$65C2, #$65C8, #$65C9, #$65CE,
      #$65D0, #$65D4, #$65D6, #$65D8, #$65DF, #$65F0, #$65F2, #$65F4,
      #$65F5, #$65F9, #$65FE, #$65FF, #$6600, #$6604, #$6608, #$6609,
      #$660D, #$6611, #$6612, #$6615, #$6616, #$661D,
      #$661E, #$6621, #$6622, #$6623, #$6624, #$6626, #$6629, #$662A,
      #$662B, #$662C, #$662E, #$6630, #$6631, #$6633, #$6639, #$6637,
      #$6640, #$6645, #$6646, #$664A, #$664C, #$6651, #$664E, #$6657,
      #$6658, #$6659, #$665B, #$665C, #$6660, #$6661, #$66FB, #$666A,
      #$666B, #$666C, #$667E, #$6673, #$6675, #$667F, #$6677, #$6678,
      #$6679, #$667B, #$6680, #$667C, #$668B, #$668C, #$668D, #$6690,
      #$6692, #$6699, #$669A, #$669B, #$669C, #$669F, #$66A0, #$66A4,
      #$66AD, #$66B1, #$66B2, #$66B5, #$66BB, #$66BF, #$66C0, #$66C2,
      #$66C3, #$66C8, #$66CC, #$66CE, #$66CF, #$66D4, #$66DB, #$66DF,
      #$66E8, #$66EB, #$66EC, #$66EE, #$66FA, #$6705, #$6707, #$670E,
      #$6713, #$6719, #$671C, #$6720, #$6722, #$6733, #$673E, #$6745,
      #$6747, #$6748, #$674C, #$6754, #$6755, #$675D,
      #$6766, #$676C, #$676E, #$6774, #$6776, #$677B, #$6781, #$6784,
      #$678E, #$678F, #$6791, #$6793, #$6796, #$6798, #$6799, #$679B,
      #$67B0, #$67B1, #$67B2, #$67B5, #$67BB, #$67BC, #$67BD, #$67F9,
      #$67C0, #$67C2, #$67C3, #$67C5, #$67C8, #$67C9, #$67D2, #$67D7,
      #$67D9, #$67DC, #$67E1, #$67E6, #$67F0, #$67F2, #$67F6, #$67F7,
      #$6852, #$6814, #$6819, #$681D, #$681F, #$6828, #$6827, #$682C,
      #$682D, #$682F, #$6830, #$6831, #$6833, #$683B, #$683F, #$6844,
      #$6845, #$684A, #$684C, #$6855, #$6857, #$6858, #$685B, #$686B,
      #$686E, #$686F, #$6870, #$6871, #$6872, #$6875, #$6879, #$687A,
      #$687B, #$687C, #$6882, #$6884, #$6886, #$6888, #$6896, #$6898,
      #$689A, #$689C, #$68A1, #$68A3, #$68A5, #$68A9, #$68AA, #$68AE,
      #$68B2, #$68BB, #$68C5, #$68C8, #$68CC, #$68CF,
      #$68D0, #$68D1, #$68D3, #$68D6, #$68D9, #$68DC, #$68DD, #$68E5,
      #$68E8, #$68EA, #$68EB, #$68EC, #$68ED, #$68F0, #$68F1, #$68F5,
      #$68F6, #$68FB, #$68FC, #$68FD, #$6906, #$6909, #$690A, #$6910,
      #$6911, #$6913, #$6916, #$6917, #$6931, #$6933, #$6935, #$6938,
      #$693B, #$6942, #$6945, #$6949, #$694E, #$6957, #$695B, #$6963,
      #$6964, #$6965, #$6966, #$6968, #$6969, #$696C, #$6970, #$6971,
      #$6972, #$697A, #$697B, #$697F, #$6980, #$698D, #$6992, #$6996,
      #$6998, #$69A1, #$69A5, #$69A6, #$69A8, #$69AB, #$69AD, #$69AF,
      #$69B7, #$69B8, #$69BA, #$69BC, #$69C5, #$69C8, #$69D1, #$69D6,
      #$69D7, #$69E2, #$69E5, #$69EE, #$69EF, #$69F1, #$69F3, #$69F5,
      #$69FE, #$6A00, #$6A01, #$6A03, #$6A0F, #$6A11, #$6A15, #$6A1A,
      #$6A1D, #$6A20, #$6A24, #$6A28, #$6A30, #$6A32,
      #$6A34, #$6A37, #$6A3B, #$6A3E, #$6A3F, #$6A45, #$6A46, #$6A49,
      #$6A4A, #$6A4E, #$6A50, #$6A51, #$6A52, #$6A55, #$6A56, #$6A5B,
      #$6A64, #$6A67, #$6A6A, #$6A71, #$6A73, #$6A7E, #$6A81, #$6A83,
      #$6A86, #$6A87, #$6A89, #$6A8B, #$6A91, #$6A9B, #$6A9D, #$6A9E,
      #$6A9F, #$6AA5, #$6AAB, #$6AAF, #$6AB0, #$6AB1, #$6AB4, #$6ABD,
      #$6ABE, #$6ABF, #$6AC6, #$6AC9, #$6AC8, #$6ACC, #$6AD0, #$6AD4,
      #$6AD5, #$6AD6, #$6ADC, #$6ADD, #$6AE4, #$6AE7, #$6AEC, #$6AF0,
      #$6AF1, #$6AF2, #$6AFC, #$6AFD, #$6B02, #$6B03, #$6B06, #$6B07,
      #$6B09, #$6B0F, #$6B10, #$6B11, #$6B17, #$6B1B, #$6B1E, #$6B24,
      #$6B28, #$6B2B, #$6B2C, #$6B2F, #$6B35, #$6B36, #$6B3B, #$6B3F,
      #$6B46, #$6B4A, #$6B4D, #$6B52, #$6B56, #$6B58, #$6B5D, #$6B60,
      #$6B67, #$6B6B, #$6B6E, #$6B70, #$6B75, #$6B7D,
      #$6B7E, #$6B82, #$6B85, #$6B97, #$6B9B, #$6B9F, #$6BA0, #$6BA2,
      #$6BA3, #$6BA8, #$6BA9, #$6BAC, #$6BAD, #$6BAE, #$6BB0, #$6BB8,
      #$6BB9, #$6BBD, #$6BBE, #$6BC3, #$6BC4, #$6BC9, #$6BCC, #$6BD6,
      #$6BDA, #$6BE1, #$6BE3, #$6BE6, #$6BE7, #$6BEE, #$6BF1, #$6BF7,
      #$6BF9, #$6BFF, #$6C02, #$6C04, #$6C05, #$6C09, #$6C0D, #$6C0E,
      #$6C10, #$6C12, #$6C19, #$6C1F, #$6C26, #$6C27, #$6C28, #$6C2C,
      #$6C2E, #$6C33, #$6C35, #$6C36, #$6C3A, #$6C3B, #$6C3F, #$6C4A,
      #$6C4B, #$6C4D, #$6C4F, #$6C52, #$6C54, #$6C59, #$6C5B, #$6C5C,
      #$6C6B, #$6C6D, #$6C6F, #$6C74, #$6C76, #$6C78, #$6C79, #$6C7B,
      #$6C85, #$6C86, #$6C87, #$6C89, #$6C94, #$6C95, #$6C97, #$6C98,
      #$6C9C, #$6C9F, #$6CB0, #$6CB2, #$6CB4, #$6CC2, #$6CC6, #$6CCD,
      #$6CCF, #$6CD0, #$6CD1, #$6CD2, #$6CD4, #$6CD6,
      #$6CDA, #$6CDC, #$6CE0, #$6CE7, #$6CE9, #$6CEB, #$6CEC, #$6CEE,
      #$6CF2, #$6CF4, #$6D04, #$6D07, #$6D0A, #$6D0E, #$6D0F, #$6D11,
      #$6D13, #$6D1A, #$6D26, #$6D27, #$6D28, #$6C67, #$6D2E, #$6D2F,
      #$6D31, #$6D39, #$6D3C, #$6D3F, #$6D57, #$6D5E, #$6D5F, #$6D61,
      #$6D65, #$6D67, #$6D6F, #$6D70, #$6D7C, #$6D82, #$6D87, #$6D91,
      #$6D92, #$6D94, #$6D96, #$6D97, #$6D98, #$6DAA, #$6DAC, #$6DB4,
      #$6DB7, #$6DB9, #$6DBD, #$6DBF, #$6DC4, #$6DC8, #$6DCA, #$6DCE,
      #$6DCF, #$6DD6, #$6DDB, #$6DDD, #$6DDF, #$6DE0, #$6DE2, #$6DE5,
      #$6DE9, #$6DEF, #$6DF0, #$6DF4, #$6DF6, #$6DFC, #$6E00, #$6E04,
      #$6E1E, #$6E22, #$6E27, #$6E32, #$6E36, #$6E39, #$6E3B, #$6E3C,
      #$6E44, #$6E45, #$6E48, #$6E49, #$6E4B, #$6E4F, #$6E51, #$6E52,
      #$6E53, #$6E54, #$6E57, #$6E5C, #$6E5D, #$6E5E,
      #$6E62, #$6E63, #$6E68, #$6E73, #$6E7B, #$6E7D, #$6E8D, #$6E93,
      #$6E99, #$6EA0, #$6EA7, #$6EAD, #$6EAE, #$6EB1, #$6EB3, #$6EBB,
      #$6EBF, #$6EC0, #$6EC1, #$6EC3, #$6EC7, #$6EC8, #$6ECA, #$6ECD,
      #$6ECE, #$6ECF, #$6EEB, #$6EED, #$6EEE, #$6EF9, #$6EFB, #$6EFD,
      #$6F04, #$6F08, #$6F0A, #$6F0C, #$6F0D, #$6F16, #$6F18, #$6F1A,
      #$6F1B, #$6F26, #$6F29, #$6F2A, #$6F2F, #$6F30, #$6F33, #$6F36,
      #$6F3B, #$6F3C, #$6F2D, #$6F4F, #$6F51, #$6F52, #$6F53, #$6F57,
      #$6F59, #$6F5A, #$6F5D, #$6F5E, #$6F61, #$6F62, #$6F68, #$6F6C,
      #$6F7D, #$6F7E, #$6F83, #$6F87, #$6F88, #$6F8B, #$6F8C, #$6F8D,
      #$6F90, #$6F92, #$6F93, #$6F94, #$6F96, #$6F9A, #$6F9F, #$6FA0,
      #$6FA5, #$6FA6, #$6FA7, #$6FA8, #$6FAE, #$6FAF, #$6FB0, #$6FB5,
      #$6FB6, #$6FBC, #$6FC5, #$6FC7, #$6FC8, #$6FCA,
      #$6FDA, #$6FDE, #$6FE8, #$6FE9, #$6FF0, #$6FF5, #$6FF9, #$6FFC,
      #$6FFD, #$7000, #$7005, #$7006, #$7007, #$700D, #$7017, #$7020,
      #$7023, #$702F, #$7034, #$7037, #$7039, #$703C, #$7043, #$7044,
      #$7048, #$7049, #$704A, #$704B, #$7054, #$7055, #$705D, #$705E,
      #$704E, #$7064, #$7065, #$706C, #$706E, #$7075, #$7076, #$707E,
      #$7081, #$7085, #$7086, #$7094, #$7095, #$7096, #$7097, #$7098,
      #$709B, #$70A4, #$70AB, #$70B0, #$70B1, #$70B4, #$70B7, #$70CA,
      #$70D1, #$70D3, #$70D4, #$70D5, #$70D6, #$70D8, #$70DC, #$70E4,
      #$70FA, #$7103, #$7104, #$7105, #$7106, #$7107, #$710B, #$710C,
      #$710F, #$711E, #$7120, #$712B, #$712D, #$712F, #$7130, #$7131,
      #$7138, #$7141, #$7145, #$7146, #$7147, #$714A, #$714B, #$7150,
      #$7152, #$7157, #$715A, #$715C, #$715E, #$7160,
      #$7168, #$7179, #$7180, #$7185, #$7187, #$718C, #$7192, #$719A,
      #$719B, #$71A0, #$71A2, #$71AF, #$71B0, #$71B2, #$71B3, #$71BA,
      #$71BF, #$71C0, #$71C1, #$71C4, #$71CB, #$71CC, #$71D3, #$71D6,
      #$71D9, #$71DA, #$71DC, #$71F8, #$71FE, #$7200, #$7207, #$7208,
      #$7209, #$7213, #$7217, #$721A, #$721D, #$721F, #$7224, #$722B,
      #$722F, #$7234, #$7238, #$7239, #$7241, #$7242, #$7243, #$7245,
      #$724E, #$724F, #$7250, #$7253, #$7255, #$7256, #$725A, #$725C,
      #$725E, #$7260, #$7263, #$7268, #$726B, #$726E, #$726F, #$7271,
      #$7277, #$7278, #$727B, #$727C, #$727F, #$7284, #$7289, #$728D,
      #$728E, #$7293, #$729B, #$72A8, #$72AD, #$72AE, #$72B1, #$72B4,
      #$72BE, #$72C1, #$72C7, #$72C9, #$72CC, #$72D5, #$72D6, #$72D8,
      #$72DF, #$72E5, #$72F3, #$72F4, #$72FA, #$72FB,
      #$72FE, #$7302, #$7304, #$7305, #$7307, #$730B, #$730D, #$7312,
      #$7313, #$7318, #$7319, #$731E, #$7322, #$7324, #$7327, #$7328,
      #$732C, #$7331, #$7332, #$7335, #$733A, #$733B, #$733D, #$7343,
      #$734D, #$7350, #$7352, #$7356, #$7358, #$735D, #$735E, #$735F,
      #$7360, #$7366, #$7367, #$7369, #$736B, #$736C, #$736E, #$736F,
      #$7371, #$7377, #$7379, #$737C, #$7380, #$7381, #$7383, #$7385,
      #$7386, #$738E, #$7390, #$7393, #$7395, #$7397, #$7398, #$739C,
      #$739E, #$739F, #$73A0, #$73A2, #$73A5, #$73A6, #$73AA, #$73AB,
      #$73AD, #$73B5, #$73B7, #$73B9, #$73BC, #$73BD, #$73BF, #$73C5,
      #$73C6, #$73C9, #$73CB, #$73CC, #$73CF, #$73D2, #$73D3, #$73D6,
      #$73D9, #$73DD, #$73E1, #$73E3, #$73E6, #$73E7, #$73E9, #$73F4,
      #$73F5, #$73F7, #$73F9, #$73FA, #$73FB, #$73FD,
      #$73FF, #$7400, #$7401, #$7404, #$7407, #$740A, #$7411, #$741A,
      #$741B, #$7424, #$7426, #$7428, #$7429, #$742A, #$742B, #$742C,
      #$742D, #$742E, #$742F, #$7430, #$7431, #$7439, #$7440, #$7443,
      #$7444, #$7446, #$7447, #$744B, #$744D, #$7451, #$7452, #$7457,
      #$745D, #$7462, #$7466, #$7467, #$7468, #$746B, #$746D, #$746E,
      #$7471, #$7472, #$7480, #$7481, #$7485, #$7486, #$7487, #$7489,
      #$748F, #$7490, #$7491, #$7492, #$7498, #$7499, #$749A, #$749C,
      #$749F, #$74A0, #$74A1, #$74A3, #$74A6, #$74A8, #$74A9, #$74AA,
      #$74AB, #$74AE, #$74AF, #$74B1, #$74B2, #$74B5, #$74B9, #$74BB,
      #$74BF, #$74C8, #$74C9, #$74CC, #$74D0, #$74D3, #$74D8, #$74DA,
      #$74DB, #$74DE, #$74DF, #$74E4, #$74E8, #$74EA, #$74EB, #$74EF,
      #$74F4, #$74FA, #$74FB, #$74FC, #$74FF, #$7506,
      #$7512, #$7516, #$7517, #$7520, #$7521, #$7524, #$7527, #$7529,
      #$752A, #$752F, #$7536, #$7539, #$753D, #$753E, #$753F, #$7540,
      #$7543, #$7547, #$7548, #$754E, #$7550, #$7552, #$7557, #$755E,
      #$755F, #$7561, #$756F, #$7571, #$7579, #$757A, #$757B, #$757C,
      #$757D, #$757E, #$7581, #$7585, #$7590, #$7592, #$7593, #$7595,
      #$7599, #$759C, #$75A2, #$75A4, #$75B4, #$75BA, #$75BF, #$75C0,
      #$75C1, #$75C4, #$75C6, #$75CC, #$75CE, #$75CF, #$75D7, #$75DC,
      #$75DF, #$75E0, #$75E1, #$75E4, #$75E7, #$75EC, #$75EE, #$75EF,
      #$75F1, #$75F9, #$7600, #$7602, #$7603, #$7604, #$7607, #$7608,
      #$760A, #$760C, #$760F, #$7612, #$7613, #$7615, #$7616, #$7619,
      #$761B, #$761C, #$761D, #$761E, #$7623, #$7625, #$7626, #$7629,
      #$762D, #$7632, #$7633, #$7635, #$7638, #$7639,
      #$763A, #$763C, #$764A, #$7640, #$7641, #$7643, #$7644, #$7645,
      #$7649, #$764B, #$7655, #$7659, #$765F, #$7664, #$7665, #$766D,
      #$766E, #$766F, #$7671, #$7674, #$7681, #$7685, #$768C, #$768D,
      #$7695, #$769B, #$769C, #$769D, #$769F, #$76A0, #$76A2, #$76A3,
      #$76A4, #$76A5, #$76A6, #$76A7, #$76A8, #$76AA, #$76AD, #$76BD,
      #$76C1, #$76C5, #$76C9, #$76CB, #$76CC, #$76CE, #$76D4, #$76D9,
      #$76E0, #$76E6, #$76E8, #$76EC, #$76F0, #$76F1, #$76F6, #$76F9,
      #$76FC, #$7700, #$7706, #$770A, #$770E, #$7712, #$7714, #$7715,
      #$7717, #$7719, #$771A, #$771C, #$7722, #$7728, #$772D, #$772E,
      #$772F, #$7734, #$7735, #$7736, #$7739, #$773D, #$773E, #$7742,
      #$7745, #$7746, #$774A, #$774D, #$774E, #$774F, #$7752, #$7756,
      #$7757, #$775C, #$775E, #$775F, #$7760, #$7762,
      #$7764, #$7767, #$776A, #$776C, #$7770, #$7772, #$7773, #$7774,
      #$777A, #$777D, #$7780, #$7784, #$778C, #$778D, #$7794, #$7795,
      #$7796, #$779A, #$779F, #$77A2, #$77A7, #$77AA, #$77AE, #$77AF,
      #$77B1, #$77B5, #$77BE, #$77C3, #$77C9, #$77D1, #$77D2, #$77D5,
      #$77D9, #$77DE, #$77DF, #$77E0, #$77E4, #$77E6, #$77EA, #$77EC,
      #$77F0, #$77F1, #$77F4, #$77F8, #$77FB, #$7805, #$7806, #$7809,
      #$780D, #$780E, #$7811, #$781D, #$7821, #$7822, #$7823, #$782D,
      #$782E, #$7830, #$7835, #$7837, #$7843, #$7844, #$7847, #$7848,
      #$784C, #$784E, #$7852, #$785C, #$785E, #$7860, #$7861, #$7863,
      #$7864, #$7868, #$786A, #$786E, #$787A, #$787E, #$788A, #$788F,
      #$7894, #$7898, #$78A1, #$789D, #$789E, #$789F, #$78A4, #$78A8,
      #$78AC, #$78AD, #$78B0, #$78B1, #$78B2, #$78B3,
      #$78BB, #$78BD, #$78BF, #$78C7, #$78C8, #$78C9, #$78CC, #$78CE,
      #$78D2, #$78D3, #$78D5, #$78D6, #$78E4, #$78DB, #$78DF, #$78E0,
      #$78E1, #$78E6, #$78EA, #$78F2, #$78F3, #$7900, #$78F6, #$78F7,
      #$78FA, #$78FB, #$78FF, #$7906, #$790C, #$7910, #$791A, #$791C,
      #$791E, #$791F, #$7920, #$7925, #$7927, #$7929, #$792D, #$7931,
      #$7934, #$7935, #$793B, #$793D, #$793F, #$7944, #$7945, #$7946,
      #$794A, #$794B, #$794F, #$7951, #$7954, #$7958, #$795B, #$795C,
      #$7967, #$7969, #$796B, #$7972, #$7979, #$797B, #$797C, #$797E,
      #$798B, #$798C, #$7991, #$7993, #$7994, #$7995, #$7996, #$7998,
      #$799B, #$799C, #$79A1, #$79A8, #$79A9, #$79AB, #$79AF, #$79B1,
      #$79B4, #$79B8, #$79BB, #$79C2, #$79C4, #$79C7, #$79C8, #$79CA,
      #$79CF, #$79D4, #$79D6, #$79DA, #$79DD, #$79DE,
      #$79E0, #$79E2, #$79E5, #$79EA, #$79EB, #$79ED, #$79F1, #$79F8,
      #$79FC, #$7A02, #$7A03, #$7A07, #$7A09, #$7A0A, #$7A0C, #$7A11,
      #$7A15, #$7A1B, #$7A1E, #$7A21, #$7A27, #$7A2B, #$7A2D, #$7A2F,
      #$7A30, #$7A34, #$7A35, #$7A38, #$7A39, #$7A3A, #$7A44, #$7A45,
      #$7A47, #$7A48, #$7A4C, #$7A55, #$7A56, #$7A59, #$7A5C, #$7A5D,
      #$7A5F, #$7A60, #$7A65, #$7A67, #$7A6A, #$7A6D, #$7A75, #$7A78,
      #$7A7E, #$7A80, #$7A82, #$7A85, #$7A86, #$7A8A, #$7A8B, #$7A90,
      #$7A91, #$7A94, #$7A9E, #$7AA0, #$7AA3, #$7AAC, #$7AB3, #$7AB5,
      #$7AB9, #$7ABB, #$7ABC, #$7AC6, #$7AC9, #$7ACC, #$7ACE, #$7AD1,
      #$7ADB, #$7AE8, #$7AE9, #$7AEB, #$7AEC, #$7AF1, #$7AF4, #$7AFB,
      #$7AFD, #$7AFE, #$7B07, #$7B14, #$7B1F, #$7B23, #$7B27, #$7B29,
      #$7B2A, #$7B2B, #$7B2D, #$7B2E, #$7B2F, #$7B30,
      #$7B31, #$7B34, #$7B3D, #$7B3F, #$7B40, #$7B41, #$7B47, #$7B4E,
      #$7B55, #$7B60, #$7B64, #$7B66, #$7B69, #$7B6A, #$7B6D, #$7B6F,
      #$7B72, #$7B73, #$7B77, #$7B84, #$7B89, #$7B8E, #$7B90, #$7B91,
      #$7B96, #$7B9B, #$7B9E, #$7BA0, #$7BA5, #$7BAC, #$7BAF, #$7BB0,
      #$7BB2, #$7BB5, #$7BB6, #$7BBA, #$7BBB, #$7BBC, #$7BBD, #$7BC2,
      #$7BC5, #$7BC8, #$7BCA, #$7BD4, #$7BD6, #$7BD7, #$7BD9, #$7BDA,
      #$7BDB, #$7BE8, #$7BEA, #$7BF2, #$7BF4, #$7BF5, #$7BF8, #$7BF9,
      #$7BFA, #$7BFC, #$7BFE, #$7C01, #$7C02, #$7C03, #$7C04, #$7C06,
      #$7C09, #$7C0B, #$7C0C, #$7C0E, #$7C0F, #$7C19, #$7C1B, #$7C20,
      #$7C25, #$7C26, #$7C28, #$7C2C, #$7C31, #$7C33, #$7C34, #$7C36,
      #$7C39, #$7C3A, #$7C46, #$7C4A, #$7C55, #$7C51, #$7C52, #$7C53,
      #$7C59, #$7C5A, #$7C5B, #$7C5C, #$7C5D, #$7C5E,
      #$7C61, #$7C63, #$7C67, #$7C69, #$7C6D, #$7C6E, #$7C70, #$7C72,
      #$7C79, #$7C7C, #$7C7D, #$7C86, #$7C87, #$7C8F, #$7C94, #$7C9E,
      #$7CA0, #$7CA6, #$7CB0, #$7CB6, #$7CB7, #$7CBA, #$7CBB, #$7CBC,
      #$7CBF, #$7CC4, #$7CC7, #$7CC8, #$7CC9, #$7CCD, #$7CCF, #$7CD3,
      #$7CD4, #$7CD5, #$7CD7, #$7CD9, #$7CDA, #$7CDD, #$7CE6, #$7CE9,
      #$7CEB, #$7CF5, #$7D03, #$7D07, #$7D08, #$7D09, #$7D0F, #$7D11,
      #$7D12, #$7D13, #$7D16, #$7D1D, #$7D1E, #$7D23, #$7D26, #$7D2A,
      #$7D2D, #$7D31, #$7D3C, #$7D3D, #$7D3E, #$7D40, #$7D41, #$7D47,
      #$7D48, #$7D4D, #$7D51, #$7D53, #$7D57, #$7D59, #$7D5A, #$7D5C,
      #$7D5D, #$7D65, #$7D67, #$7D6A, #$7D70, #$7D78, #$7D7A, #$7D7B,
      #$7D7F, #$7D81, #$7D82, #$7D83, #$7D85, #$7D86, #$7D88, #$7D8B,
      #$7D8C, #$7D8D, #$7D91, #$7D96, #$7D97, #$7D9D,
      #$7D9E, #$7DA6, #$7DA7, #$7DAA, #$7DB3, #$7DB6, #$7DB7, #$7DB9,
      #$7DC2, #$7DC3, #$7DC4, #$7DC5, #$7DC6, #$7DCC, #$7DCD, #$7DCE,
      #$7DD7, #$7DD9, #$7E00, #$7DE2, #$7DE5, #$7DE6, #$7DEA, #$7DEB,
      #$7DED, #$7DF1, #$7DF5, #$7DF6, #$7DF9, #$7DFA, #$7E08, #$7E10,
      #$7E11, #$7E15, #$7E17, #$7E1C, #$7E1D, #$7E20, #$7E27, #$7E28,
      #$7E2C, #$7E2D, #$7E2F, #$7E33, #$7E36, #$7E3F, #$7E44, #$7E45,
      #$7E47, #$7E4E, #$7E50, #$7E52, #$7E58, #$7E5F, #$7E61, #$7E62,
      #$7E65, #$7E6B, #$7E6E, #$7E6F, #$7E73, #$7E78, #$7E7E, #$7E81,
      #$7E86, #$7E87, #$7E8A, #$7E8D, #$7E91, #$7E95, #$7E98, #$7E9A,
      #$7E9D, #$7E9E, #$7F3C, #$7F3B, #$7F3D, #$7F3E, #$7F3F, #$7F43,
      #$7F44, #$7F47, #$7F4F, #$7F52, #$7F53, #$7F5B, #$7F5C, #$7F5D,
      #$7F61, #$7F63, #$7F64, #$7F65, #$7F66, #$7F6D,
      #$7F71, #$7F7D, #$7F7E, #$7F7F, #$7F80, #$7F8B, #$7F8D, #$7F8F,
      #$7F90, #$7F91, #$7F96, #$7F97, #$7F9C, #$7FA1, #$7FA2, #$7FA6,
      #$7FAA, #$7FAD, #$7FB4, #$7FBC, #$7FBF, #$7FC0, #$7FC3, #$7FC8,
      #$7FCE, #$7FCF, #$7FDB, #$7FDF, #$7FE3, #$7FE5, #$7FE8, #$7FEC,
      #$7FEE, #$7FEF, #$7FF2, #$7FFA, #$7FFD, #$7FFE, #$7FFF, #$8007,
      #$8008, #$800A, #$800D, #$800E, #$800F, #$8011, #$8013, #$8014,
      #$8016, #$801D, #$801E, #$801F, #$8020, #$8024, #$8026, #$802C,
      #$802E, #$8030, #$8034, #$8035, #$8037, #$8039, #$803A, #$803C,
      #$803E, #$8040, #$8044, #$8060, #$8064, #$8066, #$806D, #$8071,
      #$8075, #$8081, #$8088, #$808E, #$809C, #$809E, #$80A6, #$80A7,
      #$80AB, #$80B8, #$80B9, #$80C8, #$80CD, #$80CF, #$80D2, #$80D4,
      #$80D5, #$80D7, #$80D8, #$80E0, #$80ED, #$80EE,
      #$80F0, #$80F2, #$80F3, #$80F6, #$80F9, #$80FA, #$80FE, #$8103,
      #$810B, #$8116, #$8117, #$8118, #$811C, #$811E, #$8120, #$8124,
      #$8127, #$812C, #$8130, #$8135, #$813A, #$813C, #$8145, #$8147,
      #$814A, #$814C, #$8152, #$8157, #$8160, #$8161, #$8167, #$8168,
      #$8169, #$816D, #$816F, #$8177, #$8181, #$8190, #$8184, #$8185,
      #$8186, #$818B, #$818E, #$8196, #$8198, #$819B, #$819E, #$81A2,
      #$81AE, #$81B2, #$81B4, #$81BB, #$81CB, #$81C3, #$81C5, #$81CA,
      #$81CE, #$81CF, #$81D5, #$81D7, #$81DB, #$81DD, #$81DE, #$81E1,
      #$81E4, #$81EB, #$81EC, #$81F0, #$81F1, #$81F2, #$81F5, #$81F6,
      #$81F8, #$81F9, #$81FD, #$81FF, #$8200, #$8203, #$820F, #$8213,
      #$8214, #$8219, #$821A, #$821D, #$8221, #$8222, #$8228, #$8232,
      #$8234, #$823A, #$8243, #$8244, #$8245, #$8246,
      #$824B, #$824E, #$824F, #$8251, #$8256, #$825C, #$8260, #$8263,
      #$8267, #$826D, #$8274, #$827B, #$827D, #$827F, #$8280, #$8281,
      #$8283, #$8284, #$8287, #$8289, #$828A, #$828E, #$8291, #$8294,
      #$8296, #$8298, #$829A, #$829B, #$82A0, #$82A1, #$82A3, #$82A4,
      #$82A7, #$82A8, #$82A9, #$82AA, #$82AE, #$82B0, #$82B2, #$82B4,
      #$82B7, #$82BA, #$82BC, #$82BE, #$82BF, #$82C6, #$82D0, #$82D5,
      #$82DA, #$82E0, #$82E2, #$82E4, #$82E8, #$82EA, #$82ED, #$82EF,
      #$82F6, #$82F7, #$82FD, #$82FE, #$8300, #$8301, #$8307, #$8308,
      #$830A, #$830B, #$8354, #$831B, #$831D, #$831E, #$831F, #$8321,
      #$8322, #$832C, #$832D, #$832E, #$8330, #$8333, #$8337, #$833A,
      #$833C, #$833D, #$8342, #$8343, #$8344, #$8347, #$834D, #$834E,
      #$8351, #$8355, #$8356, #$8357, #$8370, #$8378,
      #$837D, #$837F, #$8380, #$8382, #$8384, #$8386, #$838D, #$8392,
      #$8394, #$8395, #$8398, #$8399, #$839B, #$839C, #$839D, #$83A6,
      #$83A7, #$83A9, #$83AC, #$83BE, #$83BF, #$83C0, #$83C7, #$83C9,
      #$83CF, #$83D0, #$83D1, #$83D4, #$83DD, #$8353, #$83E8, #$83EA,
      #$83F6, #$83F8, #$83F9, #$83FC, #$8401, #$8406, #$840A, #$840F,
      #$8411, #$8415, #$8419, #$83AD, #$842F, #$8439, #$8445, #$8447,
      #$8448, #$844A, #$844D, #$844F, #$8451, #$8452, #$8456, #$8458,
      #$8459, #$845A, #$845C, #$8460, #$8464, #$8465, #$8467, #$846A,
      #$8470, #$8473, #$8474, #$8476, #$8478, #$847C, #$847D, #$8481,
      #$8485, #$8492, #$8493, #$8495, #$849E, #$84A6, #$84A8, #$84A9,
      #$84AA, #$84AF, #$84B1, #$84B4, #$84BA, #$84BD, #$84BE, #$84C0,
      #$84C2, #$84C7, #$84C8, #$84CC, #$84CF, #$84D3,
      #$84DC, #$84E7, #$84EA, #$84EF, #$84F0, #$84F1, #$84F2, #$84F7,
      #$8532, #$84FA, #$84FB, #$84FD, #$8502, #$8503, #$8507, #$850C,
      #$850E, #$8510, #$851C, #$851E, #$8522, #$8523, #$8524, #$8525,
      #$8527, #$852A, #$852B, #$852F, #$8533, #$8534, #$8536, #$853F,
      #$8546, #$854F, #$8550, #$8551, #$8552, #$8553, #$8556, #$8559,
      #$855C, #$855D, #$855E, #$855F, #$8560, #$8561, #$8562, #$8564,
      #$856B, #$856F, #$8579, #$857A, #$857B, #$857D, #$857F, #$8581,
      #$8585, #$8586, #$8589, #$858B, #$858C, #$858F, #$8593, #$8598,
      #$859D, #$859F, #$85A0, #$85A2, #$85A5, #$85A7, #$85B4, #$85B6,
      #$85B7, #$85B8, #$85BC, #$85BD, #$85BE, #$85BF, #$85C2, #$85C7,
      #$85CA, #$85CB, #$85CE, #$85AD, #$85D8, #$85DA, #$85DF, #$85E0,
      #$85E6, #$85E8, #$85ED, #$85F3, #$85F6, #$85FC,
      #$85FF, #$8600, #$8604, #$8605, #$860D, #$860E, #$8610, #$8611,
      #$8612, #$8618, #$8619, #$861B, #$861E, #$8621, #$8627, #$8629,
      #$8636, #$8638, #$863A, #$863C, #$863D, #$8640, #$8642, #$8646,
      #$8652, #$8653, #$8656, #$8657, #$8658, #$8659, #$865D, #$8660,
      #$8661, #$8662, #$8663, #$8664, #$8669, #$866C, #$866F, #$8675,
      #$8676, #$8677, #$867A, #$868D, #$8691, #$8696, #$8698, #$869A,
      #$869C, #$86A1, #$86A6, #$86A7, #$86A8, #$86AD, #$86B1, #$86B3,
      #$86B4, #$86B5, #$86B7, #$86B8, #$86B9, #$86BF, #$86C0, #$86C1,
      #$86C3, #$86C5, #$86D1, #$86D2, #$86D5, #$86D7, #$86DA, #$86DC,
      #$86E0, #$86E3, #$86E5, #$86E7, #$8688, #$86FA, #$86FC, #$86FD,
      #$8704, #$8705, #$8707, #$870B, #$870E, #$870F, #$8710, #$8713,
      #$8714, #$8719, #$871E, #$871F, #$8721, #$8723,
      #$8728, #$872E, #$872F, #$8731, #$8732, #$8739, #$873A, #$873C,
      #$873D, #$873E, #$8740, #$8743, #$8745, #$874D, #$8758, #$875D,
      #$8761, #$8764, #$8765, #$876F, #$8771, #$8772, #$877B, #$8783,
      #$8784, #$8785, #$8786, #$8787, #$8788, #$8789, #$878B, #$878C,
      #$8790, #$8793, #$8795, #$8797, #$8798, #$8799, #$879E, #$87A0,
      #$87A3, #$87A7, #$87AC, #$87AD, #$87AE, #$87B1, #$87B5, #$87BE,
      #$87BF, #$87C1, #$87C8, #$87C9, #$87CA, #$87CE, #$87D5, #$87D6,
      #$87D9, #$87DA, #$87DC, #$87DF, #$87E2, #$87E3, #$87E4, #$87EA,
      #$87EB, #$87ED, #$87F1, #$87F3, #$87F8, #$87FA, #$87FF, #$8801,
      #$8803, #$8806, #$8809, #$880A, #$880B, #$8810, #$8819, #$8812,
      #$8813, #$8814, #$8818, #$881A, #$881B, #$881C, #$881E, #$881F,
      #$8828, #$882D, #$882E, #$8830, #$8832, #$8835,
      #$883A, #$883C, #$8841, #$8843, #$8845, #$8848, #$8849, #$884A,
      #$884B, #$884E, #$8851, #$8855, #$8856, #$8858, #$885A, #$885C,
      #$885F, #$8860, #$8864, #$8869, #$8871, #$8879, #$887B, #$8880,
      #$8898, #$889A, #$889B, #$889C, #$889F, #$88A0, #$88A8, #$88AA,
      #$88BA, #$88BD, #$88BE, #$88C0, #$88CA, #$88CB, #$88CC, #$88CD,
      #$88CE, #$88D1, #$88D2, #$88D3, #$88DB, #$88DE, #$88E7, #$88EF,
      #$88F0, #$88F1, #$88F5, #$88F7, #$8901, #$8906, #$890D, #$890E,
      #$890F, #$8915, #$8916, #$8918, #$8919, #$891A, #$891C, #$8920,
      #$8926, #$8927, #$8928, #$8930, #$8931, #$8932, #$8935, #$8939,
      #$893A, #$893E, #$8940, #$8942, #$8945, #$8946, #$8949, #$894F,
      #$8952, #$8957, #$895A, #$895B, #$895C, #$8961, #$8962, #$8963,
      #$896B, #$896E, #$8970, #$8973, #$8975, #$897A,
      #$897B, #$897C, #$897D, #$8989, #$898D, #$8990, #$8994, #$8995,
      #$899B, #$899C, #$899F, #$89A0, #$89A5, #$89B0, #$89B4, #$89B5,
      #$89B6, #$89B7, #$89BC, #$89D4, #$89D5, #$89D6, #$89D7, #$89D8,
      #$89E5, #$89E9, #$89EB, #$89ED, #$89F1, #$89F3, #$89F6, #$89F9,
      #$89FD, #$89FF, #$8A04, #$8A05, #$8A07, #$8A0F, #$8A11, #$8A12,
      #$8A14, #$8A15, #$8A1E, #$8A20, #$8A22, #$8A24, #$8A26, #$8A2B,
      #$8A2C, #$8A2F, #$8A35, #$8A37, #$8A3D, #$8A3E, #$8A40, #$8A43,
      #$8A45, #$8A47, #$8A49, #$8A4D, #$8A4E, #$8A53, #$8A56, #$8A57,
      #$8A58, #$8A5C, #$8A5D, #$8A61, #$8A65, #$8A67, #$8A75, #$8A76,
      #$8A77, #$8A79, #$8A7A, #$8A7B, #$8A7E, #$8A7F, #$8A80, #$8A83,
      #$8A86, #$8A8B, #$8A8F, #$8A90, #$8A92, #$8A96, #$8A97, #$8A99,
      #$8A9F, #$8AA7, #$8AA9, #$8AAE, #$8AAF, #$8AB3,
      #$8AB6, #$8AB7, #$8ABB, #$8ABE, #$8AC3, #$8AC6, #$8AC8, #$8AC9,
      #$8ACA, #$8AD1, #$8AD3, #$8AD4, #$8AD5, #$8AD7, #$8ADD, #$8ADF,
      #$8AEC, #$8AF0, #$8AF4, #$8AF5, #$8AF6, #$8AFC, #$8AFF, #$8B05,
      #$8B06, #$8B0B, #$8B11, #$8B1C, #$8B1E, #$8B1F, #$8B0A, #$8B2D,
      #$8B30, #$8B37, #$8B3C, #$8B42, #$8B43, #$8B44, #$8B45, #$8B46,
      #$8B48, #$8B52, #$8B53, #$8B54, #$8B59, #$8B4D, #$8B5E, #$8B63,
      #$8B6D, #$8B76, #$8B78, #$8B79, #$8B7C, #$8B7E, #$8B81, #$8B84,
      #$8B85, #$8B8B, #$8B8D, #$8B8F, #$8B94, #$8B95, #$8B9C, #$8B9E,
      #$8B9F, #$8C38, #$8C39, #$8C3D, #$8C3E, #$8C45, #$8C47, #$8C49,
      #$8C4B, #$8C4F, #$8C51, #$8C53, #$8C54, #$8C57, #$8C58, #$8C5B,
      #$8C5D, #$8C59, #$8C63, #$8C64, #$8C66, #$8C68, #$8C69, #$8C6D,
      #$8C73, #$8C75, #$8C76, #$8C7B, #$8C7E, #$8C86,
      #$8C87, #$8C8B, #$8C90, #$8C92, #$8C93, #$8C99, #$8C9B, #$8C9C,
      #$8CA4, #$8CB9, #$8CBA, #$8CC5, #$8CC6, #$8CC9, #$8CCB, #$8CCF,
      #$8CD6, #$8CD5, #$8CD9, #$8CDD, #$8CE1, #$8CE8, #$8CEC, #$8CEF,
      #$8CF0, #$8CF2, #$8CF5, #$8CF7, #$8CF8, #$8CFE, #$8CFF, #$8D01,
      #$8D03, #$8D09, #$8D12, #$8D17, #$8D1B, #$8D65, #$8D69, #$8D6C,
      #$8D6E, #$8D7F, #$8D82, #$8D84, #$8D88, #$8D8D, #$8D90, #$8D91,
      #$8D95, #$8D9E, #$8D9F, #$8DA0, #$8DA6, #$8DAB, #$8DAC, #$8DAF,
      #$8DB2, #$8DB5, #$8DB7, #$8DB9, #$8DBB, #$8DC0, #$8DC5, #$8DC6,
      #$8DC7, #$8DC8, #$8DCA, #$8DCE, #$8DD1, #$8DD4, #$8DD5, #$8DD7,
      #$8DD9, #$8DE4, #$8DE5, #$8DE7, #$8DEC, #$8DF0, #$8DBC, #$8DF1,
      #$8DF2, #$8DF4, #$8DFD, #$8E01, #$8E04, #$8E05, #$8E06, #$8E0B,
      #$8E11, #$8E14, #$8E16, #$8E20, #$8E21, #$8E22,
      #$8E23, #$8E26, #$8E27, #$8E31, #$8E33, #$8E36, #$8E37, #$8E38,
      #$8E39, #$8E3D, #$8E40, #$8E41, #$8E4B, #$8E4D, #$8E4E, #$8E4F,
      #$8E54, #$8E5B, #$8E5C, #$8E5D, #$8E5E, #$8E61, #$8E62, #$8E69,
      #$8E6C, #$8E6D, #$8E6F, #$8E70, #$8E71, #$8E79, #$8E7A, #$8E7B,
      #$8E82, #$8E83, #$8E89, #$8E90, #$8E92, #$8E95, #$8E9A, #$8E9B,
      #$8E9D, #$8E9E, #$8EA2, #$8EA7, #$8EA9, #$8EAD, #$8EAE, #$8EB3,
      #$8EB5, #$8EBA, #$8EBB, #$8EC0, #$8EC1, #$8EC3, #$8EC4, #$8EC7,
      #$8ECF, #$8ED1, #$8ED4, #$8EDC, #$8EE8, #$8EEE, #$8EF0, #$8EF1,
      #$8EF7, #$8EF9, #$8EFA, #$8EED, #$8F00, #$8F02, #$8F07, #$8F08,
      #$8F0F, #$8F10, #$8F16, #$8F17, #$8F18, #$8F1E, #$8F20, #$8F21,
      #$8F23, #$8F25, #$8F27, #$8F28, #$8F2C, #$8F2D, #$8F2E, #$8F34,
      #$8F35, #$8F36, #$8F37, #$8F3A, #$8F40, #$8F41,
      #$8F43, #$8F47, #$8F4F, #$8F51, #$8F52, #$8F53, #$8F54, #$8F55,
      #$8F58, #$8F5D, #$8F5E, #$8F65, #$8F9D, #$8FA0, #$8FA1, #$8FA4,
      #$8FA5, #$8FA6, #$8FB5, #$8FB6, #$8FB8, #$8FBE, #$8FC0, #$8FC1,
      #$8FC6, #$8FCA, #$8FCB, #$8FCD, #$8FD0, #$8FD2, #$8FD3, #$8FD5,
      #$8FE0, #$8FE3, #$8FE4, #$8FE8, #$8FEE, #$8FF1, #$8FF5, #$8FF6,
      #$8FFB, #$8FFE, #$9002, #$9004, #$9008, #$900C, #$9018, #$901B,
      #$9028, #$9029, #$902F, #$902A, #$902C, #$902D, #$9033, #$9034,
      #$9037, #$903F, #$9043, #$9044, #$904C, #$905B, #$905D, #$9062,
      #$9066, #$9067, #$906C, #$9070, #$9074, #$9079, #$9085, #$9088,
      #$908B, #$908C, #$908E, #$9090, #$9095, #$9097, #$9098, #$9099,
      #$909B, #$90A0, #$90A1, #$90A2, #$90A5, #$90B0, #$90B2, #$90B3,
      #$90B4, #$90B6, #$90BD, #$90CC, #$90BE, #$90C3,
      #$90C4, #$90C5, #$90C7, #$90C8, #$90D5, #$90D7, #$90D8, #$90D9,
      #$90DC, #$90DD, #$90DF, #$90E5, #$90D2, #$90F6, #$90EB, #$90EF,
      #$90F0, #$90F4, #$90FE, #$90FF, #$9100, #$9104, #$9105, #$9106,
      #$9108, #$910D, #$9110, #$9114, #$9116, #$9117, #$9118, #$911A,
      #$911C, #$911E, #$9120, #$9125, #$9122, #$9123, #$9127, #$9129,
      #$912E, #$912F, #$9131, #$9134, #$9136, #$9137, #$9139, #$913A,
      #$913C, #$913D, #$9143, #$9147, #$9148, #$914F, #$9153, #$9157,
      #$9159, #$915A, #$915B, #$9161, #$9164, #$9167, #$916D, #$9174,
      #$9179, #$917A, #$917B, #$9181, #$9183, #$9185, #$9186, #$918A,
      #$918E, #$9191, #$9193, #$9194, #$9195, #$9198, #$919E, #$91A1,
      #$91A6, #$91A8, #$91AC, #$91AD, #$91AE, #$91B0, #$91B1, #$91B2,
      #$91B3, #$91B6, #$91BB, #$91BC, #$91BD, #$91BF,
      #$91C2, #$91C3, #$91C5, #$91D3, #$91D4, #$91D7, #$91D9, #$91DA,
      #$91DE, #$91E4, #$91E5, #$91E9, #$91EA, #$91EC, #$91ED, #$91EE,
      #$91EF, #$91F0, #$91F1, #$91F7, #$91F9, #$91FB, #$91FD, #$9200,
      #$9201, #$9204, #$9205, #$9206, #$9207, #$9209, #$920A, #$920C,
      #$9210, #$9212, #$9213, #$9216, #$9218, #$921C, #$921D, #$9223,
      #$9224, #$9225, #$9226, #$9228, #$922E, #$922F, #$9230, #$9233,
      #$9235, #$9236, #$9238, #$9239, #$923A, #$923C, #$923E, #$9240,
      #$9242, #$9243, #$9246, #$9247, #$924A, #$924D, #$924E, #$924F,
      #$9251, #$9258, #$9259, #$925C, #$925D, #$9260, #$9261, #$9265,
      #$9267, #$9268, #$9269, #$926E, #$926F, #$9270, #$9275, #$9276,
      #$9277, #$9278, #$9279, #$927B, #$927C, #$927D, #$927F, #$9288,
      #$9289, #$928A, #$928D, #$928E, #$9292, #$9297,
      #$9299, #$929F, #$92A0, #$92A4, #$92A5, #$92A7, #$92A8, #$92AB,
      #$92AF, #$92B2, #$92B6, #$92B8, #$92BA, #$92BB, #$92BC, #$92BD,
      #$92BF, #$92C0, #$92C1, #$92C2, #$92C3, #$92C5, #$92C6, #$92C7,
      #$92C8, #$92CB, #$92CC, #$92CD, #$92CE, #$92D0, #$92D3, #$92D5,
      #$92D7, #$92D8, #$92D9, #$92DC, #$92DD, #$92DF, #$92E0, #$92E1,
      #$92E3, #$92E5, #$92E7, #$92E8, #$92EC, #$92EE, #$92F0, #$92F9,
      #$92FB, #$92FF, #$9300, #$9302, #$9308, #$930D, #$9311, #$9314,
      #$9315, #$931C, #$931D, #$931E, #$931F, #$9321, #$9324, #$9325,
      #$9327, #$9329, #$932A, #$9333, #$9334, #$9336, #$9337, #$9347,
      #$9348, #$9349, #$9350, #$9351, #$9352, #$9355, #$9357, #$9358,
      #$935A, #$935E, #$9364, #$9365, #$9367, #$9369, #$936A, #$936D,
      #$936F, #$9370, #$9371, #$9373, #$9374, #$9376,
      #$937A, #$937D, #$937F, #$9380, #$9381, #$9382, #$9388, #$938A,
      #$938B, #$938D, #$938F, #$9392, #$9395, #$9398, #$939B, #$939E,
      #$93A1, #$93A3, #$93A4, #$93A6, #$93A8, #$93AB, #$93B4, #$93B5,
      #$93B6, #$93BA, #$93A9, #$93C1, #$93C4, #$93C5, #$93C6, #$93C7,
      #$93C9, #$93CA, #$93CB, #$93CC, #$93CD, #$93D3, #$93D9, #$93DC,
      #$93DE, #$93DF, #$93E2, #$93E6, #$93E7, #$93F9, #$93F7, #$93F8,
      #$93FA, #$93FB, #$93FD, #$9401, #$9402, #$9404, #$9408, #$9409,
      #$940D, #$940E, #$940F, #$9415, #$9416, #$9417, #$941F, #$942E,
      #$942F, #$9431, #$9432, #$9433, #$9434, #$943B, #$943F, #$943D,
      #$9443, #$9445, #$9448, #$944A, #$944C, #$9455, #$9459, #$945C,
      #$945F, #$9461, #$9463, #$9468, #$946B, #$946D, #$946E, #$946F,
      #$9471, #$9472, #$9484, #$9483, #$9578, #$9579,
      #$957E, #$9584, #$9588, #$958C, #$958D, #$958E, #$959D, #$959E,
      #$959F, #$95A1, #$95A6, #$95A9, #$95AB, #$95AC, #$95B4, #$95B6,
      #$95BA, #$95BD, #$95BF, #$95C6, #$95C8, #$95C9, #$95CB, #$95D0,
      #$95D1, #$95D2, #$95D3, #$95D9, #$95DA, #$95DD, #$95DE, #$95DF,
      #$95E0, #$95E4, #$95E6, #$961D, #$961E, #$9622, #$9624, #$9625,
      #$9626, #$962C, #$9631, #$9633, #$9637, #$9638, #$9639, #$963A,
      #$963C, #$963D, #$9641, #$9652, #$9654, #$9656, #$9657, #$9658,
      #$9661, #$966E, #$9674, #$967B, #$967C, #$967E, #$967F, #$9681,
      #$9682, #$9683, #$9684, #$9689, #$9691, #$9696, #$969A, #$969D,
      #$969F, #$96A4, #$96A5, #$96A6, #$96A9, #$96AE, #$96AF, #$96B3,
      #$96BA, #$96CA, #$96D2, #$5DB2, #$96D8, #$96DA, #$96DD, #$96DE,
      #$96DF, #$96E9, #$96EF, #$96F1, #$96FA, #$9702,
      #$9703, #$9705, #$9709, #$971A, #$971B, #$971D, #$9721, #$9722,
      #$9723, #$9728, #$9731, #$9733, #$9741, #$9743, #$974A, #$974E,
      #$974F, #$9755, #$9757, #$9758, #$975A, #$975B, #$9763, #$9767,
      #$976A, #$976E, #$9773, #$9776, #$9777, #$9778, #$977B, #$977D,
      #$977F, #$9780, #$9789, #$9795, #$9796, #$9797, #$9799, #$979A,
      #$979E, #$979F, #$97A2, #$97AC, #$97AE, #$97B1, #$97B2, #$97B5,
      #$97B6, #$97B8, #$97B9, #$97BA, #$97BC, #$97BE, #$97BF, #$97C1,
      #$97C4, #$97C5, #$97C7, #$97C9, #$97CA, #$97CC, #$97CD, #$97CE,
      #$97D0, #$97D1, #$97D4, #$97D7, #$97D8, #$97D9, #$97DD, #$97DE,
      #$97E0, #$97DB, #$97E1, #$97E4, #$97EF, #$97F1, #$97F4, #$97F7,
      #$97F8, #$97FA, #$9807, #$980A, #$9819, #$980D, #$980E, #$9814,
      #$9816, #$981C, #$981E, #$9820, #$9823, #$9826,
      #$982B, #$982E, #$982F, #$9830, #$9832, #$9833, #$9835, #$9825,
      #$983E, #$9844, #$9847, #$984A, #$9851, #$9852, #$9853, #$9856,
      #$9857, #$9859, #$985A, #$9862, #$9863, #$9865, #$9866, #$986A,
      #$986C, #$98AB, #$98AD, #$98AE, #$98B0, #$98B4, #$98B7, #$98B8,
      #$98BA, #$98BB, #$98BF, #$98C2, #$98C5, #$98C8, #$98CC, #$98E1,
      #$98E3, #$98E5, #$98E6, #$98E7, #$98EA, #$98F3, #$98F6, #$9902,
      #$9907, #$9908, #$9911, #$9915, #$9916, #$9917, #$991A, #$991B,
      #$991C, #$991F, #$9922, #$9926, #$9927, #$992B, #$9931, #$9932,
      #$9933, #$9934, #$9935, #$9939, #$993A, #$993B, #$993C, #$9940,
      #$9941, #$9946, #$9947, #$9948, #$994D, #$994E, #$9954, #$9958,
      #$9959, #$995B, #$995C, #$995E, #$995F, #$9960, #$999B, #$999D,
      #$999F, #$99A6, #$99B0, #$99B1, #$99B2, #$99B5,
      #$99B9, #$99BA, #$99BD, #$99BF, #$99C3, #$99C9, #$99D3, #$99D4,
      #$99D9, #$99DA, #$99DC, #$99DE, #$99E7, #$99EA, #$99EB, #$99EC,
      #$99F0, #$99F4, #$99F5, #$99F9, #$99FD, #$99FE, #$9A02, #$9A03,
      #$9A04, #$9A0B, #$9A0C, #$9A10, #$9A11, #$9A16, #$9A1E, #$9A20,
      #$9A22, #$9A23, #$9A24, #$9A27, #$9A2D, #$9A2E, #$9A33, #$9A35,
      #$9A36, #$9A38, #$9A47, #$9A41, #$9A44, #$9A4A, #$9A4B, #$9A4C,
      #$9A4E, #$9A51, #$9A54, #$9A56, #$9A5D, #$9AAA, #$9AAC, #$9AAE,
      #$9AAF, #$9AB2, #$9AB4, #$9AB5, #$9AB6, #$9AB9, #$9ABB, #$9ABE,
      #$9ABF, #$9AC1, #$9AC3, #$9AC6, #$9AC8, #$9ACE, #$9AD0, #$9AD2,
      #$9AD5, #$9AD6, #$9AD7, #$9ADB, #$9ADC, #$9AE0, #$9AE4, #$9AE5,
      #$9AE7, #$9AE9, #$9AEC, #$9AF2, #$9AF3, #$9AF5, #$9AF9, #$9AFA,
      #$9AFD, #$9AFF, #$9B00, #$9B01, #$9B02, #$9B03,
      #$9B04, #$9B05, #$9B08, #$9B09, #$9B0B, #$9B0C, #$9B0D, #$9B0E,
      #$9B10, #$9B12, #$9B16, #$9B19, #$9B1B, #$9B1C, #$9B20, #$9B26,
      #$9B2B, #$9B2D, #$9B33, #$9B34, #$9B35, #$9B37, #$9B39, #$9B3A,
      #$9B3D, #$9B48, #$9B4B, #$9B4C, #$9B55, #$9B56, #$9B57, #$9B5B,
      #$9B5E, #$9B61, #$9B63, #$9B65, #$9B66, #$9B68, #$9B6A, #$9B6B,
      #$9B6C, #$9B6D, #$9B6E, #$9B73, #$9B75, #$9B77, #$9B78, #$9B79,
      #$9B7F, #$9B80, #$9B84, #$9B85, #$9B86, #$9B87, #$9B89, #$9B8A,
      #$9B8B, #$9B8D, #$9B8F, #$9B90, #$9B94, #$9B9A, #$9B9D, #$9B9E,
      #$9BA6, #$9BA7, #$9BA9, #$9BAC, #$9BB0, #$9BB1, #$9BB2, #$9BB7,
      #$9BB8, #$9BBB, #$9BBC, #$9BBE, #$9BBF, #$9BC1, #$9BC7, #$9BC8,
      #$9BCE, #$9BD0, #$9BD7, #$9BD8, #$9BDD, #$9BDF, #$9BE5, #$9BE7,
      #$9BEA, #$9BEB, #$9BEF, #$9BF3, #$9BF7, #$9BF8,
      #$9BF9, #$9BFA, #$9BFD, #$9BFF, #$9C00, #$9C02, #$9C0B, #$9C0F,
      #$9C11, #$9C16, #$9C18, #$9C19, #$9C1A, #$9C1C, #$9C1E, #$9C22,
      #$9C23, #$9C26, #$9C27, #$9C28, #$9C29, #$9C2A, #$9C31, #$9C35,
      #$9C36, #$9C37, #$9C3D, #$9C41, #$9C43, #$9C44, #$9C45, #$9C49,
      #$9C4A, #$9C4E, #$9C4F, #$9C50, #$9C53, #$9C54, #$9C56, #$9C58,
      #$9C5B, #$9C5D, #$9C5E, #$9C5F, #$9C63, #$9C69, #$9C6A, #$9C5C,
      #$9C6B, #$9C68, #$9C6E, #$9C70, #$9C72, #$9C75, #$9C77, #$9C7B,
      #$9CE6, #$9CF2, #$9CF7, #$9CF9, #$9D0B, #$9D02, #$9D11, #$9D17,
      #$9D18, #$9D1C, #$9D1D, #$9D1E, #$9D2F, #$9D30, #$9D32, #$9D33,
      #$9D34, #$9D3A, #$9D3C, #$9D45, #$9D3D, #$9D42, #$9D43, #$9D47,
      #$9D4A, #$9D53, #$9D54, #$9D5F, #$9D63, #$9D62, #$9D65, #$9D69,
      #$9D6A, #$9D6B, #$9D70, #$9D76, #$9D77, #$9D7B,
      #$9D7C, #$9D7E, #$9D83, #$9D84, #$9D86, #$9D8A, #$9D8D, #$9D8E,
      #$9D92, #$9D93, #$9D95, #$9D96, #$9D97, #$9D98, #$9DA1, #$9DAA,
      #$9DAC, #$9DAE, #$9DB1, #$9DB5, #$9DB9, #$9DBC, #$9DBF, #$9DC3,
      #$9DC7, #$9DC9, #$9DCA, #$9DD4, #$9DD5, #$9DD6, #$9DD7, #$9DDA,
      #$9DDE, #$9DDF, #$9DE0, #$9DE5, #$9DE7, #$9DE9, #$9DEB, #$9DEE,
      #$9DF0, #$9DF3, #$9DF4, #$9DFE, #$9E0A, #$9E02, #$9E07, #$9E0E,
      #$9E10, #$9E11, #$9E12, #$9E15, #$9E16, #$9E19, #$9E1C, #$9E1D,
      #$9E7A, #$9E7B, #$9E7C, #$9E80, #$9E82, #$9E83, #$9E84, #$9E85,
      #$9E87, #$9E8E, #$9E8F, #$9E96, #$9E98, #$9E9B, #$9E9E, #$9EA4,
      #$9EA8, #$9EAC, #$9EAE, #$9EAF, #$9EB0, #$9EB3, #$9EB4, #$9EB5,
      #$9EC6, #$9EC8, #$9ECB, #$9ED5, #$9EDF, #$9EE4, #$9EE7, #$9EEC,
      #$9EED, #$9EEE, #$9EF0, #$9EF1, #$9EF2, #$9EF5,
      #$9EF8, #$9EFF, #$9F02, #$9F03, #$9F09, #$9F0F, #$9F10, #$9F11,
      #$9F12, #$9F14, #$9F16, #$9F17, #$9F19, #$9F1A, #$9F1B, #$9F1F,
      #$9F22, #$9F26, #$9F2A, #$9F2B, #$9F2F, #$9F31, #$9F32, #$9F34,
      #$9F37, #$9F39, #$9F3A, #$9F3C, #$9F3D, #$9F3F, #$9F41, #$9F43,
      #$9F44, #$9F45, #$9F46, #$9F47, #$9F53, #$9F55, #$9F56, #$9F57,
      #$9F58, #$9F5A, #$9F5D, #$9F5E, #$9F68, #$9F69, #$9F6D, #$9F6E,
      #$9F6F, #$9F70, #$9F71, #$9F73, #$9F75, #$9F7A, #$9F7D, #$9F8F,
      #$9F90, #$9F91, #$9F92, #$9F94, #$9F96, #$9F97, #$9F9E, #$9FA1,
      #$9FA2, #$9FA3, #$9FA5);
  CNS11643_1_1Map: array[0..499] of TBuffChar = (
      #$3000, #$FF0C, #$3001, #$3002, #$FF0E, #$30FB, #$FF1B, #$FF1A,
      #$FF1F, #$FF01, #$FE30, #$2026, #$2025, #$FE50, #$FE51, #$FE52,
      #$00B7, #$FE54, #$FE55, #$FE56, #$FE57, #$FE31, #$2014, #$FE32,
      #$2013, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FF08, #$FF09, #$FE35,
      #$FE36, #$FF5B, #$FF5D, #$FE37, #$FE38, #$3014, #$3015, #$FE39,
      #$FE3A, #$3010, #$3011, #$FE3B, #$FE3C, #$300A, #$300B, #$FE3D,
      #$FE3E, #$3008, #$3009, #$FE3F, #$FE40, #$300C, #$300D, #$FE41,
      #$FE42, #$300E, #$300F, #$FE43, #$FE44, #$FE59, #$FE5A, #$FE5B,
      #$FE5C, #$FE5D, #$FE5E, #$2018, #$2019, #$201C, #$201D, #$301D,
      #$301E, #$2032, #$2035, #$FF03, #$FF06, #$FF0A, #$203B, #$00A7,
      #$3003, #$25CB, #$25CF, #$25B3, #$25B2, #$25CE, #$2606, #$2605,
      #$25C7, #$25C6, #$25A1, #$25A0, #$25BD, #$25BC,
      #$32A3, #$2105, #$203E, #$FFFD, #$FF3F, #$FFFD, #$FE49, #$FE4A,
      #$FE4D, #$FE4E, #$FE4B, #$FE4C, #$FE5F, #$FE60, #$FE61, #$FF0B,
      #$FF0D, #$00D7, #$00F7, #$00B1, #$221A, #$FF1C, #$FF1E, #$FF1D,
      #$2266, #$2267, #$2260, #$221E, #$2252, #$2261, #$FE62, #$FE63,
      #$FE64, #$FE66, #$FE65, #$223C, #$2229, #$222A, #$22A5, #$2220,
      #$221F, #$22BF, #$33D2, #$33D1, #$222B, #$222E, #$2235, #$2234,
      #$2640, #$2642, #$2641, #$2609, #$2191, #$2193, #$2192, #$2190,
      #$2196, #$2197, #$2199, #$2198, #$2016, #$FF5C, #$FF0F, #$FF3C,
      #$2215, #$FE68, #$FF04, #$FFE5, #$3012, #$FFE0, #$FFE1, #$FF05,
      #$FF20, #$2103, #$2109, #$FE69, #$FE6A, #$FE6B, #$33D5, #$339C,
      #$339D, #$339E, #$33CE, #$33A1, #$338E, #$338F, #$33C4, #$00B0,
      #$5159, #$515B, #$515E, #$515D, #$5161, #$5163,
      #$55E7, #$74E9, #$7CCE, #$2581, #$2582, #$2583, #$2584, #$2585,
      #$2586, #$2587, #$2588, #$258F, #$258E, #$258D, #$258C, #$258B,
      #$258A, #$2589, #$253C, #$2534, #$252C, #$2524, #$251C, #$2594,
      #$2500, #$2502, #$2595, #$250C, #$2510, #$2514, #$2518, #$256D,
      #$256E, #$2570, #$256F, #$2550, #$255E, #$256A, #$2561, #$25E2,
      #$25E3, #$25E5, #$25E4, #$2571, #$2572, #$2573, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FF10, #$FF11, #$FF12, #$FF13, #$FF14, #$FF15, #$FF16, #$FF17,
      #$FF18, #$FF19, #$2160, #$2161, #$2162, #$2163, #$2164, #$2165,
      #$2166, #$2167, #$2168, #$2169, #$3021, #$3022, #$3023, #$3024,
      #$3025, #$3026, #$3027, #$3028, #$3029, #$FFFD, #$5344, #$FFFD,
      #$FF21, #$FF22, #$FF23, #$FF24, #$FF25, #$FF26, #$FF27, #$FF28,
      #$FF29, #$FF2A, #$FF2B, #$FF2C, #$FF2D, #$FF2E, #$FF2F, #$FF30,
      #$FF31, #$FF32, #$FF33, #$FF34, #$FF35, #$FF36, #$FF37, #$FF38,
      #$FF39, #$FF3A, #$FF41, #$FF42, #$FF43, #$FF44, #$FF45, #$FF46,
      #$FF47, #$FF48, #$FF49, #$FF4A, #$FF4B, #$FF4C, #$FF4D, #$FF4E,
      #$FF4F, #$FF50, #$FF51, #$FF52, #$FF53, #$FF54, #$FF55, #$FF56,
      #$FF57, #$FF58, #$FF59, #$FF5A, #$0391, #$0392, #$0393, #$0394,
      #$0395, #$0396, #$0397, #$0398, #$0399, #$039A,
      #$039B, #$039C, #$039D, #$039E, #$039F, #$03A0, #$03A1, #$03A3,
      #$03A4, #$03A5, #$03A6, #$03A7, #$03A8, #$03A9, #$03B1, #$03B2,
      #$03B3, #$03B4, #$03B5, #$03B6, #$03B7, #$03B8, #$03B9, #$03BA,
      #$03BB, #$03BC, #$03BD, #$03BE, #$03BF, #$03C0, #$03C1, #$03C3,
      #$03C4, #$03C5, #$03C6, #$03C7, #$03C8, #$03C9, #$3105, #$3106,
      #$3107, #$3108, #$3109, #$310A, #$310B, #$310C, #$310D, #$310E,
      #$310F, #$3110, #$3111, #$3112, #$3113, #$3114, #$3115, #$3116,
      #$3117, #$3118, #$3119, #$311A, #$311B, #$311C, #$311D, #$311E,
      #$311F, #$3120, #$3121, #$3122, #$3123, #$3124, #$3125, #$3126,
      #$3127, #$3128, #$3129, #$02D9, #$02C9, #$02CA, #$02C7, #$02CB,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD, #$FFFD,
      #$2460, #$2461, #$2462, #$2463, #$2464, #$2465, #$2466, #$2467,
      #$2468, #$2469, #$2474, #$2475, #$2476, #$2477, #$2478, #$2479,
      #$247A, #$247B, #$247C, #$247D, #$2170, #$2171, #$2172, #$2173,
      #$2174, #$2175, #$2176, #$2177, #$2178, #$2179);
  CNS11643_1_2Map: array[0..32] of TBuffChar = (
      #$2400, #$2401, #$2402, #$2403, #$2404, #$2405, #$2406, #$2407,
      #$2408, #$2409, #$240A, #$240B, #$240C, #$240D, #$240E, #$240F,
      #$2410, #$2411, #$2412, #$2413, #$2414, #$2415, #$2416, #$2417,
      #$2418, #$2419, #$241A, #$241B, #$241C, #$241D, #$241E, #$241F,
      #$2421);
  CNS11643_1_3Map: array[0..5400] of TBuffChar = (
      #$4E00, #$4E59, #$4E01, #$4E03, #$4E43, #$4E5D, #$4E86, #$4E8C,
      #$4EBA, #$513F, #$5165, #$516B, #$51E0, #$5200, #$5201, #$529B,
      #$5315, #$5341, #$535C, #$53C8, #$4E09, #$4E0B, #$4E08, #$4E0A,
      #$4E2B, #$4E38, #$51E1, #$4E45, #$4E48, #$4E5F, #$4E5E, #$4E8E,
      #$4EA1, #$5140, #$5203, #$52FA, #$5343, #$53C9, #$53E3, #$571F,
      #$58EB, #$5915, #$5927, #$5973, #$5B50, #$5B51, #$5B53, #$5BF8,
      #$5C0F, #$5C22, #$5C38, #$5C71, #$5DDD, #$5DE5, #$5DF1, #$5DF2,
      #$5DF3, #$5DFE, #$5E72, #$5EFE, #$5F0B, #$5F13, #$624D, #$4E11,
      #$4E10, #$4E0D, #$4E2D, #$4E30, #$4E39, #$4E4B, #$5C39, #$4E88,
      #$4E91, #$4E95, #$4E92, #$4E94, #$4EA2, #$4EC1, #$4EC0, #$4EC3,
      #$4EC6, #$4EC7, #$4ECD, #$4ECA, #$4ECB, #$4EC4, #$5143, #$5141,
      #$5167, #$516D, #$516E, #$516C, #$5197, #$51F6,
      #$5206, #$5207, #$5208, #$52FB, #$52FE, #$52FF, #$5316, #$5339,
      #$5348, #$5347, #$5345, #$535E, #$5384, #$53CB, #$53CA, #$53CD,
      #$58EC, #$5929, #$592B, #$592A, #$592D, #$5B54, #$5C11, #$5C24,
      #$5C3A, #$5C6F, #$5DF4, #$5E7B, #$5EFF, #$5F14, #$5F15, #$5FC3,
      #$6208, #$6236, #$624B, #$624E, #$652F, #$6587, #$6597, #$65A4,
      #$65B9, #$65E5, #$66F0, #$6708, #$6728, #$6B20, #$6B62, #$6B79,
      #$6BCB, #$6BD4, #$6BDB, #$6C0F, #$6C34, #$706B, #$722A, #$7236,
      #$723B, #$7247, #$7259, #$725B, #$72AC, #$738B, #$4E19, #$4E16,
      #$4E15, #$4E14, #$4E18, #$4E3B, #$4E4D, #$4E4F, #$4E4E, #$4EE5,
      #$4ED8, #$4ED4, #$4ED5, #$4ED6, #$4ED7, #$4EE3, #$4EE4, #$4ED9,
      #$4EDE, #$5145, #$5144, #$5189, #$518A, #$51AC, #$51F9, #$51FA,
      #$51F8, #$520A, #$52A0, #$529F, #$5305, #$5306,
      #$5317, #$531D, #$4EDF, #$534A, #$5349, #$5361, #$5360, #$536F,
      #$536E, #$53BB, #$53EF, #$53E4, #$53F3, #$53EC, #$53EE, #$53E9,
      #$53E8, #$53FC, #$53F8, #$53F5, #$53EB, #$53E6, #$53EA, #$53F2,
      #$53F1, #$53F0, #$53E5, #$53ED, #$53FB, #$56DB, #$56DA, #$5916,
      #$592E, #$5931, #$5974, #$5976, #$5B55, #$5B83, #$5C3C, #$5DE8,
      #$5DE7, #$5DE6, #$5E02, #$5E03, #$5E73, #$5E7C, #$5F01, #$5F18,
      #$5F17, #$5FC5, #$620A, #$6253, #$6254, #$6252, #$6251, #$65A5,
      #$65E6, #$672E, #$672C, #$672A, #$672B, #$672D, #$6B63, #$6BCD,
      #$6C11, #$6C10, #$6C38, #$6C41, #$6C40, #$6C3E, #$72AF, #$7384,
      #$7389, #$74DC, #$74E6, #$7518, #$751F, #$7528, #$7529, #$7530,
      #$7531, #$7532, #$7533, #$758B, #$767D, #$76AE, #$76BF, #$76EE,
      #$77DB, #$77E2, #$77F3, #$793A, #$79BE, #$7A74,
      #$7ACB, #$4E1E, #$4E1F, #$4E52, #$4E53, #$4E69, #$4E99, #$4EA4,
      #$4EA6, #$4EA5, #$4EFF, #$4F09, #$4F19, #$4F0A, #$4F15, #$4F0D,
      #$4F10, #$4F11, #$4F0F, #$4EF2, #$4EF6, #$4EFB, #$4EF0, #$4EF3,
      #$4EFD, #$4F01, #$4F0B, #$5149, #$5147, #$5146, #$5148, #$5168,
      #$5171, #$518D, #$51B0, #$5217, #$5211, #$5212, #$520E, #$5216,
      #$52A3, #$5308, #$5321, #$5320, #$5370, #$5371, #$5409, #$540F,
      #$540C, #$540A, #$5410, #$5401, #$540B, #$5404, #$5411, #$540D,
      #$5408, #$5403, #$540E, #$5406, #$5412, #$56E0, #$56DE, #$56DD,
      #$5733, #$5730, #$5728, #$572D, #$572C, #$572F, #$5729, #$5919,
      #$591A, #$5937, #$5938, #$5984, #$5978, #$5983, #$597D, #$5979,
      #$5982, #$5981, #$5B57, #$5B58, #$5B87, #$5B88, #$5B85, #$5B89,
      #$5BFA, #$5C16, #$5C79, #$5DDE, #$5E06, #$5E76,
      #$5E74, #$5F0F, #$5F1B, #$5FD9, #$5FD6, #$620E, #$620C, #$620D,
      #$6210, #$6263, #$625B, #$6258, #$6536, #$65E9, #$65E8, #$65EC,
      #$65ED, #$66F2, #$66F3, #$6709, #$673D, #$6734, #$6731, #$6735,
      #$6B21, #$6B64, #$6B7B, #$6C16, #$6C5D, #$6C57, #$6C59, #$6C5F,
      #$6C60, #$6C50, #$6C55, #$6C61, #$6C5B, #$6C4D, #$6C4E, #$7070,
      #$725F, #$725D, #$767E, #$7AF9, #$7C73, #$7CF8, #$7F36, #$7F8A,
      #$7FBD, #$8001, #$8003, #$800C, #$8012, #$8033, #$807F, #$8089,
      #$808B, #$808C, #$81E3, #$81EA, #$81F3, #$81FC, #$820C, #$821B,
      #$821F, #$826E, #$8272, #$827E, #$866B, #$8840, #$884C, #$8863,
      #$897F, #$9621, #$4E32, #$4EA8, #$4F4D, #$4F4F, #$4F47, #$4F57,
      #$4F5E, #$4F34, #$4F5B, #$4F55, #$4F30, #$4F50, #$4F51, #$4F3D,
      #$4F3A, #$4F38, #$4F43, #$4F54, #$4F3C, #$4F46,
      #$4F63, #$4F5C, #$4F60, #$4F2F, #$4F4E, #$4F36, #$4F59, #$4F5D,
      #$4F48, #$4F5A, #$514C, #$514B, #$514D, #$5175, #$51B6, #$51B7,
      #$5225, #$5224, #$5229, #$522A, #$5228, #$52AB, #$52A9, #$52AA,
      #$52AC, #$5323, #$5373, #$5375, #$541D, #$542D, #$541E, #$543E,
      #$5426, #$544E, #$5427, #$5446, #$5443, #$5433, #$5448, #$5442,
      #$541B, #$5429, #$544A, #$5439, #$543B, #$5438, #$542E, #$5435,
      #$5436, #$5420, #$543C, #$5440, #$5431, #$542B, #$541F, #$542C,
      #$56EA, #$56F0, #$56E4, #$56EB, #$574A, #$5751, #$5740, #$574D,
      #$5747, #$574E, #$573E, #$5750, #$574F, #$573B, #$58EF, #$593E,
      #$599D, #$5992, #$59A8, #$599E, #$59A3, #$5999, #$5996, #$598D,
      #$59A4, #$5993, #$598A, #$59A5, #$5B5D, #$5B5C, #$5B5A, #$5B5B,
      #$5B8C, #$5B8B, #$5B8F, #$5C2C, #$5C40, #$5C41,
      #$5C3F, #$5C3E, #$5C90, #$5C91, #$5C94, #$5C8C, #$5DEB, #$5E0C,
      #$5E8F, #$5E87, #$5E8A, #$5EF7, #$5F04, #$5F1F, #$5F64, #$5F62,
      #$5F77, #$5F79, #$5FD8, #$5FCC, #$5FD7, #$5FCD, #$5FF1, #$5FEB,
      #$5FF8, #$5FEA, #$6212, #$6211, #$6284, #$6297, #$6296, #$6280,
      #$6276, #$6289, #$626D, #$628A, #$627C, #$627E, #$6279, #$6273,
      #$6292, #$626F, #$6298, #$626E, #$6295, #$6293, #$6291, #$6286,
      #$6539, #$653B, #$6538, #$65F1, #$66F4, #$675F, #$674E, #$674F,
      #$6750, #$6751, #$675C, #$6756, #$675E, #$6749, #$6746, #$6760,
      #$6753, #$6757, #$6B65, #$6BCF, #$6C42, #$6C5E, #$6C99, #$6C81,
      #$6C88, #$6C89, #$6C85, #$6C9B, #$6C6A, #$6C7A, #$6C90, #$6C70,
      #$6C8C, #$6C68, #$6C96, #$6C92, #$6C7D, #$6C83, #$6C72, #$6C7E,
      #$6C74, #$6C86, #$6C76, #$6C8D, #$6C94, #$6C98,
      #$6C82, #$7076, #$707C, #$707D, #$7078, #$7262, #$7261, #$7260,
      #$72C4, #$72C2, #$7396, #$752C, #$752B, #$7537, #$7538, #$7682,
      #$76EF, #$77E3, #$79C1, #$79C0, #$79BF, #$7A76, #$7CFB, #$7F55,
      #$8096, #$8093, #$809D, #$8098, #$809B, #$809A, #$80B2, #$826F,
      #$8292, #$828B, #$828D, #$898B, #$89D2, #$8A00, #$8C37, #$8C46,
      #$8C55, #$8C9D, #$8D64, #$8D70, #$8DB3, #$8EAB, #$8ECA, #$8F9B,
      #$8FB0, #$8FC2, #$8FC6, #$8FC5, #$8FC4, #$5DE1, #$9091, #$90A2,
      #$90AA, #$90A6, #$90A3, #$9149, #$91C6, #$91CC, #$9632, #$962E,
      #$9631, #$962A, #$962C, #$4E26, #$4E56, #$4E73, #$4E8B, #$4E9B,
      #$4E9E, #$4EAB, #$4EAC, #$4F6F, #$4F9D, #$4F8D, #$4F73, #$4F7F,
      #$4F6C, #$4F9B, #$4F8B, #$4F86, #$4F83, #$4F70, #$4F75, #$4F88,
      #$4F69, #$4F7B, #$4F96, #$4F7E, #$4F8F, #$4F91,
      #$4F7A, #$5154, #$5152, #$5155, #$5169, #$5177, #$5176, #$5178,
      #$51BD, #$51FD, #$523B, #$5238, #$5237, #$523A, #$5230, #$522E,
      #$5236, #$5241, #$52BE, #$52BB, #$5352, #$5354, #$5353, #$5351,
      #$5366, #$5377, #$5378, #$5379, #$53D6, #$53D4, #$53D7, #$5473,
      #$5475, #$5496, #$5478, #$5495, #$5480, #$547B, #$5477, #$5484,
      #$5492, #$5486, #$547C, #$5490, #$5471, #$5476, #$548C, #$549A,
      #$5462, #$5468, #$548B, #$547D, #$548E, #$56FA, #$5783, #$5777,
      #$576A, #$5769, #$5761, #$5766, #$5764, #$577C, #$591C, #$5949,
      #$5947, #$5948, #$5944, #$5954, #$59BE, #$59BB, #$59D4, #$59B9,
      #$59AE, #$59D1, #$59C6, #$59D0, #$59CD, #$59CB, #$59D3, #$59CA,
      #$59AF, #$59B3, #$59D2, #$59C5, #$5B5F, #$5B64, #$5B63, #$5B97,
      #$5B9A, #$5B98, #$5B9C, #$5B99, #$5B9B, #$5C1A,
      #$5C48, #$5C45, #$5C46, #$5CB7, #$5CA1, #$5CB8, #$5CA9, #$5CAB,
      #$5CB1, #$5CB3, #$5E18, #$5E1A, #$5E16, #$5E15, #$5E1B, #$5E11,
      #$5E78, #$5E9A, #$5E97, #$5E9C, #$5E95, #$5E96, #$5EF6, #$5F26,
      #$5F27, #$5F29, #$5F80, #$5F81, #$5F7F, #$5F7C, #$5FDD, #$5FE0,
      #$5FFD, #$5FF5, #$5FFF, #$600F, #$6014, #$602F, #$6035, #$6016,
      #$602A, #$6015, #$6021, #$6027, #$6029, #$602B, #$601B, #$6216,
      #$6215, #$623F, #$623E, #$6240, #$627F, #$62C9, #$62CC, #$62C4,
      #$62BF, #$62C2, #$62B9, #$62D2, #$62DB, #$62AB, #$62D3, #$62D4,
      #$62CB, #$62C8, #$62A8, #$62BD, #$62BC, #$62D0, #$62D9, #$62C7,
      #$62CD, #$62B5, #$62DA, #$62B1, #$62D8, #$62D6, #$62D7, #$62C6,
      #$62AC, #$62CE, #$653E, #$65A7, #$65BC, #$65FA, #$6614, #$6613,
      #$660C, #$6606, #$6602, #$660E, #$6600, #$660F,
      #$6615, #$660A, #$6607, #$670D, #$670B, #$676D, #$678B, #$6795,
      #$6771, #$679C, #$6773, #$6777, #$6787, #$679D, #$6797, #$676F,
      #$6770, #$677F, #$6789, #$677E, #$6790, #$6775, #$679A, #$6793,
      #$677C, #$676A, #$6772, #$6B23, #$6B66, #$6B67, #$6B7F, #$6C13,
      #$6C1B, #$6CE3, #$6CE8, #$6CF3, #$6CB1, #$6CCC, #$6CE5, #$6CB3,
      #$6CBD, #$6CBE, #$6CBC, #$6CE2, #$6CAB, #$6CD5, #$6CD3, #$6CB8,
      #$6CC4, #$6CB9, #$6CC1, #$6CAE, #$6CD7, #$6CC5, #$6CF1, #$6CBF,
      #$6CBB, #$6CE1, #$6CDB, #$6CCA, #$6CAC, #$6CEF, #$6CDC, #$6CD6,
      #$6CE0, #$7095, #$708E, #$7092, #$708A, #$7099, #$722C, #$722D,
      #$7238, #$7248, #$7267, #$7269, #$72C0, #$72CE, #$72D9, #$72D7,
      #$72D0, #$73A9, #$73A8, #$739F, #$73AB, #$73A5, #$753D, #$759D,
      #$7599, #$759A, #$7684, #$76C2, #$76F2, #$76F4,
      #$77E5, #$77FD, #$793E, #$7940, #$7941, #$79C9, #$79C8, #$7A7A,
      #$7A79, #$7AFA, #$7CFE, #$7F54, #$7F8C, #$7F8B, #$8005, #$80BA,
      #$80A5, #$80A2, #$80B1, #$80A1, #$80AB, #$80A9, #$80B4, #$80AA,
      #$80AF, #$81E5, #$81FE, #$820D, #$82B3, #$829D, #$8299, #$82AD,
      #$82BD, #$829F, #$82B9, #$82B1, #$82AC, #$82A5, #$82AF, #$82B8,
      #$82A3, #$82B0, #$82BE, #$82B7, #$864E, #$8671, #$521D, #$8868,
      #$8ECB, #$8FCE, #$8FD4, #$8FD1, #$90B5, #$90B8, #$90B1, #$90B6,
      #$91C7, #$91D1, #$9577, #$9580, #$961C, #$9640, #$963F, #$963B,
      #$9644, #$9642, #$96B9, #$96E8, #$9752, #$975E, #$4E9F, #$4EAD,
      #$4EAE, #$4FE1, #$4FB5, #$4FAF, #$4FBF, #$4FE0, #$4FD1, #$4FCF,
      #$4FDD, #$4FC3, #$4FB6, #$4FD8, #$4FDF, #$4FCA, #$4FD7, #$4FAE,
      #$4FD0, #$4FC4, #$4FC2, #$4FDA, #$4FCE, #$4FDE,
      #$4FB7, #$5157, #$5192, #$5191, #$51A0, #$524E, #$5243, #$524A,
      #$524D, #$524C, #$524B, #$5247, #$52C7, #$52C9, #$52C3, #$52C1,
      #$530D, #$5357, #$537B, #$539A, #$53DB, #$54AC, #$54C0, #$54A8,
      #$54CE, #$54C9, #$54B8, #$54A6, #$54B3, #$54C7, #$54C2, #$54BD,
      #$54AA, #$54C1, #$54C4, #$54C8, #$54AF, #$54AB, #$54B1, #$54BB,
      #$54A9, #$54A7, #$54BF, #$56FF, #$5782, #$578B, #$57A0, #$57A3,
      #$57A2, #$57CE, #$57AE, #$5793, #$5955, #$5951, #$594F, #$594E,
      #$5950, #$59DC, #$59D8, #$59FF, #$59E3, #$59E8, #$5A03, #$59E5,
      #$59EA, #$59DA, #$59E6, #$5A01, #$59FB, #$5B69, #$5BA3, #$5BA6,
      #$5BA4, #$5BA2, #$5BA5, #$5C01, #$5C4E, #$5C4F, #$5C4D, #$5C4B,
      #$5CD9, #$5CD2, #$5DF7, #$5E1D, #$5E25, #$5E1F, #$5E7D, #$5EA0,
      #$5EA6, #$5EFA, #$5F08, #$5F2D, #$5F65, #$5F88,
      #$5F85, #$5F8A, #$5F8B, #$5F87, #$5F8C, #$5F89, #$6012, #$601D,
      #$6020, #$6025, #$600E, #$6028, #$604D, #$6070, #$6068, #$6062,
      #$6046, #$6043, #$606C, #$606B, #$606A, #$6064, #$6241, #$62DC,
      #$6316, #$6309, #$62FC, #$62ED, #$6301, #$62EE, #$62FD, #$6307,
      #$62F1, #$62F7, #$62EF, #$62EC, #$62FE, #$62F4, #$6311, #$6302,
      #$653F, #$6545, #$65AB, #$65BD, #$65E2, #$6625, #$662D, #$6620,
      #$6627, #$662F, #$661F, #$6628, #$6631, #$6624, #$66F7, #$67FF,
      #$67D3, #$67F1, #$67D4, #$67D0, #$67EC, #$67B6, #$67AF, #$67F5,
      #$67E9, #$67EF, #$67C4, #$67D1, #$67B4, #$67DA, #$67E5, #$67B8,
      #$67CF, #$67DE, #$67F3, #$67B0, #$67D9, #$67E2, #$67DD, #$67D2,
      #$6B6A, #$6B83, #$6B86, #$6BB5, #$6BD2, #$6BD7, #$6C1F, #$6CC9,
      #$6D0B, #$6D32, #$6D2A, #$6D41, #$6D25, #$6D0C,
      #$6D31, #$6D1E, #$6D17, #$6D3B, #$6D3D, #$6D3E, #$6D36, #$6D1B,
      #$6CF5, #$6D39, #$6D27, #$6D38, #$6D29, #$6D2E, #$6D35, #$6D0E,
      #$6D2B, #$70AB, #$70BA, #$70B3, #$70AC, #$70AF, #$70AD, #$70B8,
      #$70AE, #$70A4, #$7230, #$7272, #$726F, #$7274, #$72E9, #$72E0,
      #$72E1, #$73B7, #$73CA, #$73BB, #$73B2, #$73CD, #$73C0, #$73B3,
      #$751A, #$752D, #$754F, #$754C, #$754E, #$754B, #$75AB, #$75A4,
      #$75A5, #$75A2, #$75A3, #$7678, #$7686, #$7687, #$7688, #$76C8,
      #$76C6, #$76C3, #$76C5, #$7701, #$76F9, #$76F8, #$7709, #$770B,
      #$76FE, #$76FC, #$7707, #$77DC, #$7802, #$7814, #$780C, #$780D,
      #$7946, #$7949, #$7948, #$7947, #$79B9, #$79BA, #$79D1, #$79D2,
      #$79CB, #$7A7F, #$7A81, #$7AFF, #$7AFD, #$7C7D, #$7D02, #$7D05,
      #$7D00, #$7D09, #$7D07, #$7D04, #$7D06, #$7F38,
      #$7F8E, #$7FBF, #$8010, #$800D, #$8011, #$8036, #$80D6, #$80E5,
      #$80DA, #$80C3, #$80C4, #$80CC, #$80E1, #$80DB, #$80CE, #$80DE,
      #$80E4, #$80DD, #$81F4, #$8222, #$82E7, #$8303, #$8305, #$82E3,
      #$82DB, #$82E6, #$8304, #$82E5, #$8302, #$8309, #$82D2, #$82D7,
      #$82F1, #$8301, #$82DC, #$82D4, #$82D1, #$82DE, #$82D3, #$82DF,
      #$82EF, #$8306, #$8650, #$8679, #$867B, #$867A, #$884D, #$886B,
      #$8981, #$89D4, #$8A08, #$8A02, #$8A03, #$8C9E, #$8CA0, #$8D74,
      #$8D73, #$8DB4, #$8ECD, #$8ECC, #$8FF0, #$8FE6, #$8FE2, #$8FEA,
      #$8FE5, #$8FED, #$8FEB, #$8FE4, #$8FE8, #$90CA, #$90CE, #$90C1,
      #$90C3, #$914B, #$914A, #$91CD, #$9582, #$9650, #$964B, #$964C,
      #$964D, #$9762, #$9769, #$97CB, #$97ED, #$97F3, #$9801, #$98A8,
      #$98DB, #$98DF, #$9996, #$9999, #$4E58, #$4EB3,
      #$500C, #$500D, #$5023, #$4FEF, #$5026, #$5025, #$4FF8, #$5029,
      #$5016, #$5006, #$503C, #$501F, #$501A, #$5012, #$5011, #$4FFA,
      #$5000, #$5014, #$5028, #$4FF1, #$5021, #$500B, #$5019, #$5018,
      #$4FF3, #$4FEE, #$502D, #$502A, #$4FFE, #$502B, #$5009, #$517C,
      #$51A4, #$51A5, #$51A2, #$51CD, #$51CC, #$51C6, #$51CB, #$5256,
      #$525C, #$5254, #$525B, #$525D, #$532A, #$537F, #$539F, #$539D,
      #$53DF, #$54E8, #$5510, #$5501, #$5537, #$54FC, #$54E5, #$54F2,
      #$5506, #$54FA, #$5514, #$54E9, #$54ED, #$54E1, #$5509, #$54EE,
      #$54EA, #$54E6, #$5527, #$5507, #$54FD, #$550F, #$5703, #$5704,
      #$57C2, #$57D4, #$57CB, #$57C3, #$5809, #$590F, #$5957, #$5958,
      #$595A, #$5A11, #$5A18, #$5A1C, #$5A1F, #$5A1B, #$5A13, #$59EC,
      #$5A20, #$5A23, #$5A29, #$5A25, #$5A0C, #$5A09,
      #$5B6B, #$5C58, #$5BB0, #$5BB3, #$5BB6, #$5BB4, #$5BAE, #$5BB5,
      #$5BB9, #$5BB8, #$5C04, #$5C51, #$5C55, #$5C50, #$5CED, #$5CFD,
      #$5CFB, #$5CEA, #$5CE8, #$5CF0, #$5CF6, #$5D01, #$5CF4, #$5DEE,
      #$5E2D, #$5E2B, #$5EAB, #$5EAD, #$5EA7, #$5F31, #$5F92, #$5F91,
      #$5F90, #$6059, #$6063, #$6065, #$6050, #$6055, #$606D, #$6069,
      #$606F, #$6084, #$609F, #$609A, #$608D, #$6094, #$608C, #$6085,
      #$6096, #$6247, #$62F3, #$6308, #$62FF, #$634E, #$633E, #$632F,
      #$6355, #$6342, #$6346, #$634F, #$6349, #$633A, #$6350, #$633D,
      #$632A, #$632B, #$6328, #$634D, #$634C, #$6548, #$6549, #$6599,
      #$65C1, #$65C5, #$6642, #$6649, #$664F, #$6643, #$6652, #$664C,
      #$6645, #$6641, #$66F8, #$6714, #$6715, #$6717, #$6821, #$6838,
      #$6848, #$6846, #$6853, #$6839, #$6842, #$6854,
      #$6829, #$68B3, #$6817, #$684C, #$6851, #$683D, #$67F4, #$6850,
      #$6840, #$683C, #$6843, #$682A, #$6845, #$6813, #$6818, #$6841,
      #$6B8A, #$6B89, #$6BB7, #$6C23, #$6C27, #$6C28, #$6C26, #$6C24,
      #$6CF0, #$6D6A, #$6D95, #$6D88, #$6D87, #$6D66, #$6D78, #$6D77,
      #$6D59, #$6D93, #$6D6C, #$6D89, #$6D6E, #$6D5A, #$6D74, #$6D69,
      #$6D8C, #$6D8A, #$6D79, #$6D85, #$6D65, #$6D94, #$70CA, #$70D8,
      #$70E4, #$70D9, #$70C8, #$70CF, #$7239, #$7279, #$72FC, #$72F9,
      #$72FD, #$72F8, #$72F7, #$7386, #$73ED, #$7409, #$73EE, #$73E0,
      #$73EA, #$73DE, #$7554, #$755D, #$755C, #$755A, #$7559, #$75BE,
      #$75C5, #$75C7, #$75B2, #$75B3, #$75BD, #$75BC, #$75B9, #$75C2,
      #$75B8, #$768B, #$76B0, #$76CA, #$76CD, #$76CE, #$7729, #$771F,
      #$7720, #$7728, #$77E9, #$7830, #$7827, #$7838,
      #$781D, #$7834, #$7837, #$7825, #$782D, #$7820, #$781F, #$7832,
      #$7955, #$7950, #$7960, #$795F, #$7956, #$795E, #$795D, #$7957,
      #$795A, #$79E4, #$79E3, #$79E7, #$79DF, #$79E6, #$79E9, #$79D8,
      #$7A84, #$7A88, #$7AD9, #$7B06, #$7B11, #$7C89, #$7D21, #$7D17,
      #$7D0B, #$7D0A, #$7D20, #$7D22, #$7D14, #$7D10, #$7D15, #$7D1A,
      #$7D1C, #$7D0D, #$7D19, #$7D1B, #$7F3A, #$7F5F, #$7F94, #$7FC5,
      #$7FC1, #$8006, #$8004, #$8018, #$8015, #$8019, #$8017, #$803D,
      #$803F, #$80F1, #$8102, #$80F0, #$8105, #$80ED, #$80F4, #$8106,
      #$80F8, #$80F3, #$8108, #$80FD, #$810A, #$80FC, #$80EF, #$81ED,
      #$81EC, #$8200, #$8210, #$822A, #$822B, #$8228, #$822C, #$82BB,
      #$832B, #$8352, #$8354, #$834A, #$8338, #$8350, #$8349, #$8335,
      #$8334, #$834F, #$8332, #$8339, #$8336, #$8317,
      #$8340, #$8331, #$8328, #$8343, #$8654, #$868A, #$86AA, #$8693,
      #$86A4, #$86A9, #$868C, #$86A3, #$869C, #$8870, #$8877, #$8881,
      #$8882, #$887D, #$8879, #$8A18, #$8A10, #$8A0E, #$8A0C, #$8A15,
      #$8A0A, #$8A17, #$8A13, #$8A16, #$8A0F, #$8A11, #$8C48, #$8C7A,
      #$8C79, #$8CA1, #$8CA2, #$8D77, #$8EAC, #$8ED2, #$8ED4, #$8ECF,
      #$8FB1, #$9001, #$9006, #$8FF7, #$9000, #$8FFA, #$8FF4, #$9003,
      #$8FFD, #$9005, #$8FF8, #$9095, #$90E1, #$90DD, #$90E2, #$9152,
      #$914D, #$914C, #$91D8, #$91DD, #$91D7, #$91DC, #$91D9, #$9583,
      #$9662, #$9663, #$9661, #$965B, #$965D, #$9664, #$9658, #$965E,
      #$96BB, #$98E2, #$99AC, #$9AA8, #$9AD8, #$9B25, #$9B32, #$9B3C,
      #$4E7E, #$507A, #$507D, #$505C, #$5047, #$5043, #$504C, #$505A,
      #$5049, #$5065, #$5076, #$504E, #$5055, #$5075,
      #$5074, #$5077, #$504F, #$500F, #$506F, #$506D, #$515C, #$5195,
      #$51F0, #$526A, #$526F, #$52D2, #$52D9, #$52D8, #$52D5, #$5310,
      #$530F, #$5319, #$533F, #$5340, #$533E, #$53C3, #$66FC, #$5546,
      #$556A, #$5566, #$5544, #$555E, #$5561, #$5543, #$554A, #$5531,
      #$5556, #$554F, #$5555, #$552F, #$5564, #$5538, #$552E, #$555C,
      #$552C, #$5563, #$5533, #$5541, #$5557, #$5708, #$570B, #$5709,
      #$57DF, #$5805, #$580A, #$5806, #$57E0, #$57E4, #$57FA, #$5802,
      #$5835, #$57F7, #$57F9, #$5920, #$5962, #$5A36, #$5A41, #$5A49,
      #$5A66, #$5A6A, #$5A40, #$5A3C, #$5A62, #$5A5A, #$5A46, #$5A4A,
      #$5B70, #$5BC7, #$5BC5, #$5BC4, #$5BC2, #$5BBF, #$5BC6, #$5C09,
      #$5C08, #$5C07, #$5C60, #$5C5C, #$5C5D, #$5D07, #$5D06, #$5D0E,
      #$5D1B, #$5D16, #$5D22, #$5D11, #$5D29, #$5D14,
      #$5D19, #$5D24, #$5D27, #$5D17, #$5DE2, #$5E38, #$5E36, #$5E33,
      #$5E37, #$5EB7, #$5EB8, #$5EB6, #$5EB5, #$5EBE, #$5F35, #$5F37,
      #$5F57, #$5F6C, #$5F69, #$5F6B, #$5F97, #$5F99, #$5F9E, #$5F98,
      #$5FA1, #$5FA0, #$5F9C, #$607F, #$60A3, #$6089, #$60A0, #$60A8,
      #$60CB, #$60B4, #$60E6, #$60BD, #$60C5, #$60BB, #$60B5, #$60DC,
      #$60BC, #$60D8, #$60D5, #$60C6, #$60DF, #$60B8, #$60DA, #$60C7,
      #$621A, #$621B, #$6248, #$63A0, #$63A7, #$6372, #$6396, #$63A2,
      #$63A5, #$6377, #$6367, #$6398, #$63AA, #$6371, #$63A9, #$6389,
      #$6383, #$639B, #$636B, #$63A8, #$6384, #$6388, #$6399, #$63A1,
      #$63AC, #$6392, #$638F, #$6380, #$637B, #$6369, #$6368, #$637A,
      #$655D, #$6556, #$6551, #$6559, #$6557, #$555F, #$654F, #$6558,
      #$6555, #$6554, #$659C, #$659B, #$65AC, #$65CF,
      #$65CB, #$65CC, #$65CE, #$665D, #$665A, #$6664, #$6668, #$6666,
      #$665E, #$66F9, #$52D7, #$671B, #$6881, #$68AF, #$68A2, #$6893,
      #$68B5, #$687F, #$6876, #$68B1, #$68A7, #$6897, #$68B0, #$6883,
      #$68C4, #$68AD, #$6886, #$6885, #$6894, #$689D, #$68A8, #$689F,
      #$68A1, #$6882, #$6B32, #$6BBA, #$6BEB, #$6BEC, #$6C2B, #$6D8E,
      #$6DBC, #$6DF3, #$6DD9, #$6DB2, #$6DE1, #$6DCC, #$6DE4, #$6DFB,
      #$6DFA, #$6E05, #$6DC7, #$6DCB, #$6DAF, #$6DD1, #$6DAE, #$6DDE,
      #$6DF9, #$6DB8, #$6DF7, #$6DF5, #$6DC5, #$6DD2, #$6E1A, #$6DB5,
      #$6DDA, #$6DEB, #$6DD8, #$6DEA, #$6DF1, #$6DEE, #$6DE8, #$6DC6,
      #$6DC4, #$6DAA, #$6DEC, #$6DBF, #$6DE6, #$70F9, #$7109, #$710A,
      #$70FD, #$70EF, #$723D, #$727D, #$7281, #$731C, #$731B, #$7316,
      #$7313, #$7319, #$7387, #$7405, #$740A, #$7403,
      #$7406, #$73FE, #$740D, #$74E0, #$74F6, #$74F7, #$751C, #$7522,
      #$7565, #$7566, #$7562, #$7570, #$758F, #$75D4, #$75D5, #$75B5,
      #$75CA, #$75CD, #$768E, #$76D4, #$76D2, #$76DB, #$7737, #$773E,
      #$773C, #$7736, #$7738, #$773A, #$786B, #$7843, #$784E, #$7965,
      #$7968, #$796D, #$79FB, #$7A92, #$7A95, #$7B20, #$7B28, #$7B1B,
      #$7B2C, #$7B26, #$7B19, #$7B1E, #$7B2E, #$7C92, #$7C97, #$7C95,
      #$7D46, #$7D43, #$7D71, #$7D2E, #$7D39, #$7D3C, #$7D40, #$7D30,
      #$7D33, #$7D44, #$7D2F, #$7D42, #$7D32, #$7D31, #$7F3D, #$7F9E,
      #$7F9A, #$7FCC, #$7FCE, #$7FD2, #$801C, #$804A, #$8046, #$812F,
      #$8116, #$8123, #$812B, #$8129, #$8130, #$8124, #$8202, #$8235,
      #$8237, #$8236, #$8239, #$838E, #$839E, #$8398, #$8378, #$83A2,
      #$8396, #$83BD, #$83AB, #$8392, #$838A, #$8393,
      #$8389, #$83A0, #$8377, #$837B, #$837C, #$8386, #$83A7, #$8655,
      #$5F6A, #$86C7, #$86C0, #$86B6, #$86C4, #$86B5, #$86C6, #$86CB,
      #$86B1, #$86AF, #$86C9, #$8853, #$889E, #$8888, #$88AB, #$8892,
      #$8896, #$888D, #$888B, #$8993, #$898F, #$8A2A, #$8A1D, #$8A23,
      #$8A25, #$8A31, #$8A2D, #$8A1F, #$8A1B, #$8A22, #$8C49, #$8C5A,
      #$8CA9, #$8CAC, #$8CAB, #$8CA8, #$8CAA, #$8CA7, #$8D67, #$8D66,
      #$8DBE, #$8DBA, #$8EDB, #$8EDF, #$9019, #$900D, #$901A, #$9017,
      #$9023, #$901F, #$901D, #$9010, #$9015, #$901E, #$9020, #$900F,
      #$9022, #$9016, #$901B, #$9014, #$90E8, #$90ED, #$90FD, #$9157,
      #$91CE, #$91F5, #$91E6, #$91E3, #$91E7, #$91ED, #$91E9, #$9589,
      #$966A, #$9675, #$9673, #$9678, #$9670, #$9674, #$9676, #$9677,
      #$966C, #$96C0, #$96EA, #$96E9, #$7AE0, #$7ADF,
      #$9802, #$9803, #$9B5A, #$9CE5, #$9E75, #$9E7F, #$9EA5, #$9EBB,
      #$50A2, #$508D, #$5085, #$5099, #$5091, #$5080, #$5096, #$5098,
      #$509A, #$6700, #$51F1, #$5272, #$5274, #$5275, #$5269, #$52DE,
      #$52DD, #$52DB, #$535A, #$53A5, #$557B, #$5580, #$55A7, #$557C,
      #$558A, #$559D, #$5598, #$5582, #$559C, #$55AA, #$5594, #$5587,
      #$558B, #$5583, #$55B3, #$55AE, #$559F, #$553E, #$55B2, #$559A,
      #$55BB, #$55AC, #$55B1, #$557E, #$5589, #$55AB, #$5599, #$570D,
      #$582F, #$582A, #$5834, #$5824, #$5830, #$5831, #$5821, #$581D,
      #$5820, #$58F9, #$58FA, #$5960, #$5A77, #$5A9A, #$5A7F, #$5A92,
      #$5A9B, #$5AA7, #$5B73, #$5B71, #$5BD2, #$5BCC, #$5BD3, #$5BD0,
      #$5C0A, #$5C0B, #$5C31, #$5D4C, #$5D50, #$5D34, #$5D47, #$5DFD,
      #$5E45, #$5E3D, #$5E40, #$5E43, #$5E7E, #$5ECA,
      #$5EC1, #$5EC2, #$5EC4, #$5F3C, #$5F6D, #$5FA9, #$5FAA, #$5FA8,
      #$60D1, #$60E1, #$60B2, #$60B6, #$60E0, #$611C, #$6123, #$60FA,
      #$6115, #$60F0, #$60FB, #$60F4, #$6168, #$60F1, #$610E, #$60F6,
      #$6109, #$6100, #$6112, #$621F, #$6249, #$63A3, #$638C, #$63CF,
      #$63C0, #$63E9, #$63C9, #$63C6, #$63CD, #$63D2, #$63E3, #$63D0,
      #$63E1, #$63D6, #$63ED, #$63EE, #$6376, #$63F4, #$63EA, #$63DB,
      #$6452, #$63DA, #$63F9, #$655E, #$6566, #$6562, #$6563, #$6591,
      #$6590, #$65AF, #$666E, #$6670, #$6674, #$6676, #$666F, #$6691,
      #$667A, #$667E, #$6677, #$66FE, #$66FF, #$671F, #$671D, #$68FA,
      #$68D5, #$68E0, #$68D8, #$68D7, #$6905, #$68DF, #$68F5, #$68EE,
      #$68E7, #$68F9, #$68D2, #$68F2, #$68E3, #$68CB, #$68CD, #$690D,
      #$6912, #$690E, #$68C9, #$68DA, #$696E, #$68FB,
      #$6B3E, #$6B3A, #$6B3D, #$6B98, #$6B96, #$6BBC, #$6BEF, #$6C2E,
      #$6C2F, #$6C2C, #$6E2F, #$6E38, #$6E54, #$6E21, #$6E32, #$6E67,
      #$6E4A, #$6E20, #$6E25, #$6E23, #$6E1B, #$6E5B, #$6E58, #$6E24,
      #$6E56, #$6E6E, #$6E2D, #$6E26, #$6E6F, #$6E34, #$6E4D, #$6E3A,
      #$6E2C, #$6E43, #$6E1D, #$6E3E, #$6ECB, #$6E89, #$6E19, #$6E4E,
      #$6E63, #$6E44, #$6E72, #$6E69, #$6E5F, #$7119, #$711A, #$7126,
      #$7130, #$7121, #$7136, #$716E, #$711C, #$724C, #$7284, #$7280,
      #$7336, #$7325, #$7334, #$7329, #$743A, #$742A, #$7433, #$7422,
      #$7425, #$7435, #$7436, #$7434, #$742F, #$741B, #$7426, #$7428,
      #$7525, #$7526, #$756B, #$756A, #$75E2, #$75DB, #$75E3, #$75D9,
      #$75D8, #$75DE, #$75E0, #$767B, #$767C, #$7696, #$7693, #$76B4,
      #$76DC, #$774F, #$77ED, #$785D, #$786C, #$786F,
      #$7A0D, #$7A08, #$7A0B, #$7A05, #$7A00, #$7A98, #$7A97, #$7A96,
      #$7AE5, #$7AE3, #$7B49, #$7B56, #$7B46, #$7B50, #$7B52, #$7B54,
      #$7B4D, #$7B4B, #$7B4F, #$7B51, #$7C9F, #$7CA5, #$7D5E, #$7D50,
      #$7D68, #$7D55, #$7D2B, #$7D6E, #$7D72, #$7D61, #$7D66, #$7D62,
      #$7D70, #$7D73, #$5584, #$7FD4, #$7FD5, #$800B, #$8052, #$8085,
      #$8155, #$8154, #$814B, #$8151, #$814E, #$8139, #$8146, #$813E,
      #$814C, #$8153, #$8174, #$8212, #$821C, #$83E9, #$8403, #$83F8,
      #$840D, #$83E0, #$83C5, #$840B, #$83C1, #$83EF, #$83F1, #$83F4,
      #$8457, #$840A, #$83F0, #$840C, #$83CC, #$83FD, #$83F2, #$83CA,
      #$8438, #$840E, #$8404, #$83DC, #$8407, #$83D4, #$83DF, #$865B,
      #$86DF, #$86D9, #$86ED, #$86D4, #$86DB, #$86E4, #$86D0, #$86DE,
      #$8857, #$88C1, #$88C2, #$88B1, #$8983, #$8996,
      #$8A3B, #$8A60, #$8A55, #$8A5E, #$8A3C, #$8A41, #$8A54, #$8A5B,
      #$8A50, #$8A46, #$8A34, #$8A3A, #$8A36, #$8A56, #$8C61, #$8C82,
      #$8CAF, #$8CBC, #$8CB3, #$8CBD, #$8CC1, #$8CBB, #$8CC0, #$8CB4,
      #$8CB7, #$8CB6, #$8CBF, #$8CB8, #$8D8A, #$8D85, #$8D81, #$8DCE,
      #$8DDD, #$8DCB, #$8DDA, #$8DD1, #$8DCC, #$8DDB, #$8DC6, #$8EFB,
      #$8EF8, #$8EFC, #$8F9C, #$902E, #$9035, #$9031, #$9038, #$9032,
      #$9036, #$9102, #$90F5, #$9109, #$90FE, #$9163, #$9165, #$91CF,
      #$9214, #$9215, #$9223, #$9209, #$921E, #$920D, #$9210, #$9207,
      #$9211, #$9594, #$958F, #$958B, #$9591, #$9593, #$9592, #$958E,
      #$968A, #$968E, #$968B, #$967D, #$9685, #$9686, #$968D, #$9672,
      #$9684, #$96C1, #$96C5, #$96C4, #$96C6, #$96C7, #$96EF, #$96F2,
      #$97CC, #$9805, #$9806, #$9808, #$98E7, #$98EA,
      #$98EF, #$98E9, #$98F2, #$98ED, #$99AE, #$99AD, #$9EC3, #$9ECD,
      #$9ED1, #$4E82, #$50AD, #$50B5, #$50B2, #$50B3, #$50C5, #$50BE,
      #$50AC, #$50B7, #$50BB, #$50AF, #$50C7, #$527F, #$5277, #$527D,
      #$52DF, #$52E6, #$52E4, #$52E2, #$52E3, #$532F, #$55DF, #$55E8,
      #$55D3, #$55E6, #$55CE, #$55DC, #$55C7, #$55D1, #$55E3, #$55E4,
      #$55EF, #$55DA, #$55E1, #$55C5, #$55C6, #$55E5, #$55C9, #$5712,
      #$5713, #$585E, #$5851, #$5858, #$5857, #$585A, #$5854, #$586B,
      #$584C, #$586D, #$584A, #$5862, #$5852, #$584B, #$5967, #$5AC1,
      #$5AC9, #$5ACC, #$5ABE, #$5ABD, #$5ABC, #$5AB3, #$5AC2, #$5AB2,
      #$5D69, #$5D6F, #$5E4C, #$5E79, #$5EC9, #$5EC8, #$5F12, #$5F59,
      #$5FAC, #$5FAE, #$611A, #$610F, #$6148, #$611F, #$60F3, #$611B,
      #$60F9, #$6101, #$6108, #$614E, #$614C, #$6144,
      #$614D, #$613E, #$6134, #$6127, #$610D, #$6106, #$6137, #$6221,
      #$6222, #$6413, #$643E, #$641E, #$642A, #$642D, #$643D, #$642C,
      #$640F, #$641C, #$6414, #$640D, #$6436, #$6416, #$6417, #$6406,
      #$656C, #$659F, #$65B0, #$6697, #$6689, #$6687, #$6688, #$6696,
      #$6684, #$6698, #$668D, #$6703, #$6994, #$696D, #$695A, #$6977,
      #$6960, #$6954, #$6975, #$6930, #$6982, #$694A, #$6968, #$696B,
      #$695E, #$6953, #$6979, #$6986, #$695D, #$6963, #$695B, #$6B47,
      #$6B72, #$6BC0, #$6BBF, #$6BD3, #$6BFD, #$6EA2, #$6EAF, #$6ED3,
      #$6EB6, #$6EC2, #$6E90, #$6E9D, #$6EC7, #$6EC5, #$6EA5, #$6E98,
      #$6EBC, #$6EBA, #$6EAB, #$6ED1, #$6E96, #$6E9C, #$6EC4, #$6ED4,
      #$6EAA, #$6EA7, #$6EB4, #$714E, #$7159, #$7169, #$7164, #$7149,
      #$7167, #$715C, #$716C, #$7166, #$714C, #$7165,
      #$715E, #$7146, #$7168, #$7156, #$723A, #$7252, #$7337, #$7345,
      #$733F, #$733E, #$746F, #$745A, #$7455, #$745F, #$745E, #$7441,
      #$743F, #$7459, #$745B, #$745C, #$7576, #$7578, #$7600, #$75F0,
      #$7601, #$75F2, #$75F1, #$75FA, #$75FF, #$75F4, #$75F3, #$76DE,
      #$76DF, #$775B, #$776B, #$7766, #$775E, #$7763, #$7779, #$776A,
      #$776C, #$775C, #$7765, #$7768, #$7762, #$77EE, #$788E, #$78B0,
      #$7897, #$7898, #$788C, #$7889, #$787C, #$7891, #$7893, #$787F,
      #$797A, #$797F, #$7981, #$842C, #$79BD, #$7A1C, #$7A1A, #$7A20,
      #$7A14, #$7A1F, #$7A1E, #$7A9F, #$7AA0, #$7B77, #$7BC0, #$7B60,
      #$7B6E, #$7B67, #$7CB1, #$7CB3, #$7CB5, #$7D93, #$7D79, #$7D91,
      #$7D81, #$7D8F, #$7D5B, #$7F6E, #$7F69, #$7F6A, #$7F72, #$7FA9,
      #$7FA8, #$7FA4, #$8056, #$8058, #$8086, #$8084,
      #$8171, #$8170, #$8178, #$8165, #$816E, #$8173, #$816B, #$8179,
      #$817A, #$8166, #$8205, #$8247, #$8482, #$8477, #$843D, #$8431,
      #$8475, #$8466, #$846B, #$8449, #$846C, #$845B, #$843C, #$8435,
      #$8461, #$8463, #$8469, #$846D, #$8446, #$865E, #$865C, #$865F,
      #$86F9, #$8713, #$8708, #$8707, #$8700, #$86FE, #$86FB, #$8702,
      #$8703, #$8706, #$870A, #$8859, #$88DF, #$88D4, #$88D9, #$88DC,
      #$88D8, #$88DD, #$88E1, #$88CA, #$88D5, #$88D2, #$899C, #$89E3,
      #$8A6B, #$8A72, #$8A73, #$8A66, #$8A69, #$8A70, #$8A87, #$8A7C,
      #$8A63, #$8AA0, #$8A71, #$8A85, #$8A6D, #$8A62, #$8A6E, #$8A6C,
      #$8A79, #$8A7B, #$8A3E, #$8A68, #$8C62, #$8C8A, #$8C89, #$8CCA,
      #$8CC7, #$8CC8, #$8CC4, #$8CB2, #$8CC3, #$8CC2, #$8CC5, #$8DE1,
      #$8DDF, #$8DE8, #$8DEF, #$8DF3, #$8DFA, #$8DEA,
      #$8DE4, #$8DE6, #$8EB2, #$8F03, #$8F09, #$8EFE, #$8F0A, #$8F9F,
      #$8FB2, #$904B, #$904A, #$9053, #$9042, #$9054, #$903C, #$9055,
      #$9050, #$9047, #$904F, #$904E, #$904D, #$9051, #$903E, #$9041,
      #$9112, #$9117, #$916C, #$916A, #$9169, #$91C9, #$9237, #$9257,
      #$9238, #$923D, #$9240, #$923E, #$925B, #$924B, #$9264, #$9251,
      #$9234, #$9249, #$924D, #$9245, #$9239, #$923F, #$925A, #$9598,
      #$9698, #$9694, #$9695, #$96CD, #$96CB, #$96C9, #$96CA, #$96F7,
      #$96FB, #$96F9, #$96F6, #$9756, #$9774, #$9776, #$9810, #$9811,
      #$9813, #$980A, #$9812, #$980C, #$98FC, #$98F4, #$98FD, #$98FE,
      #$99B3, #$99B1, #$99B4, #$9AE1, #$9CE9, #$9E82, #$9F0E, #$9F13,
      #$9F20, #$50E7, #$50EE, #$50E5, #$50D6, #$50ED, #$50DA, #$50D5,
      #$50CF, #$50D1, #$50F1, #$50CE, #$50E9, #$5162,
      #$51F3, #$5283, #$5282, #$5331, #$53AD, #$55FE, #$5600, #$561B,
      #$5617, #$55FD, #$5614, #$5606, #$5609, #$560D, #$560E, #$55F7,
      #$5616, #$561F, #$5608, #$5610, #$55F6, #$5718, #$5716, #$5875,
      #$587E, #$5883, #$5893, #$588A, #$5879, #$5885, #$587D, #$58FD,
      #$5925, #$5922, #$5924, #$596A, #$5969, #$5AE1, #$5AE6, #$5AE9,
      #$5AD7, #$5AD6, #$5AD8, #$5AE3, #$5B75, #$5BDE, #$5BE7, #$5BE1,
      #$5BE5, #$5BE6, #$5BE8, #$5BE2, #$5BE4, #$5BDF, #$5C0D, #$5C62,
      #$5D84, #$5D87, #$5E5B, #$5E63, #$5E55, #$5E57, #$5E54, #$5ED3,
      #$5ED6, #$5F0A, #$5F46, #$5F70, #$5FB9, #$6147, #$613F, #$614B,
      #$6177, #$6162, #$6163, #$615F, #$615A, #$6158, #$6175, #$622A,
      #$6487, #$6458, #$6454, #$64A4, #$6478, #$645F, #$647A, #$6451,
      #$6467, #$6434, #$646D, #$647B, #$6572, #$65A1,
      #$65D7, #$65D6, #$66A2, #$66A8, #$669D, #$699C, #$69A8, #$6995,
      #$69C1, #$69AE, #$69D3, #$69CB, #$699B, #$69B7, #$69BB, #$69AB,
      #$69B4, #$69D0, #$69CD, #$69AD, #$69CC, #$69A6, #$69C3, #$69A3,
      #$6B49, #$6B4C, #$6C33, #$6F33, #$6F14, #$6EFE, #$6F13, #$6EF4,
      #$6F29, #$6F3E, #$6F20, #$6F2C, #$6F0F, #$6F02, #$6F22, #$6EFF,
      #$6EEF, #$6F06, #$6F31, #$6F38, #$6F32, #$6F23, #$6F15, #$6F2B,
      #$6F2F, #$6F88, #$6F2A, #$6EEC, #$6F01, #$6EF2, #$6ECC, #$6EF7,
      #$7194, #$7199, #$717D, #$718A, #$7184, #$7192, #$723E, #$7292,
      #$7296, #$7344, #$7350, #$7464, #$7463, #$746A, #$7470, #$746D,
      #$7504, #$7591, #$7627, #$760D, #$760B, #$7609, #$7613, #$76E1,
      #$76E3, #$7784, #$777D, #$777F, #$7761, #$78C1, #$789F, #$78A7,
      #$78B3, #$78A9, #$78A3, #$798E, #$798F, #$798D,
      #$7A2E, #$7A31, #$7AAA, #$7AA9, #$7AED, #$7AEF, #$7BA1, #$7B95,
      #$7B8B, #$7B75, #$7B97, #$7B9D, #$7B94, #$7B8F, #$7BB8, #$7B87,
      #$7B84, #$7CB9, #$7CBD, #$7CBE, #$7DBB, #$7DB0, #$7D9C, #$7DBD,
      #$7DBE, #$7DA0, #$7DCA, #$7DB4, #$7DB2, #$7DB1, #$7DBA, #$7DA2,
      #$7DBF, #$7DB5, #$7DB8, #$7DAD, #$7DD2, #$7DC7, #$7DAC, #$7F70,
      #$7FE0, #$7FE1, #$7FDF, #$805E, #$805A, #$8087, #$8150, #$8180,
      #$818F, #$8188, #$818A, #$817F, #$8182, #$81E7, #$81FA, #$8207,
      #$8214, #$821E, #$824B, #$84C9, #$84BF, #$84C6, #$84C4, #$8499,
      #$849E, #$84B2, #$849C, #$84CB, #$84B8, #$84C0, #$84D3, #$8490,
      #$84BC, #$84D1, #$84CA, #$873F, #$871C, #$873B, #$8722, #$8725,
      #$8734, #$8718, #$8755, #$8737, #$8729, #$88F3, #$8902, #$88F4,
      #$88F9, #$88F8, #$88FD, #$88E8, #$891A, #$88EF,
      #$8AA6, #$8A8C, #$8A9E, #$8AA3, #$8A8D, #$8AA1, #$8A93, #$8AA4,
      #$8AAA, #$8AA5, #$8AA8, #$8A98, #$8A91, #$8A9A, #$8AA7, #$8C6A,
      #$8C8D, #$8C8C, #$8CD3, #$8CD1, #$8CD2, #$8D6B, #$8D99, #$8D95,
      #$8DFC, #$8F14, #$8F12, #$8F15, #$8F13, #$8FA3, #$9060, #$9058,
      #$905C, #$9063, #$9059, #$905E, #$9062, #$905D, #$905B, #$9119,
      #$9118, #$911E, #$9175, #$9178, #$9177, #$9174, #$9278, #$92AC,
      #$9280, #$9285, #$9298, #$9296, #$927B, #$9293, #$929C, #$92A8,
      #$927C, #$9291, #$95A1, #$95A8, #$95A9, #$95A3, #$95A5, #$95A4,
      #$9699, #$969C, #$969B, #$96CC, #$96D2, #$9700, #$977C, #$9785,
      #$97F6, #$9817, #$9818, #$98AF, #$98B1, #$9903, #$9905, #$990C,
      #$9909, #$99C1, #$9AAF, #$9AB0, #$9AE6, #$9B41, #$9B42, #$9CF4,
      #$9CF6, #$9CF3, #$9EBC, #$9F3B, #$9F4A, #$5104,
      #$5100, #$50FB, #$50F5, #$50F9, #$5102, #$5108, #$5109, #$5105,
      #$51DC, #$5287, #$5288, #$5289, #$528D, #$528A, #$52F0, #$53B2,
      #$562E, #$563B, #$5639, #$5632, #$563F, #$5634, #$5629, #$5653,
      #$564E, #$5657, #$5674, #$5636, #$562F, #$5630, #$5880, #$589F,
      #$589E, #$58B3, #$589C, #$58AE, #$58A9, #$58A6, #$596D, #$5B09,
      #$5AFB, #$5B0B, #$5AF5, #$5B0C, #$5B08, #$5BEE, #$5BEC, #$5BE9,
      #$5BEB, #$5C64, #$5C65, #$5D9D, #$5D94, #$5E62, #$5E5F, #$5E61,
      #$5EE2, #$5EDA, #$5EDF, #$5EDD, #$5EE3, #$5EE0, #$5F48, #$5F71,
      #$5FB7, #$5FB5, #$6176, #$6167, #$616E, #$615D, #$6155, #$6182,
      #$617C, #$6170, #$616B, #$617E, #$61A7, #$6190, #$61AB, #$618E,
      #$61AC, #$619A, #$61A4, #$6194, #$61AE, #$622E, #$6469, #$646F,
      #$6479, #$649E, #$64B2, #$6488, #$6490, #$64B0,
      #$64A5, #$6493, #$6495, #$64A9, #$6492, #$64AE, #$64AD, #$64AB,
      #$649A, #$64AC, #$6499, #$64A2, #$64B3, #$6575, #$6577, #$6578,
      #$66AE, #$66AB, #$66B4, #$66B1, #$6A23, #$6A1F, #$69E8, #$6A01,
      #$6A1E, #$6A19, #$69FD, #$6A21, #$6A13, #$6A0A, #$69F3, #$6A02,
      #$6A05, #$69ED, #$6A11, #$6B50, #$6B4E, #$6BA4, #$6BC5, #$6BC6,
      #$6F3F, #$6F7C, #$6F84, #$6F51, #$6F66, #$6F54, #$6F86, #$6F6D,
      #$6F5B, #$6F78, #$6F6E, #$6F8E, #$6F7A, #$6F70, #$6F64, #$6F97,
      #$6F58, #$6ED5, #$6F6F, #$6F60, #$6F5F, #$719F, #$71AC, #$71B1,
      #$71A8, #$7256, #$729B, #$734E, #$7357, #$7469, #$748B, #$7483,
      #$747E, #$7480, #$757F, #$7620, #$7629, #$761F, #$7624, #$7626,
      #$7621, #$7622, #$769A, #$76BA, #$76E4, #$778E, #$7787, #$778C,
      #$7791, #$778B, #$78CB, #$78C5, #$78BA, #$78CA,
      #$78BE, #$78D5, #$78BC, #$78D0, #$7A3F, #$7A3C, #$7A40, #$7A3D,
      #$7A37, #$7A3B, #$7AAF, #$7AAE, #$7BAD, #$7BB1, #$7BC4, #$7BB4,
      #$7BC6, #$7BC7, #$7BC1, #$7BA0, #$7BCC, #$7CCA, #$7DE0, #$7DF4,
      #$7DEF, #$7DFB, #$7DD8, #$7DEC, #$7DDD, #$7DE8, #$7DE3, #$7DDA,
      #$7DDE, #$7DE9, #$7D9E, #$7DD9, #$7DF2, #$7DF9, #$7F75, #$7F77,
      #$7FAF, #$7FE9, #$8026, #$819B, #$819C, #$819D, #$81A0, #$819A,
      #$8198, #$8517, #$853D, #$851A, #$84EE, #$852C, #$852D, #$8513,
      #$8511, #$8523, #$8521, #$8514, #$84EC, #$8525, #$84FF, #$8506,
      #$8782, #$8774, #$8776, #$8760, #$8766, #$8778, #$8768, #$8759,
      #$8757, #$874C, #$8753, #$885B, #$885D, #$8910, #$8907, #$8912,
      #$8913, #$8915, #$890A, #$8ABC, #$8AD2, #$8AC7, #$8AC4, #$8A95,
      #$8ACB, #$8AF8, #$8AB2, #$8AC9, #$8AC2, #$8ABF,
      #$8AB0, #$8AD6, #$8ACD, #$8AB6, #$8AB9, #$8ADB, #$8C4C, #$8C4E,
      #$8C6C, #$8CE0, #$8CDE, #$8CE6, #$8CE4, #$8CEC, #$8CED, #$8CE2,
      #$8CE3, #$8CDC, #$8CEA, #$8CE1, #$8D6D, #$8D9F, #$8DA3, #$8E2B,
      #$8E10, #$8E1D, #$8E22, #$8E0F, #$8E29, #$8E1F, #$8E21, #$8E1E,
      #$8EBA, #$8F1D, #$8F1B, #$8F1F, #$8F29, #$8F26, #$8F2A, #$8F1C,
      #$8F1E, #$8F25, #$9069, #$906E, #$9068, #$906D, #$9077, #$9130,
      #$912D, #$9127, #$9131, #$9187, #$9189, #$918B, #$9183, #$92C5,
      #$92BB, #$92B7, #$92EA, #$92E4, #$92C1, #$92B3, #$92BC, #$92D2,
      #$92C7, #$92F0, #$92B2, #$95AD, #$95B1, #$9704, #$9706, #$9707,
      #$9709, #$9760, #$978D, #$978B, #$978F, #$9821, #$982B, #$981C,
      #$98B3, #$990A, #$9913, #$9912, #$9918, #$99DD, #$99D0, #$99DF,
      #$99DB, #$99D1, #$99D5, #$99D2, #$99D9, #$9AB7,
      #$9AEE, #$9AEF, #$9B27, #$9B45, #$9B44, #$9B77, #$9B6F, #$9D06,
      #$9D09, #$9D03, #$9EA9, #$9EBE, #$9ECE, #$58A8, #$9F52, #$5112,
      #$5118, #$5114, #$5110, #$5115, #$5180, #$51AA, #$51DD, #$5291,
      #$5293, #$52F3, #$5659, #$566B, #$5679, #$5669, #$5664, #$5678,
      #$566A, #$5668, #$5665, #$5671, #$566F, #$566C, #$5662, #$5676,
      #$58C1, #$58BE, #$58C7, #$58C5, #$596E, #$5B1D, #$5B34, #$5B78,
      #$5BF0, #$5C0E, #$5F4A, #$61B2, #$6191, #$61A9, #$618A, #$61CD,
      #$61B6, #$61BE, #$61CA, #$61C8, #$6230, #$64C5, #$64C1, #$64CB,
      #$64BB, #$64BC, #$64DA, #$64C4, #$64C7, #$64C2, #$64CD, #$64BF,
      #$64D2, #$64D4, #$64BE, #$6574, #$66C6, #$66C9, #$66B9, #$66C4,
      #$66C7, #$66B8, #$6A3D, #$6A38, #$6A3A, #$6A59, #$6A6B, #$6A58,
      #$6A39, #$6A44, #$6A62, #$6A61, #$6A4B, #$6A47,
      #$6A35, #$6A5F, #$6A48, #$6B59, #$6B77, #$6C05, #$6FC2, #$6FB1,
      #$6FA1, #$6FC3, #$6FA4, #$6FC1, #$6FA7, #$6FB3, #$6FC0, #$6FB9,
      #$6FB6, #$6FA6, #$6FA0, #$6FB4, #$71BE, #$71C9, #$71D0, #$71D2,
      #$71C8, #$71D5, #$71B9, #$71CE, #$71D9, #$71DC, #$71C3, #$71C4,
      #$7368, #$749C, #$74A3, #$7498, #$749F, #$749E, #$74E2, #$750C,
      #$750D, #$7634, #$7638, #$763A, #$76E7, #$76E5, #$77A0, #$779E,
      #$779F, #$77A5, #$78E8, #$78DA, #$78EC, #$78E7, #$79A6, #$7A4D,
      #$7A4E, #$7A46, #$7A4C, #$7A4B, #$7ABA, #$7BD9, #$7C11, #$7BC9,
      #$7BE4, #$7BDB, #$7BE1, #$7BE9, #$7BE6, #$7CD5, #$7CD6, #$7E0A,
      #$7E11, #$7E08, #$7E1B, #$7E23, #$7E1E, #$7E1D, #$7E09, #$7E10,
      #$7F79, #$7FB2, #$7FF0, #$7FF1, #$7FEE, #$8028, #$81B3, #$81A9,
      #$81A8, #$81FB, #$8208, #$8258, #$8259, #$854A,
      #$8559, #$8548, #$8568, #$8569, #$8543, #$8549, #$856D, #$856A,
      #$855E, #$8783, #$879F, #$879E, #$87A2, #$878D, #$8861, #$892A,
      #$8932, #$8925, #$892B, #$8921, #$89AA, #$89A6, #$8AE6, #$8AFA,
      #$8AEB, #$8AF1, #$8B00, #$8ADC, #$8AE7, #$8AEE, #$8AFE, #$8B01,
      #$8B02, #$8AF7, #$8AED, #$8AF3, #$8AF6, #$8AFC, #$8C6B, #$8C6D,
      #$8C93, #$8CF4, #$8E44, #$8E31, #$8E34, #$8E42, #$8E39, #$8E35,
      #$8F3B, #$8F2F, #$8F38, #$8F33, #$8FA8, #$8FA6, #$9075, #$9074,
      #$9078, #$9072, #$907C, #$907A, #$9134, #$9192, #$9320, #$9336,
      #$92F8, #$9333, #$932F, #$9322, #$92FC, #$932B, #$9304, #$931A,
      #$9310, #$9326, #$9321, #$9315, #$932E, #$9319, #$95BB, #$96A7,
      #$96A8, #$96AA, #$96D5, #$970E, #$9711, #$9716, #$970D, #$9713,
      #$970F, #$975B, #$975C, #$9766, #$9798, #$9830,
      #$9838, #$983B, #$9837, #$982D, #$9839, #$9824, #$9910, #$9928,
      #$991E, #$991B, #$9921, #$991A, #$99ED, #$99E2, #$99F1, #$9AB8,
      #$9ABC, #$9AFB, #$9AED, #$9B28, #$9B91, #$9D15, #$9D23, #$9D26,
      #$9D28, #$9D12, #$9D1B, #$9ED8, #$9ED4, #$9F8D, #$9F9C, #$512A,
      #$511F, #$5121, #$5132, #$52F5, #$568E, #$5680, #$5690, #$5685,
      #$5687, #$568F, #$58D5, #$58D3, #$58D1, #$58CE, #$5B30, #$5B2A,
      #$5B24, #$5B7A, #$5C37, #$5C68, #$5DBC, #$5DBA, #$5DBD, #$5DB8,
      #$5E6B, #$5F4C, #$5FBD, #$61C9, #$61C2, #$61C7, #$61E6, #$61CB,
      #$6232, #$6234, #$64CE, #$64CA, #$64D8, #$64E0, #$64F0, #$64E6,
      #$64EC, #$64F1, #$64E2, #$64ED, #$6582, #$6583, #$66D9, #$66D6,
      #$6A80, #$6A94, #$6A84, #$6AA2, #$6A9C, #$6ADB, #$6AA3, #$6A7E,
      #$6A97, #$6A90, #$6AA0, #$6B5C, #$6BAE, #$6BDA,
      #$6C08, #$6FD8, #$6FF1, #$6FDF, #$6FE0, #$6FDB, #$6FE4, #$6FEB,
      #$6FEF, #$6F80, #$6FEC, #$6FE1, #$6FE9, #$6FD5, #$6FEE, #$6FF0,
      #$71E7, #$71DF, #$71EE, #$71E6, #$71E5, #$71ED, #$71EC, #$71F4,
      #$71E0, #$7235, #$7246, #$7370, #$7372, #$74A9, #$74B0, #$74A6,
      #$74A8, #$7646, #$7642, #$764C, #$76EA, #$77B3, #$77AA, #$77B0,
      #$77AC, #$77A7, #$77AD, #$77EF, #$78F7, #$78FA, #$78F4, #$78EF,
      #$7901, #$79A7, #$79AA, #$7A57, #$7ABF, #$7C07, #$7C0D, #$7BFE,
      #$7BF7, #$7C0C, #$7BE0, #$7CE0, #$7CDC, #$7CDE, #$7CE2, #$7CDF,
      #$7CD9, #$7CDD, #$7E2E, #$7E3E, #$7E46, #$7E37, #$7E32, #$7E43,
      #$7E2B, #$7E3D, #$7E31, #$7E45, #$7E41, #$7E34, #$7E39, #$7E48,
      #$7E35, #$7E3F, #$7E2F, #$7F44, #$7FF3, #$7FFC, #$8071, #$8072,
      #$8070, #$806F, #$8073, #$81C6, #$81C3, #$81BA,
      #$81C2, #$81C0, #$81BF, #$81BD, #$81C9, #$81BE, #$81E8, #$8209,
      #$8271, #$85AA, #$8584, #$857E, #$859C, #$8591, #$8594, #$85AF,
      #$859B, #$8587, #$85A8, #$858A, #$85A6, #$8667, #$87C0, #$87D1,
      #$87B3, #$87D2, #$87C6, #$87AB, #$87BB, #$87BA, #$87C8, #$87CB,
      #$893B, #$8936, #$8944, #$8938, #$893D, #$89AC, #$8B0E, #$8B17,
      #$8B19, #$8B1B, #$8B0A, #$8B20, #$8B1D, #$8B04, #$8B10, #$8C41,
      #$8C3F, #$8C73, #$8CFA, #$8CFD, #$8CFC, #$8CF8, #$8CFB, #$8DA8,
      #$8E49, #$8E4B, #$8E48, #$8E4A, #$8F44, #$8F3E, #$8F42, #$8F45,
      #$8F3F, #$907F, #$907D, #$9084, #$9081, #$9082, #$9080, #$9139,
      #$91A3, #$919E, #$919C, #$934D, #$9382, #$9328, #$9375, #$934A,
      #$9365, #$934B, #$9318, #$937E, #$936C, #$935B, #$9370, #$935A,
      #$9354, #$95CA, #$95CB, #$95CC, #$95C8, #$95C6,
      #$96B1, #$96B8, #$96D6, #$971C, #$971E, #$97A0, #$97D3, #$9846,
      #$98B6, #$9935, #$9A01, #$99FF, #$9BAE, #$9BAB, #$9BAA, #$9BAD,
      #$9D3B, #$9D3F, #$9E8B, #$9ECF, #$9EDE, #$9EDC, #$9EDD, #$9EDB,
      #$9F3E, #$9F4B, #$53E2, #$5695, #$56AE, #$58D9, #$58D8, #$5B38,
      #$5F5E, #$61E3, #$6233, #$64F4, #$64F2, #$64FE, #$6506, #$64FA,
      #$64FB, #$64F7, #$65B7, #$66DC, #$6726, #$6AB3, #$6AAC, #$6AC3,
      #$6ABB, #$6AB8, #$6AC2, #$6AAE, #$6AAF, #$6B5F, #$6B78, #$6BAF,
      #$7009, #$700B, #$6FFE, #$7006, #$6FFA, #$7011, #$700F, #$71FB,
      #$71FC, #$71FE, #$71F8, #$7377, #$7375, #$74A7, #$74BF, #$7515,
      #$7656, #$7658, #$7652, #$77BD, #$77BF, #$77BB, #$77BC, #$790E,
      #$79AE, #$7A61, #$7A62, #$7A60, #$7AC4, #$7AC5, #$7C2B, #$7C27,
      #$7C2A, #$7C1E, #$7C23, #$7C21, #$7CE7, #$7E54,
      #$7E55, #$7E5E, #$7E5A, #$7E61, #$7E52, #$7E59, #$7F48, #$7FF9,
      #$7FFB, #$8077, #$8076, #$81CD, #$81CF, #$820A, #$85CF, #$85A9,
      #$85CD, #$85D0, #$85C9, #$85B0, #$85BA, #$85B9, #$87EF, #$87EC,
      #$87F2, #$87E0, #$8986, #$89B2, #$89F4, #$8B28, #$8B39, #$8B2C,
      #$8B2B, #$8C50, #$8D05, #$8E59, #$8E63, #$8E66, #$8E64, #$8E5F,
      #$8E55, #$8EC0, #$8F49, #$8F4D, #$9087, #$9083, #$9088, #$91AB,
      #$91AC, #$91D0, #$9394, #$938A, #$9396, #$93A2, #$93B3, #$93AE,
      #$93AC, #$93B0, #$9398, #$939A, #$9397, #$95D4, #$95D6, #$95D0,
      #$95D5, #$96E2, #$96DC, #$96D9, #$96DB, #$96DE, #$9724, #$97A3,
      #$97A6, #$97AD, #$97F9, #$984D, #$984F, #$984C, #$984E, #$9853,
      #$98BA, #$993E, #$993F, #$993D, #$992E, #$99A5, #$9A0E, #$9AC1,
      #$9B03, #$9B06, #$9B4F, #$9B4E, #$9B4D, #$9BCA,
      #$9BC9, #$9BFD, #$9BC8, #$9BC0, #$9D51, #$9D5D, #$9D60, #$9EE0,
      #$9F15, #$9F2C, #$5133, #$56A5, #$56A8, #$58DE, #$58DF, #$58E2,
      #$5BF5, #$9F90, #$5EEC, #$61F2, #$61F7, #$61F6, #$61F5, #$6500,
      #$650F, #$66E0, #$66DD, #$6AE5, #$6ADD, #$6ADA, #$6AD3, #$701B,
      #$701F, #$7028, #$701A, #$701D, #$7015, #$7018, #$7206, #$720D,
      #$7258, #$72A2, #$7378, #$737A, #$74BD, #$74CA, #$74E3, #$7587,
      #$7586, #$765F, #$7661, #$77C7, #$7919, #$79B1, #$7A6B, #$7A69,
      #$7C3E, #$7C3F, #$7C38, #$7C3D, #$7C37, #$7C40, #$7E6B, #$7E6D,
      #$7E79, #$7E69, #$7E6A, #$7E73, #$7F85, #$7FB6, #$7FB9, #$7FB8,
      #$81D8, #$85E9, #$85DD, #$85EA, #$85D5, #$85E4, #$85E5, #$85F7,
      #$87FB, #$8805, #$880D, #$87F9, #$87FE, #$8960, #$895F, #$8956,
      #$895E, #$8B41, #$8B5C, #$8B58, #$8B49, #$8B5A,
      #$8B4E, #$8B4F, #$8B46, #$8B59, #$8D08, #$8D0A, #$8E7C, #$8E72,
      #$8E87, #$8E76, #$8E6C, #$8E7A, #$8E74, #$8F54, #$8F4E, #$8FAD,
      #$908A, #$908B, #$91B1, #$91AE, #$93E1, #$93D1, #$93DF, #$93C3,
      #$93C8, #$93DC, #$93DD, #$93D6, #$93E2, #$93CD, #$93D8, #$93E4,
      #$93D7, #$93E8, #$95DC, #$96B4, #$96E3, #$972A, #$9727, #$9761,
      #$97DC, #$97FB, #$985E, #$9858, #$985B, #$98BC, #$9945, #$9949,
      #$9A16, #$9A19, #$9B0D, #$9BE8, #$9BE7, #$9BD6, #$9BDB, #$9D89,
      #$9D61, #$9D72, #$9D6A, #$9D6C, #$9E92, #$9E97, #$9E93, #$9EB4,
      #$52F8, #$56B7, #$56B6, #$56B4, #$56BC, #$58E4, #$5B40, #$5B43,
      #$5B7D, #$5BF6, #$5DC9, #$61F8, #$61FA, #$6518, #$6514, #$6519,
      #$66E6, #$6727, #$6AEC, #$703E, #$7030, #$7032, #$7210, #$737B,
      #$74CF, #$7662, #$7665, #$7926, #$792A, #$792C,
      #$792B, #$7AC7, #$7AF6, #$7C4C, #$7C43, #$7C4D, #$7CEF, #$7CF0,
      #$8FAE, #$7E7D, #$7E7C, #$7E82, #$7F4C, #$8000, #$81DA, #$8266,
      #$85FB, #$85F9, #$8611, #$85FA, #$8606, #$860B, #$8607, #$860A,
      #$8814, #$8815, #$8964, #$89BA, #$89F8, #$8B70, #$8B6C, #$8B66,
      #$8B6F, #$8B5F, #$8B6B, #$8D0F, #$8D0D, #$8E89, #$8E81, #$8E85,
      #$8E82, #$91B4, #$91CB, #$9418, #$9403, #$93FD, #$95E1, #$9730,
      #$98C4, #$9952, #$9951, #$99A8, #$9A2B, #$9A30, #$9A37, #$9A35,
      #$9C13, #$9C0D, #$9E79, #$9EB5, #$9EE8, #$9F2F, #$9F5F, #$9F63,
      #$9F61, #$5137, #$5138, #$56C1, #$56C0, #$56C2, #$5914, #$5C6C,
      #$5DCD, #$61FC, #$61FE, #$651D, #$651C, #$6595, #$66E9, #$6AFB,
      #$6B04, #$6AFA, #$6BB2, #$704C, #$721B, #$72A7, #$74D6, #$74D4,
      #$7669, #$77D3, #$7C50, #$7E8F, #$7E8C, #$7FBC,
      #$8617, #$862D, #$861A, #$8823, #$8822, #$8821, #$881F, #$896A,
      #$896C, #$89BD, #$8B74, #$8B77, #$8B7D, #$8D13, #$8E8A, #$8E8D,
      #$8E8B, #$8F5F, #$8FAF, #$91BA, #$942E, #$9433, #$9435, #$943A,
      #$9438, #$9432, #$942B, #$95E2, #$9738, #$9739, #$9732, #$97FF,
      #$9867, #$9865, #$9957, #$9A45, #$9A43, #$9A40, #$9A3E, #$9ACF,
      #$9B54, #$9B51, #$9C2D, #$9C25, #$9DAF, #$9DB4, #$9DC2, #$9DB8,
      #$9E9D, #$9EEF, #$9F19, #$9F5C, #$9F66, #$9F67, #$513C, #$513B,
      #$56C8, #$56CA, #$56C9, #$5B7F, #$5DD4, #$5DD2, #$5F4E, #$61FF,
      #$6524, #$6B0A, #$6B61, #$7051, #$7058, #$7380, #$74E4, #$758A,
      #$766E, #$766C, #$79B3, #$7C60, #$7C5F, #$807E, #$807D, #$81DF,
      #$8972, #$896F, #$89FC, #$8B80, #$8D16, #$8D17, #$8E91, #$8E93,
      #$8F61, #$9148, #$9444, #$9451, #$9452, #$973D,
      #$973E, #$97C3, #$97C1, #$986B, #$9955, #$9A55, #$9A4D, #$9AD2,
      #$9B1A, #$9C49, #$9C31, #$9C3E, #$9C3B, #$9DD3, #$9DD7, #$9F34,
      #$9F6C, #$9F6A, #$9F94, #$56CC, #$5DD6, #$6200, #$6523, #$652B,
      #$652A, #$66EC, #$6B10, #$74DA, #$7ACA, #$7C64, #$7C63, #$7C65,
      #$7E93, #$7E96, #$7E94, #$81E2, #$8638, #$863F, #$8831, #$8B8A,
      #$9090, #$908F, #$9463, #$9460, #$9464, #$9768, #$986F, #$995C,
      #$9A5A, #$9A5B, #$9A57, #$9AD3, #$9AD4, #$9AD1, #$9C54, #$9C57,
      #$9C56, #$9DE5, #$9E9F, #$9EF4, #$56D1, #$58E9, #$652C, #$705E,
      #$7671, #$7672, #$77D7, #$7F50, #$7F88, #$8836, #$8839, #$8862,
      #$8B93, #$8B92, #$8B96, #$8277, #$8D1B, #$91C0, #$946A, #$9742,
      #$9748, #$9744, #$97C6, #$9870, #$9A5F, #$9B22, #$9B58, #$9C5F,
      #$9DF9, #$9DFA, #$9E7C, #$9E7D, #$9F07, #$9F77,
      #$9F72, #$5EF3, #$6B16, #$7063, #$7C6C, #$7C6E, #$883B, #$89C0,
      #$8EA1, #$91C1, #$9472, #$9470, #$9871, #$995E, #$9AD6, #$9B23,
      #$9ECC, #$7064, #$77DA, #$8B9A, #$9477, #$97C9, #$9A62, #$9A65,
      #$7E9C, #$8B9C, #$8EAA, #$91C5, #$947D, #$947E, #$947C, #$9C77,
      #$9C78, #$9EF7, #$8C54, #$947F, #$9E1A, #$7228, #$9A6A, #$9B31,
      #$9E1B, #$9E1E, #$7C72);
  CNS11643_2Map: array[0..7649] of TBuffChar = (
      #$4E42, #$4E5C, #$51F5, #$531A, #$5382, #$4E07, #$4E0C, #$4E47,
      #$4E8D, #$56D7, #$5C6E, #$5F73, #$4E0F, #$5187, #$4E0E, #$4E2E,
      #$4E93, #$4EC2, #$4EC9, #$4EC8, #$5198, #$52FC, #$536C, #$53B9,
      #$5720, #$5903, #$592C, #$5C10, #$5DFF, #$65E1, #$6BB3, #$6BCC,
      #$6C14, #$723F, #$4E31, #$4E3C, #$4EE8, #$4EDC, #$4EE9, #$4EE1,
      #$4EDD, #$4EDA, #$520C, #$5209, #$531C, #$534C, #$5722, #$5723,
      #$5917, #$592F, #$5B81, #$5B84, #$5C12, #$5C3B, #$5C74, #$5C73,
      #$5E04, #$5E80, #$5E82, #$5FC9, #$6209, #$6250, #$6C15, #$6C36,
      #$6C43, #$6C3F, #$6C3B, #$72AE, #$72B0, #$738A, #$79B8, #$808A,
      #$961E, #$4F0E, #$4F18, #$4F2C, #$4EF5, #$4F14, #$4EF1, #$4F00,
      #$4EF7, #$4F08, #$4F1D, #$4F02, #$4F05, #$4F22, #$4F13, #$4F04,
      #$4EF4, #$4F12, #$51B1, #$5213, #$5210, #$52A6,
      #$5322, #$531F, #$534D, #$538A, #$5407, #$56E1, #$56DF, #$572E,
      #$572A, #$5734, #$593C, #$5980, #$597C, #$5985, #$597B, #$597E,
      #$5977, #$597F, #$5B56, #$5C15, #$5C25, #$5C7C, #$5C7A, #$5C7B,
      #$5C7E, #$5DDF, #$5E75, #$5E84, #$5F02, #$5F1A, #$5F74, #$5FD5,
      #$5FD4, #$5FCF, #$625C, #$625E, #$6264, #$6261, #$6266, #$6262,
      #$6259, #$6260, #$625A, #$6265, #$6537, #$65EF, #$65EE, #$673E,
      #$6739, #$6738, #$673B, #$673A, #$673F, #$673C, #$6733, #$6C18,
      #$6C46, #$6C52, #$6C5C, #$6C4F, #$6C4A, #$6C54, #$6C4B, #$6C4C,
      #$7071, #$725E, #$72B4, #$72B5, #$738E, #$752A, #$767F, #$7A75,
      #$7F51, #$8278, #$827C, #$8280, #$827D, #$827F, #$864D, #$897E,
      #$9099, #$9097, #$9098, #$909B, #$9094, #$9622, #$9624, #$9620,
      #$9623, #$4F56, #$4F3B, #$4F62, #$4F49, #$4F53,
      #$4F64, #$4F3E, #$4F67, #$4F52, #$4F5F, #$4F41, #$4F58, #$4F2D,
      #$4F33, #$4F3F, #$4F61, #$518F, #$51B9, #$521C, #$521E, #$5221,
      #$52AD, #$52AE, #$5309, #$5363, #$5372, #$538E, #$538F, #$5430,
      #$5437, #$542A, #$5454, #$5445, #$5419, #$541C, #$5425, #$5418,
      #$543D, #$544F, #$5441, #$5428, #$5424, #$5447, #$56EE, #$56E7,
      #$56E5, #$5741, #$5745, #$574C, #$5749, #$574B, #$5752, #$5906,
      #$5940, #$59A6, #$5998, #$59A0, #$5997, #$598E, #$59A2, #$5990,
      #$598F, #$59A7, #$59A1, #$5B8E, #$5B92, #$5C28, #$5C2A, #$5C8D,
      #$5C8F, #$5C88, #$5C8B, #$5C89, #$5C92, #$5C8A, #$5C86, #$5C93,
      #$5C95, #$5DE0, #$5E0A, #$5E0E, #$5E8B, #$5E89, #$5E8C, #$5E88,
      #$5E8D, #$5F05, #$5F1D, #$5F78, #$5F76, #$5FD2, #$5FD1, #$5FD0,
      #$5FED, #$5FE8, #$5FEE, #$5FF3, #$5FE1, #$5FE4,
      #$5FE3, #$5FFA, #$5FEF, #$5FF7, #$5FFB, #$6000, #$5FF4, #$623A,
      #$6283, #$628C, #$628E, #$628F, #$6294, #$6287, #$6271, #$627B,
      #$627A, #$6270, #$6281, #$6288, #$6277, #$627D, #$6272, #$6274,
      #$65F0, #$65F4, #$65F3, #$65F2, #$65F5, #$6745, #$6747, #$6759,
      #$6755, #$674C, #$6748, #$675D, #$674D, #$675A, #$674B, #$6BD0,
      #$6C19, #$6C1A, #$6C78, #$6C67, #$6C6B, #$6C84, #$6C8B, #$6C8F,
      #$6C71, #$6C6F, #$6C69, #$6C9A, #$6C6D, #$6C87, #$6C95, #$6C9C,
      #$6C66, #$6C73, #$6C65, #$6C7B, #$6C8E, #$7074, #$707A, #$7263,
      #$72BF, #$72BD, #$72C3, #$72C6, #$72C1, #$72BA, #$72C5, #$7395,
      #$7397, #$7393, #$7394, #$7392, #$753A, #$7539, #$7594, #$7595,
      #$7681, #$793D, #$8034, #$8095, #$8099, #$8090, #$8092, #$809C,
      #$8290, #$828F, #$8285, #$828E, #$8291, #$8293,
      #$828A, #$8283, #$8284, #$8C78, #$8FC9, #$8FBF, #$909F, #$90A1,
      #$90A5, #$909E, #$90A7, #$90A0, #$9630, #$9628, #$962F, #$962D,
      #$4E33, #$4F98, #$4F7C, #$4F85, #$4F7D, #$4F80, #$4F87, #$4F76,
      #$4F74, #$4F89, #$4F84, #$4F77, #$4F4C, #$4F97, #$4F6A, #$4F9A,
      #$4F79, #$4F81, #$4F78, #$4F90, #$4F9C, #$4F94, #$4F9E, #$4F92,
      #$4F82, #$4F95, #$4F6B, #$4F6E, #$519E, #$51BC, #$51BE, #$5235,
      #$5232, #$5233, #$5246, #$5231, #$52BC, #$530A, #$530B, #$533C,
      #$5392, #$5394, #$5487, #$547F, #$5481, #$5491, #$5482, #$5488,
      #$546B, #$547A, #$547E, #$5465, #$546C, #$5474, #$5466, #$548D,
      #$546F, #$5461, #$5460, #$5498, #$5463, #$5467, #$5464, #$56F7,
      #$56F9, #$576F, #$5772, #$576D, #$576B, #$5771, #$5770, #$5776,
      #$5780, #$5775, #$577B, #$5773, #$5774, #$5762,
      #$5768, #$577D, #$590C, #$5945, #$59B5, #$59BA, #$59CF, #$59CE,
      #$59B2, #$59CC, #$59C1, #$59B6, #$59BC, #$59C3, #$59D6, #$59B1,
      #$59BD, #$59C0, #$59C8, #$59B4, #$59C7, #$5B62, #$5B65, #$5B93,
      #$5B95, #$5C44, #$5C47, #$5CAE, #$5CA4, #$5CA0, #$5CB5, #$5CAF,
      #$5CA8, #$5CAC, #$5C9F, #$5CA3, #$5CAD, #$5CA2, #$5CAA, #$5CA7,
      #$5C9D, #$5CA5, #$5CB6, #$5CB0, #$5CA6, #$5E17, #$5E14, #$5E19,
      #$5F28, #$5F22, #$5F23, #$5F24, #$5F54, #$5F82, #$5F7E, #$5F7D,
      #$5FDE, #$5FE5, #$602D, #$6026, #$6019, #$6032, #$600B, #$6034,
      #$600A, #$6017, #$6033, #$601A, #$601E, #$602C, #$6022, #$600D,
      #$6010, #$602E, #$6013, #$6011, #$600C, #$6009, #$601C, #$6214,
      #$623D, #$62AD, #$62B4, #$62D1, #$62BE, #$62AA, #$62B6, #$62CA,
      #$62AE, #$62B3, #$62AF, #$62BB, #$62A9, #$62B0,
      #$62B8, #$653D, #$65A8, #$65BB, #$6609, #$65FC, #$6604, #$6612,
      #$6608, #$65FB, #$6603, #$660B, #$660D, #$6605, #$65FD, #$6611,
      #$6610, #$66F6, #$670A, #$6785, #$676C, #$678E, #$6792, #$6776,
      #$677B, #$6798, #$6786, #$6784, #$6774, #$678D, #$678C, #$677A,
      #$679F, #$6791, #$6799, #$6783, #$677D, #$6781, #$6778, #$6779,
      #$6794, #$6B25, #$6B80, #$6B7E, #$6BDE, #$6C1D, #$6C93, #$6CEC,
      #$6CEB, #$6CEE, #$6CD9, #$6CB6, #$6CD4, #$6CAD, #$6CE7, #$6CB7,
      #$6CD0, #$6CC2, #$6CBA, #$6CC3, #$6CC6, #$6CED, #$6CF2, #$6CD2,
      #$6CDD, #$6CB4, #$6C8A, #$6C9D, #$6C80, #$6CDE, #$6CC0, #$6D30,
      #$6CCD, #$6CC7, #$6CB0, #$6CF9, #$6CCF, #$6CE9, #$6CD1, #$7094,
      #$7098, #$7085, #$7093, #$7086, #$7084, #$7091, #$7096, #$7082,
      #$709A, #$7083, #$726A, #$72D6, #$72CB, #$72D8,
      #$72C9, #$72DC, #$72D2, #$72D4, #$72DA, #$72CC, #$72D1, #$73A4,
      #$73A1, #$73AD, #$73A6, #$73A2, #$73A0, #$73AC, #$739D, #$74DD,
      #$74E8, #$753F, #$7540, #$753E, #$758C, #$7598, #$76AF, #$76F3,
      #$76F1, #$76F0, #$76F5, #$77F8, #$77FC, #$77F9, #$77FB, #$77FA,
      #$77F7, #$7942, #$793F, #$79C5, #$7A78, #$7A7B, #$7AFB, #$7C75,
      #$7CFD, #$8035, #$808F, #$80AE, #$80A3, #$80B8, #$80B5, #$80AD,
      #$8220, #$82A0, #$82C0, #$82AB, #$829A, #$8298, #$829B, #$82B5,
      #$82A7, #$82AE, #$82BC, #$829E, #$82BA, #$82B4, #$82A8, #$82A1,
      #$82A9, #$82C2, #$82A4, #$82C3, #$82B6, #$82A2, #$8670, #$866F,
      #$866D, #$866E, #$8C56, #$8FD2, #$8FCB, #$8FD3, #$8FCD, #$8FD6,
      #$8FD5, #$8FD7, #$90B2, #$90B4, #$90AF, #$90B3, #$90B0, #$9639,
      #$963D, #$963C, #$963A, #$9643, #$4FCD, #$4FC5,
      #$4FD3, #$4FB2, #$4FC9, #$4FCB, #$4FC1, #$4FD4, #$4FDC, #$4FD9,
      #$4FBB, #$4FB3, #$4FDB, #$4FC7, #$4FD6, #$4FBA, #$4FC0, #$4FB9,
      #$4FEC, #$5244, #$5249, #$52C0, #$52C2, #$533D, #$537C, #$5397,
      #$5396, #$5399, #$5398, #$54BA, #$54A1, #$54AD, #$54A5, #$54CF,
      #$54C3, #$830D, #$54B7, #$54AE, #$54D6, #$54B6, #$54C5, #$54C6,
      #$54A0, #$5470, #$54BC, #$54A2, #$54BE, #$5472, #$54DE, #$54B0,
      #$57B5, #$579E, #$579F, #$57A4, #$578C, #$5797, #$579D, #$579B,
      #$5794, #$5798, #$578F, #$5799, #$57A5, #$579A, #$5795, #$58F4,
      #$590D, #$5953, #$59E1, #$59DE, #$59EE, #$5A00, #$59F1, #$59DD,
      #$59FA, #$59FD, #$59FC, #$59F6, #$59E4, #$59F2, #$59F7, #$59DB,
      #$59E9, #$59F3, #$59F5, #$59E0, #$59FE, #$59F4, #$59ED, #$5BA8,
      #$5C4C, #$5CD0, #$5CD8, #$5CCC, #$5CD7, #$5CCB,
      #$5CDB, #$5CDE, #$5CDA, #$5CC9, #$5CC7, #$5CCA, #$5CD6, #$5CD3,
      #$5CD4, #$5CCF, #$5CC8, #$5CC6, #$5CCE, #$5CDF, #$5CF8, #$5DF9,
      #$5E21, #$5E22, #$5E23, #$5E20, #$5E24, #$5EB0, #$5EA4, #$5EA2,
      #$5E9B, #$5EA3, #$5EA5, #$5F07, #$5F2E, #$5F56, #$5F86, #$6037,
      #$6039, #$6054, #$6072, #$605E, #$6045, #$6053, #$6047, #$6049,
      #$605B, #$604C, #$6040, #$6042, #$605F, #$6024, #$6044, #$6058,
      #$6066, #$606E, #$6242, #$6243, #$62CF, #$630D, #$630B, #$62F5,
      #$630E, #$6303, #$62EB, #$62F9, #$630F, #$630C, #$62F8, #$62F6,
      #$6300, #$6313, #$6314, #$62FA, #$6315, #$62FB, #$62F0, #$6541,
      #$6543, #$65AA, #$65BF, #$6636, #$6621, #$6632, #$6635, #$661C,
      #$6626, #$6622, #$6633, #$662B, #$663A, #$661D, #$6634, #$6639,
      #$662E, #$670F, #$6710, #$67C1, #$67F2, #$67C8,
      #$67BA, #$67DC, #$67BB, #$67F8, #$67D8, #$67C0, #$67B7, #$67C5,
      #$67EB, #$67E4, #$67DF, #$67B5, #$67CD, #$67B3, #$67F7, #$67F6,
      #$67EE, #$67E3, #$67C2, #$67B9, #$67CE, #$67E7, #$67F0, #$67B2,
      #$67FC, #$67C6, #$67ED, #$67CC, #$67AE, #$67E6, #$67DB, #$67FA,
      #$67C9, #$67CA, #$67C3, #$67EA, #$67CB, #$6B28, #$6B82, #$6B84,
      #$6BB6, #$6BD6, #$6BD8, #$6BE0, #$6C20, #$6C21, #$6D28, #$6D34,
      #$6D2D, #$6D1F, #$6D3C, #$6D3F, #$6D12, #$6D0A, #$6CDA, #$6D33,
      #$6D04, #$6D19, #$6D3A, #$6D1A, #$6D11, #$6D00, #$6D1D, #$6D42,
      #$6D01, #$6D18, #$6D37, #$6D03, #$6D0F, #$6D40, #$6D07, #$6D20,
      #$6D2C, #$6D08, #$6D22, #$6D09, #$6D10, #$70B7, #$709F, #$70BE,
      #$70B1, #$70B0, #$70A1, #$70B4, #$70B5, #$70A9, #$7241, #$7249,
      #$724A, #$726C, #$7270, #$7273, #$726E, #$72CA,
      #$72E4, #$72E8, #$72EB, #$72DF, #$72EA, #$72E6, #$72E3, #$7385,
      #$73CC, #$73C2, #$73C8, #$73C5, #$73B9, #$73B6, #$73B5, #$73B4,
      #$73EB, #$73BF, #$73C7, #$73BE, #$73C3, #$73C6, #$73B8, #$73CB,
      #$74EC, #$74EE, #$752E, #$7547, #$7548, #$75A7, #$75AA, #$7679,
      #$76C4, #$7708, #$7703, #$7704, #$7705, #$770A, #$76F7, #$76FB,
      #$76FA, #$77E7, #$77E8, #$7806, #$7811, #$7812, #$7805, #$7810,
      #$780F, #$780E, #$7809, #$7803, #$7813, #$794A, #$794C, #$794B,
      #$7945, #$7944, #$79D5, #$79CD, #$79CF, #$79D6, #$79CE, #$7A80,
      #$7A7E, #$7AD1, #$7B00, #$7B01, #$7C7A, #$7C78, #$7C79, #$7C7F,
      #$7C80, #$7C81, #$7D03, #$7D08, #$7D01, #$7F58, #$7F91, #$7F8D,
      #$7FBE, #$8007, #$800E, #$800F, #$8014, #$8037, #$80D8, #$80C7,
      #$80E0, #$80D1, #$80C8, #$80C2, #$80D0, #$80C5,
      #$80E3, #$80D9, #$80DC, #$80CA, #$80D5, #$80C9, #$80CF, #$80D7,
      #$80E6, #$80CD, #$81FF, #$8221, #$8294, #$82D9, #$82FE, #$82F9,
      #$8307, #$82E8, #$8300, #$82D5, #$833A, #$82EB, #$82D6, #$82F4,
      #$82EC, #$82E1, #$82F2, #$82F5, #$830C, #$82FB, #$82F6, #$82F0,
      #$82EA, #$82E4, #$82E0, #$82FA, #$82F3, #$82ED, #$8677, #$8674,
      #$867C, #$8673, #$8841, #$884E, #$8867, #$886A, #$8869, #$89D3,
      #$8A04, #$8A07, #$8D72, #$8FE3, #$8FE1, #$8FEE, #$8FE0, #$90F1,
      #$90BD, #$90BF, #$90D5, #$90C5, #$90BE, #$90C7, #$90CB, #$90C8,
      #$91D4, #$91D3, #$9654, #$964F, #$9651, #$9653, #$964A, #$964E,
      #$501E, #$5005, #$5007, #$5013, #$5022, #$5030, #$501B, #$4FF5,
      #$4FF4, #$5033, #$5037, #$502C, #$4FF6, #$4FF7, #$5017, #$501C,
      #$5020, #$5027, #$5035, #$502F, #$5031, #$500E,
      #$515A, #$5194, #$5193, #$51CA, #$51C4, #$51C5, #$51C8, #$51CE,
      #$5261, #$525A, #$5252, #$525E, #$525F, #$5255, #$5262, #$52CD,
      #$530E, #$539E, #$5526, #$54E2, #$5517, #$5512, #$54E7, #$54F3,
      #$54E4, #$551A, #$54FF, #$5504, #$5508, #$54EB, #$5511, #$5505,
      #$54F1, #$550A, #$54FB, #$54F7, #$54F8, #$54E0, #$550E, #$5503,
      #$550B, #$5701, #$5702, #$57CC, #$5832, #$57D5, #$57D2, #$57BA,
      #$57C6, #$57BD, #$57BC, #$57B8, #$57B6, #$57BF, #$57C7, #$57D0,
      #$57B9, #$57C1, #$590E, #$594A, #$5A19, #$5A16, #$5A2D, #$5A2E,
      #$5A15, #$5A0F, #$5A17, #$5A0A, #$5A1E, #$5A33, #$5B6C, #$5BA7,
      #$5BAD, #$5BAC, #$5C03, #$5C56, #$5C54, #$5CEC, #$5CFF, #$5CEE,
      #$5CF1, #$5CF7, #$5D00, #$5CF9, #$5E29, #$5E28, #$5EA8, #$5EAE,
      #$5EAA, #$5EAC, #$5F33, #$5F30, #$5F67, #$605D,
      #$605A, #$6067, #$6041, #$60A2, #$6088, #$6080, #$6092, #$6081,
      #$609D, #$6083, #$6095, #$609B, #$6097, #$6087, #$609C, #$608E,
      #$6219, #$6246, #$62F2, #$6310, #$6356, #$632C, #$6344, #$6345,
      #$6336, #$6343, #$63E4, #$6339, #$634B, #$634A, #$633C, #$6329,
      #$6341, #$6334, #$6358, #$6354, #$6359, #$632D, #$6347, #$6333,
      #$635A, #$6351, #$6338, #$6357, #$6340, #$6348, #$654A, #$6546,
      #$65C6, #$65C3, #$65C4, #$65C2, #$664A, #$665F, #$6647, #$6651,
      #$6712, #$6713, #$681F, #$681A, #$6849, #$6832, #$6833, #$683B,
      #$684B, #$684F, #$6816, #$6831, #$681C, #$6835, #$682B, #$682D,
      #$682F, #$684E, #$6844, #$6834, #$681D, #$6812, #$6814, #$6826,
      #$6828, #$682E, #$684D, #$683A, #$6825, #$6820, #$6B2C, #$6B2F,
      #$6B2D, #$6B31, #$6B34, #$6B6D, #$8082, #$6B88,
      #$6BE6, #$6BE4, #$6BE8, #$6BE3, #$6BE2, #$6BE7, #$6C25, #$6D7A,
      #$6D63, #$6D64, #$6D76, #$6D0D, #$6D61, #$6D92, #$6D58, #$6D62,
      #$6D6D, #$6D6F, #$6D91, #$6D8D, #$6DEF, #$6D7F, #$6D86, #$6D5E,
      #$6D67, #$6D60, #$6D97, #$6D70, #$6D7C, #$6D5F, #$6D82, #$6D98,
      #$6D2F, #$6D68, #$6D8B, #$6D7E, #$6D80, #$6D84, #$6D16, #$6D83,
      #$6D7B, #$6D7D, #$6D75, #$6D90, #$70DC, #$70D3, #$70D1, #$70DD,
      #$70CB, #$7F39, #$70E2, #$70D7, #$70D2, #$70DE, #$70E0, #$70D4,
      #$70CD, #$70C5, #$70C6, #$70C7, #$70DA, #$70CE, #$70E1, #$7242,
      #$7278, #$7277, #$7276, #$7300, #$72FA, #$72F4, #$72FE, #$72F6,
      #$72F3, #$72FB, #$7301, #$73D3, #$73D9, #$73E5, #$73D6, #$73BC,
      #$73E7, #$73E3, #$73E9, #$73DC, #$73D2, #$73DB, #$73D4, #$73DD,
      #$73DA, #$73D7, #$73D8, #$73E8, #$74DE, #$74DF,
      #$74F4, #$74F5, #$7521, #$755B, #$755F, #$75B0, #$75C1, #$75BB,
      #$75C4, #$75C0, #$75BF, #$75B6, #$75BA, #$768A, #$76C9, #$771D,
      #$771B, #$7710, #$7713, #$7712, #$7723, #$7711, #$7715, #$7719,
      #$771A, #$7722, #$7727, #$7823, #$782C, #$7822, #$7835, #$782F,
      #$7828, #$782E, #$782B, #$7821, #$7829, #$7833, #$782A, #$7831,
      #$7954, #$795B, #$794F, #$795C, #$7953, #$7952, #$7951, #$79EB,
      #$79EC, #$79E0, #$79EE, #$79ED, #$79EA, #$79DC, #$79DE, #$79DD,
      #$7A86, #$7A89, #$7A85, #$7A8B, #$7A8C, #$7A8A, #$7A87, #$7AD8,
      #$7B10, #$7B04, #$7B13, #$7B05, #$7B0F, #$7B08, #$7B0A, #$7B0E,
      #$7B09, #$7B12, #$7C84, #$7C91, #$7C8A, #$7C8C, #$7C88, #$7C8D,
      #$7C85, #$7D1E, #$7D1D, #$7D11, #$7D0E, #$7D18, #$7D16, #$7D13,
      #$7D1F, #$7D12, #$7D0F, #$7D0C, #$7F5C, #$7F61,
      #$7F5E, #$7F60, #$7F5D, #$7F5B, #$7F96, #$7F92, #$7FC3, #$7FC2,
      #$7FC0, #$8016, #$803E, #$8039, #$80FA, #$80F2, #$80F9, #$80F5,
      #$8101, #$80FB, #$8100, #$8201, #$822F, #$8225, #$8333, #$832D,
      #$8344, #$8319, #$8351, #$8325, #$8356, #$833F, #$8341, #$8326,
      #$831C, #$8322, #$8342, #$834E, #$831B, #$832A, #$8308, #$833C,
      #$834D, #$8316, #$8324, #$8320, #$8337, #$832F, #$8329, #$8347,
      #$8345, #$834C, #$8353, #$831E, #$832C, #$834B, #$8327, #$8348,
      #$8653, #$8652, #$86A2, #$86A8, #$8696, #$868D, #$8691, #$869E,
      #$8687, #$8697, #$8686, #$868B, #$869A, #$8685, #$86A5, #$8699,
      #$86A1, #$86A7, #$8695, #$8698, #$868E, #$869D, #$8690, #$8694,
      #$8843, #$8844, #$886D, #$8875, #$8876, #$8872, #$8880, #$8871,
      #$887F, #$886F, #$8883, #$887E, #$8874, #$887C,
      #$8A12, #$8C47, #$8C57, #$8C7B, #$8CA4, #$8CA3, #$8D76, #$8D78,
      #$8DB5, #$8DB7, #$8DB6, #$8ED1, #$8ED3, #$8FFE, #$8FF5, #$9002,
      #$8FFF, #$8FFB, #$9004, #$8FFC, #$8FF6, #$90D6, #$90E0, #$90D9,
      #$90DA, #$90E3, #$90DF, #$90E5, #$90D8, #$90DB, #$90D7, #$90DC,
      #$90E4, #$9150, #$914E, #$914F, #$91D5, #$91E2, #$91DA, #$965C,
      #$965F, #$96BC, #$98E3, #$9ADF, #$9B2F, #$4E7F, #$5070, #$506A,
      #$5061, #$505E, #$5060, #$5053, #$504B, #$505D, #$5072, #$5048,
      #$504D, #$5041, #$505B, #$504A, #$5062, #$5015, #$5045, #$505F,
      #$5069, #$506B, #$5063, #$5064, #$5046, #$5040, #$506E, #$5073,
      #$5057, #$5051, #$51D0, #$526B, #$526D, #$526C, #$526E, #$52D6,
      #$52D3, #$532D, #$539C, #$5575, #$5576, #$553C, #$554D, #$5550,
      #$5534, #$552A, #$5551, #$5562, #$5536, #$5535,
      #$5530, #$5552, #$5545, #$550C, #$5532, #$5565, #$554E, #$5539,
      #$5548, #$552D, #$553B, #$5540, #$554B, #$570A, #$5707, #$57FB,
      #$5814, #$57E2, #$57F6, #$57DC, #$57F4, #$5800, #$57ED, #$57FD,
      #$5808, #$57F8, #$580B, #$57F3, #$57CF, #$5807, #$57EE, #$57E3,
      #$57F2, #$57E5, #$57EC, #$57E1, #$580E, #$57FC, #$5810, #$57E7,
      #$5801, #$580C, #$57F1, #$57E9, #$57F0, #$580D, #$5804, #$595C,
      #$5A60, #$5A58, #$5A55, #$5A67, #$5A5E, #$5A38, #$5A35, #$5A6D,
      #$5A50, #$5A5F, #$5A65, #$5A6C, #$5A53, #$5A64, #$5A57, #$5A43,
      #$5A5D, #$5A52, #$5A44, #$5A5B, #$5A48, #$5A8E, #$5A3E, #$5A4D,
      #$5A39, #$5A4C, #$5A70, #$5A69, #$5A47, #$5A51, #$5A56, #$5A42,
      #$5A5C, #$5B72, #$5B6E, #$5BC1, #$5BC0, #$5C59, #$5D1E, #$5D0B,
      #$5D1D, #$5D1A, #$5D20, #$5D0C, #$5D28, #$5D0D,
      #$5D26, #$5D25, #$5D0F, #$5D30, #$5D12, #$5D23, #$5D1F, #$5D2E,
      #$5E3E, #$5E34, #$5EB1, #$5EB4, #$5EB9, #$5EB2, #$5EB3, #$5F36,
      #$5F38, #$5F9B, #$5F96, #$5F9F, #$608A, #$6090, #$6086, #$60BE,
      #$60B0, #$60BA, #$60D3, #$60D4, #$60CF, #$60E4, #$60D9, #$60DD,
      #$60C8, #$60B1, #$60DB, #$60B7, #$60CA, #$60BF, #$60C3, #$60CD,
      #$60C0, #$6332, #$6365, #$638A, #$6382, #$637D, #$63BD, #$639E,
      #$63AD, #$639D, #$6397, #$63AB, #$638E, #$636F, #$6387, #$6390,
      #$636E, #$63AF, #$6375, #$639C, #$636D, #$63AE, #$637C, #$63A4,
      #$633B, #$639F, #$6378, #$6385, #$6381, #$6391, #$638D, #$6370,
      #$6553, #$65CD, #$6665, #$6661, #$665B, #$6659, #$665C, #$6662,
      #$6718, #$6879, #$6887, #$6890, #$689C, #$686D, #$686E, #$68AE,
      #$68AB, #$6956, #$686F, #$68A3, #$68AC, #$68A9,
      #$6875, #$6874, #$68B2, #$688F, #$6877, #$6892, #$687C, #$686B,
      #$6872, #$68AA, #$6880, #$6871, #$687E, #$689B, #$6896, #$688B,
      #$68A0, #$6889, #$68A4, #$6878, #$687B, #$6891, #$688C, #$688A,
      #$687D, #$6B36, #$6B33, #$6B37, #$6B38, #$6B91, #$6B8F, #$6B8D,
      #$6B8E, #$6B8C, #$6C2A, #$6DC0, #$6DAB, #$6DB4, #$6DB3, #$6E74,
      #$6DAC, #$6DE9, #$6DE2, #$6DB7, #$6DF6, #$6DD4, #$6E00, #$6DC8,
      #$6DE0, #$6DDF, #$6DD6, #$6DBE, #$6DE5, #$6DDC, #$6DDD, #$6DDB,
      #$6DF4, #$6DCA, #$6DBD, #$6DED, #$6DF0, #$6DBA, #$6DD5, #$6DC2,
      #$6DCF, #$6DC9, #$6DD0, #$6DF2, #$6DD3, #$6DFD, #$6DD7, #$6DCD,
      #$6DE3, #$6DBB, #$70FA, #$710D, #$70F7, #$7117, #$70F4, #$710C,
      #$70F0, #$7104, #$70F3, #$7110, #$70FC, #$70FF, #$7106, #$7113,
      #$7100, #$70F8, #$70F6, #$710B, #$7102, #$710E,
      #$727E, #$727B, #$727C, #$727F, #$731D, #$7317, #$7307, #$7311,
      #$7318, #$730A, #$7308, #$72FF, #$730F, #$731E, #$7388, #$73F6,
      #$73F8, #$73F5, #$7404, #$7401, #$73FD, #$7407, #$7400, #$73FA,
      #$73FC, #$73FF, #$740C, #$740B, #$73F4, #$7408, #$7564, #$7563,
      #$75CE, #$75D2, #$75CF, #$75CB, #$75CC, #$75D1, #$75D0, #$768F,
      #$7689, #$76D3, #$7739, #$772F, #$772D, #$7731, #$7732, #$7734,
      #$7733, #$773D, #$7725, #$773B, #$7735, #$7848, #$7852, #$7849,
      #$784D, #$784A, #$784C, #$7826, #$7845, #$7850, #$7964, #$7967,
      #$7969, #$796A, #$7963, #$796B, #$7961, #$79BB, #$79FA, #$79F8,
      #$79F6, #$79F7, #$7A8F, #$7A94, #$7A90, #$7B35, #$7B3B, #$7B34,
      #$7B25, #$7B30, #$7B22, #$7B24, #$7B33, #$7B18, #$7B2A, #$7B1D,
      #$7B31, #$7B2B, #$7B2D, #$7B2F, #$7B32, #$7B38,
      #$7B1A, #$7B23, #$7C94, #$7C98, #$7C96, #$7CA3, #$7D35, #$7D3D,
      #$7D38, #$7D36, #$7D3A, #$7D45, #$7D2C, #$7D29, #$7D41, #$7D47,
      #$7D3E, #$7D3F, #$7D4A, #$7D3B, #$7D28, #$7F63, #$7F95, #$7F9C,
      #$7F9D, #$7F9B, #$7FCA, #$7FCB, #$7FCD, #$7FD0, #$7FD1, #$7FC7,
      #$7FCF, #$7FC9, #$801F, #$801E, #$801B, #$8047, #$8043, #$8048,
      #$8118, #$8125, #$8119, #$811B, #$812D, #$811F, #$812C, #$811E,
      #$8121, #$8115, #$8127, #$811D, #$8122, #$8211, #$8238, #$8233,
      #$823A, #$8234, #$8232, #$8274, #$8390, #$83A3, #$83A8, #$838D,
      #$837A, #$8373, #$83A4, #$8374, #$838F, #$8381, #$8395, #$8399,
      #$8375, #$8394, #$83A9, #$837D, #$8383, #$838C, #$839D, #$839B,
      #$83AA, #$838B, #$837E, #$83A5, #$83AF, #$8388, #$8397, #$83B0,
      #$837F, #$83A6, #$8387, #$83AE, #$8376, #$8659,
      #$8656, #$86BF, #$86B7, #$86C2, #$86C1, #$86C5, #$86BA, #$86B0,
      #$86C8, #$86B9, #$86B3, #$86B8, #$86CC, #$86B4, #$86BB, #$86BC,
      #$86C3, #$86BD, #$86BE, #$8852, #$8889, #$8895, #$88A8, #$88A2,
      #$88AA, #$889A, #$8891, #$88A1, #$889F, #$8898, #$88A7, #$8899,
      #$889B, #$8897, #$88A4, #$88AC, #$888C, #$8893, #$888E, #$8982,
      #$89D6, #$89D9, #$89D5, #$8A30, #$8A27, #$8A2C, #$8A1E, #$8C39,
      #$8C3B, #$8C5C, #$8C5D, #$8C7D, #$8CA5, #$8D7D, #$8D7B, #$8D79,
      #$8DBC, #$8DC2, #$8DB9, #$8DBF, #$8DC1, #$8ED8, #$8EDE, #$8EDD,
      #$8EDC, #$8ED7, #$8EE0, #$8EE1, #$9024, #$900B, #$9011, #$901C,
      #$900C, #$9021, #$90EF, #$90EA, #$90F0, #$90F4, #$90F2, #$90F3,
      #$90D4, #$90EB, #$90EC, #$90E9, #$9156, #$9158, #$915A, #$9153,
      #$9155, #$91EC, #$91F4, #$91F1, #$91F3, #$91F8,
      #$91E4, #$91F9, #$91EA, #$91EB, #$91F7, #$91E8, #$91EE, #$957A,
      #$9586, #$9588, #$967C, #$966D, #$966B, #$9671, #$966F, #$96BF,
      #$976A, #$9804, #$98E5, #$9997, #$509B, #$5095, #$5094, #$509E,
      #$508B, #$50A3, #$5083, #$508C, #$508E, #$509D, #$5068, #$509C,
      #$5092, #$5082, #$5087, #$515F, #$51D4, #$5312, #$5311, #$53A4,
      #$53A7, #$5591, #$55A8, #$55A5, #$55AD, #$5577, #$5645, #$55A2,
      #$5593, #$5588, #$558F, #$55B5, #$5581, #$55A3, #$5592, #$55A4,
      #$557D, #$558C, #$55A6, #$557F, #$5595, #$55A1, #$558E, #$570C,
      #$5829, #$5837, #$5819, #$581E, #$5827, #$5823, #$5828, #$57F5,
      #$5848, #$5825, #$581C, #$581B, #$5833, #$583F, #$5836, #$582E,
      #$5839, #$5838, #$582D, #$582C, #$583B, #$5961, #$5AAF, #$5A94,
      #$5A9F, #$5A7A, #$5AA2, #$5A9E, #$5A78, #$5AA6,
      #$5A7C, #$5AA5, #$5AAC, #$5A95, #$5AAE, #$5A37, #$5A84, #$5A8A,
      #$5A97, #$5A83, #$5A8B, #$5AA9, #$5A7B, #$5A7D, #$5A8C, #$5A9C,
      #$5A8F, #$5A93, #$5A9D, #$5BEA, #$5BCD, #$5BCB, #$5BD4, #$5BD1,
      #$5BCA, #$5BCE, #$5C0C, #$5C30, #$5D37, #$5D43, #$5D6B, #$5D41,
      #$5D4B, #$5D3F, #$5D35, #$5D51, #$5D4E, #$5D55, #$5D33, #$5D3A,
      #$5D52, #$5D3D, #$5D31, #$5D59, #$5D42, #$5D39, #$5D49, #$5D38,
      #$5D3C, #$5D32, #$5D36, #$5D40, #$5D45, #$5E44, #$5E41, #$5F58,
      #$5FA6, #$5FA5, #$5FAB, #$60C9, #$60B9, #$60CC, #$60E2, #$60CE,
      #$60C4, #$6114, #$60F2, #$610A, #$6116, #$6105, #$60F5, #$6113,
      #$60F8, #$60FC, #$60FE, #$60C1, #$6103, #$6118, #$611D, #$6110,
      #$60FF, #$6104, #$610B, #$624A, #$6394, #$63B1, #$63B0, #$63CE,
      #$63E5, #$63E8, #$63EF, #$63C3, #$649D, #$63F3,
      #$63CA, #$63E0, #$63F6, #$63D5, #$63F2, #$63F5, #$6461, #$63DF,
      #$63BE, #$63DD, #$63DC, #$63C4, #$63D8, #$63D3, #$63C2, #$63C7,
      #$63CC, #$63CB, #$63C8, #$63F0, #$63D7, #$63D9, #$6532, #$6567,
      #$656A, #$6564, #$655C, #$6568, #$6565, #$658C, #$659D, #$659E,
      #$65AE, #$65D0, #$65D2, #$667C, #$666C, #$667B, #$6680, #$6671,
      #$6679, #$666A, #$6672, #$6701, #$690C, #$68D3, #$6904, #$68DC,
      #$692A, #$68EC, #$68EA, #$68F1, #$690F, #$68D6, #$68F7, #$68EB,
      #$68E4, #$68F6, #$6913, #$6910, #$68F3, #$68E1, #$6907, #$68CC,
      #$6908, #$6970, #$68B4, #$6911, #$68EF, #$68C6, #$6914, #$68F8,
      #$68D0, #$68FD, #$68FC, #$68E8, #$690B, #$690A, #$6917, #$68CE,
      #$68C8, #$68DD, #$68DE, #$68E6, #$68F4, #$68D1, #$6906, #$68D4,
      #$68E9, #$6915, #$6925, #$68C7, #$6B39, #$6B3B,
      #$6B3F, #$6B3C, #$6B94, #$6B97, #$6B99, #$6B95, #$6BBD, #$6BF0,
      #$6BF2, #$6BF3, #$6C30, #$6DFC, #$6E46, #$6E47, #$6E1F, #$6E49,
      #$6E88, #$6E3C, #$6E3D, #$6E45, #$6E62, #$6E2B, #$6E3F, #$6E41,
      #$6E5D, #$6E73, #$6E1C, #$6E33, #$6E4B, #$6E40, #$6E51, #$6E3B,
      #$6E03, #$6E2E, #$6E5E, #$6E68, #$6E5C, #$6E61, #$6E31, #$6E28,
      #$6E60, #$6E71, #$6E6B, #$6E39, #$6E22, #$6E30, #$6E53, #$6E65,
      #$6E27, #$6E78, #$6E64, #$6E77, #$6E55, #$6E79, #$6E52, #$6E66,
      #$6E35, #$6E36, #$6E5A, #$7120, #$711E, #$712F, #$70FB, #$712E,
      #$7131, #$7123, #$7125, #$7122, #$7132, #$711F, #$7128, #$713A,
      #$711B, #$724B, #$725A, #$7288, #$7289, #$7286, #$7285, #$728B,
      #$7312, #$730B, #$7330, #$7322, #$7331, #$7333, #$7327, #$7332,
      #$732D, #$7326, #$7323, #$7335, #$730C, #$742E,
      #$742C, #$7430, #$742B, #$7416, #$741A, #$7421, #$742D, #$7431,
      #$7424, #$7423, #$741D, #$7429, #$7420, #$7432, #$74FB, #$752F,
      #$756F, #$756C, #$75E7, #$75DA, #$75E1, #$75E6, #$75DD, #$75DF,
      #$75E4, #$75D7, #$7695, #$7692, #$76DA, #$7746, #$7747, #$7744,
      #$774D, #$7745, #$774A, #$774E, #$774B, #$774C, #$77DE, #$77EC,
      #$7860, #$7864, #$7865, #$785C, #$786D, #$7871, #$786A, #$786E,
      #$7870, #$7869, #$7868, #$785E, #$7862, #$7974, #$7973, #$7972,
      #$7970, #$7A02, #$7A0A, #$7A03, #$7A0C, #$7A04, #$7A99, #$7AE6,
      #$7AE4, #$7B4A, #$7B47, #$7B44, #$7B48, #$7B4C, #$7B4E, #$7B40,
      #$7B58, #$7B45, #$7CA2, #$7C9E, #$7CA8, #$7CA1, #$7D58, #$7D6F,
      #$7D63, #$7D53, #$7D56, #$7D67, #$7D6A, #$7D4F, #$7D6D, #$7D5C,
      #$7D6B, #$7D52, #$7D54, #$7D69, #$7D51, #$7D5F,
      #$7D4E, #$7F3E, #$7F3F, #$7F65, #$7F66, #$7FA2, #$7FA0, #$7FA1,
      #$7FD7, #$8051, #$804F, #$8050, #$80FE, #$80D4, #$8143, #$814A,
      #$8152, #$814F, #$8147, #$813D, #$814D, #$813A, #$81E6, #$81EE,
      #$81F7, #$81F8, #$81F9, #$8204, #$823C, #$823D, #$823F, #$8275,
      #$833B, #$83CF, #$83F9, #$8423, #$83C0, #$83E8, #$8412, #$83E7,
      #$83E4, #$83FC, #$83F6, #$8410, #$83C6, #$83C8, #$83EB, #$83E3,
      #$83BF, #$8401, #$83DD, #$83E5, #$83D8, #$83FF, #$83E1, #$83CB,
      #$83CE, #$83D6, #$83F5, #$83C9, #$8409, #$840F, #$83DE, #$8411,
      #$8406, #$83C2, #$83F3, #$83D5, #$83FA, #$83C7, #$83D1, #$83EA,
      #$8413, #$839A, #$83C3, #$83EC, #$83EE, #$83C4, #$83FB, #$83D7,
      #$83E2, #$841B, #$83DB, #$83FE, #$86D8, #$86E2, #$86E6, #$86D3,
      #$86E3, #$86DA, #$86EA, #$86DD, #$86EB, #$86DC,
      #$86EC, #$86E9, #$86D7, #$86E8, #$86D1, #$8848, #$8856, #$8855,
      #$88BA, #$88D7, #$88B9, #$88B8, #$88C0, #$88BE, #$88B6, #$88BC,
      #$88B7, #$88BD, #$88B2, #$8901, #$88C9, #$8995, #$8998, #$8997,
      #$89DD, #$89DA, #$89DB, #$8A4E, #$8A4D, #$8A39, #$8A59, #$8A40,
      #$8A57, #$8A58, #$8A44, #$8A45, #$8A52, #$8A48, #$8A51, #$8A4A,
      #$8A4C, #$8A4F, #$8C5F, #$8C81, #$8C80, #$8CBA, #$8CBE, #$8CB0,
      #$8CB9, #$8CB5, #$8D84, #$8D80, #$8D89, #$8DD8, #$8DD3, #$8DCD,
      #$8DC7, #$8DD6, #$8DDC, #$8DCF, #$8DD5, #$8DD9, #$8DC8, #$8DD7,
      #$8DC5, #$8EEF, #$8EF7, #$8EFA, #$8EF9, #$8EE6, #$8EEE, #$8EE5,
      #$8EF5, #$8EE7, #$8EE8, #$8EF6, #$8EEB, #$8EF1, #$8EEC, #$8EF4,
      #$8EE9, #$902D, #$9034, #$902F, #$9106, #$912C, #$9104, #$90FF,
      #$90FC, #$9108, #$90F9, #$90FB, #$9101, #$9100,
      #$9107, #$9105, #$9103, #$9161, #$9164, #$915F, #$9162, #$9160,
      #$9201, #$920A, #$9225, #$9203, #$921A, #$9226, #$920F, #$920C,
      #$9200, #$9212, #$91FF, #$91FD, #$9206, #$9204, #$9227, #$9202,
      #$921C, #$9224, #$9219, #$9217, #$9205, #$9216, #$957B, #$958D,
      #$958C, #$9590, #$9687, #$967E, #$9688, #$9689, #$9683, #$9680,
      #$96C2, #$96C8, #$96C3, #$96F1, #$96F0, #$976C, #$9770, #$976E,
      #$9807, #$98A9, #$98EB, #$9CE6, #$9EF9, #$4E83, #$4E84, #$4EB6,
      #$50BD, #$50BF, #$50C6, #$50AE, #$50C4, #$50CA, #$50B4, #$50C8,
      #$50C2, #$50B0, #$50C1, #$50BA, #$50B1, #$50CB, #$50C9, #$50B6,
      #$50B8, #$51D7, #$527A, #$5278, #$527B, #$527C, #$55C3, #$55DB,
      #$55CC, #$55D0, #$55CB, #$55CA, #$55DD, #$55C0, #$55D4, #$55C4,
      #$55E9, #$55BF, #$55D2, #$558D, #$55CF, #$55D5,
      #$55E2, #$55D6, #$55C8, #$55F2, #$55CD, #$55D9, #$55C2, #$5714,
      #$5853, #$5868, #$5864, #$584F, #$584D, #$5849, #$586F, #$5855,
      #$584E, #$585D, #$5859, #$5865, #$585B, #$583D, #$5863, #$5871,
      #$58FC, #$5AC7, #$5AC4, #$5ACB, #$5ABA, #$5AB8, #$5AB1, #$5AB5,
      #$5AB0, #$5ABF, #$5AC8, #$5ABB, #$5AC6, #$5AB7, #$5AC0, #$5ACA,
      #$5AB4, #$5AB6, #$5ACD, #$5AB9, #$5A90, #$5BD6, #$5BD8, #$5BD9,
      #$5C1F, #$5C33, #$5D71, #$5D63, #$5D4A, #$5D65, #$5D72, #$5D6C,
      #$5D5E, #$5D68, #$5D67, #$5D62, #$5DF0, #$5E4F, #$5E4E, #$5E4A,
      #$5E4D, #$5E4B, #$5EC5, #$5ECC, #$5EC6, #$5ECB, #$5EC7, #$5F40,
      #$5FAF, #$5FAD, #$60F7, #$6149, #$614A, #$612B, #$6145, #$6136,
      #$6132, #$612E, #$6146, #$612F, #$614F, #$6129, #$6140, #$6220,
      #$9168, #$6223, #$6225, #$6224, #$63C5, #$63F1,
      #$63EB, #$6410, #$6412, #$6409, #$6420, #$6424, #$6433, #$6443,
      #$641F, #$6415, #$6418, #$6439, #$6437, #$6422, #$6423, #$640C,
      #$6426, #$6430, #$6428, #$6441, #$6435, #$642F, #$640A, #$641A,
      #$6440, #$6425, #$6427, #$640B, #$63E7, #$641B, #$642E, #$6421,
      #$640E, #$656F, #$6592, #$65D3, #$6686, #$668C, #$6695, #$6690,
      #$668B, #$668A, #$6699, #$6694, #$6678, #$6720, #$6966, #$695F,
      #$6938, #$694E, #$6962, #$6971, #$693F, #$6945, #$696A, #$6939,
      #$6942, #$6957, #$6959, #$697A, #$6948, #$6949, #$6935, #$696C,
      #$6933, #$693D, #$6965, #$68F0, #$6978, #$6934, #$6969, #$6940,
      #$696F, #$6944, #$6976, #$6958, #$6941, #$6974, #$694C, #$693B,
      #$694B, #$6937, #$695C, #$694F, #$6951, #$6932, #$6952, #$692F,
      #$697B, #$693C, #$6B46, #$6B45, #$6B43, #$6B42,
      #$6B48, #$6B41, #$6B9B, #$6BFB, #$6BFC, #$6BF9, #$6BF7, #$6BF8,
      #$6E9B, #$6ED6, #$6EC8, #$6E8F, #$6EC0, #$6E9F, #$6E93, #$6E94,
      #$6EA0, #$6EB1, #$6EB9, #$6EC6, #$6ED2, #$6EBD, #$6EC1, #$6E9E,
      #$6EC9, #$6EB7, #$6EB0, #$6ECD, #$6EA6, #$6ECF, #$6EB2, #$6EBE,
      #$6EC3, #$6EDC, #$6ED8, #$6E99, #$6E92, #$6E8E, #$6E8D, #$6EA4,
      #$6EA1, #$6EBF, #$6EB3, #$6ED0, #$6ECA, #$6E97, #$6EAE, #$6EA3,
      #$7147, #$7154, #$7152, #$7163, #$7160, #$7141, #$715D, #$7162,
      #$7172, #$7178, #$716A, #$7161, #$7142, #$7158, #$7143, #$714B,
      #$7170, #$715F, #$7150, #$7153, #$7144, #$714D, #$715A, #$724F,
      #$728D, #$728C, #$7291, #$7290, #$728E, #$733C, #$7342, #$733B,
      #$733A, #$7340, #$734A, #$7349, #$7444, #$744A, #$744B, #$7452,
      #$7451, #$7457, #$7440, #$744F, #$7450, #$744E,
      #$7442, #$7446, #$744D, #$7454, #$74E1, #$74FF, #$74FE, #$74FD,
      #$751D, #$7579, #$7577, #$6983, #$75EF, #$760F, #$7603, #$75F7,
      #$75FE, #$75FC, #$75F9, #$75F8, #$7610, #$75FB, #$75F6, #$75ED,
      #$75F5, #$75FD, #$7699, #$76B5, #$76DD, #$7755, #$775F, #$7760,
      #$7752, #$7756, #$775A, #$7769, #$7767, #$7754, #$7759, #$776D,
      #$77E0, #$7887, #$789A, #$7894, #$788F, #$7884, #$7895, #$7885,
      #$7886, #$78A1, #$7883, #$7879, #$7899, #$7880, #$7896, #$787B,
      #$797C, #$7982, #$797D, #$7979, #$7A11, #$7A18, #$7A19, #$7A12,
      #$7A17, #$7A15, #$7A22, #$7A13, #$7A1B, #$7A10, #$7AA3, #$7AA2,
      #$7A9E, #$7AEB, #$7B66, #$7B64, #$7B6D, #$7B74, #$7B69, #$7B72,
      #$7B65, #$7B73, #$7B71, #$7B70, #$7B61, #$7B78, #$7B76, #$7B63,
      #$7CB2, #$7CB4, #$7CAF, #$7D88, #$7D86, #$7D80,
      #$7D8D, #$7D7F, #$7D85, #$7D7A, #$7D8E, #$7D7B, #$7D83, #$7D7C,
      #$7D8C, #$7D94, #$7D84, #$7D7D, #$7D92, #$7F6D, #$7F6B, #$7F67,
      #$7F68, #$7F6C, #$7FA6, #$7FA5, #$7FA7, #$7FDB, #$7FDC, #$8021,
      #$8164, #$8160, #$8177, #$815C, #$8169, #$815B, #$8162, #$8172,
      #$6721, #$815E, #$8176, #$8167, #$816F, #$8144, #$8161, #$821D,
      #$8249, #$8244, #$8240, #$8242, #$8245, #$84F1, #$843F, #$8456,
      #$8476, #$8479, #$848F, #$848D, #$8465, #$8451, #$8440, #$8486,
      #$8467, #$8430, #$844D, #$847D, #$845A, #$8459, #$8474, #$8473,
      #$845D, #$8507, #$845E, #$8437, #$843A, #$8434, #$847A, #$8443,
      #$8478, #$8432, #$8445, #$8429, #$83D9, #$844B, #$842F, #$8442,
      #$842D, #$845F, #$8470, #$8439, #$844E, #$844C, #$8452, #$846F,
      #$84C5, #$848E, #$843B, #$8447, #$8436, #$8433,
      #$8468, #$847E, #$8444, #$842B, #$8460, #$8454, #$846E, #$8450,
      #$870B, #$8704, #$86F7, #$870C, #$86FA, #$86D6, #$86F5, #$874D,
      #$86F8, #$870E, #$8709, #$8701, #$86F6, #$870D, #$8705, #$88D6,
      #$88CB, #$88CD, #$88CE, #$88DE, #$88DB, #$88DA, #$88CC, #$88D0,
      #$8985, #$899B, #$89DF, #$89E5, #$89E4, #$89E1, #$89E0, #$89E2,
      #$89DC, #$89E6, #$8A76, #$8A86, #$8A7F, #$8A61, #$8A3F, #$8A77,
      #$8A82, #$8A84, #$8A75, #$8A83, #$8A81, #$8A74, #$8A7A, #$8C3C,
      #$8C4B, #$8C4A, #$8C65, #$8C64, #$8C66, #$8C86, #$8C84, #$8C85,
      #$8CCC, #$8D68, #$8D69, #$8D91, #$8D8C, #$8D8E, #$8D8F, #$8D8D,
      #$8D93, #$8D94, #$8D90, #$8D92, #$8DF0, #$8DE0, #$8DEC, #$8DF1,
      #$8DEE, #$8DD0, #$8DE9, #$8DE3, #$8DE2, #$8DE7, #$8DF2, #$8DEB,
      #$8DF4, #$8F06, #$8EFF, #$8F01, #$8F00, #$8F05,
      #$8F07, #$8F08, #$8F02, #$8F0B, #$9052, #$903F, #$9044, #$9049,
      #$903D, #$9110, #$910D, #$910F, #$9111, #$9116, #$9114, #$910B,
      #$910E, #$916E, #$916F, #$9248, #$9252, #$9230, #$923A, #$9266,
      #$9233, #$9265, #$925E, #$9283, #$922E, #$924A, #$9246, #$926D,
      #$926C, #$924F, #$9260, #$9267, #$926F, #$9236, #$9261, #$9270,
      #$9231, #$9254, #$9263, #$9250, #$9272, #$924E, #$9253, #$924C,
      #$9256, #$9232, #$959F, #$959C, #$959E, #$959B, #$9692, #$9693,
      #$9691, #$9697, #$96CE, #$96FA, #$96FD, #$96F8, #$96F5, #$9773,
      #$9777, #$9778, #$9772, #$980F, #$980D, #$980E, #$98AC, #$98F6,
      #$98F9, #$99AF, #$99B2, #$99B0, #$99B5, #$9AAD, #$9AAB, #$9B5B,
      #$9CEA, #$9CED, #$9CE7, #$9E80, #$9EFD, #$50E6, #$50D4, #$50D7,
      #$50E8, #$50F3, #$50DB, #$50EA, #$50DD, #$50E4,
      #$50D3, #$50EC, #$50F0, #$50EF, #$50E3, #$50E0, #$51D8, #$5280,
      #$5281, #$52E9, #$52EB, #$5330, #$53AC, #$5627, #$5615, #$560C,
      #$5612, #$55FC, #$560F, #$561C, #$5601, #$5613, #$5602, #$55FA,
      #$561D, #$5604, #$55FF, #$55F9, #$5889, #$587C, #$5890, #$5898,
      #$5886, #$5881, #$587F, #$5874, #$588B, #$587A, #$5887, #$5891,
      #$588E, #$5876, #$5882, #$5888, #$587B, #$5894, #$588F, #$58FE,
      #$596B, #$5ADC, #$5AEE, #$5AE5, #$5AD5, #$5AEA, #$5ADA, #$5AED,
      #$5AEB, #$5AF3, #$5AE2, #$5AE0, #$5ADB, #$5AEC, #$5ADE, #$5ADD,
      #$5AD9, #$5AE8, #$5ADF, #$5B77, #$5BE0, #$5BE3, #$5C63, #$5D82,
      #$5D80, #$5D7D, #$5D86, #$5D7A, #$5D81, #$5D77, #$5D8A, #$5D89,
      #$5D88, #$5D7E, #$5D7C, #$5D8D, #$5D79, #$5D7F, #$5E58, #$5E59,
      #$5E53, #$5ED8, #$5ED1, #$5ED7, #$5ECE, #$5EDC,
      #$5ED5, #$5ED9, #$5ED2, #$5ED4, #$5F44, #$5F43, #$5F6F, #$5FB6,
      #$612C, #$6128, #$6141, #$615E, #$6171, #$6173, #$6152, #$6153,
      #$6172, #$616C, #$6180, #$6174, #$6154, #$617A, #$615B, #$6165,
      #$613B, #$616A, #$6161, #$6156, #$6229, #$6227, #$622B, #$642B,
      #$644D, #$645B, #$645D, #$6474, #$6476, #$6472, #$6473, #$647D,
      #$6475, #$6466, #$64A6, #$644E, #$6482, #$645E, #$645C, #$644B,
      #$6453, #$6460, #$6450, #$647F, #$643F, #$646C, #$646B, #$6459,
      #$6465, #$6477, #$6573, #$65A0, #$66A1, #$66A0, #$669F, #$6705,
      #$6704, #$6722, #$69B1, #$69B6, #$69C9, #$69A0, #$69CE, #$6996,
      #$69B0, #$69AC, #$69BC, #$6991, #$6999, #$698E, #$69A7, #$698D,
      #$69A9, #$69BE, #$69AF, #$69BF, #$69C4, #$69BD, #$69A4, #$69D4,
      #$69B9, #$69CA, #$699A, #$69CF, #$69B3, #$6993,
      #$69AA, #$69A1, #$699E, #$69D9, #$6997, #$6990, #$69C2, #$69B5,
      #$69A5, #$69C6, #$6B4A, #$6B4D, #$6B4B, #$6B9E, #$6B9F, #$6BA0,
      #$6BC3, #$6BC4, #$6BFE, #$6ECE, #$6EF5, #$6EF1, #$6F03, #$6F25,
      #$6EF8, #$6F37, #$6EFB, #$6F2E, #$6F09, #$6F4E, #$6F19, #$6F1A,
      #$6F27, #$6F18, #$6F3B, #$6F12, #$6EED, #$6F0A, #$6F36, #$6F73,
      #$6EF9, #$6EEE, #$6F2D, #$6F40, #$6F30, #$6F3C, #$6F35, #$6EEB,
      #$6F07, #$6F0E, #$6F43, #$6F05, #$6EFD, #$6EF6, #$6F39, #$6F1C,
      #$6EFC, #$6F3A, #$6F1F, #$6F0D, #$6F1E, #$6F08, #$6F21, #$7187,
      #$7190, #$7189, #$7180, #$7185, #$7182, #$718F, #$717B, #$7186,
      #$7181, #$7197, #$7244, #$7253, #$7297, #$7295, #$7293, #$7343,
      #$734D, #$7351, #$734C, #$7462, #$7473, #$7471, #$7475, #$7472,
      #$7467, #$746E, #$7500, #$7502, #$7503, #$757D,
      #$7590, #$7616, #$7608, #$760C, #$7615, #$7611, #$760A, #$7614,
      #$76B8, #$7781, #$777C, #$7785, #$7782, #$776E, #$7780, #$776F,
      #$777E, #$7783, #$78B2, #$78AA, #$78B4, #$78AD, #$78A8, #$787E,
      #$78AB, #$789E, #$78A5, #$78A0, #$78AC, #$78A2, #$78A4, #$7998,
      #$798A, #$798B, #$7996, #$7995, #$7994, #$7993, #$7997, #$7988,
      #$7992, #$7990, #$7A2B, #$7A4A, #$7A30, #$7A2F, #$7A28, #$7A26,
      #$7AA8, #$7AAB, #$7AAC, #$7AEE, #$7B88, #$7B9C, #$7B8A, #$7B91,
      #$7B90, #$7B96, #$7B8D, #$7B8C, #$7B9B, #$7B8E, #$7B85, #$7B98,
      #$5284, #$7B99, #$7BA4, #$7B82, #$7CBB, #$7CBF, #$7CBC, #$7CBA,
      #$7DA7, #$7DB7, #$7DC2, #$7DA3, #$7DAA, #$7DC1, #$7DC0, #$7DC5,
      #$7D9D, #$7DCE, #$7DC4, #$7DC6, #$7DCB, #$7DCC, #$7DAF, #$7DB9,
      #$7D96, #$7DBC, #$7D9F, #$7DA6, #$7DAE, #$7DA9,
      #$7DA1, #$7DC9, #$7F73, #$7FE2, #$7FE3, #$7FE5, #$7FDE, #$8024,
      #$805D, #$805C, #$8189, #$8186, #$8183, #$8187, #$818D, #$818C,
      #$818B, #$8215, #$8497, #$84A4, #$84A1, #$849F, #$84BA, #$84CE,
      #$84C2, #$84AC, #$84AE, #$84AB, #$84B9, #$84B4, #$84C1, #$84CD,
      #$84AA, #$849A, #$84B1, #$84D0, #$849D, #$84A7, #$84BB, #$84A2,
      #$8494, #$84C7, #$84CC, #$849B, #$84A9, #$84AF, #$84A8, #$84D6,
      #$8498, #$84B6, #$84CF, #$84A0, #$84D7, #$84D4, #$84D2, #$84DB,
      #$84B0, #$8491, #$8661, #$8733, #$8723, #$8728, #$876B, #$8740,
      #$872E, #$871E, #$8721, #$8719, #$871B, #$8743, #$872C, #$8741,
      #$873E, #$8746, #$8720, #$8732, #$872A, #$872D, #$873C, #$8712,
      #$873A, #$8731, #$8735, #$8742, #$8726, #$8727, #$8738, #$8724,
      #$871A, #$8730, #$8711, #$88F7, #$88E7, #$88F1,
      #$88F2, #$88FA, #$88FE, #$88EE, #$88FC, #$88F6, #$88FB, #$88F0,
      #$88EC, #$88EB, #$899D, #$89A1, #$899F, #$899E, #$89E9, #$89EB,
      #$89E8, #$8AAB, #$8A99, #$8A8B, #$8A92, #$8A8F, #$8A96, #$8C3D,
      #$8C68, #$8C69, #$8CD5, #$8CCF, #$8CD7, #$8D96, #$8E09, #$8E02,
      #$8DFF, #$8E0D, #$8DFD, #$8E0A, #$8E03, #$8E07, #$8E06, #$8E05,
      #$8DFE, #$8E00, #$8E04, #$8F10, #$8F11, #$8F0E, #$8F0D, #$9123,
      #$911C, #$9120, #$9122, #$911F, #$911D, #$911A, #$9124, #$9121,
      #$911B, #$917A, #$9172, #$9179, #$9173, #$92A5, #$92A4, #$9276,
      #$929B, #$927A, #$92A0, #$9294, #$92AA, #$928D, #$92A6, #$929A,
      #$92AB, #$9279, #$9297, #$927F, #$92A3, #$92EE, #$928E, #$9282,
      #$9295, #$92A2, #$927D, #$9288, #$92A1, #$928A, #$9286, #$928C,
      #$9299, #$92A7, #$927E, #$9287, #$92A9, #$929D,
      #$928B, #$922D, #$969E, #$96A1, #$96FF, #$9758, #$977D, #$977A,
      #$977E, #$9783, #$9780, #$9782, #$977B, #$9784, #$9781, #$977F,
      #$97CE, #$97CD, #$9816, #$98AD, #$98AE, #$9902, #$9900, #$9907,
      #$999D, #$999C, #$99C3, #$99B9, #$99BB, #$99BA, #$99C2, #$99BD,
      #$99C7, #$9AB1, #$9AE3, #$9AE7, #$9B3E, #$9B3F, #$9B60, #$9B61,
      #$9B5F, #$9CF1, #$9CF2, #$9CF5, #$9EA7, #$50FF, #$5103, #$5130,
      #$50F8, #$5106, #$5107, #$50F6, #$50FE, #$510B, #$510C, #$50FD,
      #$510A, #$528B, #$528C, #$52F1, #$52EF, #$5648, #$5642, #$564C,
      #$5635, #$5641, #$564A, #$5649, #$5646, #$5658, #$565A, #$5640,
      #$5633, #$563D, #$562C, #$563E, #$5638, #$562A, #$563A, #$571A,
      #$58AB, #$589D, #$58B1, #$58A0, #$58A3, #$58AF, #$58AC, #$58A5,
      #$58A1, #$58FF, #$5AFF, #$5AF4, #$5AFD, #$5AF7,
      #$5AF6, #$5B03, #$5AF8, #$5B02, #$5AF9, #$5B01, #$5B07, #$5B05,
      #$5B0F, #$5C67, #$5D99, #$5D97, #$5D9F, #$5D92, #$5DA2, #$5D93,
      #$5D95, #$5DA0, #$5D9C, #$5DA1, #$5D9A, #$5D9E, #$5E69, #$5E5D,
      #$5E60, #$5E5C, #$7DF3, #$5EDB, #$5EDE, #$5EE1, #$5F49, #$5FB2,
      #$618B, #$6183, #$6179, #$61B1, #$61B0, #$61A2, #$6189, #$619B,
      #$6193, #$61AF, #$61AD, #$619F, #$6192, #$61AA, #$61A1, #$618D,
      #$6166, #$61B3, #$622D, #$646E, #$6470, #$6496, #$64A0, #$6485,
      #$6497, #$649C, #$648F, #$648B, #$648A, #$648C, #$64A3, #$649F,
      #$6468, #$64B1, #$6498, #$6576, #$657A, #$6579, #$657B, #$65B2,
      #$65B3, #$66B5, #$66B0, #$66A9, #$66B2, #$66B7, #$66AA, #$66AF,
      #$6A00, #$6A06, #$6A17, #$69E5, #$69F8, #$6A15, #$69F1, #$69E4,
      #$6A20, #$69FF, #$69EC, #$69E2, #$6A1B, #$6A1D,
      #$69FE, #$6A27, #$69F2, #$69EE, #$6A14, #$69F7, #$69E7, #$6A40,
      #$6A08, #$69E6, #$69FB, #$6A0D, #$69FC, #$69EB, #$6A09, #$6A04,
      #$6A18, #$6A25, #$6A0F, #$69F6, #$6A26, #$6A07, #$69F4, #$6A16,
      #$6B51, #$6BA5, #$6BA3, #$6BA2, #$6BA6, #$6C01, #$6C00, #$6BFF,
      #$6C02, #$6F41, #$6F26, #$6F7E, #$6F87, #$6FC6, #$6F92, #$6F8D,
      #$6F89, #$6F8C, #$6F62, #$6F4F, #$6F85, #$6F5A, #$6F96, #$6F76,
      #$6F6C, #$6F82, #$6F55, #$6F72, #$6F52, #$6F50, #$6F57, #$6F94,
      #$6F93, #$6F5D, #$6F00, #$6F61, #$6F6B, #$6F7D, #$6F67, #$6F90,
      #$6F53, #$6F8B, #$6F69, #$6F7F, #$6F95, #$6F63, #$6F77, #$6F6A,
      #$6F7B, #$71B2, #$71AF, #$719B, #$71B0, #$71A0, #$719A, #$71A9,
      #$71B5, #$719D, #$71A5, #$719E, #$71A4, #$71A1, #$71AA, #$719C,
      #$71A7, #$71B3, #$7298, #$729A, #$7358, #$7352,
      #$735E, #$735F, #$7360, #$735D, #$735B, #$7361, #$735A, #$7359,
      #$7362, #$7487, #$7489, #$748A, #$7486, #$7481, #$747D, #$7485,
      #$7488, #$747C, #$7479, #$7508, #$7507, #$757E, #$7625, #$761E,
      #$7619, #$761D, #$761C, #$7623, #$761A, #$7628, #$761B, #$769C,
      #$769D, #$769E, #$769B, #$778D, #$778F, #$7789, #$7788, #$78CD,
      #$78BB, #$78CF, #$78CC, #$78D1, #$78CE, #$78D4, #$78C8, #$78C3,
      #$78C4, #$78C9, #$799A, #$79A1, #$79A0, #$799C, #$79A2, #$799B,
      #$6B76, #$7A39, #$7AB2, #$7AB4, #$7AB3, #$7BB7, #$7BCB, #$7BBE,
      #$7BAC, #$7BCE, #$7BAF, #$7BB9, #$7BCA, #$7BB5, #$7CC5, #$7CC8,
      #$7CCC, #$7CCB, #$7DF7, #$7DDB, #$7DEA, #$7DE7, #$7DD7, #$7DE1,
      #$7E03, #$7DFA, #$7DE6, #$7DF6, #$7DF1, #$7DF0, #$7DEE, #$7DDF,
      #$7F76, #$7FAC, #$7FB0, #$7FAD, #$7FED, #$7FEB,
      #$7FEA, #$7FEC, #$7FE6, #$7FE8, #$8064, #$8067, #$81A3, #$819F,
      #$819E, #$8195, #$81A2, #$8199, #$8197, #$8216, #$824F, #$8253,
      #$8252, #$8250, #$824E, #$8251, #$8524, #$853B, #$850F, #$8500,
      #$8529, #$850E, #$8509, #$850D, #$851F, #$850A, #$8527, #$851C,
      #$84FB, #$852B, #$84FA, #$8508, #$850C, #$84F4, #$852A, #$84F2,
      #$8515, #$84F7, #$84EB, #$84F3, #$84FC, #$8512, #$84EA, #$84E9,
      #$8516, #$84FE, #$8528, #$851D, #$852E, #$8502, #$84FD, #$851E,
      #$84F6, #$8531, #$8526, #$84E7, #$84E8, #$84F0, #$84EF, #$84F9,
      #$8518, #$8520, #$8530, #$850B, #$8519, #$852F, #$8662, #$8756,
      #$8763, #$8764, #$8777, #$87E1, #$8773, #$8758, #$8754, #$875B,
      #$8752, #$8761, #$875A, #$8751, #$875E, #$876D, #$876A, #$8750,
      #$874E, #$875F, #$875D, #$876F, #$876C, #$877A,
      #$876E, #$875C, #$8765, #$874F, #$877B, #$8775, #$8762, #$8767,
      #$8769, #$885A, #$8905, #$890C, #$8914, #$890B, #$8917, #$8918,
      #$8919, #$8906, #$8916, #$8911, #$890E, #$8909, #$89A2, #$89A4,
      #$89A3, #$89ED, #$89F0, #$89EC, #$8ACF, #$8AC6, #$8AB8, #$8AD3,
      #$8AD1, #$8AD4, #$8AD5, #$8ABB, #$8AD7, #$8ABE, #$8AC0, #$8AC5,
      #$8AD8, #$8AC3, #$8ABA, #$8ABD, #$8AD9, #$8C3E, #$8C4D, #$8C8F,
      #$8CE5, #$8CDF, #$8CD9, #$8CE8, #$8CDA, #$8CDD, #$8CE7, #$8DA0,
      #$8D9C, #$8DA1, #$8D9B, #$8E20, #$8E23, #$8E25, #$8E24, #$8E2E,
      #$8E15, #$8E1B, #$8E16, #$8E11, #$8E19, #$8E26, #$8E27, #$8E14,
      #$8E12, #$8E18, #$8E13, #$8E1C, #$8E17, #$8E1A, #$8F2C, #$8F24,
      #$8F18, #$8F1A, #$8F20, #$8F23, #$8F16, #$8F17, #$9073, #$9070,
      #$906F, #$9067, #$906B, #$912F, #$912B, #$9129,
      #$912A, #$9132, #$9126, #$912E, #$9185, #$9186, #$918A, #$9181,
      #$9182, #$9184, #$9180, #$92D0, #$92C3, #$92C4, #$92C0, #$92D9,
      #$92B6, #$92CF, #$92F1, #$92DF, #$92D8, #$92E9, #$92D7, #$92DD,
      #$92CC, #$92EF, #$92C2, #$92E8, #$92CA, #$92C8, #$92CE, #$92E6,
      #$92CD, #$92D5, #$92C9, #$92E0, #$92DE, #$92E7, #$92D1, #$92D3,
      #$92B5, #$92E1, #$9325, #$92C6, #$92B4, #$957C, #$95AC, #$95AB,
      #$95AE, #$95B0, #$96A4, #$96A2, #$96D3, #$9705, #$9708, #$9702,
      #$975A, #$978A, #$978E, #$9788, #$97D0, #$97CF, #$981E, #$981D,
      #$9826, #$9829, #$9828, #$9820, #$981B, #$9827, #$98B2, #$9908,
      #$98FA, #$9911, #$9914, #$9916, #$9917, #$9915, #$99DC, #$99CD,
      #$99CF, #$99D3, #$99D4, #$99CE, #$99C9, #$99D6, #$99D8, #$99CB,
      #$99D7, #$99CC, #$9AB3, #$9AEC, #$9AEB, #$9AF3,
      #$9AF2, #$9AF1, #$9B46, #$9B43, #$9B67, #$9B74, #$9B71, #$9B66,
      #$9B76, #$9B75, #$9B70, #$9B68, #$9B64, #$9B6C, #$9CFC, #$9CFA,
      #$9CFD, #$9CFF, #$9CF7, #$9D07, #$9D00, #$9CF9, #$9CFB, #$9D08,
      #$9D05, #$9D04, #$9E83, #$9ED3, #$9F0F, #$9F10, #$511C, #$5113,
      #$5117, #$511A, #$5111, #$51DE, #$5334, #$53E1, #$5670, #$5660,
      #$566E, #$5673, #$5666, #$5663, #$566D, #$5672, #$565E, #$5677,
      #$571C, #$571B, #$58C8, #$58BD, #$58C9, #$58BF, #$58BA, #$58C2,
      #$58BC, #$58C6, #$5B17, #$5B19, #$5B1B, #$5B21, #$5B14, #$5B13,
      #$5B10, #$5B16, #$5B28, #$5B1A, #$5B20, #$5B1E, #$5BEF, #$5DAC,
      #$5DB1, #$5DA9, #$5DA7, #$5DB5, #$5DB0, #$5DAE, #$5DAA, #$5DA8,
      #$5DB2, #$5DAD, #$5DAF, #$5DB4, #$5E67, #$5E68, #$5E66, #$5E6F,
      #$5EE9, #$5EE7, #$5EE6, #$5EE8, #$5EE5, #$5F4B,
      #$5FBC, #$5FBB, #$619D, #$61A8, #$6196, #$61C5, #$61B4, #$61C6,
      #$61C1, #$61CC, #$61BA, #$61BF, #$61B8, #$618C, #$64D7, #$64D6,
      #$64D0, #$64CF, #$64C9, #$64BD, #$6489, #$64C3, #$64DB, #$64F3,
      #$64D9, #$6533, #$657F, #$657C, #$65A2, #$66C8, #$66BE, #$66C0,
      #$66CA, #$66CB, #$66CF, #$66BD, #$66BB, #$66BA, #$66CC, #$6723,
      #$6A34, #$6A66, #$6A49, #$6A67, #$6A32, #$6A68, #$6A3E, #$6A5D,
      #$6A6D, #$6A76, #$6A5B, #$6A51, #$6A28, #$6A5A, #$6A3B, #$6A3F,
      #$6A41, #$6A6A, #$6A64, #$6A50, #$6A4F, #$6A54, #$6A6F, #$6A69,
      #$6A60, #$6A3C, #$6A5E, #$6A56, #$6A55, #$6A4D, #$6A4E, #$6A46,
      #$6B55, #$6B54, #$6B56, #$6BA7, #$6BAA, #$6BAB, #$6BC8, #$6BC7,
      #$6C04, #$6C03, #$6C06, #$6FAD, #$6FCB, #$6FA3, #$6FC7, #$6FBC,
      #$6FCE, #$6FC8, #$6F5E, #$6FC4, #$6FBD, #$6F9E,
      #$6FCA, #$6FA8, #$7004, #$6FA5, #$6FAE, #$6FBA, #$6FAC, #$6FAA,
      #$6FCF, #$6FBF, #$6FB8, #$6FA2, #$6FC9, #$6FAB, #$6FCD, #$6FAF,
      #$6FB2, #$6FB0, #$71C5, #$71C2, #$71BF, #$71B8, #$71D6, #$71C0,
      #$71C1, #$71CB, #$71D4, #$71CA, #$71C7, #$71CF, #$71BD, #$71D8,
      #$71BC, #$71C6, #$71DA, #$71DB, #$729D, #$729E, #$7369, #$7366,
      #$7367, #$736C, #$7365, #$736B, #$736A, #$747F, #$749A, #$74A0,
      #$7494, #$7492, #$7495, #$74A1, #$750B, #$7580, #$762F, #$762D,
      #$7631, #$763D, #$7633, #$763C, #$7635, #$7632, #$7630, #$76BB,
      #$76E6, #$779A, #$779D, #$77A1, #$779C, #$779B, #$77A2, #$77A3,
      #$7795, #$7799, #$7797, #$78DD, #$78E9, #$78E5, #$78EA, #$78DE,
      #$78E3, #$78DB, #$78E1, #$78E2, #$78ED, #$78DF, #$78E0, #$79A4,
      #$7A44, #$7A48, #$7A47, #$7AB6, #$7AB8, #$7AB5,
      #$7AB1, #$7AB7, #$7BDE, #$7BE3, #$7BE7, #$7BDD, #$7BD5, #$7BE5,
      #$7BDA, #$7BE8, #$7BF9, #$7BD4, #$7BEA, #$7BE2, #$7BDC, #$7BEB,
      #$7BD8, #$7BDF, #$7CD2, #$7CD4, #$7CD7, #$7CD0, #$7CD1, #$7E12,
      #$7E21, #$7E17, #$7E0C, #$7E1F, #$7E20, #$7E13, #$7E0E, #$7E1C,
      #$7E15, #$7E1A, #$7E22, #$7E0B, #$7E0F, #$7E16, #$7E0D, #$7E14,
      #$7E25, #$7E24, #$7F43, #$7F7B, #$7F7C, #$7F7A, #$7FB1, #$7FEF,
      #$802A, #$8029, #$806C, #$81B1, #$81A6, #$81AE, #$81B9, #$81B5,
      #$81AB, #$81B0, #$81AC, #$81B4, #$81B2, #$81B7, #$81A7, #$81F2,
      #$8255, #$8256, #$8257, #$8556, #$8545, #$856B, #$854D, #$8553,
      #$8561, #$8558, #$8540, #$8546, #$8564, #$8541, #$8562, #$8544,
      #$8551, #$8547, #$8563, #$853E, #$855B, #$8571, #$854E, #$856E,
      #$8575, #$8555, #$8567, #$8560, #$858C, #$8566,
      #$855D, #$8554, #$8565, #$856C, #$8663, #$8665, #$8664, #$87A4,
      #$879B, #$878F, #$8797, #$8793, #$8792, #$8788, #$8781, #$8796,
      #$8798, #$8779, #$8787, #$87A3, #$8785, #$8790, #$8791, #$879D,
      #$8784, #$8794, #$879C, #$879A, #$8789, #$891E, #$8926, #$8930,
      #$892D, #$892E, #$8927, #$8931, #$8922, #$8929, #$8923, #$892F,
      #$892C, #$891F, #$89F1, #$8AE0, #$8AE2, #$8AF2, #$8AF4, #$8AF5,
      #$8ADD, #$8B14, #$8AE4, #$8ADF, #$8AF0, #$8AC8, #$8ADE, #$8AE1,
      #$8AE8, #$8AFF, #$8AEF, #$8AFB, #$8C91, #$8C92, #$8C90, #$8CF5,
      #$8CEE, #$8CF1, #$8CF0, #$8CF3, #$8D6C, #$8D6E, #$8DA5, #$8DA7,
      #$8E33, #$8E3E, #$8E38, #$8E40, #$8E45, #$8E36, #$8E3C, #$8E3D,
      #$8E41, #$8E30, #$8E3F, #$8EBD, #$8F36, #$8F2E, #$8F35, #$8F32,
      #$8F39, #$8F37, #$8F34, #$9076, #$9079, #$907B,
      #$9086, #$90FA, #$9133, #$9135, #$9136, #$9193, #$9190, #$9191,
      #$918D, #$918F, #$9327, #$931E, #$9308, #$931F, #$9306, #$930F,
      #$937A, #$9338, #$933C, #$931B, #$9323, #$9312, #$9301, #$9346,
      #$932D, #$930E, #$930D, #$92CB, #$931D, #$92FA, #$9313, #$92F9,
      #$92F7, #$9334, #$9302, #$9324, #$92FF, #$9329, #$9339, #$9335,
      #$932A, #$9314, #$930C, #$930B, #$92FE, #$9309, #$9300, #$92FB,
      #$9316, #$95BC, #$95CD, #$95BE, #$95B9, #$95BA, #$95B6, #$95BF,
      #$95B5, #$95BD, #$96A9, #$96D4, #$970B, #$9712, #$9710, #$9799,
      #$9797, #$9794, #$97F0, #$97F8, #$9835, #$982F, #$9832, #$9924,
      #$991F, #$9927, #$9929, #$999E, #$99EE, #$99EC, #$99E5, #$99E4,
      #$99F0, #$99E3, #$99EA, #$99E9, #$99E7, #$9AB9, #$9ABF, #$9AB4,
      #$9ABB, #$9AF6, #$9AFA, #$9AF9, #$9AF7, #$9B33,
      #$9B80, #$9B85, #$9B87, #$9B7C, #$9B7E, #$9B7B, #$9B82, #$9B93,
      #$9B92, #$9B90, #$9B7A, #$9B95, #$9B7D, #$9B88, #$9D25, #$9D17,
      #$9D20, #$9D1E, #$9D14, #$9D29, #$9D1D, #$9D18, #$9D22, #$9D10,
      #$9D19, #$9D1F, #$9E88, #$9E86, #$9E87, #$9EAE, #$9EAD, #$9ED5,
      #$9ED6, #$9EFA, #$9F12, #$9F3D, #$5126, #$5125, #$5122, #$5124,
      #$5120, #$5129, #$52F4, #$5693, #$568C, #$568D, #$5686, #$5684,
      #$5683, #$567E, #$5682, #$567F, #$5681, #$58D6, #$58D4, #$58CF,
      #$58D2, #$5B2D, #$5B25, #$5B32, #$5B23, #$5B2C, #$5B27, #$5B26,
      #$5B2F, #$5B2E, #$5B7B, #$5BF1, #$5BF2, #$5DB7, #$5E6C, #$5E6A,
      #$5FBE, #$61C3, #$61B5, #$61BC, #$61E7, #$61E0, #$61E5, #$61E4,
      #$61E8, #$61DE, #$64EF, #$64E9, #$64E3, #$64EB, #$64E4, #$64E8,
      #$6581, #$6580, #$65B6, #$65DA, #$66D2, #$6A8D,
      #$6A96, #$6A81, #$6AA5, #$6A89, #$6A9F, #$6A9B, #$6AA1, #$6A9E,
      #$6A87, #$6A93, #$6A8E, #$6A95, #$6A83, #$6AA8, #$6AA4, #$6A91,
      #$6A7F, #$6AA6, #$6A9A, #$6A85, #$6A8C, #$6A92, #$6B5B, #$6BAD,
      #$6C09, #$6FCC, #$6FA9, #$6FF4, #$6FD4, #$6FE3, #$6FDC, #$6FED,
      #$6FE7, #$6FE6, #$6FDE, #$6FF2, #$6FDD, #$6FE2, #$6FE8, #$71E1,
      #$71F1, #$71E8, #$71F2, #$71E4, #$71F0, #$71E2, #$7373, #$736E,
      #$736F, #$7497, #$74B2, #$74AB, #$7490, #$74AA, #$74AD, #$74B1,
      #$74A5, #$74AF, #$7510, #$7511, #$7512, #$750F, #$7584, #$7643,
      #$7648, #$7649, #$7647, #$76A4, #$76E9, #$77B5, #$77AB, #$77B2,
      #$77B7, #$77B6, #$77B4, #$77B1, #$77A8, #$77F0, #$78F3, #$78FD,
      #$7902, #$78FB, #$78FC, #$78FF, #$78F2, #$7905, #$78F9, #$78FE,
      #$7904, #$79AB, #$79A8, #$7A5C, #$7A5B, #$7A56,
      #$7A58, #$7A54, #$7A5A, #$7ABE, #$7AC0, #$7AC1, #$7C05, #$7C0F,
      #$7BF2, #$7C00, #$7BFF, #$7BFB, #$7C0E, #$7BF4, #$7C0B, #$7BF3,
      #$7C02, #$7C09, #$7C03, #$7C01, #$7BF8, #$7BFD, #$7C06, #$7BF0,
      #$7BF1, #$7C10, #$7C0A, #$7CE8, #$7E2D, #$7E3C, #$7E42, #$7E33,
      #$9848, #$7E38, #$7E2A, #$7E49, #$7E40, #$7E47, #$7E29, #$7E4C,
      #$7E30, #$7E3B, #$7E36, #$7E44, #$7E3A, #$7F45, #$7F7F, #$7F7E,
      #$7F7D, #$7FF4, #$7FF2, #$802C, #$81BB, #$81C4, #$81CC, #$81CA,
      #$81C5, #$81C7, #$81BC, #$81E9, #$825B, #$825A, #$825C, #$8583,
      #$8580, #$858F, #$85A7, #$8595, #$85A0, #$858B, #$85A3, #$857B,
      #$85A4, #$859A, #$859E, #$8577, #$857C, #$8589, #$85A1, #$857A,
      #$8578, #$8557, #$858E, #$8596, #$8586, #$858D, #$8599, #$859D,
      #$8581, #$85A2, #$8582, #$8588, #$8585, #$8579,
      #$8576, #$8598, #$8590, #$859F, #$8668, #$87BE, #$87AA, #$87AD,
      #$87C5, #$87B0, #$87AC, #$87B9, #$87B5, #$87BC, #$87AE, #$87C9,
      #$87C3, #$87C2, #$87CC, #$87B7, #$87AF, #$87C4, #$87CA, #$87B4,
      #$87B6, #$87BF, #$87B8, #$87BD, #$87DE, #$87B2, #$8935, #$8933,
      #$893C, #$893E, #$8941, #$8952, #$8937, #$8942, #$89AD, #$89AF,
      #$89AE, #$89F2, #$89F3, #$8B1E, #$8B18, #$8B16, #$8B11, #$8B05,
      #$8B0B, #$8B22, #$8B0F, #$8B12, #$8B15, #$8B07, #$8B0D, #$8B08,
      #$8B06, #$8B1C, #$8B13, #$8B1A, #$8C4F, #$8C70, #$8C72, #$8C71,
      #$8C6F, #$8C95, #$8C94, #$8CF9, #$8D6F, #$8E4E, #$8E4D, #$8E53,
      #$8E50, #$8E4C, #$8E47, #$8F43, #$8F40, #$9085, #$907E, #$9138,
      #$919A, #$91A2, #$919B, #$9199, #$919F, #$91A1, #$919D, #$91A0,
      #$93A1, #$9383, #$93AF, #$9364, #$9356, #$9347,
      #$937C, #$9358, #$935C, #$9376, #$9349, #$9350, #$9351, #$9360,
      #$936D, #$938F, #$934C, #$936A, #$9379, #$9357, #$9355, #$9352,
      #$934F, #$9371, #$9377, #$937B, #$9361, #$935E, #$9363, #$9367,
      #$934E, #$9359, #$95C7, #$95C0, #$95C9, #$95C3, #$95C5, #$95B7,
      #$96AE, #$96B0, #$96AC, #$9720, #$971F, #$9718, #$971D, #$9719,
      #$979A, #$97A1, #$979C, #$979E, #$979D, #$97D5, #$97D4, #$97F1,
      #$9841, #$9844, #$984A, #$9849, #$9845, #$9843, #$9925, #$992B,
      #$992C, #$992A, #$9933, #$9932, #$992F, #$992D, #$9931, #$9930,
      #$9998, #$99A3, #$99A1, #$9A02, #$99FA, #$99F4, #$99F7, #$99F9,
      #$99F8, #$99F6, #$99FB, #$99FD, #$99FE, #$99FC, #$9A03, #$9ABE,
      #$9AFE, #$9AFD, #$9B01, #$9AFC, #$9B48, #$9B9A, #$9BA8, #$9B9E,
      #$9B9B, #$9BA6, #$9BA1, #$9BA5, #$9BA4, #$9B86,
      #$9BA2, #$9BA0, #$9BAF, #$9D33, #$9D41, #$9D67, #$9D36, #$9D2E,
      #$9D2F, #$9D31, #$9D38, #$9D30, #$9D45, #$9D42, #$9D43, #$9D3E,
      #$9D37, #$9D40, #$9D3D, #$7FF5, #$9D2D, #$9E8A, #$9E89, #$9E8D,
      #$9EB0, #$9EC8, #$9EDA, #$9EFB, #$9EFF, #$9F24, #$9F23, #$9F22,
      #$9F54, #$9FA0, #$5131, #$512D, #$512E, #$5698, #$569C, #$5697,
      #$569A, #$569D, #$5699, #$5970, #$5B3C, #$5C69, #$5C6A, #$5DC0,
      #$5E6D, #$5E6E, #$61D8, #$61DF, #$61ED, #$61EE, #$61F1, #$61EA,
      #$61F0, #$61EB, #$61D6, #$61E9, #$64FF, #$6504, #$64FD, #$64F8,
      #$6501, #$6503, #$64FC, #$6594, #$65DB, #$66DA, #$66DB, #$66D8,
      #$6AC5, #$6AB9, #$6ABD, #$6AE1, #$6AC6, #$6ABA, #$6AB6, #$6AB7,
      #$6AC7, #$6AB4, #$6AAD, #$6B5E, #$6BC9, #$6C0B, #$7007, #$700C,
      #$700D, #$7001, #$7005, #$7014, #$700E, #$6FFF,
      #$7000, #$6FFB, #$7026, #$6FFC, #$6FF7, #$700A, #$7201, #$71FF,
      #$71F9, #$7203, #$71FD, #$7376, #$74B8, #$74C0, #$74B5, #$74C1,
      #$74BE, #$74B6, #$74BB, #$74C2, #$7514, #$7513, #$765C, #$7664,
      #$7659, #$7650, #$7653, #$7657, #$765A, #$76A6, #$76BD, #$76EC,
      #$77C2, #$77BA, #$790C, #$7913, #$7914, #$7909, #$7910, #$7912,
      #$7911, #$79AD, #$79AC, #$7A5F, #$7C1C, #$7C29, #$7C19, #$7C20,
      #$7C1F, #$7C2D, #$7C1D, #$7C26, #$7C28, #$7C22, #$7C25, #$7C30,
      #$7E5C, #$7E50, #$7E56, #$7E63, #$7E58, #$7E62, #$7E5F, #$7E51,
      #$7E60, #$7E57, #$7E53, #$7FB5, #$7FB3, #$7FF7, #$7FF8, #$8075,
      #$81D1, #$81D2, #$81D0, #$825F, #$825E, #$85B4, #$85C6, #$85C0,
      #$85C3, #$85C2, #$85B3, #$85B5, #$85BD, #$85C7, #$85C4, #$85BF,
      #$85CB, #$85CE, #$85C8, #$85C5, #$85B1, #$85B6,
      #$85D2, #$8624, #$85B8, #$85B7, #$85BE, #$8669, #$87E7, #$87E6,
      #$87E2, #$87DB, #$87EB, #$87EA, #$87E5, #$87DF, #$87F3, #$87E4,
      #$87D4, #$87DC, #$87D3, #$87ED, #$87D8, #$87E3, #$87D7, #$87D9,
      #$8801, #$87F4, #$87E8, #$87DD, #$8953, #$894B, #$894F, #$894C,
      #$8946, #$8950, #$8951, #$8949, #$8B2A, #$8B27, #$8B23, #$8B33,
      #$8B30, #$8B35, #$8B47, #$8B2F, #$8B3C, #$8B3E, #$8B31, #$8B25,
      #$8B37, #$8B26, #$8B36, #$8B2E, #$8B24, #$8B3B, #$8B3D, #$8B3A,
      #$8C42, #$8C75, #$8C99, #$8C98, #$8C97, #$8CFE, #$8D04, #$8D02,
      #$8D00, #$8E5C, #$8E62, #$8E60, #$8E57, #$8E56, #$8E5E, #$8E65,
      #$8E67, #$8E5B, #$8E5A, #$8E61, #$8E5D, #$8E69, #$8E54, #$8F46,
      #$8F47, #$8F48, #$8F4B, #$9128, #$913A, #$913B, #$913E, #$91A8,
      #$91A5, #$91A7, #$91AF, #$91AA, #$93B5, #$938C,
      #$9392, #$93B7, #$939B, #$939D, #$9389, #$93A7, #$938E, #$93AA,
      #$939E, #$93A6, #$9395, #$9388, #$9399, #$939F, #$9380, #$938D,
      #$93B1, #$9391, #$93B2, #$93A4, #$93A8, #$93B4, #$93A3, #$95D2,
      #$95D3, #$95D1, #$96B3, #$96D7, #$96DA, #$5DC2, #$96DF, #$96D8,
      #$96DD, #$9723, #$9722, #$9725, #$97AC, #$97AE, #$97A8, #$97AB,
      #$97A4, #$97AA, #$97A2, #$97A5, #$97D7, #$97D9, #$97D6, #$97D8,
      #$97FA, #$9850, #$9851, #$9852, #$98B8, #$9941, #$993C, #$993A,
      #$9A0F, #$9A0B, #$9A09, #$9A0D, #$9A04, #$9A11, #$9A0A, #$9A05,
      #$9A07, #$9A06, #$9AC0, #$9ADC, #$9B08, #$9B04, #$9B05, #$9B29,
      #$9B35, #$9B4A, #$9B4C, #$9B4B, #$9BC7, #$9BC6, #$9BC3, #$9BBF,
      #$9BC1, #$9BB5, #$9BB8, #$9BD3, #$9BB6, #$9BC4, #$9BB9, #$9BBD,
      #$9D5C, #$9D53, #$9D4F, #$9D4A, #$9D5B, #$9D4B,
      #$9D59, #$9D56, #$9D4C, #$9D57, #$9D52, #$9D54, #$9D5F, #$9D58,
      #$9D5A, #$9E8E, #$9E8C, #$9EDF, #$9F01, #$9F00, #$9F16, #$9F25,
      #$9F2B, #$9F2A, #$9F29, #$9F28, #$9F4C, #$9F55, #$5134, #$5135,
      #$5296, #$52F7, #$53B4, #$56AB, #$56AD, #$56A6, #$56A7, #$56AA,
      #$56AC, #$58DA, #$58DD, #$58DB, #$5912, #$5B3D, #$5B3E, #$5B3F,
      #$5DC3, #$5E70, #$5FBF, #$61FB, #$6507, #$6510, #$650D, #$6509,
      #$650C, #$650E, #$6584, #$65DE, #$65DD, #$66DE, #$6AE7, #$6AE0,
      #$6ACC, #$6AD1, #$6AD9, #$6ACB, #$6ADF, #$6ADC, #$6AD0, #$6AEB,
      #$6ACF, #$6ACD, #$6ADE, #$6B60, #$6BB0, #$6C0C, #$7019, #$7027,
      #$7020, #$7016, #$702B, #$7021, #$7022, #$7023, #$7029, #$7017,
      #$7024, #$701C, #$720C, #$720A, #$7207, #$7202, #$7205, #$72A5,
      #$72A6, #$72A4, #$72A3, #$72A1, #$74CB, #$74C5,
      #$74B7, #$74C3, #$7516, #$7660, #$77C9, #$77CA, #$77C4, #$77F1,
      #$791D, #$791B, #$7921, #$791C, #$7917, #$791E, #$79B0, #$7A67,
      #$7A68, #$7C33, #$7C3C, #$7C39, #$7C2C, #$7C3B, #$7CEC, #$7CEA,
      #$7E76, #$7E75, #$7E78, #$7E70, #$7E77, #$7E6F, #$7E7A, #$7E72,
      #$7E74, #$7E68, #$7F4B, #$7F4A, #$7F83, #$7F86, #$7FB7, #$7FFD,
      #$7FFE, #$8078, #$81D7, #$81D5, #$820B, #$8264, #$8261, #$8263,
      #$85EB, #$85F1, #$85ED, #$85D9, #$85E1, #$85E8, #$85DA, #$85D7,
      #$85EC, #$85F2, #$85F8, #$85D8, #$85DF, #$85E3, #$85DC, #$85D1,
      #$85F0, #$85E6, #$85EF, #$85DE, #$85E2, #$8800, #$87FA, #$8803,
      #$87F6, #$87F7, #$8809, #$880C, #$880B, #$8806, #$87FC, #$8808,
      #$87FF, #$880A, #$8802, #$8962, #$895A, #$895B, #$8957, #$8961,
      #$895C, #$8958, #$895D, #$8959, #$8988, #$89B7,
      #$89B6, #$89F6, #$8B50, #$8B48, #$8B4A, #$8B40, #$8B53, #$8B56,
      #$8B54, #$8B4B, #$8B55, #$8B51, #$8B42, #$8B52, #$8B57, #$8C43,
      #$8C77, #$8C76, #$8C9A, #$8D06, #$8D07, #$8D09, #$8DAC, #$8DAA,
      #$8DAD, #$8DAB, #$8E6D, #$8E78, #$8E73, #$8E6A, #$8E6F, #$8E7B,
      #$8EC2, #$8F52, #$8F51, #$8F4F, #$8F50, #$8F53, #$8FB4, #$9140,
      #$913F, #$91B0, #$91AD, #$93DE, #$93C7, #$93CF, #$93C2, #$93DA,
      #$93D0, #$93F9, #$93EC, #$93CC, #$93D9, #$93A9, #$93E6, #$93CA,
      #$93D4, #$93EE, #$93E3, #$93D5, #$93C4, #$93CE, #$93C0, #$93D2,
      #$93A5, #$93E7, #$957D, #$95DA, #$95DB, #$96E1, #$9729, #$972B,
      #$972C, #$9728, #$9726, #$97B3, #$97B7, #$97B6, #$97DD, #$97DE,
      #$97DF, #$985C, #$9859, #$985D, #$9857, #$98BF, #$98BD, #$98BB,
      #$98BE, #$9948, #$9947, #$9943, #$99A6, #$99A7,
      #$9A1A, #$9A15, #$9A25, #$9A1D, #$9A24, #$9A1B, #$9A22, #$9A20,
      #$9A27, #$9A23, #$9A1E, #$9A1C, #$9A14, #$9AC2, #$9B0B, #$9B0A,
      #$9B0E, #$9B0C, #$9B37, #$9BEA, #$9BEB, #$9BE0, #$9BDE, #$9BE4,
      #$9BE6, #$9BE2, #$9BF0, #$9BD4, #$9BD7, #$9BEC, #$9BDC, #$9BD9,
      #$9BE5, #$9BD5, #$9BE1, #$9BDA, #$9D77, #$9D81, #$9D8A, #$9D84,
      #$9D88, #$9D71, #$9D80, #$9D78, #$9D86, #$9D8B, #$9D8C, #$9D7D,
      #$9D6B, #$9D74, #$9D75, #$9D70, #$9D69, #$9D85, #$9D73, #$9D7B,
      #$9D82, #$9D6F, #$9D79, #$9D7F, #$9D87, #$9D68, #$9E94, #$9E91,
      #$9EC0, #$9EFC, #$9F2D, #$9F40, #$9F41, #$9F4D, #$9F56, #$9F57,
      #$9F58, #$5337, #$56B2, #$56B5, #$56B3, #$58E3, #$5B45, #$5DC6,
      #$5DC7, #$5EEE, #$5EEF, #$5FC0, #$5FC1, #$61F9, #$6517, #$6516,
      #$6515, #$6513, #$65DF, #$66E8, #$66E3, #$66E4,
      #$6AF3, #$6AF0, #$6AEA, #$6AE8, #$6AF9, #$6AF1, #$6AEE, #$6AEF,
      #$703C, #$7035, #$702F, #$7037, #$7034, #$7031, #$7042, #$7038,
      #$703F, #$703A, #$7039, #$702A, #$7040, #$703B, #$7033, #$7041,
      #$7213, #$7214, #$72A8, #$737D, #$737C, #$74BA, #$76AB, #$76AA,
      #$76BE, #$76ED, #$77CC, #$77CE, #$77CF, #$77CD, #$77F2, #$7925,
      #$7923, #$7927, #$7928, #$7924, #$7929, #$79B2, #$7A6E, #$7A6C,
      #$7A6D, #$7AF7, #$7C49, #$7C48, #$7C4A, #$7C47, #$7C45, #$7CEE,
      #$7E7B, #$7E7E, #$7E81, #$7E80, #$7FBA, #$7FFF, #$8079, #$81DB,
      #$81D9, #$8268, #$8269, #$8622, #$85FF, #$8601, #$85FE, #$861B,
      #$8600, #$85F6, #$8604, #$8609, #$8605, #$860C, #$85FD, #$8819,
      #$8810, #$8811, #$8817, #$8813, #$8816, #$8963, #$8966, #$89B9,
      #$89F7, #$8B60, #$8B6A, #$8B5D, #$8B68, #$8B63,
      #$8B65, #$8B67, #$8B6D, #$8DAE, #$8E86, #$8E88, #$8E84, #$8F59,
      #$8F56, #$8F57, #$8F55, #$8F58, #$8F5A, #$908D, #$9143, #$9141,
      #$91B7, #$91B5, #$91B2, #$91B3, #$940B, #$9413, #$93FB, #$9420,
      #$940F, #$9414, #$93FE, #$9415, #$9410, #$9428, #$9419, #$940D,
      #$93F5, #$9400, #$93F7, #$9407, #$940E, #$9416, #$9412, #$93FA,
      #$9409, #$93F8, #$943C, #$940A, #$93FF, #$93FC, #$940C, #$93F6,
      #$9411, #$9406, #$95DE, #$95E0, #$95DF, #$972E, #$972F, #$97B9,
      #$97BB, #$97FD, #$97FE, #$9860, #$9862, #$9863, #$985F, #$98C1,
      #$98C2, #$9950, #$994E, #$9959, #$994C, #$994B, #$9953, #$9A32,
      #$9A34, #$9A31, #$9A2C, #$9A2A, #$9A36, #$9A29, #$9A2E, #$9A38,
      #$9A2D, #$9AC7, #$9ACA, #$9AC6, #$9B10, #$9B12, #$9B11, #$9C0B,
      #$9C08, #$9BF7, #$9C05, #$9C12, #$9BF8, #$9C40,
      #$9C07, #$9C0E, #$9C06, #$9C17, #$9C14, #$9C09, #$9D9F, #$9D99,
      #$9DA4, #$9D9D, #$9D92, #$9D98, #$9D90, #$9D9B, #$9DA0, #$9D94,
      #$9D9C, #$9DAA, #$9D97, #$9DA1, #$9D9A, #$9DA2, #$9DA8, #$9D9E,
      #$9DA3, #$9DBF, #$9DA9, #$9D96, #$9DA6, #$9DA7, #$9E99, #$9E9B,
      #$9E9A, #$9EE5, #$9EE4, #$9EE7, #$9EE6, #$9F30, #$9F2E, #$9F5B,
      #$9F60, #$9F5E, #$9F5D, #$9F59, #$9F91, #$513A, #$5139, #$5298,
      #$5297, #$56C3, #$56BD, #$56BE, #$5B48, #$5B47, #$5DCB, #$5DCF,
      #$5EF1, #$61FD, #$651B, #$6B02, #$6AFC, #$6B03, #$6AF8, #$6B00,
      #$7043, #$7044, #$704A, #$7048, #$7049, #$7045, #$7046, #$721D,
      #$721A, #$7219, #$737E, #$7517, #$766A, #$77D0, #$792D, #$7931,
      #$792F, #$7C54, #$7C53, #$7CF2, #$7E8A, #$7E87, #$7E88, #$7E8B,
      #$7E86, #$7E8D, #$7F4D, #$7FBB, #$8030, #$81DD,
      #$8618, #$862A, #$8626, #$861F, #$8623, #$861C, #$8619, #$8627,
      #$862E, #$8621, #$8620, #$8629, #$861E, #$8625, #$8829, #$881D,
      #$881B, #$8820, #$8824, #$881C, #$882B, #$884A, #$896D, #$8969,
      #$896E, #$896B, #$89FA, #$8B79, #$8B78, #$8B45, #$8B7A, #$8B7B,
      #$8D10, #$8D14, #$8DAF, #$8E8E, #$8E8C, #$8F5E, #$8F5B, #$8F5D,
      #$9146, #$9144, #$9145, #$91B9, #$943F, #$943B, #$9436, #$9429,
      #$943D, #$9430, #$9439, #$942A, #$9437, #$942C, #$9440, #$9431,
      #$95E5, #$95E4, #$95E3, #$9735, #$973A, #$97BF, #$97E1, #$9864,
      #$98C9, #$98C6, #$98C0, #$9958, #$9956, #$9A39, #$9A3D, #$9A46,
      #$9A44, #$9A42, #$9A41, #$9A3A, #$9A3F, #$9ACD, #$9B15, #$9B17,
      #$9B18, #$9B16, #$9B3A, #$9B52, #$9C2B, #$9C1D, #$9C1C, #$9C2C,
      #$9C23, #$9C28, #$9C29, #$9C24, #$9C21, #$9DB7,
      #$9DB6, #$9DBC, #$9DC1, #$9DC7, #$9DCA, #$9DCF, #$9DBE, #$9DC5,
      #$9DC3, #$9DBB, #$9DB5, #$9DCE, #$9DB9, #$9DBA, #$9DAC, #$9DC8,
      #$9DB1, #$9DAD, #$9DCC, #$9DB3, #$9DCD, #$9DB2, #$9E7A, #$9E9C,
      #$9EEB, #$9EEE, #$9EED, #$9F1B, #$9F18, #$9F1A, #$9F31, #$9F4E,
      #$9F65, #$9F64, #$9F92, #$4EB9, #$56C6, #$56C5, #$56CB, #$5971,
      #$5B4B, #$5B4C, #$5DD5, #$5DD1, #$5EF2, #$6521, #$6520, #$6526,
      #$6522, #$6B0B, #$6B08, #$6B09, #$6C0D, #$7055, #$7056, #$7057,
      #$7052, #$721E, #$721F, #$72A9, #$737F, #$74D8, #$74D5, #$74D9,
      #$74D7, #$766D, #$76AD, #$7935, #$79B4, #$7A70, #$7A71, #$7C57,
      #$7C5C, #$7C59, #$7C5B, #$7C5A, #$7CF4, #$7CF1, #$7E91, #$7F4F,
      #$7F87, #$81DE, #$826B, #$8634, #$8635, #$8633, #$862C, #$8632,
      #$8636, #$882C, #$8828, #$8826, #$882A, #$8825,
      #$8971, #$89BF, #$89BE, #$89FB, #$8B7E, #$8B84, #$8B82, #$8B86,
      #$8B85, #$8B7F, #$8D15, #$8E95, #$8E94, #$8E9A, #$8E92, #$8E90,
      #$8E96, #$8E97, #$8F60, #$8F62, #$9147, #$944C, #$9450, #$944A,
      #$944B, #$944F, #$9447, #$9445, #$9448, #$9449, #$9446, #$973F,
      #$97E3, #$986A, #$9869, #$98CB, #$9954, #$995B, #$9A4E, #$9A53,
      #$9A54, #$9A4C, #$9A4F, #$9A48, #$9A4A, #$9A49, #$9A52, #$9A50,
      #$9AD0, #$9B19, #$9B2B, #$9B3B, #$9B56, #$9B55, #$9C46, #$9C48,
      #$9C3F, #$9C44, #$9C39, #$9C33, #$9C41, #$9C3C, #$9C37, #$9C34,
      #$9C32, #$9C3D, #$9C36, #$9DDB, #$9DD2, #$9DDE, #$9DDA, #$9DCB,
      #$9DD0, #$9DDC, #$9DD1, #$9DDF, #$9DE9, #$9DD9, #$9DD8, #$9DD6,
      #$9DF5, #$9DD5, #$9DDD, #$9EB6, #$9EF0, #$9F35, #$9F33, #$9F32,
      #$9F42, #$9F6B, #$9F95, #$9FA2, #$513D, #$5299,
      #$58E8, #$58E7, #$5972, #$5B4D, #$5DD8, #$882F, #$5F4F, #$6201,
      #$6203, #$6204, #$6529, #$6525, #$6596, #$66EB, #$6B11, #$6B12,
      #$6B0F, #$6BCA, #$705B, #$705A, #$7222, #$7382, #$7381, #$7383,
      #$7670, #$77D4, #$7C67, #$7C66, #$7E95, #$826C, #$863A, #$8640,
      #$8639, #$863C, #$8631, #$863B, #$863E, #$8830, #$8832, #$882E,
      #$8833, #$8976, #$8974, #$8973, #$89FE, #$8B8C, #$8B8E, #$8B8B,
      #$8B88, #$8C45, #$8D19, #$8E98, #$8F64, #$8F63, #$91BC, #$9462,
      #$9455, #$945D, #$9457, #$945E, #$97C4, #$97C5, #$9800, #$9A56,
      #$9A59, #$9B1E, #$9B1F, #$9B20, #$9C52, #$9C58, #$9C50, #$9C4A,
      #$9C4D, #$9C4B, #$9C55, #$9C59, #$9C4C, #$9C4E, #$9DFB, #$9DF7,
      #$9DEF, #$9DE3, #$9DEB, #$9DF8, #$9DE4, #$9DF6, #$9DE1, #$9DEE,
      #$9DE6, #$9DF2, #$9DF0, #$9DE2, #$9DEC, #$9DF4,
      #$9DF3, #$9DE8, #$9DED, #$9EC2, #$9ED0, #$9EF2, #$9EF3, #$9F06,
      #$9F1C, #$9F38, #$9F37, #$9F36, #$9F43, #$9F4F, #$9F71, #$9F70,
      #$9F6E, #$9F6F, #$56D3, #$56CD, #$5B4E, #$5C6D, #$652D, #$66ED,
      #$66EE, #$6B13, #$705F, #$7061, #$705D, #$7060, #$7223, #$74DB,
      #$74E5, #$77D5, #$7938, #$79B7, #$79B6, #$7C6A, #$7E97, #$7F89,
      #$826D, #$8643, #$8838, #$8837, #$8835, #$884B, #$8B94, #$8B95,
      #$8E9E, #$8E9F, #$8EA0, #$8E9D, #$91BE, #$91BD, #$91C2, #$946B,
      #$9468, #$9469, #$96E5, #$9746, #$9743, #$9747, #$97C7, #$97E5,
      #$9A5E, #$9AD5, #$9B59, #$9C63, #$9C67, #$9C66, #$9C62, #$9C5E,
      #$9C60, #$9E02, #$9DFE, #$9E07, #$9E03, #$9E06, #$9E05, #$9E00,
      #$9E01, #$9E09, #$9DFF, #$9DFD, #$9E04, #$9EA0, #$9F1E, #$9F46,
      #$9F74, #$9F75, #$9F76, #$56D4, #$652E, #$65B8,
      #$6B18, #$6B19, #$6B17, #$6B1A, #$7062, #$7226, #$72AA, #$77D8,
      #$77D9, #$7939, #$7C69, #$7C6B, #$7CF6, #$7E9A, #$7E98, #$7E9B,
      #$7E99, #$81E0, #$81E1, #$8646, #$8647, #$8648, #$8979, #$897A,
      #$897C, #$897B, #$89FF, #$8B98, #$8B99, #$8EA5, #$8EA4, #$8EA3,
      #$946E, #$946D, #$946F, #$9471, #$9473, #$9749, #$9872, #$995F,
      #$9C68, #$9C6E, #$9C6D, #$9E0B, #$9E0D, #$9E10, #$9E0F, #$9E12,
      #$9E11, #$9EA1, #$9EF5, #$9F09, #$9F47, #$9F78, #$9F7B, #$9F7A,
      #$9F79, #$571E, #$7066, #$7C6F, #$883C, #$8DB2, #$8EA6, #$91C3,
      #$9474, #$9478, #$9476, #$9475, #$9A60, #$9B2E, #$9C74, #$9C73,
      #$9C71, #$9C75, #$9E14, #$9E13, #$9EF6, #$9F0A, #$9FA4, #$7068,
      #$7065, #$7CF7, #$866A, #$883E, #$883D, #$883F, #$8B9E, #$8C9C,
      #$8EA9, #$8EC9, #$974B, #$9873, #$9874, #$98CC,
      #$9961, #$99AB, #$9A64, #$9A66, #$9A67, #$9B24, #$9E15, #$9E17,
      #$9F48, #$6207, #$6B1E, #$7227, #$864C, #$8EA8, #$9482, #$9480,
      #$9481, #$9A69, #$9A68, #$9E19, #$864B, #$8B9F, #$9483, #$9C79,
      #$9EB7, #$7675, #$9A6B, #$9C7A, #$9E1D, #$7069, #$706A, #$7229,
      #$9EA4, #$9F7E, #$9F49, #$9F98);

  UHC_1_1Map: array[0..75] of Word = (
      $C8A5, $C8D8, $C910, $C93E, $C971, $C9A5, $C9DE, $CA1C,
      $CA47, $CA7B, $CAA8, $CADD, $CB0B, $CB3A, $CB6D, $CB99,
      $CBC5, $CBF3, $CC25, $CC67, $CC94, $CCCF, $CCFE, $CD34,
      $CD61, $CD92, $CDC6, $CDF5, $CE2C, $CE5D, $CE9A, $CECC,
      $CF02, $CF3B, $CF6D, $CF9E, $CFCC, $CFFF, $D02E, $D064,
      $D095, $D0CC, $D105, $D132, $D16E, $D19B, $D1D0, $D1FD,
      $D22A, $D25E, $D28D, $D2C5, $D2FB, $D33E, $D36A, $D3A1,
      $D3D7, $D40D, $D438, $D467, $D49E, $D4C9, $D4FE, $D52E,
      $D564, $D59D, $D5CA, $D606, $D63D, $D677, $D6AB, $D6E2,
      $D715, $D74E, $D78D, $FFFD);
  UHC_1_2Map: array[0..3125] of Byte = (
      $00, $01, $02, $04, $05, $06, $07, $08,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $19, $1A,
      $1B, $1C, $1D, $1E, $20, $21, $22, $24,
      $25, $26, $28, $29, $2A, $2B, $2C, $2D,
      $2E, $31, $00, $02, $03, $04, $05, $06,
      $07, $0A, $0B, $0D, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1C, $1E, $1F, $20, $21, $22,
      $23, $26, $27, $29, $2A, $2B, $2F, $30,
      $31, $32, $33, $36,
      $00, $02, $03, $04, $05, $06, $07, $09,
      $0A, $0B, $0C, $0D, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1D, $1E, $1F, $20, $21, $22,
      $23, $25, $26, $27, $28, $29, $2A, $2B,
      $2C, $2D, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $0E, $0F, $10, $11, $14, $15, $17, $18,
      $19, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $24, $26, $27, $28, $29, $2A, $2B, $2C,
      $2D, $2F, $30, $31,
      $00, $01, $02, $04, $05, $06, $07, $08,
      $09, $0A, $0C, $0D, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $19, $1A, $1C,
      $1D, $1E, $20, $21, $22, $23, $24, $25,
      $26, $29, $2B, $2D, $2E, $2F, $30, $31,
      $32, $33, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $0E, $0F, $10, $11, $12, $13, $14, $15,
      $16, $17, $18, $19, $1A, $1D, $1E, $20,
      $21, $24, $26, $27, $28, $29, $2A, $2D,
      $2F, $32, $33, $36,
      $00, $01, $03, $05, $07, $08, $0A, $0B,
      $0C, $0D, $10, $14, $15, $16, $17, $18,
      $19, $1C, $1D, $1F, $20, $21, $23, $24,
      $25, $26, $27, $28, $29, $2C, $30, $31,
      $32, $33, $34, $35, $37, $38, $39, $3B,
      $3C, $3D, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A,
      $00, $01, $02, $03, $04, $07, $08, $0A,
      $0B, $0C, $0E, $0F, $10, $11, $12, $13,
      $14, $17, $1B, $1C, $1D, $1E, $1F, $20,
      $22, $23, $24, $25, $26, $27, $28, $29,
      $2A, $2B, $2C, $2D, $2E, $2F, $30, $31,
      $32, $33, $00, $01, $03, $04, $05, $06,
      $07, $08, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $14, $15, $16, $17,
      $18, $19, $1A, $1B, $1C, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $16, $17, $19, $1A,
      $1B, $1D, $1E, $1F, $20, $21, $22, $23,
      $26, $28, $2A, $2C, $2D, $2E, $2F, $32,
      $33, $34, $00, $01, $02, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $10, $11, $12, $13, $14, $15, $16, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2C, $2D,
      $00, $01, $02, $03, $04, $06, $07, $08,
      $0A, $0B, $0C, $0E, $0F, $10, $11, $12,
      $13, $14, $17, $18, $19, $1A, $1B, $1C,
      $1D, $1E, $1F, $20, $21, $22, $23, $24,
      $25, $26, $27, $28, $29, $2A, $2B, $2C,
      $2D, $2E, $00, $01, $02, $03, $04, $05,
      $06, $08, $09, $0A, $0B, $0C, $0D, $10,
      $11, $13, $14, $15, $17, $18, $19, $1A,
      $1B, $1C, $1D, $20, $21, $22, $24, $25,
      $26, $27, $28, $29, $2B, $2C, $2D, $2E,
      $2F, $30, $31, $32,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0D, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $22, $23, $24, $25, $26, $27, $28, $29,
      $2A, $2B, $00, $01, $02, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $20, $21, $22, $23, $24, $25, $26, $27,
      $28, $29, $2A, $2B,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $20, $21,
      $23, $25, $26, $27, $28, $29, $2A, $2B,
      $2C, $2D, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $0E, $0F, $10, $11, $12, $13, $14, $15,
      $16, $17, $18, $1B, $1C, $1E, $1F, $20,
      $22, $23, $24, $25, $26, $27, $28, $2B,
      $2C, $2D, $30, $31,
      $00, $01, $05, $06, $08, $0A, $0C, $0D,
      $0E, $0F, $10, $11, $12, $15, $1A, $1B,
      $1C, $1D, $1E, $21, $22, $24, $25, $26,
      $28, $29, $2A, $2B, $2C, $2D, $2E, $31,
      $35, $36, $37, $38, $39, $3A, $3C, $3D,
      $3E, $40, $00, $02, $03, $04, $05, $06,
      $07, $08, $0A, $0B, $0C, $0D, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C,
      $00, $01, $02, $03, $06, $07, $09, $0A,
      $0B, $0D, $0E, $0F, $10, $11, $12, $13,
      $16, $1A, $1B, $1C, $1D, $1E, $1F, $22,
      $23, $25, $26, $27, $29, $2A, $2B, $2C,
      $2D, $2E, $2F, $32, $34, $36, $37, $38,
      $39, $3A, $00, $02, $03, $04, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $14, $16, $17, $18,
      $19, $1A, $1B, $1C, $1E, $1F, $20, $22,
      $23, $24, $25, $26, $27, $28, $29, $2A,
      $2B, $2C, $2D, $2E,
      $00, $01, $02, $04, $05, $06, $07, $08,
      $09, $0C, $0D, $0F, $10, $11, $13, $14,
      $15, $16, $17, $18, $19, $1C, $1E, $20,
      $21, $22, $23, $24, $25, $27, $28, $29,
      $2B, $2C, $2D, $2F, $30, $31, $32, $33,
      $34, $35, $00, $01, $02, $03, $04, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $29, $2A, $2B,
      $00, $01, $02, $04, $05, $06, $07, $08,
      $09, $0A, $0D, $0F, $11, $12, $13, $14,
      $15, $16, $18, $19, $1A, $1B, $1C, $1D,
      $1E, $1F, $20, $21, $22, $23, $24, $25,
      $26, $28, $29, $2A, $2B, $2C, $2D, $2E,
      $2F, $30, $00, $01, $04, $05, $07, $08,
      $09, $0B, $0C, $0D, $0E, $0F, $10, $11,
      $14, $16, $18, $19, $1A, $1B, $1C, $1D,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A, $2B, $2C, $2D, $2E,
      $2F, $30, $31, $33,
      $00, $01, $02, $03, $04, $05, $07, $08,
      $09, $0B, $0C, $0D, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $23, $24, $25, $27, $28, $29, $2B, $2C,
      $2D, $2E, $00, $01, $02, $05, $07, $09,
      $0A, $0B, $0C, $0D, $0E, $10, $11, $12,
      $14, $15, $16, $18, $19, $1A, $1B, $1C,
      $1D, $1E, $20, $21, $22, $23, $25, $26,
      $27, $28, $29, $2A, $2D, $2E, $30, $31,
      $32, $34, $35, $36,
      $00, $01, $02, $03, $06, $08, $0A, $0B,
      $0C, $0D, $0E, $0F, $10, $11, $12, $13,
      $14, $15, $16, $17, $18, $19, $1A, $1B,
      $1C, $1D, $1E, $1F, $20, $21, $22, $23,
      $24, $25, $26, $27, $28, $29, $2A, $2B,
      $2E, $2F, $00, $01, $05, $06, $07, $08,
      $09, $0A, $0D, $0F, $11, $12, $13, $14,
      $15, $16, $19, $1A, $1C, $1D, $1E, $20,
      $21, $22, $23, $24, $25, $26, $29, $2B,
      $2D, $2E, $2F, $30, $31, $32, $35, $36,
      $38, $39, $3A, $3C,
      $00, $01, $02, $03, $04, $05, $08, $0C,
      $0D, $0E, $0F, $10, $11, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
      $30, $31, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $0E, $0F, $10, $11, $12, $13, $14, $15,
      $16, $17, $1A, $1B, $1D, $1E, $21, $22,
      $23, $24, $25, $26, $27, $2A, $2E, $2F,
      $30, $31, $32, $33,
      $00, $01, $03, $04, $05, $07, $08, $09,
      $0A, $0B, $0C, $0D, $10, $12, $14, $15,
      $16, $17, $18, $19, $1B, $1C, $1D, $1F,
      $20, $21, $23, $24, $25, $26, $27, $28,
      $29, $2C, $30, $31, $32, $33, $34, $35,
      $37, $38, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $0E, $0F, $10, $11, $12, $13, $14, $15,
      $16, $17, $18, $1B, $1C, $1E, $1F, $20,
      $22, $23, $24, $25, $26, $27, $28, $2B,
      $2D, $2F, $30, $31,
      $00, $01, $02, $05, $06, $08, $09, $0A,
      $0C, $0D, $0E, $0F, $10, $11, $12, $14,
      $15, $16, $17, $19, $1A, $1B, $1C, $1D,
      $1E, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A, $2B, $2C, $2D, $2E,
      $2F, $30, $00, $01, $02, $04, $05, $06,
      $07, $08, $09, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $27, $28, $29,
      $2A, $2B, $2C, $2D,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $16, $17, $19, $1A,
      $1B, $1D, $1E, $1F, $20, $21, $22, $23,
      $26, $28, $2A, $2B, $2C, $2D, $2E, $2F,
      $31, $32, $00, $02, $03, $04, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $13, $14, $15, $16, $17, $18,
      $1A, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $22, $23, $24, $25, $26, $27, $28, $29,
      $2A, $2B, $2C, $2D,
      $00, $01, $02, $03, $04, $05, $08, $09,
      $0B, $0C, $0D, $0F, $10, $11, $12, $13,
      $14, $15, $18, $1A, $1C, $1D, $1E, $1F,
      $20, $21, $23, $24, $25, $27, $28, $29,
      $2B, $2C, $2D, $2E, $2F, $30, $31, $33,
      $34, $35, $00, $01, $02, $03, $04, $05,
      $06, $07, $0A, $0B, $0D, $0E, $0F, $11,
      $12, $13, $14, $15, $16, $17, $1A, $1B,
      $1C, $1E, $1F, $20, $21, $22, $23, $24,
      $25, $26, $27, $28, $29, $2A, $2B, $2C,
      $2D, $2E, $2F, $30,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $11,
      $12, $14, $15, $16, $18, $19, $1A, $1B,
      $1C, $1D, $1E, $21, $23, $25, $26, $27,
      $28, $29, $2A, $2D, $2E, $30, $31, $32,
      $35, $36, $00, $01, $02, $03, $06, $0A,
      $0B, $0C, $0D, $0E, $0F, $12, $13, $15,
      $16, $17, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $22, $26, $27, $28, $29, $2A, $2B,
      $2D, $2E, $2F, $30, $31, $32, $33, $34,
      $35, $36, $37, $38,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $00, $01, $03, $04, $05, $07,
      $09, $0A, $0B, $0C, $0D, $10, $14, $15,
      $16, $17, $18, $19, $1C, $1D, $1F, $20,
      $21, $23, $24, $25, $26, $27, $28, $29,
      $2C, $2E, $30, $31, $32, $33, $34, $35,
      $37, $38, $39, $3B,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0F, $10,
      $11, $12, $13, $14, $15, $17, $18, $19,
      $1B, $1C, $1D, $1E, $1F, $20, $21, $22,
      $23, $24, $25, $26, $27, $28, $29, $2A,
      $2B, $2C, $00, $01, $02, $03, $04, $07,
      $08, $0A, $0B, $0C, $0E, $0F, $10, $11,
      $12, $13, $14, $17, $19, $1B, $1C, $1D,
      $1E, $20, $22, $23, $24, $26, $27, $28,
      $29, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $31, $32, $33, $34,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $25, $26, $27, $29, $2A,
      $2B, $2C, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0B, $0D, $0E, $0F,
      $10, $11, $12, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C,
      $00, $01, $04, $05, $07, $08, $09, $0B,
      $0C, $0D, $0E, $0F, $10, $11, $14, $16,
      $18, $19, $1A, $1B, $1C, $1D, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $31, $33, $00, $01, $02, $03, $04, $05,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $24, $25, $27, $28, $29,
      $2B, $2C, $2D, $2E,
      $00, $01, $02, $05, $06, $07, $09, $0A,
      $0B, $0C, $0D, $0E, $10, $11, $12, $14,
      $15, $16, $18, $19, $1A, $1B, $1C, $1D,
      $1E, $20, $21, $22, $23, $25, $26, $27,
      $28, $29, $2A, $2D, $2E, $30, $31, $34,
      $36, $37, $00, $01, $02, $05, $07, $08,
      $09, $0A, $0B, $0C, $0D, $0E, $10, $11,
      $12, $14, $15, $16, $18, $19, $1A, $1B,
      $1C, $1D, $1E, $21, $22, $23, $24, $25,
      $26, $27, $28, $29, $2A, $2D, $2E, $30,
      $31, $32, $34, $35,
      $00, $01, $02, $03, $04, $07, $09, $0B,
      $0C, $0D, $0E, $0F, $10, $14, $16, $17,
      $18, $1A, $1C, $1D, $1E, $1F, $20, $23,
      $27, $28, $29, $2B, $2C, $2F, $30, $32,
      $33, $34, $36, $37, $38, $39, $3A, $3B,
      $3C, $3F, $00, $01, $02, $03, $04, $05,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $14, $15, $16, $17,
      $18, $19, $1A, $1B, $1C, $1D, $1E, $1F,
      $20, $21, $22, $23, $24, $25, $26, $27,
      $28, $29, $2A, $2B,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $14, $15, $17, $18, $19, $1B,
      $1C, $1D, $1E, $1F, $20, $21, $24, $28,
      $29, $2A, $2B, $2C, $2D, $30, $31, $33,
      $34, $35, $00, $01, $02, $03, $04, $05,
      $06, $09, $0B, $0D, $0E, $0F, $10, $11,
      $12, $14, $15, $16, $18, $19, $1A, $1C,
      $1D, $1E, $1F, $20, $21, $22, $25, $26,
      $29, $2A, $2B, $2C, $2D, $2E, $30, $31,
      $32, $33, $34, $35,
      $00, $02, $03, $04, $05, $06, $07, $08,
      $09, $0B, $0D, $0E, $0F, $10, $11, $12,
      $13, $14, $17, $18, $1A, $1B, $1C, $1E,
      $1F, $20, $21, $22, $23, $24, $27, $29,
      $2B, $2C, $2D, $2E, $2F, $30, $32, $33,
      $34, $35, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $0E, $0F, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $09, $0A, $0B, $0D, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $22, $23, $25, $26, $27, $29, $2A, $2B,
      $2D, $2E, $00, $01, $02, $03, $04, $05,
      $07, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $13, $14, $16, $17, $1A, $1C, $1D,
      $1E, $1F, $20, $23, $25, $27, $28, $29,
      $2A, $2B, $2C, $2E, $2F, $30, $31, $32,
      $33, $34, $35, $36,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $00, $01, $02, $04, $05, $06,
      $08, $09, $0A, $0C, $0D, $0E, $0F, $10,
      $11, $12, $14, $15, $17, $18, $19, $1A,
      $1B, $1C, $1D, $1E, $20, $21, $22, $24,
      $25, $26, $28, $29, $2A, $2B, $2C, $2D,
      $2E, $30, $31, $33,
      $00, $01, $02, $03, $04, $05, $07, $08,
      $09, $0B, $0C, $0D, $0F, $10, $11, $12,
      $13, $14, $15, $18, $1A, $1B, $1C, $1D,
      $1E, $1F, $20, $21, $22, $23, $24, $25,
      $26, $27, $28, $29, $2A, $2B, $2C, $2D,
      $2E, $2F, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0C, $0D,
      $10, $11, $13, $14, $15, $17, $18, $19,
      $1A, $1B, $1C, $1D, $20, $22, $24, $25,
      $26, $27, $28, $29, $2C, $2D, $2F, $30,
      $31, $33, $34, $35,
      $00, $02, $03, $06, $08, $0A, $0B, $0C,
      $0D, $0E, $0F, $12, $13, $15, $16, $17,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $22,
      $26, $27, $28, $29, $2A, $2B, $2D, $2E,
      $2F, $30, $31, $32, $33, $34, $35, $36,
      $37, $38, $00, $01, $02, $03, $04, $05,
      $06, $07, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A,
      $00, $01, $03, $04, $05, $07, $09, $0A,
      $0B, $0C, $0D, $10, $12, $14, $15, $16,
      $17, $18, $19, $1C, $1D, $1F, $20, $21,
      $23, $24, $25, $26, $27, $28, $29, $2C,
      $2E, $30, $31, $32, $33, $34, $35, $38,
      $39, $3B, $00, $01, $03, $04, $05, $06,
      $07, $08, $09, $0C, $10, $11, $12, $13,
      $14, $15, $17, $18, $19, $1B, $1C, $1D,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $28, $29, $2A, $2B, $2C, $2D, $2E, $2F,
      $30, $31, $34, $35,
      $00, $01, $02, $04, $05, $06, $07, $09,
      $0A, $0D, $0F, $11, $12, $13, $15, $16,
      $19, $1A, $1C, $1D, $1E, $20, $21, $22,
      $23, $24, $25, $26, $27, $28, $29, $2B,
      $2D, $2E, $2F, $30, $31, $32, $35, $36,
      $38, $39, $00, $01, $02, $03, $04, $05,
      $06, $07, $08, $09, $0A, $0B, $0D, $0F,
      $10, $11, $12, $13, $14, $17, $18, $1A,
      $1B, $1C, $1E, $1F, $20, $21, $22, $23,
      $24, $25, $27, $29, $2B, $2C, $2D, $2E,
      $2F, $30, $32, $33,
      $00, $02, $03, $04, $06, $07, $08, $09,
      $0A, $0B, $0C, $0D, $0F, $11, $12, $13,
      $14, $15, $16, $17, $18, $1B, $1C, $1E,
      $1F, $20, $22, $23, $24, $25, $27, $28,
      $2A, $2B, $2D, $2F, $30, $31, $32, $33,
      $34, $36, $00, $01, $03, $04, $05, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0F, $10,
      $11, $12, $14, $15, $16, $17, $18, $19,
      $1C, $1D, $1F, $20, $21, $23, $24, $25,
      $26, $27, $28, $29, $2A, $2B, $2C, $2D,
      $2E, $30, $31, $32,
      $00, $01, $02, $05, $06, $08, $09, $0A,
      $0C, $0D, $0E, $0F, $10, $11, $12, $15,
      $17, $19, $1A, $1B, $1C, $1D, $1E, $21,
      $22, $24, $25, $26, $28, $29, $2A, $2B,
      $2C, $2D, $2E, $30, $31, $33, $35, $36,
      $37, $38, $00, $01, $04, $05, $07, $0C,
      $0D, $0E, $0F, $10, $11, $14, $16, $18,
      $19, $1A, $1C, $1D, $1F, $20, $21, $23,
      $24, $25, $27, $28, $29, $2A, $2B, $2C,
      $2D, $30, $31, $32, $34, $35, $36, $37,
      $38, $39, $3C, $3D,
      $00, $01, $02, $04, $05, $06, $07, $08,
      $09, $0A, $0D, $0F, $11, $12, $13, $14,
      $15, $16);
  UHC_2_1Map: array[0..63] of Word = (
      $AC02, $AC8D, $AD14, $AD91, $ADFA, $AE7A, $AEE6, $AF57,
      $AFBF, $B030, $B0A5, $B122, $B19E, $B207, $B26F, $B2F0,
      $B366, $B3E1, $B445, $B4AD, $B51E, $B590, $B600, $B661,
      $B6C3, $B723, $B79F, $B811, $B885, $B8F1, $B95A, $B9D4,
      $BA47, $BAC2, $BB28, $BB9A, $BC03, $BC80, $BCFE, $BD67,
      $BDD2, $BE3D, $BEB8, $BF23, $BF83, $BFE6, $C040, $C0A7,
      $C132, $C1B1, $C224, $C297, $C310, $C37A, $C3DB, $C446,
      $C4AA, $C50F, $C596, $C626, $C6A8, $C726, $C7B8, $C832);
  UHC_2_2Map: array[0..5695] of Byte = (
      $00, $01, $03, $04, $09, $0A, $0B, $0C,
      $0D, $16, $1C, $1D, $1F, $20, $21, $23,
      $24, $25, $26, $27, $28, $29, $2C, $30,
      $31, $32, $33, $34, $35, $38, $39, $3B,
      $3C, $3D, $3F, $40, $41, $42, $43, $44,
      $45, $46, $47, $48, $4A, $4C, $4D, $4E,
      $4F, $50, $51, $53, $54, $55, $57, $58,
      $59, $5B, $5C, $5D, $5E, $5F, $60, $61,
      $62, $63, $64, $65, $66, $67, $68, $69,
      $6A, $6B, $6C, $6D, $70, $71, $73, $74,
      $77, $79, $7A, $7B, $7C, $7D, $80, $85,
      $86, $00, $01, $02, $04, $05, $06, $08,
      $09, $0A, $0B, $0C, $0D, $0E, $11, $15,
      $16, $17, $18, $19, $1A, $1E, $20, $21,
      $24, $25, $26, $27, $28, $29, $2A, $2D,
      $31, $32, $33, $35, $36, $38, $39, $3A,
      $3C, $3D, $3E, $40, $41, $42, $43, $44,
      $45, $46, $47, $49, $4B, $4C, $4D, $4E,
      $4F, $50, $51, $52, $55, $56, $58, $59,
      $5C, $5E, $60, $61, $65, $67, $6A, $6B,
      $6C, $6D, $6E, $71, $72, $74, $75, $76,
      $78, $7A, $7B, $7C, $7D, $7E, $81, $83,
      $85, $86,
      $00, $01, $02, $03, $05, $06, $07, $09,
      $0A, $0B, $0D, $0E, $0F, $10, $11, $12,
      $13, $14, $16, $17, $1A, $1B, $1C, $1D,
      $1E, $1F, $22, $23, $25, $26, $27, $29,
      $2A, $2B, $2C, $2D, $2E, $2F, $32, $34,
      $36, $37, $38, $39, $3A, $3B, $3D, $3E,
      $3F, $41, $42, $43, $45, $46, $47, $48,
      $49, $4A, $4B, $4C, $4E, $50, $51, $52,
      $53, $54, $55, $56, $57, $5A, $5B, $5D,
      $5E, $63, $64, $65, $66, $6A, $6C, $6F,
      $70, $71, $72, $73, $76, $77, $79, $7A,
      $7B, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0A, $0D, $0E, $0F, $10,
      $11, $12, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $22, $23, $24, $25, $27, $28, $29, $2A,
      $2B, $2C, $2D, $2E, $31, $32, $34, $35,
      $36, $38, $39, $3A, $3B, $3C, $3D, $3E,
      $41, $43, $44, $45, $46, $47, $48, $49,
      $4A, $4C, $4D, $4E, $50, $51, $52, $54,
      $55, $56, $57, $58, $59, $5A, $5B, $5C,
      $5D, $5E, $5F, $60, $61, $62, $63, $64,
      $65, $66,
      $00, $01, $03, $04, $08, $09, $0A, $0B,
      $0C, $0D, $10, $12, $14, $15, $16, $17,
      $18, $19, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $31, $32, $33, $34, $35, $38, $39, $3B,
      $3C, $3F, $41, $42, $43, $44, $45, $48,
      $4A, $4D, $4E, $4F, $51, $55, $57, $58,
      $59, $5B, $5D, $5E, $5F, $60, $61, $64,
      $68, $69, $6A, $6C, $6D, $70, $71, $73,
      $74, $75, $77, $78, $79, $7A, $7B, $7C,
      $7D, $00, $04, $05, $06, $07, $08, $09,
      $0C, $0D, $0E, $0F, $10, $11, $13, $14,
      $15, $16, $17, $18, $19, $1A, $1B, $1C,
      $1D, $1E, $1F, $20, $21, $22, $23, $24,
      $25, $26, $27, $28, $29, $2A, $2B, $2C,
      $2D, $2E, $2F, $30, $31, $32, $33, $34,
      $35, $36, $37, $38, $39, $3A, $3B, $3C,
      $3D, $3E, $3F, $40, $41, $45, $47, $48,
      $49, $4B, $4C, $4D, $4E, $4F, $50, $51,
      $54, $58, $59, $5A, $5B, $5C, $5D, $60,
      $61, $63, $64, $65, $66, $67, $68, $69,
      $6A, $6B,
      $00, $01, $03, $04, $06, $08, $09, $0A,
      $0B, $0C, $0D, $0F, $10, $11, $13, $14,
      $15, $17, $18, $19, $1A, $1B, $1C, $1D,
      $1E, $1F, $20, $23, $24, $25, $26, $28,
      $29, $2B, $2C, $2D, $2E, $2F, $30, $31,
      $32, $33, $34, $35, $36, $37, $38, $39,
      $3A, $3B, $3C, $3D, $3E, $3F, $40, $41,
      $42, $43, $44, $45, $48, $49, $4B, $4D,
      $4F, $50, $51, $52, $53, $54, $55, $58,
      $5A, $5E, $5F, $60, $61, $64, $65, $66,
      $67, $68, $69, $6B, $6C, $6D, $6E, $6F,
      $70, $00, $01, $02, $03, $04, $07, $08,
      $09, $0A, $0B, $0C, $0F, $10, $11, $12,
      $13, $14, $15, $16, $17, $18, $19, $1A,
      $1B, $1C, $1D, $1E, $1F, $20, $21, $23,
      $24, $25, $26, $27, $28, $2A, $2B, $2C,
      $2E, $2F, $30, $32, $33, $34, $35, $36,
      $37, $38, $3B, $3C, $3D, $3F, $40, $41,
      $42, $43, $44, $46, $47, $48, $49, $4A,
      $4B, $4C, $4D, $4E, $4F, $50, $51, $52,
      $53, $54, $55, $56, $57, $58, $59, $5A,
      $5B, $5C, $5D, $5E, $5F, $60, $63, $64,
      $66, $67,
      $00, $02, $03, $04, $05, $06, $07, $0B,
      $0D, $10, $11, $12, $13, $14, $16, $17,
      $18, $19, $1A, $1B, $1C, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $2B, $2C, $2D, $2E, $2F, $30, $33, $34,
      $36, $37, $38, $3A, $3B, $3C, $3D, $3E,
      $3F, $40, $43, $44, $46, $47, $48, $49,
      $4A, $4B, $4C, $4E, $4F, $50, $52, $53,
      $54, $56, $57, $58, $59, $5A, $5B, $5C,
      $5F, $60, $61, $62, $63, $64, $65, $66,
      $67, $68, $6A, $6B, $6C, $6D, $6E, $6F,
      $70, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $16, $17, $19,
      $1B, $1D, $1F, $20, $21, $22, $26, $28,
      $2A, $2B, $2C, $2E, $2F, $30, $31, $32,
      $33, $34, $35, $36, $37, $38, $39, $3A,
      $3B, $3C, $3D, $3E, $3F, $40, $41, $42,
      $43, $44, $45, $46, $47, $48, $49, $4A,
      $4B, $4E, $4F, $51, $52, $53, $55, $56,
      $57, $58, $59, $5A, $5B, $5E, $60, $62,
      $63, $64, $65, $66, $67, $6B, $6D, $6E,
      $73, $74,
      $00, $01, $02, $05, $0B, $0D, $11, $12,
      $14, $15, $16, $18, $19, $1A, $1B, $1C,
      $1D, $1E, $21, $25, $26, $27, $28, $29,
      $2A, $2D, $2E, $30, $31, $32, $34, $35,
      $36, $37, $38, $39, $3A, $3C, $3D, $3E,
      $3F, $41, $42, $43, $44, $45, $46, $47,
      $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
      $50, $51, $52, $53, $54, $55, $56, $57,
      $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,
      $60, $61, $62, $65, $68, $69, $6A, $6C,
      $6F, $70, $71, $72, $75, $79, $7A, $7B,
      $7C, $00, $04, $05, $07, $08, $09, $0B,
      $0C, $0D, $0E, $0F, $10, $11, $14, $18,
      $19, $1A, $1B, $1C, $1D, $20, $21, $23,
      $24, $25, $27, $28, $29, $2A, $2B, $2C,
      $2D, $30, $31, $34, $35, $37, $38, $39,
      $3B, $3C, $3D, $3F, $40, $41, $42, $43,
      $44, $45, $46, $47, $48, $49, $4A, $4B,
      $4C, $4D, $4E, $4F, $50, $51, $52, $53,
      $54, $55, $58, $59, $5B, $5C, $5D, $5F,
      $61, $62, $63, $64, $65, $68, $6A, $6C,
      $6D, $6E, $6F, $73, $74, $75, $77, $78,
      $79, $7B,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2D, $2F, $30, $31,
      $33, $34, $35, $37, $38, $39, $3A, $3B,
      $3C, $3D, $40, $42, $43, $44, $45, $46,
      $47, $48, $49, $4C, $4D, $4F, $50, $51,
      $53, $54, $55, $56, $57, $58, $59, $5A,
      $5C, $5E, $60, $61, $62, $63, $64, $65,
      $68, $00, $02, $03, $06, $07, $08, $09,
      $0A, $0B, $0C, $0F, $11, $13, $14, $15,
      $16, $17, $18, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A, $2B, $2C, $2E, $2F,
      $30, $31, $32, $33, $34, $36, $37, $38,
      $39, $3A, $3B, $3C, $3D, $3E, $3F, $40,
      $41, $42, $43, $44, $45, $46, $47, $48,
      $49, $4A, $4B, $4C, $4D, $4E, $4F, $50,
      $52, $53, $54, $56, $57, $58, $5A, $5B,
      $5C, $5D, $5E, $5F, $60, $63, $64, $65,
      $66, $67,
      $00, $01, $02, $03, $04, $07, $08, $09,
      $0A, $0B, $0C, $0E, $0F, $10, $11, $12,
      $13, $14, $17, $18, $19, $1B, $1C, $1D,
      $1E, $1F, $20, $23, $24, $26, $27, $28,
      $2C, $2D, $2E, $2F, $30, $33, $35, $38,
      $39, $3A, $3C, $3E, $3F, $40, $42, $43,
      $44, $46, $47, $48, $49, $4A, $4B, $4C,
      $4D, $4E, $4F, $50, $51, $52, $53, $54,
      $55, $56, $57, $58, $5B, $5C, $5E, $5F,
      $60, $62, $64, $65, $66, $67, $68, $6B,
      $6D, $6F, $70, $71, $72, $74, $78, $7A,
      $7B, $00, $01, $02, $06, $0C, $0D, $0E,
      $12, $13, $15, $16, $17, $19, $1A, $1B,
      $1C, $1D, $1E, $1F, $22, $26, $27, $28,
      $29, $2A, $2B, $2D, $2E, $2F, $30, $31,
      $32, $33, $34, $35, $36, $37, $38, $39,
      $3A, $3B, $3C, $3D, $3E, $3F, $40, $41,
      $42, $43, $44, $45, $46, $47, $48, $49,
      $4A, $4B, $4C, $4D, $4E, $4F, $50, $51,
      $52, $53, $54, $55, $56, $57, $58, $59,
      $5A, $5B, $5C, $5D, $5E, $5F, $60, $61,
      $62, $63, $67, $69, $6A, $6D, $70, $71,
      $72, $73,
      $00, $02, $04, $06, $07, $09, $0C, $0D,
      $0F, $10, $11, $13, $14, $15, $16, $17,
      $18, $19, $1C, $20, $21, $22, $23, $24,
      $25, $27, $28, $29, $2B, $2C, $2D, $2F,
      $30, $31, $32, $33, $34, $35, $36, $37,
      $38, $39, $3C, $3D, $3E, $3F, $40, $41,
      $43, $44, $45, $47, $48, $49, $4A, $4B,
      $4C, $4D, $4E, $4F, $50, $51, $52, $53,
      $54, $55, $56, $57, $58, $59, $5A, $5B,
      $5C, $5D, $60, $61, $63, $64, $67, $69,
      $6B, $6C, $6D, $70, $72, $74, $76, $78,
      $79, $00, $01, $02, $04, $05, $06, $08,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1C, $1D, $1E, $1F, $20, $21,
      $22, $23, $24, $25, $26, $27, $28, $29,
      $2A, $2B, $2C, $2D, $2E, $30, $31, $32,
      $33, $34, $35, $36, $38, $39, $3A, $3C,
      $3D, $3E, $40, $41, $42, $43, $44, $45,
      $46, $49, $4B, $4C, $4D, $4E, $4F, $50,
      $51, $52, $54, $55, $56, $57, $58, $59,
      $5A, $5B, $5C, $5D, $5E, $5F, $60, $61,
      $62, $63,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0D, $0E, $10, $11, $12,
      $14, $15, $16, $17, $18, $19, $1A, $1D,
      $1F, $21, $22, $23, $24, $25, $26, $28,
      $29, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $31, $32, $33, $34, $35, $36, $37, $38,
      $39, $3A, $3C, $3D, $3E, $3F, $40, $41,
      $42, $44, $45, $46, $47, $48, $49, $4A,
      $4B, $4C, $4D, $4E, $4F, $50, $51, $52,
      $53, $54, $55, $56, $57, $59, $5A, $5B,
      $5C, $5D, $5E, $60, $61, $62, $64, $65,
      $66, $00, $01, $02, $03, $04, $05, $06,
      $07, $09, $0B, $0D, $0E, $0F, $10, $11,
      $12, $14, $15, $16, $18, $19, $1A, $1C,
      $1D, $1E, $1F, $20, $21, $22, $24, $25,
      $26, $27, $29, $2A, $2B, $2C, $2D, $2E,
      $31, $32, $34, $35, $38, $3A, $3B, $3C,
      $3D, $3E, $41, $43, $45, $46, $47, $48,
      $49, $4A, $4C, $4D, $4E, $4F, $50, $51,
      $52, $53, $54, $55, $56, $57, $58, $59,
      $5A, $5B, $5C, $5D, $5E, $5F, $60, $61,
      $62, $63, $64, $65, $66, $69, $6A, $6C,
      $6D, $70,
      $00, $01, $02, $03, $04, $05, $08, $0D,
      $0E, $0F, $10, $11, $14, $15, $17, $18,
      $19, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $24, $28, $29, $2A, $2B, $2C, $30, $31,
      $33, $34, $35, $37, $38, $39, $3A, $3B,
      $3C, $3D, $40, $44, $45, $46, $47, $48,
      $49, $4A, $4B, $4C, $4D, $4E, $4F, $50,
      $51, $52, $53, $54, $55, $56, $57, $58,
      $59, $5A, $5B, $5C, $5D, $5E, $5F, $60,
      $61, $62, $63, $64, $65, $66, $67, $68,
      $69, $6A, $6B, $6C, $6D, $6E, $6F, $70,
      $71, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $12, $13, $15, $16, $17, $19, $1C,
      $1D, $1E, $1F, $22, $26, $27, $28, $29,
      $2A, $2E, $2F, $31, $32, $33, $35, $36,
      $37, $38, $39, $3A, $3B, $3E, $42, $43,
      $44, $45, $46, $47, $49, $4A, $4B, $4C,
      $4D, $4E, $4F, $50, $51, $52, $53, $54,
      $55, $56, $57, $58, $59, $5A, $5B, $5D,
      $5E, $5F, $60, $61, $62, $63, $64, $65,
      $66, $67, $68, $69, $6A, $6B, $6C, $6D,
      $6E, $6F,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $12, $13, $15, $16, $17, $19, $1A, $1B,
      $1C, $1D, $1E, $1F, $20, $21, $22, $23,
      $24, $26, $27, $28, $29, $2A, $2B, $2D,
      $2E, $2F, $30, $31, $32, $33, $35, $36,
      $37, $38, $39, $3A, $3B, $3C, $3D, $3E,
      $3F, $40, $41, $42, $43, $44, $45, $46,
      $47, $49, $4A, $4B, $4C, $4D, $4E, $4F,
      $50, $51, $52, $53, $54, $55, $56, $57,
      $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,
      $60, $00, $01, $02, $04, $05, $06, $08,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $31, $32, $33, $34, $35, $36, $37, $38,
      $39, $3A, $3D, $3E, $40, $41, $42, $44,
      $45, $46, $47, $48, $49, $4C, $4D, $4E,
      $4F, $51, $52, $53, $54, $55, $56, $57,
      $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,
      $60, $61,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2E, $2F, $30, $32,
      $33, $34, $36, $37, $38, $39, $3A, $3B,
      $3C, $3F, $40, $41, $43, $44, $45, $46,
      $47, $48, $49, $4A, $4B, $4C, $4D, $4E,
      $4F, $50, $51, $52, $53, $54, $55, $56,
      $57, $58, $59, $5A, $5B, $5C, $5D, $5E,
      $5F, $00, $01, $02, $03, $04, $07, $08,
      $0A, $0B, $0E, $0F, $10, $11, $12, $13,
      $14, $17, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $22, $23, $24, $26, $27, $28,
      $2A, $2B, $2C, $2D, $2E, $2F, $30, $33,
      $34, $35, $36, $37, $38, $39, $3A, $3B,
      $3C, $3E, $3F, $40, $42, $43, $44, $46,
      $47, $48, $49, $4A, $4B, $4C, $4F, $51,
      $53, $54, $55, $56, $57, $58, $5B, $5C,
      $5E, $5F, $60, $62, $63, $64, $65, $66,
      $67, $68, $6B, $70, $71, $72, $77, $78,
      $7A, $7B,
      $00, $02, $03, $04, $05, $06, $07, $08,
      $0B, $0F, $10, $11, $12, $13, $14, $17,
      $18, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $29,
      $2B, $2C, $2D, $2E, $2F, $30, $31, $32,
      $33, $34, $35, $36, $37, $38, $39, $3A,
      $3B, $3C, $3D, $3E, $3F, $40, $41, $42,
      $43, $44, $45, $46, $47, $48, $49, $4A,
      $4B, $4C, $4F, $50, $52, $53, $54, $56,
      $57, $58, $59, $5A, $5B, $5C, $5F, $63,
      $64, $65, $66, $67, $6B, $6C, $6E, $6F,
      $70, $00, $01, $02, $03, $04, $05, $06,
      $09, $0B, $0D, $0E, $0F, $10, $11, $12,
      $15, $16, $18, $19, $1A, $1C, $1D, $1E,
      $1F, $20, $21, $22, $25, $29, $2A, $2B,
      $2C, $2D, $2E, $30, $31, $32, $34, $35,
      $36, $37, $38, $39, $3A, $3B, $3C, $3D,
      $3E, $3F, $41, $43, $44, $45, $46, $47,
      $48, $49, $4A, $4D, $4E, $50, $51, $52,
      $54, $55, $56, $57, $58, $59, $5A, $5D,
      $5F, $61, $62, $63, $64, $65, $66, $68,
      $69, $6A, $6C, $6D, $6E, $6F, $70, $71,
      $72, $73,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $24, $25, $26, $27, $28, $29,
      $2A, $2C, $2D, $2E, $30, $31, $32, $34,
      $35, $36, $37, $38, $39, $3A, $3D, $3F,
      $41, $42, $43, $44, $45, $46, $48, $49,
      $4A, $4C, $4D, $4E, $50, $51, $52, $53,
      $54, $55, $56, $57, $59, $5B, $5D, $5E,
      $5F, $60, $61, $62, $65, $66, $68, $69,
      $6A, $00, $01, $02, $03, $04, $05, $06,
      $09, $0B, $0D, $0E, $0F, $10, $11, $12,
      $14, $15, $16, $17, $18, $19, $1A, $1B,
      $1C, $1D, $1E, $1F, $20, $21, $22, $23,
      $24, $25, $26, $28, $29, $2A, $2B, $2C,
      $2D, $2E, $30, $31, $32, $33, $34, $35,
      $36, $37, $38, $39, $3A, $3B, $3C, $3D,
      $3E, $3F, $40, $41, $42, $43, $44, $45,
      $46, $47, $48, $49, $4A, $4D, $4E, $50,
      $51, $52, $54, $55, $56, $57, $58, $59,
      $5A, $5C, $5D, $5F, $61, $62, $63, $64,
      $65, $66,
      $00, $01, $03, $04, $05, $07, $08, $09,
      $0A, $0B, $0C, $0D, $10, $12, $14, $15,
      $16, $17, $18, $19, $1C, $1D, $1F, $20,
      $21, $23, $24, $25, $26, $27, $28, $29,
      $2C, $2E, $31, $32, $35, $36, $37, $38,
      $39, $3A, $3B, $3C, $3D, $3E, $3F, $40,
      $41, $42, $43, $44, $45, $46, $47, $48,
      $49, $4A, $4B, $4C, $4D, $4E, $4F, $50,
      $51, $54, $55, $57, $58, $59, $5B, $5C,
      $5D, $5E, $5F, $60, $61, $64, $66, $68,
      $69, $6A, $6B, $6C, $6D, $70, $71, $73,
      $79, $00, $01, $02, $03, $06, $08, $0B,
      $0C, $0E, $12, $13, $15, $16, $17, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $22, $27,
      $28, $29, $2A, $2B, $2E, $2F, $30, $31,
      $32, $33, $35, $36, $37, $38, $39, $3A,
      $3B, $3C, $3D, $3E, $3F, $40, $42, $43,
      $44, $45, $46, $47, $48, $49, $4A, $4B,
      $4C, $4D, $4E, $4F, $50, $51, $52, $53,
      $54, $55, $56, $57, $58, $59, $5A, $5B,
      $5C, $5D, $5E, $5F, $60, $61, $62, $63,
      $66, $67, $69, $6A, $6B, $6D, $6F, $70,
      $71, $72,
      $00, $03, $05, $08, $09, $0A, $0B, $0F,
      $10, $12, $13, $14, $16, $17, $18, $19,
      $1A, $1B, $1C, $1F, $23, $24, $25, $26,
      $27, $28, $2B, $2C, $2E, $2F, $30, $32,
      $33, $34, $35, $36, $37, $38, $39, $3A,
      $3B, $3F, $41, $42, $43, $44, $46, $47,
      $48, $49, $4A, $4B, $4C, $4D, $4E, $4F,
      $50, $51, $52, $53, $54, $55, $56, $57,
      $58, $59, $5A, $5B, $5C, $5D, $5E, $5F,
      $60, $63, $66, $67, $68, $6A, $6C, $6D,
      $6E, $6F, $70, $73, $75, $77, $78, $79,
      $7A, $00, $01, $03, $04, $05, $07, $08,
      $09, $0A, $0B, $0C, $0D, $0E, $0F, $10,
      $11, $12, $13, $14, $15, $18, $19, $1A,
      $1B, $1C, $1D, $1E, $1F, $20, $21, $22,
      $23, $24, $25, $26, $27, $28, $29, $2A,
      $2B, $2C, $2D, $2E, $2F, $30, $31, $32,
      $33, $34, $35, $36, $37, $38, $39, $3B,
      $3C, $3D, $3F, $40, $41, $43, $44, $45,
      $46, $47, $48, $49, $4A, $4C, $4E, $50,
      $51, $52, $53, $54, $55, $57, $58, $59,
      $5B, $5C, $5D, $5F, $60, $61, $62, $63,
      $64, $65,
      $00, $02, $04, $05, $06, $07, $08, $09,
      $0A, $0B, $0F, $11, $12, $17, $18, $19,
      $1A, $1B, $1E, $20, $22, $23, $24, $26,
      $29, $2A, $2B, $2D, $2E, $2F, $31, $32,
      $33, $34, $35, $36, $37, $38, $3A, $3C,
      $3D, $3E, $3F, $40, $41, $42, $43, $45,
      $46, $47, $48, $49, $4A, $4B, $4C, $4D,
      $4E, $4F, $50, $51, $52, $53, $54, $55,
      $56, $57, $58, $59, $5A, $5B, $5C, $5D,
      $5E, $5F, $61, $62, $63, $65, $66, $67,
      $69, $6A, $6B, $6C, $6D, $6E, $6F, $70,
      $71, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0B, $0C, $0D, $0F, $10,
      $11, $13, $14, $15, $16, $17, $18, $19,
      $1B, $1C, $1E, $1F, $20, $21, $22, $23,
      $24, $25, $27, $28, $29, $2B, $2C, $2D,
      $2F, $30, $31, $32, $33, $34, $35, $37,
      $38, $3A, $3B, $3C, $3D, $3E, $3F, $40,
      $41, $42, $43, $44, $45, $46, $47, $48,
      $49, $4A, $4B, $4C, $4D, $4E, $4F, $50,
      $51, $52, $53, $54, $55, $56, $57, $58,
      $59, $5A, $5B, $5C, $5D, $60, $61, $63,
      $64, $67,
      $00, $01, $02, $03, $04, $07, $0B, $0D,
      $0F, $10, $16, $17, $1D, $1E, $1F, $20,
      $23, $25, $27, $28, $29, $2B, $2C, $2F,
      $30, $32, $33, $34, $36, $37, $38, $39,
      $3A, $3B, $3C, $3F, $43, $44, $45, $47,
      $48, $4B, $4C, $4E, $4F, $50, $51, $52,
      $53, $54, $55, $56, $57, $58, $59, $5B,
      $5C, $5D, $5E, $5F, $60, $61, $62, $63,
      $64, $65, $66, $67, $68, $69, $6A, $6B,
      $6C, $6D, $6E, $6F, $70, $71, $72, $73,
      $74, $75, $76, $77, $78, $79, $7A, $7B,
      $7C, $00, $01, $02, $03, $06, $07, $09,
      $0A, $0D, $0F, $10, $11, $12, $13, $16,
      $18, $1B, $1C, $1D, $1E, $1F, $22, $23,
      $25, $26, $29, $2A, $2B, $2C, $2D, $2E,
      $2F, $32, $36, $37, $38, $39, $3A, $3B,
      $3E, $3F, $41, $42, $43, $45, $46, $47,
      $48, $49, $4A, $4B, $4C, $4E, $52, $53,
      $54, $56, $57, $59, $5A, $5B, $5D, $5E,
      $5F, $60, $61, $62, $63, $64, $65, $66,
      $67, $68, $69, $6A, $6B, $6C, $6D, $6E,
      $6F, $70, $71, $72, $73, $77, $79, $7A,
      $7B, $7D,
      $00, $01, $02, $03, $04, $05, $08, $0A,
      $0C, $0D, $0E, $0F, $10, $11, $13, $14,
      $15, $17, $18, $19, $1A, $1B, $1C, $1D,
      $1E, $1F, $20, $21, $22, $23, $24, $25,
      $27, $28, $29, $2A, $2B, $2C, $2D, $2F,
      $30, $31, $32, $33, $34, $35, $36, $37,
      $38, $39, $3A, $3B, $3C, $3D, $3E, $3F,
      $40, $41, $43, $44, $45, $46, $47, $48,
      $49, $4C, $4D, $4F, $50, $51, $53, $54,
      $55, $56, $57, $58, $59, $5C, $5D, $5E,
      $5F, $60, $61, $62, $63, $64, $65, $67,
      $68, $00, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $14, $15, $16, $17,
      $18, $1B, $1C, $1E, $1F, $24, $25, $26,
      $27, $28, $2B, $2D, $2F, $30, $31, $34,
      $36, $37, $38, $39, $3A, $3B, $3C, $3E,
      $3F, $40, $41, $42, $43, $44, $45, $46,
      $47, $48, $4A, $4B, $4C, $4D, $4E, $4F,
      $50, $52, $53, $54, $55, $56, $57, $58,
      $59, $5A, $5B, $5C, $5D, $5E, $5F, $60,
      $61, $62, $63, $64, $65, $66, $67, $68,
      $69, $6A,
      $00, $01, $04, $05, $07, $08, $09, $0B,
      $0C, $0D, $0E, $0F, $10, $11, $12, $13,
      $14, $15, $16, $18, $19, $1A, $1B, $1C,
      $1D, $1F, $20, $21, $23, $24, $25, $27,
      $28, $29, $2A, $2B, $2C, $2D, $2F, $30,
      $32, $34, $35, $36, $37, $38, $39, $3C,
      $3D, $3F, $40, $41, $43, $44, $45, $46,
      $47, $48, $49, $4C, $4E, $4F, $50, $51,
      $52, $53, $54, $55, $56, $57, $58, $59,
      $5A, $5B, $5C, $5D, $5E, $5F, $60, $61,
      $62, $63, $64, $65, $66, $67, $68, $69,
      $6A, $00, $01, $02, $03, $04, $05, $06,
      $09, $0A, $0C, $0D, $0E, $10, $12, $13,
      $14, $15, $16, $19, $1B, $1F, $20, $21,
      $22, $25, $26, $28, $29, $2A, $2C, $2E,
      $2F, $30, $31, $32, $35, $39, $3A, $3B,
      $3C, $3D, $41, $42, $44, $45, $46, $48,
      $49, $4A, $4B, $4C, $4D, $4E, $51, $55,
      $56, $57, $58, $59, $5A, $5D, $5E, $5F,
      $60, $61, $62, $63, $64, $65, $66, $67,
      $68, $69, $6A, $6C, $6D, $6E, $6F, $70,
      $71, $72, $73, $74, $75, $76, $77, $78,
      $79, $7A,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $14, $15, $16, $17,
      $1A, $1B, $1D, $1E, $21, $22, $23, $24,
      $25, $26, $27, $29, $2A, $2E, $2F, $30,
      $31, $32, $33, $35, $36, $37, $38, $39,
      $3A, $3B, $3C, $3D, $3E, $3F, $40, $41,
      $42, $43, $44, $45, $46, $47, $48, $4A,
      $4B, $4C, $4D, $4E, $4F, $52, $53, $54,
      $55, $56, $57, $58, $59, $5A, $5B, $5C,
      $5D, $5E, $5F, $62, $66, $67, $68, $69,
      $6A, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1F, $20,
      $22, $23, $24, $26, $27, $28, $29, $2A,
      $2B, $2C, $2F, $30, $31, $33, $34, $35,
      $36, $37, $38, $39, $3A, $3B, $3C, $3D,
      $3E, $3F, $40, $41, $42, $43, $44, $45,
      $46, $47, $48, $49, $4A, $4B, $4C, $4D,
      $4E, $4F, $50, $51, $52, $53, $54, $55,
      $56, $57, $58, $59, $5A, $5B, $5C, $5D,
      $5E, $5F,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $12, $13, $14, $15, $16, $17, $18,
      $19, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2E, $2F, $30, $31,
      $32, $33, $34, $35, $36, $37, $38, $39,
      $3A, $3B, $3C, $3D, $3E, $3F, $40, $41,
      $43, $44, $45, $46, $47, $48, $4B, $4C,
      $4E, $4F, $50, $52, $53, $54, $55, $56,
      $57, $58, $5A, $5B, $5D, $5F, $60, $61,
      $62, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0C, $0D, $0E,
      $0F, $10, $11, $12, $13, $14, $15, $16,
      $17, $18, $19, $1A, $1B, $1C, $1D, $1E,
      $1F, $20, $21, $22, $23, $24, $25, $26,
      $27, $28, $29, $2A, $2B, $2C, $2D, $2E,
      $2F, $30, $31, $32, $33, $34, $35, $36,
      $37, $38, $39, $3A, $3B, $3C, $3D, $3E,
      $3F, $40, $41, $42, $43, $44, $45, $46,
      $47, $48, $49, $4A, $4B, $4C, $4D, $4E,
      $4F, $50, $51, $52, $53, $54, $55, $57,
      $58, $59,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $12, $13, $14, $15, $16, $17, $19,
      $1A, $1B, $1D, $1E, $1F, $21, $22, $23,
      $24, $25, $26, $27, $2A, $2B, $2C, $2D,
      $2E, $2F, $30, $31, $32, $33, $34, $35,
      $36, $37, $38, $39, $3A, $3B, $3C, $3D,
      $3E, $3F, $40, $41, $42, $43, $44, $45,
      $46, $47, $48, $49, $4A, $4B, $4C, $4D,
      $4E, $4F, $52, $53, $55, $56, $57, $59,
      $5A, $5B, $5C, $5D, $5E, $5F, $62, $64,
      $66, $00, $01, $02, $03, $04, $07, $0A,
      $0B, $10, $11, $12, $13, $14, $17, $1B,
      $1C, $1D, $1F, $20, $23, $24, $26, $27,
      $28, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $33, $37, $38, $39, $3A, $3B, $3C, $3F,
      $40, $42, $43, $44, $46, $47, $48, $49,
      $4A, $4B, $4C, $4F, $51, $53, $54, $55,
      $56, $57, $58, $5A, $5B, $5C, $5E, $5F,
      $60, $62, $63, $64, $65, $66, $67, $68,
      $6A, $6B, $6C, $6D, $6F, $70, $71, $72,
      $73, $74, $7A, $7B, $7E, $81, $82, $83,
      $84, $87,
      $00, $01, $02, $03, $05, $08, $09, $0B,
      $0C, $0D, $0F, $10, $11, $12, $13, $14,
      $15, $18, $1C, $1D, $1E, $1F, $20, $21,
      $24, $25, $27, $28, $29, $2B, $2C, $2D,
      $2E, $2F, $30, $31, $34, $38, $39, $3A,
      $3B, $3C, $3D, $3F, $40, $41, $43, $44,
      $45, $47, $48, $49, $4A, $4B, $4C, $4D,
      $4E, $4F, $50, $51, $52, $54, $55, $56,
      $57, $58, $59, $5D, $5F, $60, $61, $63,
      $65, $66, $67, $68, $69, $6C, $6E, $70,
      $71, $72, $74, $75, $78, $79, $7B, $7C,
      $7D, $00, $01, $02, $03, $04, $05, $06,
      $07, $08, $09, $0A, $0B, $0D, $0E, $0F,
      $10, $11, $12, $14, $15, $16, $18, $19,
      $1A, $1C, $1D, $1E, $1F, $20, $21, $22,
      $24, $25, $28, $29, $2A, $2B, $2C, $2D,
      $2E, $30, $31, $32, $34, $35, $36, $38,
      $39, $3A, $3B, $3C, $3D, $3E, $41, $43,
      $44, $45, $46, $47, $48, $49, $4A, $4D,
      $4E, $50, $51, $52, $54, $55, $56, $57,
      $58, $59, $5A, $5D, $5F, $61, $62, $63,
      $64, $65, $66, $69, $6A, $6C, $6D, $70,
      $71, $72,
      $00, $01, $02, $03, $06, $08, $0A, $0C,
      $0F, $11, $12, $13, $14, $15, $16, $17,
      $18, $19, $1A, $1B, $1C, $1D, $1E, $1F,
      $20, $21, $22, $23, $25, $26, $27, $28,
      $29, $2A, $2B, $2E, $2F, $31, $32, $33,
      $35, $36, $37, $38, $39, $3A, $3B, $3D,
      $3E, $3F, $40, $42, $43, $44, $45, $46,
      $47, $4A, $4B, $4D, $4E, $4F, $51, $52,
      $53, $54, $55, $56, $57, $5A, $5C, $5E,
      $5F, $60, $61, $62, $63, $66, $67, $68,
      $69, $6A, $6B, $6D, $6E, $6F, $70, $71,
      $72, $00, $02, $03, $05, $07, $08, $09,
      $0A, $0B, $0C, $0F, $10, $12, $13, $14,
      $17, $18, $19, $1A, $1B, $1C, $1F, $21,
      $23, $24, $25, $26, $27, $28, $29, $2A,
      $2B, $2C, $2D, $2E, $2F, $30, $31, $32,
      $33, $34, $35, $36, $37, $38, $39, $3A,
      $3B, $3C, $3D, $3E, $3F, $40, $41, $42,
      $43, $44, $47, $48, $4A, $4B, $4E, $4F,
      $50, $51, $52, $53, $57, $59, $5B, $5C,
      $5D, $5E, $60, $63, $66, $67, $68, $6A,
      $6B, $6C, $6D, $6E, $6F, $70, $73, $74,
      $77, $78,
      $00, $01, $02, $06, $07, $09, $0A, $0B,
      $0D, $0E, $0F, $10, $11, $12, $13, $16,
      $17, $1A, $1B, $1C, $1D, $1E, $1F, $20,
      $21, $22, $23, $24, $25, $26, $27, $28,
      $29, $2A, $2B, $2C, $2D, $2E, $2F, $30,
      $31, $32, $33, $34, $36, $37, $38, $39,
      $3A, $3B, $3C, $3D, $3E, $3F, $40, $41,
      $42, $43, $44, $45, $46, $47, $48, $49,
      $4A, $4B, $4C, $4D, $4E, $4F, $50, $51,
      $52, $53, $54, $55, $56, $57, $5A, $5B,
      $5D, $5E, $5F, $61, $63, $64, $65, $66,
      $67, $00, $01, $04, $05, $06, $07, $08,
      $09, $0B, $0C, $0D, $0F, $10, $11, $13,
      $14, $15, $16, $17, $18, $19, $1A, $1B,
      $1C, $1D, $1E, $1F, $20, $21, $22, $23,
      $24, $25, $26, $27, $28, $29, $2A, $2B,
      $2C, $2D, $2E, $2F, $30, $31, $32, $33,
      $34, $35, $36, $37, $38, $39, $3A, $3B,
      $3C, $3D, $3E, $3F, $40, $41, $42, $43,
      $44, $45, $47, $48, $49, $4A, $4B, $4C,
      $4D, $4E, $4F, $50, $51, $52, $53, $54,
      $55, $56, $57, $58, $59, $5A, $5B, $5C,
      $5D, $60,
      $00, $02, $03, $06, $08, $09, $0A, $0B,
      $0C, $0F, $10, $11, $13, $14, $15, $16,
      $17, $18, $1B, $1C, $1E, $1F, $20, $21,
      $22, $23, $24, $25, $26, $27, $28, $29,
      $2A, $2B, $2C, $2E, $2F, $30, $31, $32,
      $33, $34, $36, $37, $38, $39, $3A, $3B,
      $3C, $3D, $3E, $3F, $40, $41, $42, $43,
      $44, $45, $46, $47, $48, $4A, $4B, $4C,
      $4D, $4E, $4F, $50, $52, $53, $54, $56,
      $57, $58, $5A, $5B, $5C, $5D, $5E, $5F,
      $60, $63, $64, $65, $66, $67, $68, $69,
      $6A, $00, $01, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0E, $0F,
      $10, $11, $12, $13, $14, $15, $16, $17,
      $18, $19, $1A, $1B, $1C, $1D, $20, $21,
      $23, $24, $25, $27, $28, $29, $2A, $2B,
      $2C, $2D, $30, $31, $32, $34, $35, $36,
      $37, $38, $39, $3B, $3C, $3D, $3E, $3F,
      $40, $41, $42, $43, $44, $45, $46, $47,
      $48, $49, $4A, $4B, $4C, $4D, $4F, $50,
      $51, $52, $53, $54, $55, $57, $58, $59,
      $5A, $5B, $5C, $5D, $5E, $5F, $60, $61,
      $62, $63,
      $00, $01, $02, $03, $04, $05, $06, $07,
      $08, $09, $0A, $0B, $0C, $0D, $0F, $10,
      $11, $13, $14, $15, $16, $17, $18, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $20, $21,
      $22, $23, $24, $25, $26, $27, $28, $29,
      $2A, $2B, $2C, $2D, $2E, $2F, $30, $31,
      $32, $33, $34, $35, $36, $37, $38, $39,
      $3A, $3B, $3C, $3D, $3E, $40, $41, $42,
      $43, $44, $45, $48, $49, $4B, $4C, $4D,
      $4F, $51, $52, $53, $54, $58, $59, $5A,
      $5B, $5C, $5D, $5E, $5F, $60, $61, $63,
      $64, $00, $02, $03, $04, $06, $07, $08,
      $09, $0A, $0B, $0C, $0E, $0F, $10, $11,
      $12, $13, $14, $15, $16, $17, $18, $1B,
      $1C, $1E, $1F, $20, $22, $23, $24, $25,
      $26, $27, $28, $2B, $2D, $2F, $30, $31,
      $32, $33, $34, $37, $38, $3C, $40, $41,
      $42, $43, $47, $4B, $4C, $4D, $50, $53,
      $54, $56, $57, $58, $5A, $5B, $5C, $5D,
      $5E, $5F, $60, $63, $67, $68, $69, $6A,
      $6B, $6C, $6F, $70, $72, $73, $74, $76,
      $77, $79, $7A, $7B, $7C, $7F, $81, $83,
      $84, $85,
      $00, $03, $04, $05, $07, $08, $09, $0B,
      $0C, $0D, $0E, $0F, $10, $11, $12, $14,
      $15, $16, $17, $18, $19, $1A, $1B, $1C,
      $1D, $20, $21, $24, $29, $2A, $2B, $2C,
      $2D, $35, $37, $39, $3C, $3D, $3F, $40,
      $41, $43, $44, $45, $46, $47, $48, $49,
      $4C, $4E, $50, $51, $52, $53, $54, $55,
      $59, $5B, $5C, $5D, $5F, $62, $63, $64,
      $65, $6C, $6D, $6E, $73, $74, $75, $77,
      $78, $79, $7B, $7C, $7D, $7E, $7F, $80,
      $81, $84, $87, $88, $89, $8A, $8B, $8C,
      $8D, $00, $01, $03, $04, $05, $09, $0B,
      $0C, $10, $12, $14, $16, $17, $18, $19,
      $1C, $1D, $1F, $20, $21, $23, $24, $25,
      $26, $27, $28, $29, $2C, $30, $31, $32,
      $33, $34, $35, $38, $39, $3B, $3C, $3D,
      $3E, $3F, $40, $41, $42, $43, $44, $45,
      $47, $48, $4A, $4C, $4D, $4E, $4F, $50,
      $51, $54, $55, $57, $58, $59, $5B, $5C,
      $5D, $5E, $5F, $60, $61, $64, $66, $68,
      $69, $6A, $6B, $6C, $6D, $70, $71, $73,
      $74, $75, $77, $78, $79, $7A, $7B, $7C,
      $7D, $80,
      $00, $02, $03, $04, $05, $06, $07, $0A,
      $0B, $0D, $0E, $0F, $13, $14, $15, $16,
      $17, $1A, $1C, $1E, $1F, $20, $21, $22,
      $23, $26, $27, $29, $2A, $2B, $2D, $2E,
      $2F, $30, $31, $32, $33, $36, $37, $3A,
      $3B, $3C, $3D, $3E, $3F, $42, $43, $45,
      $46, $47, $49, $4A, $4B, $4C, $4D, $4E,
      $4F, $52, $53, $54, $56, $57, $58, $59,
      $5A, $5B, $5E, $5F, $61, $62, $63, $65,
      $66, $67, $68, $69, $6A, $6B, $6E, $70,
      $72, $73, $74, $75, $76, $77, $7A, $7B,
      $7D, $00, $01, $03, $04, $05, $06, $07,
      $08, $09, $0C, $0E, $10, $12, $13, $14,
      $15, $18, $19, $1B, $1C, $1D, $1F, $20,
      $21, $22, $23, $25, $28, $2A, $33, $34,
      $35, $37, $38, $39, $3B, $3C, $3D, $3E,
      $3F, $40, $41, $43, $44, $46, $47, $48,
      $49, $4A, $4B, $4C, $4D, $50, $51, $53,
      $54, $55, $59, $5A, $5B, $5C, $60, $65,
      $66, $67, $69, $6C, $6D, $6F, $73, $75,
      $76, $77, $78, $79, $7C, $81, $82, $83,
      $84, $85, $88, $89, $8B, $8C, $8D, $8F,
      $90, $91,
      $00, $01, $02, $03, $06, $0A, $0B, $0C,
      $0D, $0E, $0F, $12, $13, $15, $17, $19,
      $1A, $1B, $1C, $1D, $1E, $1F, $21, $22,
      $23, $24, $26, $27, $28, $29, $2A, $2B,
      $2D, $2E, $2F, $31, $32, $33, $35, $36,
      $37, $38, $39, $3A, $3B, $3C, $3D, $3E,
      $3F, $40, $41, $42, $43, $44, $45, $46,
      $47, $4A, $4B, $4D, $4E, $4F, $51, $53,
      $54, $55, $56, $57, $5A, $5C, $5F, $60,
      $61, $62, $63, $66, $67, $69, $6A, $6B,
      $6D, $6E, $6F, $70, $71, $72, $73, $76,
      $78, $00, $01, $02, $03, $04, $05, $07,
      $08, $09, $0B, $0C, $0D, $0F, $10, $11,
      $12, $13, $14, $15, $18, $19, $1C, $1D,
      $1E, $1F, $20, $21, $23, $24, $25, $26,
      $27, $28, $29, $2A, $2B, $2C, $2D, $2E,
      $2F, $30, $31, $32, $33, $34, $35, $36,
      $37, $38, $39, $3A, $3B, $3C, $3D, $40,
      $41, $43, $44, $45, $47, $49, $4A, $4B,
      $4C, $4D, $50, $52, $56, $57, $58, $5C,
      $5D, $5E, $5F, $60, $61, $63, $64, $65,
      $66, $67, $68, $69, $6A, $6C, $6E, $70,
      $71, $72);
  GB18030Ext_2uni_pagea9: array [0..12] of TBuffChar = (
    // $a9
    #$303e, #$2ff0, #$2ff1, #$2ff2, #$2ff3, #$2ff4, #$2ff5, #$2ff6,
    #$2ff7, #$2ff8, #$2ff9, #$2ffa, #$2ffb
  );
  GB18030Ext_2uni_pagefe: array[0..94] of TBuffChar = (
    // #$fe
    #$fffd, #$fffd, #$fffd, #$fffd, #$fffd, #$fffd, #$fffd, #$fffd,
    #$fffd, #$fffd, #$fffd, #$fffd, #$fffd, #$fffd, #$fffd, #$fffd,
    #$2e81, #$fffd, #$fffd, #$fffd, #$2e84, #$3473, #$3447, #$2e88,
    #$2e8b, #$fffd, #$359e, #$361a, #$360e, #$2e8c, #$2e97, #$396e,
    #$3918, #$fffd, #$39cf, #$39df, #$3a73, #$39d0, #$fffd, #$fffd,
    #$3b4e, #$3c6e, #$3ce0, #$2ea7, #$fffd, #$fffd, #$2eaa, #$4056,
    #$415f, #$2eae, #$4337, #$2eb3, #$2eb6, #$2eb7, #$fffd, #$43b1,
    #$43ac, #$2ebb, #$43dd, #$44d6, #$4661, #$464c, #$fffd, #$4723,
    #$4729, #$477c, #$478d, #$2eca, #$4947, #$497a, #$497d, #$4982,
    #$4983, #$4985, #$4986, #$499f, #$499b, #$49b7, #$49b6, #$fffd,
    #$fffd, #$4ca3, #$4c9f, #$4ca0, #$4ca1, #$4c77, #$4ca2, #$4d13,
    #$4d14, #$4d15, #$4d16, #$4d17, #$4d18, #$4d19, #$4dae
  );

  GB18030Uni_ranges: array [0..193] of Integer = (
      128,   129,   131,   133,   134,   135,   137,   140,
      142,   144,   145,   147,   148,   149,   150,   151,
      152,   153,   154,   155,   156,   157,   158,   159,
      160,   161,   162,   163,   164,   165,   166,   167,
      168,   171,   172,   189,   196,   213,   220,   221,
      285,   286,   287,   291,   293,   295,   297,   298,
      300,   301,   302,   303,   304,   305,   306,   307,
      308,   320,   330,   334,   338,   339,   340,   341,
      342,   343,   347,   348,   349,   354,   355,   359,
      360,   361,   362,   363,   365,   369,   371,   372,
      373,   374,   375,   376,   386,   426,   502,   538,
      553,   556,   558,   560,   562,   564,   565,   567,
      571,   573,   574,   575,   576,   577,   578,   579,
      581,   582,   583,   584,   585,   586,   588,   589,
      590,   602,   606,   625,   627,   636,   637,   720,
      724,   810,   813,   850,   860,   861,   862,   864,
      867,   868,   869,   870,   872,   873,   874,   875,
      876,   877,   878,   879,   880,   882,   883,   884,
      885,   886,   887,   888,   889,   890,   891,   892,
      893,   894,   895,   896,   897,   898,   899,   900,
      901,   902,   903,   905,   907,   908,   909,   911,
      912,   917,   924,   925, 21827, 25943, 25944, 25945,
    25946, 25947, 25948, 25952, 25953, 25955, 25956, 25959,
    25961, 25964, 25966, 25984, 25994, 25998, 26012, 26016,
    26110, 26116
  );
  GB18030Uni_charset2uni_ranges: array[0..387] of Integer = (
    $0000, $0023,  $0024, $0025,  $0026, $002c,  $002d, $0031,
    $0032, $0050,  $0051, $0058,  $0059, $005e,  $005f, $005f,
    $0060, $0063,  $0064, $0066,  $0067, $0067,  $0068, $0068,
    $0069, $006c,  $006d, $007d,  $007e, $0084,  $0085, $0093,
    $0094, $00ab,  $00ac, $00ae,  $00af, $00b2,  $00b3, $00cf,
    $00d0, $0131,  $0132, $0132,  $0133, $0133,  $0134, $0134,
    $0135, $0135,  $0136, $0136,  $0137, $0137,  $0138, $0138,
    $0139, $0154,  $0155, $01ab,  $01ac, $01ba,  $01bb, $021f,
    $0220, $0220,  $0221, $022d,  $022e, $02e4,  $02e5, $02e5,
    $02e6, $02ec,  $02ed, $02ed,  $02ee, $0324,  $0325, $0332,
    $0333, $0333,  $0334, $1ef1,  $1ef2, $1ef3,  $1ef4, $1ef4,
    $1ef5, $1ef6,  $1ef7, $1efd,  $1efe, $1f06,  $1f07, $1f07,
    $1f08, $1f08,  $1f09, $1f0d,  $1f0e, $1f7d,  $1f7e, $1fd3,
    $1fd4, $1fd4,  $1fd5, $1fd7,  $1fd8, $1fe3,  $1fe4, $1fed,
    $1fee, $202b,  $202c, $202f,  $2030, $2045,  $2046, $2047,
    $2048, $20b5,  $20b6, $20bb,  $20bc, $20bc,  $20bd, $20bf,
    $20c0, $20c3,  $20c4, $20c5,  $20c6, $20c7,  $20c8, $20c8,
    $20c9, $20c9,  $20ca, $20cb,  $20cc, $20d0,  $20d1, $20d5,
    $20d6, $20df,  $20e0, $20e2,  $20e3, $20e7,  $20e8, $20f4,
    $20f5, $20f6,  $20f7, $20fc,  $20fd, $2121,  $2122, $2124,
    $2125, $212f,  $2130, $2148,  $2149, $219a,  $219b, $22e7,
    $22e8, $22f1,  $22f2, $2355,  $2356, $2359,  $235a, $2366,
    $2367, $2369,  $236a, $2373,  $2374, $2383,  $2384, $238b,
    $238c, $2393,  $2394, $2396,  $2397, $2398,  $2399, $23aa,
    $23ab, $23c9,  $23ca, $23cb,  $23cc, $2401,  $2402, $2402,
    $2403, $2c40,  $2c41, $2c42,  $2c43, $2c45,  $2c46, $2c47,
    $2c48, $2c51,  $2c52, $2c60,  $2c61, $2c62,  $2c63, $2c65,
    $2c66, $2c69,  $2c6a, $2c6b,  $2c6c, $2c6e,  $2c6f, $2c7c,
    $2c7d, $2da1,  $2da2, $2da5,  $2da6, $2da6,  $2da7, $2dab,
    $2dac, $2dad,  $2dae, $2dc1,  $2dc2, $2dc3,  $2dc4, $2dca,
    $2dcb, $2dcc,  $2dcd, $2dd1,  $2dd2, $2dd7,  $2dd8, $2ecd,
    $2ece, $2ed4,  $2ed5, $2f45,  $2f46, $302f,  $3030, $303b,
    $303c, $303d,  $303e, $305f,  $3060, $3068,  $3069, $306a,
    $306b, $306c,  $306d, $30dd,  $30de, $3108,  $3109, $3232,
    $3233, $32a1,  $32a2, $32ac,  $32ad, $35a9,  $35aa, $35fe,
    $35ff, $365e,  $365f, $366c,  $366d, $36ff,  $3700, $37d9,
    $37da, $38f8,  $38f9, $3969,  $396a, $3cde,  $3cdf, $3de6,
    $3de7, $3fbd,  $3fbe, $4031,  $4032, $4035,  $4036, $4060,
    $4061, $4158,  $4159, $42cd,  $42ce, $42e1,  $42e2, $43a2,
    $43a3, $43a7,  $43a8, $43f9,  $43fa, $4409,  $440a, $45c2,
    $45c3, $45f4,  $45f5, $45f6,  $45f7, $45fa,  $45fb, $45fb,
    $45fc, $460f,  $4610, $4612,  $4613, $4628,  $4629, $48e7,
    $48e8, $490e,  $490f, $497d,  $497e, $4a11,  $4a12, $4a62,
    $4a63, $82bc,  $830e, $93d4,  $93d5, $9420,  $9421, $943b,
    $943c, $948c,  $948d, $9495,  $9496, $94af,  $94b0, $94b0,
    $94b1, $94b1,  $94b2, $94b4,  $94b5, $94ba,  $94bb, $94bb,
    $94bc, $94bd,  $94be, $98c3,  $98c4, $98c4,  $98c5, $98c8,
    $98c9, $98c9,  $98ca, $98ca,  $98cb, $98cb,  $98cc, $9960,
    $9961, $99e1,  $99e2, $99fb
  );

implementation

end.
