// Code snippets from Win32Api.zip (JwaWinBase.pas, JwaWinType.pas)
{******************************************************************************}
{                                                       	               }
{ Windows Base Services API interface Unit for Object Pascal                   }
{                                                       	               }
{ Portions created by Microsoft are Copyright (C) 1995-2001 Microsoft          }
{ Corporation. All Rights Reserved.                                            }
{ 								               }
{ The original file is: winbase.h, released August 2001. The original Pascal   }
{ code is: WinBase.pas, released December 2000. The initial developer of the   }
{ Pascal code is Marcel van Brakel (brakelm@chello.nl).                        }
{                                                                              }
{ Portions created by Marcel van Brakel are Copyright (C) 1999-2001            }
{ Marcel van Brakel. All Rights Reserved.                                      }
{ 								               }
{ Obtained through: Joint Endeavour of Delphi Innovators (Project JEDI)        }
{								               }
{ You may retrieve the latest version of this file at the Project JEDI home    }
{ page, located at http://delphi-jedi.org or my personal homepage located at   }
{ http://members.chello.nl/m.vanbrakel2                                        }
{								               }
{ The contents of this file are used with permission, subject to the Mozilla   }
{ Public License Version 1.1 (the "License"); you may not use this file except }
{ in compliance with the License. You may obtain a copy of the License at      }
{ http://www.mozilla.org/MPL/MPL-1.1.html                                      }
{                                                                              }
{ Software distributed under the License is distributed on an "AS IS" basis,   }
{ WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for }
{ the specific language governing rights and limitations under the License.    }
{                                                                              }
{ Alternatively, the contents of this file may be used under the terms of the  }
{ GNU Lesser General Public License (the  "LGPL License"), in which case the   }
{ provisions of the LGPL License are applicable instead of those above.        }
{ If you wish to allow use of your version of this file only under the terms   }
{ of the LGPL License and not to allow others to use your version of this file }
{ under the MPL, indicate your decision by deleting  the provisions above and  }
{ replace  them with the notice and other provisions required by the LGPL      }
{ License.  If you do not delete the provisions above, a recipient may use     }
{ your version of this file under either the MPL or the LGPL License.          }
{ 								               }
{ For more information about the LGPL: http://www.gnu.org/copyleft/lesser.html }
{ 								               }
{******************************************************************************}

unit jwa;

{$DEFINE DYNAMIC_LINK}
interface

uses Windows;

const
  ACTCTX_FLAG_RESOURCE_NAME_VALID           = ($00000008);

type
  USHORT = Word;
  ULONG_PTR = Longword;

  tagACTCTXA = record
    cbSize: ULONG;
    dwFlags: DWORD;
    lpSource: LPCSTR;
    wProcessorArchitecture: USHORT;
    wLangId: LANGID;
    lpAssemblyDirectory: LPCSTR;
    lpResourceName: LPCSTR;
    lpApplicationName: LPCSTR;
    hModule: HMODULE;
  end;
  ACTCTXA = tagACTCTXA;
  ACTCTX = ACTCTXA;

function CreateActCtxA(var pActCtx: ACTCTXA): THandle; stdcall;
function ActivateActCtx(hActCtx: THandle; var lpCookie: ULONG_PTR): BOOL; stdcall;
function DeactivateActCtx(dwFlags: DWORD; ulCookie: ULONG_PTR): BOOL; stdcall;
procedure ReleaseActCtx(hActCtx: THandle); stdcall;

implementation

procedure GetProcedureAddress(var P: Pointer; const ModuleName, ProcName: string);
var
  ModuleHandle: HMODULE;
begin
  if not Assigned(P) then
  begin
    ModuleHandle := GetModuleHandle(PChar(ModuleName));
    if ModuleHandle = 0 then
    begin
      ModuleHandle := LoadLibrary(PChar(ModuleName));
      //if ModuleHandle = 0 then raise EJwaLoadLibraryError.Create('Library not found: ' + ModuleName);
    end;
    P := GetProcAddress(ModuleHandle, PChar(ProcName));
    //if not Assigned(P) then raise EJwaGetProcAddressError.Create('Function not found: ' + ModuleName + '.' + ProcName);
  end;
end;

{$IFDEF DYNAMIC_LINK}
var
  _CreateActCtxA: Pointer;

function CreateActCtxA;
begin
  GetProcedureAddress(_CreateActCtxA, kernel32, 'CreateActCtxA');
  asm
    mov esp, ebp
    pop ebp
    jmp [_CreateActCtxA]
  end;
end;
{$ELSE}
function CreateActCtxA; external kernel32 name 'CreateActCtxA';
{$ENDIF DYNAMIC_LINK}

{$IFDEF DYNAMIC_LINK}
var
  _ActivateActCtx: Pointer;

function ActivateActCtx;
begin
  GetProcedureAddress(_ActivateActCtx, kernel32, 'ActivateActCtx');
  asm
    mov esp, ebp
    pop ebp
    jmp [_ActivateActCtx]
  end;
end;
{$ELSE}
function ActivateActCtx; external kernel32 name 'ActivateActCtx';
{$ENDIF DYNAMIC_LINK}

{$IFDEF DYNAMIC_LINK}
var
  _DeactivateActCtx: Pointer;

function DeactivateActCtx;
begin
  GetProcedureAddress(_DeactivateActCtx, kernel32, 'DeactivateActCtx');
  asm
    mov esp, ebp
    pop ebp
    jmp [_DeactivateActCtx]
  end;
end;
{$ELSE}
function DeactivateActCtx; external kernel32 name 'DeactivateActCtx';
{$ENDIF DYNAMIC_LINK}

{$IFDEF DYNAMIC_LINK}
var
  _ReleaseActCtx: Pointer;

procedure ReleaseActCtx;
begin
  GetProcedureAddress(_ReleaseActCtx, kernel32, 'ReleaseActCtx');
  asm
    mov esp, ebp
    pop ebp
    jmp [_ReleaseActCtx]
  end;
end;
{$ELSE}
procedure ReleaseActCtx; external kernel32 name 'ReleaseActCtx';
{$ENDIF DYNAMIC_LINK}

end.
