unit XPThemesOn;

interface

uses Windows, SysUtils, jwa;

function InitXPThemes(var hActCtx : THANDLE; var XPCookie : ULONG):boolean;
procedure CloseXPThemes(ContextActivated : boolean;
 hActCtx : THANDLE; XPCookie : ULONG);

implementation

function InitXPThemes(var hActCtx : THANDLE; var XPCookie : ULONG):boolean;
var
  act : ACTCTX;
  Buffer : array[0..MAX_PATH] of Char;
begin
  result := false;
  hActCtx := 0;
  if (Win32Platform = VER_PLATFORM_WIN32_NT) and ((Win32MajorVersion > 5)
   or ((Win32MajorVersion = 5) and (Win32MinorVersion >= 1))) then begin
    GetModuleFileName(HInstance, Buffer, MAX_PATH);
    ZeroMemory(@act, SizeOf(act));
    act.cbSize := sizeof(act);
    act.dwFlags := ACTCTX_FLAG_RESOURCE_NAME_VALID;
    act.lpResourceName := MAKEINTRESOURCE(2);
    act.lpSource := Buffer;
    hActCtx := CreateActCtxA(act);
    if hActCtx <> INVALID_HANDLE_VALUE then
      result := ActivateActCtx(hActCtx, XPCookie);
  end;
end;

procedure CloseXPThemes(ContextActivated : boolean;
 hActCtx : THANDLE; XPCookie : ULONG);
begin
  if ContextActivated then
    DeactivateActCtx(0, XPCookie);
  if (hActCtx <> INVALID_HANDLE_VALUE) and (hActCtx <> 0) then
    ReleaseActCtx(hActCtx);
end;

end.
