//**************************************************************
//                                                             *
//                        IE-Const                             *
//                       For Delphi                            *
//                                                             *
//  Contributions:                                             *
//  Per Linds Larsen                                          *
//  Eran Bodankin (bsalsa) bsalsa@gmail.com                   *
//  Thomas Stutz (smot)                                        *
//                                                             *
//  Updated versions:                                          *
//               http://www.bsalsa.com                         *
//**************************************************************

{*******************************************************************************}
{LICENSE:
THIS SOFTWARE IS PROVIDED TO YOU "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESSED OR IMPLIED INCLUDING BUT NOT LIMITED TO THE APPLIED
WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
YOU ASSUME THE ENTIRE RISK AS TO THE ACCURACY AND THE USE OF THE SOFTWARE
AND ALL OTHER RISK ARISING OUT OF THE USE OR PERFORMANCE OF THIS SOFTWARE
AND DOCUMENTATION. BSALSA PRODUCTIONS DOES NOT WARRANT THAT THE SOFTWARE IS ERROR-FREE
OR WILL OPERATE WITHOUT INTERRUPTION. THE SOFTWARE IS NOT DESIGNED, INTENDED
OR LICENSED FOR USE IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE CONTROLS,
INCLUDING WITHOUT LIMITATION, THE DESIGN, CONSTRUCTION, MAINTENANCE OR
OPERATION OF NUCLEAR FACILITIES, AIRCRAFT NAVIGATION OR COMMUNICATION SYSTEMS,
AIR TRAFFIC CONTROL, AND LIFE SUPPORT OR WEAPONS SYSTEMS. BSALSA PRODUCTIONS SPECIFICALLY
DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR SUCH PURPOSE.

You may use, change or modify the component under 4 conditions:
1. In your website, add a link to "http://www.bsalsa.com"
2. In your application, add credits to "Embedded Web Browser"
3. Mail me  (bsalsa@gmail.com) any code change in the unit
   for the benefit of the other users.
4. Please, consider donation in our web site!
{*******************************************************************************}

unit EWB.IEConst;

interface

{$I EWB.inc}


// The reason for this file is that some constants are
// missing in previous delphi versions.

const
  ACO_NONE = 0;
  ACO_AUTOSUGGEST = $1;
  ACO_AUTOAPPEND = $2;
  ACO_SEARCH = $4;
  ACO_FILTERPREFIXES = $8;
  ACO_USETAB = $10;
  ACO_UPDOWNKEYDROPSLIST = $20;
  ACO_RTLREADING = $40;
  ACLO_NONE = 0; {don't enumerate anything}
  ACLO_CURRENTDIR = 1; {enumerate current directory}
  ACLO_MYCOMPUTER = 2; {enumerate MyComputer}
  ACLO_DESKTOP = 4; {enumerate Desktop Folder}
  ACLO_FAVORITES = 8; {enumerate Favorites Folder}
  ACLO_FILESYSONLY = 16; {enumerate only the file system}
  BINDSTATUS_FINDINGRESOURCE = 1;
  BINDSTATUS_CONNECTING = 2;
  BINDSTATUS_REDIRECTING = 3;
  BINDSTATUS_BEGINDOWNLOADDATA = 4;
  BINDSTATUS_DOWNLOADINGDATA = 5;
  BINDSTATUS_ENDDOWNLOADDATA = 6;
  BINDSTATUS_BEGINDOWNLOADCOMPONENTS = 7;
  BINDSTATUS_INSTALLINGCOMPONENTS = 8;
  BINDSTATUS_ENDDOWNLOADCOMPONENTS = 9;
  BINDSTATUS_USINGCACHEDCOPY = 10;
  BINDSTATUS_SENDINGREQUEST = 11;
  BINDSTATUS_CLASSIDAVAILABLE = 12;
  BINDSTATUS_MIMETYPEAVAILABLE = 13;
  BINDSTATUS_CACHEFILENAMEAVAILABLE = 14;
  BINDSTATUS_BEGINSYNCOPERATION = 15;
  BINDSTATUS_ENDSYNCOPERATION = 16;
  BINDSTATUS_BEGINUPLOADDATA = 17;
  BINDSTATUS_UPLOADINGDATA = 18;
  BINDSTATUS_ENDUPLOADINGDATA = 19;
  BINDSTATUS_PROTOCOLCLASSID = 20;
  BINDSTATUS_ENCODING = 21;
  BINDSTATUS_VERFIEDMIMETYPEAVAILABLE = 22;
  BINDSTATUS_CLASSINSTALLLOCATION = 23;
  BINDSTATUS_DECODING = 24;
  BINDSTATUS_LOADINGMIMEHANDLER = 25;
  BINDSTATUS_CONTENTDISPOSITIONATTACH = 26;
  BINDSTATUS_FILTERREPORTMIMETYPE = 27;
  BINDSTATUS_CLSIDCANINSTANTIATE = 28;
  BINDSTATUS_IUNKNOWNAVAILABLE = 29;
  BINDSTATUS_DIRECTBIND = 30;
  BINDSTATUS_RAWMIMETYPE = 31;
  BINDSTATUS_PROXYDETECTING = 32;
  BINDSTATUS_ACCEPTRANGES = 33;
  BINDSTATUS_COOKIE_SENT = 34;
  BINDSTATUS_COMPACT_POLICY_RECEIVED = 35;
  BINDSTATUS_COOKIE_SUPPRESSED = 36;
  BINDSTATUS_COOKIE_STATE_UNKNOWN = 37;
  BINDSTATUS_COOKIE_STATE_ACCEPT = 38;
  BINDSTATUS_COOKIE_STATE_REJECT = 39;
  BINDSTATUS_COOKIE_STATE_PROMPT = 40;
  BINDSTATUS_COOKIE_STATE_LEASH = 41;
  BINDSTATUS_COOKIE_STATE_DOWNGRADE = 42;
  BINDSTATUS_POLICY_HREF = 43;
  BINDSTATUS_P3P_HEADER = 44;
  BINDSTATUS_SESSION_COOKIE_RECEIVED = 45;
  BINDSTATUS_PERSISTENT_COOKIE_RECEIVED = 46;
  BINDSTATUS_SESSION_COOKIES_ALLOWED = 47;
  BINDSTATUS_CACHECONTROL = 48;
  BINDSTATUS_CONTENTDISPOSITIONFILENAME = 49;
  BINDSTATUS_MIMETEXTPLAINMISMATCH = 50;
  BINDSTATUS_PUBLISHERAVAILABLE = 51;
  BINDSTATUS_DISPLAYNAMEAVAILABLE = 52;
  BINDSTATUS_SSLUX_NAVBLOCKED = 53;
  BINDSTATUS_SERVER_MIMETYPEAVAILABLE = 54;
  BINDSTATUS_SNIFFED_CLASSIDAVAILABLE = 55;
  BINDSTATUS_64BIT_PROGRESS = 56;
  VER_NUM = ' 14.70.0';
  _MaskedChars: string = 'ACFNP';
  ADDRESS_NOT_VALID = 2147221020; //**
  ASS_MESS = 'Please assign a WebBrowser before using this feature.';
  CACHEGROUP_ATTRIBUTE_BASIC = $00000001;
  CACHEGROUP_ATTRIBUTE_FLAG = $00000002;
  CACHEGROUP_ATTRIBUTE_GET_ALL = $FFFFFFFF;
  CACHEGROUP_ATTRIBUTE_GROUPNAME = $00000010;
  CACHEGROUP_ATTRIBUTE_QUOTA = $00000008;
  CACHEGROUP_ATTRIBUTE_STORAGE = $00000020;
  CACHEGROUP_ATTRIBUTE_TYPE = $00000004;
  CACHEGROUP_FLAG_FLUSHURL_ONDELETE = $00000002;
  CACHEGROUP_FLAG_GIDONLY = $00000004;
  CACHEGROUP_FLAG_NONPURGEABLE = $00000001;
  CACHEGROUP_SEARCH_ALL = $00000000;
  CACHEGROUP_SEARCH_BYURL = $00000001;
  CACHEGROUP_TYPE_INVALID = $00000001;
  CACHEGROUP_READWRITE_MASK = CACHEGROUP_ATTRIBUTE_TYPE or
    CACHEGROUP_ATTRIBUTE_QUOTA or CACHEGROUP_ATTRIBUTE_GROUPNAME or
    CACHEGROUP_ATTRIBUTE_STORAGE;
  CAddMenuExtensionsCommandID = 53;
  CContextMenuID = 24641;
  CGetMimeSubMenuCommandID = 27;
  CIP_NEED_REBOOT_UI_PERMISSION = 9;
  comctl32 = 'comctl32.dll';
  CONTEXT_MENU_ANCHOR = 5;
  CONTEXT_MENU_CONTROL = 2;
  CONTEXT_MENU_DEBUG = 9;
  CONTEXT_MENU_DEFAULT = 0;
  CONTEXT_MENU_HSCROLL = 11;
  CONTEXT_MENU_IMAGE = 1;
  CONTEXT_MENU_IMGART = 8;
  CONTEXT_MENU_IMGDYNSRC = 7;
  CONTEXT_MENU_TABLE = 3;
  CONTEXT_MENU_TEXTSELECT = 4;
  CONTEXT_MENU_UNKNOWN = 6;
  CONTEXT_MENU_VSCROLL = 10;
  CP_SYMBOL = 42;
  CP_THREAD_ACP = 3;
  DISPID_AMBIENT_DLCONTROL = (-5512);
  DISPID_AMBIENT_USERAGENT = (-5513);
  DOCHOSTUIDBLCLK_DEFAULT = 0;
  DOCHOSTUIDBLCLK_SHOWCODE = 2;
  DOCHOSTUIDBLCLK_SHOWPROPERTIES = 1;
  DOCHOSTUIFLAG_ACTIVATE_CLIENTHIT_ONLY = $0200;
  DOCHOSTUIFLAG_CODEPAGELINKEDFONTS = $0800;
  DOCHOSTUIFLAG_DIALOG = $0001;
  DOCHOSTUIFLAG_DISABLE_HELP_MENU = $0002;
  DOCHOSTUIFLAG_DISABLE_OFFSCREEN = $0040;
  DOCHOSTUIFLAG_DISABLE_SCRIPT_INACTIVE = $0010;
  DOCHOSTUIFLAG_DIV_BLOCKDEFAULT = $0100;
  DOCHOSTUIFLAG_ENABLE_FORMS_AUTOCOMPLETE = $4000;
  DOCHOSTUIFLAG_ENABLE_INPLACE_NAVIGATION = $10000;
  DOCHOSTUIFLAG_FLAT_SCROLLBAR = $0080;
  DOCHOSTUIFLAG_IME_ENABLE_RECONVERSION = $20000;
  DOCHOSTUIFLAG_NO3DBORDER = $0004;
  DOCHOSTUIFLAG_OPENNEWWIN = $0020;
  DOCHOSTUIFLAG_OVERRIDEBEHAVIORFACTORY = $0400;
  DOCHOSTUIFLAG_SCROLL_NO = $0008;
  DOCHOSTUIFLAG_URL_ENCODING_DISABLE_UTF8 = $1000;
  DOCHOSTUIFLAG_URL_ENCODING_ENABLE_UTF8 = $2000;
  DOCHOSTUITYPE_AUTHOR = 1;
  DOCHOSTUITYPE_BROWSE = 0;
  ERROR_INTERNET_FORTEZZA_LOGIN_NEEDED = 12054;
  INTERNET_ERROR_BASE = 12000;
  ERROR_INTERNET_OUT_OF_HANDLES = INTERNET_ERROR_BASE + 1;
  ERROR_INTERNET_TIMEOUT = INTERNET_ERROR_BASE + 2;
  ERROR_INTERNET_EXTENDED_ERROR = INTERNET_ERROR_BASE + 3;
  ERROR_INTERNET_INTERNAL_ERROR = INTERNET_ERROR_BASE + 4;
  ERROR_INTERNET_INVALID_URL = INTERNET_ERROR_BASE + 5;
  ERROR_INTERNET_UNRECOGNIZED_SCHEME = INTERNET_ERROR_BASE + 6;
  ERROR_INTERNET_NAME_NOT_RESOLVED = INTERNET_ERROR_BASE + 7;
  ERROR_INTERNET_PROTOCOL_NOT_FOUND = INTERNET_ERROR_BASE + 8;
  ERROR_INTERNET_INVALID_OPTION = INTERNET_ERROR_BASE + 9;
  ERROR_INTERNET_BAD_OPTION_LENGTH = INTERNET_ERROR_BASE + 10;
  ERROR_INTERNET_OPTION_NOT_SETTABLE = INTERNET_ERROR_BASE + 11;
  ERROR_INTERNET_SHUTDOWN = INTERNET_ERROR_BASE + 12;
  ERROR_INTERNET_INCORRECT_USER_NAME = INTERNET_ERROR_BASE + 13;
  ERROR_INTERNET_INCORRECT_PASSWORD = INTERNET_ERROR_BASE + 14;
  ERROR_INTERNET_LOGIN_FAILURE = INTERNET_ERROR_BASE + 15;
  ERROR_INTERNET_INVALID_OPERATION = INTERNET_ERROR_BASE + 16;
  ERROR_INTERNET_OPERATION_CANCELLED = INTERNET_ERROR_BASE + 17;
  ERROR_INTERNET_INCORRECT_HANDLE_TYPE = INTERNET_ERROR_BASE + 18;
  ERROR_INTERNET_INCORRECT_HANDLE_STATE = INTERNET_ERROR_BASE + 19;
  ERROR_INTERNET_NOT_PROXY_REQUEST = INTERNET_ERROR_BASE + 20;
  ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND = INTERNET_ERROR_BASE + 21;
  ERROR_INTERNET_BAD_REGISTRY_PARAMETER = INTERNET_ERROR_BASE + 22;
  ERROR_INTERNET_NO_DIRECT_ACCESS = INTERNET_ERROR_BASE + 23;
  ERROR_INTERNET_NO_CONTEXT = INTERNET_ERROR_BASE + 24;
  ERROR_INTERNET_NO_CALLBACK = INTERNET_ERROR_BASE + 25;
  ERROR_INTERNET_REQUEST_PENDING = INTERNET_ERROR_BASE + 26;
  ERROR_INTERNET_INCORRECT_FORMAT = INTERNET_ERROR_BASE + 27;
  ERROR_INTERNET_ITEM_NOT_FOUND = INTERNET_ERROR_BASE + 28;
  ERROR_INTERNET_CANNOT_CONNECT = INTERNET_ERROR_BASE + 29;
  ERROR_INTERNET_CONNECTION_ABORTED = INTERNET_ERROR_BASE + 30;
  ERROR_INTERNET_CONNECTION_RESET = INTERNET_ERROR_BASE + 31;
  ERROR_INTERNET_FORCE_RETRY = INTERNET_ERROR_BASE + 32;
  ERROR_INTERNET_INVALID_PROXY_REQUEST = INTERNET_ERROR_BASE + 33;
  ERROR_INTERNET_HANDLE_EXISTS = INTERNET_ERROR_BASE + 36;
  ERROR_INTERNET_SEC_CERT_DATE_INVALID = INTERNET_ERROR_BASE + 37;
  ERROR_INTERNET_SEC_CERT_CN_INVALID = INTERNET_ERROR_BASE + 38;
  ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR = INTERNET_ERROR_BASE + 39;
  ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR = INTERNET_ERROR_BASE + 40;
  ERROR_INTERNET_MIXED_SECURITY = INTERNET_ERROR_BASE + 41;
  ERROR_INTERNET_CHG_POST_IS_NON_SECURE = INTERNET_ERROR_BASE + 42;
  ERROR_INTERNET_POST_IS_NON_SECURE = INTERNET_ERROR_BASE + 43;
  ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED = INTERNET_ERROR_BASE + 44;
  ERROR_INTERNET_INVALID_CA = INTERNET_ERROR_BASE + 45;
  ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP = INTERNET_ERROR_BASE + 46;
  ERROR_INTERNET_ASYNC_THREAD_FAILED = INTERNET_ERROR_BASE + 47;
  ERROR_INTERNET_REDIRECT_SCHEME_CHANGE = INTERNET_ERROR_BASE + 48;
  ERROR_INTERNET_DIALOG_PENDING = INTERNET_ERROR_BASE + 49;
  ERROR_INTERNET_RETRY_DIALOG = INTERNET_ERROR_BASE + 50;
  ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR = INTERNET_ERROR_BASE + 52;
  ERROR_INTERNET_INSERT_CDROM = INTERNET_ERROR_BASE + 53;
  E_PENDING = $8000000A;
  IED_INFO = ' IEDownload http://bsalsa.com/';
  EWB_INFO = ' EmbeddedWB http://bsalsa.com/';
  EXPLORE_COMMAND = 2;
  FEATURE_FROM_PROCESS = $00000002;
  FEATURE_FROM_REGISTRY = $00000004;
  FEATURE_FROM_THREAD = $00000001;
  FEATURE_FROM_THREAD_INTERNET = $00000040;
  FEATURE_FROM_THREAD_INTRANET = $00000010;
  FEATURE_FROM_THREAD_LOCALMACHINE = $00000008;
  FEATURE_FROM_THREAD_RESTRICTED = $00000080;
  FEATURE_FROM_THREAD_TRUSTED = $00000020;
  FIND_COMMAND = 3;
  Free_Index = 73;
  GROUP_OWNER_STORAGE_SIZE = 4;
  GROUPNAME_MAX_LENGTH = 120;
  hhctrl = 'hhctrl.ocx';
  HoursPerDay = 24;
  HTMLID_FIND = 1;
  HTMLID_OPTIONS = 3;
  HTMLID_VIEWSOURCE = 2;
  HTTP_QUERY_FLAG_COALESCE = $10000000;
  HTTP_QUERY_FLAG_NUMBER = $20000000;
  HTTP_QUERY_FLAG_REQUEST_HEADERS = $80000000;
  HTTP_QUERY_FLAG_SYSTEMTIME = $40000000;
  HTTP_QUERY_MODIFIER_FLAGS_MASK = (HTTP_QUERY_FLAG_REQUEST_HEADERS or
    HTTP_QUERY_FLAG_SYSTEMTIME or HTTP_QUERY_FLAG_NUMBER or
    HTTP_QUERY_FLAG_COALESCE);
  ID_EDITMODE = 32801;
  ID_IE_CONTEXTMENU_ADDFAV = 2261;
  ID_IE_CONTEXTMENU_NEWWINDOW = 2137;
  ID_IE_CONTEXTMENU_REFRESH = 6042;
  ID_IE_F5_REFRESH = 6041; // added by smot
  ID_IE_FILE_ADDLOCAL = 377;
  ID_IE_FILE_ADDTRUST = 376;
  ID_IE_FILE_IMPORTEXPORT = 374;
  ID_IE_FILE_NEWCALL = 395;
  ID_IE_FILE_NEWMAIL = 279;
  ID_IE_FILE_NEWPEOPLE = 390;
  ID_IE_FILE_NEWPUBLISHINFO = 387;
  ID_IE_FILE_NEWWINDOW = 275;
  ID_IE_FILE_PAGESETUP = 259;
  ID_IE_FILE_PRINT = 260;
  ID_IE_FILE_PRINTPREVIEW = 277;
  ID_IE_FILE_SENDDESKTOPSHORTCUT = 284;
  ID_IE_FILE_SENDLINK = 283;
  ID_IE_FILE_SENDPAGE = 282;
  ID_IE_HELP_BESTPAGE = 346;
  ID_IE_HELP_ENHANCEDSECURITY = 375;
  ID_IE_HELP_FAQ = 343;
  ID_IE_HELP_FEEDBACK = 345;
  ID_IE_HELP_FREESTUFF = 341;
  ID_IE_HELP_HELPINDEX = 337;
  ID_IE_HELP_MSHOME = 348;
  ID_IE_HELP_NETSCAPEUSER = 351;
  ID_IE_HELP_ONLINESUPPORT = 344;
  ID_IE_HELP_PRODUCTUPDATE = 342;
  ID_IE_HELP_SEARCHWEB = 347;
  ID_IE_HELP_STARTPAGE = 350;
  ID_IE_HELP_VERSIONINFO = 336;
  ID_IE_HELP_VISITINTERNET = 349;
  ID_IE_HELP_WEBTUTORIAL = 338;
  IDM_1D = 2170;
  IDM_ADDFAVORITES = 2261;
  IDM_ADDRESS = 2189;
  IDM_ADDTOFAVOURITES = 2261;
  IDM_ALIGNBOTTOM = 1;
  IDM_ALIGNHORIZONTALCENTERS = 2;
  IDM_ALIGNLEFT = 3;
  IDM_ALIGNRIGHT = 4;
  IDM_ALIGNTOGRID = 5;
  IDM_ALIGNTOP = 6;
  IDM_ALIGNVERTICALCENTERS = 7;
  IDM_APPLYHEADING1 = 2255;
  IDM_APPLYHEADING2 = 2256;
  IDM_APPLYHEADING3 = 2257;
  IDM_APPLYNORMAL = 2254;
  IDM_ARRANGEBOTTOM = 8;
  IDM_ARRANGERIGHT = 9;
  IDM_AUTODETECT = 2329;
  IDM_BACK = 2282;
  IDM_BACKCOLOR = 51;
  IDM_BASELINEFONT1 = 2141;
  IDM_BASELINEFONT3 = 2143;
  IDM_BASELINEFONT4 = 2144;
  IDM_BASELINEFONT5 = 2145;
  IDM_BLINK = 2190;
  IDM_BLOCKFMT = 2234;
  IDM_BOLD = 52;
  IDM_BOOKMARK = 2123;
  IDM_BORDERCOLOR = 53;
  IDM_BREAKATNEXT = 2311;
  IDM_BRINGFORWARD = 10;
  IDM_BRINGTOFRONT = 11;
  IDM_BROWSEMODE = 2126;
  IDM_BUTTON = 2167;
  IDM_CANCEL = 89;
  IDM_CAPTIONINSERT = 2203;
  IDM_CELLINSERT = 2202;
  IDM_CELLMERGE = 2204;
  IDM_CELLPROPERTIES = 2211;
  IDM_CELLSELECT = 2206;
  IDM_CELLSPLIT = 2205;
  IDM_CENTERALIGNPARA = 2250;
  IDM_CENTERHORIZONTALLY = 12;
  IDM_CENTERVERTICALLY = 13;
  IDM_CHANGECASE = 2246;
  IDM_CHANGEFONT = 2240;
  IDM_CHANGEFONTSIZE = 2241;
  IDM_CHECKBOX = 2163;
  IDM_CHISELED = 64;
  IDM_CLEARSELECTION = 2007;
  IDM_CODE = 14;
  IDM_COLUMNINSERT = 2213;
  IDM_COLUMNSELECT = 2208;
  IDM_COMMENT = 2173;
  IDM_COMPOSESETTINGS = 2318;
  IDM_CONTEXTMENU = 2280;
  IDM_CONVERTOBJECT = 82;
  IDM_COPY = 15;
  IDM_COPYBACKGROUND = 2265;
  IDM_COPYCONTENT = 2291;
  IDM_COPYFORMAT = 2237;
  IDM_COPYSHORTCUT = 2262;
  IDM_CREATELINK = 2290;
  IDM_CREATESHORTCUT = 2266;
  IDM_CUSTOMCONTROL = 83;
  IDM_CUSTOMIZEITEM = 84;
  IDM_CUT = 16;
  IDM_DECFONTSIZE = 2243;
  IDM_DECFONTSIZE1PT = 2245;
  IDM_DELETE = 17;
  IDM_DELETEWORD = 92;
  IDM_DIV = 2191;
  IDM_DOCPROPERTIES = 2260;
  IDM_DROPDOWNBOX = 2165;
  IDM_DYNSRCPLAY = 2271;
  IDM_DYNSRCSTOP = 2272;
  IDM_EDITMODE = 2127;
  IDM_EDITSOURCE = 2122;
  IDM_ENABLE_INTERACTION = 2302;
  IDM_ENCODING = 2292;
  IDM_ETCHED = 65;
  IDM_FILE = 2172;
  IDM_FIND = 67;
  IDM_FLAT = 54;
  IDM_FOLLOW_ANCHOR = 2008;
  IDM_FOLLOWLINKC = 2136;
  IDM_FOLLOWLINKN = 2137;
  IDM_FONT = 90;
  IDM_FONTNAME = 18;
  IDM_FONTSIZE = 19;
  IDM_FORECOLOR = 55;
  IDM_FORM = 2181;
  IDM_FORMATMARK = 2132;
  IDM_FORWARD = 2283;
  IDM_GETBLOCKFMTS = 2233;
  IDM_GETBYTESDOWNLOADED = 2331;
  IDM_GETZOOM = 68;
  IDM_GOBACKWARD = 2282;
  IDM_GOFORWARD = 2283;
  IDM_GOTO = 2239;
  IDM_GROUP = 20;
  IDM_HELP_ABOUT = 2221;
  IDM_HELP_CONTENT = 2220;
  IDM_HELP_README = 2222;
  IDM_HORIZONTALLINE = 2150;
  IDM_HORIZSPACECONCATENATE = 21;
  IDM_HORIZSPACEDECREASE = 22;
  IDM_HORIZSPACEINCREASE = 23;
  IDM_HORIZSPACEMAKEEQUAL = 24;
  IDM_HTMLCONTAIN = 2159;
  IDM_HTMLEDITMODE = 2316;
  IDM_HTMLSOURCE = 2157;
  IDM_HYPERLINK = 2124;
  IDM_IFRAME = 2158;
  IDM_IMAGE = 2168;
  IDM_IMAGEMAP = 2171;
  IDM_IMGARTPLAY = 2274;
  IDM_IMGARTREWIND = 2276;
  IDM_IMGARTSTOP = 2275;
  IDM_IMPORT = 86;
  IDM_INCFONTSIZE = 2242;
  IDM_INCFONTSIZE1PT = 2244;
  IDM_INDENT = 2186;
  IDM_INSERTOBJECT = 25;
  IDM_INSFIELDSET = 2119;
  IDM_INSINPUTBUTTON = 2115;
  IDM_INSINPUTHIDDEN = 2312;
  IDM_INSINPUTIMAGE = 2114;
  IDM_INSINPUTPASSWORD = 2313;
  IDM_INSINPUTRESET = 2116;
  IDM_INSINPUTSUBMIT = 2117;
  IDM_INSINPUTUPLOAD = 2118;
  IDM_ITALIC = 56;
  IDM_JAVAAPPLET = 2175;
  IDM_JUSTIFYCENTER = 57;
  IDM_JUSTIFYFULL = 50;
  IDM_JUSTIFYGENERAL = 58;
  IDM_JUSTIFYLEFT = 59;
  IDM_JUSTIFYRIGHT = 60;
  IDM_LANGUAGE = 2292;
  IDM_LAUNCHDEBUGGER = 2310;
  IDM_LEFTALIGNPARA = 2251;
  IDM_LINEBREAKBOTH = 2154;
  IDM_LINEBREAKLEFT = 2152;
  IDM_LINEBREAKNORMAL = 2151;
  IDM_LINEBREAKRIGHT = 2153;
  IDM_LIST = 2183;
  IDM_LISTBOX = 2166;
  IDM_MARQUEE = 2182;
  IDM_MENUEXT_COUNT = 3733;
  IDM_MENUEXT_FIRST__ = 3700;
  IDM_MENUEXT_LAST__ = 3732;
  IDM_MIMECSET__FIRST__ = 3609;
  IDM_MIMECSET__LAST__ = 3640;
  IDM_MOVE = 88;
  IDM_MULTILEVELREDO = 30;
  IDM_MULTILEVELUNDO = 44;
  IDM_NEW = 2001;
  IDM_NEWPAGE = 87;
  IDM_NOACTIVATEDESIGNTIMECONTROLS = 2333;
  IDM_NOACTIVATEJAVAAPPLETS = 2334;
  IDM_NOACTIVATENORMALOLECONTROLS = 2332;
  IDM_NONBREAK = 2155;
  IDM_OBJECT = 2169;
  IDM_OBJECTVERBLIST0 = 72;
  IDM_OBJECTVERBLIST1 = 73;
  IDM_OBJECTVERBLIST2 = 74;
  IDM_OBJECTVERBLIST3 = 75;
  IDM_OBJECTVERBLIST4 = 76;
  IDM_OBJECTVERBLIST5 = 77;
  IDM_OBJECTVERBLIST6 = 78;
  IDM_OBJECTVERBLIST7 = 79;
  IDM_OBJECTVERBLIST8 = 80;
  IDM_OBJECTVERBLIST9 = 81;
  IDM_OPEN = 2000;
  IDM_OPENINNEWWINDOW = 2137;
  IDM_OPENLINK = 2136;
  IDM_OPTIONS = 2135;
  IDM_ORDERLIST = 2184;
  IDM_OUTDENT = 2187;
  IDM_OVERWRITE = 2314;
  IDM_PAGE = 2267;
  IDM_PAGEBREAK = 2177;
  IDM_PAGEINFO = 2231;
  IDM_PAGESETUP = 2004;
  IDM_PARAGRAPH = 2180;
  IDM_PARSECOMPLETE = 2315;
  IDM_PASTE = 26;
  IDM_PASTEFORMAT = 2238;
  IDM_PASTEINSERT = 2120;
  IDM_PASTESPECIAL = 2006;
  IDM_PERSISTSTREAMSYNC = 2341;
  IDM_PLUGIN = 2176;
  IDM_PREFORMATTED = 2188;
  IDM_PRESTOP = 2284;
  IDM_PRINT = 27;
  IDM_PRINTPREVIEW = 2003;
  IDM_PRINTQUERYJOBSPENDING = 2277;
  IDM_PRINTTARGET = 2273;
  IDM_PROPERTIES = 28;
  IDM_RADIOBUTTON = 2164;
  IDM_RAISED = 61;
  IDM_RCINSERT = 2201;
  IDM_REDO = 29;
  IDM_REFRESH = 2300;
  IDM_REGISTRYREFRESH = 2317;
  IDM_REMOVEFORMAT = 2230;
  IDM_REMOVEPARAFORMAT = 2253;
  IDM_RENAME = 85;
  IDM_REPLACE = 2121;
  IDM_RIGHTALIGNPARA = 2252;
  IDM_ROWINSERT = 2212;
  IDM_ROWSELECT = 2207;
  IDM_SAVE = 70;
  IDM_SAVEAS = 71;
  IDM_SAVEBACKGROUND = 2263;
  IDM_SAVECOPYAS = 2002;
  IDM_SAVEPICTURE = 2270;
  IDM_SAVETARGET = 2268;
  IDM_SCRIPT = 2174;
  IDM_SCRIPTDEBUGGER = 2330;
  IDM_SELECTALL = 31;
  IDM_SENDBACKWARD = 32;
  IDM_SENDTOBACK = 33;
  IDM_SETASBACKGROUND = 2264;
  IDM_SETASDESKTOPITEM = 2278;
  IDM_SETDIRTY = 2342;
  IDM_SETWALLPAPER = 2264;
  IDM_SHADOWED = 66;
  IDM_SHOWALIGNEDSITETAGS = 2321;
  IDM_SHOWALLTAGS = 2320;
  IDM_SHOWAREATAGS = 2325;
  IDM_SHOWCOMMENTTAGS = 2324;
  IDM_SHOWGRID = 69;
  IDM_SHOWHIDE_CODE = 2235;
  IDM_SHOWMISCTAGS = 2327;
  IDM_SHOWPICTURE = 2269;
  IDM_SHOWSCRIPTTAGS = 2322;
  IDM_SHOWSPECIALCHAR = 2249;
  IDM_SHOWSTYLETAGS = 2323;
  IDM_SHOWTABLE = 34;
  IDM_SHOWUNKNOWNTAGS = 2326;
  IDM_SHOWWBRTAGS = 2340;
  IDM_SHOWZEROBORDERATDESIGNTIME = 2328;
  IDM_SIZETOCONTROL = 35;
  IDM_SIZETOCONTROLHEIGHT = 36;
  IDM_SIZETOCONTROLWIDTH = 37;
  IDM_SIZETOFIT = 38;
  IDM_SIZETOGRID = 39;
  IDM_SNAPTOGRID = 40;
  IDM_SPECIALCHAR = 2156;
  IDM_SPELL = 2005;
  IDM_STATUSBAR = 2131;
  IDM_STOP = 2138;
  IDM_STOPDOWNLOAD = 2301;
  IDM_STRIKETHROUGH = 91;
  IDM_SUBSCRIPT = 2247;
  IDM_SUNKEN = 62;
  IDM_SUPERSCRIPT = 2248;
  IDM_TABLE = 2236;
  IDM_TABLEINSERT = 2200;
  IDM_TABLEPROPERTIES = 2210;
  IDM_TABLESELECT = 2209;
  IDM_TABORDER = 41;
  IDM_TELETYPE = 2232;
  IDM_TEXTAREA = 2162;
  IDM_TEXTBOX = 2161;
  IDM_TEXTONLY = 2133;
  IDM_TOOLBARS = 2130;
  IDM_TOOLBOX = 42;
  IDM_TRIED_CONSTRAIN = 12; //[in,VT_BOOL]
  IDM_TRIED_DELETECELLS = 21;
  IDM_TRIED_DELETECOLS = 17;
  IDM_TRIED_DELETEROWS = 16;
  IDM_TRIED_INSERTCELL = 20;
  IDM_TRIED_INSERTCOL = 15;
  IDM_TRIED_INSERTROW = 14;
  IDM_TRIED_INSERTTABLE = 22; //[in, VT_ARRAY]
  IDM_TRIED_IS_1D_ELEMENT = 0; //[out,VT_BOOL]
  IDM_TRIED_IS_2D_ELEMENT = 1; //[out,VT_BOOL]
  IDM_TRIED_LAST_CID = IDM_TRIED_INSERTTABLE; //WARNING WARNING WARNING!!! Don't forget to modify IDM_TRIED_LAST_CID
  IDM_TRIED_LOCK_ELEMENT = 5;
  IDM_TRIED_MAKE_ABSOLUTE = 4;
  IDM_TRIED_MERGECELLS = 18;
  IDM_TRIED_NUDGE_ELEMENT = 2; //[in,VT_BYREF VARIANT.byref=LPPOINT]
  IDM_TRIED_SEND_BACKWARD = 8;
  IDM_TRIED_SEND_BEHIND_1D = 10;
  IDM_TRIED_SEND_FORWARD = 9;
  IDM_TRIED_SEND_FRONT_1D = 11;
  IDM_TRIED_SEND_TO_BACK = 6;
  IDM_TRIED_SEND_TO_FRONT = 7;
  IDM_TRIED_SET_2D_DROP_MODE = 13; //[in,VT_BOOL]
  IDM_TRIED_SET_ALIGNMENT = 3; //[in,VT_BYREF VARIANT.byref=LPPOINT]
  IDM_TRIED_SPLITCELL = 19;
  IDM_UNBOOKMARK = 2128;
  IDM_UNDERLINE = 63;
  IDM_UNDO = 43;
  IDM_UNGROUP = 45;
  IDM_UNKNOWN = 0;
  IDM_UNLINK = 2125;
  IDM_UNORDERLIST = 2185;
  IDM_VERTSPACECONCATENATE = 46;
  IDM_VERTSPACEDECREASE = 47;
  IDM_VERTSPACEINCREASE = 48;
  IDM_VERTSPACEMAKEEQUAL = 49;
  IDM_VIEWSOURCE = 2139;
  IDM_ZOOMPERCENT = 50;
  IDM_ZOOMPOPUP = 2140;
  IE_PPREVIEWCLASS = 'Internet Explorer_TridentDlgFrame';
  InchToMetric = 25.4;
  INET_E_AUTHENTICATION_REQUIRED = -2146697207;
  INET_E_CANNOT_CONNECT = -2146697212;
  INET_E_CANNOT_INSTANTIATE_OBJECT = -2146697200;
  INET_E_CANNOT_LOAD_DATA = -2146697201;
  INET_E_CANNOT_LOCK_REQUEST = -2146697194;
  INET_E_CANNOT_REPLACE_SFP_FILE = -2146697448;
  INET_E_CODE_DOWNLOAD_DECLINED = -2146697960;
  INET_E_CONNECTION_TIMEOUT = -2146697205; //**
  INET_E_DATA_NOT_AVAILABLE = -2146697209;
  INET_E_DOWNLOAD_FAILURE = -2146697208;
  INET_E_INVALID_REQUEST = -2146697204;
  INET_E_INVALID_URL = -2146697214;
  INET_E_NO_SESSION = -2146697213;
  INET_E_NO_VALID_MEDIA = -2146697206;
  INET_E_OBJECT_NOT_FOUND = -2146697210;
  INET_E_REDIRECT_FAILED = -2146697196;
  INET_E_REDIRECT_TO_DIR = -2146697195;
  INET_E_RESOURCE_NOT_FOUND = -2146697211; //**
  INET_E_RESULT_DISPATCHED = -2146697704;
  INET_E_SECURITY_PROBLEM = -2146697202; //**
  INET_E_TERMINATED_BIND = -2146697192;
  INET_E_UNKNOWN_PROTOCOL = -2146697203;
  INET_E_USE_EXTEND_BINDING = -2146697193;
  INTERNET_OPTION_PER_CONNECTION_OPTION = 75;
  INTERNET_OPTION_REFRESH = 37;
  INTERNET_OPTION_SETTINGS_CHANGED = 39;
  INTERNET_PER_CONN_AUTOCONFIG_URL = 4;
  INTERNET_PER_CONN_AUTODISCOVERY_FLAGS = 5;
  INTERNET_PER_CONN_FLAGS = 1;
  INTERNET_PER_CONN_PROXY_BYPASS = 3;
  INTERNET_PER_CONN_PROXY_SERVER = 2;
  INTERNET_SCHEME_PARTIAL = -2;
  INTERNET_SCHEME_UNKNOWN = -1;
  INTERNET_SCHEME_DEFAULT = 0;
  INTERNET_SCHEME_FTP = 1;
  INTERNET_SCHEME_GOPHER = 2;
  INTERNET_SCHEME_HTTP = 3;
  INTERNET_SCHEME_HTTPS = 4;
  INTERNET_SCHEME_FILE = 5;
  INTERNET_SCHEME_NEWS = 6;
  INTERNET_SCHEME_MAILTO = 7;
  INTERNET_SCHEME_SOCKS = 8;
  INTERNET_SCHEME_JAVASCRIPT = 9;
  INTERNET_SCHEME_VBSCRIPT = 10;
  INTERNET_SCHEME_RES = 11;
  INTERNET_SCHEME_FIRST = INTERNET_SCHEME_FTP;
  INTERNET_SCHEME_LAST = INTERNET_SCHEME_MAILTO;
  INTERNET_SCHEME_ABOUT = 24;
  INTERNET_SCHEME_COOKIE = 25;
  INTERNET_SCHEME_CUSTOM_FIRST = INTERNET_SCHEME_ABOUT;
  INTERNET_SCHEME_CUSTOM_LAST = INTERNET_SCHEME_COOKIE;
  INTERNET_STATE_CONNECTED = $1;
  INTERNET_STATE_DISCONNECTED_BY_USER = $10;
  INSTALL_SCOPE_INVALID = 0;
  INSTALL_SCOPE_MACHINE = 1;
  INSTALL_SCOPE_USER = 2;
  ISDigit = ['0'..'9', '-', '+'];
  ISO_FORCE_DISCONNECTED = $1;
  IURL_INVOKECOMMAND_FL_ALLOW_UI = $0001;
  IURL_INVOKECOMMAND_FL_DDEWAIT = $0004; // pass DDEWAIT to ShellExec
  IURL_INVOKECOMMAND_FL_USE_DEFAULT_VERB = $0002; // Ignore pcszVerb
  IURL_SETURL_FL_GUESS_PROTOCOL = $0001; // Guess protocol if missing
  IURL_SETURL_FL_USE_DEFAULT_PROTOCOL = $0002; // Use default protocol if missing
  MIMEASSOCDLG_FL_REGISTER_ASSOC = $0001;
  MinsPerHour = 60;
  MOUSE_XBUTTONNEXT = $20000;
  MOUSE_XBUTTONPREV = $10000;
  MSecsPerSec = 1000;
  navAllowAutosearch = $00000010;
  navBrowserBar = $00000020;
  navNoHistory = $00000002;
  navNoReadFromCache = $00000004;
  navNoWriteToCache = $00000008;
  navOpenInNewWindow = $00000001;
  NO_COMMAND = 0;
  PathDelim  = {$IFDEF MSWINDOWS} '\'; {$ELSE} '/'; {$ENDIF}
  PROXY_TYPE_AUTO_DETECT = $00000008;
  PROXY_TYPE_AUTO_PROXY_URL = $00000004;
  PROXY_TYPE_DIRECT = $00000001;
  PROXY_TYPE_PROXY = $00000002;
  QUERY_EXPIRATION_DATE = 1;
  QUERY_TIME_OF_LAST_CHANGE = 2;
  QUERY_CONTENT_ENCODING = 3;
  QUERY_CONTENT_TYPE = 4;
  QUERY_REFRESH = 5;
  QUERY_RECOMBINE = 6;
  QUERY_CAN_NAVIGATE = 7;
  QUERY_USES_NETWORK = 8;
  QUERY_IS_CACHED = 9;
  QUERY_IS_INSTALLEDENTRY = 10;
  QUERY_IS_CACHED_OR_MAPPED = 11;
  QUERY_USES_CACHE = 12;
  QUERY_IS_SECURE = 13;
  QUERY_IS_SAFE = 14;
  QUERY_USES_HISTORYFOLDER = 15;
  QUICK_LAUNCH_ROOT = 'Software\MicroSoft\Windows\CurrentVersion\GrpConv';
  READYSTATE_COMPLETE = $00000004;
  READYSTATE_INTERACTIVE = $00000003;
  READYSTATE_LOADED = $00000002;
  READYSTATE_LOADING = $00000001;
  READYSTATE_UNINITIALIZED = $00000000;
  RegMail = 'Software\Microsoft\Windows\CurrentVersion\UnreadMail\';
  SecsPerMin = 60;
  SHACF_AUTOAPPEND_FORCE_OFF = $80000000; // Ignore the registry default and force the feature off. (Also know as AutoComplete)
  SHACF_AUTOAPPEND_FORCE_ON = $40000000; // Ignore the registry default and force the feature on. (Also know as AutoComplete)
  SHACF_AUTOSUGGEST_FORCE_OFF = $20000000; // Ignore the registry default and force the feature off.
  SHACF_AUTOSUGGEST_FORCE_ON = $10000000; // Ignore the registry default and force the feature on.
  SHACF_DEFAULT = $00000000; // Currently (SHACF_FILESYSTEM | SHACF_URLALL)
  SHACF_FILESYSTEM = $00000001; // This includes the File System as well as the rest of the shell (Desktop\My Computer\Control Panel\)
  SHACF_URLHISTORY = $00000002; // URLs in the User's History
  SHACF_URLMRU = $00000004; // URLs in the User's Recently Used list.
  SHACF_USETAB = $00000008;
  SHACF_URLALL = (SHACF_URLHISTORY + SHACF_URLMRU);
  SHELL_FOLDERS_ROOT = 'Software\MicroSoft\Windows\CurrentVersion\Explorer';
  Shell32 = 'shell32.dll';
  SHFreeShared_Index = 523;
  SHLockShared_Index = 521;
  SHUnlockShared_Index = 522;
  SITE_ADDRESS = 'http://bsalsa.com/';
  STATURL_QUERYFLAG_ISCACHED = $00010000;
  STATURL_QUERYFLAG_NOTITLE = $00040000;
  STATURL_QUERYFLAG_NOURL = $00020000;
  STATURL_QUERYFLAG_TOPLEVEL = $00080000;
  STATURLFLAG_ISCACHED = $00000001;
  STATURLFLAG_ISTOPLEVEL = $00000002;
  TLEF_ABSOLUTE = $00000031;
  TLEF_INCLUDE_UNINVOKEABLE = $00000040;
  TLEF_RELATIVE_BACK = $00000010;
  TLEF_RELATIVE_FORE = $00000020;
  TLEF_RELATIVE_INCLUDE_CURRENT = $00000001;
  TRANSLATEURL_FL_GUESS_PROTOCOL = $0001; // Guess protocol if missing
  TRANSLATEURL_FL_USE_DEFAULT_PROTOCOL = $0002; // Use default protocol if missing
  UNKNOWN_RESPOND = 262632;
  URLACTION_CLIENT_CERT_PROMPT = $00001A04;
  URLACTION_COOKIES = $00001A02;
  URLACTION_COOKIES_SESSION = $00001A03;
  URLACTION_CROSS_DOMAIN_DATA = $00001406;
  URLACTION_HTML_SUBFRAME_NAVIGATE = $00001607;
  URLACTION_HTML_USERDATA_SAVE = $00001606;
  URLACTION_SCRIPT_PASTE = $00001407;
  URLASSOCDLG_FL_REGISTER_ASSOC = $0002;
  URLASSOCDLG_FL_USE_DEFAULT_NAME = $0001;
  urldll = 'url.dll';
  UrlMonLib = 'URLMON.DLL';
  URL_MK_LEGACY = 0;
  URL_MK_UNIFORM = 1;
  URL_MK_NO_CANONICALIZE = 2;
  URLPOLICY_ACTIVEX_CHECK_LIST = $00010000;
  URLTEMPLATE_MEDLOW = $10500;
  USER_AGENT_IE6 = 'User-agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)';
  USER_AGENT_IE7 = 'User-agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)';
  USER_AGENT_PATH = '\Software\Microsoft\Windows\CurrentVersion\Internet Settings\User Agent\Post Platform';
  VER_GREATER_EQUAL = 3;
  VER_MAJORVERSION = $0000002;
  VER_MINORVERSION = $0000001;
  VER_SERVICEPACKMAJOR = $0000020;
  VER_SERVICEPACKMINOR = $0000010;
  VIEW_COMMAND = 1;
  WEB_SITE = 'Help & Support: http://www.bsalsa.com/';
  WM_USER = $0400;
  WM_USER_STARTWALKING = WM_USER + 1;
  WM_XBUTTONDBLCLK = $020D;
  WM_XBUTTONDOWN = $020B;
  WM_XBUTTONUP = $020C;

const
  MinsPerDay = HoursPerDay * MinsPerHour;
  SecsPerDay = MinsPerDay * SecsPerMin;
  MSecsPerDay = SecsPerDay * MSecsPerSec;

const
  INTERNET_CONNECTION_MODEM = 1;
{$EXTERNALSYM INTERNET_CONNECTION_MODEM}
  INTERNET_CONNECTION_LAN = 2;
{$EXTERNALSYM INTERNET_CONNECTION_LAN}
  INTERNET_CONNECTION_PROXY = 4;
{$EXTERNALSYM INTERNET_CONNECTION_PROXY}
  INTERNET_CONNECTION_MODEM_BUSY = 8;
{$EXTERNALSYM INTERNET_CONNECTION_MODEM_BUSY}
  INTERNET_RAS_INSTALLED = 16;
{$EXTERNALSYM INTERNET_RAS_INSTALLED}
  INTERNET_CONNECTION_OFFLINE = 32;
{$EXTERNALSYM INTERNET_CONNECTION_OFFLINE}
  INTERNET_CONNECTION_CONFIGURED = 64;
{$EXTERNALSYM INTERNET_CONNECTION_CONFIGURED}

{$EXTERNALSYM MAX_SIZE_SECURITY_ID}
  MAX_SIZE_SECURITY_ID = 512;
{$EXTERNALSYM PUAF_DEFAULT}
  PUAF_DEFAULT = $00000000;
{$EXTERNALSYM PUAF_NOUI}
  PUAF_NOUI = $00000001;
{$EXTERNALSYM PUAF_ISFILE}
  PUAF_ISFILE = $00000002;
{$EXTERNALSYM PUAF_WARN_IF_DENIED}
  PUAF_WARN_IF_DENIED = $00000004;
{$EXTERNALSYM PUAF_FORCEUI_FOREGROUND}
  PUAF_FORCEUI_FOREGROUND = $00000008;
{$EXTERNALSYM PUAF_CHECK_TIFS}
  PUAF_CHECK_TIFS = $00000010;
{$EXTERNALSYM SZM_CREATE}
  SZM_CREATE = $00000000;
{$EXTERNALSYM SZM_DELETE}
  SZM_DELETE = $00000001;
{$EXTERNALSYM URLACTION_MIN}
  URLACTION_MIN = $00001000;
{$EXTERNALSYM URLACTION_DOWNLOAD_MIN}
  URLACTION_DOWNLOAD_MIN = $00001000;
{$EXTERNALSYM URLACTION_DOWNLOAD_SIGNED_ACTIVEX}
  URLACTION_DOWNLOAD_SIGNED_ACTIVEX = $00001001;
{$EXTERNALSYM URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX}
  URLACTION_DOWNLOAD_UNSIGNED_ACTIVEX = $00001004;
{$EXTERNALSYM URLACTION_DOWNLOAD_CURR_MAX}
  URLACTION_DOWNLOAD_CURR_MAX = $00001004;
{$EXTERNALSYM URLACTION_DOWNLOAD_MAX}
  URLACTION_DOWNLOAD_MAX = $000011FF;
{$EXTERNALSYM URLACTION_ACTIVEX_MIN}
  URLACTION_ACTIVEX_MIN = $00001200;
{$EXTERNALSYM URLACTION_ACTIVEX_RUN}
  URLACTION_ACTIVEX_RUN = $00001200;
{$EXTERNALSYM URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY}
  URLACTION_ACTIVEX_OVERRIDE_OBJECT_SAFETY = $00001201;
{$EXTERNALSYM URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY}
  URLACTION_ACTIVEX_OVERRIDE_DATA_SAFETY = $00001202;
{$EXTERNALSYM URLACTION_ACTIVEX_OVERRIDE_SCRIPT_SAFETY}
  URLACTION_ACTIVEX_OVERRIDE_SCRIPT_SAFETY = $00001203;
{$EXTERNALSYM URLACTION_SCRIPT_OVERRIDE_SAFETY}
  URLACTION_SCRIPT_OVERRIDE_SAFETY = $00001401; //
{$EXTERNALSYM URLACTION_ACTIVEX_CONFIRM_NOOBJECTSAFETY}
  URLACTION_ACTIVEX_CONFIRM_NOOBJECTSAFETY = $00001204;
{$EXTERNALSYM URLACTION_ACTIVEX_TREATASUNTRUSTED}
  URLACTION_ACTIVEX_TREATASUNTRUSTED = $00001205;
{$EXTERNALSYM URLACTION_ACTIVEX_CURR_MAX}
  URLACTION_ACTIVEX_CURR_MAX = $00001205;
{$EXTERNALSYM URLACTION_ACTIVEX_MAX}
  URLACTION_ACTIVEX_MAX = $000013FF;
{$EXTERNALSYM URLACTION_SCRIPT_MIN}
  URLACTION_SCRIPT_MIN = $00001400;
{$EXTERNALSYM URLACTION_SCRIPT_RUN}
  URLACTION_SCRIPT_RUN = $00001400;
{$EXTERNALSYM URLACTION_SCRIPT_JAVA_USE}
  URLACTION_SCRIPT_JAVA_USE = $00001402;
{$EXTERNALSYM URLACTION_SCRIPT_SAFE_ACTIVEX}
  URLACTION_SCRIPT_SAFE_ACTIVEX = $00001405;
{$EXTERNALSYM URLACTION_SCRIPT_CURR_MAX}
  URLACTION_SCRIPT_CURR_MAX = $00001405;
{$EXTERNALSYM URLACTION_SCRIPT_MAX}
  URLACTION_SCRIPT_MAX = $000015FF;
{$EXTERNALSYM URLACTION_HTML_MIN}
  URLACTION_HTML_MIN = $00001600;
{$EXTERNALSYM URLACTION_HTML_SUBMIT_FORMS}
  URLACTION_HTML_SUBMIT_FORMS = $00001601; // aggregate next two
{$EXTERNALSYM URLACTION_HTML_SUBMIT_FORMS_FROM}
  URLACTION_HTML_SUBMIT_FORMS_FROM = $00001602; //
{$EXTERNALSYM URLACTION_HTML_SUBMIT_FORMS_TO}
  URLACTION_HTML_SUBMIT_FORMS_TO = $00001603; //
{$EXTERNALSYM URLACTION_HTML_FONT_DOWNLOAD}
  URLACTION_HTML_FONT_DOWNLOAD = $00001604;
{$EXTERNALSYM URLACTION_HTML_JAVA_RUN}
  URLACTION_HTML_JAVA_RUN = $00001605; // derive from Java custom policy;
{$EXTERNALSYM URLACTION_HTML_CURR_MAX}
  URLACTION_HTML_CURR_MAX = $00001605;
{$EXTERNALSYM URLACTION_HTML_MAX}
  URLACTION_HTML_MAX = $000017FF;
{$EXTERNALSYM URLACTION_SHELL_MIN}
  URLACTION_SHELL_MIN = $00001800;
{$EXTERNALSYM URLACTION_SHELL_INSTALL_DTITEMS}
  URLACTION_SHELL_INSTALL_DTITEMS = $00001800;
{$EXTERNALSYM URLACTION_SHELL_MOVE_OR_COPY}
  URLACTION_SHELL_MOVE_OR_COPY = $00001802;
{$EXTERNALSYM URLACTION_SHELL_FILE_DOWNLOAD}
  URLACTION_SHELL_FILE_DOWNLOAD = $00001803;
{$EXTERNALSYM URLACTION_SHELL_VERB}
  URLACTION_SHELL_VERB = $00001804;
{$EXTERNALSYM URLACTION_SHELL_WEBVIEW_VERB}
  URLACTION_SHELL_WEBVIEW_VERB = $00001805;
{$EXTERNALSYM URLACTION_SHELL_CURR_MAX}
  URLACTION_SHELL_CURR_MAX = $00001805;
{$EXTERNALSYM URLACTION_SHELL_MAX}
  URLACTION_SHELL_MAX = $000019FF;
{$EXTERNALSYM URLACTION_NETWORK_MIN}
  URLACTION_NETWORK_MIN = $00001A00;
{$EXTERNALSYM URLACTION_CREDENTIALS_USE}
  URLACTION_CREDENTIALS_USE = $00001A00;
{$EXTERNALSYM URLPOLICY_CREDENTIALS_SILENT_LOGON_OK}
  URLPOLICY_CREDENTIALS_SILENT_LOGON_OK = $00000000;
{$EXTERNALSYM URLPOLICY_CREDENTIALS_MUST_PROMPT_USER}
  URLPOLICY_CREDENTIALS_MUST_PROMPT_USER = $00010000;
{$EXTERNALSYM URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT}
  URLPOLICY_CREDENTIALS_CONDITIONAL_PROMPT = $00020000;
{$EXTERNALSYM URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY}
  URLPOLICY_CREDENTIALS_ANONYMOUS_ONLY = $00030000;
{$EXTERNALSYM URLACTION_AUTHENTICATE_CLIENT}
  URLACTION_AUTHENTICATE_CLIENT = $00001A01;
{$EXTERNALSYM URLPOLICY_AUTHENTICATE_CLEARTEXT_OK}
  URLPOLICY_AUTHENTICATE_CLEARTEXT_OK = $00000000;
{$EXTERNALSYM URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE}
  URLPOLICY_AUTHENTICATE_CHALLENGE_RESPONSE = $00010000;
{$EXTERNALSYM URLPOLICY_AUTHENTICATE_MUTUAL_ONLY}
  URLPOLICY_AUTHENTICATE_MUTUAL_ONLY = $00030000;
{$EXTERNALSYM URLACTION_NETWORK_CURR_MAX}
  URLACTION_NETWORK_CURR_MAX = $00001A01;
{$EXTERNALSYM URLACTION_NETWORK_MAX}
  URLACTION_NETWORK_MAX = $00001BFF;
{$EXTERNALSYM URLACTION_JAVA_MIN}
  URLACTION_JAVA_MIN = $00001C00;
{$EXTERNALSYM URLACTION_JAVA_PERMISSIONS}
  URLACTION_JAVA_PERMISSIONS = $00001C00;
{$EXTERNALSYM URLPOLICY_JAVA_PROHIBIT}
  URLPOLICY_JAVA_PROHIBIT = $00000000;
{$EXTERNALSYM URLPOLICY_JAVA_HIGH}
  URLPOLICY_JAVA_HIGH = $00010000;
{$EXTERNALSYM URLPOLICY_JAVA_MEDIUM}
  URLPOLICY_JAVA_MEDIUM = $00020000;
{$EXTERNALSYM URLPOLICY_JAVA_LOW}
  URLPOLICY_JAVA_LOW = $00030000;
{$EXTERNALSYM URLPOLICY_JAVA_CUSTOM}
  URLPOLICY_JAVA_CUSTOM = $00800000;
{$EXTERNALSYM URLACTION_JAVA_CURR_MAX}
  URLACTION_JAVA_CURR_MAX = $00001C00;
{$EXTERNALSYM URLACTION_JAVA_MAX}
  URLACTION_JAVA_MAX = $00001CFF;
{$EXTERNALSYM URLACTION_INFODELIVERY_MIN}
  URLACTION_INFODELIVERY_MIN = $00001D00;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_ADDING_CHANNELS}
  URLACTION_INFODELIVERY_NO_ADDING_CHANNELS = $00001D00;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_EDITING_CHANNELS}
  URLACTION_INFODELIVERY_NO_EDITING_CHANNELS = $00001D01;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS}
  URLACTION_INFODELIVERY_NO_REMOVING_CHANNELS = $00001D02;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_ADDING_SUBSCRIPTIONS}
  URLACTION_INFODELIVERY_NO_ADDING_SUBSCRIPTIONS = $00001D03;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_EDITING_SUBSCRIPTIONS}
  URLACTION_INFODELIVERY_NO_EDITING_SUBSCRIPTIONS = $00001D04;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS}
  URLACTION_INFODELIVERY_NO_REMOVING_SUBSCRIPTIONS = $00001D05;
{$EXTERNALSYM URLACTION_INFODELIVERY_NO_CHANNEL_LOGGING}
  URLACTION_INFODELIVERY_NO_CHANNEL_LOGGING = $00001D06;
{$EXTERNALSYM URLACTION_INFODELIVERY_CURR_MAX}
  URLACTION_INFODELIVERY_CURR_MAX = $00001D06;
{$EXTERNALSYM URLACTION_INFODELIVERY_MAX}
  URLACTION_INFODELIVERY_MAX = $00001DFF;
{$EXTERNALSYM URLACTION_CHANNEL_SOFTDIST_MIN}
  URLACTION_CHANNEL_SOFTDIST_MIN = $00001E00;
{$EXTERNALSYM URLACTION_CHANNEL_SOFTDIST_PERMISSIONS}
  URLACTION_CHANNEL_SOFTDIST_PERMISSIONS = $00001E05;
{$EXTERNALSYM URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT}
  URLPOLICY_CHANNEL_SOFTDIST_PROHIBIT = $00010000;
{$EXTERNALSYM URLPOLICY_CHANNEL_SOFTDIST_PRECACHE}
  URLPOLICY_CHANNEL_SOFTDIST_PRECACHE = $00020000;
{$EXTERNALSYM URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL}
  URLPOLICY_CHANNEL_SOFTDIST_AUTOINSTALL = $00030000;
{$EXTERNALSYM URLACTION_CHANNEL_SOFTDIST_MAX}
  URLACTION_CHANNEL_SOFTDIST_MAX = $00001EFF;
{$EXTERNALSYM URLPOLICY_ALLOW}
  URLPOLICY_ALLOW = $00;
{$EXTERNALSYM URLPOLICY_QUERY}
  URLPOLICY_QUERY = $01;
{$EXTERNALSYM URLPOLICY_DISALLOW}
  URLPOLICY_DISALLOW = $03;
{$EXTERNALSYM URLPOLICY_NOTIFY_ON_ALLOW}
  URLPOLICY_NOTIFY_ON_ALLOW = $10;
{$EXTERNALSYM URLPOLICY_NOTIFY_ON_DISALLOW}
  URLPOLICY_NOTIFY_ON_DISALLOW = $20;
{$EXTERNALSYM URLPOLICY_LOG_ON_ALLOW}
  URLPOLICY_LOG_ON_ALLOW = $40;
{$EXTERNALSYM URLPOLICY_LOG_ON_DISALLOW}
  URLPOLICY_LOG_ON_DISALLOW = $80;
{$EXTERNALSYM URLPOLICY_MASK_PERMISSIONS}
  URLPOLICY_MASK_PERMISSIONS = $0F;
{$EXTERNALSYM URLZONE_PREDEFINED_MIN}
  URLZONE_PREDEFINED_MIN = 0;
{$EXTERNALSYM URLZONE_LOCAL_MACHINE}
  URLZONE_LOCAL_MACHINE = 0;
{$EXTERNALSYM URLZONE_INTRANET}
  URLZONE_INTRANET = URLZONE_LOCAL_MACHINE + 1;
{$EXTERNALSYM URLZONE_TRUSTED}
  URLZONE_TRUSTED = URLZONE_INTRANET + 1;
{$EXTERNALSYM URLZONE_INTERNET}
  URLZONE_INTERNET = URLZONE_TRUSTED + 1;
{$EXTERNALSYM URLZONE_UNTRUSTED}
  URLZONE_UNTRUSTED = URLZONE_INTERNET + 1;
{$EXTERNALSYM URLZONE_PREDEFINED_MAX}
  URLZONE_PREDEFINED_MAX = 999;
{$EXTERNALSYM URLZONE_USER_MIN}
  URLZONE_USER_MIN = 1000;
{$EXTERNALSYM URLZONE_USER_MAX}
  URLZONE_USER_MAX = 10000;
{$EXTERNALSYM URLTEMPLATE_CUSTOM}
  URLTEMPLATE_CUSTOM = $00000000;
{$EXTERNALSYM URLTEMPLATE_PREDEFINED_MIN}
  URLTEMPLATE_PREDEFINED_MIN = $00010000;
{$EXTERNALSYM URLTEMPLATE_LOW}
  URLTEMPLATE_LOW = $00010000;
{$EXTERNALSYM URLTEMPLATE_MEDIUM}
  URLTEMPLATE_MEDIUM = $00011000;
{$EXTERNALSYM URLTEMPLATE_HIGH}
  URLTEMPLATE_HIGH = $00012000;
{$EXTERNALSYM URLTEMPLATE_PREDEFINED_MAX}
  URLTEMPLATE_PREDEFINED_MAX = $00020000;
{$EXTERNALSYM MAX_ZONE_PATH}
  MAX_ZONE_PATH = 260;
{$EXTERNALSYM MAX_ZONE_DESCRIPTION}
  MAX_ZONE_DESCRIPTION = 200;
{$EXTERNALSYM ZAFLAGS_CUSTOM_EDIT}
  ZAFLAGS_CUSTOM_EDIT = $00000001;
{$EXTERNALSYM ZAFLAGS_ADD_SITES}
  ZAFLAGS_ADD_SITES = $00000002;
{$EXTERNALSYM ZAFLAGS_REQUIRE_VERIFICATION}
  ZAFLAGS_REQUIRE_VERIFICATION = $00000004;
{$EXTERNALSYM ZAFLAGS_INCLUDE_PROXY_OVERRIDE}
  ZAFLAGS_INCLUDE_PROXY_OVERRIDE = $00000008;
{$EXTERNALSYM ZAFLAGS_INCLUDE_INTRANET_SITES}
  ZAFLAGS_INCLUDE_INTRANET_SITES = $00000010;
{$EXTERNALSYM ZAFLAGS_NO_UI}
  ZAFLAGS_NO_UI = $00000020;
{$EXTERNALSYM ZAFLAGS_SUPPORTS_VERIFICATION}
  ZAFLAGS_SUPPORTS_VERIFICATION = $00000040;
{$EXTERNALSYM ZAFLAGS_UNC_AS_INTRANET}
  ZAFLAGS_UNC_AS_INTRANET = $00000080;
{$EXTERNALSYM URLZONEREG_DEFAULT}
  URLZONEREG_DEFAULT = 0;
{$EXTERNALSYM URLZONEREG_HKLM}
  URLZONEREG_HKLM = URLZONEREG_DEFAULT + 1;
{$EXTERNALSYM URLZONEREG_HKCU}
  URLZONEREG_HKCU = URLZONEREG_HKLM + 1;

const
  IID_IWebBrowserEventsService: TGUID = '{87CC5D04-EAFA-4833-9820-8F986530CC00}';
  IID_ITravelLogEntry: TGUID = '{7EBFDD87-AD18-11d3-A4C5-00C04F72D6B8}';
  IID_IEnumTravelLogEntry: TGUID = '{7EBFDD85-AD18-11d3-A4C5-00C04F72D6B8}';
  IID_ITravelLogStg: TGUID = '{7EBFDD80-AD18-11d3-A4C5-00C04F72D6B8}';
  IID_IInputObjectSite: TGUID = (D1: $F1DB8392; D2: $7331; D3: $11D0; D4: ($8C,
    $99, $00, $A0, $C9, $2D, $BF, $E8));
  IID_IQueryInfo: TGUID = (D1: $00021500; D2: $0000; D3: $0000; D4: ($C0, $00,
    $00, $00, $00, $00, $00, $46));
  IID_IUniformResourceLocatorA: TGUID = (D1: $FBF23B80; D2: $E3F0; D3: $101B;
    D4: ($84, $88, $00, $AA, $00, $3E, $56, $F8));
  IID_IUniformResourceLocatorW: TGUID = (D1: $CABB0DA0; D2: $DA57; D3: $11CF;
    D4: ($99, $74, $00, $20, $AF, $D7, $97, $62));
  IID_IUrlHistoryNotify: TGUID = (D1: $BC40BEC1; D2: $C493; D3: $11D0; D4: ($83,
    $1B, $00, $C0, $4F, $D5, $AE, $38));
  IID_IUrlHistoryStg: TGUID = (D1: $3C374A41; D2: $BAE4; D3: $11CF; D4: ($BF,
    $7D, $00, $AA, $00, $69, $46, $EE));
  IID_IUrlHistoryStg2: TGUID = (D1: $AFA0DC11; D2: $C313; D3: $831A; D4: ($83,
    $1A, $00, $C0, $4F, $D5, $AE, $38));
  SID_IHTMLOMWindowServices = '{3050F5FC-98B5-11CF-BB82-00AA00BDCE0B}';
  CLSID_InternetShortCut: TGUID = (d1: $FBF23B40; D2: $E3F0; D3: $101B; D4:
    ($84, $88, $00, $AA, $00, $3E, $56, $F8));
  CGID_DocHostCommandHandler: TGUID = (D1: $F38BC242; D2: $B950; D3: $11D1; D4:
    ($89, $18, $00, $C0, $4F, $C2, $C8, $36));
  CLSID_CUrlHistory: TGUID = '{3C374A40-BAE4-11CF-BF7D-00AA006946EE}';
  CLSID_ShellUIHelper: TGUID = '{64AB4BB7-111E-11D1-8F79-00C04FC2FBE1}';
  CLSID_WebBrowser: TGUID = '{ED016940-BD5B-11cf-BA4E-00C04FD70816}';
  CGID_MSHTML: TGUID = '{DE4BA900-59CA-11CF-9592-444553540000}';
  IID_IoleCommandTarget: TGUID = '{B722BCCB-4E68-101B-A2BC-00AA00404770}';
  GUID_TriEditCommandGroup: TGUID = '{2582F1C0-084E-11d1-9A0E-006097C9B344}';
  IID_IACList: TGUID = '{77A130B0-94FD-11D0-A544-00C04FD7d062}';
  IID_IACList2: TGUID = '{470141a0-5186-11d2-bbb6-0060977b464c}';
  IID_ICustomDoc: TGUID = '{3050f3f0-98b5-11cf-bb82-00aa00bdce0b}';
  IID_IDocHostShowUI: TGUID = '{c4d244b0-d43e-11cf-893b-00aa00bdce1a}';
  IID_IDocHostUIHandler: TGUID = '{bd3f23c0-d43e-11cf-893b-00aa00bdce1a}';
  IID_IDocHostUIHandler2: TGUID = '{3050f6d0-98b5-11cf-bb82-00aa00bdce0b}';
  IID_IDownloadManager: TGUID = (D1: $988934A4; D2: $064B; D3: $11D3; D4: ($BB,
    $80, $0, $10, $4B, $35, $E7, $F9));
  IID_IEnumStatUrl: TGUID = (D1: $3C374A42; D2: $BAE4; D3: $11CF; D4: ($BF, $7D,
    $00, $AA, $00, $69, $46, $EE));
  IID_IHTMLOMWindowServices: TGUID = '{3050F5FC-98B5-11CF-BB82-00AA00BDCE0B}';
  IID_IHlinkFrame: TGUID = '{79eac9c5-baf9-11ce-8c82-00aa004ba90b}';
  IID_INewWindowManager: TGUID = '{D2BC4C84-3F72-4a52-A604-7BCBF3982CBB}';
  IID_IProtectFocus: TGUID = '{D81F90A3-8156-44F7-AD28-5ABB87003274}';
  SID_STravelLogCursor: TGUID = '{7EBFDD80-AD18-11d3-A4C5-00C04F72D6B8}';
  SID_IEnumStatUrl = '{3C374A42-BAE4-11CF-BF7D-00AA006946EE}';
  SID_IURLHistoryNotify = '{BC40BEC1-C493-11d0-831B-00C04FD5AE38}';
  SID_IUrlHistoryStg = '{3C374A41-BAE4-11CF-BF7D-00AA006946EE}';
  SID_IUrlHistoryStg2 = '{AFA0DC11-C313-11d0-831A-00C04FD5AE38}';
  SID_SDownloadManager = '{988934A4-064B-11D3-BB80-00104B35E7F9}';
  SID_IUniformResourceLocatorA = '{FBF23B80-E3F0-101B-8488-00AA003E56F8}';
  SID_IUniformResourceLocatorW = '{CABB0DA0-DA57-11CF-9974-0020AFD79762}';
{$IFDEF UNICODE}
  SID_IUniformResourceLocator = SID_IUniformResourceLocatorW;
{$ELSE}
  SID_IUniformResourceLocator = SID_IUniformResourceLocatorA;
{$ENDIF}
  IID_IUniformResourceLocator: TGUID = SID_IUniformResourceLocator;

implementation

end.
