{******************************************************************************}
{ Package:      Clinical Case Registries Custom Components                     }
{ Date Created: November 18, 2004                                              }
{ Site Name:    Hines OIFO                                                     }
{ Developers:   Sergey Gavrilov                                                }
{ Description:  This unit defines custom components for saving/restoring       }
{               component or form state.                                       }
{ Note:                                                                        }
{******************************************************************************}

unit uROR_State;

{$I Components.inc}

interface
{$IFNDEF NOORPHEUS}

uses
  SysUtils, Classes, ovcbase, ovcstate;

type

  TCCRComponentState = class(TOvcComponentState)
  private

    fOnSaveState:    TNotifyEvent;
    fOnRestoreState: TNotifyEvent;

  protected

    procedure RestoreStatePrim; override;
    procedure SaveStatePrim; override;

  published

    property OnSaveState: TNotifyEvent
      read fOnSaveState  write fOnSaveState;

    property OnRestoreState: TNotifyEvent
      read fOnRestoreState  write fOnRestoreState;

  end;

  TCCRFormState = class(TOvcFormState)
  private

    fOnSaveState:    TNotifyEvent;
    fOnRestoreState: TNotifyEvent;

  protected

    procedure RestoreStatePrim; override;
    procedure SaveStatePrim; override;

  published

    property OnSaveState: TNotifyEvent
      read fOnSaveState  write fOnSaveState;

    property OnRestoreState: TNotifyEvent
      read fOnRestoreState  write fOnRestoreState;

  end;

{$ENDIF}
implementation
{$IFNDEF NOORPHEUS}

////////////////////////////// TCCRComponentState \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TCCRComponentState.RestoreStatePrim;
begin
  if not Assigned(Storage) then
    Exit;

  try
    Storage.Open;
    try
      inherited;
      if Assigned(OnRestoreState) then
        OnRestoreState(Self);
    finally
      Storage.Close;
    end;
  except
  end;
end;

procedure TCCRComponentState.SaveStatePrim;
begin
  if not Assigned(Storage) then
    Exit;

  try
    Storage.Open;
    try
      inherited;
      if Assigned(OnSaveState) then
        OnSaveState(Self);
    finally
      Storage.Close;
    end;
  except
  end;
end;

///////////////////////////////// TCCRFormState \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TCCRFormState.RestoreStatePrim;
begin
  if not Assigned(Storage) then Exit;

  try
    Storage.Open;
    try
      inherited;
      if Assigned(OnRestoreState) then
        OnRestoreState(Self);
    finally
      Storage.Close;
    end;
  except
  end;
end;

procedure TCCRFormState.SaveStatePrim;
begin
  if not Assigned(Storage) then Exit;

  try
    Storage.Open;
    try
      inherited;
      if Assigned(OnSaveState) then
        OnSaveState(Self);
    finally
      Storage.Close;
    end;
  except
  end;
end;

{$ENDIF}
end.
