unit uROR_User;

interface

uses
  Classes, uROR_Common;

type

  TUserInfo = class(TPersistent)
  private

    fIEN:           String;
    fName:          String;
    fNickName:      String;
    fOfficePhone:   String;
    fStationNumber: String;
    fTimeout:       Integer;

  public

    constructor Create;

    function Load: Boolean;

    property IEN:  String               read fIEN;
    property Name: String               read fName;
    property NickName: String           read fNickName;
    property OfficePhone: String        read fOfficePhone;
    property StationNumber: String      read fStationNumber;
    property Timeout: Integer           read fTimeout;

  end;

function UserInfo: TUserInfo;

implementation

uses
  SysUtils, uROR_Utilities;

var
  vUserInfo: TUserInfo = nil;

////////////////////////////////// TUserInfo \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TUserInfo.Create;
begin
  inherited;
  fTimeout := 600;
end;

function TUserInfo.Load: Boolean;
var
  buf: String;
begin
  if Broker.CallProc('ROR GET USER INFO', ['']) then
    begin
      buf := Broker.Results[0];
      fIEN           := Piece(buf, U, 1);
      fName          := Piece(buf, U, 2);
      fOfficePhone   := Piece(buf, U, 3);
      fNickName      := Piece(buf, U, 4);
      fStationNumber := Piece(buf, U, 10);
      fTimeout       := StrToIntDef(Piece(buf, U, 5), 600);
      Result := True;
    end
  else
    Result := False;
end;

///////////////////////////// Functions/Procedures \\\\\\\\\\\\\\\\\\\\\\\\\\\\\

function UserInfo: TUserInfo;
begin
  if not Assigned(vUserInfo) then
    vUserInfo := TUserInfo.Create;
  Result := vUserInfo;
end;

//////////////////////////////// Initialization \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

initialization
finalization
  FreeAndNil(vUserInfo);

end.
