unit fROR_MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uROR_CustomContextor, uROR_Contextor, uROR_CustomBroker,
  uROR_Broker, uROR_CmdLineParams, ComCtrls, ExtCtrls, Menus, ActnList,
  VERGENCECONTEXTORLib_TLB, ovcfiler, ovcstore, uROR_VistAStore, ovcbase,
  ovcstate, uROR_State, Trpcb, CCOWRPCBroker, fROR_GridFrame, fROR_ParamsFrame,
  uROR_CustomListView, uROR_GridView, StdCtrls;

type

  TFormMain = class(TForm)

    ccrCmdLineParams: TCCRCmdLineParams;
    ccrBroker: TCCRBroker;
    ccrContextor: TCCRContextor;
    stsbrMain: TStatusBar;
    ccrContextorIndicator: TCCRContextorIndicator;
    aclMain: TActionList;
    acFileExit: TAction;
    acFileBreakLink: TAction;
    acFileRejoinApp: TAction;
    acFileRejoinGlobal: TAction;
    mnuMain: TMainMenu;
    mnuFile: TMenuItem;
    mnuFileRejoin: TMenuItem;
    mnuFileRejoinLocal: TMenuItem;
    mnuFileRejoinGlobal: TMenuItem;
    mnuFileBreakLink: TMenuItem;
    N1: TMenuItem;
    N4: TMenuItem;
    mnuFileExit: TMenuItem;
    ccrFormState: TCCRFormState;
    ccrFormLayout: TCCRVistAStore;
    pgctrlMain: TPageControl;
    tbshtGrid: TTabSheet;
    brkrMainBroker: TCCOWRPCBroker;
    tbshtParams: TTabSheet;

    procedure acFileCCOWUpdate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure acFileExitExecute(Sender: TObject);
    procedure acFileBreakLinkExecute(Sender: TObject);
    procedure acFileRejoinAppExecute(Sender: TObject);
    procedure acFileRejoinGlobalExecute(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ccrContextorCommitted(Sender: TObject);
    procedure ccrContextorPatientChanged(Sender: TObject);
    procedure ccrContextorPending(aSender: TObject;
      const aContextItemCollection: IDispatch);
    procedure ccrFormStateSaveState(Sender: TObject);
    procedure ccrFormStateRestoreState(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private

    fGridFrame:   TFrameGrid;
    fParamsFrame: TFrameParams;

    fPendingDFN: String;

  public

    procedure CloseModalWindows;
    function  Connect: Boolean;
    procedure EndPatientEdit;
    procedure SelectPatient(const aPatientIEN: String);
    procedure StartPatientEdit;

    property GridFrame: TFrameGrid  read fGridFrame;
    
    property ParamsFrame: TFrameParams  read fParamsFrame;

    { The PendingDFN property indicates an IEN (DFN) of a patient who must be
      selected as the current one after the modal forms, which block the patient
      context change, are closed.  See the StartPatientEdit, EndPatientEdit,
      and ccrContextorPatientChanged procedures for more details. }
    property PendingDFN: String  read fPendingDFN  write fPendingDFN;

  end;

var
  FormMain: TFormMain;

//////////////////////////////// Implementation \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

implementation

{$R *.dfm}

uses
  CommCtrl, uROR_Common, uROR_Debug, uROR_User, uROR_Utilities;

/////////////////////////////////// TFormMain \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFormMain.acFileBreakLinkExecute(Sender: TObject);
begin
  Contextor.Suspend;
end;

procedure TFormMain.acFileCCOWUpdate(Sender: TObject);
begin
  acFileBreakLink.Enabled := (Contextor.State = csParticipating);

  if Contextor.State = csSuspended then
    begin
      acFileRejoinGlobal.Enabled := True;
      acFileRejoinGlobal.Enabled := True;
      mnuFileRejoin.Enabled      := True;
    end
  else
    begin
      acFileRejoinGlobal.Enabled := False;
      acFileRejoinGlobal.Enabled := False;
      mnuFileRejoin.Enabled      := False;
    end;
end;

procedure TFormMain.acFileExitExecute(Sender: TObject);
begin
  Close;
end;

procedure TFormMain.acFileRejoinAppExecute(Sender: TObject);
begin
  Contextor.Resume(crmUseAppData);
end;

procedure TFormMain.acFileRejoinGlobalExecute(Sender: TObject);
begin
  Contextor.Resume(crmUseGlobalData);
end;

procedure TFormMain.ccrContextorCommitted(Sender: TObject);
begin
  { Perform the checks required by the single sign-on/sign-off. }
  if brkrMainBroker.WasUserDefined and brkrMainBroker.IsUserCleared then
    begin
      { Force closure of all modal dialogs and message boxes. }
      CloseModalWindows;
      { Terminate the application. }
      Application.Terminate;
    end;
end;

procedure TFormMain.ccrContextorPatientChanged(Sender: TObject);
begin
  { If this application conditionally accepted the patient context change
    request and is forced to change it now then close modal dialogs and
    message boxes that block the patient context change. }
  if Contextor.ForcedChange then
    CloseModalWindows;
  { If there were modal dialogs and message boxes that blocked the patient
    context change then postpone the change until the outermost EndPatientEdit
    is executed. Otherwise, select the new patient immediately. }
  if Contextor.ContextSubjects[CCOW_PATIENT].Locked then
    PendingDFN := Contextor.PatientDFN
  else
    SelectPatient(Contextor.PatientDFN);
end;

procedure TFormMain.ccrContextorPending(aSender: TObject;
  const aContextItemCollection: IDispatch);
var
  newDFN, newICN: String;
  ctx: IContextItemCollection;
begin
  ctx := IContextItemCollection(aContextItemCollection);
  with Contextor do
    begin
      { Get the awailable patient identifier(s) }
      PatientDFNFromContext(ctx, newDFN);
      PatientICNFromContext(ctx, newICN);
      { Check if the context change is actually required. }
      if (newDFN <> PatientDFN) or (newICN <> PatientICN) then
        { If there are modal dialogs and/or message boxex that block the
          patient context change then accept the request conditionally
          and inform the user about the potential data loss. }
        if ContextSubjects[CCOW_PATIENT].Locked then
          SetSurveyResponse('You might lose unsaved patient data.');
    end;
end;

procedure TFormMain.ccrFormStateRestoreState(Sender: TObject);
begin
  { Restore layouts of demonstration frames. }
  if Assigned(GridFrame) then
    GridFrame.LoadLayout(ccrFormLayout);
  if Assigned(ParamsFrame) then
    ParamsFrame.LoadLayout(ccrFormLayout);
end;

procedure TFormMain.ccrFormStateSaveState(Sender: TObject);
begin
  { Save layouts of demonstration frames. }
  if Assigned(GridFrame) then
    GridFrame.SaveLayout(ccrFormLayout);
  if Assigned(ParamsFrame) then
    ParamsFrame.SaveLayout(ccrFormLayout);
end;

procedure TFormMain.CloseModalWindows;
var
  i: Integer;
begin
  for i:=0 to Screen.CustomFormCount-1 do
    begin
      { Close all modal dialogs and message boxes that are displayed
        over this window (main application window). }
      if Screen.CustomForms[i] = Self then
        Break;
      if fsModal in Screen.CustomForms[i].FormState then
        Screen.CustomForms[i].Close;
    end;
end;

function TFormMain.Connect: Boolean;
var
  idt: ICCRDebugTrace;
  accType: Integer;
begin
  Result := False;
  idt := TCCRDebugTrace.Create('TFormMain.Connect');

  { Connect to a server. }
  if not Broker.Connect then
    begin
      idt.Error('Error during connecting to the server.');
      Exit;
    end;

  { Restore form state and frame layouts. }
  ccrFormState.RestoreState;

  { Load information about the user. }
  if not UserInfo.Load then
    begin
      idt.Error('Error during loading the user profile.');
      Exit;
    end;

  { Determine type of the VistA account. }
  if not Broker.CallProc('ROR PRODUCTION ACCOUNT', []) then
    accType := -1
  else if StrToIntDef(Broker.Results[0], 0) <> 0 then
    accType := 1
  else
    accType := 0;

  { Complete contextor initialization. }
  with Contextor do
    begin
      { If the station number is not available for any reason, then the
        participation in the context will be suspended and the contextor
        will be disabled. }
      if UserInfo.StationNumber <> '' then
        begin
          { Append the station number to the base name stored in
            the property ('patient.id.mrn.dfn_'). }
          DFNItemName := Piece(DFNItemName, '_') + '_' +
            UserInfo.StationNumber;
          case accType of
            -1: begin
                  NotRunningReason := 'Cannot determine type of the VistA' +
                    ' account (test or production)!';
                  idt.Error(NotRunningReason + ' Contextor is disabled.');
                  Enabled := False;
                end;
             0: DFNItemName := DFNItemName + '_test';
          end;
          { Process known subjects of the current context and extract
            available patient identifiers (convert the DFN to/from the
            ICN if necessary). }
          ProcessKnownSubjects(True);
        end
      else
        begin
          NotRunningReason := 'Station number is not available!';
          idt.Error(NotRunningReason + ' Contextor is disabled.');
          Enabled := False;
        end;
    end;

  { Update the status bar with the connection information.}
  with stsbrMain, Broker do
    begin
      Panels[1].Text := Format('  %s @ %d', [Server, ListenerPort]);
      Panels[2].Text := '  ' + UserInfo.Name;
    end;

  Result := True;
end;

procedure TFormMain.EndPatientEdit;
begin
  { Unlock the subject and if this is the outmost nesting level then process
    the postponed patient change request. }
  if not Contextor.ContextSubjects[CCOW_PATIENT].Unlock and
    (fPendingDFN <> '') then
    begin
      SelectPatient(fPendingDFN);
      fPendingDFN := '';
    end;
end;

procedure TFormMain.FormCreate(Sender: TObject);
begin
  TCCRDebugTrace.Create('TFormMain.FormCreate');

  { If command-line parameters help is requested, the applicattion will be
    closed after dispalying the help dialog box (see the CCRCompDemo.dpr).
    So, there is no need to perform any additional initialization. }
  if CmdLineParams.Help then
    Exit;

  { Create a debug log if the application is started in debug mode. Otherwise,
    a "dummy" log instance is created implicitly and any debug/trace output is
    discarded. }
  if CmdLineParams.DebugMode then
    TCCRDebugLog.Create;

  Caption := Application.Title;

  { Create demonstration frames and insert them into the corresponding tabs
    on the main form. }
  fGridFrame := TFrameGrid.Create(Self);
  with fGridFrame do
    begin
      Align  := alClient;
      Parent := tbshtGrid;
    end;
  fParamsFrame := TFrameParams.Create(Self);
  with fParamsFrame do
    begin
      Align  := alClient;
      Parent := tbshtParams;
    end;

  { Try to start the contextor and connect to the vault. If the Sentillion
    contextor is not installed on the users workstation or the vault is not
    available then the TCCRContextor will switch to idle mode and all requests
    will be ignored. }
  Contextor.Run;
end;

procedure TFormMain.FormDestroy(Sender: TObject);
begin
  FormMain := nil;
end;

procedure TFormMain.FormResize(Sender: TObject);
var
  i, wd: Integer;
  sbpr: TRect;
begin
  { Resize the leftmost panel of the status bar to fill all available space. }
  wd := stsbrMain.Width;
  for i:=stsbrMain.Panels.Count-1 downto 1 do
    wd := wd - stsbrMain.Panels[i].Width;
  stsbrMain.Panels[0].Width := wd;

  { Place the CCOW contextor indicator on the status bar of the main window. }
  stsbrMain.Perform(SB_GETRECT, 3, LPARAM(@sbpr));
  with ccrContextorIndicator do
    begin
      Parent := stsbrMain;
      Left := sbpr.Left + (sbpr.Right  - sbpr.Left - Width)  div 2;
      Top  := sbpr.Top  + (sbpr.Bottom - sbpr.Top  - Height) div 2;
    end;
end;

procedure TFormMain.SelectPatient(const aPatientIEN: String);
begin
  if Assigned(GridFrame) then
    GridFrame.SelectPatient(aPatientIEN);
end;

procedure TFormMain.StartPatientEdit;
begin
  { Lock the subject. }
  if not Contextor.ContextSubjects[CCOW_PATIENT].Lock then
    begin
      Application.ProcessMessages;
      fPendingDFN := '';
    end;
end;

end.
