program CCRCompDemo;

uses
  Forms,
  SysUtils,
  uROR_Debug,
  fROR_MainForm in 'fROR_MainForm.pas' {FormMain},
  uROR_Common in 'uROR_Common.pas',
  uROR_User in 'uROR_User.pas',
  fROR_GridFrame in 'fROR_GridFrame.pas' {FrameGrid: TFrame},
  fROR_EditPatientData in 'fROR_EditPatientData.pas' {FormPatientData},
  fROR_ParamsFrame in 'fROR_ParamsFrame.pas' {FrameParams: TFrame},
  fGMV_TimeOutManager in 'fGMV_TimeOutManager.pas' {frmGMV_TimeOutManager};

{$R *.res}

var
  NormalRun: Boolean = False;

begin
  Application.Initialize;
  Application.Title := 'CCR Components Demo';

  //--- Initialize the application
  Application.CreateForm(TFormMain, FormMain);
  try
    if CmdLineParams.Help then
      CmdLineParams.ShowHelp
    else if FormMain.Connect then
      begin
        { Insert additional after-connection initilization here }
        NormalRun := True;
      end;
  except
    on E: Exception do
      Application.ShowException(E);
  end;

  //--- Run the application
  if NormalRun then
    begin
      InitTimeout(nil);
      if UserInfo <> nil then
        UpdateTimeoutInterval(UserInfo.Timeout)
      else
        UpdateTimeoutInterval(300);
      try
        Application.Run;
      finally
        ShutDownTimeOut;
      end;
    end
  else
    begin
      Application.ShowMainForm := False;
      Application.Terminate;
      Application.Run;
    end;
end.
