; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

[Setup]
AppName=Clinical Case Registries
AppId=CCR
AppVerName=Clinical Case Registries 1.5*28
AppPublisher=VA Office of Enterprise Development
DefaultDirName={pf}\VistA\Clinical Case Registries
DefaultGroupName=Clinical Case Registries
OutputDir=C:\CCR\CCR\Install
OutputBaseFilename=CCRSetup
VersionInfoVersion=1.5.28
VersionInfoCompany=Veterans Health Administration
VersionInfoDescription=Install Clinical Case Registries 1.5 (Patch 28)
Compression=lzma
SolidCompression=yes
ShowLanguageDialog=yes

[Languages]
Name: english; MessagesFile: compiler:Default.isl

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons};

[Files]
Source: C:\CCR\CCR\Bin\ClinicalCaseRegistries.exe; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\CCR.CNT; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\CCR.HLP; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\CCR_Help_Workaround.txt; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\CCR_Patch.txt; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\borlndmm.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\CDC1.bmp; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\CDC2.bmp; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\iconv.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\js32.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\libexpat.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\Roboex32.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\sablot.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\wh2robo.dll; DestDir: {app}; Flags: ignoreversion
Source: C:\CCR\CCR\Bin\INETWH32.dll; DestDir: {app}; Check: IsInetDLLNeeded

[Icons]
Name: {group}\Use Clinical Case Registries; Filename: {app}\ClinicalCaseRegistries.exe; IconIndex: 0
Name: {group}\{cm:UninstallProgram,ClinicalCaseRegistries}; Filename: {uninstallexe}
Name: {userdesktop}\Clinical Case Registries; Filename: {app}\ClinicalCaseRegistries.exe; Tasks: desktopicon; IconIndex: 0

[Run]

[Code]
//-------------------------------------------------------------------
// Check to see if CCR is running when installing or uninstalling. If
// it is prompt the user that it MUST be shut down before they can 
// proceed.  Check to see if INETWH32.DLL used by the application's
// help file is loaded on the system. Copy it to the application's
// installation directory if it is not already on the system.
//-------------------------------------------------------------------
const
  CCR_EXEFILE = 'ClinicalCaseRegistries.exe';
  CCR_HELPDLL = 'INETWH32.DLL';
  CCR_RUNNING = 'Clinical Case Registries is currently running. Please close to continue.';
  LEN_EXEFILE = 260;

type
  PROCESSENTRY32 = record
    dwSize: cardinal;
    cntUsage: cardinal;
    th32ProcessID: cardinal;
    th32DefaultHeapID: cardinal;
    th32ModuleID: cardinal;
    cntThreads: cardinal;
    th32ParentProcessID: cardinal;
    pcPriClassBase: cardinal;
    dwFlags: cardinal;
    szExeFile: Array[0..LEN_EXEFILE] Of Char;
  end;
  HANDLE = cardinal;

const
  TH32CS_SNAPHEAPLIST = $1;
  TH32CS_SNAPPROCESS = $2;
  TH32CS_SNAPTHREAD = $4;
  TH32CS_SNAPMODULE = $8;

function Process32First(hSnapshot: HANDLE; var lpProcess: PROCESSENTRY32): Integer;
  external 'Process32First@kernel32.dll stdcall';

function Process32Next(hSnapshot: HANDLE; var lpProcess: PROCESSENTRY32): Integer;
  external 'Process32Next@kernel32.dll stdcall';

function CloseHandle(hSnapshot: HANDLE): Integer;
  external 'CloseHandle@kernel32.dll stdcall';

function CreateToolhelp32Snapshot(lFlags: cardinal; lProcessID: cardinal): HANDLE;
  external 'CreateToolhelp32Snapshot@kernel32.dll stdcall';

//-------------------------------------------------------------------

var 
  InetDLLFound: (dllUnknown, dllNotFound, dllFound);

function ProcessRunning(sProcessName : String): Boolean;
var
  hSnapshot: HANDLE;
  PInfo: PROCESSENTRY32;
  nResult: Integer;
  bRunning: Boolean;
  sTemp: String;
  i: Integer;

begin 
  hSnapshot := CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, 0);

  if hSnapshot = -1 then
  begin
     Result := false;
     Msgbox('Failed to get snapshot of running processes.', mbError, MB_OK);
     Exit;
  end;

  bRunning := false;
  PInfo.dwSize := SizeOf(PInfo);
  nResult := Process32First(hSnapshot, PInfo);

  while (nResult <> 0) and (not bRunning) do
  begin
    i := 0;
    sTemp := '';
    while (i < LEN_EXEFILE) and (PInfo.szExeFile[i] > Chr(0)) do
    begin
      sTemp := sTemp + PInfo.szExeFile[i];
      i := i + 1;
    end;

    if CompareText(sTemp, sProcessName) = 0 then 
      bRunning := true;

    PInfo.dwSize := SizeOf(PInfo);
    nResult := Process32Next(hSnapshot, PInfo)
  end;

  CloseHandle(hSnapshot);
  Result := bRunning;
end;

// Check if the DLL needed by CCR Help is already on the target system.
// Changed in Patch 17 to ALWAYS copy the DLL to the application folder.
function IsInetDLLNeeded(): Boolean;
begin
  if InetDLLFound = dllUnknown then
  begin
    InetDLLFound := dllNotFound;
    //if FileExists(ExpandConstant('{sys}\' + CCR_HELPDLL)) then
    //  InetDLLFound := dllFound;
  end;
  Result := InetDLLFound = dllNotFound;
end;

function InitializeSetup(): Boolean;
var
  nMsgBoxResult: Integer;
begin
  Result := true;
  nMsgBoxResult := IDOK;
  // Check if CCR is currently running
  while ProcessRunning(CCR_EXEFILE) and (nMsgBoxResult <> IDCANCEL) do
  begin
    nMsgBoxResult := Msgbox(CCR_RUNNING, mbError, MB_RETRYCANCEL);
  end;

  if nMsgBoxResult = IDCANCEL then 
    Result := false
  else begin
    InetDLLFound := dllUnknown;
  end;
end;

function InitializeUninstall(): Boolean;
var
  nMsgBoxResult: Integer;
begin
  Result := true;
  nMsgBoxResult := IDOK;
  // Check if CCR is currently running
  while ProcessRunning(CCR_EXEFILE) and (nMsgBoxResult <> IDCANCEL) do
  begin
    nMsgBoxResult := Msgbox(CCR_RUNNING, mbError, MB_RETRYCANCEL);
  end;

  if nMsgBoxResult = IDCANCEL then 
    Result := false;
end;

[_ISTool]
OutputExeFilename=C:\CCR\CCR\Install\CCRSetup.exe
