unit uROR_VistAStore;
{$I Components.inc}

interface

uses
  SysUtils, Classes, Forms,
  {$IFNDEF NOORPHEUS}OvcStore,{$ENDIF}
  uROR_CustomBroker;

{$IFNDEF NOORPHEUS}
type

  TCCRVistAStore = class(TO32XMLFileStore)
  private

    fLocked:        Boolean;
    fOnAfterOpen:   TNotifyEvent;
    fOnBeforeClose: TNotifyEvent;
    fOnBeforeOpen:  TNotifyEvent;
    fOptimization:  Boolean;
    fBroker:        TCCRCustomBroker;
    fRPCLoadParams: String;
    fRPCSaveParams: String;

  protected

    procedure DoClose; override;
    procedure DoOpen; override;

  public

    destructor Destroy; override;

    procedure Close;

    property XMLText: TStringList        read FStore;

  published

    property OnAfterOpen: TNotifyEvent   read fOnAfterOpen   write fOnAfterOpen;
    property OnBeforeClose: TNotifyEvent read fOnBeforeClose write fOnBeforeClose;
    property OnBeforeOpen: TNotifyEvent  read fOnBeforeOpen  write fOnBeforeOpen;
    property Optimization: Boolean       read fOptimization  write fOptimization;
    property Broker: TCCRCustomBroker    read fBroker        write fBroker;
    property RPCLoadParams: String       read fRPCLoadParams write fRPCLoadParams;
    property RPCSaveParams: String       read fRPCSaveParams write fRPCSaveParams;

  end;
{$ENDIF}

implementation

uses
  uROR_Utilities;

type

  TRPCStringList = class(TStringList)
  protected

    fBroker:        TCCRCustomBroker;
    fRPCLoadParams: String;
    fRPCSaveParams: String;

  public

    constructor Create(aBroker: TCCRCustomBroker;
      const aLoadParamsRPC, aSaveParamsRPC: String);
    destructor  Destroy; override;

    procedure LoadFromFile(const FileName: String); override;
    procedure SaveToFile(const FileName: String); override;

    property Broker: TCCRCustomBroker read fBroker;

  end;


///////////////////////////////// TRPCStringList \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

constructor TRPCStringList.Create(aBroker: TCCRCustomBroker;
      const aLoadParamsRPC, aSaveParamsRPC: String);
begin
  inherited Create;
  fBroker := aBroker;
  fRPCLoadParams := aLoadParamsRPC;
  fRPCSaveParams := aSaveParamsRPC;
end;

destructor TRPCStringList.Destroy;
begin
  fBroker := nil;
  inherited;
end;

procedure TRPCStringList.LoadFromFile(const FileName: String);
var
  prmName: String;
begin
  if Assigned(Broker) and Broker.Connected and (fRPCLoadParams <> '') then
    begin
      prmName := ExtractFileName(FileName);
      try
        Broker.CallProc(fRPCLoadParams, [prmName, 'USR'], nil, Self, [rpcSilent]);
      except
      end;
      if Count > 0 then
        Delete(0);
    end
  else
    begin
      Clear;
      Exit;
    end;
end;

procedure TRPCStringList.SaveToFile(const FileName: String);
var
  prmName: String;
begin
  if Assigned(Broker) and Broker.Connected and (fRPCSaveParams <> '') then
    begin
      Broker.CreateResults;
      prmName := ExtractFileName(FileName);
      try
        if Count > 0 then
          Broker.CallProc(fRPCSaveParams,
            [prmName, 'USR'], Self, nil, [rpcSilent])
        else
          Broker.CallProc(fRPCSaveParams,
            [prmName, 'USR', '@'], nil, nil, [rpcSilent]);
      except
      end;
    end;
end;

///////////////////////////////// TCCRVistAStore \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
{$IFNDEF NOORPHEUS}

destructor TCCRVistAStore.Destroy;
begin
  if fOptimization then
    Close;
  fBroker := nil;
  inherited;
end;

procedure TCCRVistAStore.Close;
begin
  try
    fLocked := False;
    if Assigned(FStore) then
      inherited Close;
  except
  end;
end;

procedure TCCRVistAStore.DoClose;
begin
  if not fLocked then
    begin
      if Assigned(OnBeforeClose) then
        OnBeforeClose(self);
      inherited;
    end;
end;

procedure TCCRVistAStore.DoOpen;
begin
  if not fLocked then
    begin
      if Assigned(OnBeforeOpen) then
        OnBeforeOpen(self);
      FStore := TRPCStringList.Create(Broker, RPCLoadParams, RPCSaveParams);
      FStore.LoadFromFile(XMLFileName);
      try
        xsInitialize;
      except
        FStore.Clear;
        xsInitialize;
      end;
      if fOptimization then
        fLocked := True;
      if Assigned(OnAfterOpen) then
        OnAfterOpen(self);
    end;
end;

{$ENDIF}
end.
