unit uZZ_DescribedItem;
{
================================================================================
*
*       Package:        development tool
*       Date Created:   5/08/12
*       Site:           Hines OIFO
*       Developers:
*                       PII                       
*
*       Description:    General self-described object
*
================================================================================
}
interface

uses
  classes
  ,SysUtils
  ;

type

  ImDescribe = interface
    ['{D3CA9934-7EBA-40F9-A481-C93E301D130F}']
    function GetName:String;   stdcall;
    function GetDescription:TStringList;  stdcall;

    procedure Reload; stdcall;
    function GetComponents:TStringList; stdcall;
    function GetImageIndex:Integer;stdcall;
    function GetSelectedIndex:Integer;stdcall;
    function HasComponents:Integer;stdcall;

  end;

  TmDescribedItem = class(TInterfacedObject , ImDescribe, IUnknown)
  protected
    Name:String;
    Status:String;
    Description: TStringList;
    Components:TStringList;
    RawLines:TStringList;
    ImageIndex,
    SelectedIndex: Integer;
  public
    function _AddRef:Integer;stdcall;
    function _Release:Integer;stdcall;

    function GetName:String;stdcall;
    function GetDescription:TStringList;stdcall;
    function GetComponents:TStringList; stdcall;
    procedure Reload;stdcall;
    function GetImageIndex:Integer;stdcall;
    function GetSelectedIndex:Integer;stdcall;
    function HasComponents:Integer;stdcall;

    constructor Create(aList:TStringList);
    destructor Destroy;override;
  end;

function getDescribedItem(
  aName: String;
  aDescription:String): TmDescribedItem;

implementation


function getDescribedItem(
  aName: String;
  aDescription:String): TmDescribedItem;
var
  SL: TStringList;
begin
  SL := TStringList.Create;
  SL.Text := aName+#13#10+aDescription+ #13#10;
  Result := TmDescribedItem.Create(SL);
  FreeAndNil(SL);
end;

{TDescribedItem}
function TmDescribedItem._AddRef:Integer;
begin
  Result := -1;
end;

function TmDescribedItem._Release:Integer;
begin
  Result := -1;
end;

function TmDescribedItem.GetName:String;
begin
  Result := Name;
end;

function TmDescribedItem.GetDescription:TStringList;
begin
  Result := Description;
end;

function TmDescribedItem.GetComponents:TStringList;
begin
  Result := Components;
end;

procedure TmDescribedItem.Reload;
begin
end;

function TmDescribedItem.GetImageIndex:Integer;
begin
  Result := ImageIndex;
end;

function TmDescribedItem.GetSelectedIndex:Integer;
begin
  Result := SelectedIndex;
end;

function TmDescribedItem.HasComponents:Integer;
begin
  Result := Components.Count;
end;

constructor TmDescribedItem.Create(aList:TStringList);
begin
  try
    RawLines := TStringList.Create;
    Components := TStringList.Create;
    Description := TStringList.Create;
    Name := '...';
    if Assigned(aList) then
    try
      RawLines.Assign(aList);
      Description.Assign(aList);
      Name := Description[0];
    except
    end;
  except
  end;
end;

destructor TmDescribedItem.Destroy;
begin
  //MessageDLG('Destroying Described Item '+Name, mtInformation,[mbOk], 0);
  try
    if RawLines <> nil then
      RawLines.Free;
    if Description <> nil then
      Description.Free;
    if Components <> nil then
      Components.Free;
  except
  end;
  inherited;
end;

end.

