{******************************************************************************}
{ Package:      Clinical Case Registries Custom Components                     }
{ Date Created: January 26, 2007                                               }
{ Site Name:    Hines OIFO                                                     }
{ Developers:   Sergey Gavrilov                                                }
{ Description:  A dialog box that displays a list of command-line parameters.  }
{ Note:                                                                        }
{******************************************************************************}

unit fROR_CmdLineParams;

{$I Components.inc}

interface

uses
  Windows, Forms, ComCtrls, Buttons, ExtCtrls, uROR_CmdLineParams,
  Vcl.StdCtrls, Vcl.Controls, System.Classes;

type

  {=========================== TFormCCRCmdLineParams ===========================
    Overview:     Command-line parameters help dialog box.
    SeeAlso:      TCCRCustomCmdLineParams.ShowHelp
    Description:
      TFormCCRCmdLineParams is used internally to display a list of command-line
      parameters and their descriptions.
  }
  TFormCCRCmdLineParams = class(TForm)

    edHelp: TRichEdit;
    Panel1: TPanel;
    btnOK: TBitBtn;
    procedure FormResize(Sender: TObject);

  public

    class procedure Show(HelpItems: TCCRCmdLineHelpItems);

  end;

///////////////////////////////// Implementation \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

implementation

{$R *.dfm}

///////////////////////////// TFormCCRCmdLineParams \\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFormCCRCmdLineParams.FormResize(Sender: TObject);
begin
  btnOK.Left := (btnOK.Parent.ClientWidth - btnOK.Width) div 2;
  edHelp.Invalidate;
end;

class procedure TFormCCRCmdLineParams.Show(HelpItems: TCCRCmdLineHelpItems);
begin
  with TFormCCRCmdLineParams.Create(Application) do
    try
      if Application.Title <> '' then
        Caption := Application.Title + ': ' + Caption;
      edHelp.Assign(HelpItems);
      ShowModal;
    finally
      Free;
    end;
end;

end.
