{******************************************************************************}
{ Package:      Clinical Case Registries Custom Components                     }
{ Date Created: January 26, 2007                                               }
{ Site Name:    Hines OIFO                                                     }
{ Developers:   Sergey Gavrilov                                                }
{ Description:  Dialog box for procedure errors.                               }
{ Note:                                                                        }
{******************************************************************************}

unit fROR_BrokerErrors;

{$I Components.inc}

interface

uses
  SysUtils, Classes, Forms, Dialogs, StdCtrls, Controls,
  uROR_CustomBroker, Buttons, ExtCtrls, ComCtrls, Graphics;

type

  {========================== TCCRFormProcedureErrors ==========================
    Overview:     ???
    Description:
  }
  TCCRFormProcedureErrors = class(TForm)

    edMsg: TRichEdit;
    Panel1: TPanel;
    btnOK: TBitBtn;

  protected

    {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      Overview:     ???
      SeeAlso:      TCCRFormProcedureErrors.Show
      Description:
    }
    procedure FormatErrors(CallInfo: TCCRBrokerCallInfo);

    {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      Overview:     ???
      SeeAlso:      TControl.Resize
      Keywords:     Resize,TCCRFormProcedureErrors
      Description:
    }
    procedure Resize; override;

  public

    {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      Overview:     ???
      SeeAlso:      TCCRFormProcedureErrors.FormatErrors
      Keywords:     Show,TCCRFormProcedureErrors
      Description:
    }
    class procedure Show(CallInfo: TCCRBrokerCallInfo);

  end;

///////////////////////////////// Implementation \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

implementation

{$R *.DFM}

uses
  uROR_Utilities, uROR_Resources;

//////////////////////////// TCCRFormProcedureErrors \\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TCCRFormProcedureErrors.FormatErrors(CallInfo: TCCRBrokerCallInfo);
var
  i, iErr, n, numErr: Integer;
  buf: String;
begin
  edMsg.Clear;
  numErr := CallInfo.ErrorCount - 1;
  for iErr:=0 to numErr do
    with CallInfo.Errors[iErr],edMsg do
      begin
        Lines.Add('');
        Lines.Add(Message);

        if Code <> 0 then
          begin
            buf := Format(RSC0052, [Code]);
            if Place <> '' then
              buf := buf + Format(RSC0053, [Place]);
            Lines.Add(buf);
          end;

        if Assigned(Details) and (Details.Count > 0) then
          begin
            n := Details.Count - 1;
            for i:=0 to n do
              Lines.Add(Details[i]);
          end;
      end;
end;

procedure TCCRFormProcedureErrors.Resize;
begin
  inherited;
  btnOK.Left := (btnOK.Parent.ClientWidth - btnOK.Width) div 2;
  edMsg.Invalidate;
end;

class procedure TCCRFormProcedureErrors.Show(CallInfo: TCCRBrokerCallInfo);
begin
  with Create(Application) do
    try
      FormatErrors(CallInfo);
      ShowModal;
    finally
      Free;
    end;
end;

end.
