unit uZZ_RPCEvent;
{
================================================================================
*
*       Package:        development tool
*       Date Created:   5/08/12
*       Site:           Hines OIFO
*       Developers:
*                       PII                       
*
*       Description:    Implementation of RPCEventItem of the Event log
*
================================================================================
}

interface
uses
  Classes
  , uZZ_DescribedItem
  , TRPCB
  , Dialogs
  ;

type
  TRPCEventItem = class(TmDescribedItem)
  public
    Start: TDateTime;
    Stop: TDateTime;
    RPCContext: string;
    BrokerInfo: String;
    RPC: string;
    Params: TStrings;
    Results: TStrings;
    Errors: TStrings;

    constructor Create;
    destructor Destroy; override;
    procedure AppendResults(aResults:TStrings;aStart,aStop:TDateTime);
    procedure AppendError(anError:String);
  end;

function getRPCEventItem(
  aStart, aStop: TDateTime;
  aConnection: String;
  aBrokerInfo:String;
  RemoteProcedure: string;
  Parameters: TStrings; // array of string;
  MultList: TStringList = nil;
  RetList: TStrings = nil): TRPCEventItem;

function getTRPCBEventItem(aRPCB: TRPCBroker): TRPCEventItem;

var
  ServerDelay: TDateTime;
  CheckBrokerFlag: Boolean;
  RPCCount: Integer;

implementation
uses
  SysUtils
  ;

////////////////////////////////////////////////////////////////////////////////
const
  fmtParams =  'Params:   --------------------------------------------------';
  fmtResults = 'Results:  --------------------------------------------------';
  fmtErrors  = 'Errors:   --------------------------------------------------';
  fmtRef =     'Reference ''%s''';
  fmtLit =     'Literal   ''%s''';
  fmtOutput =  '%-7.7d   %s';
  fmtContext = 'Context:  ''%s''';
  fmtRPC =     'RPC:      ''%s''';
  fmtRPCBInfo ='Broker:   ''%s''';
  fmtConnect = 'Account:  %s:%d %s (%s)';

function getRPCEventItem(
  aStart, aStop: TDateTime;
  aConnection:String;
  aBrokerInfo:String;
  RemoteProcedure: string;
  Parameters: TStrings;  //array of string;
  MultList: TStringList = nil;
  RetList: TStrings = nil): TRPCEventItem;
var
  Item: TRPCEventItem;
  i, j: Integer;
begin
  Item := TRPCEventItem.Create;
  Item.Start := aStart;
  Item.Stop := aStop;
  Item.RPC := RemoteProcedure;
  Item.RPCContext := aConnection;
  Item.BrokerInfo := aBrokerInfo;
  Item.Params.Add(fmtParams);

  for i := 0 to Parameters.Count - 1 do
  begin
    if (Copy(Parameters[i], 1, 1) = '@') and (Parameters[i] <> '@') then
      Item.Params.Add(Format(fmtRef,[Copy(Parameters[i], 2, Length(Parameters[i]))]))
    else
      Item.Params.Add(Format(fmtLit,[Parameters[i]]));
  end;

  if MultList <> nil then
    if MultList.Count > 0 then
    begin
      Item.Params.Add('List:');
      for j := 1 to MultList.Count do
        Item.Params.Add(MultList[j - 1]);
    end;

  if RetList <> nil then
    if RetList.Count > 0 then
    begin
      for j := 0 to RetList.Count - 1 do
        Item.Results.Add(RetList[j]);
    end;
  Result := Item;

  inc(RPCCount);
  Item.Description.Text := '          ' +
    FormatDateTime('hh:mm:ss.zzz -- ',aStart) +
    FormatDateTime('hh:mm:ss.zzz    ',aStop) + '  ' +
    FormatDateTime('(hh:mm:ss.zzz)',aStop-aStart) + #13#10 +

    Format(fmtContext,[Item.RPCContext]) + #13#10 +
    Format(fmtRPC,[Item.RPC]) + #13#10 +
    Format(fmtRPCBinfo,[Item.BrokerInfo]) + #13#10 +
    #13#10 +
    Item.Params.Text + #13#10;
  Item.Description.Text := Item.Description.Text +
    fmtResults +#13#10;
  for i := 0 to Item.Results.Count - 1 do
    Item.Description.Text := Item.Description.Text +
      Format(fmtOutput,[i,Item.Results[i]]) + #13#10;

  Item.Description.Text := Item.Description.Text +
    fmtResults;

end;

function getTRPCBEventItem(aRPCB: TRPCBroker): TRPCEventItem;
var
  i,j: Integer;
  item : TRPCEventItem;
  ss,sss: String;
begin
  Item:= TRPCEventItem.Create;
  Item.RPC := aRPCB.RemoteProcedure;
  Item.RPCContext := aRPCB.CurrentContext;

  for i := 0 to aRPCB.Param.Count - 1 do
  begin
    if aRPCB.Param[i].PType = Literal then
        Item.Params.Add(Format(fmtLit,[aRPCB.Param[i].Value]))
    else if aRPCB.Param[i].PType = Reference then
        Item.Params.Add(Format(fmtRef,['@'+aRPCB.Param[i].Value]))
    else if aRPCB.Param[i].PType = List then
      begin
        for j := 0 to aRPCB.Param[i].Mult.Count - 1 do
          begin
            ss := aRPCB.Param[i].Mult.Subscript(j);
            sss := Format('List     [%-20.20s] = ''%s''',[ss,aRPCB.Param[i].Mult[ss]]);
            Item.Params.Add(sss);
          end;
      end
  end;

  Item.Description.Text :=
    Format(fmtContext,[Item.RPCContext]) + #13#10 +
    Format(fmtRPC,[Item.RPC]) +        #13#10 +
    Format(fmtConnect,[aRPCB.Server,aRPCB.ListenerPort, aRPCB.User.Name,aRPCB.User.DUZ]) +#13#10#13#10 +
    fmtParams + #13#10 +
    Item.Params.Text + #13#10 +
    fmtResults + #13#10;

  Result := Item;
end;

////////////////////////////////////////////////////////////////////////////////

constructor TRPCEventItem.Create;
begin
  inherited Create(nil);
  Params := TStringList.Create;
  Results := TStringList.Create;
  Errors := TStringList.Create;
end;

destructor TRPCEventItem.Destroy;
begin
  Params.Free;
  Results.Free;
  Errors.Free;
  inherited;
end;

procedure TRPCEventItem.AppendResults(aResults:TStrings;aStart,aStop:TDateTime);
var
  i: Integer;
begin
  Start := aStart;
  Stop := aStop;
  Description.Text := '          ' +
    FormatDateTime('hh:mm:ss.zzz -- ',aStart) +
    FormatDateTime('hh:mm:ss.zzz    ',aStop) + '  ' +
    FormatDateTime('(hh:mm:ss.zzz)',aStop-aStart) + #13#10 +
    Description.Text;

  if Assigned(aResults) then
    begin
      Results.Assign(aResults);
      for i := 0 to aResults.Count - 1 do
        Description.Text := Description.Text +
          Format(fmtOutput,[i,aResults[i]]);
      Description.Text := Description.Text + fmtResults;

    end;
end;

procedure TRPCEventItem.AppendError(anError:String);
var
  i: integer;
begin
  Errors.Text := Errors.Text + anError;
  Description.Text := Description.Text + #13#10 + fmtErrors + #13#10;
  for i := 0 to Errors.Count - 1 do
       Description.Text := Description.Text + Errors[i];
  Description.Text := Description.Text + fmtErrors + #13#10;

end;
////////////////////////////////////////////////////////////////////////////////

initialization
  CheckBrokerFlag := False;
  RPCCount := 0;

finalization
end.
