unit Unit1;

interface

uses Vcl.ExtCtrls, System.SysUtils;

const
// number of seconds between checks for a screen reader
  POST_SCREEN_READER_ACTIVATION_CHECK_SECONDS = 30;

function ScreenReaderSystemActive: boolean;

implementation

uses VAUtils;

var
  CheckScreenReaderSystemActive: boolean = TRUE;
  uScreenReaderSystemActive: boolean = FALSE;
  uPostScreenReaderActivationTimer: TTimer = nil;

function IsScreenReaderSupported(Unload: Boolean): boolean;
var
  i: integer;
  HighVersion, LowVersion: integer;
begin
  Result := FALSE;
  FindScreenReaders;
  VersionStringSplit(VA508AccessibilityManagerVersion, HighVersion, LowVersion);
  for I := 0 to ValidSRFiles.Count - 1 do
  begin
    LoadScreenReader(i);
    Result := CheckRunning(Unload, HighVersion, LowVersion);
    if Result then exit;
    if not Unload then
    begin
      FreeLibrary(DLLHandle);
      DLLHandle := 0;
    end;
  end;
end;

procedure PostScreenReaderCheckEvent(Self: TObject; Sender: TObject);
var
  AppName, ext, error: string;
begin
  if ScreenReaderActive then
  begin
    FreeAndNil(uPostScreenReaderActivationTimer);
    if IsScreenReaderSupported(TRUE) then
    begin
      AppName := ExtractFileName(ParamStr(0));
      ext := ExtractFileExt(AppName);
      AppName := LeftStr(AppName, length(AppName) - Length(ext));
      error := Format(POST_SCREEN_READER_INFO_MESSAGE, [AppName]);
      MessageBox(0, PChar(error), 'Accessibility Component Information',
        MB_OK or MB_ICONINFORMATION or MB_TASKMODAL or MB_TOPMOST);
    end;
  end;
end;

function ScreenReaderSystemActive: boolean;

  procedure CreateTimer;
  var
    ptr: TMethod;
  begin
    uPostScreenReaderActivationTimer := TTimer.Create(nil);
    with uPostScreenReaderActivationTimer do
    begin
      Enabled := FALSE;
      Interval := 1000 * POST_SCREEN_READER_ACTIVATION_CHECK_SECONDS;
      ptr.Code := @PostScreenReaderCheckEvent;
      ptr.Data := @ptr;
      OnTimer := TNotifyEvent(ptr);
      Enabled := TRUE;
    end;
  end;

begin
  if CheckScreenReaderSystemActive then
  begin
    CheckScreenReaderSystemActive := FALSE;
    // prevent Delphi IDE from running DLL
    if LowerCase(ExtractFileName(ParamStr(0))) <> 'bds.exe' then
      uScreenReaderSystemActive := ScreenReaderDLLsExist;
    if uScreenReaderSystemActive then
    begin
      if ScreenReaderSupportEnabled then
      begin
        if IsScreenReaderSupported(FALSE) then
          uScreenReaderSystemActive := InitializeScreenReaderLink
        else
          uScreenReaderSystemActive := FALSE;
      end
      else
      begin
        uScreenReaderSystemActive := FALSE;
        CreateTimer;
      end;
    end;
  end;
  Result := uScreenReaderSystemActive;
end;

end.
