unit uROR_Common;

interface

uses
  uROR_Broker, uROR_CmdLineParams, uROR_Contextor;

const
  CCOW_PATIENT = 'Patient';
  CCOW_USER    = 'User';
  
  U = '^';

type

  IFrameInterface = interface(IInterface)
    ['{4A03FF55-31F2-4A69-864A-9E26F0B47E2B}']

    procedure SelectPatient(const aPatientIEN: String);

  end;

function  Broker: TCCRBroker;
function  CmdLineParams: TCCRCmdLineParams;
function  Contextor: TCCRContextor;
procedure DisplayStatus(const msg: String);
function  FormatSSN(const aSSN:String): String;

implementation

uses
  fROR_MainForm;

function Broker: TCCRBroker;
begin
  if Assigned(FormMain) then
    Result := FormMain.ccrBroker
  else
    Result := nil;
end;

function CmdLineParams: TCCRCmdLineParams;
begin
  if Assigned(FormMain) then
    Result := FormMain.ccrCmdLineParams
  else
    Result := nil;
end;

function Contextor: TCCRContextor;
begin
  if Assigned(FormMain) then
    Result := FormMain.ccrContextor
  else
    Result := nil;
end;

procedure DisplayStatus(const msg: String);
begin
  with FormMain.stsbrMain do
    begin
      Panels[0].Text := msg;
      Repaint;
    end;
end;

function FormatSSN(const aSSN:String):String;
begin
  try
    Result := Copy(aSSN,1,3)+'-'+Copy(aSSN,4,2)+'-'+Copy(aSSN,6,99);
  except
    Result := aSSN
  end;
end;

end.
