unit fROR_GridFrame;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, 
  Dialogs, ComCtrls, uROR_CustomListView, uROR_GridView, uROR_SearchEdit,
  ExtCtrls, uROR_Common, ovcfiler, ActnList;

type

  TFrameGrid = class(TFrame,IFrameInterface)
    pnlPatients: TPanel;
    ccrPatientSearch: TCCRSearchEdit;
    lvwPatientList: TCCRGridView;
    aclGridFrame: TActionList;
    acCancelSearch: TAction;
    acEditPatientData: TAction;
    procedure lvwPatientListCustomDrawItem(Sender: TCustomListView;
      Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure ccrPatientSearchSearchStart(aSender: TObject;
      var aCommand: TCCRSearchCommand);
    procedure ccrPatientSearchSearch(aSender: TObject;
      var aCommand: TCCRSearchCommand);
    procedure ccrPatientSearchSearchEnd(aSender: TObject;
      var aCommand: TCCRSearchCommand);
    procedure acCancelSearchExecute(Sender: TObject);
    procedure acEditPatientDataExecute(Sender: TObject);
    procedure lvwPatientListDblClick(Sender: TObject);
    procedure lvwPatientListKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private

    fPatientIEN:    String;
    fSearchFrom:    String;
    fSearchPattern: String;

    procedure UpdatePatientCounter;

  public

    procedure LoadLayout(aStorage: TOvcAbstractStore);
    procedure LoadPatient(const aPatientIEN: String);
    procedure SaveLayout(aStorage: TOvcAbstractStore);
    procedure SelectPatient(const aPatientIEN: String);

  end;

//////////////////////////////// Implementation \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

implementation

{$R *.dfm}

uses
  fROR_MainForm, StrUtils, uROR_Utilities, fROR_EditPatientData;

const
  iPtlIEN  =  0;
  iPtlName =  1;
  iPtlSSN  =  2;
  iPtlDOB  =  3;

////////////////////////////////// TFrameGrid \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

procedure TFrameGrid.acCancelSearchExecute(Sender: TObject);
begin
  ccrPatientSearch.CancelSearch;
end;

procedure TFrameGrid.acEditPatientDataExecute(Sender: TObject);
var
  DFN: String;
begin
  if Assigned(lvwPatientList.Selected) then
    begin
      DFN := lvwPatientList.Selected.AsString[iPtlIEN];
      { Request the patient context change. The SetPatientContext
        returns False if another application conditionally accepts
        the request but the user chooses to cancel the transaction. }
      if Contextor.SetPatientContext(DFN) then
        begin
          { StartPatientEdit must be called before displaying any
            modal form that blocks the patient context changes. }
          FormMain.StartPatientEdit;
          lvwPatientList.Invalidate;
          try
            with lvwPatientList.Selected do
              TFormPatientData.EditPatientData(DFN, AsString[iPtlName],
                AsString[iPtlSSN]);
          finally
            { EndPatientEdit must be called after the modal form
              that blocks the patient context changes is closed. }
            FormMain.EndPatientEdit;
            lvwPatientList.Invalidate;
          end;
        end;
    end;
end;

procedure TFrameGrid.ccrPatientSearchSearch(aSender: TObject;
  var aCommand: TCCRSearchCommand);

  procedure FillPatientList;
  var
    sTmp: String;
    i: Integer;
    LItem : TCCRGridItem;
  begin
    lvwPatientList.Items.BeginUpdate;
    try
      for i:=1 to Broker.Results.Count-1 do
        begin
          LItem := lvwPatientList.Items.Add;
          LItem.ImageIndex := -1;
          LItem.AsString[iPtlName] := Piece(Broker.Results[i], U, 2);
          with LItem do
            begin
              sTmp := Broker.Results[i];
              { Store the patient DFN, name, and date of birth
                into the corresponding fields of the list item. }
              AssignRawData(sTmp, [1,2,-1,3]);
              { Format the SSN and assign it to the corresponding
                field of the list item. }
              AsString[iPtlSSN] := FormatSSN(Piece(sTmp, U, 4));
            end;
        end;
      finally
        lvwPatientList.Items.EndUpdate;
      end;
  end;

var
  n: Integer;
begin
  Broker.CreateResults;

  if Broker.CallProc('ROR LIST PATIENTS',
       ['1', '', fSearchPattern, '2', '20', fSearchFrom]) then
    begin
      n := StrToIntDef(Piece(Broker.Results[0],U), 0);
      if n > 0 then
        begin
          fSearchFrom := Piece(Broker.Results[0], U, 2, 99);

          { Add records to the list. }
          FillPatientList;

          { Check if there are more records to load. }
          if fSearchFrom = '' then
            aCommand := cscFinish;

          UpdatePatientCounter;
        end
      else
        aCommand := cscCancel;
    end
  else
    aCommand := cscCancel;
end;

procedure TFrameGrid.ccrPatientSearchSearchEnd(aSender: TObject;
  var aCommand: TCCRSearchCommand);
begin
  DisplayStatus('');

  if (lvwPatientList.Items.Count = 0) and (fPatientIEN = '') then
    MessageDialog('Patient Selection',
      'No patient records conform to the search criteria.',
      mtInformation, [mbOK], mrOK, 0);

  with lvwPatientList do
    if Items.Count > 0 then
      try
        ItemFocused := Items[0];
        ItemFocused.Selected := True;
      except
      end;
end;

procedure TFrameGrid.ccrPatientSearchSearchStart(aSender: TObject;
  var aCommand: TCCRSearchCommand);
begin
  lvwPatientList.Clear;
  if fPatientIEN <> '' then  // Load a particular patient
    fSearchPattern := '`' + fPatientIEN
  else                       // Search for patients
    fSearchPattern := Uppercase(ccrPatientSearch.Text);
  fSearchFrom := '';
  UpdatePatientCounter;
end;

procedure TFrameGrid.LoadLayout(aStorage: TOvcAbstractStore);
begin
  lvwPatientList.LoadLayout(aStorage, 'PatientList');
end;

procedure TFrameGrid.LoadPatient(const aPatientIEN: String);
begin
  fPatientIEN := aPatientIEN;
  try
    ccrPatientSearch.Search;
  finally
    fPatientIEN := '';
  end;
end;

procedure TFrameGrid.lvwPatientListCustomDrawItem(Sender: TCustomListView;
  Item: TListItem; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  { Highlight the record of the patient who is referenced by the current
    patient context. }
  with lvwPatientList.Canvas.Font do
    begin
      if TCCRGridItem(Item).AsString[iPtlIEN] = Contextor.PatientDFN then
        Style := Style + [fsBold]
      else
        Style := Style - [fsBold];
    end;
end;

procedure TFrameGrid.lvwPatientListDblClick(Sender: TObject);
begin
  acEditpatientData.Execute;
end;

procedure TFrameGrid.lvwPatientListKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_Return then
    acEditpatientData.Execute;
end;

procedure TFrameGrid.SaveLayout(aStorage: TOvcAbstractStore);
begin
  lvwPatientList.SaveLayout(aStorage, 'PatientList');
end;

procedure TFrameGrid.SelectPatient(const aPatientIEN: String);
var
  i, n: Integer;
  found: Boolean;
begin
  found  := False;

  { Clear the list if the patient IEN (DFN) is not provided. }
  if aPatientIEN = '' then
    begin
      lvwPatientList.Clear;
      Exit;
    end;

  { If the patient record is in the current list then select it. }
  with lvwPatientList do
    begin
      n := Items.Count - 1;
      for i:=0 to n do
        if Items[i].AsString[iPtlIEN] = aPatientIEN then
          begin
            if Assigned(ItemFocused) then
              ItemFocused.Update;
            Selected := Items[i];
            ItemFocused := Selected;
            found := True;
            Break;
          end;
    end;

  { Otherwise, compile a new list that contains only this patient. }
  if not found then
    LoadPatient(aPatientIEN);
end;

procedure TFrameGrid.UpdatePatientCounter;
begin
  DisplayStatus(
     Format('Patients found: %d', [lvwPatientList.Items.Count]) +
     ' (press Ctrl+Alt+C to cancel)...');
end;

end.
