<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>


<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ include file="/jsp/init.jsp" %>	


<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    //border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}

	.messageicon{
	margin-left:50px;font-size: 15px; font-weight:100; float:center;
	}

	.assessment-history-all{
		float:right;
		margin:10px;
	}
	.section-link{
		float:right;
		margin:10px;
	}
	
</style>

<div id="mainTab">

<div class="tab-content">
<div class="yui3-skin-sam">
	<div id="modalEditLetterContent0"></div>
</div>

<div class="supporting-docs">

<div class="content toggler-content-expanded">	

<legend class="header">Preview & Send</legend>
	<div id="letterContentTable">
	<div id="letterContent" class="letterContent" contenteditable = "true">
			${letterContent}
	</div>
</div>
		<table style="width:98%">
			<tr>
			  <th width="15%">File Name</th> 
			  <th width="10%">Action</th>			  
			</tr>
			<tr id="">
			    <td>
			    <!--${letterName}-->
			    <aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="facilityPopup required-input">
				<aui:select label="letter-name" name="previewLetterName" id="previewLetterName" >
					<aui:option value="0" label="select-letter" selected="true" />
					<c:forEach var="letterName" items="${cscLetterNames}">
						<aui:option value="${letterName}" label="${letterName}"/>
					</c:forEach>
				</aui:select>
				</aui:field-wrapper>
			    </td>
			    <td>
					<portlet:resourceURL var="previewLetter">
						<portlet:param name="action" value="previewLetter"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
					</portlet:resourceURL>
					
					<portlet:actionURL var="sendLetter">
						<portlet:param name="javax.portlet.action" value="doAction" />
						<portlet:param name="action" value="sendLetter"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
						<portlet:param name="letterName" value="${letterName}"/>
					</portlet:actionURL>
					
					<aui:form  style="margin:0px;" action="${previewLetter}" name="previewLetter" method="post" enctype="multipart/form-data">
					<input type="hidden" id="letterName" name="letterName" value=""/>
					<input type="hidden" id="editedLetterContent" name="editedLetterContent" value=""/>
					</aui:form>
					<aui:form style="margin:0px;" action="${sendLetter}" name="sendLetter" method="post" enctype="multipart/form-data">
					<input type="hidden" id="sendLetterName" name="sendLetterName" value=""/>
					<input type="hidden" id="editedLetterContent" name="editedLetterContent" value=""/>
					</aui:form>
					<a href="javascript:previewLetter();"><i class="close-window btn btn-primary" >&nbsp; Preview </i></a>
					<a href="javascript:editLetterContent();"><i class="close-window btn btn-primary" >&nbsp; Edit </i></a>
					<a href="javascript:sendLetter();"><i class="close-window btn btn-primary" >&nbsp; Send</i></a>			    	
				</td>
			</tr>
		</table>
	</div>
</div>	

<legend class="header">Previous Letters </legend>
	<div class="summaryTable">
	<c:choose>
		<c:when test="${not empty allLetters}">
			<table style="width:98%">
				<tr>
					<th>File Name</th> 
					<th>From</th> 
					<th>Sent Date</th> 
					<th>Action</th>		  
				</tr>
				<c:forEach var="doc" items="${allLetters}">	
					<c:set var="docInfo" value="${fn:split(doc.note, ',')}" />
					<tr id="row_${doc.documId}">
						<td>${doc.name}</td>
						<td>${docInfo[1]}</td>
						<td>${docInfo[0]}</td>
						<td>
						<portlet:resourceURL var="viewLetter">
						<portlet:param name="action" value="getDocum"/>
						<portlet:param name="documId" value="${doc.documId}"/>
						</portlet:resourceURL>
						<a href="${viewLetter}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; View</i></a>
						</td>
					</tr>
				</c:forEach>
			</table>
		</c:when>
		<c:otherwise>
			<div class="messageicon">No letters available</div>
		</c:otherwise>
	</c:choose>
	
	
	</div>
</div>	
</div>
</div>
 <aui:script use="aui-io-request,aui-parse-content,aui-modal">
 
	var modalEditLetterContent = new A.Modal({
	headerContent: '<h4><liferay-ui:message key="edit-letter-content" /></h4>',
     bodyContent: A.one("#letterContentTable"),
     centered: true,
     destroyOnHide: false,
     modal: true,
     render: '#modalEditLetterContent0', 
     resizable: {
       handles: 'b, r'
     },
     visible: false,
     width: 950
	});

	window.previewLetter = function() {
		var letterName = A.one("#<portlet:namespace/>previewLetterName").val();
		A.one('#letterName').val(letterName);	
		var content = document.getElementById("letterContent").innerHTML;
		A.all('#editedLetterContent').val(content);	
		A.one("#<portlet:namespace/>previewLetter").submit();
	}

	window.sendLetter = function() {
		var content = document.getElementById("letterContent").innerHTML;
		A.all('#editedLetterContent').val(content);	
		var letterName = A.one("#<portlet:namespace/>previewLetterName").val();
		A.one('#sendLetterName').val(letterName);	
		A.one("#<portlet:namespace/>sendLetter").submit();
	}
	
	window.editLetterContent = function() {	
		modalEditLetterContent.render();
		modalEditLetterContent.show();
	}

	modalEditLetterContent.addToolbar([
	        {
	          label: 'Cancel',
	          on: {
	            click: function() {
	            	modalEditLetterContent.hide();
	            }
	          }
	        },{
	          label: 'Save Changes',
	          on: {
	            click: function() {
	        		modalEditLetterContent.hide();
	            }
	          }
	        }
	   ]);
	
	
   </aui:script>