<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>


<%@ taglib uri="http://liferay.com/tld/ui" prefix="liferay-ui" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ include file="/jsp/init.jsp" %>	


<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.section{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
	.manage-layout-td text{
		/* width: 840px; */
		width: 67px;
		padding-left: 10px;
	}
	.manage-layout-td textarea{
		/* width: 840px; */
		width: 767px;
		padding-left: 10px;
	}

	.messageicon{
	margin-left:50px;font-size: 15px; font-weight:100; float:center;
	}

	.assessment-history-all{
		float:right;
		margin:10px;
	}
	.section-link{
		float:right;
		margin:10px;
	}
	
</style>	

  <!--    <textarea name="letter_content" id="content"></textarea>      -->
 
<div class="supporting-docs">
	<hr/>
	<!-- <legend class="header">Supporting Documents</legend> -->
<div class="content toggler-content-expanded">	

<div class="sectionHeading">Preview & Sends</div>		
	<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <th width="15%">File Name............testttttt</th> 
			  <th width="10%">Action</th>			  
			</tr>
			<tr id="">
			    <td>${letterName}</td>
			    <td>
					<portlet:resourceURL var="previewLetter">
						<portlet:param name="action" value="previewLetter"/>
							<portlet:param name="vcgId" value="${vcgId}"/>
							<portlet:param name="letterName" value="${letterName}"/>
					</portlet:resourceURL>
					<portlet:resourceURL var="editLetter">
					<portlet:param name="action" value="editLetter"/>
						<portlet:param name="vcgId" value="${vcgId}"/>
						<portlet:param name="letterName" value="${letterName}"/>
					</portlet:resourceURL>
					<portlet:actionURL var="sendLetter">
					<portlet:param name="javax.portlet.action" value="doAction"/>
							<portlet:param name="action" value="sendLetter"/>
							<portlet:param name="vcgId" value="${vcgId}"/>
							<portlet:param name="letterName" value="${letterName}"/>
					</portlet:actionURL>
					<aui:form action="${saveLetter}" name="saveLetter" method="post" enctype="multipart/form-data">
						<input type="hidden" name="letterContent" value=""/>
					</aui:form>
					<a href="${previewLetter}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; Preview </i></a>
					<a href="${editLetter}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; Edit </i></a>
					<!-- <a href="javascript:saveLetter();" class="btn-primary delete-document" id="${doc.documId}"><i class="close-window btn btn-primary" >&nbsp; Send</i></a>	 -->
					<a href="${sendLetter}" class="btn-primary delete-document" id="${doc.documId}"><i class="close-window btn btn-primary" >&nbsp; Send</i></a>			    	
				</td>
			</tr>
		</table>
	</div>
</div>	

<div class="sectionHeading">All letters previously sent for this VCG</div>		
	<div class="summaryTable">
		<table style="width:98%">
			<tr>
			  <th>File Name</th> 
			  <th>From</th> 
			  <th>Sent Date</th> 
			  <th>Action</th>		  
			</tr>
			
		<c:forEach var="doc" items="${allLetters}">	
			<c:set var="docInfo" value="${fn:split(doc.note, ',')}" />
			<tr id="row_${doc.documId}">
			     <td>${doc.name}</td>
				 <td>${docInfo[1]}</td>
				 <td>${docInfo[0]}</td>
			     <td>
					<portlet:resourceURL var="viewLetter">
                       <portlet:param name="action" value="getDocum"/>
                       <portlet:param name="documId" value="${doc.documId}"/>
					</portlet:resourceURL>
					<a href="${viewLetter}" target="_blank" ><i class="close-window btn btn-primary" >&nbsp; View</i></a>
					
				</td>
			</tr>
		</c:forEach>
		</table>
	</div>
</div>	
 
<aui:field-wrapper>
    <liferay-ui:input-editor name="descriptionEditor" toolbarSet="liferay-article" width="200">
    </liferay-ui:input-editor>
</aui:field-wrapper> 

<div id="val" style="display:none">
'${letterContent}'
</div>

 <aui:script use="aui-io-request,aui-parse-content,aui-modal">
 
	window.<portlet:namespace />initEditor = function() {
		//var editor1 = $('#editor').ckeditorGet();
		//var editor = CKEDITOR.replace('letter_content');
		 /*  =====INSTANCE====== */
		// var instance = CKEDITOR.instances.content;
		// instance.updateElement();
		//instance.insertElement(data);
		CKEDITOR.config.pasteFromWordRemoveFontStyles=false;
		CKEDITOR.config.pasteFromWordRemoveStyles=false;
		 var data =  A.one("#val").html();
		return data;
 	}
	/*
	window.saveLetter = function() {
		var data = CKEDITOR.instances.editor1.getData();
		A.one('#<portlet:namespace/>letterContent').val(data);	
		A.one("#<portlet:namespace/>saveLetter").submit();
		window.caretIo( '<portlet:actionURL><portlet:param name="action" value="saveLetter" /></portlet:actionURL>', 'json',
				{ 	
					letterContent:  CKEDITOR.instances.editor1.getData()
			  	},
				function( data ) {
					  alert("Success");
				} 
		);
	}*/
	
   </aui:script>