<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<c:set var="type" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx2']}" />
<c:set var="worImId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx1']}" />
<c:set var="primaryKey" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx10']}" />
<c:set var="vcgId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx11']}" />

<portlet:actionURL var="loadProcessApplication">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadProcessApplication" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<portlet:actionURL var="loadVcgManagement">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadVcgManagement" />
	<portlet:param name="vcgId" value="${vcgId}"/>
</portlet:actionURL>

<portlet:actionURL var="createAppfromCall">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="callId" value="${primaryKey}"/>
	<portlet:param name="entry" value="CREATE_APPLICATIONS"/>
</portlet:actionURL>

<portlet:actionURL var="openReferral">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="openReferral" />
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="callId" value="${primaryKey}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>

<portlet:actionURL var="editEntry">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="takeOwnership"/>
	<portlet:param name="worImId" value="${worImId}"/>
	<portlet:param name="type" value="${type}"/>
</portlet:actionURL>



<liferay-ui:icon-menu>
	<liferay-ui:icon image="edit" message="take-ownership" url="${editEntry}" />
	<liferay-ui:icon image="post" message="transfer-to-facility" url="javascript:transfer(${worImId});"  />
	<liferay-ui:icon image="assign" message="assign-ownership" url="javascript:assignTo(${worImId});" />
	<liferay-ui:icon image="time" message="work-audit" url="javascript:auditLog(${worImId});" />
	
	<!-- liferay-ui:icon image="reply" message="transfer-accept-reject"  url="javascript:transferDo(${worImId},${userOrgIds}, '${queId}', ${fn:contains(userOrgIds, queId)});"  /-->
	
	<c:set var="documId" value="${SEARCH_CONTAINER_RESULT_ROW.object['ndx12']}" />
	<c:if test="${documId gt 0}" >
		<portlet:resourceURL var="getDocum">
			<portlet:param name="action" value="getDocum"/>
			<portlet:param name="documId" value="${documId}"/>
		</portlet:resourceURL>
		<liferay-ui:icon image="page" useDialog="false" target="_blank"  message="view-document" url="${getDocum}" />
	</c:if>
	<c:choose>
		<c:when test="${fn:contains(type, 'REFERRAL')}">
			<liferay-ui:icon image="preview" message="view-referral" url="${openReferral}" />
			<liferay-ui:icon image="add" message="start-application"  url="${createAppfromCall}" />
		</c:when>
		<c:otherwise>
			<c:choose>
				<c:when test="${vcgId gt 0}">
			        <liferay-ui:icon image="group" message="manage-vcg" url="${loadVcgManagement}"/>
			    </c:when>    
			    <c:otherwise>
			        <liferay-ui:icon image="submit" message="process-application" url="${loadProcessApplication}" />
			    </c:otherwise>		
			</c:choose>
		</c:otherwise>
	</c:choose>
	<c:if test="${fn:endsWith(type, '_APP')}">
				<liferay-ui:icon image="add" message="new-note" url="javascript:newWorkNote(${worImId});" />
			</c:if>
</liferay-ui:icon-menu>