<%@ include file="/jsp/init.jsp" %>

	<c:set var="ndx" value="primaryPerson" />	
	<c:set var="searchCss" value="search-person-action icon-search" />
	<c:set var="cssClass" value="${form_['primaryRequired']}" />	
	
	<c:set var="isDisabled" value="${false}" />
	<c:set var="caretCss" value="${cssClass}" />
	<%@include file="/jsp/internal/person.jsp" %>

	<c:set var="includeFacility" value="${false}" />
	<c:set var="isDisabled" value="${false}" />	
	<%@include file="/jsp/common/editAddress.jsp" %>
	
	<br>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['phone']}"  >
		<aui:input label="phone1" cssClass="phone-field" name="${ndx}_phone" type="text" size="25" value="${person.phone}" />
	</aui:field-wrapper>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="phone2" cssClass="phone-field" name="${ndx}_phone2" type="text" size="25" value="${person.phone2}" />
	</aui:field-wrapper>
			
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
		<aui:input label="email" cssClass="email-field" name="${ndx}_email" id="${ndx}_email" max="75" type="text" size="25" value="${person.email}"  />
	</aui:field-wrapper>

	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['primaryRelationship']}"   >
		<aui:select disabled="${isDisabled}" label="online-cg-relationship" name="vcgAn_primaryRelationship" id="vcgAn_primaryRelationship" >
			<aui:option label="select-relationship" value="" selected="true" />
			<aui:option label="family" cssClass="section" disabled="true" />
			<c:forEach var="relationship" items="${caretMap_['relationship-family']}">
				<aui:option cssClass="family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].primaryRelationship eq relationship}" />
			</c:forEach>
			<aui:option label="not-family" cssClass="section" disabled="true" />
			<c:forEach var="relationship" items="${caretMap_['relationship-not-family']}">
				<aui:option cssClass="not-family relationship" value="${relationship}" label="${relationship}" selected="${form_['vcgAn'].primaryRelationship eq relationship}" />
			</c:forEach>
		</aui:select>
	</aui:field-wrapper>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass['mediEnrolled']}"  >		
		<aui:select cssClass="yes-no-select" disabled="${isDisabled}" label="enrolled-in-medicare" name="vcgAn_mediEnrolled"  >
			<aui:option label="yes" selected="${form_['vcgAn'].mediEnrolled}" value="true" />
			<aui:option label="no" selected="${!form_['vcgAn'].mediEnrolled}" value="false" />
		</aui:select>
	</aui:field-wrapper>
	
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass['otherHealthInsurance']}"  >
		<aui:select cssClass="yes-no-select" disabled="${isDisabled}" label="other-health-insurance" name="${ndx}_otherHealthInsuranceYesNo" id="${ndx}_otherHealthInsuranceYesNo" >
			<aui:option label="yes" selected="${not empty person.otherHealthInsurance}" value="true" />
			<aui:option label="no" selected="${empty person.otherHealthInsurance}" value="false" />
		</aui:select>
		&nbsp;
		<aui:input disabled="${isDisabled || empty person.otherHealthInsurance}" label="" name="${ndx}_otherHealthInsurance" id="${ndx}_otherHealthInsurance" type="text" size="25" value="${person.otherHealthInsurance}" />
	</aui:field-wrapper>
	
	<!-- 
	<div class="certify-that float-left" >
		<aui:input label="" cssClass="float-left required-input" id="primaryRelationship" name="certify-that" type="checkbox" />
		<div id="primaryFamily" class="hidden-msg" ><p>
			<liferay-ui:message key="caregiver-certify-as-family" /></p>
		</div>
		<div id="primaryNotFamily" class="hidden-msg" ><p>
			<liferay-ui:message key="caregiver-certify-not-as-family" /></p>
		</div><p><liferay-ui:message key="primary-perform-services-to-veteran" /></p>		
	</div>
	
	<div class="clear-both"></div>
	-->
	
<aui:script use="aui-base">

	/*
	A.one('#<portlet:namespace/>vcgAn_primaryRelationship').on( 'change', function( event ) {
		var eventId = event.currentTarget.attr('id');
   	  	var str = this._node.options[this._node.selectedIndex].getAttribute('class');
   	  	
   	  	if ( str.indexOf('not-family') > -1 ){ 		    	  		
			if ( A.one ('#primaryNotFamily').hasClass('hidden-msg') ){
				A.one ('#primaryNotFamily').removeClass('hidden-msg');
			}
   	  		if ( ! A.one ('#primaryFamily').hasClass('hidden-msg') ){
				A.one ('#primaryFamily').addClass('hidden-msg');
			}
		} else {		    	  		
   	  		if ( A.one ('#primaryFamily').hasClass('hidden-msg') ){
				A.one ('#primaryFamily').removeClass('hidden-msg');
			}
   	  		if ( ! A.one ('#primaryNotFamily').hasClass('hidden-msg') ){
				A.one ('#primaryNotFamily').addClass('hidden-msg');
			}
		}		    	  	
	});
	*/
		 
	 var temp = ''; 
	
	 A.one('#<portlet:namespace/>${ndx}_otherHealthInsuranceYesNo').on('change',function( event ) {
    	  	if ( this.val() === 'false' ){
    	  		//temp = A.one( "#<portlet:namespace/>${ndx}_otherHealthInsurance" ).val();
    	  		A.one( "#<portlet:namespace/>${ndx}_otherHealthInsurance" ).val('');
    	  		A.one( "#<portlet:namespace/>${ndx}_otherHealthInsurance" ).attr('disabled',true);
    	  	} else {
    	  		//A.one( "#<portlet:namespace/>${ndx}_otherHealthInsurance" ).val(temp);
    	  		A.one( "#<portlet:namespace/>${ndx}_otherHealthInsurance" ).val();
    	  		A.one( "#<portlet:namespace/>${ndx}_otherHealthInsurance" ).attr('disabled',false);
    	  	}
     });

	window.validatePrimaryFields = function( validateOtherCallback ){
		var submit = true;
		if(A.one('#<portlet:namespace/>${ndx}_primaryKey')!=null ){

			validateFields( function( message ){
		
				/*
				if(A.one('#<portlet:namespace/>vcgAn_primaryRelationship')==null || A.one('#<portlet:namespace/>vcgAn_primaryRelationship').val()=='' ){
					message = message + "<li>Primary Caregiver relationship to Veteran is required</li>";
					A.one('#<portlet:namespace/>vcgAn_primaryRelationship').addClass( 'missing-required-input' );
				}else{
					if ( A.one('#<portlet:namespace/>vcgAn_primaryRelationship').hasClass('missing-required-input') ){
						A.one('#<portlet:namespace/>vcgAn_primaryRelationship').removeClass( 'missing-required-input' );
					}
				}
				*/
				
				if ( message.length > 0 ){
					modalDataValidation.render();
					modalDataValidation.show();
					var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields-primary' /><ul>" + message +"</ul></div>";
					A.one ('#primaryValidationResult').html(msg);
					submit = false;
				}else{
					A.one ('#primaryValidationResult').html('');
				}
				validateOtherCallback( submit );
			});
		}else{
			A.one ('#primaryValidationResult').html('');
			validateOtherCallback( submit );			
		}
	}

	window.validatePrimaryAddress = function( validateOtherCallback ){
		var submit = true;

		if(A.one('#<portlet:namespace/>${ndx}_primaryKey')!=null ){
			validateAddress( function( message ){	
				if ( message.length > 0){
					modalAddressValidation.render();
					modalAddressValidation.show();			

					var msg = "<ul><li> Primary Caregiver - " + message +"</li></ul>";
					var theDiv = document.getElementById('addressValidationResult');
					theDiv.innerHTML += msg;
	
					submit = false;				
				}	
				validateOtherCallback( submit );
			});
		}else{
			validateOtherCallback( submit );			
		}
	}
			

	<%@include file="/jsp/internal/cscValidation.jsp" %>

</aui:script>

