<%@ include file="/jsp/init.jsp" %>

<portlet:actionURL var="saveEntryCesp">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="saveEntry"/>
	<portlet:param name="entry" value="cesp"/>
</portlet:actionURL>


<style>
	.sectionHeading{
	    border: thin solid #d9d9d9;
	    background-color: #f0efef;
		font-weight: bold;
		margin: 1px;
		padding: 3px;
		width: 99%;
	}
	.summaryTable table, th, td{
	    border: thin solid #d9d9d9;
	    border-collapse: collapse;
	    margin: 12px;
	    padding: 5px;
	    text-align: center;
	}
	.summaryTable tr:hover {
		background-color: #f5f5f5;
	}
	.summaryTable th {
	    background-color: #f0efef;
	}
</style>



<form name="cespEntry" method="post" action="${saveEntryCesp}" >
	<input type="hidden" name="TRACKER" value="${TRACKER}" >
	<input type="hidden" name="cesp_callId" value="${call.callId}" >
	<input type="hidden" name="cesp_createdByPersnId" value="${form_['loggedPersnId']}" >
	<input type="hidden" name="cesp_numOfCesp" value="${form_['numOfCesp']}" >
	<input type="hidden" name="cesp_step" value="${form_['step']}" >
	

	<div class="sectionHeading">CESP History</div>	
	<div class="summaryTable">
	<table style="width:70%">
		<tr>
		  <th width="10%">CESP Id</th> 
		  <th width="10%">Step</th> 	  
		  <th width="20%">Status</th> 
		  <th width="30%">Date and Time</th>
		  <th width="30%">Created By</th>
		</tr>

		<c:if test="${form_['numOfCesp'] gt 0}">
			<c:forEach var="oneCesp" items="${form_['cesp-history']}" >
			  <tr>
			    <td>${oneCesp.cesp.cespId}</td>
			    <td>${oneCesp.cesp.step}</td>
			    <td>${oneCesp.cesp.status}</td>
			    <td>${oneCesp.formattedCreatedDate}</td> 
			    <td>${oneCesp.cespCreatedByName}</td> 
			  </tr>
			</c:forEach>
		</c:if>
		<c:if test="${form_['numOfCesp'] eq 0}">
			<tr>
				<td colspan=5>No previous CESP </td>
			</tr>
		</c:if>
	</table>
	</div>
	
	
	<div class="sectionHeading">CESP Input</div>	
   	<c:if test="${form_['cespStatus'] eq 'closed'}">
   		<br>
    	<div class='portlet-msg-alert'><liferay-ui:message key="cesp-closed-msg" /></div>
    </c:if>

	<c:if test="${form_['cespStatus'] ne 'closed'}">

	<!-- if cesp not found in cesp table - initial cesp -->
	<c:if test="${form_['numOfCesp'] eq '0'}">
   		<br>
   		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}" >
   			<label>
    			<liferay-ui:message key="cesp-referred-by" />
   			</label>
   			<div class="referred-by">
			<aui:input type="radio" name="cesp_referredBy" label="csl" value="CSL"/>
		    <aui:input type="radio" name="cesp_referredBy" label="csc" value="CSC"/>  
		    </div>
   		</aui:field-wrapper>
	    
	    <br>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}" >
			<aui:select id="assignedUser" label="cesp-assigned-csl" name="cesp_assignedCslPersnId">				
				<aui:option value="" >Select</aui:option>
			</aui:select>
		</aui:field-wrapper>	
		
		<aui:script use="aui-tooltip">
			A.one('.referred-by').on('change', function( event ) {
		    	window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="getUserList" /></portlet:resourceURL>', 'json', 
					{ 
		    			referredBy: A.one("input[name=<portlet:namespace/>cesp_referredBy]:checked").get("value")
		    		},
					function( data ){
						var assignedUserNode = A.one ( '#<portlet:namespace/>assignedUser' );
				    	var options = "<option value=''>Select</option>";			    	
				    	var userList = data.userList;
				    	
				    	if(data.userListSize > 0){
				    		for ( var i = 0; i < data.userListSize; i++  ){
					    		options = options + '<option value="' + userList[i].persnId + '">'+ userList[i].name + '</option>';
					    	 }			    		
				    	}
				    	assignedUserNode.html( options );
					} 
				);
			});
			
			A.one('#submitCespForm').on('click', function() {	
				document.forms['cespEntry'].submit();
			});
		</aui:script>
		
	</c:if>
	    			
    <br>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}"  >
 		<aui:input label="cesp-goals" name="cesp_goals" size="50" cssClass="call-cesp-goal" type="textarea"  />
	</aui:field-wrapper>
	
    <br>
	<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}"  >
 		<aui:input label="cesp-plan" name="cesp_planProgressBarrier" size="50" cssClass="call-cesp-plan" type="textarea"  />
	</aui:field-wrapper>
    
    
    <c:if test="${form_['numOfCesp'] gt '0'}">   
 	    <div id="closedRB">
   		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}" >
   			<label>
    			<liferay-ui:message key="cesp-closed" />
   			</label>
   			<aui:input type="radio" name="cesp_cespClosed" label="yes" value="Yes" />
   			<aui:input type="radio" name="cesp_cespClosed" label="no" value="No" />
   		</aui:field-wrapper>
   		</div>

	   	<div id="closedDetails">
			<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}" >
				<aui:select label="cesp-closed-reason" name="cesp_cespClosedReason">
					<aui:option value="" label="select"  />
					<aui:option value="Goals Reached" >Goals Reached</aui:option>
					<aui:option value="Participation Discontinued - refer to CSC" >Participation Discontinued - refer to CSC</aui:option>
					<aui:option value="Participation Discontinued - do not refer to CSC" >Participation Discontinued - do not refer to CSC</aui:option>
				</aui:select>
			</aui:field-wrapper>
	
			<br>
	   		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout-wide-input ${cssClass}" >
	   			<label>
	    			<liferay-ui:message key="cesp-goals-reached" />
	   			</label>
	   			<aui:input type="radio" name="cesp_goalsReached" label="yes" value="Yes" />
	   			<aui:input type="radio" name="cesp_goalsReached" label="no" value="No" />
	   		</aui:field-wrapper>
		</div>

		<aui:script use="aui-modal">
		
		    A.one("#closedDetails").hide();
		
			A.one('#closedRB').on('click', function( event ){
				if(null!=A.one("input[name=<portlet:namespace/>cesp_cespClosed]:checked")){
					cespClosed= A.one("input[name=<portlet:namespace/>cesp_cespClosed]:checked").get("value");	
					if("Yes"==cespClosed){
						A.one("#closedDetails").show();
					}
					if("No"==cespClosed){
						A.one("#closedDetails").hide();
					}
				}		
			});
			
			var cespModal = new A.Modal({
			    headerContent: '<h4><liferay-ui:message key="data-validation-header" /></h4>',
			    bodyContent: A.one("#cespValidationDiv"),
			    centered: true,
			    destroyOnHide: false,
			    modal: true,
			    render: '#cespValidationModal',
			    resizable: {
			      handles: 'b, r'
			    },
			    visible: false,
			    width: 600
			});

			A.one('#submitCespForm').on('click', function() {	
		    	if(null==A.one("input[name=<portlet:namespace/>cesp_cespClosed]:checked")){
		    		cespModal.render();
		    		cespModal.show();
		    		A.one('#closedRB' ).addClass( 'missing-required-input' );
		    		var msg = "<div class='portlet-msg-alert'>'CESP Closed?' is required</div>";
		    		A.one ('#cespValidationResult').html(msg);
		    	}else{
		    		document.forms['cespEntry'].submit();
		    	}
			});
		</aui:script>
    </c:if>
    
   
	<div class="clear-both">
		<button type="button" id="submitCespForm" class="btn btn-primary" >
			<liferay-ui:message key="submit-cesp" />
		</button>
		
		<a href="<portlet:actionURL/>" class="btn btn-primary" >
			<liferay-ui:message key="cancel" />
		</a>
		
	</div>
	
	</c:if>
	
</form>

	<div class="yui3-skin-sam">
	    <div id="cespValidationModal"></div>
	</div>

	<div id="cespValidationDiv" class="yui3-skin-sam">
	    <div id="cespValidationResult"></div>
	</div>
	