<%
/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
%>

<%@include file="/jsp/init.jsp" %>

<!-- %@include file="/jsp/online/console.jsp" % -->

<div class="yui3-skin-sam">
    <div id="modal"></div>
</div>

<%@include file="/jsp/internal/menu.jsp" %>



<div id="mainTab">
  <ul class="nav nav-tabs">
    <li class="tab-click" ><a href="#tab-1"><div class="icon-home"></div> ${role} Dashboard<!-- ${facilityNumber} --></a></li>
    <li class="tab-click" ><a href="#tab-2"><div class="icon-search"></div> Search</a></li>
  </ul>

  <div class="tab-content">
    <div id="tab-1" class="tab-pane">
      	<div class="dashboard-top">
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse1">
			      	<legend class="header toggler-header-expanded"><div class="icon-bookmark"></div> My Work</legend>
			      	<div class="content toggler-header-expanded" id="cbopcReview" >
					</div>
				</fieldset>
      		</div>
      		<div class="internal-split-pane">
      			<fieldset id="sectionCollapse2">
		      		<legend class="header toggler-header-expanded"><div class="icon-comment"></div> Messaging</legend>
		      		<div class="content toggler-header-expanded" id="myNotes" >
	      			</div>
      			</fieldset>
      		</div>
      	</div>
      	
      	<fieldset id="sectionCollapseCbopc1" class="clear-both">
			<legend class="header toggler-header-expanded"><div class="icon-hospital"></div> ${facilityName} </legend>
			   <div id="midTabs" class="content toggler-header-expanded" >
					<ul class="nav nav-tabs">
					
					    <li class="tab-click" ><a href="#cbopcChampva">ChampVA (<span id='total_cbopcChampva'>${total_['cbopcChampva']}</span>)</a></li>
					    <li class="tab-click" ><a href="#cbopcVendor">Vendor (<span id='total_cbopcVendor'>${total_['cbopcVendor']}</span>)</a></li>
					    <li class="tab-click" ><a href="#tierChange">Tier Change (<span id='total_dueTodayWork'>${total_['tierChange']}</span>)</a></li>
					    <li class="tab-click" ><a href="#revocations">Caregiver Revocation (<c:if test="${ ! empty FILTERED['revocations']}">*</c:if><span id='total_overdueInProcess'>${total_['revocations']}</span>)</a></li>
					    <li class="tab-click" ><a href="#reinstatements">Caregiver Reinstatement (<span id='total_newApplications'>${total_['reinstatements']}</span>)</a></li>
					    <li class="tab-click" ><a href="#recoupments">Caregiver Recoupment (<span id='total_transferred'>${total_['recoupments']}</span>)</a></li>
						<li class="tab-click" ><a href="#lostChecks">Caregiver Lost Check (<span id='total_referralWork'>${total_['lostChecks']}</span>)</a></li>
					    <li class="tab-click" ><a href="#rejectedPayments">Caregiver Rejected Payment (<span id='total_homeVisit'>${total_['rejectedPayments']}</span>)</a></li>
					    <li class="tab-click" ><a href="#approvedCaregivers">Approved Caregivers (<span id='total_deathNotice'>${total_['approvedCaregivers']}</span>)</a></li>
					  
					</ul>
					<div class="tab-content">
						<div id="cbopcChampva" class="tab-pane"></div>
						<div id="cbopcVendor" class="tab-pane"></div>
						<div id="tierChange" class="tab-pane"></div>
						<div id="revocations" class="tab-pane"></div>
						<div id="reinstatements" class="tab-pane"></div>
						<div id="recoupments" class="tab-pane"></div>
						<div id="lostChecks" class="tab-pane"></div>
						<div id="rejectedPayments" class="tab-pane"></div>
						<div id="approvedCaregivers" class="tab-pane"></div>
					</div>
				</div>
		  </fieldset>
		  
	
		  
	  	<fieldset  id="sectionCollapseCbopc2" class="clear-both">
			<legend class="header toggler-header-collapsed"><div class="icon-hand-up"></div>  Secondary Work Items</legend>
			<div id="bottomTabs3" class="content toggler-content-collapsed" >
					<ul class="nav nav-tabs">
					    <li ><a href="#revoke_tab">Held Payments (${total_['revocationCount']})</a></li>
					    <li ><a href="#correct_tab">Duplicate Payments (${total_['correctionCount']})</a></li>
					    <li ><a href="#reject_tab">Rejected and Held Payments(${total_['rejectionCount']})</a></li>
					    <li ><a href="#consideration">Consideration (${total_['correctionCount']})</a></li>
					    <li ><a href="#lost_check">Lost Check (${total_['rejectionCount']})</a></li>
					</ul>
				<div class="tab-content">
					<div id="0revoke_tab" class="tab-pane">
					  	<div class="portlet-msg-info hidden-msg" >No Held Payments were found.</div>
					</div>
					<div id="0correct_tab" class="tab-pane">
					   	<div class="portlet-msg-info hidden-msg" >No Duplicate Payments were found.</div>
					</div>
					<div id="0reject_tab" class="tab-pane">
					  	<div class="portlet-msg-info hidden-msg" >No Rejected and Held Payments were found.</div>
					</div>
					<div id="0consideration" class="tab-pane">
					   	<div class="portlet-msg-info hidden-msg" >No Considerations were found.</div>
					</div>
					<div id="0lost_check" class="tab-pane">
					  	<div class="portlet-msg-info hidden-msg" >No Lost Checks were found.</div>
					</div>
				</div>
			</div>
			</fieldset>
    </div>

    <div id="tab-2" class="tab-pane">
		<%@include file="/jsp/internal/filter.jsp" %>
	</div>
  </div>

</div>


<aui:script use="aui-tabview,aui-modal,aui-dropdown,aui-toggler,node-event-simulate">
	
	for ( i = 1 ; i < 3; i++ ){
	    new A.TogglerDelegate(
	      {
	        animated: true,
	        container: '#sectionCollapseCbopc' + i ,
	        content: '.content',
	        expanded: true,
	        header: '.header',
	        transition: {
	          duration: 0.2,
	          easing: 'cubic-bezier(0, 0.1, 0, 1)'
	        }
	      }
	    );
	}

	A.all('.close-window').on(
	 'click',
	  function() {
		modal.hide();	    	  
	  }
	);
    
    
    var loadList = function(e, page) {
	  	if (!page){
	   		var href = e.currentTarget.getActiveTab().one('a').attr('href');
	  	   	page = href.substring(href.indexOf('#'));
		}
		var node = A.one( page );
	    if (node.hasClass('loaded-pane')){
	    	return false;
	    }
	
		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="loadList" /></portlet:resourceURL>', 'html', 
			{ page: page },
			function( data ){
				overwrite( node, data );
			} 
		);
	}
    
    window.midTabs = new A.TabView({
        srcNode: '#midTabs',
        type: 'pills',
        on: {
            click: function(e){ loadList(e); }
          }
      }      
    );
    window.midTabs.render();

  window.careTmainTab = new A.TabView({
      srcNode: '#mainTab',
      type: 'pills'
    }
  );
  window.careTmainTab.render();
  
  A.on('domready', function( event ) {
   	try {
   		A.one('#cbopcChampva').simulate('click');
   		loadList(event,'#cbopcChampva');
   		loadList(event,'#myNotes');
   		loadList(event,'#cbopcReview');
   		A.all('.tab-click').attr('tabindex',0);
   	} catch (e){}
   });
  
</aui:script>

<%@include file="/jsp/internal/actionsSupport.jsp" %>
<%@include file="/jsp/im/compose.jsp" %>