package gov.va.iam;

import gov.va.iam.esig.dss.AddUserFailedException_Exception;
import gov.va.iam.esig.dss.ESigDSS;
import gov.va.iam.esig.dss.ESigDSSService;
import gov.va.iam.esig.dss.Exception_Exception;
import gov.va.iam.esig.dss.SignFailedException_Exception;
import gov.va.iam.esig.dss.UnsupportedFileTypeException_Exception;

public class IamService {

	final static String appId = "200CARE";
	final static String reason = "Approve";
	final static String fileName = "10-10CG.pdf";
	
	private IamService(){}
	
	private static ESigDSS getEsigPort(){
		return new ESigDSSService().getESigDSSPort();
	}
	
	public static String verifyPdf(byte[] file, String userId) throws Exception_Exception{
		return getEsigPort().verify(appId, fileName, file, userId);
	}
	
	public static byte[] signPdf(String userid, String commonname, String email, byte[] file, String signField, String gmtoffset )
					throws Exception_Exception, AddUserFailedException_Exception, SignFailedException_Exception, UnsupportedFileTypeException_Exception{
		return getEsigPort().sign(userid, commonname, email, appId, fileName, file, reason, gmtoffset, null, null, null, null, null, signField );
	}
	
}
