package gov.va.caret.view;

import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringPool;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletRequest;


public class GenericReport implements Comparable<GenericReport>, Serializable {
	
	private static final long serialVersionUID = 1L;
	
	public static final String MY_APPLICATIONS = "myApplications";

	public static final String MY_MESSAGES = "myMessages";

	public static final String MY_VCG_STATUS = "myVcgStatus";

	public static final String MY_STIPENDS = "myStipends";

	
	private String name;
	private ReportParameter[] parameter = new ReportParameter[0];
	private String filtered = StringPool.BLANK;
	private boolean lazy = false;
	private String orderBy;
	private boolean desc = false;
	private int queryColumn = 0;
	
	public GenericReport(String reportName) {
		super();
		this.name = reportName;
	}
	
	public GenericReport(String reportName, boolean lazy) {
		super();
		this.name = reportName;
		this.lazy = lazy;
	}
	
	public GenericReport(String reportName,
			ReportParameter... parameters ) {
		super();
		this.name = reportName;
		this.parameter = parameters;
	}
	
	public GenericReport(String reportName, boolean lazy, 
			String orderBy, boolean desc ) {
		super();
		if ( orderBy != null && !orderBy.isEmpty() ){
			this.orderBy = orderBy.split(",")[0];
		}
		this.desc = desc;
		this.name = reportName;
		this.lazy = lazy;
	}
	
	public GenericReport(String reportName, boolean lazy, 
			String orderBy, boolean desc,
			ReportParameter... parameters ) {
		this(reportName, lazy, orderBy, desc, 0, parameters);
	}
	
	public GenericReport(String reportName, boolean lazy, 
			String orderBy, boolean desc, int queryColumn,
			ReportParameter... parameters ) {
		super();
		if ( orderBy != null && !orderBy.isEmpty() ){
			this.orderBy = orderBy.split(",")[0];
		}
		this.queryColumn = queryColumn;
		this.desc = desc;
		this.name = reportName;
		this.parameter = parameters;
		this.lazy = lazy;
	}

	public String getName() {
		return name;
	}
	
	public String getOrderBy() {
		return orderBy;
	}
	
	public boolean isDesc() {
		return desc;
	}
	
	public void setOrderBy( String orderBy ) {
		this.orderBy = orderBy;
	}
	
	public void toggleOrder( ) {
		this.desc = !this.desc;
	}
	
	public void setDesc( boolean desc ) {
		this.desc = desc;
	}

	public ReportParameter[] getParameterNames() {
		return parameter;
	}
	
	public boolean isLazy(){
		return lazy;
	}
	
	public String getFiltered(){
		return filtered;
	}
	
	public void setFiltered( String filtered ){
		this.filtered = StringPool.FALSE.equals( filtered )? StringPool.BLANK : filtered;
	}

	public String toString(){
		return name;
	}
	
	public int hashCode(){
		return name.hashCode();
	}

	public boolean equals(Object o) {
		return o == null? false: o.toString().equals( toString() );
	}

	@Override
	public int compareTo(GenericReport o) {
		return name.compareTo(o.name);
	}
	
	public void run ( PortletRequest request, boolean loadFromParams ){
		run(request, loadFromParams, 0, 0);
	}
	
	public void run ( PortletRequest request, boolean loadFromParams, int start, int end ){
		try {
			ReportParameter[] val = getParameterNames();
			
			Object parameters = null;
			if ( val != null && val.length == 1){
				if ( loadFromParams ){
					parameters = ParamUtil.getLong(request, getParameterNames()[0].name() );
				} else {
					parameters = CaretParam.getParameter( request, getParameterNames() );
				}
			} else {
				Map entries = new HashMap<String,Object>();
				String parameter = null;
				for ( ReportParameter name : getParameterNames() ){
					switch(name){
					case queId: 
						if ( loadFromParams ){
							entries.put( name.name(), ParamUtil.getLong(request, "userOrgIds" ) );
						} else {
							entries.put( name.name(), CaretParam.getUserOrgParameter( request, name ) );
						}
						break;
					case userId:
					case roleId:
					case socDueDate:
					case userOrgIds:
						if ( loadFromParams ){
							entries.put( name.name(), ParamUtil.getLong(request, parameter == null? name.name(): parameter ) );
						} else {
							entries.put( name.name(), CaretParam.getUserOrgParameter( request, name ) );
						}
						break;
					}
				}
				parameters = entries;
			}
			String orderByCol = request.getParameter(SearchContainer.DEFAULT_ORDER_BY_COL_PARAM);
			if (orderByCol != null && orderByCol.length() > 3 ){
				if ( Character.isDigit( orderByCol.charAt(3) ) ){
					int ndx = Integer.valueOf(orderByCol.substring(3));
					if ( ndx > 0){
						orderByCol = queryColumns[getQueryColumnIndex()].get(ndx);
					}
				}
			}
			if ( orderByCol != null && !orderByCol.isEmpty() ){
				setOrderBy( orderByCol );
			} else {
				orderByCol = getOrderBy();
			}
			
			String byType = request.getParameter(SearchContainer.DEFAULT_ORDER_BY_TYPE_PARAM);
			if ( byType!= null && !byType.isEmpty() ){
				setDesc( "desc".equals(byType) );
			}
			
			String type = request.getParameter("type");
			if ( type != null && !type.isEmpty() ){
				_log.info("type..." + type );
				setFiltered(type);
			}
			
			if ( !getFiltered().isEmpty() ){
				if ( getFiltered().equals( type ) ){
					_log.info("report.getFiltered().equals( type ) -" + type );
				}
				type = getFiltered();
				if ( parameters instanceof Map ){
					((Map)parameters).put("FILTERED", " and wi.type_ = '" + type + StringPool.APOSTROPHE );
				}
				ResultMap.getResultFilteredMap( request ).put( getName(), getFiltered() );
			}
			
			List<Map<String, Object>> list = CaretLocalServiceUtil.getReport( 
					getName(), parameters, nlsort(orderByCol), isDesc(), start, end);
			
			ResultMap.getResultListMap( request ).put( getName(), list );
			ResultMap.getResultTotalMap( request ).put( getName(), 
								CaretLocalServiceUtil.getReportCount( getName(), parameters) );

			ResultMap.getResultOrderColumnMap( request ).put( getName(), getNdx(orderByCol) );
			
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	public String getPageName() {
		return getName();
	}

	private String nlsort(String orderByCol) {
		if ( indexed.contains(orderByCol) ){
			return SORT_B + orderByCol + SORT_E;
		} 
		return orderByCol;
	}

	public int getQueryColumnIndex(){
		return queryColumn;
	}
	
	public String getNdx ( String columnName ) {
		String ndx = CaretStrPool.ROWNUM;
		int index = queryColumns[getQueryColumnIndex()].indexOf(columnName);
		if ( index > -1 ){
			return CaretStrPool.NDX + (index);
		}
		return ndx;
	}
	
	public final static int CBOPC_QUERY_NDX = 1;
	public final static int CALL_QUERY_NDX = 2;
	public final static int NOTES_QUERY_NDX = 3;
	public final static int DISP_QUERY_NDX = 5;

	
	private List<String>[] queryColumns = new List[]{ 
			Arrays.asList( new String[] { StringPool.BLANK, "wi.worImId", "type_", " creationDate", "dueDate", "wi.status", "pn.firstName", "pn.lastName", "cg.firstName", "cg.lastName", "wi.classPk", "wi.vcgId", "d.documId", "us.screenName", "wi.queId" } ),
			Arrays.asList( new String[] { StringPool.BLANK, "wi.worImId", "wi.TYPE_", "wi.creationDate", "wi.dueDate", "wi.status", "pn.firstName", "pn.lastName", "cg.firstName", "cg.lastName", " wi.classPk", "wi.vcgId", "wi.userId", "wi.queId",  "us.firstName", "us.lastName", "us2.firstName", "us2.lastName", "wi.completionDate" } ),
			Arrays.asList( new String[] { StringPool.BLANK, "c.workPrimaryKey", "c.callType", "c.callerRelationship", "c.creationDate", "c.callState", "vet.lastName", "vet.firstName", "vet.middleName", "clr.lastName", "clr.firstName", "clr.middleName", "org.name", "c.callId", "d.documId", "soc.creationDate", "soc.clsocId", "soc.attemptNum", "soc.tresholdmet", "cesp.status", "us.screenName" } ),
			Arrays.asList( new String[] { StringPool.BLANK, "chainId", "creationDate", "value" } ),
			Arrays.asList( new String[] { StringPool.BLANK, "assmt.assmtid", "assmt.TYPE_", "assmt.scheduleDate", "vln", "cln", "vetPrsn.zip", "cgPrsn.zip", "vcg.vcgId" } ),
			Arrays.asList( new String[] { StringPool.BLANK, "g1.vcgId", "g1.secondaryId", "g1.veteranId", "g1.secondaryInitDispDate", "p1.lastName", "p1.firstName", "v1.lastName", "v1.firstName", "g1.secondaryType", "g1.secondaryRevocationDate" } )
			};

//	TODO: Create case insensitive indexes for all the needed columns to prevent full table scan...
	private static List<String> indexed = Arrays.asList( new String[] { "pn.lastName", "clr.lastName", "cg.lastName", "vet.lastName", "c.callType" } );
//	static{
//		String[] indexed = PortletProps.get(CaretStrPool.INDEXED_CASE_INSENSITIVE).split(StringPool.COMMA);
//		if ( indexed != null && indexed.length > 0 ){
//			GenericReport.indexed = Arrays.asList( indexed );
//		}
//	}
	
	private final static String SORT_B = "NLSSORT(";
	private final static String SORT_E = ",'nls_sort=BINARY_CI')";
	
	private static Log _log = LogFactoryUtil.getLog( GenericReport.class );
}
