package gov.va.caret.sso;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class SSOeUser extends SSOUser {

	private static final String SITE = "AccessVA CareT";
	private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmsszzzz");
	private static SimpleDateFormat sdf12 = new SimpleDateFormat("yyyyMMddHHmm");
	private static SimpleDateFormat sdf14 = new SimpleDateFormat("yyyyMMddHHmmss");
	
	public SSOeUser(HashMap<String, String> headers, Connection con) throws Exception {
		
		
		super(headers);
		_site_name = SITE;
		l("SITE_NAME SET TO : " + _site_name);
		
		
		
		String temp = safeGet("va_eauth_uid");
		if(temp.contains(","))
		{
			String[] tparts = temp.split(",");
			for(String p:tparts)
			{
				if(p.startsWith("id="))
				{
					_sname = p.substring(p.indexOf("=") + 1);
					break;
				}
			}
		}else
		{
			_sname = safeGet("va_eauth_uid");
		}
		

		
		_fname = safeGet("va_eauth_firstname");
		_lname = safeGet("va_eauth_lastname");
		_mname = safeGet("va_eauth_middlename");
		
		_email = safeGet("va_eauth_emailaddress");
		_icn = safeGet("va_eauth_icn");
		_street1 = safeGet("va_eauth_street");
		_street2 = safeGet("va_eauth_street1");
		_street3 = safeGet("va_eauth_street2");
		_street4 = safeGet("va_eauth_street3");
		_city = safeGet("va_eauth_city");
		_state = safeGet("va_eauth_state");
		_zip = safeGet("va_eauth_postalcode");
		_country = safeGet("va_eauth_country");
		_phone = safeGet("va_eauth_phone");
		_prefix =  safeGet("va_eauth_prefix");
		_suffix =  safeGet("va_eauth_sufix");
		_gender =  safeGet("va_eauth_gender");
		
		
		_dob =  safeGet("va_eauth_birthdate_v1");
		if(_dob != null)
		{
			if(_dob.length() == 12)
				try{	_dob_date = sdf12.parse(_dob); } catch(Exception dobex){ l("COULD NOT PARSE DATE " + _dob + " WITH sdf12 (yyyyMMddHHmm)"); }
			else
			if(_dob.length() == 14)
				try{	_dob_date = sdf14.parse(_dob); } catch(Exception dobex){ l("COULD NOT PARSE DATE " + _dob + " WITH sdf14 (yyyyMMddHHmmss)"); }
			else
				try{	_dob_date = sdf.parse(_dob); } catch(Exception dobex){ l("COULD NOT PARSE DATE " + _dob + " WITH sdf (yyyyMMddHHmmsszzzz)"); }
		}
		
		if(safeGet("va_eauth_pnidtype").intern() == "SSN")
			_ssn = safeGet("va_eauth_pnid");
		
		
		if(_icn != null)
		{
			//if it has an icn - that icn came out of MVI. So it's a vet.
			
			_roles = new String[]{"Veteran"};
		}else
		{
			//no ICN - it must be a caregiver
			_roles = new String[]{"Caregiver"};
		}
		
		l("ROLE SET TO : " + _roles[0]);
		
		
	    l(super.toString());
		
	}
	
	private void init_data(Connection con) throws Exception
	{
		
	}
	
	protected void l(String msg)
	{
		System.out.println("SSOeUser------->" + msg);
	}
}
