package gov.va.caret.sso;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import com.ibm.xylem.IdentityHashMap.MapEntry;
import com.liferay.portal.model.User;
import java.util.Date;

class SSOUser {

	
	protected HashMap<String,String> _headerz;
	protected String _sname;
	protected String _fname;
	protected String _lname;
	protected String _mname;
	protected String _email;
	protected String _tz;
	protected String _facility;
	protected String _facility_name;
	protected String _icn;
	protected String _vistaID;
	protected String _site_name;
	protected String _street1;
	protected String _street2;
	protected String _street3;
	protected String _street4;
	protected String _city;
	protected String _state;
	protected String _zip;
	protected String _country;
	protected String _phone;
	protected String _prefix;
	protected String _ssn;
	protected String _suffix;
	protected String _gender = "MALE";
	protected String _dob;
	protected Date _dob_date;
	protected String[] _roles;
	protected Connection _con;

	
	protected void dumpHeaders()
	{
		l("START HEADER DUMP");
		for(Map.Entry<String,String> me: _headerz.entrySet())
		{
			l(me.getKey() + "=" + me.getValue());
		}
		l("END HEADER DUMP");	
		
		
		
		
		
		
		
		
	}
	
	 
	public SSOUser()
	{
		//do nothing - this is a dummy constructor
		
	}
	
	
	protected SSOUser(HashMap<String,String> headers) throws Exception
	{
		_headerz = headers;

		dumpHeaders();
		
		
			
	}
	
	protected HashMap<String,String> get_headers()
	{
		return _headerz;
	}

	protected String get_sname() {
		return _sname;
	}

	protected String get_fname() {
		return _fname;
	}

	protected String get_lname() {
		return _lname;
	}

	protected String get_mname() {
		return _mname;
	}

	protected String get_email() {
		return _email;
	}



	protected String get_tz() {
		return _tz;
	}

	protected String get_facility() {
		return _facility;
	}

	protected String get_facility_name() {
		return _facility_name;
	}

	protected String[] get_roles() {
		
		return _roles;
		//this is just for tesing
		//l("TEST CODE CALLED - RETURNING PSEUDO ROLE 'CSC'");
		//return new String[]{"CSC"};
		
	}


	protected void l(String msg)
	{
		System.out.println("SSOUser-------->" + msg);
	}



	protected String get_icn() {
		return _icn;
	}


	protected String get_vistaID() {
		return _vistaID;
	}
	

	protected String getWelcome() {
		return "Welcome " + _fname + " " + _lname + "!";

	}


	protected boolean getMale() {

		return _gender.toUpperCase().startsWith("M");
	}


	protected String get_site() {
		// TODO Auto-generated method stub
		return _site_name;
	}
	
	
	protected String safeGet(String key)
	{
		if(_headerz.containsKey(key) && _headerz.get(key).trim().toUpperCase().intern() != "NOT_FOUND")
			return _headerz.get(key).trim();
		else
			return null;
		
	}
	

	public String toString()
	{
		
		StringBuilder sb = new StringBuilder();
		sb.append("_sname =  " + _sname + "\n");
		sb.append("_fname =  " + _fname + "\n");
		sb.append("_lname =  " + _lname + "\n");
		sb.append("_mname =  " + _mname + "\n");
		sb.append("_email =  " + _email + "\n");
		sb.append("_tz =  " + _tz + "\n");
		sb.append("_facility =  " + _facility + "\n");
		sb.append("_facility_name =  " + _facility_name + "\n");
		sb.append("_icn =  " + _icn + "\n");
		sb.append("_vistaID =  " + _vistaID + "\n");
		sb.append("_site_name =  " + _site_name + "\n");
		sb.append("_street1 =  " + _street1 + "\n");
		sb.append("_street2 =  " + _street2 + "\n");
		sb.append("_street3 =  " + _street3 + "\n");
		sb.append("_street4 =  " + _street4 + "\n");
		sb.append("_city =  " + _city + "\n");
		sb.append("_state =  " + _state + "\n");
		sb.append("_zip =  " + _zip + "\n");
		sb.append("_country =  " + _country + "\n");
		sb.append("_phone =  " + _phone + "\n");
		sb.append("_prefix =  " + _prefix + "\n");
		sb.append("_ssn =  " + _ssn + "\n");
		sb.append("_suffix =  " + _suffix + "\n");
		sb.append("_gender =  " + _gender + "\n");
		sb.append("_dob =  " + _dob + "\n");

		if(_dob_date != null)
			sb.append("_dob_date =  " + _dob_date.toString() + "\n");

		if(_roles != null)
			for(String role:_roles)
			{
				sb.append("_role =  " + role + "\n");
			}



		return sb.toString();
		
	}
	
	
}
