package gov.va.caret.sso;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleConstants;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ClassNameLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;

import gov.va.caret.model.Note;
import gov.va.caret.model.Persn;
import gov.va.caret.model.WorIm;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.NoteLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;

public class SSOProcessor implements com.liferay.portal.security.auth.AutoLogin {

	final long COMPANY_ID = 20155;//how to get this real time?
	
	
	@Override
	public String[] handleException(HttpServletRequest arg0, HttpServletResponse arg1, Exception arg2) throws AutoLoginException {
	
		arg2.printStackTrace();
		return null;
	}
	
	
	
	@Override
	public String[] login(HttpServletRequest request, HttpServletResponse response) throws AutoLoginException {

		l("PROCESSING SSO LOGIN REQUEST");
		 
		
		/*
		 * return String[]
		 * 				[0] the userid
		 * 				[1] the password
		 * 				[2] true if password is encrypted, false if it is not
		 * 
		 */
		Connection con = null;
		try {
		
			
			//System.out.println("User.class.getName : " + User.class.getName() + "(" + ClassNameLocalServiceUtil.getClassNameId(User.class) + ")");
			//System.out.println("Contact.class.getName() : " + Contact.class.getName() + "(" + ClassNameLocalServiceUtil.getClassNameId(Contact.class) + ")");
			//System.out.println("Group.class.getName() : " + Group.class.getName() + "(" + ClassNameLocalServiceUtil.getClassNameId(Group.class) + ")");
			
			 con = DataAccess.getConnection();		
			 SSOUser iUser = SSOUserFactory.createUser(getHeaders(request), con);
			 
			 if(iUser == null)
			 {
				 l("SSOi/e HEADERS NOT PRESENT - ROUTING TO MANUAL LOGIN PAGE");
				 return null; 
			 }
				 

			 
			 CompanyThreadLocal.setCompanyId(COMPANY_ID);	
			 Date newdate = new Date();	


			 
			 l("CHECKING LR TO SEE OF USER IS ALREADY THERE : " + iUser.get_sname());
			 User liferay_user = null;
			 Persn caret_person = null;
			 try{ 	 liferay_user = UserLocalServiceUtil.getUserByScreenName(COMPANY_ID,iUser.get_sname()); } catch(Exception e) {  }
			 boolean new_user = (liferay_user == null);
			 l("USER EXISTED IN LR : " + (!new_user));
			 if(new_user)
			 {
				 l("ADDING USER VIA USERLOCALSERVICEUTIL.ADDUSERWITHWORKFLOW");
				 
				 //getSiteGroups
				 liferay_user = UserLocalServiceUtil.addUserWithWorkflow((long)0,(long)COMPANY_ID,true,null,null,false,iUser.get_sname(),iUser.get_email(),(long)0,null, 
						 LocaleUtil.getDefault(),iUser.get_fname(),iUser.get_mname(), iUser.get_lname(),
						 1,1,iUser.getMale(),01,01,1970,
						 null,null,null,new long[]{RoleLocalServiceUtil.getRole(COMPANY_ID, RoleConstants.POWER_USER).getRoleId()},
						 null,true,null);
				
				 
				 //Add the correct site to the user.
				 l("ADDING USER " + liferay_user.getScreenName() + " TO SITE " + iUser.get_site());
				 Group liferay_site_group = GroupLocalServiceUtil.getGroup(COMPANY_ID, iUser.get_site());
				 UserLocalServiceUtil.addGroupUser(liferay_site_group.getGroupId(),liferay_user);
 
				 
				 l("ADDING CARET_PERSON VIA PERSNLOCALSERVICEUTIL");
				 caret_person = PersnLocalServiceUtil.addPersn(liferay_user, false);
				 caret_person.setVistaID(iUser.get_vistaID());
				 caret_person.setICN(iUser.get_icn());
				 
				 
				 l("SAVING CARET_PERSON VIA CARETLOCALSERVICEUTIL");
				 CaretLocalServiceUtil.save(caret_person);

					
			 }
			 
			 if(caret_person == null)
			 {
				 try{	 caret_person = PersnLocalServiceUtil.getByUser(liferay_user.getUserId());	 }catch(Exception e) {		 }
				 
				 if(caret_person == null)
				 {
					 l("ADDING CARET_PERSON VIA PERSNLOCALSERVICEUTIL BECAUSE IT HAD NOT BEEN CREATED YET");
					 caret_person = PersnLocalServiceUtil.addPersn(liferay_user, false);
					 caret_person.setVistaID(iUser.get_vistaID());
					 caret_person.setICN(iUser.get_icn());
					 l("SAVING CARET_PERSON VIA CARETLOCALSERVICEUTIL");
					 CaretLocalServiceUtil.save(caret_person);
				 }
			 }
			 
			 SaveHeaders(liferay_user, iUser.get_headers(),con);
			 
			 //we have to process the roles every single sign-on.  The reason is the roles may change and we have to make sure
			 //any new role is added, and any deprecated role is removed.
			 //for SSOi (internal) this is especially important
			 //for SSOe (external) we won't do much because it's either CareTaker or Veteran.
			 //now handle the roles.
			 if(iUser.get_roles() != null)
			 {
				 //instead of trying to reconcile roles - just blow away all the roles associated with this user and then add the valid ones back
				 //this is actually faster than reconcilign
				 List<Role> liferay_user_roles = liferay_user.getRoles();
				 for(Role liferay_user_role: liferay_user_roles)
				 {
					 if(liferay_user_role.getName().intern() != "Power User")//always leave this
					 {
						 l("REMOVING ROLE " + liferay_user_role.getName() + " FROM USER " + liferay_user.getScreenName());
						 RoleLocalServiceUtil.deleteUserRole(liferay_user.getUserId(), liferay_user_role.getRoleId());
					 }
				 }				 
				 
				 //make sure all the roles provided are associate with the user
				 for(String role : iUser.get_roles())
				 {
					 l("ADDING ROLE " + role + " TO USER " + liferay_user.getScreenName());
					 Role liferay_role = RoleLocalServiceUtil.getRole(COMPANY_ID, role);
					 UserLocalServiceUtil.addRoleUser(liferay_role.getRoleId(), liferay_user);
				 }
				 
				 
			 }else
			 {
				 l("NO ROLES FOUND - CREATING WORK ITEM AND NOTE");
				//create a work item in the Tech queueu
				 long caret_workitem_id = CounterLocalServiceUtil.increment(WorIm.class.getName());
				 WorIm caret_work_item = WorImLocalServiceUtil.createWorIm(caret_workitem_id);
				 caret_work_item.setType("SSO_SIGNON_FAILURE");
				 caret_work_item.setClassId(ClassNameLocalServiceUtil.getClassNameId(User.class));
				 caret_work_item.setClassPk(liferay_user.getUserId());
				 caret_work_item.setStatus("NEW");
				 caret_work_item.setCreationDate(newdate);
				 caret_work_item.setPersnId(caret_person.getPersnId());
				 WorImLocalServiceUtil.addWorIm(caret_work_item);
				 
				 long caret_note_id = CounterLocalServiceUtil.increment(Note.class.getName());
				 Note caret_note = NoteLocalServiceUtil.createNote(caret_note_id);
				 caret_note.setChainId(caret_workitem_id);
				 caret_note.setValue("NO ROLES PROVIDED FOR USER " + liferay_user.getScreenName());
				 caret_note.setCreationDate(newdate);
				 caret_note.setUuid(UUID.randomUUID().toString());
				 NoteLocalServiceUtil.addNote(caret_note);
				 
			 }			 
			 
			 //that's it.  We are done. :)
			
			 l("RETURNING new String[] { " + liferay_user.getUserId() + "," +  liferay_user.getPassword() + "," + liferay_user.isPasswordEncrypted() + "};");
			 return new String[] { String.valueOf(liferay_user.getUserId()),    liferay_user.getPassword(),     String.valueOf(liferay_user.isPasswordEncrypted()) };
			 	
		} catch (Exception e) {
			
			l("ERROR THROWN  : " + e.getMessage());
			e.printStackTrace();
			
		}finally {
			try{ con.close(); }catch(Exception g){}
		}
		

		 return null; //returning null drops the user on the login screen - no way around that.
		
	}

	private HashMap<String,String> getHeadersSSOiTest()
	{
		HashMap<String, String> hdrs = new HashMap<>();

	
		
		//TEST CODE HERE
		
		String uid = "STU" + (System.currentTimeMillis()/1000);
		
		hdrs.put("HTTP_PROOFINGAUTH","VA-PIV");
		hdrs.put("HTTP_ASSURLEVEL","3");
		hdrs.put("HTTP_ADDOMAIN","vhamaster");
		hdrs.put("HTTP_ADSAMACCOUNTNAME",uid);//has to be unique
		hdrs.put("HTTP_ADUPN", uid + "@DOMAIN");//has to be unique
		hdrs.put("HTTP_ADEMAIL", uid + "@DOMAIN");//has to be unique
		hdrs.put("HTTP_VAUID","12345");
		hdrs.put("HTTP_FIRSTNAME","TestSSOi");
		hdrs.put("HTTP_LASTNAME","Smithski");
		hdrs.put("HTTP_SECID","1234567890");
		hdrs.put("HTTP_MVIICN","1012830246V283996");
		hdrs.put("VistAID","TESTVISTAID");
		hdrs.put("HTTP_CORPID","600095357");//<-- dis is the SS
		hdrs.put("HTTP_DODEDIPNID","1234567890");
		hdrs.put("HTTP_ROLE","Role1");
		hdrs.put("HTTP_ORGANIZATION","Department of Veterans Affairs");
		hdrs.put("HTTP_ORGANIZATIONID","urn:oid:2.16.840.1.113883.4.349");	
		

		
		return hdrs;
	}

	private void SaveHeaders(User user, HashMap<String,String>hdrs, Connection con) throws Exception
	{
			l("STORING ALL HEADER VALUES");
			PreparedStatement psmt = con.prepareStatement("INSERT INTO CARET_SSO_ATTR (USERID, HTTP_HEADER,HTTP_VALUE) VALUES (" + user.getUserId() + ",?,?)"); 
			for(Map.Entry<String,String> me: hdrs.entrySet())
			{
				psmt.setString(1, me.getKey());
				
				if(me.getValue() == null)
					psmt.setString(2, "[null value]");
				else
					psmt.setString(2, me.getValue());
				
				psmt.addBatch();
			}
			
			psmt.executeBatch();
	 
	}
	
	private HashMap<String,String> getHeaders(HttpServletRequest request)
	{
		HashMap<String, String> hdrs = new HashMap<>();

		Enumeration<String> headerNames = request.getHeaderNames();
		while (headerNames.hasMoreElements()) {
			String key = (String) headerNames.nextElement();
			String value = request.getHeader(key);
			hdrs.put(key, value);
		}
		
		//hdrs.putAll(getHeadersSSOiTest());
		//hdrs.putAll(getHeadersSSOeTest());
		
		return hdrs;
	}
	
	
	
	
	private HashMap<String,String> getHeadersSSOeTest()
	{
		HashMap<String, String> hdrs = new HashMap<>();
		
		String uid = "SeTU" + (System.currentTimeMillis()/1000);

		
		hdrs.put("va_eauth_csid","");
		hdrs.put("va_eauth_uid","id=" + uid + ",ou=user,o=beneficiaries,dc=osd,dc=mil");
		hdrs.put("va_eauth_hash","");
		hdrs.put("va_eauth_commonname","");
		hdrs.put("va_eauth_assurancelevel","");
		hdrs.put("va_eauth_issueinstant","");
		hdrs.put("va_eauth_emailaddress", uid + "@DOMAIN");
		hdrs.put("va_eauth_firstname","Frankie");
		hdrs.put("va_eauth_middlename","GoesTo");
		hdrs.put("va_eauth_lastname","Hollywood");
		hdrs.put("va_eauth_street","1234 E Elm Street");
		hdrs.put("va_eauth_street1","Apartment G");
		hdrs.put("va_eauth_street2","");
		hdrs.put("va_eauth_street3","");
		hdrs.put("va_eauth_city","San Gabriel");
		hdrs.put("va_eauth_state","CA");
		hdrs.put("va_eauth_country","USA");
		hdrs.put("va_eauth_postalcode","91832");
		hdrs.put("va_eauth_phone","606-222-0423");
		hdrs.put("va_eauth_pnid","555-55-5555");
		hdrs.put("va_eauth_pnidtype","SSN");
		hdrs.put("va_eauth_birthdate_v1","197102161422");
		hdrs.put("va_eauth_dodedipnid","");
		hdrs.put("va_eauth_authenticationmethod",""); 
		hdrs.put("va_eauth_authenticationauthority","");
		hdrs.put("va_eauth_icn","ICN2132112"); 
		hdrs.put("va_eauth_pid",""); 
		hdrs.put("va_eauth_birlsfilenumber","");
		hdrs.put("va_eauth_secid",""); 
		hdrs.put("va_eauth_mhvien","");
		hdrs.put("va_eauth_csponly","");
		hdrs.put("va_eauth_backenddown","");
		hdrs.put("va_eauth_prefix","Miss");
		hdrs.put("va_eauth_suffix",""); 
		hdrs.put("va_eauth_gender","Female"); 
		hdrs.put("va_eauth_hdr_version","");
		hdrs.put("va_eauth_transactionid","");
		hdrs.put("cookie","");
		hdrs.put("va_eauth_authorization","");
		hdrs.put("iv-groups","");
		hdrs.put("iv-user","");
		hdrs.put("va_eauth_sponsordodedipnid",""); 

		
		return hdrs;
	}

	
	private void l(String msg)
	{
		System.out.println("SSOProcessor--->" + msg);
	}
	
}
