package gov.va.caret.service.vetscanner;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.model.Persn;
import gov.va.caret.service.PersnLocalServiceUtil;


public class VetScanner implements MessageListener {

	final long COMPANY_ID = PortalUtil.getDefaultCompanyId();
	public static Log log = LogFactoryUtil.getLog( VetScanner.class );
	
	@Override
	public void receive(Message arg0) throws MessageListenerException {

		/*
		 * get all veterans and put into an array
		 * create new thread worker pool to do e&e searches
		 * when they are done, loop back through and process any with a dod date
		 * 
		 * 
		 */
		log.info("VetScanner--->VETERAN SCANNER BEGIN " + new Date().toString());
		try {

			
			//get all verteran users that are NOT deceased.
			//loop through them doing an EE call for each
			ExecutorService exec = Executors.newFixedThreadPool(15);
			ArrayList<VetScanWorker> alVets = new ArrayList<>();

			String get_vet_sql = "SELECT * FROM CARET_PERSON WHERE PERSNUSERID IN (SELECT USERID FROM USERGROUPROLE WHERE ROLEID = (SELECT ROLEID FROM ROLE_ WHERE NAME = 'Veteran')) AND ICN IS NOT NULL";
			
			
			Connection con = DataAccess.getConnection();
			PreparedStatement get_vets_stmt = con.prepareStatement(get_vet_sql);
			ResultSet rsVeterans = get_vets_stmt.executeQuery();			
			
			//Role liferay_role = RoleLocalServiceUtil.getRole(COMPANY_ID, "Veteran");
			//List<User> lVets = UserLocalServiceUtil.getRoleUsers(liferay_role.getRoleId());

			while(rsVeterans.next())
			{
				Persn caret_person = PersnLocalServiceUtil.getByUser(rsVeterans.getInt("PERSNUSERID"));
	
				log.info("VetScanner--->Veteran (persnid:" + caret_person.getPersnId() + ",userid:" + caret_person.getUserId() + ") queued for processing");
				VetScanWorker vsw = new VetScanWorker(caret_person);
				alVets.add(vsw);
				exec.submit(vsw);
	
			}
			con.close();
			
			exec.shutdown();
			
			try {
				exec.awaitTermination(120, TimeUnit.MINUTES);//give it two hours to finish doing what it is doing
			} catch (InterruptedException e) {
			  
			}
			
			
		} catch (Exception e) {
			
			log.info(e.getMessage());
		}

		log.info("VETERAN SCANNER END " + new Date().toString());

		
	}

	

	public void receiveOld(Message arg0) throws MessageListenerException {

		/*
		 * get all veterans and put into an array
		 * create new thread worker pool to do e&e searches
		 * when they are done, loop back through and process any with a dod date
		 * 
		 * 
		 */
		try {
			
			Connection con = DataAccess.getConnection();
			//-->  research this later --> Connection con = ConnectionPool.this.getConnection();
			
			String get_vet_sql = "SELECT * FROM CARET_PERSON WHERE PERSNUSERID IN (SELECT USERID FROM USERGROUPROLE WHERE ROLEID = (SELECT ROLEID FROM ROLE_ WHERE NAME = 'Veteran')) AND ICN IS NOT NULL";
			
			PreparedStatement get_vets_stmt = con.prepareStatement(get_vet_sql);
			ResultSet rsVeterans = get_vets_stmt.executeQuery();

			System.out.print("PERSNID");
			System.out.print("\t");
			System.out.print("PERSNUSERID");
			System.out.print("\t");
			System.out.print("FIRSTNAME");
			System.out.print("\t");
			System.out.print("MIDDLENAME");
			System.out.print("\t");
			System.out.print("LASTNAME");
			System.out.print("\t");
			System.out.print("DECEASEDDATE");
			System.out.print("\n");
			System.out.print("------");
			System.out.print("\t");
			System.out.print("-----------");
			System.out.print("\t");
			System.out.print("---------");
			System.out.print("\t");
			System.out.print("----------");
			System.out.print("\t");
			System.out.print("--------");
			System.out.print("\t");
			System.out.print("------------");
			System.out.print("\n");
			
			while(rsVeterans.next())
			{
				System.out.print(rsVeterans.getString("PERSNID"));
				System.out.print("\t");
				System.out.print(rsVeterans.getString("PERSNUSERID"));
				System.out.print("\t");
				System.out.print(rsVeterans.getString("FIRSTNAME"));
				System.out.print("\t");
				System.out.print(rsVeterans.getString("MIDDLENAME"));
				System.out.print("\t");
				System.out.print(rsVeterans.getString("LASTNAME"));
				System.out.print("\t");
				System.out.print(rsVeterans.getString("DECEASEDDATE"));
				System.out.print("\n");
			}
	
			con.close();
			
			
		} catch (Exception e) {
			
			log.info(e.getMessage());
		}

		
		
		log.info("The scheduler works!");

		
	}

	
	
	
	
	
	
}
