package gov.va.caret.service.thread;

import java.util.HashMap;
import java.util.Map;


public class Monitor {
	
	private Map<Long,Long> monitor;
	private Monitor(){}
	
	private Map<Long,Long> getMonitorMap(){
		if ( this.monitor == null ){
			this.monitor = new HashMap<Long,Long>();
		}
		return this.monitor;
	}

	private static Monitor _instans;
	private static Monitor getInstance(){
		if ( _instans == null ){
			_instans = new Monitor();
		}
		return _instans;
	}
	
	public static void clear (){
		_instans = new Monitor();
	}
	
	public static long unlock ( Long objectId ){
		synchronized(Monitor.class){
			if ( getInstance().getMonitorMap().containsKey(objectId) ){
				return getInstance().getMonitorMap().remove(objectId);
			}
			return 0;
		}
	}

	public static long lock( long objectId, long def ) {
		synchronized(Monitor.class){
			if ( getInstance().getMonitorMap().containsKey(objectId) ){
				return getInstance().getMonitorMap().get(objectId);
			}
			getInstance().getMonitorMap().put( objectId, def );
			return def;
		}
	}
	
}
