/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Junction;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.model.User;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import gov.va.caret.model.PMDeletedMessage;
import gov.va.caret.model.PMMessage;
import gov.va.caret.model.impl.PMDeletedMessageImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.pm.util.PMUtil;
import gov.va.caret.service.PMDeletedMessageLocalServiceUtil;
import gov.va.caret.service.PMReadMessageLocalServiceUtil;
import gov.va.caret.service.base.PMMessageLocalServiceBaseImpl;
import gov.va.caret.service.persistence.PMDeletedMessageUtil;
import gov.va.caret.service.persistence.PMMessageUtil;
import gov.va.caret.util.CaretStrPool;

/**
 * The implementation of the p m message local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.PMMessageLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.PMMessageLocalServiceBaseImpl
 * @see gov.va.caret.service.PMMessageLocalServiceUtil
 */
public class PMMessageLocalServiceImpl extends PMMessageLocalServiceBaseImpl {

	@Override
	public int getUnreadCount(long userId) throws SystemException {
		int unreadCount = 0;
		for (PMMessage m : getInboxMessages(userId)) {
			if (PMReadMessageLocalServiceUtil.isMessageUnread(m.getMessageId())) {
				unreadCount++;
			}
		}
		return unreadCount;
	}

	@Override
	public List<PMMessage> getInboxMessages(long userId) throws SystemException {
		 
		List<PMMessage> messages = new ArrayList<PMMessage>();
		//List<PMDeletedMessage> deletedMessages = PMDeletedMessageUtil.findByOwnerId(userId);
		//PMDeletedMessageUtil.findWithDynamicQuery(dynamicQuery)
		for (PMMessage m : getPMMessagePersistence().findAll()) {
			try {
				 DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass( PMDeletedMessageImpl.class, PortletClassLoaderUtil.getClassLoader() );
				 dynamicQuery.add(PropertyFactoryUtil.forName(CaretStrPool.MESSAGE_ID).like(m.getMessageId()));
				 dynamicQuery.add( PropertyFactoryUtil.forName(CaretStrPool.OWNER_ID).like(userId) );
				 List<PMDeletedMessage> deletedMessages = PMDeletedMessageUtil.findWithDynamicQuery(dynamicQuery);
					
				if (!deletedMessages.isEmpty()) {
					continue;
				}
				Set<User> users = PMUtil.getRecepientsList(m.getRecepients());
				if (m.getOwnerId() == userId) {
					messages.add(m);
				}
				for (User u : users) {
					if (u.getUserId() == userId) {
						messages.add(m);
						break;
					}
				}
			} catch (Exception e) {
				throw new SystemException(e.getMessage());
			}
		}
		return messages;
	}

	public List<PMMessage> getOutboxMessages(long ownerId) throws SystemException {
		return getPMMessagePersistence().findByOwnerId(ownerId);
	}
	
	public List<PMMessage> getChildMessages(long messageId)
		    throws SystemException {
	    return getPMMessagePersistence().findByParentMessageId(messageId);
	}
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.PMMessageLocalServiceUtil} to access the p m message local service.
	 */
}