package gov.va.caret.service.impl;

import gov.va.caret.service.base.FacilServiceBaseImpl;

/**
 * The implementation of the facil remote service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.FacilService} interface.
 *
 * <p>
 * This is a remote service. Methods of this service are expected to have security checks based on the propagated JAAS credentials because this service can be accessed remotely.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.FacilServiceBaseImpl
 * @see gov.va.caret.service.FacilServiceUtil
 */
public class FacilServiceImpl extends FacilServiceBaseImpl {
    /*
     * NOTE FOR DEVELOPERS:
     *
     * Never reference this interface directly. Always use {@link gov.va.caret.service.FacilServiceUtil} to access the facil remote service.
     */
}
