/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package gov.va.caret.service.impl;

import com.liferay.portal.NoSuchClassNameException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextThreadLocal;
import com.liferay.portal.service.persistence.ClassNameUtil;
import com.liferay.portal.util.PortalUtil;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.AudLg;
import gov.va.caret.model.Docum;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.impl.AudLgImpl;
import gov.va.caret.pdf.FileType;
import gov.va.caret.service.base.DocumLocalServiceBaseImpl;
import gov.va.caret.util.CaretStrPool;

import java.util.Date;
import java.util.List;

/**
 * The implementation of the docum local service.
 *
 * <p>
 * All custom service methods should be put in this class. Whenever methods are added, rerun ServiceBuilder to copy their definitions into the {@link gov.va.caret.service.DocumLocalService} interface.
 *
 * <p>
 * This is a local service. Methods of this service will not have security checks based on the propagated JAAS credentials because this service can only be accessed from within the same VM.
 * </p>
 *
 * @author caret
 * @see gov.va.caret.service.base.DocumLocalServiceBaseImpl
 * @see gov.va.caret.service.DocumLocalServiceUtil
 */
public class DocumLocalServiceImpl extends DocumLocalServiceBaseImpl {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this interface directly. Always use {@link gov.va.caret.service.DocumLocalServiceUtil} to access the docum local service.
	 */
	
	public List<Docum> getByClass ( long primaryKey, long classId, String type ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByType(primaryKey, classId, type, false);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public List<Docum> getByPrimaryKey ( long primaryKey ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByClassPk( primaryKey, false );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}

	public List<Docum> getByPrimaryKey ( long primaryKey, boolean deleted ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByClassPk( primaryKey, deleted );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public int getByPrimaryKeyCount ( long primaryKey ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.countByClassPk( primaryKey, false );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	
	public Docum addDocum(Docum document) {
		
		try {
			super.addDocum(document);
		
			ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
			if ( sc == null ){
				sc = new ServiceContext();
			}
	
			Object userIdObj = sc.getAttribute( CaretStrPool.USER_ID );
			long userId = userIdObj == null? sc.getUserId(): (Long) userIdObj;
			
			Object coverUserIdObj = sc.getAttribute( CaretStrPool.REAL_USER_ID );
			long coverUserId = coverUserIdObj == null? userId : (Long)coverUserIdObj;
			
			String roleName = String.valueOf( sc.getAttribute( CaretStrPool.DASHBOARD_ROLE_NAME ) );
			Date modifiedDate = sc.getCreateDate() == null? new Date(): sc.getCreateDate();
			
			AudLg audit = new AudLgImpl();
			try {
				audit.setClassId( ClassNameUtil.findByValue( Docum.class.getName() ).getPrimaryKey() );
			} catch (NoSuchClassNameException e){
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
			audit.setClassPk(document.getDocumId());
			audit.setAttribute("Document");
			audit.setModifiedById(sc.getUserId());
			audit.setCoverUserId (coverUserId);
			audit.setModifiedDate(modifiedDate);
			audit.setSysDateTime(modifiedDate.getTime());
			audit.setOldValue("N/A");
			audit.setNewValue("UPLOADED");
			audit.setGroupId (0);
			audit.setRoleName (roleName);
			
			audit = audLgPersistence.update(audit);

		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		return document;
	}
	
	public boolean deleteDocument ( Docum document ) throws ApplicationWorkFlowException {
		
		ServiceContext sc = ServiceContextThreadLocal.getServiceContext();
		if ( sc == null ){
			sc = new ServiceContext();
		}

		Object userIdObj = sc.getAttribute( CaretStrPool.USER_ID );
		long userId = userIdObj == null? sc.getUserId(): (Long) userIdObj;
		
		Object coverUserIdObj = sc.getAttribute( CaretStrPool.REAL_USER_ID );
		long coverUserId = coverUserIdObj == null? userId : (Long)coverUserIdObj;
		
		String roleName = String.valueOf( sc.getAttribute( CaretStrPool.DASHBOARD_ROLE_NAME ) );
		Date modifiedDate = sc.getCreateDate() == null? new Date(): sc.getCreateDate();
		
		AudLg audit = new AudLgImpl();
		try {
			audit.setClassId( ClassNameUtil.findByValue( Docum.class.getName() ).getPrimaryKey() );
		} catch (NoSuchClassNameException e){
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		audit.setClassPk( document.getDocumId() );
		audit.setAttribute( "Document" );
		audit.setModifiedById( sc.getUserId() );
		audit.setCoverUserId ( coverUserId );
		audit.setModifiedDate( modifiedDate );
		audit.setSysDateTime( modifiedDate.getTime() );
		audit.setOldValue( document.getName() );
		audit.setNewValue( "DELETED" );
		audit.setGroupId ( 0 );
		audit.setRoleName ( roleName );
		try {
			document.setDeleted(true);
			documPersistence.update(document);
			audit = audLgPersistence.update( audit );
			return true;
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return false;
	}
	
	public List<Docum> findByVcgAnId(long[] vcgAnIds) throws ApplicationWorkFlowException {
		try {
			return documPersistence.findByVcgAnId(vcgAnIds);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}
	
	public Docum getAppByOwnerId ( long ownerId ) throws ApplicationWorkFlowException {
		try {
			return documPersistence.fetchByType_First( ownerId, PortalUtil.getClassNameId(VcgAn.class), FileType.TEN_TEN_CG.name(), false, null);
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException(e);
		}
	}

}