/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.caret.service.ctssh.request;

import java.util.HashMap;

import gov.va.caret.service.ctssh.response.ResponseProperty;
import gov.va.caret.service.ctssh.response.SimpleResponse;
import gov.va.caret.service.ctssh.template.ChainStep;
import gov.va.caret.service.ctssh.template.ChainedTemplate;
import gov.va.caret.service.ctssh.util.AppHelper;


/**
 *
 * @author ronaday
 */
public class ChainedRequest extends Request {

    //a chained request is simply a set of sequential calls - all driven off the template
  
    /**
     * 
     */
    SimpleRequest[] _requests;
    /**
     * 
     */
    private HashMap<String, String> parameters;
    
    /**
     * 
     */
    ChainedTemplate template;
    /**
     * @param ikey
     * @throws Exception
     */
    public ChainedRequest(String ikey) throws Exception
    {
        super(ikey);
        template = (ChainedTemplate)super.template();
        
        _requests = new SimpleRequest[template.call_steps().length];
        int k = 0;
        for(ChainStep step: template.call_steps())
        {
        	_requests[k] = (SimpleRequest) RequestFactory.createRequest(step.template_id());
        	k++;
        }
    }	

      /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.request.Request#toString()
     */
    @Override
    public String toString()
    {
        return super.toString() + ":CHAIN";
    }        
        
    /* (non-Javadoc)
     * @see gov.va.caret.service.ctssh.request.Request#template()
     */
    @Override
	public ChainedTemplate template()
    {
        return template;
    }
    
    /**
     * @return
     */
    public SimpleRequest[] requests()
    {
        return _requests;
    }
    
    /**
     * @return
     */
    public HashMap<String,String> getParameters()
    {
    	return parameters;
    	
    	
    }

	/**
	 * @param name
	 * @return
	 */
	public String getParameter(String name)
	{
            return parameters.get(name);
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, java.lang.String)
	 */
	@Override
	public void setParameter(String name, String value) throws Exception
	{
            if(parameters == null)
                parameters = new HashMap<>();
            
            if(template.isParameter(name.toLowerCase()))
            {
            	parameters.put(name.toLowerCase(), value);
                AppHelper.log("Parameter " + name.toLowerCase() + " set to " + value);
            }
            else
                throw new Exception("Invalid parameter \"" + name + "\" for template " + template.key());
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, int)
	 */
	@Override
	public void setParameter(String name, int value) throws Exception
	{
            setParameter(name, String.valueOf(value));
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, long)
	 */
	@Override
	public void setParameter(String name, long value) throws Exception
	{
            setParameter(name, String.valueOf(value));
	}
	
	/* (non-Javadoc)
	 * @see gov.va.caret.service.ctssh.request.Request#setParameter(java.lang.String, double)
	 */
	@Override
	public void setParameter(String name, double value) throws Exception
	{
            setParameter(name, String.valueOf(value));
	}

	/**
	 * @param _sresponse
	 */
	public void forwardParameters(SimpleResponse _sresponse) {
		
		//take all the parameters off the response and add them to the parameters for the chained request.
		//this will make them accessable to all subsequent requests
		
		for(ResponseProperty rp: _sresponse.response_properties().values())
		{
			parameters.put(rp.name(),rp.value());
		}
		
		
	}
            
    
    
    
    
    
    
    
    
    
    
    
    
}
